/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ShareAcknowledgeResponse;
import org.apache.kafka.common.requests.ShareRequestMetadata;

public class ShareAcknowledgeRequest
extends AbstractRequest {
    private final ShareAcknowledgeRequestData data;

    public ShareAcknowledgeRequest(ShareAcknowledgeRequestData data, short version) {
        super(ApiKeys.SHARE_ACKNOWLEDGE, version);
        this.data = data;
    }

    @Override
    public ShareAcknowledgeRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return new ShareAcknowledgeResponse(new ShareAcknowledgeResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()));
    }

    public static ShareAcknowledgeRequest parse(Readable readable, short version) {
        return new ShareAcknowledgeRequest(new ShareAcknowledgeRequestData(readable, version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ShareAcknowledgeRequest> {
        private final ShareAcknowledgeRequestData data;

        public Builder(ShareAcknowledgeRequestData data) {
            super(ApiKeys.SHARE_ACKNOWLEDGE);
            this.data = data;
        }

        public static Builder forConsumer(String groupId, ShareRequestMetadata metadata, Map<TopicIdPartition, List<ShareAcknowledgeRequestData.AcknowledgementBatch>> acknowledgementsMap) {
            ShareAcknowledgeRequestData data = new ShareAcknowledgeRequestData();
            data.setGroupId(groupId);
            if (metadata != null) {
                data.setMemberId(metadata.memberId().toString());
                data.setShareSessionEpoch(metadata.epoch());
            }
            ShareAcknowledgeRequestData.AcknowledgeTopicCollection ackTopics = new ShareAcknowledgeRequestData.AcknowledgeTopicCollection();
            for (Map.Entry<TopicIdPartition, List<ShareAcknowledgeRequestData.AcknowledgementBatch>> acknowledgeEntry : acknowledgementsMap.entrySet()) {
                ShareAcknowledgeRequestData.AcknowledgePartition ackPartition;
                TopicIdPartition tip = acknowledgeEntry.getKey();
                ShareAcknowledgeRequestData.AcknowledgeTopic ackTopic = ackTopics.find(tip.topicId());
                if (ackTopic == null) {
                    ackTopic = new ShareAcknowledgeRequestData.AcknowledgeTopic().setTopicId(tip.topicId()).setPartitions(new ShareAcknowledgeRequestData.AcknowledgePartitionCollection());
                    ackTopics.add(ackTopic);
                }
                if ((ackPartition = ackTopic.partitions().find(tip.partition())) == null) {
                    ackPartition = new ShareAcknowledgeRequestData.AcknowledgePartition().setPartitionIndex(tip.partition());
                    ackTopic.partitions().add(ackPartition);
                }
                ackPartition.setAcknowledgementBatches(acknowledgeEntry.getValue());
            }
            data.setTopics(ackTopics);
            return new Builder(data);
        }

        public ShareAcknowledgeRequestData data() {
            return this.data;
        }

        @Override
        public ShareAcknowledgeRequest build(short version) {
            return new ShareAcknowledgeRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

