/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.Error;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.keyword.KeywordFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisallowUnknownKeywordFactory
implements KeywordFactory {
    private static final Logger logger = LoggerFactory.getLogger(DisallowUnknownKeywordFactory.class);

    @Override
    public Keyword getKeyword(String value, SchemaContext schemaContext) {
        logger.error("Keyword '{}' is unknown and must be configured on the meta-schema or vocabulary", (Object)value);
        throw new InvalidSchemaException(((Error.Builder)((Error.Builder)Error.builder().message("Keyword ''{0}'' is unknown and must be configured on the meta-schema or vocabulary")).arguments(value)).build());
    }

    public static DisallowUnknownKeywordFactory getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final DisallowUnknownKeywordFactory INSTANCE = new DisallowUnknownKeywordFactory();

        private Holder() {
        }
    }
}

