/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.operation.relateng.BasicPredicate;
import org.locationtech.jts.operation.relateng.IMPatternMatcher;
import org.locationtech.jts.operation.relateng.IMPredicate;
import org.locationtech.jts.operation.relateng.TopologyPredicate;

public interface RelatePredicate {
    public static TopologyPredicate intersects() {
        return new BasicPredicate(){

            @Override
            public String name() {
                return "intersects";
            }

            @Override
            public boolean requireSelfNoding() {
                return false;
            }

            @Override
            public boolean requireExteriorCheck(boolean isSourceA) {
                return false;
            }

            @Override
            public void init(Envelope envA, Envelope envB) {
                this.require(envA.intersects(envB));
            }

            @Override
            public void updateDimension(int locA, int locB, int dimension) {
                this.setValueIf(true, 1.isIntersection(locA, locB));
            }

            @Override
            public void finish() {
                this.setValue(false);
            }
        };
    }

    public static TopologyPredicate disjoint() {
        return new BasicPredicate(){

            @Override
            public String name() {
                return "disjoint";
            }

            @Override
            public boolean requireSelfNoding() {
                return false;
            }

            @Override
            public boolean requireInteraction() {
                return false;
            }

            @Override
            public boolean requireExteriorCheck(boolean isSourceA) {
                return false;
            }

            @Override
            public void init(Envelope envA, Envelope envB) {
                this.setValueIf(true, envA.disjoint(envB));
            }

            @Override
            public void updateDimension(int locA, int locB, int dimension) {
                this.setValueIf(false, 2.isIntersection(locA, locB));
            }

            @Override
            public void finish() {
                this.setValue(true);
            }
        };
    }

    public static TopologyPredicate contains() {
        return new IMPredicate(){

            @Override
            public String name() {
                return "contains";
            }

            @Override
            public boolean requireCovers(boolean isSourceA) {
                return isSourceA;
            }

            @Override
            public boolean requireExteriorCheck(boolean isSourceA) {
                return !isSourceA;
            }

            @Override
            public void init(int dimA, int dimB) {
                super.init(dimA, dimB);
                this.require(3.isDimsCompatibleWithCovers(dimA, dimB));
            }

            @Override
            public void init(Envelope envA, Envelope envB) {
                this.requireCovers(envA, envB);
            }

            @Override
            public boolean isDetermined() {
                return this.intersectsExteriorOf(true);
            }

            @Override
            public boolean valueIM() {
                return this.intMatrix.isContains();
            }
        };
    }

    public static TopologyPredicate within() {
        return new IMPredicate(){

            @Override
            public String name() {
                return "within";
            }

            @Override
            public boolean requireCovers(boolean isSourceA) {
                return !isSourceA;
            }

            @Override
            public boolean requireExteriorCheck(boolean isSourceA) {
                return isSourceA;
            }

            @Override
            public void init(int dimA, int dimB) {
                super.init(dimA, dimB);
                this.require(4.isDimsCompatibleWithCovers(dimB, dimA));
            }

            @Override
            public void init(Envelope envA, Envelope envB) {
                this.requireCovers(envB, envA);
            }

            @Override
            public boolean isDetermined() {
                return this.intersectsExteriorOf(false);
            }

            @Override
            public boolean valueIM() {
                return this.intMatrix.isWithin();
            }
        };
    }

    public static TopologyPredicate covers() {
        return new IMPredicate(){

            @Override
            public String name() {
                return "covers";
            }

            @Override
            public boolean requireCovers(boolean isSourceA) {
                return isSourceA;
            }

            @Override
            public boolean requireExteriorCheck(boolean isSourceA) {
                return !isSourceA;
            }

            @Override
            public void init(int dimA, int dimB) {
                super.init(dimA, dimB);
                this.require(5.isDimsCompatibleWithCovers(dimA, dimB));
            }

            @Override
            public void init(Envelope envA, Envelope envB) {
                this.requireCovers(envA, envB);
            }

            @Override
            public boolean isDetermined() {
                return this.intersectsExteriorOf(true);
            }

            @Override
            public boolean valueIM() {
                return this.intMatrix.isCovers();
            }
        };
    }

    public static TopologyPredicate coveredBy() {
        return new IMPredicate(){

            @Override
            public String name() {
                return "coveredBy";
            }

            @Override
            public boolean requireCovers(boolean isSourceA) {
                return !isSourceA;
            }

            @Override
            public boolean requireExteriorCheck(boolean isSourceA) {
                return isSourceA;
            }

            @Override
            public void init(int dimA, int dimB) {
                super.init(dimA, dimB);
                this.require(6.isDimsCompatibleWithCovers(dimB, dimA));
            }

            @Override
            public void init(Envelope envA, Envelope envB) {
                this.requireCovers(envB, envA);
            }

            @Override
            public boolean isDetermined() {
                return this.intersectsExteriorOf(false);
            }

            @Override
            public boolean valueIM() {
                return this.intMatrix.isCoveredBy();
            }
        };
    }

    public static TopologyPredicate crosses() {
        return new IMPredicate(){

            @Override
            public String name() {
                return "crosses";
            }

            @Override
            public void init(int dimA, int dimB) {
                super.init(dimA, dimB);
                boolean isBothPointsOrAreas = dimA == 0 && dimB == 0 || dimA == 2 && dimB == 2;
                this.require(!isBothPointsOrAreas);
            }

            @Override
            public boolean isDetermined() {
                return this.dimA == 1 && this.dimB == 1 ? this.getDimension(0, 0) > 0 : (this.dimA < this.dimB ? this.isIntersects(0, 0) && this.isIntersects(0, 2) : this.dimA > this.dimB && this.isIntersects(0, 0) && this.isIntersects(2, 0));
            }

            @Override
            public boolean valueIM() {
                return this.intMatrix.isCrosses(this.dimA, this.dimB);
            }
        };
    }

    public static TopologyPredicate equalsTopo() {
        return new IMPredicate(){

            @Override
            public String name() {
                return "equals";
            }

            @Override
            public void init(int dimA, int dimB) {
                super.init(dimA, dimB);
                this.require(dimA == dimB);
            }

            @Override
            public void init(Envelope envA, Envelope envB) {
                this.require(envA.equals(envB));
            }

            @Override
            public boolean isDetermined() {
                boolean isEitherExteriorIntersects = this.isIntersects(0, 2) || this.isIntersects(1, 2) || this.isIntersects(2, 0) || this.isIntersects(2, 1);
                return isEitherExteriorIntersects;
            }

            @Override
            public boolean valueIM() {
                return this.intMatrix.isEquals(this.dimA, this.dimB);
            }
        };
    }

    public static TopologyPredicate overlaps() {
        return new IMPredicate(){

            @Override
            public String name() {
                return "overlaps";
            }

            @Override
            public void init(int dimA, int dimB) {
                super.init(dimA, dimB);
                this.require(dimA == dimB);
            }

            @Override
            public boolean isDetermined() {
                if ((this.dimA == 2 || this.dimA == 0) && this.isIntersects(0, 0) && this.isIntersects(0, 2) && this.isIntersects(2, 0)) {
                    return true;
                }
                return this.dimA == 1 && this.isDimension(0, 0, 1) && this.isIntersects(0, 2) && this.isIntersects(2, 0);
            }

            @Override
            public boolean valueIM() {
                return this.intMatrix.isOverlaps(this.dimA, this.dimB);
            }
        };
    }

    public static TopologyPredicate touches() {
        return new IMPredicate(){

            @Override
            public String name() {
                return "touches";
            }

            @Override
            public void init(int dimA, int dimB) {
                super.init(dimA, dimB);
                boolean isBothPoints = dimA == 0 && dimB == 0;
                this.require(!isBothPoints);
            }

            @Override
            public boolean isDetermined() {
                boolean isInteriorsIntersects = this.isIntersects(0, 0);
                return isInteriorsIntersects;
            }

            @Override
            public boolean valueIM() {
                return this.intMatrix.isTouches(this.dimA, this.dimB);
            }
        };
    }

    public static TopologyPredicate matches(String imPattern) {
        return new IMPatternMatcher(imPattern);
    }
}

