/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;

public class BwsProtocolEncoder
extends BaseProtocolEncoder {
    public BwsProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(long deviceId, int value) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(0);
        buf.writeBytes(DataConverter.parseHex(this.getUniqueId(deviceId).substring(0, 8)));
        buf.writeByte(66);
        buf.writeByte(0);
        buf.writeByte(value);
        buf.writeByte(Checksum.crc8(Checksum.CRC8_DALLAS, buf.nioBuffer()));
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        return switch (command.getType()) {
            case "engineStop" -> this.encodeContent(command.getDeviceId(), 0);
            case "engineResume" -> this.encodeContent(command.getDeviceId(), 1);
            default -> null;
        };
    }
}

