/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jexl3.internal.introspection.Permissions;

public class PermissionsParser {
    private String src;
    private int size;
    private Map<String, Permissions.NoJexlPackage> packages;
    private Set<String> wildcards;

    private void clear() {
        this.src = null;
        this.size = 0;
        this.packages = null;
        this.wildcards = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Permissions parse(Set<String> wildcards, Map<String, Permissions.NoJexlPackage> packages, String ... srcs) {
        try {
            if (srcs == null || srcs.length == 0) {
                Permissions permissions = Permissions.UNRESTRICTED;
                return permissions;
            }
            this.packages = packages;
            this.wildcards = wildcards;
            Object object = srcs;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String source;
                this.src = source = object[i];
                this.size = source.length();
                this.readPackages();
            }
            object = new Permissions(wildcards, packages);
            return object;
        }
        finally {
            this.clear();
        }
    }

    public Permissions parse(String ... srcs) {
        return this.parse(new LinkedHashSet<String>(), new ConcurrentHashMap<String, Permissions.NoJexlPackage>(), srcs);
    }

    private int readClass(Permissions.NoJexlPackage njpackage, boolean nojexl, String outer, String inner, int offset) {
        StringBuilder temp = new StringBuilder();
        Permissions.NoJexlClass njclass = null;
        String njname = null;
        String identifier = inner;
        boolean deny = nojexl;
        int i = offset;
        int j = -1;
        boolean isMethod = false;
        while (i < this.size) {
            char c = this.src.charAt(i);
            if (j >= i) {
                throw new IllegalStateException(this.unexpected(c, i));
            }
            j = i++;
            if (Character.isWhitespace(c)) {
                i = this.readSpaces(i + 1);
                continue;
            }
            if (c == '#') {
                i = this.readEol(i + 1);
                continue;
            }
            if (njclass != null && c == '}') break;
            if (identifier == null) {
                if (c == '-') {
                    ++i;
                } else if (c == '+') {
                    deny = false;
                    ++i;
                }
                int next = this.readIdentifier(temp, i);
                if (i != next) {
                    identifier = temp.toString();
                    temp.setLength(0);
                    i = next;
                    continue;
                }
            }
            if (njclass == null) {
                if (identifier == null || c != '{') {
                    throw new IllegalStateException(this.unexpected(c, i));
                }
                njclass = deny ? new Permissions.NoJexlClass() : new Permissions.JexlClass();
                njname = outer != null ? outer + "$" + identifier : identifier;
                njpackage.addNoJexl(njname, njclass);
                identifier = null;
            } else if (identifier != null) {
                if (c == '{') {
                    i = this.readClass(njpackage, deny, njname, identifier, i - 1);
                    identifier = null;
                    continue;
                }
                if (c == ';') {
                    if (isMethod) {
                        njclass.methodNames.add(identifier);
                        isMethod = false;
                    } else {
                        njclass.fieldNames.add(identifier);
                    }
                    identifier = null;
                } else if (c == '(' && !isMethod) {
                    isMethod = true;
                } else if (c != ')' || this.src.charAt(i - 1) != '(') {
                    throw new IllegalStateException(this.unexpected(c, i));
                }
            }
            ++i;
        }
        if (njname != null && njclass.isEmpty()) {
            njpackage.addNoJexl(njname, njclass instanceof Permissions.JexlClass ? Permissions.JEXL_CLASS : Permissions.NOJEXL_CLASS);
        }
        return i;
    }

    private int readEol(int offset) {
        char c;
        int i;
        for (i = offset; i < this.size && (c = this.src.charAt(i)) != '\n'; ++i) {
        }
        return i;
    }

    private int readIdentifier(StringBuilder id, int offset) {
        return this.readIdentifier(id, offset, false, false);
    }

    private int readIdentifier(StringBuilder id, int offset, boolean dot, boolean star) {
        int i;
        int begin = -1;
        boolean starf = star;
        char c = '\u0000';
        for (i = offset; i < this.size; ++i) {
            c = this.src.charAt(i);
            if (Character.isJavaIdentifierStart(c) && begin < 0) {
                begin = i;
                id.append(c);
                continue;
            }
            if (Character.isJavaIdentifierPart(c) && begin >= 0) {
                id.append(c);
                continue;
            }
            if (dot && c == '.') {
                if (this.src.charAt(i - 1) == '.') {
                    throw new IllegalStateException(this.unexpected(c, i));
                }
                id.append('.');
                begin = -1;
                continue;
            }
            if (!starf || c != '*') break;
            id.append('*');
            starf = false;
        }
        if (dot && c == '.') {
            throw new IllegalStateException(this.unexpected(c, i));
        }
        return i;
    }

    private void readPackages() {
        StringBuilder temp = new StringBuilder();
        Permissions.NoJexlPackage njpackage = null;
        int i = 0;
        int j = -1;
        String pname = null;
        while (i < this.size) {
            int next;
            char c = this.src.charAt(i);
            if (j >= i) {
                throw new IllegalStateException(this.unexpected(c, i));
            }
            j = i;
            if (Character.isWhitespace(c)) {
                i = this.readSpaces(i + 1);
                continue;
            }
            if (c == '#') {
                i = this.readEol(i + 1);
                continue;
            }
            if (pname == null && i != (next = this.readIdentifier(temp, i, true, true))) {
                pname = temp.toString();
                temp.setLength(0);
                i = next;
                if (!pname.endsWith(".*")) continue;
                this.wildcards.add(pname);
                pname = null;
                continue;
            }
            if (njpackage == null) {
                if (c != '{') continue;
                njpackage = this.packages.compute(pname, (n, p) -> new Permissions.NoJexlPackage(p == null ? null : p.nojexl));
                ++i;
                continue;
            }
            if (c == '}') {
                if (njpackage.isEmpty()) {
                    this.packages.put(pname, Permissions.NOJEXL_PACKAGE);
                }
                njpackage = null;
                pname = null;
                ++i;
                continue;
            }
            i = this.readClass(njpackage, true, null, null, i);
        }
    }

    private int readSpaces(int offset) {
        char c;
        for (int i = offset; i < this.size && Character.isWhitespace(c = this.src.charAt(i)); ++i) {
        }
        return offset;
    }

    private String unexpected(char c, int i) {
        return "unexpected '" + c + "'@" + i;
    }
}

