/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.transfermanager.TransferStatus;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DownloadResult {
    static final Comparator<DownloadResult> COMPARATOR = Comparator.comparingInt(dr -> dr.getStatus().ordinal());
    private final @NonNull BlobInfo input;
    private final @MonotonicNonNull Path outputDestination;
    private final @NonNull TransferStatus status;
    private final @MonotonicNonNull Exception exception;

    private DownloadResult(@NonNull BlobInfo input, Path outputDestination, @NonNull TransferStatus status, Exception exception) {
        this.input = input;
        this.outputDestination = outputDestination;
        this.status = status;
        this.exception = exception;
    }

    public @NonNull BlobInfo getInput() {
        return this.input;
    }

    public @NonNull Path getOutputDestination() {
        Preconditions.checkState((this.status == TransferStatus.SUCCESS ? 1 : 0) != 0, (String)"getOutputDestination() is only valid when status is SUCCESS but status was %s", (Object)((Object)this.status));
        return this.outputDestination;
    }

    public @NonNull TransferStatus getStatus() {
        return this.status;
    }

    public @NonNull Exception getException() {
        Preconditions.checkState((this.status == TransferStatus.FAILED_TO_FINISH || this.status == TransferStatus.FAILED_TO_START ? 1 : 0) != 0, (String)"getException() is only valid when an unexpected error has occurred but status was %s", (Object)((Object)this.status));
        return this.exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadResult that = (DownloadResult)o;
        return this.input.equals(that.input) && this.outputDestination.equals(that.outputDestination) && this.status == that.status && this.exception.equals(that.exception);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.input, this.outputDestination, this.status, this.exception});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("input", (Object)this.input).add("outputDestination", (Object)this.outputDestination).add("status", (Object)this.status).add("exception", (Object)this.exception).toString();
    }

    public static Builder newBuilder(@NonNull BlobInfo blobInfo, @NonNull TransferStatus status) {
        return new Builder(blobInfo, status);
    }

    public static final class Builder {
        private @NonNull BlobInfo input;
        private @MonotonicNonNull Path outputDestination;
        private @NonNull TransferStatus status;
        private @MonotonicNonNull Exception exception;

        private Builder(@NonNull BlobInfo input, @NonNull TransferStatus status) {
            this.input = input;
            this.status = status;
        }

        public Builder setInput(@NonNull BlobInfo input) {
            this.input = input;
            return this;
        }

        public Builder setOutputDestination(@NonNull Path outputDestination) {
            this.outputDestination = outputDestination;
            return this;
        }

        public Builder setStatus(@NonNull TransferStatus status) {
            this.status = status;
            return this;
        }

        public Builder setException(@NonNull Exception exception) {
            this.exception = exception;
            return this;
        }

        public DownloadResult build() {
            Preconditions.checkNotNull((Object)this.input);
            Preconditions.checkNotNull((Object)((Object)this.status));
            if (this.status == TransferStatus.SUCCESS) {
                Preconditions.checkNotNull((Object)this.outputDestination);
            } else if (this.status == TransferStatus.FAILED_TO_START || this.status == TransferStatus.FAILED_TO_FINISH) {
                Preconditions.checkNotNull((Object)this.exception);
            }
            return new DownloadResult(this.input, this.outputDestination, this.status, this.exception);
        }
    }
}

