/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class ActionsTree
extends BeanTreeView
implements DragGestureListener,
DragSourceListener {
    private Cursor dragMoveCursor = DragSource.DefaultMoveDrop;
    private Cursor dragNoDropCursor = DragSource.DefaultMoveNoDrop;

    public ActionsTree() {
        this.setRootVisible(false);
        this.tree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.tree.setShowsRootHandles(true);
        this.setDragSource(false);
        this.setDropTarget(false);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.tree, 2, this);
        this.setQuickSearchAllowed(true);
        this.setSelectionMode(1);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreePath treePath = this.tree.getPathForLocation(dragGestureEvent.getDragOrigin().x, dragGestureEvent.getDragOrigin().y);
        if (null != treePath) {
            Object object = treePath.getLastPathComponent();
            if (this.tree.getModel().isLeaf(object)) {
                try {
                    Node node = Visualizer.findNode((Object)object);
                    Transferable transferable = node.drag();
                    dragGestureEvent.getDragSource().addDragSourceListener(this);
                    dragGestureEvent.startDrag(this.dragNoDropCursor, transferable);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    Logger.getLogger(ActionsTree.class.getName()).log(Level.INFO, invalidDnDOperationException.getMessage(), invalidDnDOperationException);
                }
                catch (IOException iOException) {
                    Logger.getLogger(ActionsTree.class.getName()).log(Level.WARNING, null, iOException);
                }
            }
        }
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(this.dragNoDropCursor);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        int n = dragSourceDragEvent.getDropAction();
        if ((n & 2) != 0) {
            dragSourceContext.setCursor(this.dragMoveCursor);
        } else {
            dragSourceContext.setCursor(this.dragNoDropCursor);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.dragOver(dragSourceDragEvent);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }
}

