# General options:
complete -c pg_restore -s d -l dbname -x -a '(__fish_complete_pg_database)' -d "Connect to database name"
complete -c pg_restore -s f -l file -a - -r -d "Output file name (- for stdout)"
complete -c pg_restore -s F -l format -x -a "c\t'Custom format (pg_dump)' d\t'Directory archive' t\t'Tar archive'" -d "Backup file format (should be automatic)"
complete -c pg_restore -s l -l list -d "Print summarized TOC of the archive"
complete -c pg_restore -s v -l verbose -d "Verbose mode"
complete -c pg_restore -s V -l version -d "Output version information"
complete -c pg_restore -s '?' -l help -d "Show help"

# Options controlling the restore:
complete -c pg_restore -s a -l data-only -d "Restore only the data, no schema"
complete -c pg_restore -s c -l clean -d "Clean (drop) database objects before recreating"
complete -c pg_restore -s C -l create -d "Create the target database"
complete -c pg_restore -s e -l exit-on-error -d "Exit on error, default is to continue"
complete -c pg_restore -s I -l index -x -d "Restore named index"
complete -c pg_restore -s j -l jobs -x -d "Number of parallel jobs to restore"
complete -c pg_restore -s L -l use-list -r -d "Use table of contents from this file"
complete -c pg_restore -s n -l schema -x -d "Restore only objects in this schema"
complete -c pg_restore -s N -l exclude-schema -x -d "Do not restore objects in this schema"
complete -c pg_restore -s O -l no-owner -d "Skip restoration of object ownership"
complete -c pg_restore -s P -l function -x -d "Restore named function"
complete -c pg_restore -s s -l schema-only -d "Restore only the schema, no data"
complete -c pg_restore -s S -l superuser -x -a '(__fish_complete_pg_user)' -d "Superuser user name to use for disabling triggers"
complete -c pg_restore -s t -l table -x -d "Restore named relation (table, view, etc.)"
complete -c pg_restore -s T -l trigger -x -d "Restore named trigger"
complete -c pg_restore -s x -l no-privileges -d "Skip restoration of access privileges (grant/revoke)"
complete -c pg_restore -s 1 -l single-transaction -d "Restore as a single transaction"
complete -c pg_restore -l disable-triggers -d "Disable triggers during data-only restore"
complete -c pg_restore -l enable-row-security -d "Enable row security"
complete -c pg_restore -l if-exists -d "Use IF EXISTS when dropping objects"
complete -c pg_restore -l no-comments -d "Do not restore comments"
complete -c pg_restore -l no-data-for-failed-tables -d "Don't restore data of tables that could not be created"
complete -c pg_restore -l no-publications -d "Do not restore publications"
complete -c pg_restore -l no-security-labels -d "Do not restore security labels"
complete -c pg_restore -l no-subscriptions -d "Do not restore subscriptions"
complete -c pg_restore -l no-tablespaces -d "Do not restore tablespace assignments"
complete -c pg_restore -l section -x -d "Restore named section (pre-data, data, or post-data)"
complete -c pg_restore -l strict-names -d "Require table/schema include patterns to match entities"
complete -c pg_restore -l use-set-session-authorization -d "Use SET SESSION AUTHORIZATION instead of ALTER OWNER"

# Connection options:
complete -c pg_restore -s h -l host -x -a '(__fish_print_hostnames)' -d "Database server host or socket directory"
complete -c pg_restore -s p -l port -x -d "Database server port number"
complete -c pg_restore -s U -l username -x -a '(__fish_complete_pg_user)' -d "Connect as specified database user"
complete -c pg_restore -s w -l no-password -d "Never prompt for password"
complete -c pg_restore -s W -l password -d "Force password prompt (should happen automatically)"
complete -c pg_restore -l role -x -d "Do SET ROLE before restore"
