/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLUtils;
import io.mola.galimatias.canonicalize.URLCanonicalizer;

public class DecodeUnreservedCanonicalizer
implements URLCanonicalizer {
    @Override
    public URL canonicalize(URL input) throws GalimatiasParseException {
        if (input == null) {
            return input;
        }
        URL output = input;
        if (output.isHierarchical()) {
            output = output.withUsername(this.decodeUnreserved(output.username())).withPassword(this.decodeUnreserved(output.password())).withPath(this.decodeUnreserved(output.path()));
        }
        return output.withQuery(this.decodeUnreserved(output.query())).withFragment(this.decodeUnreserved(output.fragment()));
    }

    private String decodeUnreserved(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '%' && input.length() > i + 2 && URLUtils.isASCIIHexDigit(input.charAt(i + 1)) && URLUtils.isASCIIHexDigit(input.charAt(i + 2))) {
                int d = URLUtils.hexToInt(input.charAt(i + 1), input.charAt(i + 2));
                if (URLUtils.isASCIIAlphanumeric(d) || d == 45 || d == 46 || d == 95 || d == 126) {
                    output.appendCodePoint(d);
                } else {
                    output.append(input.substring(i, i + 3));
                }
                i += 2;
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }
}

