/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.CodeBlockGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StatementWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public final class SwitchStatementGenerator {
    private SwitchStatementGenerator() {
    }

    public static void generate(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrSwitchStatement switchStatement) {
        PsiType type;
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(1);
        }
        if (switchStatement == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(2);
        }
        GrExpression condition = switchStatement.getCondition();
        GrCaseSection[] caseSections = switchStatement.getCaseSections();
        PsiType psiType = type = condition == null ? null : TypesUtil.unboxPrimitiveTypeWrapper(condition.getType());
        if (type == null || SwitchStatementGenerator.isValidTypeForSwitchSelector(type)) {
            SwitchStatementGenerator.generateSwitch(builder, context, condition, caseSections);
        } else {
            SwitchStatementGenerator.generateIfs(builder, context, condition, caseSections);
        }
    }

    private static boolean isValidTypeForSwitchSelector(@NotNull PsiType type) {
        if (type == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(3);
        }
        if (TypeConversionUtil.getTypeRank((PsiType)type) <= 4) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        return aClass != null && aClass.isEnum();
    }

    private static void generateIfs(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrExpression condition, GrCaseSection @NotNull [] caseSections) {
        GrExpression ref2;
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(5);
        }
        if (condition == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(6);
        }
        if (caseSections == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(7);
        }
        if (condition instanceof GrReferenceExpression) {
            ref2 = condition;
        } else {
            String varName = SwitchStatementGenerator.generateConditionVar(builder, context, condition);
            ref2 = GroovyPsiElementFactory.getInstance(context.project).createExpressionFromText(varName);
        }
        GrExpression[] args = new GrExpression[]{ref2};
        SwitchStatementGenerator.generateIfFromCaseSection(builder, context, caseSections, 0, List.of(), args);
    }

    private static void generateIfFromCaseSection(@NotNull StringBuilder builder, @NotNull ExpressionContext context, final GrCaseSection @NotNull [] caseSections, final int i2, final List<GrCaseSection> currentSequentialSectionFrame, final GrExpression @NotNull [] args) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(8);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(9);
        }
        if (caseSections == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(10);
        }
        if (args == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(11);
        }
        GenerationUtil.writeStatement(builder, context, null, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                GrCaseSection section;
                if (caseSections.length == 1 && caseSections[0].isDefault()) {
                    builder.append("if(true)");
                }
                if ((section = caseSections[i2]).getStatements().length != 0) {
                    boolean isCase;
                    boolean bl = isCase = currentSequentialSectionFrame.size() > 1 || !section.isDefault();
                    if (isCase) {
                        SwitchStatementGenerator.writeCondition(builder, context, section, currentSequentialSectionFrame, args);
                    }
                    SwitchStatementGenerator.writeCaseBody(builder, context, i2, caseSections);
                    if (isCase && i2 != caseSections.length - 1) {
                        builder.append("\nelse ");
                        StringBuilder elseBuilder = new StringBuilder();
                        ExpressionContext elseContext = context.extend();
                        SwitchStatementGenerator.generateIfFromCaseSection(elseBuilder, elseContext, caseSections, i2 + 1, List.of(), args);
                        GenerationUtil.insertStatementFromContextBefore(builder, elseContext);
                        builder.append((CharSequence)elseBuilder);
                    }
                    if (!context.myStatements.isEmpty()) {
                        context.setInsertCurlyBrackets();
                    }
                } else {
                    ArrayList<GrCaseSection> list = new ArrayList<GrCaseSection>(currentSequentialSectionFrame);
                    list.add(section);
                    SwitchStatementGenerator.generateIfFromCaseSection(builder, context, caseSections, i2 + 1, list, args);
                }
            }
        });
    }

    private static void writeCaseBody(@NotNull StringBuilder builder, @NotNull ExpressionContext context, int i2, GrCaseSection @NotNull [] caseSections) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(12);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(13);
        }
        if (caseSections == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(14);
        }
        builder.append("{\n");
        ExpressionContext extended = context.extend();
        CodeBlockGenerator generator = new CodeBlockGenerator(builder, extended);
        block0: for (int j = i2; j < caseSections.length; ++j) {
            GrStatement[] statements;
            GrCaseSection curSection = caseSections[j];
            for (GrStatement statement : statements = curSection.getStatements()) {
                if (statement instanceof GrBreakStatement && ((GrBreakStatement)statement).getLabelIdentifier() == null) break block0;
                statement.accept(generator);
                builder.append("\n");
            }
            if (SwitchStatementGenerator.brakesFlow(curSection)) break;
        }
        builder.append('}');
    }

    private static boolean brakesFlow(GrCaseSection section) {
        Object[] statements = section.getStatements();
        return statements.length > 0 && !ControlFlowUtils.statementMayCompleteNormally((GrStatement)ArrayUtil.getLastElement((Object[])statements));
    }

    private static void writeCondition(StringBuilder builder, ExpressionContext context, GrCaseSection section, List<GrCaseSection> currentSequentialSectionFrame, GrExpression[] args) {
        builder.append("if (");
        for (GrCaseSection prevSection : currentSequentialSectionFrame) {
            SwitchStatementGenerator.appendCaseSection(builder, context, args, prevSection);
        }
        SwitchStatementGenerator.appendCaseSection(builder, context, args, section);
        builder.delete(builder.length() - 2, builder.length());
        builder.append(") ");
    }

    private static void appendCaseSection(StringBuilder builder, ExpressionContext context, GrExpression[] args, GrCaseSection prevSection) {
        if (prevSection.isDefault()) {
            builder.append("true");
        } else {
            GenerationUtil.invokeMethodByName(prevSection.getExpressions()[0], "isCase", args, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, new ExpressionGenerator(builder, context), prevSection);
        }
        builder.append("||");
    }

    private static String generateConditionVar(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrExpression condition) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(15);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(16);
        }
        if (condition == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(17);
        }
        StringBuilder conditionBuilder = new StringBuilder();
        PsiType type = condition.getType();
        String varName = GenerationUtil.validateName("switchArg", condition, context);
        conditionBuilder.append("final ");
        TypeWriter.writeType(conditionBuilder, type, condition);
        conditionBuilder.append(' ').append(varName).append(" = ");
        condition.accept(new ExpressionGenerator(conditionBuilder, context));
        conditionBuilder.append(";\n");
        GenerationUtil.insertStatementFromContextBefore(builder, context);
        builder.append((CharSequence)conditionBuilder);
        return varName;
    }

    private static void generateSwitch(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @Nullable GrExpression condition, GrCaseSection @NotNull [] caseSections) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(18);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(19);
        }
        if (caseSections == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(20);
        }
        builder.append("switch (");
        if (condition != null) {
            condition.accept(new ExpressionGenerator(builder, context));
        }
        builder.append(") {\n");
        ExpressionContext innerContext = context.extend();
        for (GrCaseSection section : caseSections) {
            SwitchStatementGenerator.generateCaseSection(builder, context, innerContext, section);
        }
        builder.append('}');
    }

    private static void generateCaseSection(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull ExpressionContext innerContext, @NotNull GrCaseSection section) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(21);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(22);
        }
        if (innerContext == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(23);
        }
        if (section == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(24);
        }
        SwitchStatementGenerator.writeLabel(builder, context, section);
        GrStatement[] statements = section.getStatements();
        CodeBlockGenerator generator = new CodeBlockGenerator(builder, innerContext);
        for (GrStatement statement : statements) {
            statement.accept(generator);
            builder.append("\n");
        }
    }

    private static void writeLabel(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrCaseSection section) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(25);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(26);
        }
        if (section == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(27);
        }
        if (section.isDefault()) {
            builder.append("default");
        } else {
            Object evaluated;
            builder.append("case ");
            GrExpression value = section.getExpressions()[0];
            try {
                evaluated = GroovyConstantExpressionEvaluator.evaluate(value);
            }
            catch (Throwable e) {
                evaluated = null;
            }
            if (evaluated != null) {
                builder.append(evaluated);
            } else if (value != null) {
                value.accept(new ExpressionGenerator(builder, context));
            }
        }
        builder.append(":\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseSections";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerContext";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/SwitchStatementGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidTypeForSwitchSelector";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generateIfs";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "generateIfFromCaseSection";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "writeCaseBody";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "generateConditionVar";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "generateSwitch";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "generateCaseSection";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLabel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

