/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.applicators.ApplicabilityRanges;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.AddBracesToElseFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ConvertIfToWhenFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.SuspiciousCascadingIfInspectionKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0014\u0010\u000e\u001a\u00020\u0003*\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\r\u001a\u00020\u0002H\u0016J3\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/SuspiciousCascadingIfInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isApplicableByPsi", "element", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "createProblemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Lcom/intellij/codeInspection/InspectionManager;", "context", "rangeInElement", "onTheFly", "(Lcom/intellij/codeInspection/InspectionManager;Lorg/jetbrains/kotlin/psi/KtIfExpression;Lkotlin/Unit;Lcom/intellij/openapi/util/TextRange;Z)Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.kotlin.codeInsight.inspections"})
public final class SuspiciousCascadingIfInspection
extends KotlinApplicableInspectionBase<KtIfExpression, Unit> {
    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.ifExpressionVisitor(arg_0 -> SuspiciousCascadingIfInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtIfExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getCondition() == null || element.getThen() == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)element.getParent().getNode().getElementType(), (Object)KtNodeTypes.ELSE)) {
            return false;
        }
        KtExpression lastElseBranch = SuspiciousCascadingIfInspectionKt.access$findLastElseBranch(element);
        KtExpression candidateExpression = lastElseBranch instanceof KtQualifiedExpression ? ((KtQualifiedExpression)lastElseBranch).getReceiverExpression() : (lastElseBranch instanceof KtBinaryExpression ? ((KtBinaryExpression)lastElseBranch).getLeft() : null);
        return candidateExpression instanceof KtIfExpression;
    }

    @Override
    public void prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtIfExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtIfExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ApplicabilityRanges.INSTANCE.ifKeyword(element);
    }

    @Override
    @NotNull
    protected ProblemDescriptor createProblemDescriptor(@NotNull InspectionManager $this$createProblemDescriptor, @NotNull KtIfExpression element, @NotNull Unit context2, @Nullable TextRange rangeInElement, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)$this$createProblemDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ConvertIfToWhenFix(), new AddBracesToElseFix()};
        ProblemDescriptor problemDescriptor = $this$createProblemDescriptor.createProblemDescriptor((PsiElement)element, rangeInElement, KotlinBundle.message((String)"inspection.suspicious.cascading.if.display.name", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, localQuickFixArray);
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        return problemDescriptor;
    }

    private static final Unit buildVisitor$lambda$0(SuspiciousCascadingIfInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtIfExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }
}

