/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.testFramework.LightVirtualFileBase;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0002*\u00020\u0002\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\u001f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u000b\u001a\u00020\u0001*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0007\u00a8\u0006\u000e"}, d2={"isKotlinFileType", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "isJavaFileType", "getOriginalOrDelegateFileOrSelf", "getOriginalOrDelegateFile", "getAllFilesRecursively", "", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "isFileInRoots", "Lcom/intellij/openapi/project/Project;", "file", "intellij.kotlin.base.util"})
@JvmName(name="FileUtils")
public final class FileUtils {
    public static final boolean isKotlinFileType(@NotNull VirtualFile $this$isKotlinFileType) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinFileType, (String)"<this>");
        CharSequence charSequence = $this$isKotlinFileType.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence nameSequence = charSequence;
        if (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kt", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".class", (boolean)false, (int)2, null)) {
            return false;
        }
        return Intrinsics.areEqual((Object)FileTypeManager.getInstance().getFileTypeByFileName(nameSequence), (Object)KotlinFileType.INSTANCE);
    }

    public static final boolean isJavaFileType(@NotNull VirtualFile $this$isJavaFileType) {
        Intrinsics.checkNotNullParameter((Object)$this$isJavaFileType, (String)"<this>");
        CharSequence charSequence = $this$isJavaFileType.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence nameSequence = charSequence;
        return StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".java", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)FileTypeManager.getInstance().getFileTypeByFileName(nameSequence), (Object)JavaFileType.INSTANCE);
    }

    @NotNull
    public static final VirtualFile getOriginalOrDelegateFileOrSelf(@NotNull VirtualFile $this$getOriginalOrDelegateFileOrSelf) {
        Intrinsics.checkNotNullParameter((Object)$this$getOriginalOrDelegateFileOrSelf, (String)"<this>");
        VirtualFile virtualFile = FileUtils.getOriginalOrDelegateFile($this$getOriginalOrDelegateFileOrSelf);
        if (virtualFile == null) {
            virtualFile = $this$getOriginalOrDelegateFileOrSelf;
        }
        return virtualFile;
    }

    @Nullable
    public static final VirtualFile getOriginalOrDelegateFile(@NotNull VirtualFile $this$getOriginalOrDelegateFile) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)$this$getOriginalOrDelegateFile, (String)"<this>");
        VirtualFile virtualFile2 = $this$getOriginalOrDelegateFile;
        if (virtualFile2 instanceof VirtualFileWindow) {
            VirtualFile virtualFile3 = ((VirtualFileWindow)$this$getOriginalOrDelegateFile).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getDelegate(...)");
            virtualFile = FileUtils.getOriginalOrDelegateFile(virtualFile3);
        } else {
            virtualFile = virtualFile2 instanceof LightVirtualFileBase ? ((LightVirtualFileBase)$this$getOriginalOrDelegateFile).getOriginalFile() : $this$getOriginalOrDelegateFile;
        }
        return virtualFile;
    }

    @NotNull
    public static final Collection<VirtualFile> getAllFilesRecursively(@NotNull VirtualFile[] filesOrDirs) {
        Intrinsics.checkNotNullParameter((Object)filesOrDirs, (String)"filesOrDirs");
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile file : filesOrDirs) {
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, optionArray){
                final /* synthetic */ ArrayList<VirtualFile> $result;
                {
                    this.$result = $result;
                    super($super_call_param$1);
                }

                public boolean visitFile(VirtualFile file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    this.$result.add(file);
                    return true;
                }
            }));
        }
        return result2;
    }

    @ApiStatus.Internal
    public static final boolean isFileInRoots(@NotNull Project $this$isFileInRoots, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$isFileInRoots, (String)"<this>");
        if (file == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)$this$isFileInRoots).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex index2 = projectFileIndex;
        return index2.isInSourceContent(file) || index2.isInLibraryClasses(file) || index2.isInLibrarySource(file);
    }
}

