/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import sun.misc.ObjectInputFilter;
import sun.security.util.SecurityProperties;

public final class ObjectFactoriesFilter {
    private static final String FACTORIES_FILTER_PROPNAME = "jdk.jndi.object.factoriesFilter";
    private static final String DEFAULT_SP_VALUE = "*";
    private static final ObjectInputFilter GLOBAL = ObjectInputFilter.Config.createFilter(ObjectFactoriesFilter.getFilterPropertyValue());

    public static boolean canInstantiateObjectsFactory(Class<?> clazz) {
        return ObjectFactoriesFilter.checkInput(() -> clazz);
    }

    private static boolean checkInput(FactoryInfo factoryInfo) {
        ObjectInputFilter.Status status = GLOBAL.checkInput(factoryInfo);
        return status != ObjectInputFilter.Status.REJECTED;
    }

    private ObjectFactoriesFilter() {
        throw new InternalError("Not instantiable");
    }

    private static String getFilterPropertyValue() {
        String string = SecurityProperties.privilegedGetOverridable(FACTORIES_FILTER_PROPNAME);
        return string != null ? string : DEFAULT_SP_VALUE;
    }

    @FunctionalInterface
    private static interface FactoryInfo
    extends ObjectInputFilter.FilterInfo {
        @Override
        default public long arrayLength() {
            return -1L;
        }

        @Override
        default public long depth() {
            return 1L;
        }

        @Override
        default public long references() {
            return 0L;
        }

        @Override
        default public long streamBytes() {
            return 0L;
        }
    }
}

