/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jboss.logging.Logger;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.JOSEHeader;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.oid4vci.CredentialScopeModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.OffsetTimeProvider;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilder;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderFactory;
import org.keycloak.protocol.oid4vc.issuance.keybinding.CNonceHandler;
import org.keycloak.protocol.oid4vc.issuance.keybinding.ProofValidator;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.issuance.signing.CredentialSigner;
import org.keycloak.protocol.oid4vc.model.ClaimsDescription;
import org.keycloak.protocol.oid4vc.model.CredentialIssuer;
import org.keycloak.protocol.oid4vc.model.CredentialOfferURI;
import org.keycloak.protocol.oid4vc.model.CredentialRequest;
import org.keycloak.protocol.oid4vc.model.CredentialRequestEncryptionMetadata;
import org.keycloak.protocol.oid4vc.model.CredentialResponse;
import org.keycloak.protocol.oid4vc.model.CredentialResponseEncryption;
import org.keycloak.protocol.oid4vc.model.CredentialResponseEncryptionMetadata;
import org.keycloak.protocol.oid4vc.model.CredentialsOffer;
import org.keycloak.protocol.oid4vc.model.ErrorResponse;
import org.keycloak.protocol.oid4vc.model.ErrorType;
import org.keycloak.protocol.oid4vc.model.NonceResponse;
import org.keycloak.protocol.oid4vc.model.OfferUriType;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedCode;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedGrant;
import org.keycloak.protocol.oid4vc.model.Proofs;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.protocol.oid4vc.utils.ClaimsPathPointer;
import org.keycloak.protocol.oidc.grants.PreAuthorizedCodeGrantType;
import org.keycloak.protocol.oidc.utils.OAuth2Code;
import org.keycloak.protocol.oidc.utils.OAuth2CodeParser;
import org.keycloak.provider.Provider;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.dpop.DPoP;
import org.keycloak.saml.processing.api.util.DeflateUtil;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.util.JsonSerialization;

public class OID4VCIssuerEndpoint {
    private static final Logger LOGGER = Logger.getLogger(OID4VCIssuerEndpoint.class);
    public static final String CREDENTIAL_CONFIGURATION_IDS_NOTE = "CREDENTIAL_CONFIGURATION_IDS";
    public static final String CREDENTIAL_IDENTIFIER_PREFIX = "credential_identifier_";
    public static final String AUTHORIZATION_DETAILS_CLAIMS_PREFIX = "AUTHORIZATION_DETAILS_CLAIMS_";
    private Cors cors;
    private static final String CODE_LIFESPAN_REALM_ATTRIBUTE_KEY = "preAuthorizedCodeLifespanS";
    private static final int DEFAULT_CODE_LIFESPAN_S = 30;
    public static final String DEFLATE_COMPRESSION = "DEF";
    public static final String NONCE_PATH = "nonce";
    public static final String CREDENTIAL_PATH = "credential";
    public static final String CREDENTIAL_OFFER_PATH = "credential-offer/";
    public static final String RESPONSE_TYPE_IMG_PNG = "image/png";
    public static final String CREDENTIAL_OFFER_URI_CODE_SCOPE = "credential-offer";
    private final KeycloakSession session;
    private final AppAuthManager.BearerTokenAuthenticator bearerTokenAuthenticator;
    private final TimeProvider timeProvider;
    private final int preAuthorizedCodeLifeSpan;
    private static final String OID4VCI_ENABLED_ATTRIBUTE_KEY = "oid4vci.enabled";
    private final Map<String, CredentialBuilder> credentialBuilders;

    public OID4VCIssuerEndpoint(KeycloakSession session, Map<String, CredentialBuilder> credentialBuilders, AppAuthManager.BearerTokenAuthenticator authenticator, TimeProvider timeProvider, int preAuthorizedCodeLifeSpan) {
        this.session = session;
        this.bearerTokenAuthenticator = authenticator;
        this.timeProvider = timeProvider;
        this.credentialBuilders = credentialBuilders;
        this.preAuthorizedCodeLifeSpan = preAuthorizedCodeLifeSpan;
    }

    public OID4VCIssuerEndpoint(KeycloakSession keycloakSession) {
        this.session = keycloakSession;
        this.bearerTokenAuthenticator = new AppAuthManager.BearerTokenAuthenticator(keycloakSession);
        this.timeProvider = new OffsetTimeProvider();
        this.credentialBuilders = this.loadCredentialBuilders(this.session);
        RealmModel realm = keycloakSession.getContext().getRealm();
        this.preAuthorizedCodeLifeSpan = Optional.ofNullable(realm.getAttribute(CODE_LIFESPAN_REALM_ATTRIBUTE_KEY)).map(Integer::valueOf).orElse(30);
    }

    private Map<String, CredentialBuilder> loadCredentialBuilders(KeycloakSession keycloakSession) {
        KeycloakSessionFactory keycloakSessionFactory = keycloakSession.getKeycloakSessionFactory();
        return keycloakSessionFactory.getProviderFactoriesStream(CredentialBuilder.class).map(factory -> (CredentialBuilderFactory)factory).map(factory -> (CredentialBuilder)factory.create(keycloakSession, null)).collect(Collectors.toMap(CredentialBuilder::getSupportedFormat, credentialBuilder -> credentialBuilder));
    }

    private void checkClientEnabled() {
        AuthenticatedClientSessionModel clientSession = this.getAuthenticatedClientSession();
        ClientModel client = clientSession.getClient();
        boolean oid4vciEnabled = Boolean.parseBoolean((String)client.getAttributes().get(OID4VCI_ENABLED_ATTRIBUTE_KEY));
        if (!oid4vciEnabled) {
            LOGGER.debugf("Client '%s' is not enabled for OID4VCI features.", (Object)client.getClientId());
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Client not enabled for OID4VCI", Response.Status.FORBIDDEN);
        }
        LOGGER.debugf("Client '%s' is enabled for OID4VCI features.", (Object)client.getClientId());
    }

    private String generateNotificationId() {
        return SecretGenerator.getInstance().randomString();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="nonce")
    public Response getCNonce() {
        CNonceHandler cNonceHandler = (CNonceHandler)this.session.getProvider(CNonceHandler.class);
        NonceResponse nonceResponse = new NonceResponse();
        String sourceEndpoint = OID4VCIssuerWellKnownProvider.getNonceEndpoint(this.session.getContext());
        String audience = OID4VCIssuerWellKnownProvider.getCredentialsEndpoint(this.session.getContext());
        String bodyCNonce = cNonceHandler.buildCNonce(List.of(audience), Map.of("source_endpoint", sourceEndpoint));
        String headerDPoPNonce = cNonceHandler.buildCNonce(List.of(audience), Map.of("source_endpoint", sourceEndpoint));
        nonceResponse.setNonce(bodyCNonce);
        Response.ResponseBuilder responseBuilder = Response.ok().header("Cache-Control", (Object)"no-store").entity((Object)nonceResponse);
        if (headerDPoPNonce != null) {
            responseBuilder.header("DPoP-Nonce", (Object)headerDPoPNonce);
        }
        return responseBuilder.build();
    }

    @GET
    @Produces(value={"application/json", "image/png"})
    @Path(value="credential-offer-uri")
    public Response getCredentialOfferURI(@QueryParam(value="credential_configuration_id") String vcId, @QueryParam(value="type") @DefaultValue(value="uri") OfferUriType type, @QueryParam(value="width") @DefaultValue(value="200") int width, @QueryParam(value="height") @DefaultValue(value="200") int height) {
        AuthenticatedClientSessionModel clientSession = this.getAuthenticatedClientSession();
        this.cors = Cors.builder().auth().allowedMethods(new String[]{"GET"}).auth().exposedHeaders(new String[]{"Access-Control-Allow-Methods"});
        this.checkClientEnabled();
        Map<String, SupportedCredentialConfiguration> credentialsMap = OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.session);
        LOGGER.debugf("Get an offer for %s", (Object)vcId);
        if (!credentialsMap.containsKey(vcId)) {
            LOGGER.debugf("No credential with id %s exists.", (Object)vcId);
            LOGGER.debugf("Supported credentials are %s.", credentialsMap);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        SupportedCredentialConfiguration supportedCredentialConfiguration = credentialsMap.get(vcId);
        int expiration = this.timeProvider.currentTimeSeconds() + this.preAuthorizedCodeLifeSpan;
        String preAuthorizedCode = this.generateAuthorizationCodeForClientSession(expiration, clientSession);
        CredentialsOffer theOffer = new CredentialsOffer().setCredentialIssuer(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext())).setCredentialConfigurationIds(List.of(supportedCredentialConfiguration.getId())).setGrants(new PreAuthorizedGrant().setPreAuthorizedCode(new PreAuthorizedCode().setPreAuthorizedCode(preAuthorizedCode)));
        String sessionCode = this.generateCodeForSession(expiration, clientSession);
        try {
            clientSession.setNote(sessionCode, JsonSerialization.mapper.writeValueAsString((Object)theOffer));
            String credentialConfigIdsJson = JsonSerialization.mapper.writeValueAsString(theOffer.getCredentialConfigurationIds());
            clientSession.setNote(CREDENTIAL_CONFIGURATION_IDS_NOTE, credentialConfigIdsJson);
            LOGGER.debugf("Stored credential configuration IDs for token processing: %s", (Object)credentialConfigIdsJson);
        }
        catch (JsonProcessingException e) {
            LOGGER.errorf("Could not convert the offer POJO to JSON: %s", (Object)e.getMessage());
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case OfferUriType.URI -> this.getOfferUriAsUri(sessionCode);
            case OfferUriType.QR_CODE -> this.getOfferUriAsQr(sessionCode, width, height);
        };
    }

    private Response getOfferUriAsUri(String sessionCode) {
        CredentialOfferURI credentialOfferURI = new CredentialOfferURI().setIssuer(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext()) + "/protocol/oid4vc/credential-offer/").setNonce(sessionCode);
        return Response.ok().type("application/json").entity((Object)credentialOfferURI).build();
    }

    private Response getOfferUriAsQr(String sessionCode, int width, int height) {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        String encodedOfferUri = URLEncoder.encode(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext()) + "/protocol/oid4vc/credential-offer/" + sessionCode, StandardCharsets.UTF_8);
        try {
            BitMatrix bitMatrix = qrCodeWriter.encode("openid-credential-offer://?credential_offer_uri=" + encodedOfferUri, BarcodeFormat.QR_CODE, width, height);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)bos);
            return Response.ok().type(RESPONSE_TYPE_IMG_PNG).entity((Object)bos.toByteArray()).build();
        }
        catch (WriterException | IOException e) {
            LOGGER.warnf("Was not able to create a qr code of dimension %s:%s.", (Object)width, (Object)height, (Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Was not able to generate qr.").build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="credential-offer/{sessionCode}")
    public Response getCredentialOffer(@PathParam(value="sessionCode") String sessionCode) {
        if (sessionCode == null) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        CredentialsOffer credentialsOffer = this.getOfferFromSessionCode(sessionCode);
        LOGGER.debugf("Responding with offer: %s", (Object)credentialsOffer);
        return Response.ok().entity((Object)credentialsOffer).build();
    }

    private void checkScope(CredentialScopeModel requestedCredential) {
        AuthenticatedClientSessionModel clientSession = this.getAuthenticatedClientSession();
        String vcIssuanceFlow = clientSession.getNote("VC-Issuance-Flow");
        if (vcIssuanceFlow == null || !vcIssuanceFlow.equals("urn:ietf:params:oauth:grant-type:pre-authorized_code")) {
            AccessToken accessToken = this.bearerTokenAuthenticator.authenticate().getToken();
            if (Arrays.stream(accessToken.getScope().split(" ")).noneMatch(tokenScope -> tokenScope.equals(requestedCredential.getScope()))) {
                LOGGER.debugf("Scope check failure: required scope = %s, scope in access token = %s.", (Object)requestedCredential.getName(), (Object)accessToken.getScope());
                throw new CorsErrorResponseException(this.cors, ErrorType.UNKNOWN_CREDENTIAL_CONFIGURATION.toString(), "Scope check failure", Response.Status.BAD_REQUEST);
            }
            LOGGER.debugf("Scope check success: required scope = %s, #scope in access token = %s.", (Object)requestedCredential.getScope(), (Object)accessToken.getScope());
        } else {
            clientSession.removeNote("VC-Issuance-Flow");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Consumes(value={"application/json", "application/jwt"})
    @Produces(value={"application/json", "application/jwt"})
    @Path(value="credential")
    public Response requestCredential(String requestPayload) {
        CredentialScopeModel requestedCredential;
        LOGGER.debugf("Received credentials request with payload: %s", (Object)requestPayload);
        if (requestPayload == null || requestPayload.trim().isEmpty()) {
            String errorMessage = "Request payload is null or empty.";
            LOGGER.debug((Object)errorMessage);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST, errorMessage));
        }
        this.cors = Cors.builder().auth().allowedMethods(new String[]{"POST"}).auth().exposedHeaders(new String[]{"Access-Control-Allow-Methods"});
        CredentialIssuer issuerMetadata = (CredentialIssuer)new OID4VCIssuerWellKnownProvider(this.session).getConfig();
        CredentialRequest credentialRequestVO = this.validateRequestEncryption(requestPayload, issuerMetadata);
        AuthenticationManager.AuthResult authResult = this.getAuthResult();
        CredentialResponseEncryption encryptionParams = credentialRequestVO.getCredentialResponseEncryption();
        CredentialResponseEncryptionMetadata encryptionMetadata = OID4VCIssuerWellKnownProvider.getCredentialResponseEncryption(this.session);
        boolean isEncryptionRequired = Optional.ofNullable(encryptionMetadata).map(CredentialResponseEncryptionMetadata::getEncryptionRequired).orElse(false);
        if (isEncryptionRequired && encryptionParams == null) {
            String errorMessage = "Response encryption is required by the Credential Issuer, but no encryption parameters were provided.";
            LOGGER.debug((Object)errorMessage);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, errorMessage));
        }
        if (encryptionParams != null) {
            this.validateEncryptionParameters(encryptionParams);
            String selectedAlg = this.selectKeyManagementAlg(encryptionMetadata, encryptionParams.getJwk());
            if (selectedAlg == null) {
                String errorMessage = String.format("No supported key management algorithm (alg) for provided JWK (kty=%s)", encryptionParams.getJwk().getKeyType());
                LOGGER.debug((Object)errorMessage);
                throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, errorMessage));
            }
            if (!encryptionMetadata.getEncValuesSupported().contains(encryptionParams.getEnc())) {
                String errorMessage = String.format("Unsupported content encryption algorithm: enc=%s", encryptionParams.getEnc());
                LOGGER.debug((Object)errorMessage);
                throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, errorMessage));
            }
            if (encryptionParams.getZip() != null && !this.isSupportedCompression(encryptionMetadata, encryptionParams.getZip())) {
                String errorMessage = String.format("Unsupported compression parameter: zip=%s", encryptionParams.getZip());
                LOGGER.debug((Object)errorMessage);
                throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, errorMessage));
            }
        }
        this.checkClientEnabled();
        String requestedCredentialConfigurationId = credentialRequestVO.getCredentialConfigurationId();
        String requestedCredentialIdentifier = credentialRequestVO.getCredentialIdentifier();
        if (requestedCredentialConfigurationId == null && requestedCredentialIdentifier == null) {
            LOGGER.debugf("Missing both credential_configuration_id and credential_identifier. At least one must be specified.", new Object[0]);
            throw new BadRequestException(this.getErrorResponse(ErrorType.MISSING_CREDENTIAL_IDENTIFIER_AND_CONFIGURATION_ID));
        }
        if (credentialRequestVO.getCredentialIdentifier() != null) {
            String mappingKey = CREDENTIAL_IDENTIFIER_PREFIX + credentialRequestVO.getCredentialIdentifier();
            UserSessionModel userSession = authResult.getSession();
            AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(authResult.getClient().getId());
            String mappedCredentialConfigurationId = null;
            if (clientSession != null && (mappedCredentialConfigurationId = clientSession.getNote(mappingKey)) != null) {
                LOGGER.debugf("Found credential configuration ID mapping in client session for identifier %s: %s", (Object)credentialRequestVO.getCredentialIdentifier(), (Object)mappedCredentialConfigurationId);
            }
            if (mappedCredentialConfigurationId != null) {
                Map<String, SupportedCredentialConfiguration> supportedCredentials = OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.session);
                if (!supportedCredentials.containsKey(mappedCredentialConfigurationId)) {
                    LOGGER.errorf("Mapped credential configuration not found: %s", (Object)mappedCredentialConfigurationId);
                    throw new BadRequestException(this.getErrorResponse(ErrorType.UNKNOWN_CREDENTIAL_CONFIGURATION));
                }
                SupportedCredentialConfiguration config = supportedCredentials.get(mappedCredentialConfigurationId);
                ClientModel client = this.session.getContext().getClient();
                Map clientScopes = client.getClientScopes(false);
                ClientScopeModel clientScope = (ClientScopeModel)clientScopes.get(config.getScope());
                if (clientScope == null) {
                    LOGGER.errorf("Client scope not found for mapped credential configuration: %s", (Object)config.getScope());
                    throw new BadRequestException(this.getErrorResponse(ErrorType.UNKNOWN_CREDENTIAL_CONFIGURATION));
                }
                requestedCredential = new CredentialScopeModel(clientScope);
                LOGGER.debugf("Successfully mapped credential identifier %s to configuration %s", (Object)credentialRequestVO.getCredentialIdentifier(), (Object)mappedCredentialConfigurationId);
            } else {
                LOGGER.debugf("No mapping found for credential identifier %s, trying direct scope lookup", (Object)credentialRequestVO.getCredentialIdentifier());
                try {
                    requestedCredential = credentialRequestVO.findCredentialScope(this.session).orElseThrow(() -> {
                        LOGGER.errorf("Credential scope not found for identifier: %s", (Object)credentialRequestVO.getCredentialIdentifier());
                        return new BadRequestException(this.getErrorResponse(ErrorType.UNKNOWN_CREDENTIAL_IDENTIFIER));
                    });
                }
                catch (Exception e) {
                    LOGGER.errorf((Throwable)e, "Failed to find credential scope for identifier: %s", (Object)credentialRequestVO.getCredentialIdentifier());
                    throw new BadRequestException(this.getErrorResponse(ErrorType.UNKNOWN_CREDENTIAL_IDENTIFIER));
                }
            }
        } else {
            if (credentialRequestVO.getCredentialConfigurationId() == null) {
                throw new BadRequestException(this.getErrorResponse(ErrorType.MISSING_CREDENTIAL_IDENTIFIER_AND_CONFIGURATION_ID));
            }
            requestedCredential = credentialRequestVO.findCredentialScope(this.session).orElseThrow(() -> {
                LOGGER.errorf("Credential scope not found for configuration ID: %s", (Object)credentialRequestVO.getCredentialConfigurationId());
                return new BadRequestException(this.getErrorResponse(ErrorType.UNKNOWN_CREDENTIAL_CONFIGURATION));
            });
        }
        this.checkScope(requestedCredential);
        SupportedCredentialConfiguration supportedCredential = OID4VCIssuerWellKnownProvider.toSupportedCredentialConfiguration(this.session, requestedCredential);
        List<String> allProofs = this.getAllProofs(credentialRequestVO);
        CredentialResponse responseVO = new CredentialResponse();
        responseVO.setNotificationId(this.generateNotificationId());
        if (allProofs.isEmpty()) {
            Object theCredential = this.getCredential(authResult, supportedCredential, credentialRequestVO);
            responseVO.addCredential(theCredential);
        } else {
            Proofs originalProofs = credentialRequestVO.getProofs();
            for (String currentProof : allProofs) {
                credentialRequestVO.setProofs(new Proofs().setJwt(List.of(currentProof)));
                Object theCredential = this.getCredential(authResult, supportedCredential, credentialRequestVO);
                responseVO.addCredential(theCredential);
            }
            credentialRequestVO.setProofs(originalProofs);
        }
        if (encryptionParams != null && !responseVO.getCredentials().isEmpty()) {
            String jwe = this.encryptCredentialResponse(responseVO, encryptionParams, encryptionMetadata);
            return Response.ok().type("application/jwt").entity((Object)jwe).build();
        }
        return Response.ok().entity((Object)responseVO).build();
    }

    private CredentialRequest validateRequestEncryption(String requestPayload, CredentialIssuer issuerMetadata) throws BadRequestException {
        block8: {
            CredentialRequestEncryptionMetadata requestEncryptionMetadata = issuerMetadata.getCredentialRequestEncryption();
            boolean isRequestEncryptionRequired = Optional.ofNullable(requestEncryptionMetadata).map(CredentialRequestEncryptionMetadata::isEncryptionRequired).orElse(false);
            String contentType = this.session.getContext().getHttpRequest().getHttpHeaders().getHeaderString("Content-Type");
            if (contentType != null) {
                contentType = contentType.split(";")[0].trim();
            }
            boolean contentTypeIsJwt = "application/jwt".equalsIgnoreCase(contentType);
            if (isRequestEncryptionRequired || contentTypeIsJwt) {
                if (requestEncryptionMetadata == null && contentTypeIsJwt) {
                    String errorMessage = "Received JWT content-type request, but credential_request_encryption is not supported.";
                    LOGGER.debug((Object)errorMessage);
                    throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, errorMessage));
                }
                try {
                    return this.decryptCredentialRequest(requestPayload, requestEncryptionMetadata);
                }
                catch (Exception e) {
                    if (isRequestEncryptionRequired) {
                        String errorMessage = "Encryption is required but request is not a valid JWE: " + e.getMessage();
                        LOGGER.debug((Object)errorMessage);
                        throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, errorMessage));
                    }
                    if (!contentTypeIsJwt) break block8;
                    String errorMessage = "Request has JWT content-type but is not a valid JWE: " + e.getMessage();
                    LOGGER.debug((Object)errorMessage);
                    throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, errorMessage));
                }
            }
        }
        try {
            return (CredentialRequest)JsonSerialization.mapper.readValue(requestPayload, CredentialRequest.class);
        }
        catch (JsonProcessingException e) {
            String errorMessage = "Failed to parse JSON request: " + e.getMessage();
            LOGGER.debug((Object)errorMessage);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST, errorMessage));
        }
    }

    private CredentialRequest decryptCredentialRequest(String jweString, CredentialRequestEncryptionMetadata metadata) throws Exception {
        JWE jwe = new JWE(jweString);
        JOSEHeader rawHeader = jwe.getHeader();
        if (!(rawHeader instanceof JWEHeader)) {
            throw new JWEException("Invalid header type: expected JWEHeader but got " + rawHeader.getClass().getName());
        }
        JWEHeader header = (JWEHeader)rawHeader;
        String enc = header.getEncryptionAlgorithm();
        if (!metadata.getEncValuesSupported().contains(enc)) {
            String errorMessage = String.format("Unsupported content encryption algorithm: enc=%s", enc);
            LOGGER.debugf(errorMessage, new Object[0]);
            throw new JWEException(String.valueOf((Object)ErrorType.INVALID_ENCRYPTION_PARAMETERS));
        }
        String zip = header.getCompressionAlgorithm();
        if (!(zip == null || DEFLATE_COMPRESSION.equals(zip) && metadata.getZipValuesSupported() != null && metadata.getZipValuesSupported().contains(zip))) {
            String errorMessage = String.format("Unsupported compression algorithm: zip=%s", zip);
            LOGGER.debugf(errorMessage, new Object[0]);
            throw new JWEException(String.valueOf((Object)ErrorType.INVALID_ENCRYPTION_PARAMETERS));
        }
        String kid = header.getKeyId();
        if (kid == null) {
            throw new JWEException("Missing kid in JWE header");
        }
        RealmModel realm = this.session.getContext().getRealm();
        KeyManager keyManager = this.session.keys();
        List matchingKeys = keyManager.getKeysStream(realm).filter(key -> KeyUse.ENC.equals((Object)key.getUse()) && kid.equals(key.getKid())).collect(Collectors.toList());
        if (matchingKeys.isEmpty()) {
            throw new JWEException("No encryption key found for kid: " + kid);
        }
        if (matchingKeys.size() > 1) {
            throw new JWEException("Multiple encryption keys found for kid: " + kid);
        }
        KeyWrapper keyWrapper = (KeyWrapper)matchingKeys.get(0);
        jwe.getKeyStorage().setDecryptionKey(keyWrapper.getPrivateKey());
        try {
            jwe.verifyAndDecodeJwe();
        }
        catch (JWEException e) {
            throw new JWEException("Failed to decrypt JWE: " + e.getMessage());
        }
        byte[] content = jwe.getContent();
        if (zip != null) {
            content = this.decompress(content, zip);
        }
        try {
            return (CredentialRequest)JsonSerialization.mapper.readValue(content, CredentialRequest.class);
        }
        catch (JsonProcessingException e) {
            throw new JWEException("Failed to parse decrypted JWE payload: " + e.getMessage());
        }
    }

    private byte[] decompress(byte[] content, String zipAlgorithm) throws JWEException {
        if (DEFLATE_COMPRESSION.equals(zipAlgorithm)) {
            try {
                return IOUtils.toByteArray((InputStream)DeflateUtil.decode((byte[])content));
            }
            catch (IOException e) {
                throw new JWEException("Failed to decompress: " + e.getMessage());
            }
        }
        throw new JWEException("Unsupported compression algorithm");
    }

    private String selectKeyManagementAlg(CredentialResponseEncryptionMetadata metadata, JWK jwk) {
        List<String> supportedAlgs = metadata.getAlgValuesSupported();
        if (supportedAlgs == null || supportedAlgs.isEmpty()) {
            return null;
        }
        String jwkAlg = jwk.getAlgorithm();
        if (jwkAlg == null) {
            LOGGER.debugf("JWK is missing required 'alg' parameter for key type: %s", (Object)jwk.getKeyType());
            return null;
        }
        if (supportedAlgs.contains(jwkAlg)) {
            return jwkAlg;
        }
        LOGGER.debugf("JWK algorithm '%s' is not supported by the server. Supported algorithms: %s", (Object)jwkAlg, supportedAlgs);
        throw new IllegalArgumentException(String.format("JWK algorithm '%s' is not supported. Supported algorithms: %s", jwkAlg, supportedAlgs));
    }

    private List<String> getAllProofs(CredentialRequest credentialRequestVO) {
        ArrayList<String> allProofs = new ArrayList<String>();
        Proofs proofs = credentialRequestVO.getProofs();
        if (proofs == null) {
            return allProofs;
        }
        if (proofs.getJwt() == null || proofs.getJwt().isEmpty()) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_PROOF, "The 'proofs' object must contain exactly one proof type with non-empty array."));
        }
        allProofs.addAll(proofs.getJwt());
        return allProofs;
    }

    private String encryptCredentialResponse(CredentialResponse response, CredentialResponseEncryption encryptionParams, CredentialResponseEncryptionMetadata metadata) {
        PublicKey publicKey;
        this.validateEncryptionParameters(encryptionParams);
        String enc = encryptionParams.getEnc();
        String zip = encryptionParams.getZip();
        JWK jwk = encryptionParams.getJwk();
        try {
            publicKey = JWKParser.create((JWK)jwk).toPublicKey();
            if (publicKey == null) {
                LOGGER.debug((Object)"Invalid JWK: Failed to parse public key");
                throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, "Invalid JWK: Failed to parse public key."));
            }
        }
        catch (Exception e) {
            LOGGER.debugf("Failed to parse JWK: %s", (Object)e.getMessage());
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, "Invalid JWK: Failed to parse public key."));
        }
        String selectedAlg = this.selectKeyManagementAlg(metadata, jwk);
        try {
            byte[] content = JsonSerialization.writeValueAsBytes((Object)response);
            if (zip != null) {
                content = this.compressContent(content, zip);
            }
            JWEHeader header = new JWEHeader.JWEHeaderBuilder().algorithm(selectedAlg).encryptionAlgorithm(enc).compressionAlgorithm(zip).keyId(jwk.getKeyId()).build();
            JWE jwe = new JWE().header(header).content(content);
            jwe.getKeyStorage().setEncryptionKey((Key)publicKey);
            return jwe.encodeJwe();
        }
        catch (IOException e) {
            LOGGER.errorf("Serialization failed: %s", (Object)e.getMessage());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorResponse().setErrorDescription("Failed to serialize response")).type("application/json").build());
        }
        catch (JWEException e) {
            LOGGER.errorf("Encryption operation failed: %s", (Object)e.getMessage());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse().setErrorDescription("Encryption operation failed: " + e.getMessage())).type("application/json").build());
        }
    }

    private byte[] compressContent(byte[] content, String zipAlgorithm) throws IOException {
        if (DEFLATE_COMPRESSION.equals(zipAlgorithm)) {
            return DeflateUtil.encode((byte[])content);
        }
        throw new IllegalArgumentException("Unsupported compression algorithm: " + zipAlgorithm);
    }

    private void validateEncryptionParameters(CredentialResponseEncryption encryptionParams) {
        if (encryptionParams == null) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, "Missing required encryption parameters (enc and jwk)."));
        }
        ArrayList<String> missingParams = new ArrayList<String>();
        if (encryptionParams.getEnc() == null) {
            missingParams.add("enc");
        }
        if (encryptionParams.getJwk() == null) {
            missingParams.add("jwk");
        }
        if (!missingParams.isEmpty()) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, String.format("Missing required parameters: %s", String.join((CharSequence)", ", missingParams))));
        }
        if (!this.isValidJwkForEncryption(encryptionParams.getJwk())) {
            String errorMessage = "Invalid JWK: Not suitable for encryption";
            LOGGER.debug((Object)errorMessage);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_ENCRYPTION_PARAMETERS, errorMessage));
        }
    }

    private boolean isValidJwkForEncryption(JWK jwk) {
        if (jwk == null) {
            return false;
        }
        String publicKeyUse = jwk.getPublicKeyUse();
        return publicKeyUse == null || "enc".equals(publicKeyUse);
    }

    private boolean isSupportedCompression(CredentialResponseEncryptionMetadata metadata, String zip) {
        return metadata != null && metadata.getZipValuesSupported() != null && metadata.getZipValuesSupported().contains(zip);
    }

    private AuthenticatedClientSessionModel getAuthenticatedClientSession() {
        AuthenticationManager.AuthResult authResult = this.getAuthResult();
        UserSessionModel userSessionModel = authResult.getSession();
        AuthenticatedClientSessionModel clientSession = userSessionModel.getAuthenticatedClientSessionByClient(authResult.getClient().getId());
        if (clientSession == null) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN));
        }
        return clientSession;
    }

    private AuthenticationManager.AuthResult getAuthResult() {
        String nonceJwt;
        Object nonceClaim;
        AuthenticationManager.AuthResult authResult = this.bearerTokenAuthenticator.authenticate();
        if (authResult == null) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN));
        }
        DPoP dPoP = (DPoP)this.session.getAttribute("dpop", DPoP.class);
        if (dPoP != null && (nonceClaim = Optional.ofNullable(dPoP.getOtherClaims()).map(m -> m.get(NONCE_PATH)).orElse(null)) instanceof String && !(nonceJwt = (String)nonceClaim).isEmpty()) {
            try {
                CNonceHandler cNonceHandler = (CNonceHandler)this.session.getProvider(CNonceHandler.class);
                String expectedAudience = OID4VCIssuerWellKnownProvider.getCredentialsEndpoint(this.session.getContext());
                String expectedSource = OID4VCIssuerWellKnownProvider.getNonceEndpoint(this.session.getContext());
                cNonceHandler.verifyCNonce(nonceJwt, List.of(expectedAudience), Map.of("source_endpoint", expectedSource));
            }
            catch (VerificationException e) {
                LOGGER.debugf("DPoP nonce validation failed: %s", (Object)e.getMessage());
                throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN));
            }
        }
        return authResult;
    }

    private AuthenticationManager.AuthResult getAuthResult(WebApplicationException errorResponse) {
        AuthenticationManager.AuthResult authResult = this.bearerTokenAuthenticator.authenticate();
        if (authResult == null) {
            throw errorResponse;
        }
        return authResult;
    }

    private Object getCredential(AuthenticationManager.AuthResult authResult, SupportedCredentialConfiguration credentialConfig, CredentialRequest credentialRequestVO) {
        CredentialScopeModel credentialScopeModel = this.getClientScopeModel(credentialConfig);
        List<OID4VCMapper> protocolMappers = credentialScopeModel.getProtocolMappersStream().map(pm -> {
            OID4VCMapper mapperFactory;
            ProtocolMapper protocolMapper;
            Provider patt50481$temp = this.session.getProvider(ProtocolMapper.class, pm.getProtocolMapper());
            if (patt50481$temp instanceof OID4VCMapper && (protocolMapper = (ProtocolMapper)(mapperFactory = (OID4VCMapper)patt50481$temp).create(this.session)) instanceof OID4VCMapper) {
                OID4VCMapper oid4VCMapper = (OID4VCMapper)protocolMapper;
                oid4VCMapper.setMapperModel((ProtocolMapperModel)pm, credentialScopeModel.getFormat());
                return oid4VCMapper;
            }
            LOGGER.warnf("The protocol mapper %s is not an instance of OID4VCMapper.", (Object)pm.getId());
            return null;
        }).filter(Objects::nonNull).toList();
        VCIssuanceContext vcIssuanceContext = this.getVCToSign(protocolMappers, credentialConfig, authResult, credentialRequestVO);
        this.enforceKeyBindingIfProofProvided(vcIssuanceContext);
        CredentialSigner credentialSigner = (CredentialSigner)this.session.getProvider(CredentialSigner.class, credentialConfig.getFormat());
        return Optional.ofNullable(credentialSigner).map(signer -> signer.signCredential(vcIssuanceContext.getCredentialBody(), credentialConfig.getCredentialBuildConfig())).orElseThrow(() -> {
            String message = String.format("No signer found for format '%s'.", credentialConfig.getFormat());
            return new BadRequestException(message, this.getErrorResponse(ErrorType.UNKNOWN_CREDENTIAL_CONFIGURATION, message));
        });
    }

    private CredentialScopeModel getClientScopeModel(SupportedCredentialConfiguration credentialConfig) {
        ClientModel clientModel = this.session.getContext().getClient();
        Map clientScopes = clientModel.getClientScopes(false);
        ClientScopeModel clientScopeModel = (ClientScopeModel)clientScopes.get(credentialConfig.getScope());
        if (clientScopeModel == null) {
            throw new BadRequestException("Client scope not found for the specified scope: " + credentialConfig.getScope());
        }
        return new CredentialScopeModel(clientScopeModel);
    }

    private String generateCodeForSession(int expiration, AuthenticatedClientSessionModel clientSession) {
        String codeId = SecretGenerator.getInstance().randomString();
        String nonce = SecretGenerator.getInstance().randomString();
        OAuth2Code oAuth2Code = new OAuth2Code(codeId, expiration, nonce, CREDENTIAL_OFFER_URI_CODE_SCOPE, null, null, null, null, clientSession.getUserSession().getId());
        return OAuth2CodeParser.persistCode(this.session, clientSession, oAuth2Code);
    }

    private CredentialsOffer getOfferFromSessionCode(String sessionCode) {
        EventBuilder eventBuilder = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        OAuth2CodeParser.ParseResult result = OAuth2CodeParser.parseCode(this.session, sessionCode, this.session.getContext().getRealm(), eventBuilder);
        if (result.isExpiredCode() || result.isIllegalCode() || !result.getCodeData().getScope().equals(CREDENTIAL_OFFER_URI_CODE_SCOPE)) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN));
        }
        try {
            String offer = result.getClientSession().getNote(sessionCode);
            CredentialsOffer credentialsOffer = (CredentialsOffer)JsonSerialization.mapper.readValue(offer, CredentialsOffer.class);
            return credentialsOffer;
        }
        catch (JsonProcessingException e) {
            LOGGER.errorf("Could not convert JSON to POJO: %s", (Object)e);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN));
        }
        finally {
            result.getClientSession().removeNote(sessionCode);
        }
    }

    private String generateAuthorizationCodeForClientSession(int expiration, AuthenticatedClientSessionModel clientSessionModel) {
        return PreAuthorizedCodeGrantType.getPreAuthorizedCode(this.session, clientSessionModel, expiration);
    }

    private Response getErrorResponse(ErrorType errorType) {
        return this.getErrorResponse(errorType, null);
    }

    private Response getErrorResponse(ErrorType errorType, String errorDescription) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(errorType).setErrorDescription(errorDescription);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).type("application/json").build();
    }

    private VCIssuanceContext getVCToSign(List<OID4VCMapper> protocolMappers, SupportedCredentialConfiguration credentialConfig, AuthenticationManager.AuthResult authResult, CredentialRequest credentialRequestVO) {
        VerifiableCredential vc = new VerifiableCredential().setIssuanceDate(Instant.ofEpochMilli(this.timeProvider.currentTimeMillis())).setType(List.of(credentialConfig.getScope()));
        HashMap<String, Object> subjectClaims = new HashMap<String, Object>();
        protocolMappers.forEach(mapper -> mapper.setClaimsForSubject(subjectClaims, authResult.getSession()));
        this.validateRequestedClaimsArePresent(subjectClaims, authResult.getSession(), credentialConfig.getScope());
        subjectClaims.forEach((key, value) -> vc.getCredentialSubject().setClaims((String)key, value));
        protocolMappers.forEach(mapper -> mapper.setClaimsForCredential(vc, authResult.getSession()));
        LOGGER.debugf("The credential to sign is: %s", (Object)vc);
        CredentialBody credentialBody = this.findCredentialBuilder(credentialConfig).buildCredentialBody(vc, credentialConfig.getCredentialBuildConfig());
        return new VCIssuanceContext().setAuthResult(authResult).setCredentialBody(credentialBody).setCredentialConfig(credentialConfig).setCredentialRequest(credentialRequestVO);
    }

    private void enforceKeyBindingIfProofProvided(VCIssuanceContext vcIssuanceContext) {
        Proofs proofs = vcIssuanceContext.getCredentialRequest().getProofs();
        if (proofs == null) {
            LOGGER.debugf("No proofs provided, skipping key binding", new Object[0]);
            return;
        }
        if (proofs.getJwt() != null && !proofs.getJwt().isEmpty()) {
            this.validateProofs(vcIssuanceContext, "jwt");
        }
    }

    private void validateProofs(VCIssuanceContext vcIssuanceContext, String proofType) {
        ProofValidator proofValidator = (ProofValidator)this.session.getProvider(ProofValidator.class, proofType);
        if (proofValidator == null) {
            throw new BadRequestException(String.format("Unable to validate proofs of type %s", proofType));
        }
        try {
            List<JWK> jwks = proofValidator.validateProof(vcIssuanceContext);
            if (jwks != null && !jwks.isEmpty()) {
                vcIssuanceContext.getCredentialBody().addKeyBinding(jwks.get(0));
            }
        }
        catch (VCIssuerException e) {
            if (e.getErrorType() == ErrorType.INVALID_NONCE) {
                throw new ErrorResponseException(ErrorType.INVALID_NONCE.getValue(), "The proofs parameter in the Credential Request uses an invalid nonce", Response.Status.BAD_REQUEST);
            }
            throw new BadRequestException("Could not validate provided proof", (Throwable)e);
        }
    }

    private CredentialBuilder findCredentialBuilder(SupportedCredentialConfiguration credentialConfig) {
        String format = credentialConfig.getFormat();
        CredentialBuilder credentialBuilder = this.credentialBuilders.get(format);
        if (credentialBuilder == null) {
            String message = String.format("No credential builder found for format %s", format);
            throw new BadRequestException(message, this.getErrorResponse(ErrorType.UNKNOWN_CREDENTIAL_CONFIGURATION, message));
        }
        return credentialBuilder;
    }

    private void validateRequestedClaimsArePresent(Map<String, Object> allClaims, UserSessionModel userSession, String scope) {
        block11: {
            try {
                String claimsKey = AUTHORIZATION_DETAILS_CLAIMS_PREFIX + scope;
                String storedClaimsJson = userSession.getNote(claimsKey);
                if (storedClaimsJson != null && !storedClaimsJson.isEmpty()) {
                    try {
                        List storedClaims = (List)JsonSerialization.readValue((String)storedClaimsJson, (TypeReference)new TypeReference<List<ClaimsDescription>>(){});
                        if (storedClaims != null && !storedClaims.isEmpty()) {
                            try {
                                ClaimsPathPointer.filterClaimsByAuthorizationDetails(allClaims, storedClaims);
                                LOGGER.debugf("All requested claims are present for scope %s", (Object)scope);
                                break block11;
                            }
                            catch (IllegalArgumentException e) {
                                LOGGER.errorf("Requested claims validation failed for scope %s: %s", (Object)scope, (Object)e.getMessage());
                                throw new BadRequestException("Credential issuance failed: " + e.getMessage() + ". The requested claims are not available in the user profile.");
                            }
                        }
                        LOGGER.infof("Stored claims list is null or empty", new Object[0]);
                    }
                    catch (Exception e) {
                        LOGGER.errorf((Throwable)e, "Failed to parse stored claims for scope %s", (Object)scope);
                    }
                    break block11;
                }
                LOGGER.infof("No stored claims found for scope %s", (Object)scope);
            }
            catch (IllegalArgumentException e) {
                String errorMessage = e.getMessage();
                if (errorMessage.contains("Mandatory claim not found:")) {
                    LOGGER.errorf("Mandatory claim missing during claims filtering for scope %s: %s", (Object)scope, (Object)errorMessage);
                    throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST, "Credential issuance failed: " + errorMessage + ". The requested mandatory claim is not available in the user profile."));
                }
                LOGGER.errorf("Claims filtering error for scope %s: %s", (Object)scope, (Object)errorMessage);
                throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST, "Credential issuance failed: " + errorMessage));
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.errorf((Throwable)e, "Unexpected error during claims validation for scope %s, continuing with all claims", (Object)scope);
            }
        }
    }
}

