/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;

final class MakeSharableVisualPanel2
extends JPanel {
    DefaultTableModel model;
    private String location = null;
    AntProjectHelper helper;
    private ReferenceHelper refhelper;
    String ACTION_COPY = "copy";
    String ACTION_RELATIVE = "keep";
    String ACTION_ABSOLUTE = "abs";
    String ACTION_USE_LOCAL_LIBRARY = "use";
    String[] comboValues = new String[]{this.ACTION_COPY, this.ACTION_RELATIVE, this.ACTION_ABSOLUTE, this.ACTION_USE_LOCAL_LIBRARY};
    String[] comboValuesJar = new String[]{this.ACTION_COPY, this.ACTION_RELATIVE, this.ACTION_ABSOLUTE};
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblDetails;
    private JLabel lblHint;
    private JLabel lblJars;
    private JTextArea taDetails;
    private JTable tblJars;

    public MakeSharableVisualPanel2() {
        this.initComponents();
        this.createTableDefinition();
    }

    @Override
    public String getName() {
        return Bundle.MakeSharablePanel2_LBL_Actions();
    }

    void readSettings(WizardDescriptor wiz) {
        String loc = (String)wiz.getProperty("location");
        this.helper = (AntProjectHelper)wiz.getProperty("helper");
        this.refhelper = (ReferenceHelper)wiz.getProperty("refhelper");
        List libraries = NbCollections.checkedListByCopy((List)((List)wiz.getProperty("libraries")), String.class, (boolean)true);
        List jars = NbCollections.checkedListByCopy((List)((List)wiz.getProperty("jars")), String.class, (boolean)true);
        if (!loc.equals(this.location)) {
            this.location = loc;
            this.populateTable(this.helper, libraries, jars);
            this.populateDescriptionField();
        }
    }

    void storeSettings(WizardDescriptor wiz) {
        this.refhelper = (ReferenceHelper)wiz.getProperty("refhelper");
        this.helper = (AntProjectHelper)wiz.getProperty("helper");
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object item = this.model.getValueAt(i, 0);
            String action = (String)this.model.getValueAt(i, 1);
            if (item instanceof Library) {
                Library lib = (Library)item;
                if (this.ACTION_ABSOLUTE.equals(action)) {
                    actions.add(new SharableLibrariesUtils.KeepLibraryAtLocation(lib, false, this.helper));
                    continue;
                }
                if (this.ACTION_RELATIVE.equals(action)) {
                    actions.add(new SharableLibrariesUtils.KeepLibraryAtLocation(lib, true, this.helper));
                    continue;
                }
                if (this.ACTION_COPY.equals(action)) {
                    actions.add(new SharableLibrariesUtils.CopyLibraryJars(this.refhelper, lib));
                    continue;
                }
                if (!this.ACTION_USE_LOCAL_LIBRARY.equals(action)) assert (false) : "No handling defined for action: " + action;
                continue;
            }
            if (item instanceof String) {
                String ref = (String)item;
                if (this.ACTION_ABSOLUTE.equals(action)) {
                    actions.add(new SharableLibrariesUtils.KeepJarAtLocation(ref, false, this.helper, this.refhelper));
                    continue;
                }
                if (this.ACTION_RELATIVE.equals(action)) {
                    actions.add(new SharableLibrariesUtils.KeepJarAtLocation(ref, true, this.helper, this.refhelper));
                    continue;
                }
                if (this.ACTION_COPY.equals(action)) {
                    actions.add(new SharableLibrariesUtils.CopyJars(this.refhelper, this.helper, ref));
                    continue;
                }
                assert (false) : "no handling defined for action: " + action;
                continue;
            }
            if (!(item instanceof AntArtifact)) continue;
        }
        wiz.putProperty("actions", actions);
    }

    private void createTableDefinition() {
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 1;
            }
        };
        this.model.addColumn("jar");
        this.model.addColumn("action");
        this.tblJars.setModel(this.model);
        TableColumn col1 = this.tblJars.getColumn("jar");
        col1.setHeaderValue(Bundle.tblJars_header1());
        col1.setResizable(true);
        col1.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String text = "";
                if (value instanceof Library) {
                    Library lib = (Library)value;
                    text = lib.getDisplayName();
                } else if (value instanceof String) {
                    String v = MakeSharableVisualPanel2.this.helper.getStandardPropertyEvaluator().evaluate((String)value);
                    File absFile = MakeSharableVisualPanel2.this.helper.resolveFile(v);
                    text = absFile.getAbsolutePath();
                }
                return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            }
        });
        TableColumn col2 = this.tblJars.getColumn("action");
        col2.setResizable(true);
        JComboBox<String> editorBox = new JComboBox<String>(this.comboValues);
        editorBox.setEditable(false);
        MyCellEditor ed = new MyCellEditor(editorBox);
        col2.setCellEditor(ed);
        col2.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String val = (String)value;
                if (table.getValueAt(row, 0) instanceof Library) {
                    if (MakeSharableVisualPanel2.this.ACTION_ABSOLUTE.equals(val)) {
                        val = Bundle.TXT_Absolute();
                    } else if (MakeSharableVisualPanel2.this.ACTION_COPY.equals(val)) {
                        val = Bundle.TXT_Copy();
                    } else if (MakeSharableVisualPanel2.this.ACTION_RELATIVE.equals(val)) {
                        val = Bundle.TXT_Keep();
                    } else if (MakeSharableVisualPanel2.this.ACTION_USE_LOCAL_LIBRARY.equals(val)) {
                        val = Bundle.TXT_UseLocal();
                    }
                } else if (MakeSharableVisualPanel2.this.ACTION_ABSOLUTE.equals(val)) {
                    val = Bundle.TXT_AbsoluteJar();
                } else if (MakeSharableVisualPanel2.this.ACTION_COPY.equals(val)) {
                    val = Bundle.TXT_CopyJar();
                } else if (MakeSharableVisualPanel2.this.ACTION_RELATIVE.equals(val)) {
                    val = Bundle.TXT_KeepJar();
                }
                return super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
            }
        });
        this.tblJars.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MakeSharableVisualPanel2.this.populateDescriptionField();
            }
        });
        this.tblJars.getSelectionModel().setSelectionMode(0);
        col2.setPreferredWidth(300);
        col2.setMinWidth(150);
        col2.setWidth(300);
        col2.setHeaderValue(Bundle.tblJars_header2());
    }

    private void initComponents() {
        this.lblHint = new JLabel();
        this.lblJars = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblJars = new JTable();
        this.lblDetails = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.taDetails = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"MakeSharableVisualPanel2.lblHint.text"));
        this.lblHint.setVerticalAlignment(1);
        this.lblJars.setLabelFor(this.tblJars);
        Mnemonics.setLocalizedText((JLabel)this.lblJars, (String)NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"MakeSharableVisualPanel2.lblJars.text"));
        this.tblJars.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.tblJars);
        this.tblJars.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"ACSD_lblJars"));
        this.lblDetails.setLabelFor(this.taDetails);
        Mnemonics.setLocalizedText((JLabel)this.lblDetails, (String)NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"MakeSharableVisualPanel2.lblDetails.text"));
        this.taDetails.setColumns(20);
        this.taDetails.setRows(5);
        this.jScrollPane2.setViewportView(this.taDetails);
        this.taDetails.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"ACSD_lblDetails"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblJars).addContainerGap()).addComponent(this.lblHint, -1, 469, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 469, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblDetails).addContainerGap()).addComponent(this.jScrollPane2, -1, 469, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblHint, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblJars).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDetails).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 60, Short.MAX_VALUE)));
        this.lblJars.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"ACSD_lblJars"));
        this.lblDetails.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"ACSD_lblDetails"));
    }

    private void populateTable(AntProjectHelper helper, List<String> libraries, List<String> jars) {
        this.createTableDefinition();
        try {
            String action;
            File libraryFile = helper.resolveFile(this.location);
            File prjDir = FileUtil.toFile((FileObject)helper.getProjectDirectory());
            boolean absoluteLibrary = LibrariesSupport.convertFilePathToURI((String)this.location).isAbsolute();
            LibraryManager newmanager = LibraryManager.forLocation((URL)Utilities.toURI((File)libraryFile).toURL());
            LibraryManager oldmanager = LibraryManager.getDefault();
            for (String lib : libraries) {
                Library library = oldmanager.getLibrary(lib);
                Library newLib = newmanager.getLibrary(lib);
                action = this.ACTION_COPY;
                if (newLib != null) {
                    action = this.ACTION_USE_LOCAL_LIBRARY;
                }
                if (library == null) continue;
                this.model.addRow(new Object[]{library, action});
            }
            for (String jar : jars) {
                if (jar != null) {
                    String value = helper.getStandardPropertyEvaluator().evaluate(jar);
                    if (!value.startsWith("${")) {
                        File jarFile = helper.resolveFile(value);
                        action = this.ACTION_COPY;
                        if (CollocationQuery.areCollocated((File)prjDir, (File)jarFile)) {
                            action = this.ACTION_RELATIVE;
                        } else if (absoluteLibrary && CollocationQuery.areCollocated((File)libraryFile.getParentFile(), (File)jarFile)) {
                            action = this.ACTION_ABSOLUTE;
                        } else if (CollocationQuery.areCollocated((File)libraryFile.getParentFile(), (File)jarFile)) {
                            action = this.ACTION_RELATIVE;
                        }
                        this.model.addRow(new Object[]{jar, action});
                        continue;
                    }
                    Logger.getLogger(MakeSharableVisualPanel2.class.getName()).info("Cannot find jar reference:" + jar);
                    continue;
                }
                Logger.getLogger(MakeSharableVisualPanel2.class.getName()).info("Cannot find jar reference:" + jar);
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void populateDescriptionField() {
        int row = this.tblJars.getSelectedRow();
        if (row != -1) {
            Object val = this.tblJars.getModel().getValueAt(row, 0);
            if (val instanceof Library) {
                Library lib = (Library)val;
                String type = lib.getType();
                LibraryTypeProvider provider = LibrariesSupport.getLibraryTypeProvider((String)type);
                assert (provider != null);
                String typeString = provider.getDisplayName();
                String[] volumes = provider.getSupportedVolumeTypes();
                StringBuffer contents = new StringBuffer();
                for (String vol : volumes) {
                    List urls = lib.getContent(vol);
                    for (URL url : urls) {
                        FileObject fo = URLMapper.findFileObject((URL)url);
                        if (fo != null && FileUtil.getArchiveFile((FileObject)fo) != null) {
                            url = URLMapper.findURL((FileObject)FileUtil.getArchiveFile((FileObject)fo), (int)1);
                        }
                        if ("file".equals(url.getProtocol())) {
                            contents.append(FileUtil.getFileDisplayName((FileObject)fo)).append("\n");
                            continue;
                        }
                        contents.append(url).append("\n");
                    }
                }
                this.taDetails.setText(Bundle.LBL_LIbraryContent(typeString, contents));
            } else if (val instanceof String) {
                String ref = (String)val;
                String value = this.helper.getStandardPropertyEvaluator().evaluate(ref);
                File absFile = this.helper.resolveFile(value);
                Object text = Bundle.LBL_BinaryDesc(absFile.getAbsolutePath());
                String source = ref.replace("${file.reference", "${source.reference");
                value = this.helper.getStandardPropertyEvaluator().evaluate(source);
                if (!value.startsWith("${source.")) {
                    absFile = this.helper.resolveFile(value);
                    text = (String)text + Bundle.LBL_SourcesDesc(absFile.getAbsolutePath());
                }
                String javadoc = ref.replace("${file.reference", "${javadoc.reference");
                value = this.helper.getStandardPropertyEvaluator().evaluate(javadoc);
                if (!value.startsWith("${javadoc.")) {
                    absFile = this.helper.resolveFile(value);
                    text = (String)text + Bundle.LBL_JavadocDesc(absFile.getAbsolutePath());
                }
                this.taDetails.setText((String)text);
            }
        } else {
            this.taDetails.setText(Bundle.LBL_DescNoItems());
        }
    }

    private class MyCellEditor
    extends DefaultCellEditor {
        private JComboBox cb;
        private DefaultListCellRenderer library;
        private DefaultListCellRenderer jar;

        MyCellEditor(JComboBox combo) {
            super(combo);
            this.cb = combo;
            this.library = new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String val = (String)value;
                    if (MakeSharableVisualPanel2.this.ACTION_ABSOLUTE.equals(val)) {
                        val = Bundle.TXT_Absolute();
                    } else if (MakeSharableVisualPanel2.this.ACTION_COPY.equals(val)) {
                        val = Bundle.TXT_Copy();
                    } else if (MakeSharableVisualPanel2.this.ACTION_RELATIVE.equals(val)) {
                        val = Bundle.TXT_Keep();
                    } else if (MakeSharableVisualPanel2.this.ACTION_USE_LOCAL_LIBRARY.equals(val)) {
                        val = Bundle.TXT_UseLocal();
                    }
                    return super.getListCellRendererComponent((JList<?>)list, val, index, isSelected, cellHasFocus);
                }
            };
            this.jar = new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String val = (String)value;
                    if (MakeSharableVisualPanel2.this.ACTION_ABSOLUTE.equals(val)) {
                        val = Bundle.TXT_AbsoluteJar();
                    } else if (MakeSharableVisualPanel2.this.ACTION_COPY.equals(val)) {
                        val = Bundle.TXT_CopyJar();
                    } else if (MakeSharableVisualPanel2.this.ACTION_RELATIVE.equals(val)) {
                        val = Bundle.TXT_KeepJar();
                    } else if (MakeSharableVisualPanel2.this.ACTION_USE_LOCAL_LIBRARY.equals(val)) {
                        val = Bundle.TXT_UseLocalJar();
                    }
                    return super.getListCellRendererComponent((JList<?>)list, val, index, isSelected, cellHasFocus);
                }
            };
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (table.getValueAt(row, 0) instanceof Library) {
                this.cb.setRenderer(this.library);
                this.cb.setModel(new DefaultComboBoxModel<String>(MakeSharableVisualPanel2.this.comboValues));
            } else {
                this.cb.setRenderer(this.jar);
                this.cb.setModel(new DefaultComboBoxModel<String>(MakeSharableVisualPanel2.this.comboValuesJar));
            }
            super.getTableCellEditorComponent(table, value, isSelected, row, column);
            return this.cb;
        }
    }

    private class XSizer
    extends JLabel
    implements TableCellRenderer {
        private XSizer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText("" + value);
            return this;
        }
    }
}

