/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.net.URL;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;

class ModuleLocation
implements JavaFileManager.Location {
    private final JavaFileManager.Location base;
    private final String moduleName;
    private final Collection<? extends URL> moduleRoots;

    ModuleLocation(@NonNull JavaFileManager.Location base, @NonNull String moduleName, @NonNull Collection<? extends URL> moduleRoots) {
        assert (base != null);
        assert (moduleName != null);
        assert (moduleRoots != null);
        this.base = base;
        this.moduleName = moduleName;
        this.moduleRoots = moduleRoots;
    }

    @Override
    @NonNull
    public String getName() {
        return this.moduleRoots.toString();
    }

    @Override
    public boolean isOutputLocation() {
        return this.base == StandardLocation.CLASS_OUTPUT;
    }

    public String toString() {
        return this.getName();
    }

    @NonNull
    String getModuleName() {
        return this.moduleName;
    }

    @NonNull
    Collection<? extends URL> getModuleRoots() {
        return this.moduleRoots;
    }

    @NonNull
    JavaFileManager.Location getBaseLocation() {
        return this.base;
    }

    @NonNull
    static ModuleLocation cast(@NonNull JavaFileManager.Location l) {
        if (!ModuleLocation.isInstance(l)) {
            throw new IllegalArgumentException(String.valueOf(l));
        }
        return (ModuleLocation)l;
    }

    static boolean isInstance(JavaFileManager.Location l) {
        return l instanceof ModuleLocation;
    }

    @NonNull
    static ModuleLocation create(@NonNull JavaFileManager.Location base, @NonNull Collection<? extends URL> moduleRoots, @NonNull String moduleName) {
        return new ModuleLocation(base, moduleName, moduleRoots);
    }

    static final class WithExcludes
    extends ModuleLocation {
        private final Collection<? extends ClassPath.Entry> moduleEntries;

        private WithExcludes(JavaFileManager.Location base, String moduleName, Collection<? extends ClassPath.Entry> moduleEntries) {
            super(base, moduleName, moduleEntries.stream().map(entry -> entry.getURL()).collect(Collectors.toSet()));
            this.moduleEntries = moduleEntries;
        }

        @NonNull
        Collection<? extends ClassPath.Entry> getModuleEntries() {
            return this.moduleEntries;
        }

        @NonNull
        static WithExcludes cast(@NonNull JavaFileManager.Location l) {
            if (!WithExcludes.isInstance(l)) {
                throw new IllegalArgumentException(String.valueOf(l));
            }
            return (WithExcludes)l;
        }

        static boolean isInstance(JavaFileManager.Location l) {
            return l instanceof WithExcludes;
        }

        @NonNull
        static WithExcludes createExcludes(@NonNull JavaFileManager.Location base, @NonNull Collection<? extends ClassPath.Entry> moduleEntries, @NonNull String moduleName) {
            return new WithExcludes(base, moduleName, moduleEntries);
        }
    }
}

