/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class AttrTableModel
extends AbstractTableModel {
    private String[] colheaders = null;
    private Object[][] data = null;
    private int numCols;
    private int numRows = 0;

    public AttrTableModel() {
    }

    AttrTableModel(String[] headers) {
        this.colheaders = headers;
        this.numCols = this.colheaders.length;
    }

    AttrTableModel(String[] headers, Object[][] data) {
        this.colheaders = headers;
        this.numCols = this.colheaders.length;
        this.data = data;
        this.numRows = data.length;
    }

    @Override
    public String getColumnName(int col) {
        String key = "LBL_" + this.colheaders[col];
        return NbBundle.getMessage(AttrTableModel.class, (String)key);
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public int getColumnCount() {
        return this.numCols;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public int addRow(String name, String type, boolean required, boolean rtexpr) {
        Object[][] data2 = new Object[this.numRows + 1][this.numCols];
        boolean i = false;
        int j = 0;
        if (this.numRows > 0) {
            for (j = 0; j < this.numRows; ++j) {
                data2[j] = this.data[j];
            }
        }
        data2[j][0] = name;
        data2[j][1] = type;
        data2[j][2] = required;
        data2[j][3] = rtexpr;
        this.data = data2;
        ++this.numRows;
        return j;
    }

    public void removeRow(int row) {
        Object[][] data2 = new Object[this.numRows - 1][this.numCols];
        int newRowIndex = 0;
        for (int i = 0; i < this.numRows; ++i) {
            if (i == row) continue;
            data2[newRowIndex] = this.data[i];
            ++newRowIndex;
        }
        this.data = data2;
        --this.numRows;
    }

    public void setData(String name, String value, boolean required, boolean rtexpr, int row) {
        this.data[row][0] = name;
        this.data[row][1] = value;
        this.data[row][2] = required;
        this.data[row][3] = rtexpr;
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public Object[][] getAttributes() {
        if (this.data == null) {
            return new Object[0][];
        }
        return this.data;
    }
}

