/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer;

import com.oracle.bmc.util.internal.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(UploadConfiguration.class);
    public static final int MAXIMUM_NUM_ALLOWED_PARTS = 10000;
    public static final long MINIMUM_ALLOWED_LENGTH_PER_PART_MB = 1L;
    public static final long MAXIMUM_ALLOWED_LENGTH_PER_PART_MB = 51200L;
    private static final int DEFAULT_MIN_LENGTH_FOR_MULTI_PART_UPLOAD = 128;
    private static final int DEFAULT_LENGTH_PER_UPLOAD_PART = 128;
    private final long minimumLengthForMultipartUpload;
    private final long lengthPerUploadPart;
    @Deprecated
    private final int maxPartsForMultipartUpload;
    private final boolean enforceMd5BeforeUpload;
    private final boolean enforceMd5BeforeMultipartUpload;
    private final boolean allowMultipartUploads;
    private final boolean allowParallelUploads;
    private final boolean disableAutoAbort;

    @Deprecated
    public long getMinimumLengthPerUploadPart() {
        return this.lengthPerUploadPart;
    }

    private UploadConfiguration(Integer minimumLengthForMultipartUpload, Integer lengthPerUploadPart, Boolean enforceMd5BeforeUpload, Boolean enforceMd5BeforeMultipartUpload, Boolean allowMultipartUploads, Boolean allowParallelUploads, Boolean disableAutoAbort) {
        this.minimumLengthForMultipartUpload = UploadConfiguration.getOrDefault(minimumLengthForMultipartUpload, 128).intValue();
        this.lengthPerUploadPart = UploadConfiguration.getOrDefault(lengthPerUploadPart, 128).intValue();
        this.maxPartsForMultipartUpload = 10000;
        this.enforceMd5BeforeUpload = UploadConfiguration.getOrDefault(enforceMd5BeforeUpload, false);
        this.enforceMd5BeforeMultipartUpload = UploadConfiguration.getOrDefault(enforceMd5BeforeMultipartUpload, false);
        this.allowMultipartUploads = UploadConfiguration.getOrDefault(allowMultipartUploads, true);
        this.allowParallelUploads = UploadConfiguration.getOrDefault(allowParallelUploads, true);
        this.disableAutoAbort = UploadConfiguration.getOrDefault(disableAutoAbort, false);
        Validate.isTrue((this.minimumLengthForMultipartUpload >= 0L ? 1 : 0) != 0, (String)String.format("minimumLengthForMultipartUpload [%s] must be greater than or equal to %s", this.minimumLengthForMultipartUpload, 0L), (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)51200L, (long)this.lengthPerUploadPart, (String)String.format("lengthPerUploadPart [%s] must be between %s-%s (inclusive)", this.lengthPerUploadPart, 1L, 51200L), (Object[])new Object[0]);
    }

    private static <T> T getOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static UploadConfigurationBuilder builder() {
        return new UploadConfigurationBuilder();
    }

    public long getMinimumLengthForMultipartUpload() {
        return this.minimumLengthForMultipartUpload;
    }

    public long getLengthPerUploadPart() {
        return this.lengthPerUploadPart;
    }

    @Deprecated
    public int getMaxPartsForMultipartUpload() {
        return this.maxPartsForMultipartUpload;
    }

    public boolean isEnforceMd5BeforeUpload() {
        return this.enforceMd5BeforeUpload;
    }

    public boolean isEnforceMd5BeforeMultipartUpload() {
        return this.enforceMd5BeforeMultipartUpload;
    }

    public boolean isAllowMultipartUploads() {
        return this.allowMultipartUploads;
    }

    public boolean isAllowParallelUploads() {
        return this.allowParallelUploads;
    }

    public boolean isDisableAutoAbort() {
        return this.disableAutoAbort;
    }

    public String toString() {
        return "UploadConfiguration(minimumLengthForMultipartUpload=" + this.getMinimumLengthForMultipartUpload() + ", lengthPerUploadPart=" + this.getLengthPerUploadPart() + ", maxPartsForMultipartUpload=" + this.getMaxPartsForMultipartUpload() + ", enforceMd5BeforeUpload=" + this.isEnforceMd5BeforeUpload() + ", enforceMd5BeforeMultipartUpload=" + this.isEnforceMd5BeforeMultipartUpload() + ", allowMultipartUploads=" + this.isAllowMultipartUploads() + ", allowParallelUploads=" + this.isAllowParallelUploads() + ", disableAutoAbort=" + this.isDisableAutoAbort() + ")";
    }

    public static class UploadConfigurationBuilder {
        private Integer minimumLengthForMultipartUpload;
        private Integer lengthPerUploadPart;
        private Boolean enforceMd5BeforeUpload;
        private Boolean enforceMd5BeforeMultipartUpload;
        private Boolean allowMultipartUploads;
        private Boolean allowParallelUploads;
        private Boolean disableAutoAbort;

        public UploadConfigurationBuilder enforceMd5(Boolean enforceMd5) {
            this.enforceMd5BeforeUpload = enforceMd5;
            this.enforceMd5BeforeMultipartUpload = enforceMd5;
            return this;
        }

        @Deprecated
        public UploadConfigurationBuilder maxPartsForMultipartUpload(Integer maxPartsForMultipartUpload) {
            LOG.info("Configuring MaxPartsForMultipartUpload is deprecated and is ignored. Using value of {}", (Object)10000);
            return this;
        }

        @Deprecated
        public UploadConfigurationBuilder minimumLengthPerUploadPart(Integer minimumLengthPerUploadPart) {
            LOG.info("MinimumLengthPerUploadPart is deprecated.  Setting lengthPerUploadPart to {} instead", (Object)minimumLengthPerUploadPart);
            this.lengthPerUploadPart = minimumLengthPerUploadPart;
            return this;
        }

        UploadConfigurationBuilder() {
        }

        public UploadConfigurationBuilder minimumLengthForMultipartUpload(Integer minimumLengthForMultipartUpload) {
            this.minimumLengthForMultipartUpload = minimumLengthForMultipartUpload;
            return this;
        }

        public UploadConfigurationBuilder lengthPerUploadPart(Integer lengthPerUploadPart) {
            this.lengthPerUploadPart = lengthPerUploadPart;
            return this;
        }

        public UploadConfigurationBuilder enforceMd5BeforeUpload(Boolean enforceMd5BeforeUpload) {
            this.enforceMd5BeforeUpload = enforceMd5BeforeUpload;
            return this;
        }

        public UploadConfigurationBuilder enforceMd5BeforeMultipartUpload(Boolean enforceMd5BeforeMultipartUpload) {
            this.enforceMd5BeforeMultipartUpload = enforceMd5BeforeMultipartUpload;
            return this;
        }

        public UploadConfigurationBuilder allowMultipartUploads(Boolean allowMultipartUploads) {
            this.allowMultipartUploads = allowMultipartUploads;
            return this;
        }

        public UploadConfigurationBuilder allowParallelUploads(Boolean allowParallelUploads) {
            this.allowParallelUploads = allowParallelUploads;
            return this;
        }

        public UploadConfigurationBuilder disableAutoAbort(Boolean disableAutoAbort) {
            this.disableAutoAbort = disableAutoAbort;
            return this;
        }

        public UploadConfiguration build() {
            return new UploadConfiguration(this.minimumLengthForMultipartUpload, this.lengthPerUploadPart, this.enforceMd5BeforeUpload, this.enforceMd5BeforeMultipartUpload, this.allowMultipartUploads, this.allowParallelUploads, this.disableAutoAbort);
        }

        public String toString() {
            return "UploadConfiguration.UploadConfigurationBuilder(minimumLengthForMultipartUpload=" + this.minimumLengthForMultipartUpload + ", lengthPerUploadPart=" + this.lengthPerUploadPart + ", enforceMd5BeforeUpload=" + this.enforceMd5BeforeUpload + ", enforceMd5BeforeMultipartUpload=" + this.enforceMd5BeforeMultipartUpload + ", allowMultipartUploads=" + this.allowMultipartUploads + ", allowParallelUploads=" + this.allowParallelUploads + ", disableAutoAbort=" + this.disableAutoAbort + ")";
        }
    }
}

