/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.behavior;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.Collection;
import java.util.Collections;

public abstract class ClientBehaviorContext {
    public static final String BEHAVIOR_SOURCE_PARAM_NAME = "jakarta.faces.source";
    public static final String BEHAVIOR_EVENT_PARAM_NAME = "jakarta.faces.behavior.event";

    public static ClientBehaviorContext createClientBehaviorContext(FacesContext context, UIComponent component, String eventName, String sourceId, Collection<Parameter> parameters) {
        return new ClientBehaviorContextImpl(context, component, eventName, sourceId, parameters);
    }

    public abstract FacesContext getFacesContext();

    public abstract UIComponent getComponent();

    public abstract String getEventName();

    public abstract String getSourceId();

    public abstract Collection<Parameter> getParameters();

    public static class Parameter {
        private String name;
        private Object value;

        public Parameter(String name, Object value) {
            if (null == name) {
                throw new NullPointerException();
            }
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private static final class ClientBehaviorContextImpl
    extends ClientBehaviorContext {
        private FacesContext context;
        private UIComponent component;
        private String eventName;
        private String sourceId;
        private Collection<Parameter> parameters;

        private ClientBehaviorContextImpl(FacesContext context, UIComponent component, String eventName, String sourceId, Collection<Parameter> parameters) {
            if (null == context) {
                throw new NullPointerException();
            }
            if (null == component) {
                throw new NullPointerException();
            }
            if (null == eventName) {
                throw new NullPointerException();
            }
            this.context = context;
            this.component = component;
            this.eventName = eventName;
            this.sourceId = sourceId;
            this.parameters = parameters == null ? Collections.emptyList() : parameters;
        }

        @Override
        public FacesContext getFacesContext() {
            return this.context;
        }

        @Override
        public UIComponent getComponent() {
            return this.component;
        }

        @Override
        public String getEventName() {
            return this.eventName;
        }

        @Override
        public String getSourceId() {
            return this.sourceId;
        }

        @Override
        public Collection<Parameter> getParameters() {
            return this.parameters;
        }
    }
}

