/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.web.browser.api.ResizeOption;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ResizeOptions {
    private static final Logger LOGGER = Logger.getLogger(ResizeOptions.class.getName());
    private static final ResizeOptions INSTANCE = new ResizeOptions();

    private ResizeOptions() {
    }

    public static ResizeOptions getDefault() {
        return INSTANCE;
    }

    public synchronized List<ResizeOption> loadAll() {
        Preferences prefs = this.getPreferences();
        int count = prefs.getInt("count", 0);
        ArrayList<ResizeOption> res = new ArrayList<ResizeOption>(count);
        if (count == 0) {
            res.add(ResizeOption.create(ResizeOption.Type.DESKTOP, NbBundle.getMessage(ResizeOption.class, (String)"Lbl_DESKTOP"), 1280, 1024, true, true));
            res.add(ResizeOption.create(ResizeOption.Type.TABLET_LANDSCAPE, NbBundle.getMessage(ResizeOption.class, (String)"Lbl_TABLET_LANDSCAPE"), 1024, 768, true, true));
            res.add(ResizeOption.create(ResizeOption.Type.TABLET_PORTRAIT, NbBundle.getMessage(ResizeOption.class, (String)"Lbl_TABLET_PORTRAIT"), 768, 1024, true, true));
            res.add(ResizeOption.create(ResizeOption.Type.SMARTPHONE_LANDSCAPE, NbBundle.getMessage(ResizeOption.class, (String)"Lbl_SMARTPHONE_LANDSCAPE"), 480, 320, true, true));
            res.add(ResizeOption.create(ResizeOption.Type.SMARTPHONE_PORTRAIT, NbBundle.getMessage(ResizeOption.class, (String)"Lbl_SMARTPHONE_PORTRAIT"), 320, 480, true, true));
            res.add(ResizeOption.create(ResizeOption.Type.WIDESCREEN, NbBundle.getMessage(ResizeOption.class, (String)"Lbl_WIDESCREEN"), 1680, 1050, false, true));
            res.add(ResizeOption.create(ResizeOption.Type.NETBOOK, NbBundle.getMessage(ResizeOption.class, (String)"Lbl_NETBOOK"), 1024, 600, false, true));
        } else {
            for (int i = 0; i < count; ++i) {
                Preferences node = prefs.node("option" + i);
                ResizeOption option = this.load(node);
                if (option == null) continue;
                res.add(option);
            }
        }
        return res;
    }

    public synchronized void saveAll(List<ResizeOption> options) {
        int i;
        Preferences prefs = this.getPreferences();
        int count = prefs.getInt("count", 0);
        try {
            for (i = 0; i < count; ++i) {
                prefs.node("option" + i).removeNode();
            }
        }
        catch (BackingStoreException e) {
            LOGGER.log(Level.FINE, null, e);
        }
        prefs.putInt("count", options.size());
        for (i = 0; i < options.size(); ++i) {
            Preferences node = prefs.node("option" + i);
            this.save(node, options.get(i));
        }
    }

    private void save(Preferences prefs, ResizeOption option) {
        prefs.put("displayName", option.getDisplayName());
        prefs.putInt("width", option.getWidth());
        prefs.putInt("height", option.getHeight());
        prefs.putBoolean("toolbar", option.isShowInToolbar());
        prefs.putBoolean("default", option.isDefault());
        prefs.put("type", option.getType().name());
    }

    private ResizeOption load(Preferences prefs) {
        String name = prefs.get("displayName", null);
        int width = prefs.getInt("width", -1);
        int height = prefs.getInt("height", -1);
        boolean toolbar = prefs.getBoolean("toolbar", false);
        boolean isDefault = prefs.getBoolean("default", false);
        ResizeOption.Type type = ResizeOption.Type.valueOf(prefs.get("type", null));
        try {
            return ResizeOption.create(type, name, width, height, toolbar, isDefault);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Error while loading resize options.", e);
            return null;
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(ResizeOptions.class).node("resize_options");
    }
}

