/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.LocalNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.NbLocalNativeProcess;
import org.netbeans.modules.nativeexecution.NbRemoteNativeProcess;
import org.netbeans.modules.nativeexecution.PtyNativeProcess;
import org.netbeans.modules.nativeexecution.RemoteNativeProcess;
import org.netbeans.modules.nativeexecution.TerminalLocalNativeProcess;
import org.netbeans.modules.nativeexecution.api.Bundle;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.ShellValidationSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.pty.NbStartUtility;
import org.netbeans.modules.nativeexecution.spi.support.NativeExecutionUserNotification;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

public final class NativeProcessBuilder
implements Callable<Process> {
    private final NativeProcessInfo info;
    private ExternalTerminal externalTerminal = null;

    private NativeProcessBuilder(ExecutionEnvironment execEnv) {
        this.info = new NativeProcessInfo(execEnv);
    }

    public static NativeProcessBuilder newProcessBuilder(ExecutionEnvironment execEnv) {
        return new NativeProcessBuilder(execEnv);
    }

    public static NativeProcessBuilder newLocalProcessBuilder() {
        return new NativeProcessBuilder(ExecutionEnvironmentFactory.getLocal());
    }

    public NativeProcessBuilder redirectError() {
        this.info.redirectError(true);
        return this;
    }

    public boolean redirectErrorStream() {
        return this.info.isRedirectError();
    }

    public NativeProcessBuilder setExecutable(String executable) {
        this.info.setExecutable(executable);
        return this;
    }

    public NativeProcessBuilder setCommandLine(String commandLine) {
        this.info.setCommandLine(commandLine);
        return this;
    }

    public NativeProcessBuilder addNativeProcessListener(ChangeListener listener) {
        this.info.addChangeListener(listener);
        return this;
    }

    public NativeProcessBuilder removeNativeProcessListener(ChangeListener listener) {
        this.info.removeChangeListener(listener);
        return this;
    }

    public MacroMap getEnvironment() {
        return this.info.getEnvironment();
    }

    @Override
    public NativeProcess call() throws IOException {
        AbstractNativeProcess process = null;
        final ExecutionEnvironment execEnv = this.info.getExecutionEnvironment();
        if (this.info.getCommand() == null) {
            throw new IllegalStateException("No executable nor command line is specified");
        }
        if (!ConnectionManager.getInstance().isConnectedTo(execEnv)) {
            throw new UserQuestionException("No connection to " + execEnv.getDisplayName()){

                public void confirmed() throws IOException {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            ConnectionManager.getInstance().connect(execEnv);
                        }
                    });
                }

                public String getLocalizedMessage() {
                    return Bundle.EXC_NotConnectedQuestion(execEnv.getDisplayName());
                }
            };
        }
        if (this.externalTerminal == null && NbStartUtility.getInstance().isSupported(this.info.getExecutionEnvironment())) {
            process = this.info.getExecutionEnvironment().isLocal() ? new NbLocalNativeProcess(this.info) : new NbRemoteNativeProcess(this.info);
        } else if (this.info.isPtyMode() && PtySupport.isSupportedFor(this.info.getExecutionEnvironment())) {
            process = new PtyNativeProcess(this.info);
        } else {
            if (this.info.getExecutionEnvironment().isRemote()) {
                process = new RemoteNativeProcess(this.info);
            } else if (this.externalTerminal != null) {
                boolean canProceed = true;
                boolean available = this.externalTerminal.isAvailable(this.info.getExecutionEnvironment());
                if (!available) {
                    if (Boolean.getBoolean("nativeexecution.mode.unittest") || "true".equals(System.getProperty("cnd.command.line.utility"))) {
                        System.err.println(NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoTermianl.text", new String[0]));
                    } else {
                        NativeExecutionUserNotification.getDefault().notify(NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoTermianl.text", new String[0]), NativeExecutionUserNotification.Descriptor.WARNING);
                    }
                    canProceed = false;
                } else {
                    if (Utilities.isWindows()) {
                        Shell shell = WindowsSupport.getInstance().getActiveShell();
                        if (shell == null) {
                            if (Boolean.getBoolean("nativeexecution.mode.unittest") || "true".equals(System.getProperty("cnd.command.line.utility"))) {
                                System.err.println(NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoShell.text", new String[0]));
                            } else {
                                NativeExecutionUserNotification.getDefault().notify(NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoShell.text", new String[0]), NativeExecutionUserNotification.Descriptor.WARNING);
                            }
                            canProceed = false;
                        } else {
                            ShellValidationSupport.ShellValidationStatus validationStatus = ShellValidationSupport.getValidationStatus(shell);
                            if (!validationStatus.isValid()) {
                                canProceed = ShellValidationSupport.confirm(NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.BrokenShellConfirmationHeader.text", new String[0]), NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.BrokenShellConfirmationFooter.text", new String[0]), validationStatus);
                            }
                        }
                    }
                    if (canProceed) {
                        process = new TerminalLocalNativeProcess(this.info, this.externalTerminal);
                    }
                }
            }
            if (process == null) {
                process = new LocalNativeProcess(this.info);
            }
        }
        return process.createAndStart();
    }

    public NativeProcessBuilder setWorkingDirectory(String workingDirectory) {
        this.info.setWorkingDirectory(workingDirectory);
        return this;
    }

    public NativeProcessBuilder setArguments(String ... arguments) {
        this.info.setArguments(arguments);
        return this;
    }

    public NativeProcessBuilder useExternalTerminal(ExternalTerminal terminal) {
        this.externalTerminal = terminal;
        return this;
    }

    public NativeProcessBuilder unbufferOutput(boolean unbuffer) {
        this.info.setUnbuffer(unbuffer);
        return this;
    }

    public NativeProcessBuilder setX11Forwarding(boolean x11forwarding) {
        if (Boolean.getBoolean("cnd.remote.noX11")) {
            return this;
        }
        this.info.setX11Forwarding(x11forwarding);
        return this;
    }

    public NativeProcessBuilder setInitialSuspend(boolean suspend) {
        this.info.setInitialSuspend(suspend);
        return this;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(NativeProcessBuilder.class, (String)key, (Object[])params);
    }

    public NativeProcessBuilder setUsePty(boolean usePty) {
        this.info.setPtyMode(usePty);
        return this;
    }

    public NativeProcessBuilder setMacroExpansion(boolean expandMacros) {
        this.info.setExpandMacros(expandMacros);
        return this;
    }

    public NativeProcessBuilder setCharset(Charset charset) {
        this.info.setCharset(charset);
        return this;
    }

    public NativeProcessBuilder setStatusEx(boolean b) {
        this.info.setStatusEx(b);
        return this;
    }
}

