/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.cache;

import java.lang.ref.SoftReference;
import java.time.Duration;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class ExpiringCache<V> {
    private final long expiry;
    private final Supplier<@Nullable V> action;
    private SoftReference<@Nullable V> value = new SoftReference<Object>(null);
    private long expiresAt;

    public ExpiringCache(Duration expiry, Supplier<@Nullable V> action) {
        if (expiry.isNegative() || expiry.isZero()) {
            throw new IllegalArgumentException("Cache expire time must be greater than 0");
        }
        this.expiry = expiry.toNanos();
        this.action = action;
    }

    public ExpiringCache(long expiry, Supplier<@Nullable V> action) {
        this(Duration.ofMillis(expiry), action);
    }

    public synchronized @Nullable V getValue() {
        @Nullable V cachedValue = this.value.get();
        if (cachedValue == null || this.isExpired()) {
            return this.refreshValue();
        }
        return cachedValue;
    }

    public final synchronized void putValue(@Nullable V value) {
        this.value = new SoftReference<V>(value);
        this.expiresAt = this.calcExpiresAt();
    }

    public final synchronized void invalidateValue() {
        this.value = new SoftReference<Object>(null);
        this.expiresAt = 0L;
    }

    public synchronized @Nullable V refreshValue() {
        @Nullable V freshValue = this.action.get();
        this.value = new SoftReference<V>(freshValue);
        this.expiresAt = this.calcExpiresAt();
        return freshValue;
    }

    public boolean isExpired() {
        return this.expiresAt < System.nanoTime();
    }

    private long calcExpiresAt() {
        return System.nanoTime() + this.expiry;
    }
}

