/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.AnsiRenderKt;
import com.github.ajalt.mordant.internal.MppImplKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.terminal.ConversionResult;
import com.github.ajalt.mordant.terminal.DisabledTerminalCursor;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.Prompt;
import com.github.ajalt.mordant.terminal.StdoutTerminalInterface;
import com.github.ajalt.mordant.terminal.TerminalColors;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import com.github.ajalt.mordant.widgets.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BW\b\u0016\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\rB%\b\u0016\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B5\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b)J?\u0010*\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00102J\u0006\u00103\u001a\u00020\u0000J?\u0010\u001e\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00102J?\u00104\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00102J\u000e\u00105\u001a\u00020'2\u0006\u00106\u001a\u000207J?\u00105\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00102J\u0006\u00108\u001a\u00020'J\u000e\u00108\u001a\u00020'2\u0006\u00106\u001a\u000207J?\u00108\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00102J\u008b\u0001\u00109\u001a\u0004\u0018\u0001H:\"\u0004\b\u0000\u0010:2\u0006\u00109\u001a\u00020;2\n\b\u0002\u0010<\u001a\u0004\u0018\u0001H:2\b\b\u0002\u0010=\u001a\u00020\n2\b\b\u0002\u0010>\u001a\u00020\n2\b\b\u0002\u0010?\u001a\u00020\n2\u000e\b\u0002\u0010@\u001a\b\u0012\u0004\u0012\u0002H:0A2\b\b\u0002\u0010B\u001a\u00020;2\b\b\u0002\u0010C\u001a\u00020;2\u001a\b\u0004\u0010D\u001a\u0014\u0012\u0004\u0012\u00020;\u0012\n\u0012\b\u0012\u0004\u0012\u0002H:0F0EH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ^\u00109\u001a\u0004\u0018\u00010;2\u0006\u00109\u001a\u00020;2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010;2\b\b\u0002\u0010=\u001a\u00020\n2\b\b\u0002\u0010>\u001a\u00020\n2\b\b\u0002\u0010?\u001a\u00020\n2\u000e\b\u0002\u0010@\u001a\b\u0012\u0004\u0012\u00020;0A2\b\b\u0002\u0010B\u001a\u00020;2\b\b\u0002\u0010C\u001a\u00020;J\u0010\u0010H\u001a\u00020'2\u0006\u0010+\u001a\u00020;H\u0002J\u0010\u0010I\u001a\u00020'2\u0006\u0010+\u001a\u00020;H\u0002J\u0010\u0010J\u001a\u0004\u0018\u00010;2\u0006\u0010?\u001a\u00020\nJ\u0015\u0010K\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bLJ\u000e\u0010M\u001a\u00020;2\u0006\u00106\u001a\u000207J?\u0010M\u001a\u00020;2\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010NJ\u0010\u0010O\u001a\u00020'2\u0006\u0010P\u001a\u00020QH\u0002J?\u0010R\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00102J?\u0010S\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00102R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006T"}, d2={"Lcom/github/ajalt/mordant/terminal/Terminal;", "", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "theme", "Lcom/github/ajalt/mordant/rendering/Theme;", "width", "", "height", "hyperlinks", "", "tabWidth", "interactive", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;Lcom/github/ajalt/mordant/rendering/Theme;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;ILjava/lang/Boolean;)V", "terminalInterface", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "(Lcom/github/ajalt/mordant/rendering/Theme;ILcom/github/ajalt/mordant/terminal/TerminalInterface;)V", "interceptors", "", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "lock", "(Lcom/github/ajalt/mordant/rendering/Theme;ILcom/github/ajalt/mordant/terminal/TerminalInterface;Ljava/util/List;Ljava/lang/Object;)V", "colors", "Lcom/github/ajalt/mordant/terminal/TerminalColors;", "getColors", "()Lcom/github/ajalt/mordant/terminal/TerminalColors;", "cursor", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "getCursor", "()Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "getInfo", "()Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "getTabWidth", "()I", "getTheme", "()Lcom/github/ajalt/mordant/rendering/Theme;", "addInterceptor", "", "interceptor", "addInterceptor$mordant", "danger", "message", "whitespace", "Lcom/github/ajalt/mordant/rendering/Whitespace;", "align", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "overflowWrap", "Lcom/github/ajalt/mordant/rendering/OverflowWrap;", "(Ljava/lang/Object;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;)V", "forStdErr", "muted", "print", "widget", "Lcom/github/ajalt/mordant/rendering/Widget;", "println", "prompt", "T", "", "default", "showDefault", "showChoices", "hideInput", "choices", "", "promptSuffix", "invalidChoiceMessage", "convert", "Lkotlin/Function1;", "Lcom/github/ajalt/mordant/terminal/ConversionResult;", "(Ljava/lang/String;Ljava/lang/Object;ZZZLjava/util/Collection;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "rawPrint", "rawPrintln", "readLineOrNull", "removeInterceptor", "removeInterceptor$mordant", "render", "(Ljava/lang/Object;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;)Ljava/lang/String;", "sendPrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "success", "warning", "mordant"})
public final class Terminal {
    @NotNull
    private final Theme theme;
    private final int tabWidth;
    @NotNull
    private final TerminalInterface terminalInterface;
    @NotNull
    private final List<TerminalInterceptor> interceptors;
    @NotNull
    private final Object lock;
    @NotNull
    private final TerminalInfo info;
    @NotNull
    private final TerminalColors colors;
    @NotNull
    private final TerminalCursor cursor;

    private Terminal(Theme theme, int tabWidth, TerminalInterface terminalInterface, List<TerminalInterceptor> interceptors, Object lock) {
        this.theme = theme;
        this.tabWidth = tabWidth;
        this.terminalInterface = terminalInterface;
        this.interceptors = interceptors;
        this.lock = lock;
        this.info = this.terminalInterface.getInfo();
        this.colors = new TerminalColors(this.info, this.theme);
        this.cursor = this.info.getInteractive() ? MppImplKt.makePrintingTerminalCursor(this) : (TerminalCursor)DisabledTerminalCursor.INSTANCE;
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    public final int getTabWidth() {
        return this.tabWidth;
    }

    public Terminal(@Nullable AnsiLevel ansiLevel, @NotNull Theme theme, @Nullable Integer width, @Nullable Integer height, @Nullable Boolean hyperlinks, int tabWidth, @Nullable Boolean interactive) {
        Intrinsics.checkNotNullParameter(theme, "theme");
        this(theme, tabWidth, new StdoutTerminalInterface(ansiLevel, width, height, hyperlinks, interactive));
    }

    public /* synthetic */ Terminal(AnsiLevel ansiLevel, Theme theme, Integer n, Integer n2, Boolean bl, int n3, Boolean bl2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            ansiLevel = null;
        }
        if ((n4 & 2) != 0) {
            theme = Theme.Companion.getDefault();
        }
        if ((n4 & 4) != 0) {
            n = null;
        }
        if ((n4 & 8) != 0) {
            n2 = null;
        }
        if ((n4 & 0x10) != 0) {
            bl = null;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 8;
        }
        if ((n4 & 0x40) != 0) {
            bl2 = null;
        }
        this(ansiLevel, theme, n, n2, bl, n3, bl2);
    }

    public Terminal(@NotNull Theme theme, int tabWidth, @NotNull TerminalInterface terminalInterface) {
        Intrinsics.checkNotNullParameter(theme, "theme");
        Intrinsics.checkNotNullParameter(terminalInterface, "terminalInterface");
        this(theme, tabWidth, terminalInterface, new ArrayList(), new Object());
    }

    public /* synthetic */ Terminal(Theme theme, int n, TerminalInterface terminalInterface, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            theme = Theme.Companion.getDefault();
        }
        if ((n2 & 2) != 0) {
            n = 8;
        }
        if ((n2 & 4) != 0) {
            terminalInterface = new StdoutTerminalInterface(null, null, null, null, null);
        }
        this(theme, n, terminalInterface);
    }

    @NotNull
    public final TerminalInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final TerminalColors getColors() {
        return this.colors;
    }

    @NotNull
    public final TerminalCursor getCursor() {
        return this.cursor;
    }

    public final void success(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this.println(this.theme.getSuccess().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void success$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.success(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void danger(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this.println(this.theme.getDanger().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void danger$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.danger(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void warning(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this.println(this.theme.getWarning().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void warning$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.warning(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void info(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this.println(this.theme.getInfo().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void info$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.info(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void muted(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this.println(this.theme.getMuted().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void muted$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.muted(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void print(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this.rawPrint(this.render(message, whitespace2, align, overflowWrap2, width));
    }

    public static /* synthetic */ void print$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.print(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void println(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this.rawPrintln(this.render(message, whitespace2, align, overflowWrap2, width));
    }

    public static /* synthetic */ void println$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.println(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void print(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter(widget, "widget");
        this.rawPrint(this.render(widget));
    }

    public final void println(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter(widget, "widget");
        this.rawPrintln(this.render(widget));
    }

    public final void println() {
        this.sendPrintRequest(new PrintRequest("", true));
    }

    @NotNull
    public final String render(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        Object object = message;
        return object instanceof Lines ? AnsiRenderKt.renderLinesAnsi((Lines)message, this.info.getAnsiLevel(), this.info.getAnsiHyperLinks()) : (object instanceof Widget ? this.render((Widget)message) : this.render(new Text(String.valueOf(message), whitespace2, align, overflowWrap2, width, null, 32, null)));
    }

    public static /* synthetic */ String render$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        return terminal.render(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    @NotNull
    public final String render(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter(widget, "widget");
        return AnsiRenderKt.renderLinesAnsi(Widget.DefaultImpls.render$default(widget, this, 0, 2, null), this.info.getAnsiLevel(), this.info.getAnsiHyperLinks());
    }

    @NotNull
    public final Terminal forStdErr() {
        return new Terminal(this.theme, this.tabWidth, this.terminalInterface.forStdErr(), this.interceptors, this.lock);
    }

    @Nullable
    public final String readLineOrNull(boolean hideInput) {
        return this.terminalInterface.readLineOrNull(hideInput);
    }

    @Nullable
    public final <T> T prompt(@NotNull String prompt2, @Nullable T t, boolean showDefault, boolean showChoices, boolean hideInput, @NotNull Collection<? extends T> choices, @NotNull String promptSuffix, @NotNull String invalidChoiceMessage, @NotNull Function1<? super String, ? extends ConversionResult<? extends T>> convert2) {
        Intrinsics.checkNotNullParameter(prompt2, "prompt");
        Intrinsics.checkNotNullParameter(choices, "choices");
        Intrinsics.checkNotNullParameter(promptSuffix, "promptSuffix");
        Intrinsics.checkNotNullParameter(invalidChoiceMessage, "invalidChoiceMessage");
        Intrinsics.checkNotNullParameter(convert2, "convert");
        boolean $i$f$prompt = false;
        return new Prompt<T>(prompt2, this, t, showDefault, showChoices, hideInput, choices, promptSuffix, invalidChoiceMessage, convert2){
            final /* synthetic */ Function1<String, ConversionResult<T>> $convert;
            {
                this.$convert = $convert;
                super($prompt, $receiver, $default, $showDefault, $showChoices, $hideInput, $choices, $promptSuffix, $invalidChoiceMessage);
            }

            @NotNull
            protected ConversionResult<T> convert(@NotNull String input) {
                Intrinsics.checkNotNullParameter(input, "input");
                return this.$convert.invoke(input);
            }
        }.ask();
    }

    public static /* synthetic */ Object prompt$default(Terminal $this, String prompt2, Object object, boolean showDefault, boolean showChoices, boolean hideInput, Collection choices, String promptSuffix, String invalidChoiceMessage, Function1 convert2, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            showDefault = true;
        }
        if ((n & 8) != 0) {
            showChoices = true;
        }
        if ((n & 0x10) != 0) {
            hideInput = false;
        }
        if ((n & 0x20) != 0) {
            choices = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            promptSuffix = ": ";
        }
        if ((n & 0x80) != 0) {
            invalidChoiceMessage = "Invalid value, choose from ";
        }
        Intrinsics.checkNotNullParameter(prompt2, "prompt");
        Intrinsics.checkNotNullParameter(choices, "choices");
        Intrinsics.checkNotNullParameter(promptSuffix, "promptSuffix");
        Intrinsics.checkNotNullParameter(invalidChoiceMessage, "invalidChoiceMessage");
        Intrinsics.checkNotNullParameter(convert2, "convert");
        boolean $i$f$prompt = false;
        return new /* invalid duplicate definition of identical inner class */.ask();
    }

    @Nullable
    public final String prompt(@NotNull String prompt2, @Nullable String string, boolean showDefault, boolean showChoices, boolean hideInput, @NotNull Collection<String> choices, @NotNull String promptSuffix, @NotNull String invalidChoiceMessage) {
        Intrinsics.checkNotNullParameter(prompt2, "prompt");
        Intrinsics.checkNotNullParameter(choices, "choices");
        Intrinsics.checkNotNullParameter(promptSuffix, "promptSuffix");
        Intrinsics.checkNotNullParameter(invalidChoiceMessage, "invalidChoiceMessage");
        Terminal this_$iv = this;
        boolean $i$f$prompt = false;
        return (String)new Prompt<String>(prompt2, this_$iv, (Object)string, showDefault, showChoices, hideInput, choices, promptSuffix, invalidChoiceMessage){

            @NotNull
            protected ConversionResult<String> convert(@NotNull String input) {
                Intrinsics.checkNotNullParameter(input, "input");
                String it = input;
                boolean bl = false;
                return new ConversionResult.Valid<String>(it);
            }
        }.ask();
    }

    public static /* synthetic */ String prompt$default(Terminal terminal, String string, String string2, boolean bl, boolean bl2, boolean bl3, Collection collection, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            string3 = ": ";
        }
        if ((n & 0x80) != 0) {
            string4 = "Invalid value, choose from ";
        }
        return terminal.prompt(string, string2, bl, bl2, bl3, collection, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addInterceptor$mordant(@NotNull TerminalInterceptor interceptor) {
        Intrinsics.checkNotNullParameter(interceptor, "interceptor");
        Object lock$iv = this.lock;
        boolean $i$f$synchronizeJvm = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            ((Collection)this.interceptors).add(interceptor);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeInterceptor$mordant(@NotNull TerminalInterceptor interceptor) {
        Intrinsics.checkNotNullParameter(interceptor, "interceptor");
        Object lock$iv = this.lock;
        boolean $i$f$synchronizeJvm = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            this.interceptors.remove(interceptor);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void rawPrintln(String message) {
        this.sendPrintRequest(new PrintRequest(message, true));
    }

    private final void rawPrint(String message) {
        this.sendPrintRequest(new PrintRequest(message, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendPrintRequest(PrintRequest request) {
        Object lock$iv = this.lock;
        boolean $i$f$synchronizeJvm = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            MppImplKt.sendInterceptedPrintRequest(request, this.terminalInterface, this.interceptors);
            Unit unit = Unit.INSTANCE;
        }
    }
}

