/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.threads;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JToggleButton;
import org.graalvm.visualvm.lib.charts.axis.TimeAxisUtils;
import org.graalvm.visualvm.lib.jfluid.results.threads.ThreadData;
import org.graalvm.visualvm.lib.jfluid.results.threads.ThreadsDataManager;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;

public class ViewManager
extends ProfilerTableContainer.ColumnChangeAdapter {
    private static final int MIN_TIMEMARK_STEP = 120;
    public static final String PROP_NEW_OFFSET = "newOffset";
    private static final int MAX_ZOOM = 5;
    private static final int MIN_VIEW = 3;
    private final int column;
    private final ThreadsDataManager data;
    private final Map<Integer, RowView> rowViews;
    private int offset;
    private int width;
    private int prefWidth;
    private boolean fit = false;
    private double zoom;
    private double lastZoom = this.zoom = (double)0.03f;
    private Action zoomInAction;
    private Action zoomOutAction;
    private Action fitAction;
    private long firstTimeMark;
    private long _firstTimeMark;
    private long timeMarksStep;
    private String format;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.threads.Bundle");
    }

    public ViewManager(int column, ThreadsDataManager data) {
        this.column = column;
        this.data = data;
        this.updateTimeMarks(true);
        this.rowViews = new HashMap<Integer, RowView>();
    }

    public int zoomIn() {
        return this.setZoom(this.zoom * 1.2);
    }

    public int zoomOut() {
        return this.setZoom(this.zoom * 0.8);
    }

    public int setZoom(double zoom) {
        int newOffset = this.offset;
        if (this.zoom != zoom) {
            double oldZoom = this.zoom;
            this.zoomChanged(this.zoom, zoom);
            if (!this.isFit()) {
                double tt = (double)(this.offset + this.width / 2) / oldZoom;
                newOffset = Math.max((int)(tt * zoom - (double)(this.width / 2)), 0);
            }
            this.updateActions();
        }
        return newOffset;
    }

    public double getZoom() {
        return this.zoom;
    }

    public Action zoomInAction() {
        if (this.zoomInAction == null) {
            this.zoomInAction = new AbstractAction(null, Icons.getIcon((String)"GeneralIcons.ZoomIn")){
                {
                    this.putValue("ShortDescription", ViewManager.BUNDLE().getString("ACT_ZoomIn"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    int newOffset = ViewManager.this.zoomIn();
                    Integer _newOffset = newOffset == ViewManager.this.offset ? null : Integer.valueOf(newOffset);
                    ViewManager.this.zoomInAction.putValue(ViewManager.PROP_NEW_OFFSET, _newOffset);
                }
            };
        }
        return this.zoomInAction;
    }

    public Action zoomOutAction() {
        if (this.zoomOutAction == null) {
            this.zoomOutAction = new AbstractAction(null, Icons.getIcon((String)"GeneralIcons.ZoomOut")){
                {
                    this.putValue("ShortDescription", ViewManager.BUNDLE().getString("ACT_ZoomOut"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    int newOffset = ViewManager.this.zoomOut();
                    Integer _newOffset = newOffset == ViewManager.this.offset ? null : Integer.valueOf(newOffset);
                    ViewManager.this.zoomOutAction.putValue(ViewManager.PROP_NEW_OFFSET, _newOffset);
                }
            };
        }
        return this.zoomOutAction;
    }

    public Action fitAction() {
        if (this.fitAction == null) {
            this.fitAction = new AbstractAction(null, Icons.getIcon((String)"GeneralIcons.ScaleToFit")){
                {
                    this.putValue("ShortDescription", ViewManager.BUNDLE().getString("ACT_ScaleToFit"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object source = e.getSource();
                    if (source instanceof JToggleButton) {
                        ViewManager.this.fit = ((JToggleButton)source).isSelected();
                        if (ViewManager.this.fit) {
                            ViewManager.this.lastZoom = ViewManager.this.zoom;
                        } else {
                            ViewManager.this.zoom = ViewManager.this.lastZoom;
                        }
                        ViewManager.this.updateTimeMarks(true);
                        ViewManager.this.updateActions();
                    }
                }
            };
        }
        return this.fitAction;
    }

    private void updateActions() {
        if (this.zoomInAction != null) {
            this.zoomInAction.setEnabled(!this.isFit() && this.getViewWidth() > 0 && this.zoom <= 5.0);
        }
        if (this.zoomOutAction != null) {
            this.zoomOutAction.setEnabled(!this.isFit() && this.prefWidth >= this.width / 3);
        }
    }

    private long getFirstTime() {
        return this.data.getStartTime();
    }

    public int getViewWidth() {
        return (int)((double)this.getDataWidth() * this.zoom);
    }

    private int getDataWidth() {
        return (int)(this.data.getEndTime() - this.data.getStartTime());
    }

    public long getFirstTimeMark(boolean _offset) {
        return _offset ? this._firstTimeMark : this.firstTimeMark;
    }

    public long getTimeMarksStep() {
        return this.timeMarksStep;
    }

    public String getTimeMarksFormat() {
        return this.format;
    }

    public int getTimePosition(long time, boolean _offset) {
        return !_offset || this.isFit() ? (int)((double)(time - this.data.getStartTime()) * this.zoom) : (int)((double)(time - this.data.getStartTime()) * this.zoom) - this.offset;
    }

    private void updateTimeMarks(boolean updateStep) {
        if (updateStep) {
            this.timeMarksStep = TimeAxisUtils.getTimeUnits((double)this.zoom, (int)120);
        }
        long first = this.data.getStartTime();
        long _first = first + (long)((double)this.offset / this.zoom);
        this.firstTimeMark = first / this.timeMarksStep * this.timeMarksStep + this.timeMarksStep;
        this._firstTimeMark = _first / this.timeMarksStep * this.timeMarksStep + this.timeMarksStep;
        long last = first + (long)((double)this.width / this.zoom);
        this.format = TimeAxisUtils.getFormatString((long)this.timeMarksStep, (long)first, (long)last);
    }

    public RowView getRowView(int row) {
        RowView rowView = this.rowViews.get(row);
        if (rowView == null) {
            rowView = new RowView(this.data.getThreadData(row));
            this.rowViews.put(row, rowView);
        }
        return rowView;
    }

    public void update() {
        if (this.isFit()) {
            this.zoomChanged(this.zoom, (double)this.width / (double)this.getDataWidth());
        }
    }

    public void reset() {
        this.lastZoom = this.zoom = (double)0.03f;
        this.rowViews.clear();
        this.updateTimeMarks(true);
    }

    @Override
    public void columnOffsetChanged(int column, int oldO, int newO) {
        if (this.column != column) {
            return;
        }
        this.offset = newO;
        this.updateTimeMarks(false);
        for (RowView view : this.rowViews.values()) {
            view.offsetChanged(oldO, newO);
        }
    }

    @Override
    public void columnWidthChanged(int column, int oldW, int newW) {
        if (this.column != column) {
            return;
        }
        this.width = newW;
        if (!this.isFit()) {
            for (RowView view : this.rowViews.values()) {
                view.widthChanged(oldW, newW);
            }
        }
        this.updateActions();
    }

    @Override
    public void columnPreferredWidthChanged(int column, int oldW, int newW) {
        if (this.column != column) {
            return;
        }
        this.prefWidth = newW;
        this.updateTimeMarks(false);
        if (!this.isFit()) {
            for (RowView view : this.rowViews.values()) {
                view.preferredWidthChanged(oldW, newW);
            }
        }
        this.updateActions();
    }

    public void zoomChanged(double oldZoom, double newZoom) {
        this.zoom = newZoom;
        this.updateTimeMarks(true);
        for (RowView view : this.rowViews.values()) {
            view.zoomChanged(oldZoom, newZoom);
        }
    }

    public void setFit(boolean f) {
        this.fit = f;
    }

    public boolean isFit() {
        return this.fit;
    }

    private boolean isTrackingEnd() {
        return this.offset + this.width >= this.prefWidth;
    }

    private static enum Position {
        LEFT,
        WITHIN,
        RIGHT;

    }

    public class RowView
    implements Comparable<RowView> {
        private final ThreadData data;
        private int i = -1;
        private boolean lastMaxIn = true;

        RowView(ThreadData data) {
            this.data = data;
            if (this.getMaxIndex() >= 0) {
                this.i = this.findLastIndex();
            }
        }

        public int getLastIndex() {
            return this.i == Integer.MIN_VALUE || this.i == Integer.MAX_VALUE ? -1 : this.i;
        }

        public int getMaxIndex() {
            return this.data.size() - 1;
        }

        public long getTime(int index) {
            return this.data.getTimeStampAt(index);
        }

        public int getState(int index) {
            return this.data.getStateAt(index);
        }

        public int getPosition(long time) {
            return (int)((double)(time - ViewManager.this.getFirstTime()) * ViewManager.this.zoom);
        }

        public int getMaxPosition() {
            return ViewManager.this.getViewWidth();
        }

        private int findLastIndex() {
            if (ViewManager.this.isTrackingEnd() || ViewManager.this.isFit()) {
                return this.getMaxIndex();
            }
            this.i = Integer.MIN_VALUE;
            return this.findLastIndexLeft();
        }

        private int findLastIndexLeft() {
            if (this.i == Integer.MAX_VALUE) {
                return this.i;
            }
            int maxIndex = this.getMaxIndex();
            int newIndex = this.i == Integer.MIN_VALUE ? maxIndex : this.i;
            Position position = this.getIndexPosition(newIndex);
            while (newIndex > 0 && Position.RIGHT.equals((Object)position)) {
                position = this.getIndexPosition(--newIndex);
            }
            if (Position.RIGHT.equals((Object)position)) {
                return Integer.MAX_VALUE;
            }
            if (Position.LEFT.equals((Object)position) && newIndex == maxIndex && this.getMaxPosition() - ViewManager.this.offset < 0) {
                return Integer.MIN_VALUE;
            }
            return newIndex;
        }

        private int findLastIndexRight() {
            if (this.i == Integer.MIN_VALUE) {
                return this.i;
            }
            int maxIndex = this.getMaxIndex();
            int newIndex = this.i == Integer.MAX_VALUE ? 0 : this.i;
            Position position = this.getIndexPosition(newIndex);
            while (newIndex < maxIndex && !Position.RIGHT.equals((Object)position)) {
                position = this.getIndexPosition(++newIndex);
            }
            if (Position.RIGHT.equals((Object)position)) {
                return newIndex == 0 ? Integer.MAX_VALUE : newIndex - 1;
            }
            if (Position.LEFT.equals((Object)position) && newIndex == maxIndex && this.getMaxPosition() - ViewManager.this.offset < 0) {
                return Integer.MIN_VALUE;
            }
            return newIndex;
        }

        private Position getIndexPosition(int index) {
            int position = this.getPosition(this.getTime(index)) - ViewManager.this.offset;
            if (position < 0) {
                return Position.LEFT;
            }
            if (position >= ViewManager.this.width) {
                return Position.RIGHT;
            }
            return Position.WITHIN;
        }

        private void offsetChanged(int oldOffset, int newOffset) {
            int maxIndex = this.getMaxIndex();
            if (maxIndex == -1) {
                return;
            }
            this.i = ViewManager.this.isTrackingEnd() ? maxIndex : (newOffset > oldOffset ? (this.i == -1 ? this.findLastIndex() : this.findLastIndexRight()) : (this.i == -1 ? this.findLastIndex() : this.findLastIndexLeft()));
        }

        private void widthChanged(int oldWidth, int newWidth) {
            int maxIndex = this.getMaxIndex();
            if (maxIndex == -1) {
                return;
            }
            this.i = ViewManager.this.isTrackingEnd() || ViewManager.this.isFit() ? maxIndex : (newWidth > oldWidth ? (this.i == -1 ? this.findLastIndex() : this.findLastIndexRight()) : (this.i == -1 ? this.findLastIndex() : this.findLastIndexLeft()));
        }

        private void preferredWidthChanged(int oldWidth, int newWidth) {
            int maxIndex = this.getMaxIndex();
            if (maxIndex == -1) {
                return;
            }
            int currPos = this.getMaxPosition() - ViewManager.this.offset;
            if (currPos >= 0 && currPos < ViewManager.this.width) {
                this.i = maxIndex;
                this.lastMaxIn = true;
            } else {
                if (this.lastMaxIn && currPos >= ViewManager.this.width) {
                    this.i = maxIndex;
                    this.findLastIndexLeft();
                }
                this.lastMaxIn = false;
            }
        }

        private void zoomChanged(double oldZoom, double newZoom) {
            int maxIndex = this.getMaxIndex();
            if (maxIndex == -1) {
                return;
            }
            this.i = ViewManager.this.isTrackingEnd() || ViewManager.this.isFit() ? maxIndex : this.findLastIndex();
        }

        @Override
        public int compareTo(RowView view) {
            return Long.compare(this.data.getFirstTimeStamp(), view.data.getFirstTimeStamp());
        }

        public String toString() {
            return ViewManager.BUNDLE().getString("COL_Timeline");
        }
    }
}

