/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.xy.synchronous;

import org.graalvm.visualvm.lib.charts.ChartItemListener;
import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.swing.LongRect;
import org.graalvm.visualvm.lib.charts.xy.XYItem;
import org.graalvm.visualvm.lib.charts.xy.XYItemChange;

public abstract class SynchronousXYItem
implements XYItem {
    private final String name;
    private Timeline timeline;
    private int lastIndex;
    private final LongRect bounds;
    private long initialMinY;
    private long initialMaxY;
    private LongRect initialBounds;
    private long minY;
    private long maxY;

    public SynchronousXYItem(String name) {
        this(name, Long.MAX_VALUE);
    }

    public SynchronousXYItem(String name, long initialMinY) {
        this(name, initialMinY, Long.MIN_VALUE);
    }

    public SynchronousXYItem(String name, long initialMinY, long initialMaxY) {
        this.name = name;
        this.initialMinY = initialMinY;
        this.initialMaxY = initialMaxY;
        this.minY = Long.MAX_VALUE;
        this.maxY = Long.MIN_VALUE;
        this.bounds = new LongRect();
        this.initialBounds = new LongRect();
        this.lastIndex = -1;
    }

    public String getName() {
        return this.name;
    }

    public void setInitialBounds(LongRect initialBounds) {
        this.initialBounds = initialBounds;
    }

    public LongRect getInitialBounds() {
        return this.initialBounds;
    }

    public XYItemChange valuesChanged() {
        int index = this.timeline.getTimestampsCount() - 1;
        XYItemChange.Default change = null;
        if (this.lastIndex == index) {
            LongRect b = new LongRect(this.bounds);
            change = new XYItemChange.Default(this, new int[]{-1}, b, b, b);
        } else if (index > -1) {
            int dirtyIndex;
            LongRect oldBounds = new LongRect(this.bounds);
            LongRect dirtyBounds = new LongRect();
            boolean initBounds = this.lastIndex == -1;
            for (int i = dirtyIndex = this.lastIndex == -1 ? 0 : this.lastIndex; i <= index; ++i) {
                long timestamp = this.timeline.getTimestamp(i);
                long value = this.getYValue(i);
                this.minY = Math.min(value, this.minY);
                this.maxY = Math.max(value, this.maxY);
                if (initBounds) {
                    this.bounds.x = timestamp;
                    this.bounds.y = Math.min(value, this.initialMinY);
                    this.bounds.width = 0L;
                    this.bounds.height = Math.max(value, this.initialMaxY) - this.bounds.y;
                    initBounds = false;
                } else {
                    LongRect.add(this.bounds, timestamp, value);
                }
                if (i == dirtyIndex) {
                    dirtyBounds.x = timestamp;
                    dirtyBounds.y = value;
                    dirtyBounds.width = this.timeline.getTimestamp(index) - dirtyBounds.x;
                    continue;
                }
                long dirtyY = dirtyBounds.y;
                dirtyBounds.y = Math.min(dirtyY, value);
                dirtyBounds.height = Math.max(dirtyY, value) - dirtyBounds.y;
            }
            int indexesCount = index - this.lastIndex;
            int[] indexes = new int[indexesCount];
            for (int i = 0; i < indexesCount; ++i) {
                indexes[i] = this.lastIndex + 1 + i;
            }
            change = new XYItemChange.Default(this, indexes, oldBounds, new LongRect(this.bounds), dirtyBounds);
        } else {
            this.minY = Long.MAX_VALUE;
            this.maxY = Long.MIN_VALUE;
            LongRect oldBounds = new LongRect(this.bounds);
            LongRect.set(this.bounds, 0L, 0L, 0L, 0L);
            change = new XYItemChange.Default(this, new int[]{-1}, oldBounds, new LongRect(this.bounds), oldBounds);
        }
        this.lastIndex = index;
        return change;
    }

    @Override
    public int getValuesCount() {
        return this.timeline.getTimestampsCount();
    }

    @Override
    public long getXValue(int index) {
        return this.timeline.getTimestamp(index);
    }

    @Override
    public abstract long getYValue(int var1);

    public long getMinYValue() {
        return this.minY;
    }

    public long getMaxYValue() {
        return this.maxY;
    }

    @Override
    public LongRect getBounds() {
        if (this.getValuesCount() == 0) {
            return this.initialBounds;
        }
        return this.bounds;
    }

    @Override
    public void addItemListener(ChartItemListener listener) {
    }

    @Override
    public void removeItemListener(ChartItemListener listener) {
    }

    void setTimeline(Timeline timeline) {
        this.timeline = timeline;
    }
}

