/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.RGBA;

public class DeviceCMYK {
    String output = null;
    CssValue vc;
    CssValue vy;
    CssValue vm;
    CssValue vk;
    CssValue alpha;
    CssValue fallback = null;
    boolean faSet = false;

    public final void setC(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vc = RGBA.filterAlpha(ac, val);
    }

    public final void setY(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vy = RGBA.filterAlpha(ac, val);
    }

    public final void setM(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vm = RGBA.filterAlpha(ac, val);
    }

    public final void setK(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vk = RGBA.filterAlpha(ac, val);
    }

    public final void setAlpha(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.faSet = true;
        this.alpha = RGBA.filterAlpha(ac, val);
    }

    public final void setFallbackColor(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        switch (val.getType()) {
            case 15: {
                CssColor c = new CssColor();
                c.setShortRGBColor(ac, val.toString());
                this.fallback = c;
                break;
            }
            case 0: {
                this.fallback = new CssColor(ac, (String)val.get());
                break;
            }
            case 3: {
                this.fallback = val;
                break;
            }
            case 11: {
                CssFunction attr = (CssFunction)val;
                CssExpression params = attr.getParameters();
                String fname = attr.getName();
                if (fname.equals("attr")) {
                    CssValue v1 = params.getValue();
                    params.next();
                    CssValue v2 = params.getValue();
                    if (params.getCount() != 2) {
                        throw new InvalidParamException("value", params.getValue(), val.toString(), ac);
                    }
                    if (v1.getType() != 0) {
                        throw new InvalidParamException("value", params.getValue(), val.toString(), ac);
                    }
                    if (!v2.toString().equals("color")) {
                        throw new InvalidParamException("value", params.getValue(), val.toString(), ac);
                    }
                    this.fallback = val;
                    break;
                }
                throw new InvalidParamException("value", params.getValue(), val.toString(), ac);
            }
            default: {
                throw new InvalidParamException("value", "color", val.toString(), ac);
            }
        }
    }

    public boolean equals(DeviceCMYK other) {
        if (other != null) {
            return this.vc.equals(other.vc) && this.vm.equals(other.vm) && this.vy.equals(other.vy) && this.vk.equals(other.vk) && (this.alpha == null && other.alpha == null || this.alpha != null && this.alpha.equals(other.alpha));
        }
        return false;
    }

    public String toString() {
        if (this.output == null) {
            StringBuilder sb = new StringBuilder("device-cmyk(");
            sb.append(this.vc).append(' ');
            sb.append(this.vm).append(' ');
            sb.append(this.vy).append(' ');
            sb.append(this.vk);
            if (this.faSet) {
                sb.append(" / ").append(this.alpha);
            }
            if (this.fallback != null) {
                sb.append(", ").append(this.fallback);
            }
            sb.append(')');
            this.output = sb.toString();
        }
        return this.output;
    }
}

