/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.impl.AbstractTabDisplayer;
import org.netbeans.core.multitabs.impl.CloseButtonHandler;
import org.netbeans.core.multitabs.impl.SingleRowTabTable;
import org.netbeans.core.multitabs.impl.TabLayoutManager;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.core.multitabs.impl.TabTableModel;
import org.netbeans.core.multitabs.impl.TabTableUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.openide.windows.TopComponent;

public class MultiRowTabDisplayer
extends AbstractTabDisplayer
implements ListSelectionListener,
ComplexListDataListener {
    final ArrayList<SingleRowTabTable> rowTables = new ArrayList(10);
    TabLayoutManager layoutManager;
    final JPanel rowPanel;
    CloseButtonHandler closeHandler;
    private final int tabsLocation;
    private boolean ignoreSelectionEvents;

    public MultiRowTabDisplayer(TabDataModel tabDataModel, int n) {
        super(tabDataModel, n);
        this.tabsLocation = n;
        this.rowPanel = new RowPanel();
        this.rowPanel.addMouseWheelListener(this);
        this.scrollPane.setViewportView(this.rowPanel);
        this.layoutManager = TabLayoutManager.create(this.rowTables, this.scrollPane, tabDataModel);
    }

    void initRows() {
        int n = Settings.getDefault().getRowCount();
        for (int i = 0; i < n; ++i) {
            this.addRowTable();
        }
    }

    protected void addRowTable() {
        SingleRowTabTable singleRowTabTable = new SingleRowTabTable(this.tabModel);
        singleRowTabTable.getSelectionModel().setSelectionInterval(0, 0);
        singleRowTabTable.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        singleRowTabTable.addMouseWheelListener(this);
        singleRowTabTable.getSelectionModel().addListSelectionListener(this);
        singleRowTabTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        singleRowTabTable.addMouseListener(this.controller);
        singleRowTabTable.addMouseListener(this.closeHandler);
        singleRowTabTable.addMouseMotionListener(this.closeHandler);
        this.rowTables.add(singleRowTabTable);
        if (this.rowTables.size() == 1) {
            singleRowTabTable.setBorder(TabTableUI.createTabBorder(singleRowTabTable, this.tabsLocation));
        }
        this.rowPanel.add((Component)singleRowTabTable, new GridBagConstraints(0, this.rowTables.size() - 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public Rectangle getTabBounds(int n) {
        return this.layoutManager.getTabBounds(n);
    }

    @Override
    public TabData getTabAt(Point point) {
        return this.layoutManager.getTabAt(point);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        TabTable tabTable = this.getTableFrom(listSelectionEvent);
        if (null != tabTable) {
            this.changeSelection(tabTable);
        }
    }

    private TabTable getTableFrom(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        for (TabTable tabTable : this.rowTables) {
            if (tabTable.getSelectionModel() != object && tabTable.getColumnModel().getSelectionModel() != object) continue;
            return tabTable;
        }
        return null;
    }

    private void changeSelection(TabTable tabTable) {
        if (this.ignoreSelectionEvents) {
            return;
        }
        this.ignoreSelectionEvents = true;
        int n = -1;
        int n2 = tabTable.getSelectedRow();
        int n3 = tabTable.getSelectedColumn();
        if (n2 >= 0 && n3 >= 0) {
            TabData tabData = (TabData)tabTable.getValueAt(n2, n3);
            if (tabData != null) {
                n = this.tabModel.indexOf(tabData);
                Rectangle rectangle = tabTable.getCellRect(n2, n3, true);
                tabTable.scrollRectToVisible(rectangle);
                this.controller.setSelectedIndex(n);
            }
            for (TabTable tabTable2 : this.rowTables) {
                if (tabTable2 == tabTable) continue;
                tabTable2.clearSelection();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = MultiRowTabDisplayer.this.controller.getSelectedIndex();
                    if (n < 0) {
                        n = 0;
                    }
                    MultiRowTabDisplayer.this.setSelectedIndex(n);
                }
            });
        }
        this.ignoreSelectionEvents = false;
    }

    @Override
    public void setSelectedIndex(int n) {
        this.ignoreSelectionEvents = true;
        for (SingleRowTabTable singleRowTabTable : this.rowTables) {
            if (singleRowTabTable.hasTabIndex(n)) {
                TabTableModel tabTableModel = (TabTableModel)singleRowTabTable.getModel();
                int n2 = tabTableModel.toRowIndex(n);
                int n3 = tabTableModel.toColumnIndex(n);
                if (n3 < 0 || n2 < 0) continue;
                singleRowTabTable.getSelectionModel().setSelectionInterval(n2, n2);
                singleRowTabTable.getColumnModel().getSelectionModel().setSelectionInterval(n3, n3);
                Rectangle rectangle = singleRowTabTable.getCellRect(n2, n3, true);
                singleRowTabTable.scrollRectToVisible(rectangle);
                continue;
            }
            singleRowTabTable.clearSelection();
        }
        this.ignoreSelectionEvents = false;
    }

    @Override
    public void attach(Controller controller) {
        super.attach(controller);
        this.closeHandler = new CloseButtonHandler(this, controller);
        this.initRows();
    }

    @Override
    public int dropIndexOfPoint(Point point) {
        int n = -1;
        TabData tabData = this.getTabAt(point);
        if (null != tabData && (n = this.getModel().indexOf(tabData)) == this.getModel().size() - 1) {
            Rectangle rectangle = this.getTabBounds(n);
            if (point.x > rectangle.x + rectangle.width / 2) {
                ++n;
            }
        }
        return n;
    }

    @Override
    public Rectangle dropIndication(TopComponent topComponent, Point point) {
        Rectangle rectangle;
        int n = this.dropIndexOfPoint(point);
        if (n < 0) {
            return null;
        }
        if (n == this.getModel().size()) {
            --n;
        }
        if (null != (rectangle = this.getTabBounds(n))) {
            rectangle.x = n == this.getModel().size() - 1 && point.x > rectangle.x + rectangle.width / 2 ? (rectangle.x += rectangle.width / 4) : (rectangle.x -= rectangle.width / 4);
        }
        return rectangle;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tabModel.addComplexListDataListener((ComplexListDataListener)this);
        this.layoutManager.doLayout();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.tabModel.removeComplexListDataListener((ComplexListDataListener)this);
    }

    public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
        this.layoutManager.invalidate();
    }

    public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
        this.layoutManager.invalidate();
    }

    public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
        this.layoutManager.invalidate();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.layoutManager.invalidate();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.layoutManager.invalidate();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.layoutManager.invalidate();
    }

    private class RowPanel
    extends JPanel
    implements Scrollable {
        public RowPanel() {
            super(new GridBagLayout());
            this.setOpaque(false);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            int n3 = Integer.MAX_VALUE;
            for (TabTable tabTable : MultiRowTabDisplayer.this.rowTables) {
                if (tabTable.getColumnCount() == 0) continue;
                n3 = Math.min(Math.abs(tabTable.getScrollableUnitIncrement(rectangle, n, n2)), n3);
            }
            return n3 * n2;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            int n3 = Integer.MAX_VALUE;
            for (TabTable tabTable : MultiRowTabDisplayer.this.rowTables) {
                if (tabTable.getColumnCount() == 0) continue;
                n3 = Math.min(Math.abs(tabTable.getScrollableBlockIncrement(rectangle, n, n2)), n3);
            }
            return n3 * n2;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }
    }
}

