/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class ExpressionVisitor {
    private Stack stack = new Stack();
    private Container container;
    private Executable executable;
    private StaticContext staticContext;
    private Configuration configuration;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public Stack getStack() {
        return this.stack;
    }

    public void setStack(Stack stack) {
        this.stack = stack;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public Expression getCurrentExpression() {
        return (Expression)this.stack.peek();
    }

    public static ExpressionVisitor make(StaticContext env) {
        ExpressionVisitor visitor = new ExpressionVisitor();
        visitor.setStaticContext(env);
        visitor.setConfiguration(env.getConfiguration());
        return visitor;
    }

    public Expression simplify(Expression exp) throws XPathException {
        if (exp != null) {
            this.stack.push(exp);
            Expression exp2 = exp.simplify(this);
            this.stack.pop();
            return exp2;
        }
        return null;
    }

    public Expression typeCheck(Expression exp, ItemType contextItemType) throws XPathException {
        if (exp != null) {
            this.stack.push(exp);
            Expression exp2 = exp.typeCheck(this, contextItemType);
            this.stack.pop();
            return exp2;
        }
        return null;
    }

    public Expression optimize(Expression exp, ItemType contextItemType) throws XPathException {
        if (exp != null) {
            this.stack.push(exp);
            Expression exp2 = exp.optimize(this, contextItemType);
            this.stack.pop();
            return exp2;
        }
        return null;
    }

    public Expression getParentExpression() {
        int pos = this.stack.size() - 2;
        if (pos > 0) {
            return (Expression)this.stack.get(pos);
        }
        return null;
    }

    public boolean isLoopingSubexpression(Expression ancestor) {
        int top = this.stack.size() - 1;
        while (top > 0) {
            Expression parent = (Expression)this.stack.get(top - 1);
            if (parent.hasLoopingSubexpression((Expression)this.stack.get(top))) {
                return true;
            }
            if (parent == ancestor) {
                return false;
            }
            --top;
        }
        return false;
    }

    public final void resetStaticProperties() {
        Iterator up = this.stack.iterator();
        while (up.hasNext()) {
            Expression exp = (Expression)up.next();
            exp.resetLocalStaticProperties();
        }
    }
}

