/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-02-14
 * Description : a widget to insert a text over an image.
 * 
 * Copyright (C) 2005-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2006-2007 by Marcel Wiesweg <marcel dot wiesweg at gmx dot de>
 * 
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef INSERTTEXTWIDGET_H
#define INSERTTEXTWIDGET_H

// TQt includes.

#include <tqwidget.h>
#include <tqimage.h>
#include <tqrect.h>
#include <tqsize.h>
#include <tqpixmap.h>
#include <tqstring.h>
#include <tqfont.h>
#include <tqcolor.h>

// KDE includes.

#include <kurl.h>

// Digikam includes.

#include "dimg.h"

class TQPixmap;

namespace Digikam
{
class ImageIface;
}

namespace DigikamInsertTextImagesPlugin
{

enum Action
{
    ALIGN_LEFT=0,
    ALIGN_RIGHT,
    ALIGN_CENTER,
    ALIGN_BLOCK,
    BORDER_TEXT,
    TRANSPARENT_TEXT
};

enum TextRotation
{
    ROTATION_NONE=0,
    ROTATION_90,
    ROTATION_180,
    ROTATION_270
};

enum BorderMode
{
    BORDER_NONE,
    BORDER_SUPPORT,
    BORDER_NORMAL
};

class InsertTextWidget : public TQWidget
{
TQ_OBJECT
  

public:

    InsertTextWidget(int w, int h, TQWidget *parent=0);
    ~InsertTextWidget();

    Digikam::ImageIface* imageIface();
    Digikam::DImg        makeInsertText(void);

    void   setText(TQString text, TQFont font, TQColor color, int alignMode,
                   bool border, bool transparent, int rotation);
    void   resetEdit(void);

    void  setPositionHint(TQRect hint);
    TQRect getPositionHint();

protected:

    void paintEvent(TQPaintEvent *e);
    void resizeEvent(TQResizeEvent * e);
    void mousePressEvent(TQMouseEvent * e);
    void mouseReleaseEvent(TQMouseEvent * e);
    void mouseMoveEvent(TQMouseEvent * e);

    void makePixmap(void);
    TQRect composeImage(Digikam::DImg *image, TQPainter *destPainter,
                       int x, int y,
                       TQFont font, float pointSize, int textRotation, TQColor textColor,
                       int alignMode, const TQString &textString,
                       bool transparentBackground, TQColor backgroundColor,
                       BorderMode borderMode, int borderWidth, int spacing);

private:

    bool                 m_currentMoving;
    bool                 m_textBorder;
    bool                 m_textTransparent;

    int                  m_alignMode;
    int                  m_textRotation;

    uchar               *m_data;
    int                  m_w;
    int                  m_h;

    int                  m_xpos;
    int                  m_ypos;
    
    int                  m_transparency;

    TQPixmap             *m_pixmap;

    TQRect                m_rect;
    TQRect                m_textRect;

    TQString              m_textString;

    TQFont                m_textFont;

    TQColor               m_textColor;

    TQColor               m_backgroundColor;

    TQRect                m_positionHint;

    Digikam::ImageIface *m_iface;
};

}  // NameSpace DigikamInsertTextImagesPlugin

#endif /* INSERTTEXTWIDGET_H */
