/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-08-22
 * Description : a generic widget to display a panel to choose
 *               a rectangular image area.
 * 
 * Copyright (C) 2004-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef PANICONWIDGET_H
#define PANICONWIDGET_H

// TQt includes.

#include <tqwidget.h>
#include <tqrect.h>
#include <tqimage.h>

// Local includes.

#include "dimg.h"

namespace Digikam
{

class ImagePanIconWidget;
class PanIconWidgetPriv;

class PanIconWidget : public TQWidget
{
TQ_OBJECT
  

public:

    PanIconWidget(TQWidget *parent=0, WFlags flags=TQt::WDestructiveClose);
    ~PanIconWidget();

    void setImage(int previewWidth, int previewHeight, const TQImage& image);
    void setImage(int previewWidth, int previewHeight, const DImg& image);

    void  setRegionSelection(const TQRect& regionSelection);
    TQRect getRegionSelection();
    void  setCenterSelection();

    void  setCursorToLocalRegionSelectionCenter();
    void  setMouseFocus();
       
signals:

    // Used with ImagePreview widget. 
    // Emit when selection have been moved with mouse. 'targetDone' booleen 
    // value is used for indicate if the mouse have been released.
    void signalSelectionMoved(const TQRect& rect, bool targetDone );     
    
    void signalSelectionTakeFocus();

    void signalHiden();

public slots:

    void slotZoomFactorChanged(double);
            
protected:

    void hideEvent(TQHideEvent*);
    void paintEvent(TQPaintEvent*);
    void mousePressEvent(TQMouseEvent*);
    void mouseReleaseEvent(TQMouseEvent*);
    void mouseMoveEvent(TQMouseEvent*);
    void timerEvent(TQTimerEvent*);
        
    /** Recalculate the target selection position and emit 'signalSelectionMoved'.*/
    void regionSelectionMoved(bool targetDone);

    virtual void updatePixmap();

protected:

    bool     m_flicker;

    int      m_timerID;
    int      m_width;
    int      m_height;
    int      m_zoomedOrgWidth;
    int      m_zoomedOrgHeight;
    int      m_orgWidth;    
    int      m_orgHeight;   
    
    double   m_zoomFactor;

    TQRect    m_rect;
    TQRect    m_localRegionSelection;    // Thumbnail size selection.

    TQPixmap *m_pixmap;


private:

    PanIconWidgetPriv* d;        
};

}  // NameSpace Digikam

#endif /* PANICONWIDGET_H */
