/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz                                      *
 *   peter.penz@gmx.at                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef DOLPHINDETAILSVIEW_H
#define DOLPHINDETAILSVIEW_H

#include <tdefiledetailview.h>
#include <itemeffectsmanager.h>

class TQRect;
class TQTimer;
class DolphinView;

/**
 * @brief Represents the details view which shows the name, size,
 * date, permissions, owner and group of an item.
 *
 * The width of the columns are automatically adjusted in a way
 * that full available width of the view is used by stretching the width
 * of the name column.
 *
 * @author Peter Penz
 */
class DolphinDetailsView : public KFileDetailView, public ItemEffectsManager
{
    TQ_OBJECT
  

public:
    /**
     * Maps the column indices of KFileDetailView to a
     * descriptive column name.
     */
    enum ColumnName {
        NameColumn        = 0,
        SizeColumn        = 1,
        DateColumn        = 2,
        PermissionsColumn = 3,
        OwnerColumn       = 4,
        GroupColumn       = 5
    };

    DolphinDetailsView(DolphinView* parent);

    virtual ~DolphinDetailsView();

    /** @see ItemEffectsManager::updateItems */
    virtual void beginItemUpdates();

    /** @see ItemEffectsManager::updateItems */
    virtual void endItemUpdates();

    /** @see KFileView::insertItem */
    virtual void insertItem(KFileItem* fileItem);

    /**
     * @return  True, if the position \a pos is above the name of
     *          item \a item.
     */
    bool isOnFilename(const TQListViewItem* item, const TQPoint& pos) const;

    /**
     * Reads out the dolphin settings for the details view and refreshs
     * the details view.
     */
    // TODO: Other view implementations use a similar interface. When using
    // Interview in TQt4 this method should be moved to a base class (currently
    // not possible due to having different base classes for the views).
    void refreshSettings();

    /** @see ItemEffectsManager::zoomIn() */
    virtual void zoomIn();

    /** @see ItemEffectsManager::zoomOut() */
    virtual void zoomOut();

    /** @see ItemEffectsManager::isZoomInPossible() */
    virtual bool isZoomInPossible() const;

    /** @see ItemEffectsManager::isZoomOutPossible() */
    virtual bool isZoomOutPossible() const;

signals:
    /**
     * Is send, if the details view should be activated. Usually an activation
     * is triggered by a mouse click.
     */
    void signalRequestActivation();

public slots:
    /** @see KFileDetailView::resizeContents */
    virtual void resizeContents(int width, int height);

    /** Is connected to the onItem-signal from KFileDetailView. */
    void slotOnItem(TQListViewItem* item);

    /** Is connected to the onViewport-signal from KFileDetailView. */
    void slotOnViewport();

protected:
    /** @see ItemEffectsManager::setContextPixmap() */
    virtual void setContextPixmap(void* context,
                                  const TQPixmap& pixmap);

    /** @see ItemEffectsManager::setContextPixmap() */
    virtual const TQPixmap* contextPixmap(void* context);

    /** @see ItemEffectsManager::setContextPixmap() */
    virtual void* firstContext();

    /** @see ItemEffectsManager::setContextPixmap() */
    virtual void* nextContext(void* context);

    /** @see ItemEffectsManager::setContextPixmap() */
    virtual KFileItem* contextFileInfo(void* context);

    /** @see KFileDetailView::contentsDragMoveEvent() */
    virtual void contentsDragMoveEvent(TQDragMoveEvent* event);

    /** @see KFileDetailView::resizeEvent() */
    virtual void resizeEvent(TQResizeEvent* event);

    /** @see KFileDetailView::acceptDrag() */
    virtual bool acceptDrag (TQDropEvent* event) const;

    /** @see KFileDetailView::contentsDropEvent() */
    virtual void contentsDropEvent(TQDropEvent* event);

    /** @see KFileDetailView::contentsMousePressEvent() */
    virtual void contentsMousePressEvent(TQMouseEvent* event);

    /** @see KFileDetailView::contentsMouseMoveEvent() */
    virtual void contentsMouseMoveEvent(TQMouseEvent* event);

    /** @see KFileDetailView::contentsMouseReleaseEvent() */
    virtual void contentsMouseReleaseEvent(TQMouseEvent* event);

    /** @see TQListView::paintEmptyArea() */
    virtual void paintEmptyArea(TQPainter* painter, const TQRect& rect);

    /** Draws the selection rubber. */
    void drawRubber();

    /** @see TQListView::viewportPaintEvent() */
    virtual void viewportPaintEvent(TQPaintEvent* paintEvent);

    /** @see TQWidget::leaveEvent() */
    virtual void leaveEvent(TQEvent* event);

private slots:
    void slotActivationUpdate();
    void slotContextMenuRequested(TQListViewItem* item,
                                  const TQPoint& pos,
                                  int col);
    void slotUpdateDisabledItems();
    void slotAutoScroll();
    void updateColumnsWidth();
    void slotItemRenamed(TQListViewItem* item,
                         const TQString& name,
                         int column);

    /**
     * Is invoked when a section from the header has
     * been clicked and stores the sort column and sort
     * order.
     */
    void slotHeaderClicked(int section);

private:
    class DolphinListViewItem : public KFileListViewItem {
    public:
        DolphinListViewItem(TQListView* parent,
                            KFileItem* fileItem);
        virtual ~DolphinListViewItem();
        virtual void paintCell(TQPainter* painter,
                               const TQColorGroup& colorGroup,
                               int column,
                               int cellWidth,
                               int alignment);

        virtual void paintFocus(TQPainter* painter,
                                const TQColorGroup& colorGroup,
                                const TQRect& rect);
    };

    DolphinView* m_dolphinView;
    TQTimer* m_resizeTimer;
    TQTimer* m_scrollTimer;
    TQRect* m_rubber;

    /**
     * Returns the width of the filename in pixels including
     * the icon. It is assured that the returned width is
     * <= the width of the filename column.
     */
    int filenameWidth(const TQListViewItem* item) const;

};

#endif
