

#ifndef TAGENGINE_H
#define TAGENGINE_H

#include <tqstring.h>
#include <tqstringlist.h>

/**
 * @short All metainformation can be stored in this class
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class TagData
{
public:
    /**
     * Constructor
     */
    TagData( const TQString& _artist = TQString(), const TQString& _composer = TQString(),
             const TQString& _album = TQString(), const TQString& _title = TQString(),
             const TQString& _genre = TQString(), const TQString& _comment = TQString(),
             int _track = 0, int _disc = 0, int _year = 0,
             int _length = 0, int _fileSize = 0, int _bitrate = 0, int _samplingRate = 0 );

    /**
     * Destructor
     */
    virtual ~TagData();

    /** The tags */
    TQString artist;
    TQString composer;
    TQString album;
    TQString title;
    TQString genre;
    TQString comment;
    int track;
    int disc;
    int year;
    float track_gain;
    float album_gain;

    /** The technical information */
    int length;
    int fileSize;
    int bitrate;
    int samplingRate;
};


/**
 * @short Manages everything that has something to do with tags
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class TagEngine
{
public:
    /**
     * Constructor
     */
    TagEngine();

    /**
     * Destructor
     */
    virtual ~TagEngine();

    /** A list of all genre */
    TQStringList genreList;

    TagData* readTags( const TQString& file );
    bool writeTags( const TQString& file, TagData* tagData );

//     bool canWrite( TQString format ); // NOTE no const because this string is being modyfied
};

#endif // TAGENGINE_H
