
#include "convertpluginloader.h"

#include <tqfile.h>

#include <tdelocale.h>
#include <tdeglobal.h>

// TODO check whether it is possible to implement presets in the lame plugin

ConvertPlugin::ConvertPlugin()
{}

ConvertPlugin::~ConvertPlugin()
{}


ConvertPluginLoader::ConvertPluginLoader()
{}

ConvertPluginLoader::~ConvertPluginLoader()
{}

int ConvertPluginLoader::verifyFile( TQString fileName )
{
    TQFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return -1;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return -1;
    }
    opmlFile.close();

    TQDomElement root = domTree.documentElement();
    if( root.attribute("type") != "converter" ) return -1;
    int version;
    TQDomNode node;
    node = root.firstChild();
    while( !node.isNull() ) {
        if( node.isElement() && node.nodeName() == "info" ) {
            version = node.toElement().attribute("version","0").toInt();
            break;
        }
    }

    return version;
}

ConvertPlugin* ConvertPluginLoader::loadFile( TQString fileName )
{
    int t_int;
    float t_float;
    TQString t_str;

    ConvertPlugin* plugin = new ConvertPlugin();
    plugin->info.version = -1; // if something goes wrong, we can see that by looking at plugin->info.version
    plugin->filePathName = fileName;

    TQFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return plugin;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return plugin;
    }
    opmlFile.close();

    TQString language = TDEGlobal::locale()->languagesTwoAlpha().first();

    TQDomElement root = domTree.documentElement();
    if( root.attribute("type") != "converter" ) return plugin;
    TQDomNode node, sub1Node, sub2Node, sub3Node, sub4Node;
    node = root.firstChild();

    plugin->enc.enabled = false;
    plugin->enc.strength.enabled = false;
    plugin->enc.lossy.enabled = false;
    plugin->enc.lossy.quality.enabled = false;
    plugin->enc.lossy.bitrate.abr.enabled = false;
    plugin->enc.lossy.bitrate.abr.bitrate_range.enabled = false;
    plugin->enc.lossy.bitrate.cbr.enabled = false;
    plugin->enc.lossy.samplingrate.enabled = false;
    plugin->enc.lossy.channels.stereo_enabled = false;
    plugin->enc.lossy.channels.joint_stereo_enabled = false;
    plugin->enc.lossy.channels.forced_joint_stereo_enabled = false;
    plugin->enc.lossy.channels.dual_channels_enabled = false;
    plugin->enc.lossy.channels.mono_enabled = false;
    plugin->enc.lossless.enabled = false;
    plugin->enc.hybrid.enabled = false;
    plugin->enc.replaygain.enabled = false;
    plugin->enc.tag.enabled = false;
    plugin->dec.enabled = false;

    while( !node.isNull() ) {
        if( node.isElement() && node.nodeName() == "info" ) {

            plugin->info.name = node.toElement().attribute("name",i18n("Unknown Name"));
            plugin->info.about = node.toElement().attribute("about_"+language);
            if( plugin->info.about.isEmpty() ) plugin->info.about = node.toElement().attribute("about");
            if( plugin->info.about.isEmpty() ) plugin->info.about = i18n("Sorry, no information available!");
            plugin->info.author = node.toElement().attribute("author",i18n("Unknown Author"));
            plugin->info.version = node.toElement().attribute("version","0").toInt();

        }
        else if( node.isElement() && node.nodeName() == "enc" ) {

            if(node.toElement().attribute("enabled") == "true") plugin->enc.enabled = true;
            plugin->enc.rank = node.toElement().attribute("rank","10").toInt();
            plugin->enc.bin = node.toElement().attribute( "bin" );
            plugin->enc.param = node.toElement().attribute("param");
            plugin->enc.silent_param = node.toElement().attribute("silent_param");
            plugin->enc.mime_types = TQStringList::split( ',', node.toElement().attribute("mime_types","application/octet-stream") );
            plugin->enc.in_out_files = node.toElement().attribute("in_out_files");
            plugin->enc.overwrite = node.toElement().attribute("overwrite");

            sub1Node = node.toElement().firstChild();
            while( !sub1Node.isNull() ) {
                if( sub1Node.isElement() && sub1Node.nodeName() == "strength" ) {

                    if( sub1Node.toElement().attribute("enabled") == "true" ) plugin->enc.strength.enabled = true;
                    plugin->enc.strength.range_min = sub1Node.toElement().attribute("range_min").toFloat();
                    plugin->enc.strength.range_max = sub1Node.toElement().attribute("range_max").toFloat();
                    plugin->enc.strength.separator = sub1Node.toElement().attribute("separator").at(0);
                    plugin->enc.strength.param = sub1Node.toElement().attribute("param");
                    plugin->enc.strength.step = sub1Node.toElement().attribute("step").toFloat();
                    plugin->enc.strength.profiles = TQStringList::split( ',', sub1Node.toElement().attribute("profiles") );
                    plugin->enc.strength.default_value = sub1Node.toElement().attribute("default_value").toFloat();

                }
                else if( sub1Node.isElement() && sub1Node.nodeName() == "lossy" ) {

                    if( sub1Node.toElement().attribute("enabled") == "true" ) plugin->enc.lossy.enabled = true;

                    sub2Node = sub1Node.toElement().firstChild();
                    while( !sub2Node.isNull() ) {
                       if( sub2Node.isElement() && sub2Node.nodeName() == "quality" ) {

                            if( sub2Node.toElement().attribute("enabled") == "true" ) plugin->enc.lossy.quality.enabled = true;
                            plugin->enc.lossy.quality.range_min = sub2Node.toElement().attribute("range_min").toFloat();
                            plugin->enc.lossy.quality.range_max = sub2Node.toElement().attribute("range_max").toFloat();
                            plugin->enc.lossy.quality.separator = sub2Node.toElement().attribute("separator").at(0);
                            plugin->enc.lossy.quality.help = sub2Node.toElement().attribute("help");
                            plugin->enc.lossy.quality.output = sub2Node.toElement().attribute("output");
                            plugin->enc.lossy.quality.param = sub2Node.toElement().attribute("param");
                            plugin->enc.lossy.quality.step = sub2Node.toElement().attribute("step").toFloat();
                            plugin->enc.lossy.quality.profiles = TQStringList::split( ',', sub2Node.toElement().attribute("profiles") );

                        }
                        else if( sub2Node.isElement() && sub2Node.nodeName() == "bitrate" ) {
                            sub3Node = sub2Node.toElement().firstChild();
                            while( !sub3Node.isNull() ) {
                                if( sub3Node.isElement() && sub3Node.nodeName() == "abr" ) {

                                    if( sub3Node.toElement().attribute("enabled") == "true" ) plugin->enc.lossy.bitrate.abr.enabled = true;
                                    plugin->enc.lossy.bitrate.abr.output = sub3Node.toElement().attribute("output");
                                    plugin->enc.lossy.bitrate.abr.param = sub3Node.toElement().attribute("param");

                                    sub4Node = sub3Node.toElement().firstChild();
                                    while( !sub4Node.isNull() ) {
                                        if( sub4Node.isElement() && sub4Node.nodeName() == "bitrate_range" ) {

                                            if( sub4Node.toElement().attribute("enabled") == "true" ) plugin->enc.lossy.bitrate.abr.bitrate_range.enabled = true;
                                            plugin->enc.lossy.bitrate.abr.bitrate_range.param_min = sub4Node.toElement().attribute("min_param");
                                            plugin->enc.lossy.bitrate.abr.bitrate_range.param_max = sub4Node.toElement().attribute("max_param");

                                        }
                                        sub4Node = sub4Node.nextSibling();
                                    }
                                }
                                else if( sub3Node.isElement() && sub3Node.nodeName() == "cbr" ) {

                                    if( sub3Node.toElement().attribute("enabled") == "true" ) plugin->enc.lossy.bitrate.cbr.enabled = true;
                                    plugin->enc.lossy.bitrate.cbr.output = sub3Node.toElement().attribute("output");
                                    plugin->enc.lossy.bitrate.cbr.param = sub3Node.toElement().attribute("param");

                                }
                                sub3Node = sub3Node.nextSibling();
                            }
                        }
                        else if( sub2Node.isElement() && sub2Node.nodeName() == "samplingrate" ) {

                            if( sub2Node.toElement().attribute("enabled") == "true" ) plugin->enc.lossy.samplingrate.enabled = true;
                            if( sub2Node.toElement().attribute("unit") == "Hz" ) plugin->enc.lossy.samplingrate.unit = PluginLoaderBase::Hz;
                            else plugin->enc.lossy.samplingrate.unit = PluginLoaderBase::KHz;
                            plugin->enc.lossy.samplingrate.param = sub2Node.toElement().attribute("param");

                        }
                        else if( sub2Node.isElement() && sub2Node.nodeName() == "channels" ) {

                            if( sub2Node.toElement().attribute("stereo_enabled") == "true" ) plugin->enc.lossy.channels.stereo_enabled = true;
                            plugin->enc.lossy.channels.stereo_param = sub2Node.toElement().attribute("stereo_param");
                            if( sub2Node.toElement().attribute("joint_stereo_enabled") == "true" ) plugin->enc.lossy.channels.joint_stereo_enabled = true;
                            plugin->enc.lossy.channels.joint_stereo_param = sub2Node.toElement().attribute("joint_stereo_param");
                            if( sub2Node.toElement().attribute("forced_joint_stereo_enabled") == "true" ) plugin->enc.lossy.channels.forced_joint_stereo_enabled = true;
                            plugin->enc.lossy.channels.forced_joint_stereo_param = sub2Node.toElement().attribute("forced_joint_stereo_param");
                            if( sub2Node.toElement().attribute("dual_channels_enabled") == "true" ) plugin->enc.lossy.channels.dual_channels_enabled = true;
                            plugin->enc.lossy.channels.dual_channels_param=sub2Node.toElement().attribute("dual_channels_param");
                            if( sub2Node.toElement().attribute("mono_enabled") == "true" ) plugin->enc.lossy.channels.mono_enabled = true;
                            plugin->enc.lossy.channels.mono_param=sub2Node.toElement().attribute("mono_param");

                        }
                        sub2Node = sub2Node.nextSibling();
                    }
                }
                else if( sub1Node.isElement() && sub1Node.nodeName() == "lossless" ) {

                    if( sub1Node.toElement().attribute("enabled") == "true" ) plugin->enc.lossless.enabled = true;
                    plugin->enc.lossless.output = sub1Node.toElement().attribute("output");
                    plugin->enc.lossless.param = sub1Node.toElement().attribute("param");

                }
                else if( sub1Node.isElement() && sub1Node.nodeName() == "hybrid" ) {

                    if( sub1Node.toElement().attribute("enabled") == "true" ) plugin->enc.hybrid.enabled = true;
                    plugin->enc.hybrid.output = sub1Node.toElement().attribute("output");
                    plugin->enc.hybrid.param = sub1Node.toElement().attribute("param");
                    plugin->enc.hybrid.correction_file_mime_type = sub1Node.toElement().attribute("correction_file_mime_type","application/octet-stream");

                }
                else if( sub1Node.isElement() && sub1Node.nodeName() == "replay_gain" ) {

                    if( sub1Node.toElement().attribute("enabled") == "true" ) plugin->enc.replaygain.enabled = true;
                    plugin->enc.replaygain.use = sub1Node.toElement().attribute("use");
                    plugin->enc.replaygain.avoid = sub1Node.toElement().attribute("avoid");
                    plugin->enc.replaygain.rank = sub1Node.toElement().attribute("rank","10").toInt();

                }
                else if( sub1Node.isElement() && sub1Node.nodeName() == "tag" ) {

                    if( sub1Node.toElement().attribute("enabled") == "true" ) plugin->enc.tag.enabled = true;
                    plugin->enc.tag.param = sub1Node.toElement().attribute("param");
                    plugin->enc.tag.artist = sub1Node.toElement().attribute("artist");
                    plugin->enc.tag.composer = sub1Node.toElement().attribute("composer");
                    plugin->enc.tag.album = sub1Node.toElement().attribute("album");
                    plugin->enc.tag.disc = sub1Node.toElement().attribute("disc");
                    plugin->enc.tag.title = sub1Node.toElement().attribute("title");
                    plugin->enc.tag.genre = sub1Node.toElement().attribute("genre");
                    plugin->enc.tag.comment = sub1Node.toElement().attribute("comment");
                    plugin->enc.tag.track = sub1Node.toElement().attribute("track");
                    plugin->enc.tag.year = sub1Node.toElement().attribute("year");

                }
                sub1Node = sub1Node.nextSibling();
            }
        }
        else if ( node.isElement() && node.nodeName() == "dec" ) {

            if(node.toElement().attribute("enabled") == "true") plugin->dec.enabled = true;
            plugin->dec.rank = node.toElement().attribute("rank","10").toInt();
            plugin->dec.bin = node.toElement().attribute("bin");
            plugin->dec.output = node.toElement().attribute("output");
            plugin->dec.param = node.toElement().attribute("param");
            plugin->dec.overwrite = node.toElement().attribute("overwrite");
            plugin->dec.mime_types = TQStringList::split( ',', node.toElement().attribute("mime_types","application/octet-stream") );
            plugin->dec.in_out_files = node.toElement().attribute("in_out_files");
            plugin->dec.silent_param = node.toElement().attribute("silent_param");

        }
        node = node.nextSibling();
    }

    return plugin;
}

#include "convertpluginloader.moc"
