/***************************************************************************
 *
 * tdenetman.h - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author:  Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_WIRELESSMENUITEM_H
#define TDENETWORKMANAGER_WIRELESSMENUITEM_H

#include "tdenetman-menuitem.h"

#include <tqmap.h>
#include <tqtimer.h>

#include <tqtooltip.h>
#include <ksystemtray.h>
#include <tdepopupmenu.h>
#include <tdeactionclasses.h>
#include <kstdaction.h>
#include <kstdguiitem.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqprogressbar.h>
#include <tqguardedptr.h>

#include "tdenetman-wireless_network.h"

class WirelessNetworkItem : public NetworkMenuItem, public TQCustomMenuItem
{
	TQ_OBJECT

	public:
		WirelessNetworkItem  (TQWidget*, TQString dev, WirelessNetwork& net, TQString conn, bool adhoc);
		WirelessNetworkItem  (TQWidget*, TQString dev, WirelessNetwork& net, bool adhoc);
		~WirelessNetworkItem ();
	
		TQWidget*      parent;
		TQProgressBar* pbarStrength;
	
		void  paint    (TQPainter*, const TQColorGroup&, bool, bool, int, int, int, int);
		TQSize sizeHint ();

	public slots:
		void slotActivate();

	private:
		TQString getDisplayText();

		bool    _adhoc;
		WirelessNetwork _net;
		TQString _dev;
		TQString _conn;
	
		/* menu item */
		int _width;
		int _height;
		int _border;
	
		/* elements */
		int _textHeight;
		int _widgetHeight;
	
		int _space;
	
		TDEHardwareDevices* hwdevices;
};

#endif /* TDENETWORKMANAGER_WIRELESSMENUITEM_H */
