/***************************************************************************
                          quanta.cpp  -  description
                             -------------------
    begin                : ?? ???  9 13:29:57 EEST 2000
    copyright            : (C) 2000 by Dmitry Poplavsky & Alexander Yakovlev <pdima@users.sourceforge.net,yshurik@linuxfan.com>
                           (C) 2001-2004 by Andras Mantia <amantia@kde.org>
                           (C) 2000, 2003 by Eric Laffoon <sequitur@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// include files for QT
#include <tqdir.h>
#include <tqprinter.h>
#include <tqpainter.h>
#include <tqtabwidget.h>
#include <tqwidgetstack.h>
#include <tqlayout.h>
#include <tqeventloop.h>
#include <tqtimer.h>
#include <tqdom.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqtextcodec.h>
#include <tqpopupmenu.h>
#include <tqdatetime.h>
#include <tqradiobutton.h>

// include files for KDE
#include <dcopclient.h>
#include <tdeaccel.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <tdemessagebox.h>
#include <tdefiledialog.h>
#include <tdeglobal.h>
#include <tdemenubar.h>
#include <tdelocale.h>
#include <tdeconfig.h>
#include <tdehtmlview.h>
#include <tdestandarddirs.h>
#include <kstatusbar.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <tdepopupmenu.h>
#include <tdeprocess.h>
#include <kprogress.h>
#include <ktip.h>
#include <tdeio/netaccess.h>
#include <ktabwidget.h>
#include <tdemultitabbar.h>
#include <tdetexteditor/view.h>

#include "wkafkapart.h"
#include "kafkacommon.h"
#include "undoredo.h"
#include <dom/dom_string.h>

// application specific includes

#include "quanta_init.h"
#include "quanta.h"
#include "viewmanager.h"
#include "quantadoc.h"
#include "resource.h"
#include "document.h"
#include "qextfileinfo.h"

#include "project.h"
#include "debuggermanager.h"

#include "wkafkapart.h"
#include "whtmlpart.h"
#include "annotationoutput.h"
#include "messageoutput.h"

#include "tagaction.h"

#include "filestreeview.h"
#include "projecttreeview.h"
#include "doctreeview.h"
#include "structtreeview.h"
#include "templatestreeview.h"
#include "tagattributetree.h"
#include "scripttreeview.h"
#include "toolbartabwidget.h"

#ifdef ENABLE_CVSSERVICE
#include "cvsservice.h"
#endif

#include "quantaplugin.h"
#include "quantaplugininterface.h"


#include "parser.h"
#include "filemasks.h"
#include "dirtydlg.h"
#include "dirtydialog.h"

#include "dtds.h"
#include "qpevents.h"
#include "quantabookmarks.h"

#include "tagactionmanager.h"
#include "tagactionset.h"

extern TQMap<int, TQString> replacementMap;

QuantaInit::QuantaInit(QuantaApp * quantaApp)
        : TQObject()
{
  m_quanta = quantaApp;
  connect(this, TQ_SIGNAL(hideSplash()), m_quanta, TQ_SLOT(slotHideSplash()));
}

QuantaInit::~QuantaInit()
{
}


/** Delayed initialization. */
void QuantaInit::initQuanta()
{
  m_config = quantaApp->m_config;
  parser = new Parser();

  TQStringList tmpDirs = TDEGlobal::dirs()->resourceDirs("tmp");
  TQDir dir;
  tmpDir = tmpDirs[0];
  for (uint i = 0; i < tmpDirs.count(); i++)
  {
    if (tmpDirs[i].contains("tde-"))
       tmpDir = tmpDirs[i];
  }
  dir.mkdir(tmpDir + "quanta");
  tmpDir += "quanta/quanta";

  scriptBeginRx.setCaseSensitive(false);
  scriptBeginRx.setPattern("(<script)");
  scriptEndRx.setCaseSensitive(false);
  scriptEndRx.setPattern("(/script>)");

  initStatusBar();

  //defaultDocType must be read before the Project object is created!!
  m_config->setGroup("General Options");
  qConfig.defaultDocType = m_config->readEntry("Default DTD",DEFAULT_DTD);
  if (! DTDs::ref()->find(qConfig.defaultDocType))
     qConfig.defaultDocType = DEFAULT_DTD;
  DTDs::ref()->find("dtd"); //load on startup

  initView();
  initDocument();  // after initView because of init of treeViews
  initProject();
  initActions();


  DTDs::ref();  // create the class, must be before readOptions() !
  readOptions();
  initPlugins();  // needs to be before createGUI because some actions are created inside
  readAbbreviations();

  // Initialize debugger
  m_quanta->m_debugger = new DebuggerManager(m_quanta);
  connect(Project::ref(), TQ_SIGNAL(newProjectLoaded(const TQString &, const KURL &, const KURL &)),
          m_quanta->m_debugger, TQ_SLOT(slotNewProjectLoaded(const TQString &, const KURL &, const KURL &)));
  connect(Project::ref(), TQ_SIGNAL(eventHappened(const TQString &, const TQString &, const TQString &)),
          m_quanta->m_debugger, TQ_SLOT(slotHandleEvent(const TQString &, const TQString &, const TQString &)));
  connect(m_quanta->m_debugger, TQ_SIGNAL(hideSplash()), m_quanta, TQ_SLOT(slotHideSplash()));

  //m_quanta->KDockMainWindow::createGUI( TQString(), false /* conserveMemory */ );
  m_quanta->createShellGUI(true);

  addToolTreeView(m_quanta->fTab, i18n("Files"), UserIcon("ftab"), KDockWidget::DockLeft);
  addToolTreeView(m_quanta->dTab, i18n("Documentation"), BarIcon("contents"), KDockWidget::DockRight);
  addToolTreeView(m_quanta->aTab, i18n("Attribute Editor"), UserIcon("tag_misc"), KDockWidget::DockRight);
  addToolTreeView(ProjectTreeView::ref(), i18n("Project"), UserIcon("ptab"), KDockWidget::DockLeft);
  addToolTreeView(TemplatesTreeView::ref(), i18n("Templates"), UserIcon("ttab"), KDockWidget::DockLeft);
  addToolTreeView(StructTreeView::ref(), i18n("Document Structure"), BarIcon("view_sidetree"), KDockWidget::DockLeft);
  addToolTreeView(m_quanta->scriptTab, i18n("Scripts"), BarIcon("system-run"), KDockWidget::DockLeft);
  m_quanta->m_messageOutputView = addToolTreeView(m_quanta->m_messageOutput, i18n("Messages"), SmallIcon("openterm"), KDockWidget::DockBottom);
  m_quanta->m_problemsOutputView = addToolTreeView(m_quanta->m_problemOutput, i18n("Problems"), SmallIcon("application-vnd.tde.info"), KDockWidget::DockBottom);
  m_quanta->m_annotationOutputView = addToolTreeView(m_quanta->m_annotationOutput, i18n("Annotations"), SmallIcon("stamp"), KDockWidget::DockBottom);

  // Restore the dock layout
  m_config->setGroup  ("General Options");
  TQString layout = m_config->readEntry("Window layout", "Default");
  int mdiMode = m_config->readNumEntry("MDI mode", -1);
  if (mdiMode != -1 && layout != "Default")
  {
      m_quanta->readDockConfig(m_config); //FIXME: This causes the visible widget construction on startup, but is needed to restore the window layout...
      if (mdiMode != KMdi::IDEAlMode)
        m_quanta->setToolviewStyle(qConfig.toolviewTabs);
  }

  m_quanta->initTabWidget(true);
  qConfig.windowLayout = "Custom";
  //FIXME: This is a hack to workaround the starting problem when we are in Toplevel mode.
  //Without this, the editor becomes the child of the widget holding the menus and toolbars...
  if (mdiMode == KMdi::ToplevelMode)
  {
      m_quanta->switchToChildframeMode();
      TQTimer::singleShot(0, m_quanta, TQ_SLOT(switchToToplevelMode()));
  }

  // Always hide debugger toolbar at this point
  m_quanta->toolBar("debugger_toolbar")->hide();

  m_quanta->m_pluginInterface->setPluginMenu(static_cast<TQPopupMenu*>(m_quanta->factory()->container("plugins", m_quanta)));
 m_quanta->m_pluginInterface->buildPluginMenu();
//TODO: Remove after upgrade from 3.1 is not supported
  TQDomDocument doc;
  doc.setContent(KXMLGUIFactory::readConfigFile(m_quanta->xmlFile(), m_quanta->instance()));
  TQDomNodeList nodeList = doc.elementsByTagName("ActionProperties");
  TQDomNode node = nodeList.item(0).firstChild();
  while (!node.isNull())
  {
    if (node.nodeName() == "Action")
    {
      TQDomElement el = node.toElement();
      m_quanta->oldShortcuts.insert(el.attribute("name"), el.attribute("shortcut"));
      node = node.nextSibling();
      el.parentNode().removeChild(el);
    } else
    {
      node = node.nextSibling();
    }
  }

  m_quanta->applyMainWindowSettings(m_config);

  m_quanta->m_tagsMenu =   static_cast<TQPopupMenu*>(m_quanta->factory()->container("tags", m_quanta));
  KMenuBar *mb = m_quanta->menuBar();
  for (uint i = 0 ; i < mb->count(); i++)
  {
       if (mb->text(mb->idAt(i)) == i18n("&Settings"))
       {
          mb->insertItem(i18n("&Window"), m_quanta->windowMenu(), -1, i);
          break;
       }
  }
  TDEActionMenu *toolviewMenu = (TDEActionMenu*)(m_quanta->actionCollection()->action("tdemdi_toolview_menu"));
  if (toolviewMenu)
     toolviewMenu->plug(m_quanta->windowMenu());

  TQPopupMenu *toolbarsMenu  = (TQPopupMenu*)(m_quanta->guiFactory())->container("toolbars_load", m_quanta);
  connect(toolbarsMenu, TQ_SIGNAL(aboutToShow()), m_quanta, TQ_SLOT(slotBuildPrjToolbarsMenu()));

  TQPopupMenu *contextMenu = (TQPopupMenu*)(m_quanta->guiFactory())->container("popup_editor", m_quanta);
  connect(contextMenu, TQ_SIGNAL(aboutToShow()), m_quanta, TQ_SLOT(slotContextMenuAboutToShow()));

  connect(m_quanta->m_messageOutput, TQ_SIGNAL(clicked(const TQString&, int, int)),
          m_quanta, TQ_SLOT(gotoFileAndLine(const TQString&, int, int)));
  connect(m_quanta->m_problemOutput, TQ_SIGNAL(clicked(const TQString&, int, int)),
          m_quanta, TQ_SLOT(gotoFileAndLine(const TQString&, int, int)));
  connect(m_quanta->m_annotationOutput->currentFileAnnotations(), TQ_SIGNAL(clicked(const TQString&, int, int)),
          m_quanta, TQ_SLOT(gotoFileAndLine(const TQString&, int, int)));
  connect(m_quanta->m_annotationOutput, TQ_SIGNAL(clicked(const TQString&, int, int)),
          m_quanta, TQ_SLOT(gotoFileAndLine(const TQString&, int, int)));

  m_quanta->slotFileNew();
  m_quanta->slotNewStatus();
  initToolBars();
  Project::ref()->setProjectToolbarVisible(m_quanta->factory()->container("project_toolbar", m_quanta)->isShown());
  Project::ref()->slotShowProjectToolbar(Project::ref()->hasProject());
  KTipDialog::showTip(m_quanta);

  //get the PID of this running instance
  qConfig.quantaPID = TQString::number(int(getpid()), 10);
  qConfig.backupDirPath = TDEGlobal::instance()->dirs()->saveLocation("data", resourceDir + "backups/");

  m_quanta->autosaveTimer = new TQTimer(m_quanta);
  connect(m_quanta->autosaveTimer, TQ_SIGNAL(timeout()), m_quanta, TQ_SLOT(slotAutosaveTimer()));
  m_quanta->autosaveTimer->start(qConfig.autosaveInterval * 60000, false);

  connect(m_quanta->m_doc, TQ_SIGNAL(hideSplash()), m_quanta, TQ_SLOT(slotHideSplash()));
  connect(parser, TQ_SIGNAL(rebuildStructureTree(bool)),
          m_quanta, TQ_SLOT(slotReloadStructTreeView(bool)));

  // Read list of characters
  TQFile file(locate("appdata","chars"));
  if ( file.open(IO_ReadOnly) ) {    // file opened successfully
    TQTextStream t( &file );        // use a text stream
    t.setEncoding(TQTextStream::UnicodeUTF8);
    TQString s;
    while (!t.eof())
    {
      s = t.readLine();
      charList << i18n(s.utf8()); // line excluding '\n'
      int begin = s.find("(&") + 1;
      if (begin == 1)
          continue;
      int length = s.find(";)") - begin + 1;
      TQString s2 = s.mid(begin, length - 1);
      replacementMap[s[0].unicode()] = s2;
    }
    file.close();
  }

  TQString infoCss = tmpDir;
  infoCss.replace(TQRegExp("/quanta$"),"");
  infoCss += "/info.css";
  QExtFileInfo::copy(KURL().fromPathOrURL(qConfig.globalDataDir + resourceDir + "scripts/info.css"), KURL().fromPathOrURL(infoCss));

  checkRuntimeDependencies();
  ViewManager::ref()->activeDocument()->view()->setFocus();

  m_quanta->refreshTimer = new TQTimer(m_quanta);
  connect(m_quanta->refreshTimer, TQ_SIGNAL(timeout()), m_quanta, TQ_SLOT(slotReparse()));
  m_quanta->refreshTimer->start( qConfig.refreshFrequency*1000, false ); //update the structure tree every 5 seconds
  if (qConfig.instantUpdate || qConfig.refreshFrequency == 0)
  {
    m_quanta->refreshTimer->stop();
  }

}

void QuantaInit::initToolBars()
{
 if (m_quanta->m_toolbarList.count() == 0)
   m_quanta->slotLoadToolbarForDTD(Project::ref()->defaultDTD());
}

void QuantaInit::initStatusBar()
{
  m_quanta->statusbarTimer = new TQTimer(m_quanta);
  connect(m_quanta->statusbarTimer,TQ_SIGNAL(timeout()),
          m_quanta, TQ_SLOT(statusBarTimeout()));

  progressBar = new KProgress(m_quanta->statusBar());
  progressBar->setTextEnabled(false);
  progressBar->setMaximumHeight(progressBar->fontMetrics().height());
  progressBar->show();
  m_quanta->statusBar()->insertItem(i18n(IDS_DEFAULT),IDS_STATUS, 1);
  m_quanta->statusBar()->addWidget(progressBar);
  m_quanta->statusBar()->insertItem("",               IDS_INS_OVR  );
  m_quanta->statusBar()->insertFixedItem(" * ",       IDS_MODIFIED );
  m_quanta->statusBar()->insertFixedItem(i18n("Line: 00000 Col: 000"), IDS_STATUS_CLM, true);

  m_quanta->statusBar()->changeItem("", IDS_INS_OVR);
  m_quanta->statusBar()->changeItem("", IDS_MODIFIED);
  m_quanta->statusBar()->changeItem("", IDS_STATUS_CLM);
  m_quanta->statusBar()->setItemAlignment(IDS_STATUS, AlignLeft);
}


void QuantaInit::initDocument()
{
  m_quanta->m_doc = new QuantaDoc(0L);
  connect(m_quanta->m_doc, TQ_SIGNAL(newStatus()),
          m_quanta, TQ_SLOT(slotNewStatus()));
}

void QuantaInit::initProject()
{
  Project *m_project = Project::ref(m_quanta);

  connect(m_project, TQ_SIGNAL(getTreeStatus(TQStringList *)),
          pTab, TQ_SLOT(slotGetTreeStatus(TQStringList *)));
  connect(m_project, TQ_SIGNAL(loadToolbarFile(const KURL &)),
          m_quanta, TQ_SLOT(slotLoadToolbarFile(const KURL &)));
  connect(m_project, TQ_SIGNAL(getUserToolbarFiles(KURL::List *)),
          m_quanta, TQ_SLOT(slotGetUserToolbarFiles(KURL::List *)));
  connect(m_project, TQ_SIGNAL(openFiles(const KURL::List &, const TQString&)),
          m_quanta, TQ_SLOT(slotFileOpen(const KURL::List &, const TQString&)));
  connect(m_project, TQ_SIGNAL(openFile(const KURL &, const TQString&)),
          m_quanta, TQ_SLOT(slotFileOpen(const KURL &, const TQString&)));
  connect(m_project, TQ_SIGNAL(closeFile(const KURL &)),
          m_quanta, TQ_SLOT(slotFileClose(const KURL &)));
  connect(m_project, TQ_SIGNAL(reloadTree(ProjectList *, bool, const TQStringList &)),
          pTab, TQ_SLOT(slotReloadTree(ProjectList *, bool, const TQStringList &)));
  connect(m_project, TQ_SIGNAL(closeFiles()), ViewManager::ref(), TQ_SLOT(closeAll()));
  connect(m_project, TQ_SIGNAL(eventHappened(const TQString&, const TQString&, const TQString& )), QPEvents::ref(m_quanta), TQ_SLOT(slotEventHappened(const TQString&, const TQString&, const TQString& )));

  connect(m_quanta->fTab, TQ_SIGNAL(insertDirInProject(const KURL&)),
          m_project, TQ_SLOT(slotAddDirectory(const KURL&)));

  connect(m_quanta->fTab, TQ_SIGNAL(insertFileInProject(const KURL&)),
          m_project, TQ_SLOT(slotInsertFile(const KURL&)));

  connect(TemplatesTreeView::ref(), TQ_SIGNAL(insertDirInProject(const KURL&)),
          m_project, TQ_SLOT(slotAddDirectory(const KURL&)));

  connect(TemplatesTreeView::ref(), TQ_SIGNAL(insertFileInProject(const KURL&)),
          m_project, TQ_SLOT(slotInsertFile(const KURL&)));
  connect(TemplatesTreeView::ref(), TQ_SIGNAL(downloadTemplate()),
          m_quanta, TQ_SLOT(slotDownloadTemplate()));
  connect(TemplatesTreeView::ref(), TQ_SIGNAL(uploadTemplate(const TQString&)), m_quanta, TQ_SLOT(slotUploadTemplate(const TQString&)));

  // inform project if something was renamed
  connect(pTab, TQ_SIGNAL(renamed(const KURL&, const KURL&)),
          m_project, TQ_SLOT(slotRenamed(const KURL&, const KURL&)));
  connect(m_quanta->fTab, TQ_SIGNAL(renamed(const KURL&, const KURL&)),
          m_project, TQ_SLOT(slotRenamed(const KURL&, const KURL&)));
  connect(tTab, TQ_SIGNAL(renamed(const KURL&, const KURL&)),
          m_project, TQ_SLOT(slotRenamed(const KURL&, const KURL&)));

  connect(pTab, TQ_SIGNAL(insertToProject(const KURL&)),
          m_project, TQ_SLOT(slotInsertFile(const KURL&)));
  connect(pTab, TQ_SIGNAL(removeFromProject(const KURL&)),
          m_project, TQ_SLOT(slotRemove(const KURL&)));
  connect(pTab, TQ_SIGNAL(uploadSingleURL(const KURL&, const TQString&, bool, bool)),
          m_project, TQ_SLOT(slotUploadURL(const KURL&, const TQString&, bool, bool)));
  connect(pTab, TQ_SIGNAL(rescanProjectDir()), m_project, TQ_SLOT(slotRescanPrjDir()));
  connect(pTab, TQ_SIGNAL(showProjectOptions()), m_project, TQ_SLOT(slotOptions()));
  connect(pTab, TQ_SIGNAL(uploadProject()), m_project, TQ_SLOT(slotUpload()));

  connect(m_quanta->dTab, TQ_SIGNAL(reloadProjectDocs()), m_project, TQ_SLOT(slotReloadProjectDocs()));
  connect(m_project, TQ_SIGNAL(reloadProjectDocs()), m_quanta->dTab, TQ_SLOT(slotReloadProjectDocs()));
  connect(m_project, TQ_SIGNAL(addProjectDoc(const KURL&)), m_quanta->dTab, TQ_SLOT(slotAddProjectDoc(const KURL&)));

  connect(m_project, TQ_SIGNAL(enableMessageWidget()),
          m_quanta, TQ_SLOT(slotShowMessagesView()));

  connect(m_project, TQ_SIGNAL(messages(const TQString&)),
          m_quanta->m_messageOutput, TQ_SLOT(showMessage(const TQString&)));

  connect(m_project, TQ_SIGNAL(newStatus()),
          m_quanta, TQ_SLOT(slotNewStatus()));

  connect(m_project, TQ_SIGNAL(newProjectLoaded(const TQString &, const KURL &, const KURL &)),
          TemplatesTreeView::ref(), TQ_SLOT(slotNewProjectLoaded(const TQString &, const KURL &, const KURL &)));
  connect(m_project, TQ_SIGNAL(newProjectLoaded(const TQString &, const KURL &, const KURL &)),
          pTab, TQ_SLOT(slotNewProjectLoaded(const TQString &, const KURL &, const KURL &)));
  connect(m_project, TQ_SIGNAL(newProjectLoaded(const TQString &, const KURL &, const KURL &)),
          m_quanta->fTab, TQ_SLOT(slotNewProjectLoaded(const TQString &, const KURL &, const KURL &)));
  connect(m_project, TQ_SIGNAL(newProjectLoaded(const TQString &, const KURL &, const KURL &)),
          m_quanta->annotationOutput(), TQ_SLOT(updateAnnotations()));

  connect(pTab, TQ_SIGNAL(changeFileDescription(const KURL&, const TQString&)),
          m_project, TQ_SLOT(slotFileDescChanged(const KURL&, const TQString&)));
  connect(pTab, TQ_SIGNAL(changeUploadStatus(const KURL&, int)),
          m_project, TQ_SLOT(slotUploadStatusChanged(const KURL&, int)));
  connect(pTab, TQ_SIGNAL(changeDocumentFolderStatus(const KURL&, bool)),
          m_project, TQ_SLOT(slotChangeDocumentFolderStatus(const KURL&, bool)));

  connect(m_project, TQ_SIGNAL(hideSplash()), m_quanta, TQ_SLOT(slotHideSplash()));

  connect(m_project, TQ_SIGNAL(statusMsg(const TQString &)),
          m_quanta, TQ_SLOT(slotStatusMsg(const TQString & )));
}

void QuantaInit::initView()
{
  ViewManager *m_viewManager = ViewManager::ref(m_quanta);
  connect(m_quanta, TQ_SIGNAL(viewActivated (KMdiChildView *)), m_viewManager, TQ_SLOT(slotViewActivated(KMdiChildView*)));
  connect(m_quanta, TQ_SIGNAL(lastChildViewClosed()), m_viewManager, TQ_SLOT(slotLastViewClosed()));
//   connect(m_quanta, TQ_SIGNAL(viewDeactivated(KMdiChildView *)), m_viewManager, TQ_SLOT(slotViewDeactivated(KMdiChildView*)));
  KafkaDocument *m_kafkaDocument = KafkaDocument::ref(0, 0, "KafkaPart");
  m_kafkaDocument->getKafkaWidget()->view()->setMinimumHeight(50);
  m_kafkaDocument->readConfig(quantaApp->config());
  loadVPLConfig();
  ToolbarTabWidget *toolBarTab = ToolbarTabWidget::ref(quantaApp);
  connect(toolBarTab, TQ_SIGNAL(iconTextModeChanged()), quantaApp, TQ_SLOT(slotRefreshActiveWindow()));

  //set the toolview and close button style before the GUI is created
  m_config->setGroup("General Options");
  int iconTextMode = m_config->readNumEntry("IconTextMode", TDEToolBar::IconOnly);
  toolBarTab->setIconText(TDEToolBar::IconText(iconTextMode));
  qConfig.toolviewTabs = m_config->readNumEntry("MDI style", KMdi::IconOnly);
  m_quanta->initTabWidget();

  m_quanta->setStandardMDIMenuEnabled(false);
  m_quanta->setManagedDockPositionModeEnabled(true);

  m_quanta->fTab = new FilesTreeView(m_config, m_quanta, "filestree");
  m_quanta->aTab = new EnhancedTagAttributeTree(m_quanta, "TagAttributes");
  pTab = ProjectTreeView::ref(m_quanta, "Project");
  tTab = TemplatesTreeView::ref(m_quanta, "Templates");  // creates the treeview
  m_quanta->dTab = new DocTreeView(m_quanta, "Docs");
  StructTreeView *sTab = StructTreeView::ref(m_quanta ,"Struct");
  m_quanta->scriptTab = new ScriptTreeView(m_quanta, "Scripts");

  m_quanta->m_messageOutput = new MessageOutput(m_quanta, "Messages");
  m_quanta->m_messageOutput->setFocusPolicy(TQWidget::NoFocus);
  m_quanta->m_messageOutput->showMessage(i18n("Message Window..."));
  connect(m_quanta, TQ_SIGNAL(showMessage(const TQString&, bool)), m_quanta->m_messageOutput, TQ_SLOT(showMessage(const TQString&, bool)));
  connect(m_quanta, TQ_SIGNAL(clearMessages()), m_quanta->m_messageOutput, TQ_SLOT(clear()));

  m_quanta->m_problemOutput = new MessageOutput(m_quanta, "Problems");
  m_quanta->m_problemOutput->setFocusPolicy(TQWidget::NoFocus);
  m_quanta->m_annotationOutput = new AnnotationOutput(m_quanta, "Annotations");
  m_quanta->m_annotationOutput->setFocusPolicy(TQWidget::NoFocus);

  m_quanta->createPreviewPart();
  m_quanta->createDocPart();

  connect(m_quanta, TQ_SIGNAL(reloadAllTrees()),
          m_quanta->fTab, TQ_SLOT(slotReloadAllTrees()));

  connect(pTab, TQ_SIGNAL(loadToolbarFile  (const KURL&)),
          m_quanta, TQ_SLOT(slotLoadToolbarFile(const KURL&)));
  connect(m_viewManager, TQ_SIGNAL(viewActivated(const KURL&)),
          pTab, TQ_SLOT(slotViewActivated(const KURL&)));

  connect(m_viewManager, TQ_SIGNAL(documentClosed(const KURL&)),
          pTab, TQ_SLOT(slotDocumentClosed(const KURL&)));
  connect(m_viewManager, TQ_SIGNAL(documentClosed(const KURL&)),
          tTab, TQ_SLOT(slotDocumentClosed(const KURL&)));
  connect(m_viewManager, TQ_SIGNAL(documentClosed(const KURL&)),
          m_quanta->scriptTab, TQ_SLOT(slotDocumentClosed(const KURL&)));
  connect(m_viewManager, TQ_SIGNAL(documentClosed(const KURL&)),
          m_quanta->fTab, TQ_SLOT(slotDocumentClosed(const KURL&)));

  connect(tTab, TQ_SIGNAL(insertFile  (const KURL &)),
          m_quanta, TQ_SLOT(slotInsertFile(const KURL &)));

  connect(m_quanta->scriptTab, TQ_SIGNAL(openFileInPreview(const KURL &)),
          m_quanta, TQ_SLOT(slotOpenFileInPreview(const KURL &)));
  connect(m_quanta->scriptTab, TQ_SIGNAL(showPreviewWidget(bool)),
          m_quanta, TQ_SLOT(slotShowPreviewWidget(bool)));
  connect(m_quanta->scriptTab, TQ_SIGNAL(assignActionToScript(const KURL &, const TQString&)),
          m_quanta, TQ_SLOT(slotAssignActionToScript(const KURL &, const TQString&)));
  connect(m_quanta->scriptTab, TQ_SIGNAL(downloadScript()), m_quanta, TQ_SLOT(slotDownloadScript()));
  connect(m_quanta->scriptTab, TQ_SIGNAL(uploadScript(const TQString&)), m_quanta, TQ_SLOT(slotUploadScript(const TQString&)));
  connect(m_quanta->dTab, TQ_SIGNAL(downloadDoc()), m_quanta, TQ_SLOT(slotDownloadDoc()));

  connect(m_quanta->m_htmlPart, TQ_SIGNAL(onURL(const TQString&)),
              m_quanta, TQ_SLOT(slotStatusMsg(const TQString&)));
  connect(m_quanta->m_htmlPartDoc, TQ_SIGNAL(onURL(const TQString&)),
                 m_quanta, TQ_SLOT(slotStatusMsg(const TQString&)));

  connect(sTab, TQ_SIGNAL(newCursorPosition(int,int)), m_quanta, TQ_SLOT(setCursorPosition(int,int)));
  connect(sTab, TQ_SIGNAL(selectArea(int,int,int,int)), m_quanta, TQ_SLOT( selectArea(int,int,int,int)));
  connect(sTab, TQ_SIGNAL(selectTagArea(Node*)), m_quanta, TQ_SLOT(slotSelectTagArea(Node*)));
  connect(sTab, TQ_SIGNAL(needReparse()), m_quanta, TQ_SLOT(slotForceReparse()));
  connect(sTab, TQ_SIGNAL(showGroupsForDTEP(const TQString&, bool)), m_quanta, TQ_SLOT(slotShowGroupsForDTEP(const TQString&, bool)));
  connect(sTab, TQ_SIGNAL(openFile(const KURL &)),
          m_quanta, TQ_SLOT  (slotFileOpen(const KURL &)));
  connect(sTab, TQ_SIGNAL(openImage  (const KURL&)),
          m_quanta, TQ_SLOT(slotImageOpen(const KURL&)));
  connect(sTab, TQ_SIGNAL(showProblemMessage(const TQString&)),
          m_quanta->m_problemOutput, TQ_SLOT(showMessage(const TQString&)));
  connect(sTab, TQ_SIGNAL(clearProblemOutput()),
          m_quanta->m_problemOutput, TQ_SLOT(clear()));
  connect(parser, TQ_SIGNAL(nodeTreeChanged()), sTab, TQ_SLOT(slotNodeTreeChanged()));

  connect(m_quanta->dTab, TQ_SIGNAL(openURL(const TQString&)), m_quanta, TQ_SLOT(openDoc(const TQString&)));

  connect(m_viewManager, TQ_SIGNAL(dragInsert(TQDropEvent *)), tTab, TQ_SLOT(slotDragInsert(TQDropEvent *)));

  qConfig.windowLayout = "Default";
}

KMdiToolViewAccessor* QuantaInit::addToolTreeView(TQWidget *widget, const TQString &name, const TQPixmap &icon, KDockWidget::DockPosition position)
{
  widget->setIcon(icon);
  widget->setCaption(name);
  return m_quanta->addToolWindow(widget, m_quanta->prevDockPosition(widget, position), m_quanta->getMainDockWidget());
}

void QuantaInit::readOptions()
{
  m_config->setGroup("General Options");

  qConfig.markupMimeTypes = m_config->readEntry("Markup mimetypes", qConfig.markupMimeTypes);
  qConfig.scriptMimeTypes = m_config->readEntry("Script mimetypes", qConfig.scriptMimeTypes);
  qConfig.imageMimeTypes = m_config->readEntry("Image mimetypes", qConfig.imageMimeTypes);
  qConfig.textMimeTypes = m_config->readEntry("Text mimetypes", qConfig.textMimeTypes);

  qConfig.tagCase = m_config->readNumEntry("Capitals for tags", 0);
  qConfig.attrCase = m_config->readNumEntry("Capitals for attr", 0);
  qConfig.attrValueQuotation = (m_config->readEntry("Attribute quotation", "double") == "double" )? '"':'\'';
  qConfig.closeOptionalTags = m_config->readBoolEntry("Close tag if optional", true);
  qConfig.closeTags = m_config->readBoolEntry("Close tags", true);
  qConfig.useAutoCompletion = m_config->readBoolEntry("Auto completion",true);
  qConfig.updateClosingTags = m_config->readBoolEntry("Update Closing Tags", true);
  qConfig.replaceAccented = m_config->readBoolEntry("Replace Accented Chars", false);
  qConfig.replaceNotInEncoding = m_config->readBoolEntry("Replace Chars Not In Current Encoding", true);


  qConfig.defaultEncoding = m_config->readEntry("Default encoding", "UTF8");

  StructTreeView::ref()->setFollowCursor( m_config->readBoolEntry("Follow Cursor", true));

  qConfig.previewPosition   = m_config->readEntry("Preview area","Editor");
  qConfig.docPosition   = m_config->readEntry("Documentation area","Tab");

  qConfig.smartTagInsertion = m_config->readBoolEntry("Smart Tag Insertion", false);
  TDEAction *action = quantaApp->actionCollection()->action("smart_tag_insertion");
  (static_cast<TDEToggleAction* >(action))->setChecked(qConfig.smartTagInsertion);

  TQSize s(800,580);
  m_quanta->resize( m_config->readSizeEntry("Geometry", &s));
  qConfig.autosaveInterval = m_config->readNumEntry("Autosave interval", 1);

  qConfig.enableDTDToolbar = m_config->readBoolEntry("Show DTD Toolbar",true);
  m_quanta->showDTDToolbar->setChecked(qConfig.enableDTDToolbar);
  qConfig.showCloseButtons = m_config->readEntry("Close Buttons", "ShowDelayed");
//  m_quanta->initTabWidget(true);
  m_quanta->fileRecent ->loadEntries(m_config);
  qConfig.showHiddenFiles = m_config->readBoolEntry("Show Hidden Files", true);
  qConfig.saveTrees = m_config->readBoolEntry("Save Local Trees", true);
  int maxRecentItems = m_config->readNumEntry("Recent Files Limit", 32);
  m_quanta->fileRecent->setMaxItems(maxRecentItems);

  m_config->setGroup("Parser options");
  qConfig.showEmptyNodes = m_config->readBoolEntry("Show Empty Nodes", false);
  qConfig.showClosingTags = m_config->readBoolEntry("Show Closing Tags", false);
  qConfig.instantUpdate = m_config->readBoolEntry("Instant Update", false);
  qConfig.refreshFrequency = m_config->readNumEntry("Refresh frequency",5);
  qConfig.expandLevel = m_config->readNumEntry("Expand Level", 4);
  qConfig.showDTDSelectDialog = m_config->readBoolEntry("Show DTD Select Dialog", true);

  m_quanta->m_previewVisible = false;
  m_quanta->m_noFramesPreview = false;

  m_quanta->showVPLAction->setChecked( false );


//TDENewStuff config
   m_config->setGroup("TDENewStuff");
   TQString str = m_config->readEntry("ProvidersUrl");
   if (str.isEmpty())
   {
      m_config->writeEntry( "ProvidersUrl", "https://www.trinitydesktop.org/ocs/providers.xml" );
      m_config->sync();
   }


  Project::ref()->readConfig(m_config); // project
}

void QuantaInit::openLastFiles()
{

  // Reload previously opened files only if setting allows
  m_config->setGroup("General Options");
  if (!m_config->readBoolEntry("Reload Files", true))
  {
    m_quanta->setParserEnabled(true);
    m_quanta->reparse(true);
    return;
  }
  // we need to check config
  // because project now can be
  // in load stage ( remote prj )
  m_config->setGroup("Projects");
  TQString pu = QuantaCommon::readPathEntry(m_config, "Last Project");

  KURL u;
  QuantaCommon::setUrl(u, pu);
  bool isPrj = true;
  if (pu.isEmpty())
     isPrj = false;
  if (!u.isValid())
     isPrj = false;

  m_config->setGroup("General Options");

  TQStringList urls = QuantaCommon::readPathListEntry(m_config, "List of opened files");
  TQStringList encodings = QuantaCommon::readPathListEntry(m_config, "Encoding of opened files");
  m_quanta->m_doc->blockSignals(true);
  m_quanta->setParserEnabled(false);
  uint i = 0;
  for ( TQStringList::Iterator it = urls.begin(); it != urls.end(); ++it )
  {
    KURL fu;
    QuantaCommon::setUrl(fu, *it);

    if (!ViewManager::ref()->isOpened(fu) && (!isPrj || fu.isLocalFile()))
      m_quanta->slotFileOpen(fu, encodings[i]);
    i++;
  }
  m_config->sync();
  m_quanta->m_doc->blockSignals(false);
  m_quanta->setParserEnabled(true);
  m_quanta->reparse(true);
  Document *w = ViewManager::ref()->activeDocument();
  if (w) //w==0 might happen on quick close on startup
  {
    m_quanta->setTitle(w->url().prettyURL(0, KURL::StripFileProtocol) );
//    m_quanta->slotUpdateStatus(w);//FIXME:
  }
}

/** Loads the initial project */
void QuantaInit::loadInitialProject(const TQString& url)
{
  if(url.isNull())
  {
    if(runningQuantas() == 1)
    {
      // Get config
      TDEConfig *config = m_quanta->config();
      config->setGroup("General Options");

      // Reload last project if setting is enabled
      Project::ref()->loadLastProject(config->readBoolEntry("Reload Project", true));
    }
  }
  else
    Project::ref()->slotOpenProject(KURL( url ));
}


void QuantaInit::initActions()
{
    TDEActionCollection *ac = m_quanta->actionCollection();
    new TDEAction(i18n("Annotate..."), 0, m_quanta, TQ_SLOT(slotAnnotate()),ac, "annotate");
    m_quanta->editTagAction = new TDEAction( i18n( "&Edit Current Tag..." ), CTRL+Key_E,
                        m_quanta, TQ_SLOT( slotEditCurrentTag() ),
                        ac, "edit_current_tag" );
    m_quanta->selectTagAreaAction = new TDEAction( i18n( "&Select Current Tag Area" ), 0,
                        m_quanta, TQ_SLOT( slotSelectTagArea() ),
                        ac, "select_tag_area" );
    new TDEAction( i18n( "E&xpand Abbreviation" ), CTRL+SHIFT+Key_J,
                        m_quanta, TQ_SLOT( slotExpandAbbreviation() ),
                        ac, "expand_abbreviation" );

    new TDEAction(i18n("&Report Bug..."), 0, m_quanta, TQ_SLOT(slotReportBug()), ac, "help_reportbug"); //needed, because quanta_be bugs should be reported for quanta

    //Kate actions

//Edit menu
    KStdAction::undo(m_quanta, TQ_SLOT(slotUndo()), ac);
    KStdAction::redo(m_quanta, TQ_SLOT(slotRedo()), ac);
    KStdAction::cut(m_quanta, TQ_SLOT(slotCut()), ac);
    KStdAction::copy(m_quanta, TQ_SLOT(slotCopy()), ac) ;
    KStdAction::pasteText(m_quanta, TQ_SLOT(slotPaste()), ac);

//help
   (void) new TDEAction(i18n("Ti&p of the Day"), "idea", "", m_quanta,
      TQ_SLOT(slotHelpTip()), ac, "help_tip");

    // File actions
    //
    KStdAction::openNew( m_quanta, TQ_SLOT( slotFileNew()  ), ac);
    KStdAction::open   ( m_quanta, TQ_SLOT( slotFileOpen() ), ac, "file_open");
    (void) new TDEAction(i18n("Close Other Tabs"), 0, ViewManager::ref(), TQ_SLOT(slotCloseOtherTabs()), ac, "close_other_tabs");

    m_quanta->fileRecent =  KStdAction::openRecent(m_quanta, TQ_SLOT(slotFileOpenRecent(const KURL&)),
                                         ac, "file_open_recent");
    m_quanta->fileRecent->setToolTip(i18n("Open / Open Recent"));
    connect(m_quanta->fileRecent, TQ_SIGNAL(activated()), m_quanta, TQ_SLOT(slotFileOpen()));

    (void) new TDEAction( i18n( "Close All" ), 0, m_quanta,
                        TQ_SLOT( slotFileCloseAll() ),
                        ac, "file_close_all" );

    m_quanta->saveAction = KStdAction::save(m_quanta, TQ_SLOT( slotFileSave() ), ac);

    KStdAction::saveAs( m_quanta, TQ_SLOT( slotFileSaveAs() ), ac );

    m_quanta->saveAllAction = new TDEAction( i18n( "Save All..." ), "save_all", SHIFT+TDEStdAccel::shortcut(TDEStdAccel::Save).keyCodeQt(),
                        m_quanta, TQ_SLOT( slotFileSaveAll() ),
                        ac, "file_save_all" );
    (void)  new TDEAction(i18n("Reloa&d"), "document-revert", SHIFT+Key_F5, m_quanta,
                        TQ_SLOT(slotFileReload()), ac, "file_reload");
//    (void)  new TDEAction(i18n("Reload All "), 0, 0, m_quanta,
//                        TQ_SLOT(slotFileReloadAll()), ac, "file_reload_all");

    (void) new TDEAction( i18n( "Save as Local Template..." ), 0,
                        m_quanta, TQ_SLOT( slotFileSaveAsLocalTemplate() ),
                        ac, "save_local_template" );

    (void) new TDEAction( i18n( "Save Selection to Local Template File..." ), 0,
                        m_quanta, TQ_SLOT( slotFileSaveSelectionAsLocalTemplate() ),
                        ac, "save_selection_local_template" );

    KStdAction::quit( m_quanta, TQ_SLOT( slotFileQuit() ), ac );

    // Edit actions

    (void) new TDEAction( i18n( "Find in Files..." ),
                        SmallIcon("filefind"), CTRL+ALT+Key_F,
                        m_quanta, TQ_SLOT( slotEditFindInFiles() ),
                        ac, "find_in_files" );

    TDEAction* aux = TagActionManager::self()->actionCollection()->action("apply_source_indentation");
    aux->setEnabled(false);
    ac->insert(aux);

    // Tool actions

    (void) new TDEAction( i18n( "&Context Help..." ), CTRL+Key_H,
                        m_quanta, TQ_SLOT( slotContextHelp() ),
                        ac, "context_help" );

    (void) new TDEAction( i18n( "Tag &Attributes..." ), ALT+Key_Down,
                        m_quanta->m_doc, TQ_SLOT( slotAttribPopup() ),
                        ac, "tag_attributes" );

    (void) new TDEAction( i18n( "&Change the DTD..." ), 0,
                        m_quanta, TQ_SLOT( slotChangeDTD() ),
                        ac, "change_dtd" );

    (void) new TDEAction( i18n( "&Edit DTD Settings..." ), 0,
    m_quanta, TQ_SLOT( slotEditDTD() ),
    ac, "edit_dtd" );

    (void) new TDEAction( i18n( "&Load && Convert DTD..." ), 0,
                        DTDs::ref(), TQ_SLOT( slotLoadDTD() ),
                        ac, "load_dtd" );
    (void) new TDEAction( i18n( "Load DTD E&ntities..." ), 0,
                        DTDs::ref(), TQ_SLOT( slotLoadEntities() ),
                        ac, "load_entities" );

    (void) new TDEAction( i18n( "Load DTD &Package (DTEP)..." ), 0,
                        m_quanta, TQ_SLOT( slotLoadDTEP() ),
                        ac, "load_dtep" );

    (void) new TDEAction( i18n( "Send DTD Package (DTEP) in E&mail..." ), "mail-send", 0,
                        m_quanta, TQ_SLOT( slotEmailDTEP() ),
                        ac, "send_dtep" );

    (void) new TDEAction( i18n( "&Download DTD Package (DTEP)..." ), "network", 0,
                        m_quanta, TQ_SLOT( slotDownloadDTEP() ),
                        ac, "download_dtep" );
    (void) new TDEAction( i18n( "&Upload DTD Package (DTEP)..." ), "network", 0,
                        m_quanta, TQ_SLOT( slotUploadDTEP() ),
                        ac, "upload_dtep" );
/*
    (void) new TDEAction( i18n( "&Upload DTD Package (DTEP)..." ), 0,
                        m_quanta, TQ_SLOT( slotUploadDTEP() ),
                        ac, "send_dtep" );
*/
    (void) new TDEAction( i18n( "&Document Properties" ), 0,
                        m_quanta, TQ_SLOT( slotDocumentProperties() ),
                        ac, "tools_document_properties" );

    (void) new TDEAction ( i18n ("F&ormat XML Code"), 0,
                        m_quanta, TQ_SLOT( slotCodeFormatting() ),
                        ac, "tools_code_formatting");

    (void) new TDEAction( i18n( "&Convert Tag && Attribute Case..."), 0,
                        m_quanta, TQ_SLOT(slotConvertCase()),
                        ac, "tools_change_case");

    // View actions


    m_quanta->showSourceAction =
      new TDEToggleAction( i18n( "&Source Editor"), UserIcon ("view_text"), ALT+Key_F9,
                         m_quanta, TQ_SLOT( slotShowSourceEditor()),
                         ac, "show_quanta_editor");
    m_quanta->showSourceAction->setExclusiveGroup("view");

    m_quanta->showVPLAction =
      new TDEToggleAction( i18n( "&VPL Editor"), UserIcon ("vpl"), CTRL+SHIFT+Key_F9,
      m_quanta, TQ_SLOT( slotShowVPLOnly() ),
                          ac, "show_kafka_view");
    m_quanta->showVPLAction->setExclusiveGroup("view");

    m_quanta->showVPLSourceAction =
      new TDEToggleAction( i18n("VPL && So&urce Editors"), UserIcon ("vpl_text"), Key_F9,
                         m_quanta, TQ_SLOT( slotShowVPLAndSourceEditor() ),
                          ac, "show_kafka_and_quanta");
    m_quanta->showVPLSourceAction->setExclusiveGroup("view");
    /**kafkaSelectAction = new TDESelectAction(i18n("Main &View"), 0, ac,"show_kafka");
    TQStringList list2;
    list2.append(i18n("&Source Editor"));
    list2.append(i18n("&VPL Editor (experimental)"));
    list2.append(i18n("&Both Editors"));
    kafkaSelectAction->setItems(list2);
    connect(kafkaSelectAction, TQ_SIGNAL(activated(int)), m_quanta, TQ_SLOT(slotShowKafkaPartl(int)));*/


    (void) new TDEAction( i18n( "&Reload Preview" ), "reload",
                        TDEStdAccel::shortcut(TDEStdAccel::Reload).keyCodeQt(),
                        m_quanta, TQ_SLOT(slotRepaintPreview()),
                        ac, "reload" );

    (void) new TDEAction( i18n( "&Previous File" ), "1leftarrow", TDEStdAccel::back(),
                        m_quanta, TQ_SLOT( slotBack() ),
                        ac, "previous_file" );

    (void) new TDEAction( i18n( "&Next File" ), "1rightarrow", TDEStdAccel::forward(),
                        m_quanta, TQ_SLOT( slotForward() ),
                        ac, "next_file" );

    // Options actions
    //

    (void) new TDEAction( i18n( "Configure &Actions..." ), UserIcon("ball"),0,
                        m_quanta, TQ_SLOT( slotOptionsConfigureActions() ),
                        ac, "configure_actions" );

    KStdAction::showMenubar(m_quanta, TQ_SLOT(slotShowMenuBar()), ac, "options_show_menubar");
    KStdAction::keyBindings(m_quanta, TQ_SLOT( slotOptionsConfigureKeys() ), ac, "configure_shortcuts");
    KStdAction::configureToolbars(m_quanta, TQ_SLOT( slotOptionsConfigureToolbars() ), ac, "options_configure_toolbars");
    KStdAction::preferences(m_quanta, TQ_SLOT( slotOptions() ), ac, "general_options");
    new TDEAction(i18n("Configure Pre&view..."), SmallIcon("konqueror"), 0, m_quanta, TQ_SLOT(slotPreviewOptions()), ac, "preview_options");

    // Toolbars actions
    m_quanta->projectToolbarFiles = new TDERecentFilesAction(i18n("Load &Project Toolbar"),0,
                                                           m_quanta, TQ_SLOT(slotLoadToolbarFile(const KURL&)),
                                                           ac, "toolbars_load_project");

    new TDEAction(i18n("Load &Global Toolbar..."), 0, m_quanta, TQ_SLOT(slotLoadGlobalToolbar()), ac, "toolbars_load_global");
    new TDEAction(i18n("Load &Local Toolbar..."), 0, m_quanta, TQ_SLOT(slotLoadToolbar()), ac, "toolbars_load_user");
    new TDEAction(i18n("Save as &Local Toolbar..."), 0, m_quanta, TQ_SLOT(slotSaveLocalToolbar()), ac, "toolbars_save_local");
    new TDEAction(i18n("Save as &Project Toolbar..."), 0, m_quanta, TQ_SLOT(slotSaveProjectToolbar()), ac, "toolbars_save_project");
    new TDEAction(i18n("&New User Toolbar..."),  0, m_quanta, TQ_SLOT(slotAddToolbar()), ac, "toolbars_add");
    new TDEAction(i18n("&Remove User Toolbar..."), 0, m_quanta, TQ_SLOT(slotRemoveToolbar()), ac, "toolbars_remove");
    new TDEAction(i18n("Re&name User Toolbar..."), 0, m_quanta, TQ_SLOT(slotRenameToolbar()), ac, "toolbars_rename");
    new TDEAction(i18n("Send Toolbar in E&mail..."), "mail-send", 0, m_quanta, TQ_SLOT(slotSendToolbar()), ac, "toolbars_send");
    new TDEAction(i18n("&Upload Toolbar..." ), "network", 0, m_quanta, TQ_SLOT(slotUploadToolbar()), ac, "toolbars_upload" );
    new TDEAction(i18n("&Download Toolbar..." ), "network", 0, m_quanta, TQ_SLOT(slotDownloadToolbar()), ac, "toolbars_download" );

    TDEToggleAction *toggle = new TDEToggleAction( i18n("Smart Tag Insertion"), 0, ac, "smart_tag_insertion");
    connect(toggle, TQ_SIGNAL(toggled(bool)), m_quanta, TQ_SLOT(slotSmartTagInsertion()));

    m_quanta->showDTDToolbar=new TDEToggleAction(i18n("Show DTD Toolbar"), 0, ac, "view_dtd_toolbar");

    connect(m_quanta->showDTDToolbar, TQ_SIGNAL(toggled(bool)), m_quanta, TQ_SLOT(slotToggleDTDToolbar(bool)));
    m_quanta->showDTDToolbar->setCheckedState(i18n("Hide DTD Toolbar"));

    new TDEAction(i18n("Complete Text"), CTRL+Key_Space,
                m_quanta, TQ_SLOT(slotShowCompletion()), ac,"show_completion");
    new TDEAction(i18n("Completion Hints"), CTRL+SHIFT+Key_Space,
                m_quanta, TQ_SLOT(slotShowCompletionHint()), ac,"show_completion_hint");

    KStdAction::back(m_quanta, TQ_SLOT( slotBack() ), ac, "w_back");
    KStdAction::forward(m_quanta, TQ_SLOT( slotForward() ), ac, "w_forward");

    new TDEAction(i18n("Open File: none"), 0, m_quanta, TQ_SLOT(slotOpenFileUnderCursor()), ac, "open_file_under_cursor");
    new TDEAction(i18n("Upload..."), 0, m_quanta, TQ_SLOT(slotUploadFile()), ac, "upload_file");
    new TDEAction(i18n("Delete File"), 0, m_quanta, TQ_SLOT(slotDeleteFile()), ac, "delete_file");

    TQString ss = i18n("Upload Opened Project Files...");
/*    new TDEAction(i18n("Upload Opened Project Files"), 0, m_quanta, TQ_SLOT(slotUploadOpenedFiles()), ac, "upload_opened_files"); */

    TQString error;
    int el, ec;
    m_quanta->m_actions = new TQDomDocument();
//load the global actions
    TQFile f(qConfig.globalDataDir + resourceDir + "actions.rc");
    if ( f.open( IO_ReadOnly ))
    {
      if (m_quanta->m_actions->setContent(&f, &error, &el, &ec))
      {
        TQDomElement docElem = m_quanta->m_actions->documentElement();

        TQDomNode n = docElem.firstChild();
        while( !n.isNull() ) {
          TQDomElement e = n.toElement(); // try to convert the node to an element.
          if( !e.isNull() ) { // the node was really an element.
              bool toggable = (e.attribute("toggable", "") == "true");
              new TagAction(&e, m_quanta, toggable);
          }
          n = n.nextSibling();
        }
      } else
        kdError(24000) << TQString("Error %1 at (%2, %3) in %4").arg(error).arg(el).arg(ec).arg(f.name()) << endl;
      f.close();
    }
    m_quanta->m_actions->clear();
//read the user defined actions
    TQString s = locateLocal("appdata","actions.rc");
    if (!s.isEmpty())
    {
      f.setName(s);
      if ( f.open( IO_ReadOnly ))
      {
        if (m_quanta->m_actions->setContent(&f, &error, &el, &ec))
        {
          TQDomElement docElem = m_quanta->m_actions->documentElement();

          TQDomNode n = docElem.firstChild();
          while( !n.isNull() ) {
            TQDomElement e = n.toElement(); // try to convert the node to an element.
            if( !e.isNull())
            { // the node was really an element.
                delete ac->action(e.attribute("name").ascii());
                bool toggable = (e.attribute("toggable", "") == "true");
                new TagAction(&e, m_quanta, toggable);
            }
            n = n.nextSibling();
          }
        } else
        kdError(24000) << TQString("Error %1 at (%2, %3) in %4").arg(error).arg(el).arg(ec).arg(f.name()) << endl;
        f.close();
      }
    } else
    {
      m_quanta->m_actions->setContent(s);
    }

    // create the preview action
    m_quanta->showPreviewAction =
      new TDEToolBarPopupAction( i18n( "&Preview" ), "preview", Key_F6,
                         m_quanta, TQ_SLOT( slotToggleShowPreview() ),
                         ac, "show_preview" );

    TDEAction *act = new TDEAction( i18n( "Preview Without Frames" ), "", 0,
                                  m_quanta, TQ_SLOT(slotShowNoFramesPreview()),
                                  ac, "show_preview_no_frames" );
    act->plug(m_quanta->showPreviewAction->popupMenu());

    act = new TDEAction( i18n( "View with &Konqueror" ), "konqueror", Key_F12,
                        m_quanta, TQ_SLOT( slotViewInKFM() ),
                        ac, "view_with_konqueror" );
    act->plug(m_quanta->showPreviewAction->popupMenu());


    act = ac->action("view_with_firefox");
    if (act)
      act->plug(m_quanta->showPreviewAction->popupMenu());

    act = ac->action("view_with_mozilla");
    if (act)
      act->plug(m_quanta->showPreviewAction->popupMenu());

    act = ac->action("view_with_netscape");
    if (act)
      act->plug(m_quanta->showPreviewAction->popupMenu());

    act = ac->action("view_with_opera");
    if (act)
      act->plug(m_quanta->showPreviewAction->popupMenu());

    act = new TDEAction( i18n( "View with L&ynx" ), "terminal", 0,
                        m_quanta, TQ_SLOT( slotViewInLynx() ),
                        ac, "view_with_lynx" );
    act->plug(m_quanta->showPreviewAction->popupMenu());


    (void) new TDEAction( i18n( "Table Editor..." ), "quick_table", 0,
                        m_quanta, TQ_SLOT( slotTagEditTable() ),
                        ac, "tag_edit_table" );

    (void) new TDEAction( i18n( "Quick List..." ), "quick_list", 0,
                        m_quanta, TQ_SLOT( slotTagQuickList() ),
                        ac, "tag_quick_list" );

    (void) new TDEAction( i18n( "Color..." ), "colorize", CTRL+SHIFT+Key_C,
                        m_quanta, TQ_SLOT( slotTagColor() ),
                        ac, "tag_color" );


    (void) new TDEAction( i18n( "Email..." ), "tag_mail", 0,
                        m_quanta, TQ_SLOT( slotTagMail() ),
                        ac, "tag_mail" );

    (void) new TDEAction( i18n( "Misc. Tag..." ), "tag_misc", CTRL+SHIFT+Key_T,
                        m_quanta, TQ_SLOT( slotTagMisc() ),
                        ac, "tag_misc" );

    (void) new TDEAction( i18n( "Frame Wizard..." ), "frame", 0,
                        m_quanta, TQ_SLOT( slotFrameWizard() ),
                        ac, "tag_frame_wizard" );

    (void) new TDEAction( i18n( "Paste &HTML Quoted" ), "edit-paste", 0,
                        m_quanta, TQ_SLOT( slotPasteHTMLQuoted() ),
                        ac, "edit_paste_html_quoted" );

    (void) new TDEAction( i18n( "Paste &URL Encoded" ), "edit-paste", 0,
                        m_quanta, TQ_SLOT( slotPasteURLEncoded() ),
                        ac, "edit_paste_url_encoded" );

    (void) new TDEAction( i18n( "Insert CSS..." ),"css", 0,
                        m_quanta, TQ_SLOT( slotInsertCSS() ),
                        ac, "insert_css" );

    // special-character combo
    TDEAction* char_action = new TDEAction(
                        i18n( "Insert Special Character" ), "charset", 0,
                        ac, "insert_char" );
    connect( char_action, TQ_SIGNAL(activated()),
             m_quanta, TQ_SLOT(slotInsertChar()) );

    connect(m_quanta, TQ_SIGNAL(eventHappened(const TQString&, const TQString&, const TQString& )), QPEvents::ref(m_quanta), TQ_SLOT(slotEventHappened(const TQString&, const TQString&, const TQString& )));
    connect(m_quanta->doc(), TQ_SIGNAL(eventHappened(const TQString&, const TQString&, const TQString& )), QPEvents::ref(m_quanta), TQ_SLOT(slotEventHappened(const TQString&, const TQString&, const TQString& )));
    connect(ViewManager::ref(), TQ_SIGNAL(eventHappened(const TQString&, const TQString&, const TQString& )), QPEvents::ref(m_quanta), TQ_SLOT(slotEventHappened(const TQString&, const TQString&, const TQString& )));

    QuantaBookmarks *m_bookmarks = new QuantaBookmarks(ViewManager::ref(m_quanta));
    m_bookmarks->createActions(ac);
    connect(m_bookmarks, TQ_SIGNAL(gotoFileAndLine(const TQString&, int, int)), m_quanta, TQ_SLOT(gotoFileAndLine(const TQString&, int, int)));
}

/** Initialize the plugin architecture. */
void QuantaInit::initPlugins()
{
  // TODO : read option from plugins.rc to see if we should validate the plugins

  m_quanta->m_pluginInterface = QuantaPluginInterface::ref(m_quanta);

  connect(m_quanta->m_pluginInterface, TQ_SIGNAL(hideSplash()),
          m_quanta, TQ_SLOT(slotHideSplash()));
  connect(m_quanta->m_pluginInterface, TQ_SIGNAL(statusMsg(const TQString &)),
          m_quanta, TQ_SLOT(slotStatusMsg(const TQString & )));

  m_quanta->m_pluginInterface->readConfig();
  if (!m_quanta->m_pluginInterface->pluginAvailable("TDEFileReplace"))
  {
    delete m_quanta->actionCollection()->action("find_in_files");
  }
}


void QuantaInit::recoverCrashed(TQStringList& recoveredFileNameList)
{
  m_quanta->m_doc->blockSignals(true);

  execCommandPS("ps -C quanta -C quanta_be -o pid --no-headers");
  m_PIDlist = TQStringList::split("\n", m_quanta->m_scriptOutput);

  m_config->setGroup("Projects");
  TQString pu = QuantaCommon::readPathEntry(m_config, "Last Project");

  KURL u;
  QuantaCommon::setUrl(u, pu);
  bool isPrj = true;
  if (pu.isEmpty())
     isPrj = false;
  if (!u.isValid())
     isPrj = false;

  m_config->reparseConfiguration();
  m_config->setGroup("General Options");

  TQStringList backedUpUrlsList = QuantaCommon::readPathListEntry(m_config, "List of backedup files");
  TQStringList autosavedUrlsList = QuantaCommon::readPathListEntry(m_config, "List of autosaved files");

  TQStringList::ConstIterator backedUpUrlsEndIt = backedUpUrlsList.constEnd();
  for (TQStringList::ConstIterator backedUpUrlsIt = backedUpUrlsList.constBegin();
       backedUpUrlsIt != backedUpUrlsEndIt; ++backedUpUrlsIt )
  {
    // when quanta crashes and file autoreloading option is on
    // then if user restarts quanta, the backup copies will reload
    TQString backedUpFileName = (*backedUpUrlsIt).left((*backedUpUrlsIt).findRev(".")); //the filename without the PID
    bool notFound;
    TQString autosavedPath = searchPathListEntry(backedUpFileName, autosavedUrlsList, notFound);
    if (!autosavedPath.isEmpty()) //the current item was autosaved and is not in use by another Quanta
    {
      KURL originalVersion;
      KURL autosavedVersion;
      QuantaCommon::setUrl(originalVersion, backedUpFileName);
      QuantaCommon::setUrl(autosavedVersion, autosavedPath);
      bool isUntitledDocument = false;
      if (autosavedVersion.path().right(1) == "U")
        isUntitledDocument = true;
      if (!isPrj || originalVersion.isLocalFile())
      {
        //find some information about local files
        TDEIO::UDSEntry entry;
        TDEIO::NetAccess::stat(originalVersion, entry, m_quanta);
        KFileItem* item= new KFileItem(entry, originalVersion, false, true);
        TQString origTime = item->timeString();
        TDEIO::filesize_t origSize = item->size();
        delete item;
        TDEIO::NetAccess::stat(autosavedVersion, entry, m_quanta);
        item= new KFileItem(entry, autosavedVersion, false, true);
        TQString backupTime = item->timeString();
        TDEIO::filesize_t backupSize = item->size();
        delete item;

        if (TQFileInfo(autosavedPath).exists()) //if the backup file exists
        {
          emit hideSplash();
          DirtyDlg *dlg = new DirtyDlg(autosavedVersion.path(), originalVersion.path(), false, m_quanta);
          dlg->setCaption(i18n("Restore File"));
          DirtyDialog *w = static_cast<DirtyDialog*>(dlg->mainWidget());
          w->textLabel->setText(i18n("<qt>A backup copy of a file was found:<br><br>"
            "Original file: <b>%1</b><br>"
            "Original file size: <b>%2</b><br>"
            "Original file last modified on: <b>%3</b><br><br>"
            "Backup file size: <b>%4</b><br>"
            "Backup created on: <b>%5</b><br><br>"
            "</qt>")
            .arg(originalVersion.prettyURL(0, KURL::StripFileProtocol ))
            .arg(TDEIO::convertSize(origSize)).arg(origTime)
            .arg(TDEIO::convertSize(backupSize)).arg(backupTime));
          w->buttonLoad->setText(i18n("&Restore the file from backup"));
          w->buttonIgnore->setText(i18n("Do &not restore the file from backup"));
          delete w->warningLabel;
          w->warningLabel = 0L;
          w->setMinimumHeight(320);
          dlg->adjustSize();
          if (TDEStandardDirs::findExe("kompare").isEmpty() || isUntitledDocument)
          {
            w->buttonCompare->setEnabled(false);
            w->buttonLoad->setChecked(true);
          }
          if (dlg->exec())
          {
            //backup the current version and restore it from the autosaved backup
            KURL backupURL = originalVersion;
            backupURL.setPath(backupURL.path() + "." + TQString::number(getpid(),10) + ".backup");
            QExtFileInfo::copy(originalVersion, backupURL, -1, true, false, m_quanta);
            QExtFileInfo::copy(autosavedVersion, originalVersion, -1, true, false, m_quanta);
            //we save a list of autosaved file names so "KQApplicationPrivate::init()"
            //can open them. If autosavedVersion.path().right(1) == "U" then we are recovering
            //an untitled document
            if(isUntitledDocument)
              m_quanta->slotFileOpen(autosavedVersion,
                                    m_quanta->defaultEncoding());  // load initial files
            else
              recoveredFileNameList += backedUpFileName;
          }
          delete dlg;
          TQFile::remove(autosavedPath); //we don't need the backup anymore
       }
      }
      //remove the auto-backup file from the list
      m_config->setGroup("General Options");
      TQStringList autosavedFilesEntryList = QuantaCommon::readPathListEntry(m_config, "List of autosaved files");
      TQStringList::Iterator entryIt = autosavedFilesEntryList.begin();
      while(entryIt != autosavedFilesEntryList.end())
      {
        if ((*entryIt) == KURL::fromPathOrURL(autosavedPath).url())
          entryIt = autosavedFilesEntryList.remove(entryIt);
        else
          ++entryIt;
      }
      m_config->writePathEntry("List of autosaved files", autosavedFilesEntryList);

      autosavedUrlsList = autosavedFilesEntryList;
    }

    if (notFound)
    {
      //remove processed items
      m_config->setGroup("General Options");

      TQStringList backedupFilesEntryList = QuantaCommon::readPathListEntry(m_config, "List of backedup files");
      TQStringList::Iterator entryIt = backedupFilesEntryList.begin();
      while (entryIt != backedupFilesEntryList.end())
      {
        if ((*entryIt) == (*backedUpUrlsIt))
          entryIt = backedupFilesEntryList.remove(entryIt);
        else
          ++entryIt;
      }
      m_config->writePathEntry("List of backedup files", backedupFilesEntryList);
    }
  }

  //clean up auto-backup list, just in case of an old Quanta was used before
  TQStringList::Iterator entryIt = autosavedUrlsList.begin();
  while (entryIt != autosavedUrlsList.end())
  {
    TQString quPID = retrievePID((*entryIt));

    //check if the file is opened by another running Quanta or not
    bool isOrphan = true;
    TQStringList::ConstIterator PIDEndIt = m_PIDlist.constEnd();
    for (TQStringList::ConstIterator PIDIt = m_PIDlist.constBegin(); PIDIt != PIDEndIt; ++PIDIt )
    {
      if ((*PIDIt) == quPID && qConfig.quantaPID != quPID)
      {
        isOrphan = false; //the file is opened
        break;
      }
    }
    if (isOrphan)
      entryIt = autosavedUrlsList.remove(entryIt);
    else
      ++entryIt;
  }
  m_config->writePathEntry("List of autosaved files", autosavedUrlsList);



}

 void QuantaInit::execCommandPS(const TQString& cmd)
 {

  //We create a TDEProcess that executes the "ps" *nix command to get the PIDs of the
  //other instances of quanta actually running
  TDEProcess *execCommand = new TDEProcess();
  *(execCommand) << TQStringList::split(" ",cmd);

  connect(execCommand, TQ_SIGNAL(receivedStdout(TDEProcess*,char*,int)),
          m_quanta, TQ_SLOT(slotGetScriptOutput(TDEProcess*,char*,int)));
  connect(execCommand, TQ_SIGNAL(receivedStderr(TDEProcess*,char*,int)),
          m_quanta, TQ_SLOT(slotGetScriptError(TDEProcess*,char*,int)));
  connect(execCommand, TQ_SIGNAL(processExited(TDEProcess*)),
          m_quanta, TQ_SLOT(slotProcessExited(TDEProcess*)));

  if (!execCommand->start(TDEProcess::NotifyOnExit,TDEProcess::All))
  {
    KMessageBox::error(m_quanta, i18n("Failed to query for running Quanta instances."));
  }
  else
  {
    //To avoid lock-ups, start a timer.
    TQTimer *timer = new TQTimer(m_quanta);
    connect(timer, TQ_SIGNAL(timeout()),
            m_quanta, TQ_SLOT(slotProcessTimeout()));
    timer->start(180*1000, true);
    QExtFileInfo internalFileInfo;
    m_quanta->m_loopStarted = true;
    internalFileInfo.enter_loop();
    delete timer;
  }
 }


 TQString QuantaInit::searchPathListEntry(const TQString& url, const TQStringList& autosavedUrlsList, bool &notFound)
{
  TQString backedUpUrlHashedPath = retrieveHashedPath('.' + Document::hashFilePath(url));
  notFound = true;
  TQStringList::ConstIterator autosavedUrlsEndIt = autosavedUrlsList.constEnd();
  for (TQStringList::ConstIterator autosavedUrlsIt = autosavedUrlsList.constBegin();
       autosavedUrlsIt != autosavedUrlsEndIt;
       ++autosavedUrlsIt)
  {
    TQString quPID = retrievePID((*autosavedUrlsIt));

    //check if the file is opened by another running Quanta or not
    bool isOrphan = true;
    TQStringList::ConstIterator PIDEndIt = m_PIDlist.constEnd();
    for (TQStringList::ConstIterator PIDIt = m_PIDlist.constBegin(); PIDIt != PIDEndIt; ++PIDIt )
    {
      if ((*PIDIt) == quPID && qConfig.quantaPID != quPID)
      {
        isOrphan = false; //the file is opened
        break;
      }
    }

    if (backedUpUrlHashedPath ==  retrieveHashedPath((*autosavedUrlsIt)))
    {
      notFound = false;
      if (isOrphan)
        return KURL::fromPathOrURL(*autosavedUrlsIt).path(); //the url was autosaved to this file
    }

  }
  return TQString();
}

/** Retrieves hashed path from the name of a backup file */
TQString QuantaInit::retrieveHashedPath(const TQString& filename)
{
  int lastPoint = filename.findRev(".");
  int Ppos = filename.find("P", lastPoint);
  return filename.mid(lastPoint + 1,
                      Ppos - lastPoint);
}


/** Retrieves PID from the name of a backup file */
TQString QuantaInit::retrievePID(const TQString& filename)
{
 TQString strPID = TQString();
 strPID = filename.mid(filename.findRev("P") + 1);


 if (strPID.isEmpty())
  strPID = filename.mid(filename.findRev("N") + 1);

 if (strPID.endsWith("U"))
   strPID = strPID.left(strPID.length() - 1);

 return strPID;
}


void QuantaInit::loadVPLConfig()
{
  //load the VPL options
  m_config->setGroup("Kafka Synchronization options");
  qConfig.quantaRefreshOnFocus = (m_config->readEntry("Source refresh", "delay") == "focus");
  qConfig.quantaRefreshDelay = m_config->readNumEntry("Source refresh delay", 500);
  qConfig.kafkaRefreshOnFocus = (m_config->readEntry("Kafka refresh", "focus") == "focus");
  qConfig.kafkaRefreshDelay = m_config->readNumEntry("Kafka refresh delay", 4000);
  /**reloadUpdateTimers();*/

  m_config->setGroup("Kafka Indentation options");
  qConfig.inlineNodeIndentation = m_config->readBoolEntry("Inline Node Indentation");
}

struct Dependency{
  TQString name;
  TQString execName;
  TQString url;
  TQString description;
  enum Type{
    Executable = 0,
    Plugin
  };
  Type type;
};

void QuantaInit::checkRuntimeDependencies()
{

  TQValueList<Dependency> dependencies;
  Dependency dependency;
  dependency.name = "Kommander";
  dependency.execName = "kmdr-executor";
  dependency.description = i18n("various script based dialogs including the Quick Start dialog");
  dependency.type = Dependency::Executable;
  dependencies.append(dependency);

  dependency.name = "Tidy";
  dependency.execName = "tidy";
  dependency.description = i18n("HTML syntax checking");
  dependency.type = Dependency::Executable;
  dependencies.append(dependency);

  dependency.name = "Kompare";
  dependency.execName = "kompare";
  dependency.description = i18n("comparing of files by content");
  dependency.type = Dependency::Executable;
  dependencies.append(dependency);


  dependency.name = i18n("Control Center (tdebase)");
  dependency.execName = "tdecmshell";
  dependency.description = i18n("preview browser configuration");
  dependency.type = Dependency::Executable;
  dependencies.append(dependency);

  dependency.name = "GPG (OpenPGP)";
  dependency.execName = "gpg";
  dependency.description = i18n("preview browser configuration");
  dependency.type = Dependency::Executable;
  dependencies.append(dependency);

  dependency.name = "TDEFileReplace";
  dependency.execName = "TDEFileReplace";
  dependency.description = i18n("search and replace in files");
  dependency.type = Dependency::Plugin;
  dependencies.append(dependency);

  dependency.name = "KXSLDbg";
  dependency.execName = "XSLT Debugger";
  dependency.description = i18n("XSLT debugging");
  dependency.type = Dependency::Plugin;
  dependencies.append(dependency);


  dependency.name = "KImageMapEditor";
  dependency.execName = "KImageMapEditor";
  dependency.description = i18n("editing HTML image maps");
  dependency.type = Dependency::Plugin;
  dependencies.append(dependency);


  dependency.name = "KLinkStatus";
  dependency.execName = "Link Checker";
  dependency.description = i18n("link validity checking");
  dependency.type = Dependency::Plugin;
  dependencies.append(dependency);

  dependency.name = "Cervisia";
  dependency.execName = "CVS Management (Cervisia)";
  dependency.description = i18n("CVS management plugin");
  dependency.type = Dependency::Plugin;
  dependencies.append(dependency);

  TQString errorStr;
  TQString stdErrorMsg = i18n("<br><b>-    %1</b> [<i>%2</i>] will not be available;");
  for (TQValueList<Dependency>::ConstIterator it = dependencies.constBegin(); it != dependencies.constEnd(); ++it)
  {
    dependency = *it;
    if (dependency.type == Dependency::Executable)
    {
      if (TDEStandardDirs::findExe(dependency.execName).isNull())
        errorStr += TQString(stdErrorMsg).arg(dependency.name).arg(dependency.description);

    } else
    if (dependency.type == Dependency::Plugin)
    {
      if (!QuantaPlugin::validatePlugin(m_quanta->m_pluginInterface->plugin(dependency.execName)))
        errorStr += TQString(stdErrorMsg).arg(dependency.name).arg(dependency.description);
    }
  }

#ifdef ENABLE_CVSSERVICE
  TQString error;
  TQCString appId;

  TDEApplication::startServiceByDesktopName("cvsservice", TQStringList(), &error,
                                            &appId);
  if (appId.isEmpty())
  {
     errorStr += TQString(stdErrorMsg).arg("Cervisia (cvsservice)").arg("http://www.kde.org/apps/cervisia").arg(i18n("integrated CVS management"));
  } else
  {
     CVSService::ref(m_quanta->actionCollection())->setAppId(appId);
     connect(CVSService::ref(), TQ_SIGNAL(clearMessages()), m_quanta->m_messageOutput, TQ_SLOT(clear()));
     connect(CVSService::ref(), TQ_SIGNAL(showMessage(const TQString&, bool)), m_quanta->m_messageOutput, TQ_SLOT(showMessage(const TQString&, bool)));
     connect(CVSService::ref(), TQ_SIGNAL(commandExecuted(const TQString&, const TQStringList&)), m_quanta, TQ_SLOT(slotCVSCommandExecuted(const TQString&, const TQStringList&)));
     //connect(CVSService::ref(), TQ_SIGNAL(statusMsg(const TQString &)),  m_quanta, TQ_SLOT(slotStatusMsg(const TQString & )));
     m_quanta->fTab->plugCVSMenu();
     pTab->plugCVSMenu();
  }
#endif

  if (!errorStr.isEmpty())
  {
      m_quanta->slotHideSplash();
      errorStr[errorStr.length() - 1] = '.';
      KMessageBox::information(m_quanta, "<qt>" + i18n("Some applications required for full functionality are missing or installed incorrectly:<br>") + errorStr + i18n("<br><br>Please verify the package contents.</qt>"), i18n("Missing Applications"), "RuntimeDependencyCheck");
  }
}

void QuantaInit::readAbbreviations()
{
  TQDomDocument doc;
  TQString groupName;
  bool mainAbbrevFileFound = false;
  TQStringList mainFileList;
  mainFileList << qConfig.globalDataDir + resourceDir + "abbreviations.xml";
  mainFileList << TDEGlobal::dirs()->saveLocation("data") + resourceDir + "abbreviations.xml";
  for (uint i = 0; i < mainFileList.count(); i++)
  {
     if (!TQFile::exists(mainFileList[i]))
       continue;
     TQFile file(mainFileList[i]);
     if (file.open(IO_ReadOnly))
     {
        if (doc.setContent(&file))
        {
          TQDomNodeList groupList = doc.elementsByTagName("Group");
          for (uint groupIdx = 0; groupIdx < groupList.count(); groupIdx++)
          {
             Abbreviation abbrev;
             TQDomElement el = groupList.item(groupIdx).toElement();
             groupName = el.attribute("name");
             TQDomNodeList dtepList = el.elementsByTagName("DTEP");
             for (uint dtepListIdx = 0; dtepListIdx < dtepList.count(); dtepListIdx++)
             {
               abbrev.dteps.append(dtepList.item(dtepListIdx).toElement().attribute("name"));
             }
             TQDomNodeList nodeList = el.elementsByTagName("Template");
             for (uint nodeIdx = 0; nodeIdx < nodeList.count(); nodeIdx++)
             {
               TQDomElement e = nodeList.item(nodeIdx).toElement();
               abbrev.abbreviations.insert(e.attribute("name")+" "+e.attribute("description"), e.attribute("code"));
             }
             qConfig.abbreviations.insert(groupName, abbrev);
          }
        }
        mainAbbrevFileFound = true;
        file.close();
     }
  }
  if (mainAbbrevFileFound) return;
//Compatibility code: read the abbreviations files from the DTEP directories
//TODO: Remove when upgrade from 3.2 is not supported.
 TQStringList filenameList = DTDs::ref()->fileNameList(false);
 TQStringList::Iterator it;
 for (it = filenameList.begin(); it != filenameList.end(); ++it)
 {
    int pos =(*it).find('|');
    TQString dirName = (*it).mid(pos + 1);
    TQString dtepName = (*it).left(pos);
    KURL dirURL(dirName);
    dirURL.setFileName("");
    dirName = dirURL.path(1);
    TQString abbrevFile = dirName;
    TQString tmpStr = dirName;
    TQStringList resourceDirs = TDEGlobal::dirs()->resourceDirs("data");
    bool dirFound = false;
    for (uint i = 0; i < resourceDirs.count(); i++)
    {
      if (tmpStr.startsWith(resourceDirs[i]))
      {
        dirFound = true;
        tmpStr = tmpStr.right(tmpStr.length() - resourceDirs[i].length());
        break;
      }
    }
    if (dirFound)
    {
      abbrevFile = TDEGlobal::dirs()->saveLocation("data", tmpStr) +"/";
    }
    abbrevFile.append("abbreviations");
    if (!TQFile::exists(abbrevFile))
        abbrevFile = dirName + "abbreviations";
    TQFile f(abbrevFile);
    if (f.open(IO_ReadOnly))
    {
      if (doc.setContent(&f))
      {
        Abbreviation abbrev;
        TQDomNodeList nodeList = doc.elementsByTagName("Template");
        for (uint i = 0; i < nodeList.count(); i++)
        {
          TQDomElement e = nodeList.item(i).toElement();
          abbrev.abbreviations.insert(e.attribute("name")+" "+e.attribute("description"), e.attribute("code"));
        }
        abbrev.dteps.append(dtepName);
        qConfig.abbreviations.insert(DTDs::ref()->getDTDNickNameFromName(dtepName), abbrev);
      }
      f.close();
    }
 }
}


int QuantaInit::runningQuantas()
{
  QCStringList list = tdeApp->dcopClient()->registeredApplications();
  int i = 0;
  for (QCStringList::iterator it = list.begin(); it != list.end(); ++it)
  {
    if (TQString(*it).startsWith("quanta", false))
      ++i;
  }
  return i;
}

#include "quanta_init.moc"
