/***************************************************************************
*   Copyright (C) 2006 - 2008 Robert Hogan                                *
*   robert@roberthogan.net                                                *
begin                : 2004/02/07
copyright            : (C) Mark Kretschmann
email                : markey@web.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TORKCONFIGDIALOG_H
#define TORKCONFIGDIALOG_H

#include <tqmap.h>
#include <tqvaluelist.h>

#include <tdeconfigdialog.h>

class TQComboBox;
class TQGroupBox;
class TQVBox;

class TorkConfigDialog : public TDEConfigDialog
{
    TQ_OBJECT

    public:
        TorkConfigDialog( TQWidget *parent, const char* name, TDEConfigSkeleton *config );
        ~TorkConfigDialog();

        void addPage( TQWidget *page, const TQString &itemName, const TQString &pixmapName,
                      const TQString &header=TQString::null, bool manage=true);

        void showPage( const TQCString& page );
        class QuickConfig     *m_quickconfig;
    public slots:
        void showServerOpts(bool state);
    signals:
        void updateServerButton( );
    private slots:
        void updateCustomSettings();
        void enableApply();
        void showHidePages( const int &);
    private:
        class FirewallsProxies  *m_firewallsproxies;
        class FilterTable  *m_filtertable;
        class MaxMin  *m_maxmin;
        class Usability     *m_usability;
        class TorServers     *m_torservers;
        class Running     *m_running;
        class MyServer     *m_myserver;
        class MyHidden     *m_myhidden;
        class Konq     *m_konq;

        TQValueList<TQWidget*> m_pageList;
        TQMap<TQString, TQString> m_pluginName;
        TQMap<TQString, TQString> m_pluginTorkName;
        
        TQWidget* m_parent;
};


#endif // TORKCONFIGDIALOG_H
