/*
 * // Copyright (c) Radzivon Bartoshyk 8/2025. All rights reserved.
 * //
 * // Redistribution and use in source and binary forms, with or without modification,
 * // are permitted provided that the following conditions are met:
 * //
 * // 1.  Redistributions of source code must retain the above copyright notice, this
 * // list of conditions and the following disclaimer.
 * //
 * // 2.  Redistributions in binary form must reproduce the above copyright notice,
 * // this list of conditions and the following disclaimer in the documentation
 * // and/or other materials provided with the distribution.
 * //
 * // 3.  Neither the name of the copyright holder nor the names of its
 * // contributors may be used to endorse or promote products derived from
 * // this software without specific prior written permission.
 * //
 * // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * // AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * // DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * // FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * // DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * // SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * // CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * // OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
Generated by SageMath:
```python
values = POW_INV

R = RealField(150)

def hex_to_float(h):
    return struct.unpack('>d', struct.pack('>Q', h))[0]

real_array = [R(hex_to_float(h)) for h in values]

for r in real_array:
    print_triple_double("", -RealField(180)(r).log2())
```
**/
pub(crate) static LOG2_NEG_TD: [(u64, u64, u64); 182] = [
    (0x390941b6615224a5, 0xbc61d46ccc53c278, 0xbfdfbc16b902680a),
    (0x38f07da8aa70916c, 0x3c6780e41697a095, 0xbfdf38c567bcc541),
    (0x391d3c8f5fd3dc67, 0xbc74f9727980f5ed, 0xbfdeb4b847d15bce),
    (0xb8e739d205efb04e, 0xbc4be44aae7442ab, 0xbfde2fed3d097298),
    (0x3898c9127b6c16fb, 0xbc1274a5715611b7, 0xbfddaa6222064fb9),
    (0xb9196a462f40def6, 0xbc74856fb52a53d2, 0xbfdd2414c80bf27d),
    (0x390bea8fdeb55632, 0x3c6b517ae88c2fd3, 0xbfdce0a4923a587d),
    (0xb908a7815661988f, 0xbc7f9fb952bbbccc, 0xbfdc592fad295b56),
    (0xb8e453488bf5b6cc, 0x3c752ef4c737fba5, 0xbfdbd0f2e9e79031),
    (0x38fc548eb57fa11c, 0x3c76fae441c09d76, 0xbfdb47ebf73882a1),
    (0xb8fc786e3d2aafcf, 0x3c5e5b8daaa73a43, 0xbfdabe18797f1f49),
    (0xb91b1fdcc00753ce, 0x3c78a0efca1a184f, 0xbfda33760a7f6051),
    (0x38fa1959f815466e, 0x3c7dc938c18e544d, 0xbfd9edd6759b25e0),
    (0xb9153e596854d8d8, 0x3c7cc298a148e6ca, 0xbfd961f90527409c),
    (0xb8ebb343d8cce6ac, 0x3c7530bdb6949302, 0xbfd8d54673b5c372),
    (0x38f53bc13892380d, 0x3c76d266d6cdc959, 0xbfd88e9c72e0b226),
    (0xb90911b0bd8dfc92, 0xbc69575b04fa6fbd, 0xbfd800a563161c54),
    (0x38ac786dcf6b587c, 0x3c5b90132aeddb58, 0xbfd771d2ba7efb3c),
    (0x38edde6c0edf5f9b, 0xbc75e35482d13dc1, 0xbfd6e221cd9d0cde),
    (0x390079b0d8796cf7, 0xbc7a3152150d2dbf, 0xbfd699f5248cd4b8),
    (0xb9015c2742b99e22, 0x3c7a43fc62b7e690, 0xbfd608f1b42948ae),
    (0x38f48bb6c3065717, 0x3c7817fd3b7d7e5d, 0xbfd5c01a39fbd688),
    (0xb912cbbddfbc3c96, 0xbc7f73d83987f26d, 0xbfd52dbdfc4c96b3),
    (0x38b2cc9a4ea80721, 0x3c1b6d40900b2502, 0xbfd49a784bcd1b8b),
    (0x390e110ddda53ed5, 0x3c7aca97d800ce47, 0xbfd4507cfedd4fc4),
    (0xb91d40a85c203c0a, 0x3c7a9f3c8bc9672e, 0xbfd3bbd3a0a1dcfb),
    (0xb8f186e41376f461, 0x3c63376649b4fc09, 0xbfd37124cea4cded),
    (0xb90b8ee38b380b8c, 0xbc7bc4de8f631bcf, 0xbfd2db10fc4d9aaf),
    (0x391f0463d2dc68ee, 0xbc78c0e85a908be6, 0xbfd28fab35b32683),
    (0x390dfcf160587090, 0xbc65f43469fbe6ea, 0xbfd1f825f6d88e13),
    (0xb91a061db1cd272d, 0xbc74a31ce1b7e328, 0xbfd1ac05b291f070),
    (0xb903f833b9cd87fa, 0x3c6a7b47d2c352d9, 0xbfd11307dad30b76),
    (0xb90ea304fc9566d2, 0x3c76c13816f9f480, 0xbfd0c62975542a8f),
    (0x38f4999ebc7b5be1, 0xbc7bc0c69a675517, 0xbfd0790adbb03009),
    (0x38f941b6615224a5, 0xbc51d46ccc53c278, 0xbfcfbc16b902680a),
    (0x390b074c63fc2e10, 0xbc61dd4a99cc633b, 0xbfcf205339208f27),
    (0x38bd01b29154c9bc, 0x3c4e41bd8c32e1be, 0xbfcde73fe3b1480f),
    (0x38f77c80fa9696aa, 0x3c5b85a54d7ee2fd, 0xbfcd49ee4c325970),
    (0xb902de32e0e76d80, 0x3c6a4ecd69d3b872, 0xbfccac163c770dc9),
    (0x38bfcd52b1405dd8, 0xbc6afb63338bed1f, 0xbfcb6ecf175f95e9),
    (0xb8da5a90415f750a, 0x3c401ee1343fe7ca, 0xbfcacf5e2db4ec94),
    (0xb8edc57adc0d07e5, 0x3c5ae3bd6c6d42f0, 0xbfca2f632320b86b),
    (0xb8fbd5bde9064fc5, 0x3c628caf799ad993, 0xbfc8edcae8352b6c),
    (0x38b1e10526896a05, 0x3c116edb88c4e2b5, 0xbfc84c2bd02f03b3),
    (0x38d23d3d07963ee8, 0x3c3d0364be23e873, 0xbfc7a9fec7d05ddf),
    (0x38f4a786b5f060aa, 0xbc6f3314e0985116, 0xbfc663f6fac91316),
    (0x38e48bb6c3065717, 0x3c6817fd3b7d7e5d, 0xbfc5c01a39fbd688),
    (0x390a35613d82ada7, 0xbc622c022616fdff, 0xbfc51bab907a5c8a),
    (0xb8c3eeadb3c7c4e9, 0xbc589c74a0b21fb6, 0xbfc476a9f983f74d),
    (0x38e66c9ab03b4ece, 0xbc4f51f2c075a74c, 0xbfc32ae9e278ae1a),
    (0xb8d9632ea3495efa, 0x3c6ca25d54d6f775, 0xbfc284294b07a640),
    (0xb90575a87dd48ab4, 0xbc67a9150c1e0e58, 0xbfc1dcd197552b7b),
    (0x38536121d3d82a7d, 0x3bf94b7dfe0d99a5, 0xbfc134e1b489062e),
    (0x38f9009af5640e65, 0x3c5becb2e71abdc8, 0xbfbfc66a0f0b00a5),
    (0xb893a950ee2d9c26, 0xbc3cbdb5d9dc29f2, 0xbfbe72ec117fa5b2),
    (0xb8f8af0cb05a0a5c, 0xbc5342ce3cc8f2f9, 0xbfbd1e34e35b82da),
    (0x38f47869be3af7ef, 0xbc58ecb169b9465f, 0xbfbbc84240adabba),
    (0x38d3b67d8a9115c0, 0x3c34bba7e1c43d2c, 0xbfba7111df348494),
    (0x38d737dca6ec6478, 0x3c5463736dac9317, 0xbfb918a16e46335b),
    (0x38e4a786b5f060aa, 0xbc5f3314e0985116, 0xbfb663f6fac91316),
    (0xb8d0a7b1e526a7c3, 0x3c458696424b2e96, 0xbfb507b836033bb7),
    (0xb8dda9b52342f8f1, 0x3c43fd9776f25acf, 0xbfb3aa2fdd27f1c3),
    (0x38ff4924636e235a, 0x3c5d974c32ba8269, 0xbfb24b5b7e135a3d),
    (0xb8f7066b9150f3c8, 0x3c530c22d15199b8, 0xbfb0eb389fa29f9b),
    (0xb8decbebcad152bd, 0x3c478cbe51121a94, 0xbfaf1389833253a0),
    (0xb8b42bd2b182fdab, 0x3c160e0f2c3388f0, 0xbfac4dfab90aab5f),
    (0xb8d5c7c92fd4f7f3, 0xbc482838ed43de84, 0xbfa985bfc3495194),
    (0x38dedbe726436947, 0xbc389b03784b5be1, 0xbfa6bad3758efd87),
    (0xb8dea50c8ba63a79, 0xbc3013a5b81fc494, 0xbfa3ed3094685a26),
    (0xb8c4bcdabff7514c, 0x3c227ebafb056cb9, 0xbfa11cd1d5133413),
    (0x38ce9f581ff32546, 0xbc399ba03dc5d34f, 0xbf9c9363ba850f86),
    (0x38d06b9f56890d24, 0x3c3d6476077b9fbd, 0xbf96e79685c2d22a),
    (0xb8b1b179cc231c2a, 0xbc32ed069b244452, 0xbf91363117a97b0c),
    (0x38b777c664136e1b, 0xbc2fe38dec005e54, 0xbf86fe50b6ef0851),
    (0x0000000000000000, 0x0000000000000000, 0x8000000000000000),
    (0x0000000000000000, 0x0000000000000000, 0x8000000000000000),
    (0xb8a7dbe5813706e0, 0x3c0456006875bd76, 0x3f815cfe8eaec830),
    (0x38c7f9509188db9f, 0x3c2ae48169cf4cdb, 0x3f8cfee70c5ce5dc),
    (0xb8d79e2d0f7ae4d0, 0x3c37910667a9b5f8, 0x3f94564a62192834),
    (0xb8d813d8377012b5, 0xbc361176ce5d0a51, 0x3f9a330fd028f75f),
    (0xb8d685445ab0c8b5, 0xbc493cced296b87d, 0x3fa00ae7f502c1c4),
    (0xb8ebcdc68a46e891, 0xbc4c3f1d5c0cfec8, 0x3fa2ff4b77413dcb),
    (0x38a63b39766a5ce1, 0x3c2c62a2f6e13b06, 0x3fa5f6b8a11c3c61),
    (0x38ed757f27c1c5b2, 0x3c477970e03f821c, 0x3fa77394c9d958d5),
    (0x38d0bf5248279df2, 0xbc486446a6eb19b1, 0x3faa6f9c377dd31b),
    (0x387223b831459354, 0x3c0155660710eb2a, 0x3fad6ebd1f1febfe),
    (0x38f423e28c15d772, 0xbc57de9078d157a3, 0x3fb0387efbca869e),
    (0xb8c9cfd3de88693e, 0x3c298c5452bbce74, 0x3fb1bb32a600549d),
    (0xb8d9456e30e04c8b, 0xbc3e20375a3220ba, 0x3fb33f7cde14cf5a),
    (0xb8dd9b5327c61668, 0xbc4e40a005e7a3e0, 0x3fb4023b7b26ac9e),
    (0xb8d8302738bd7244, 0x3c5a489c555db4a8, 0x3fb588edd4d1ceaa),
    (0x38d15de8817f9652, 0xbc524e45ed01d67c, 0x3fb7113f3259e07a),
    (0xb8c297cc436527f1, 0x3c34ea44821c1dc2, 0x3fb89b33091d6fe8),
    (0xb8d163823d724b8c, 0xbc5d9af608a7a4d8, 0x3fba26ccd9981853),
    (0xb8f030b03172242b, 0x3c540238de7ea9f1, 0x3fbaed391ab6674e),
    (0xb898fd98ad57a6d5, 0xbc17936311889913, 0x3fbc7b528b70f1c5),
    (0xb8f80f8712f10464, 0x3c592ce9636c90a0, 0x3fbe0b1ae8f2fd56),
    (0x38ec0a4d34a2fd5c, 0xbc56fb7d020ef0e0, 0x3fbed3a1d4cdbebb),
    (0xb8b8adf1dbb4847f, 0x3c3905c241a252f9, 0x3fc032fbbaee6d65),
    (0xb903fe7b94dd3deb, 0xbc61d536b72e64f7, 0x3fc0fd02a03727ea),
    (0xb8f06547268dda91, 0xbc5df0fdbc295d19, 0x3fc162593186da70),
    (0x38e31c1f44f6723a, 0xbc5696e2866c718e, 0x3fc22dadc2ab3497),
    (0x38fd32863d2685d2, 0xbc6978b98f7dedf9, 0x3fc2f9e32d5bfdd1),
    (0x38ec6ccb73071d8f, 0xbc4b5ac8d9739e01, 0x3fc36052d01c3dd7),
    (0xb90321b9c961872d, 0x3c648a7168f01501, 0x3fc42ddd2ba1b4a9),
    (0x390f41f9b48ee641, 0x3c67c2c3172b86af, 0x3fc4fc4d4d9bb313),
    (0xb8b9b5bedec4594c, 0x3c390e41bca6ef96, 0x3fc563dc29ffacb2),
    (0x38dd601656701a20, 0x3c354fae008fbb59, 0x3fc633a8bf437ce1),
    (0xb905adb0d2530905, 0x3c6a1981a877433e, 0x3fc69be6fbb3aa6f),
    (0xb90f3e5eefe085d3, 0x3c6519f7ed9559d4, 0x3fc76d14a4601225),
    (0x38fc9f6eab582c70, 0x3c69ced1447e30ad, 0x3fc7d60496cfbb4c),
    (0x3902bdc639cad5c0, 0x3c699aa6df8b7d83, 0x3fc8a8980abfbd32),
    (0xb8ca47539e091f76, 0xbc40b273219ed335, 0x3fc9123c1528c6ce),
    (0xb8cd48f7f45b5018, 0xbc45359413e77d86, 0x3fc9e63a24971f46),
    (0xb8b73b65f96477cb, 0x3c6013b6eaceb921, 0x3fca5094b54d2828),
    (0xb9055f0f3a28066a, 0xbc6cc865b3dd0dbb, 0x3fcb2602497d5346),
    (0x38f53cf448ae828c, 0x3c569a95f528f2c7, 0x3fcb9115db83a3dd),
    (0xb8e2102812a3d1b1, 0xbc4fab00c0500189, 0x3fcc67f7f770a67e),
    (0x38fa40fe032a2c66, 0x3c592eeaf409cc88, 0x3fccd3c712d31109),
    (0xb887c5ffe75deb96, 0xbc0ba8b1f646ab12, 0x3fcdac22d3e441d3),
    (0xb8811c83ec58557f, 0x3c29bf75f08df8fb, 0x3fce18b00e13123d),
    (0x38ea7fea131ac432, 0x3c506313e79cf1dc, 0x3fcef28aacd72231),
    (0xb9084b9b76dd9f57, 0xbc6bdc0426c3c274, 0x3fcf5fd8a9063e35),
    (0x3902c0ac2d3510c7, 0x3c7768994400ca0a, 0x3fd01d9bbcfa61d4),
    (0xb90ead7402dbb16c, 0x3c7fdee226b2d7aa, 0x3fd054a474bf0eb7),
    (0x38f7ea4900b7ca9f, 0xbc53d56efe4338fe, 0x3fd08bce0d95fa38),
    (0xb8ef4d89ee4185a6, 0x3c40de07b685556f, 0x3fd0fa848044b351),
    (0xb918d4aa56ccb3b2, 0x3c790ea4cc5a44e3, 0x3fd13211a9b38424),
    (0x38fa379cb518805e, 0x3c7a3174c8d0586b, 0x3fd1a190a5d674a0),
    (0xb90af38b63e590a5, 0x3c6ae9804237ec8e, 0x3fd1d982c9d52708),
    (0x3907a7fd81201c43, 0xbc7343f87991ca1f, 0x3fd21196e87473d1),
    (0x38fc178bd3a1edca, 0xbc57154f4085d044, 0x3fd28225bb5e64a4),
    (0x38e7ab84f442d263, 0xbc50132ae5e417cd, 0x3fd2baa0c34be1ec),
    (0x39026a2436846fab, 0xbc7bc5dc0ebe6308, 0x3fd2f33e6d2120f2),
    (0xb9047b4beb18bc59, 0xbc687bf1007a1695, 0x3fd364e2511cc821),
    (0xb919992a2440dc93, 0x3c7fcad2f4710e00, 0x3fd39de8e1559f6f),
    (0x38ead80ac1494e37, 0xbc69cee46ebe3a2d, 0x3fd3d712bf9c9def),
    (0xb9134ed7c8d82134, 0xbc7c658d602e66b0, 0x3fd4106017c3eca3),
    (0x38f81bffac5a3040, 0xbc75759f8091112d, 0x3fd48365e695d797),
    (0x390122141b6e6cce, 0xbc75e341793e8e12, 0x3fd4bd1eb680e548),
    (0xb90844a77a231cf3, 0x3c7e393a16b94b52, 0x3fd4f6fbb2cec598),
    (0x390784ce0b08724e, 0xbc78d86531d55da2, 0x3fd56b22e6b578e5),
    (0x38fdb88067f0d789, 0x3c7885b23dbdaaf1, 0x3fd5a56d7a370ded),
    (0x391c3aeac5cdb196, 0x3c710b5b643a6ecb, 0x3fd5dfdcf1eeae0e),
    (0x38f9a8ddc498a5b0, 0x3c515f01e8fdf6ad, 0x3fd61a717cac1983),
    (0x38d9002dddd7f2ce, 0x3c3d3cd794eee08b, 0x3fd6900a8836d0d5),
    (0x38c2cc9a4ea80721, 0x3c2b6d40900b2502, 0x3fd6cb0f6865c8ea),
    (0x38cf01842d4b2f59, 0x3c6cbc6f17205b76, 0x3fd7063a1a5fb4f2),
    (0xb915071dd6fa27c2, 0xbc726bfff0133975, 0x3fd7418acebbf18f),
    (0xb914f2a5689dd709, 0xbc76d8d6e54d428b, 0x3fd77d01b66fbd37),
    (0xb8e0b434dd18e7de, 0x3c6412d04e355531, 0x3fd7f462e58e1688),
    (0x38f6527e7e840122, 0x3c651d58525aad39, 0x3fd8304d90c11fd3),
    (0x38e516a4b1855739, 0xbc71660ad9487503, 0x3fd86c5f36dea3dc),
    (0x3912bdc639cad5c0, 0x3c799aa6df8b7d83, 0x3fd8a8980abfbd32),
    (0xb91995b025e39b60, 0xbc740df0e173c574, 0x3fd8e4f83fa145ee),
    (0x38f93dd58663d90f, 0x3c7fdc46af571993, 0x3fd921800924dd3b),
    (0xb8f0939e6edc060c, 0x3c7bca36fd02def0, 0x3fd99b072a96c6b2),
    (0xb91659657a3f4cd6, 0xbc7cf91d2080a35b, 0x3fd9d806ebc9921c),
    (0x390d166fe5d876b2, 0xbc64278cd1699312, 0x3fda152f142981b4),
    (0xb8fec39dceb08f82, 0x3c6b56b1d743ac01, 0x3fda527fd95fd8ff),
    (0x38d48bb6c3065717, 0x3c5817fd3b7d7e5d, 0x3fda8ff971810a5e),
    (0xb8e711410d392f17, 0x3c77061311743a68, 0x3fdacd9c130dd53f),
    (0x38c45703d2c5dcbe, 0xbc45e13b838eba7d, 0x3fdb0b67f4f46810),
    (0xb8fd917ff9c35ae9, 0xbc501d98c3531027, 0x3fdb877c57b1b070),
    (0x3907193712b6e51c, 0xbc78a87a168550fe, 0x3fdbc5c5489254cc),
    (0x391d391561769b34, 0x3c7edf515c63dd87, 0x3fdc043859e2fdb3),
    (0xb905c1e916668206, 0xbc687a4c86c71df7, 0x3fdc42d5c4c688b4),
    (0x38efe382a72aa9a4, 0x3c6c4aec56233279, 0x3fdc819dc2d45fe4),
    (0xb8ff56b5607ee8e4, 0x3c5d3c79567f954e, 0x3fdcc0908e19b7bd),
    (0x390e73e7b9e3ba70, 0x3c78a38b4175d665, 0x3fdcffae611ad12b),
    (0x38ef3d2624494be1, 0xbc4e2b378ff59cbb, 0x3fdd3ef776d43ff4),
    (0xb90611295daec3b0, 0xbc6e15a52a31604a, 0x3fdd7e6c0abc3579),
    (0x38f6dcd082b5ed11, 0xbc76a568b022e9a3, 0x3fddbe0c58c3cff2),
    (0x38c4b12ca495197c, 0x3c438c8946414c6a, 0x3fddfdd89d586e2b),
    (0x38f9351168f2db59, 0xbc63aeabca24fd25, 0x3fde3dd1156507de),
    (0x38eeaaf81af2c453, 0x3c73bed456b24ed1, 0x3fde7df5fe538ab3),
    (0x391a697a348a408c, 0x3c7ff93949a1897d, 0x3fdebe47960e3c08),
    (0xb8fe170ccb0f7762, 0x3c76d261f1753e0b, 0x3fdefec61b011f85),
    (0xb900da9304567477, 0xbc7f4c8f8f9cbfe1, 0x3fdf3f71cc1b629c),
    (0x391c1a6aa9135b96, 0xbc79ca1a3202b3d7, 0x3fdf804ae8d0cd02),
    (0xb8f5b4fa1d9fe122, 0x3c5b9a81085cd3b3, 0x3fdfc151b11b3640),
    (0x391dd3a12d527b9c, 0xbc87398fe685f171, 0x3fe0014332be0033),
];
