// RUN: %clang_cc1 -std=c++23 -triple x86_64-linux-gnu -fsyntax-only -ast-dump=json %s | FileCheck %s

struct S {
  int arr[1];
  const int *begin() const { return arr; }
  const int *end() const { return &arr[1]; }
  S() {}
  ~S() {}
};

S func(const int &, const S &s = S());

void test() {
  for (auto v : func(1)) {}
}

// NOTE: CHECK lines have been autogenerated by gen_ast_dump_json_test.py


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "TranslationUnitDecl",
// CHECK-NEXT:  "loc": {},
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {},
// CHECK-NEXT:   "end": {}
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__int128_t",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "__int128"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "BuiltinType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "__int128"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__uint128_t",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "unsigned __int128"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "BuiltinType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "unsigned __int128"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__NSConstantString",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "__NSConstantString_tag"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "RecordType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "__NSConstantString_tag"
// CHECK-NEXT:      },
// CHECK-NEXT:      "decl": {
// CHECK-NEXT:       "id": "0x{{.*}}",
// CHECK-NEXT:       "kind": "CXXRecordDecl",
// CHECK-NEXT:       "name": "__NSConstantString_tag"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__builtin_ms_va_list",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "char *"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "PointerType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "char *"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "BuiltinType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "char"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TypedefDecl",
// CHECK-NEXT:    "loc": {},
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__builtin_va_list",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "__va_list_tag[1]"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ConstantArrayType",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "__va_list_tag[1]"
// CHECK-NEXT:      },
// CHECK-NEXT:      "size": 1,
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "RecordType",
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "__va_list_tag"
// CHECK-NEXT:        },
// CHECK-NEXT:        "decl": {
// CHECK-NEXT:         "id": "0x{{.*}}",
// CHECK-NEXT:         "kind": "CXXRecordDecl",
// CHECK-NEXT:         "name": "__va_list_tag"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 110,
// CHECK-NEXT:     "file": "{{.*}}",
// CHECK-NEXT:     "line": 3,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 103,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 235,
// CHECK-NEXT:      "line": 9,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "S",
// CHECK-NEXT:    "tagUsed": "struct",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canConstDefaultInit": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "defaultedIsConstexpr": true,
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "nonTrivial": true,
// CHECK-NEXT:      "userProvided": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "nonTrivial": true,
// CHECK-NEXT:      "userDeclared": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "hasUserDeclaredConstructor": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "moveAssign": {},
// CHECK-NEXT:     "moveCtor": {}
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXRecordDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 110,
// CHECK-NEXT:       "line": 3,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 103,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 6
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 110,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "S",
// CHECK-NEXT:      "tagUsed": "struct"
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 120,
// CHECK-NEXT:       "line": 4,
// CHECK-NEXT:       "col": 7,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 116,
// CHECK-NEXT:        "col": 3,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 125,
// CHECK-NEXT:        "col": 12,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isReferenced": true,
// CHECK-NEXT:      "name": "arr",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int[1]"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXMethodDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 141,
// CHECK-NEXT:       "line": 5,
// CHECK-NEXT:       "col": 14,
// CHECK-NEXT:       "tokLen": 5
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 130,
// CHECK-NEXT:        "col": 3,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 169,
// CHECK-NEXT:        "col": 42,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isUsed": true,
// CHECK-NEXT:      "name": "begin",
// CHECK-NEXT:      "mangledName": "_ZNK1S5beginEv",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const int *() const"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CompoundStmt",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 155,
// CHECK-NEXT:          "col": 28,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 169,
// CHECK-NEXT:          "col": 42,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "ReturnStmt",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 157,
// CHECK-NEXT:            "col": 30,
// CHECK-NEXT:            "tokLen": 6
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 164,
// CHECK-NEXT:            "col": 37,
// CHECK-NEXT:            "tokLen": 3
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "ImplicitCastExpr",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 164,
// CHECK-NEXT:              "col": 37,
// CHECK-NEXT:              "tokLen": 3
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 164,
// CHECK-NEXT:              "col": 37,
// CHECK-NEXT:              "tokLen": 3
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "const int *"
// CHECK-NEXT:            },
// CHECK-NEXT:            "valueCategory": "prvalue",
// CHECK-NEXT:            "castKind": "ArrayToPointerDecay",
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "MemberExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 164,
// CHECK-NEXT:                "col": 37,
// CHECK-NEXT:                "tokLen": 3
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 164,
// CHECK-NEXT:                "col": 37,
// CHECK-NEXT:                "tokLen": 3
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "const int[1]"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "lvalue",
// CHECK-NEXT:              "name": "arr",
// CHECK-NEXT:              "isArrow": true,
// CHECK-NEXT:              "referencedMemberDecl": "0x{{.*}}",
// CHECK-NEXT:              "inner": [
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "CXXThisExpr",
// CHECK-NEXT:                "range": {
// CHECK-NEXT:                 "begin": {
// CHECK-NEXT:                  "offset": 164,
// CHECK-NEXT:                  "col": 37,
// CHECK-NEXT:                  "tokLen": 3
// CHECK-NEXT:                 },
// CHECK-NEXT:                 "end": {
// CHECK-NEXT:                  "offset": 164,
// CHECK-NEXT:                  "col": 37,
// CHECK-NEXT:                  "tokLen": 3
// CHECK-NEXT:                 }
// CHECK-NEXT:                },
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "const S *"
// CHECK-NEXT:                },
// CHECK-NEXT:                "valueCategory": "prvalue",
// CHECK-NEXT:                "implicit": true
// CHECK-NEXT:               }
// CHECK-NEXT:              ]
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXMethodDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 184,
// CHECK-NEXT:       "line": 6,
// CHECK-NEXT:       "col": 14,
// CHECK-NEXT:       "tokLen": 3
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 173,
// CHECK-NEXT:        "col": 3,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 214,
// CHECK-NEXT:        "col": 44,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isUsed": true,
// CHECK-NEXT:      "name": "end",
// CHECK-NEXT:      "mangledName": "_ZNK1S3endEv",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const int *() const"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CompoundStmt",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 196,
// CHECK-NEXT:          "col": 26,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 214,
// CHECK-NEXT:          "col": 44,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "ReturnStmt",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 198,
// CHECK-NEXT:            "col": 28,
// CHECK-NEXT:            "tokLen": 6
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 211,
// CHECK-NEXT:            "col": 41,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "UnaryOperator",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 205,
// CHECK-NEXT:              "col": 35,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 211,
// CHECK-NEXT:              "col": 41,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "const int *"
// CHECK-NEXT:            },
// CHECK-NEXT:            "valueCategory": "prvalue",
// CHECK-NEXT:            "isPostfix": false,
// CHECK-NEXT:            "opcode": "&",
// CHECK-NEXT:            "canOverflow": false,
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "ArraySubscriptExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 206,
// CHECK-NEXT:                "col": 36,
// CHECK-NEXT:                "tokLen": 3
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 211,
// CHECK-NEXT:                "col": 41,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "const int"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "lvalue",
// CHECK-NEXT:              "inner": [
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "ImplicitCastExpr",
// CHECK-NEXT:                "range": {
// CHECK-NEXT:                 "begin": {
// CHECK-NEXT:                  "offset": 206,
// CHECK-NEXT:                  "col": 36,
// CHECK-NEXT:                  "tokLen": 3
// CHECK-NEXT:                 },
// CHECK-NEXT:                 "end": {
// CHECK-NEXT:                  "offset": 206,
// CHECK-NEXT:                  "col": 36,
// CHECK-NEXT:                  "tokLen": 3
// CHECK-NEXT:                 }
// CHECK-NEXT:                },
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "const int *"
// CHECK-NEXT:                },
// CHECK-NEXT:                "valueCategory": "prvalue",
// CHECK-NEXT:                "castKind": "ArrayToPointerDecay",
// CHECK-NEXT:                "inner": [
// CHECK-NEXT:                 {
// CHECK-NEXT:                  "id": "0x{{.*}}",
// CHECK-NEXT:                  "kind": "MemberExpr",
// CHECK-NEXT:                  "range": {
// CHECK-NEXT:                   "begin": {
// CHECK-NEXT:                    "offset": 206,
// CHECK-NEXT:                    "col": 36,
// CHECK-NEXT:                    "tokLen": 3
// CHECK-NEXT:                   },
// CHECK-NEXT:                   "end": {
// CHECK-NEXT:                    "offset": 206,
// CHECK-NEXT:                    "col": 36,
// CHECK-NEXT:                    "tokLen": 3
// CHECK-NEXT:                   }
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "type": {
// CHECK-NEXT:                   "qualType": "const int[1]"
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "valueCategory": "lvalue",
// CHECK-NEXT:                  "name": "arr",
// CHECK-NEXT:                  "isArrow": true,
// CHECK-NEXT:                  "referencedMemberDecl": "0x{{.*}}",
// CHECK-NEXT:                  "inner": [
// CHECK-NEXT:                   {
// CHECK-NEXT:                    "id": "0x{{.*}}",
// CHECK-NEXT:                    "kind": "CXXThisExpr",
// CHECK-NEXT:                    "range": {
// CHECK-NEXT:                     "begin": {
// CHECK-NEXT:                      "offset": 206,
// CHECK-NEXT:                      "col": 36,
// CHECK-NEXT:                      "tokLen": 3
// CHECK-NEXT:                     },
// CHECK-NEXT:                     "end": {
// CHECK-NEXT:                      "offset": 206,
// CHECK-NEXT:                      "col": 36,
// CHECK-NEXT:                      "tokLen": 3
// CHECK-NEXT:                     }
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "type": {
// CHECK-NEXT:                     "qualType": "const S *"
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "valueCategory": "prvalue",
// CHECK-NEXT:                    "implicit": true
// CHECK-NEXT:                   }
// CHECK-NEXT:                  ]
// CHECK-NEXT:                 }
// CHECK-NEXT:                ]
// CHECK-NEXT:               },
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "IntegerLiteral",
// CHECK-NEXT:                "range": {
// CHECK-NEXT:                 "begin": {
// CHECK-NEXT:                  "offset": 210,
// CHECK-NEXT:                  "col": 40,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 },
// CHECK-NEXT:                 "end": {
// CHECK-NEXT:                  "offset": 210,
// CHECK-NEXT:                  "col": 40,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 }
// CHECK-NEXT:                },
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "int"
// CHECK-NEXT:                },
// CHECK-NEXT:                "valueCategory": "prvalue",
// CHECK-NEXT:                "value": "1"
// CHECK-NEXT:               }
// CHECK-NEXT:              ]
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXConstructorDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 218,
// CHECK-NEXT:       "line": 7,
// CHECK-NEXT:       "col": 3,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 218,
// CHECK-NEXT:        "col": 3,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 223,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isUsed": true,
// CHECK-NEXT:      "name": "S",
// CHECK-NEXT:      "mangledName": "_ZN1SC1Ev",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void ()"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CompoundStmt",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 222,
// CHECK-NEXT:          "col": 7,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 223,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXDestructorDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 227,
// CHECK-NEXT:       "line": 8,
// CHECK-NEXT:       "col": 3,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 227,
// CHECK-NEXT:        "col": 3,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 233,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isUsed": true,
// CHECK-NEXT:      "name": "~S",
// CHECK-NEXT:      "mangledName": "_ZN1SD1Ev",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void () noexcept"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CompoundStmt",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 232,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 233,
// CHECK-NEXT:          "col": 9,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXConstructorDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 110,
// CHECK-NEXT:       "line": 3,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 110,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 110,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "name": "S",
// CHECK-NEXT:      "mangledName": "_ZN1SC1ERKS_",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "void (const S &)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "constexpr": true,
// CHECK-NEXT:      "explicitlyDefaulted": "default",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 110,
// CHECK-NEXT:         "col": 8,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 110,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 110,
// CHECK-NEXT:          "col": 8,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "const S &"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 241,
// CHECK-NEXT:     "line": 11,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 4
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 239,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 275,
// CHECK-NEXT:      "col": 37,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isUsed": true,
// CHECK-NEXT:    "name": "func",
// CHECK-NEXT:    "mangledName": "_Z4funcRKiRK1S",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "S (const int &, const S &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 257,
// CHECK-NEXT:       "col": 19,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 246,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 256,
// CHECK-NEXT:        "col": 18,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const int &"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 268,
// CHECK-NEXT:       "col": 30,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 259,
// CHECK-NEXT:        "col": 21,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 274,
// CHECK-NEXT:        "col": 36,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "s",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const S &"
// CHECK-NEXT:      },
// CHECK-NEXT:      "init": "c",
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ExprWithCleanups",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 272,
// CHECK-NEXT:          "col": 34,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 274,
// CHECK-NEXT:          "col": 36,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "const S"
// CHECK-NEXT:        },
// CHECK-NEXT:        "valueCategory": "lvalue",
// CHECK-NEXT:        "cleanupsHaveSideEffects": true,
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "MaterializeTemporaryExpr",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 272,
// CHECK-NEXT:            "col": 34,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 274,
// CHECK-NEXT:            "col": 36,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "const S"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "lvalue",
// CHECK-NEXT:          "storageDuration": "full expression",
// CHECK-NEXT:          "boundToLValueRef": true,
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "ImplicitCastExpr",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 272,
// CHECK-NEXT:              "col": 34,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 274,
// CHECK-NEXT:              "col": 36,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "const S"
// CHECK-NEXT:            },
// CHECK-NEXT:            "valueCategory": "prvalue",
// CHECK-NEXT:            "castKind": "NoOp",
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "CXXBindTemporaryExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 272,
// CHECK-NEXT:                "col": 34,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 274,
// CHECK-NEXT:                "col": 36,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "S"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "prvalue",
// CHECK-NEXT:              "temp": "0x{{.*}}",
// CHECK-NEXT:              "dtor": {
// CHECK-NEXT:               "id": "0x{{.*}}",
// CHECK-NEXT:               "kind": "CXXDestructorDecl",
// CHECK-NEXT:               "name": "~S",
// CHECK-NEXT:               "type": {
// CHECK-NEXT:                "qualType": "void () noexcept"
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "inner": [
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "CXXTemporaryObjectExpr",
// CHECK-NEXT:                "range": {
// CHECK-NEXT:                 "begin": {
// CHECK-NEXT:                  "offset": 272,
// CHECK-NEXT:                  "col": 34,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 },
// CHECK-NEXT:                 "end": {
// CHECK-NEXT:                  "offset": 274,
// CHECK-NEXT:                  "col": 36,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 }
// CHECK-NEXT:                },
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "S"
// CHECK-NEXT:                },
// CHECK-NEXT:                "valueCategory": "prvalue",
// CHECK-NEXT:                "ctorType": {
// CHECK-NEXT:                 "qualType": "void ()"
// CHECK-NEXT:                },
// CHECK-NEXT:                "hadMultipleCandidates": true,
// CHECK-NEXT:                "constructionKind": "complete"
// CHECK-NEXT:               }
// CHECK-NEXT:              ]
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 284,
// CHECK-NEXT:     "line": 13,
// CHECK-NEXT:     "col": 6,
// CHECK-NEXT:     "tokLen": 4
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 279,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 4
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 321,
// CHECK-NEXT:      "line": 15,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "test",
// CHECK-NEXT:    "mangledName": "_Z4testv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CompoundStmt",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 291,
// CHECK-NEXT:        "line": 13,
// CHECK-NEXT:        "col": 13,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 321,
// CHECK-NEXT:        "line": 15,
// CHECK-NEXT:        "col": 1,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CXXForRangeStmt",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 295,
// CHECK-NEXT:          "line": 14,
// CHECK-NEXT:          "col": 3,
// CHECK-NEXT:          "tokLen": 3
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 319,
// CHECK-NEXT:          "col": 27,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "inner": [
// CHECK-NEXT:         {},
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "DeclStmt",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 309,
// CHECK-NEXT:            "col": 17,
// CHECK-NEXT:            "tokLen": 4
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 309,
// CHECK-NEXT:            "col": 17,
// CHECK-NEXT:            "tokLen": 4
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "VarDecl",
// CHECK-NEXT:            "loc": {
// CHECK-NEXT:             "offset": 309,
// CHECK-NEXT:             "col": 17,
// CHECK-NEXT:             "tokLen": 4
// CHECK-NEXT:            },
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 309,
// CHECK-NEXT:              "col": 17,
// CHECK-NEXT:              "tokLen": 4
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 315,
// CHECK-NEXT:              "col": 23,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "isImplicit": true,
// CHECK-NEXT:            "isUsed": true,
// CHECK-NEXT:            "name": "__range1",
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "S &&"
// CHECK-NEXT:            },
// CHECK-NEXT:            "init": "c",
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "ExprWithCleanups",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 309,
// CHECK-NEXT:                "col": 17,
// CHECK-NEXT:                "tokLen": 4
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 315,
// CHECK-NEXT:                "col": 23,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "S"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "xvalue",
// CHECK-NEXT:              "cleanupsHaveSideEffects": true,
// CHECK-NEXT:              "inner": [
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "MaterializeTemporaryExpr",
// CHECK-NEXT:                "range": {
// CHECK-NEXT:                 "begin": {
// CHECK-NEXT:                  "offset": 309,
// CHECK-NEXT:                  "col": 17,
// CHECK-NEXT:                  "tokLen": 4
// CHECK-NEXT:                 },
// CHECK-NEXT:                 "end": {
// CHECK-NEXT:                  "offset": 315,
// CHECK-NEXT:                  "col": 23,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 }
// CHECK-NEXT:                },
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "S"
// CHECK-NEXT:                },
// CHECK-NEXT:                "valueCategory": "xvalue",
// CHECK-NEXT:                "extendingDecl": {
// CHECK-NEXT:                 "id": "0x{{.*}}",
// CHECK-NEXT:                 "kind": "VarDecl",
// CHECK-NEXT:                 "name": "__range1",
// CHECK-NEXT:                 "type": {
// CHECK-NEXT:                  "qualType": "S &&"
// CHECK-NEXT:                 }
// CHECK-NEXT:                },
// CHECK-NEXT:                "storageDuration": "automatic",
// CHECK-NEXT:                "inner": [
// CHECK-NEXT:                 {
// CHECK-NEXT:                  "id": "0x{{.*}}",
// CHECK-NEXT:                  "kind": "CXXBindTemporaryExpr",
// CHECK-NEXT:                  "range": {
// CHECK-NEXT:                   "begin": {
// CHECK-NEXT:                    "offset": 309,
// CHECK-NEXT:                    "col": 17,
// CHECK-NEXT:                    "tokLen": 4
// CHECK-NEXT:                   },
// CHECK-NEXT:                   "end": {
// CHECK-NEXT:                    "offset": 315,
// CHECK-NEXT:                    "col": 23,
// CHECK-NEXT:                    "tokLen": 1
// CHECK-NEXT:                   }
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "type": {
// CHECK-NEXT:                   "qualType": "S"
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "valueCategory": "prvalue",
// CHECK-NEXT:                  "temp": "0x{{.*}}",
// CHECK-NEXT:                  "dtor": {
// CHECK-NEXT:                   "id": "0x{{.*}}",
// CHECK-NEXT:                   "kind": "CXXDestructorDecl",
// CHECK-NEXT:                   "name": "~S",
// CHECK-NEXT:                   "type": {
// CHECK-NEXT:                    "qualType": "void () noexcept"
// CHECK-NEXT:                   }
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "inner": [
// CHECK-NEXT:                   {
// CHECK-NEXT:                    "id": "0x{{.*}}",
// CHECK-NEXT:                    "kind": "CallExpr",
// CHECK-NEXT:                    "range": {
// CHECK-NEXT:                     "begin": {
// CHECK-NEXT:                      "offset": 309,
// CHECK-NEXT:                      "col": 17,
// CHECK-NEXT:                      "tokLen": 4
// CHECK-NEXT:                     },
// CHECK-NEXT:                     "end": {
// CHECK-NEXT:                      "offset": 315,
// CHECK-NEXT:                      "col": 23,
// CHECK-NEXT:                      "tokLen": 1
// CHECK-NEXT:                     }
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "type": {
// CHECK-NEXT:                     "qualType": "S"
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "valueCategory": "prvalue",
// CHECK-NEXT:                    "inner": [
// CHECK-NEXT:                     {
// CHECK-NEXT:                      "id": "0x{{.*}}",
// CHECK-NEXT:                      "kind": "ImplicitCastExpr",
// CHECK-NEXT:                      "range": {
// CHECK-NEXT:                       "begin": {
// CHECK-NEXT:                        "offset": 309,
// CHECK-NEXT:                        "col": 17,
// CHECK-NEXT:                        "tokLen": 4
// CHECK-NEXT:                       },
// CHECK-NEXT:                       "end": {
// CHECK-NEXT:                        "offset": 309,
// CHECK-NEXT:                        "col": 17,
// CHECK-NEXT:                        "tokLen": 4
// CHECK-NEXT:                       }
// CHECK-NEXT:                      },
// CHECK-NEXT:                      "type": {
// CHECK-NEXT:                       "qualType": "S (*)(const int &, const S &)"
// CHECK-NEXT:                      },
// CHECK-NEXT:                      "valueCategory": "prvalue",
// CHECK-NEXT:                      "castKind": "FunctionToPointerDecay",
// CHECK-NEXT:                      "inner": [
// CHECK-NEXT:                       {
// CHECK-NEXT:                        "id": "0x{{.*}}",
// CHECK-NEXT:                        "kind": "DeclRefExpr",
// CHECK-NEXT:                        "range": {
// CHECK-NEXT:                         "begin": {
// CHECK-NEXT:                          "offset": 309,
// CHECK-NEXT:                          "col": 17,
// CHECK-NEXT:                          "tokLen": 4
// CHECK-NEXT:                         },
// CHECK-NEXT:                         "end": {
// CHECK-NEXT:                          "offset": 309,
// CHECK-NEXT:                          "col": 17,
// CHECK-NEXT:                          "tokLen": 4
// CHECK-NEXT:                         }
// CHECK-NEXT:                        },
// CHECK-NEXT:                        "type": {
// CHECK-NEXT:                         "qualType": "S (const int &, const S &)"
// CHECK-NEXT:                        },
// CHECK-NEXT:                        "valueCategory": "lvalue",
// CHECK-NEXT:                        "referencedDecl": {
// CHECK-NEXT:                         "id": "0x{{.*}}",
// CHECK-NEXT:                         "kind": "FunctionDecl",
// CHECK-NEXT:                         "name": "func",
// CHECK-NEXT:                         "type": {
// CHECK-NEXT:                          "qualType": "S (const int &, const S &)"
// CHECK-NEXT:                         }
// CHECK-NEXT:                        }
// CHECK-NEXT:                       }
// CHECK-NEXT:                      ]
// CHECK-NEXT:                     },
// CHECK-NEXT:                     {
// CHECK-NEXT:                      "id": "0x{{.*}}",
// CHECK-NEXT:                      "kind": "MaterializeTemporaryExpr",
// CHECK-NEXT:                      "range": {
// CHECK-NEXT:                       "begin": {
// CHECK-NEXT:                        "offset": 314,
// CHECK-NEXT:                        "col": 22,
// CHECK-NEXT:                        "tokLen": 1
// CHECK-NEXT:                       },
// CHECK-NEXT:                       "end": {
// CHECK-NEXT:                        "offset": 314,
// CHECK-NEXT:                        "col": 22,
// CHECK-NEXT:                        "tokLen": 1
// CHECK-NEXT:                       }
// CHECK-NEXT:                      },
// CHECK-NEXT:                      "type": {
// CHECK-NEXT:                       "qualType": "const int"
// CHECK-NEXT:                      },
// CHECK-NEXT:                      "valueCategory": "lvalue",
// CHECK-NEXT:                      "extendingDecl": {
// CHECK-NEXT:                       "id": "0x{{.*}}",
// CHECK-NEXT:                       "kind": "VarDecl",
// CHECK-NEXT:                       "name": "__range1",
// CHECK-NEXT:                       "type": {
// CHECK-NEXT:                        "qualType": "S &&"
// CHECK-NEXT:                       }
// CHECK-NEXT:                      },
// CHECK-NEXT:                      "storageDuration": "automatic",
// CHECK-NEXT:                      "boundToLValueRef": true,
// CHECK-NEXT:                      "inner": [
// CHECK-NEXT:                       {
// CHECK-NEXT:                        "id": "0x{{.*}}",
// CHECK-NEXT:                        "kind": "ImplicitCastExpr",
// CHECK-NEXT:                        "range": {
// CHECK-NEXT:                         "begin": {
// CHECK-NEXT:                          "offset": 314,
// CHECK-NEXT:                          "col": 22,
// CHECK-NEXT:                          "tokLen": 1
// CHECK-NEXT:                         },
// CHECK-NEXT:                         "end": {
// CHECK-NEXT:                          "offset": 314,
// CHECK-NEXT:                          "col": 22,
// CHECK-NEXT:                          "tokLen": 1
// CHECK-NEXT:                         }
// CHECK-NEXT:                        },
// CHECK-NEXT:                        "type": {
// CHECK-NEXT:                         "qualType": "const int"
// CHECK-NEXT:                        },
// CHECK-NEXT:                        "valueCategory": "prvalue",
// CHECK-NEXT:                        "castKind": "NoOp",
// CHECK-NEXT:                        "inner": [
// CHECK-NEXT:                         {
// CHECK-NEXT:                          "id": "0x{{.*}}",
// CHECK-NEXT:                          "kind": "IntegerLiteral",
// CHECK-NEXT:                          "range": {
// CHECK-NEXT:                           "begin": {
// CHECK-NEXT:                            "offset": 314,
// CHECK-NEXT:                            "col": 22,
// CHECK-NEXT:                            "tokLen": 1
// CHECK-NEXT:                           },
// CHECK-NEXT:                           "end": {
// CHECK-NEXT:                            "offset": 314,
// CHECK-NEXT:                            "col": 22,
// CHECK-NEXT:                            "tokLen": 1
// CHECK-NEXT:                           }
// CHECK-NEXT:                          },
// CHECK-NEXT:                          "type": {
// CHECK-NEXT:                           "qualType": "int"
// CHECK-NEXT:                          },
// CHECK-NEXT:                          "valueCategory": "prvalue",
// CHECK-NEXT:                          "value": "1"
// CHECK-NEXT:                         }
// CHECK-NEXT:                        ]
// CHECK-NEXT:                       }
// CHECK-NEXT:                      ]
// CHECK-NEXT:                     },
// CHECK-NEXT:                     {
// CHECK-NEXT:                      "id": "0x{{.*}}",
// CHECK-NEXT:                      "kind": "CXXDefaultArgExpr",
// CHECK-NEXT:                      "range": {
// CHECK-NEXT:                       "begin": {},
// CHECK-NEXT:                       "end": {}
// CHECK-NEXT:                      },
// CHECK-NEXT:                      "type": {
// CHECK-NEXT:                       "qualType": "const S"
// CHECK-NEXT:                      },
// CHECK-NEXT:                      "valueCategory": "lvalue",
// CHECK-NEXT:                      "hasRewrittenInit": true,
// CHECK-NEXT:                      "inner": [
// CHECK-NEXT:                       {
// CHECK-NEXT:                        "id": "0x{{.*}}",
// CHECK-NEXT:                        "kind": "MaterializeTemporaryExpr",
// CHECK-NEXT:                        "range": {
// CHECK-NEXT:                         "begin": {
// CHECK-NEXT:                          "offset": 272,
// CHECK-NEXT:                          "line": 11,
// CHECK-NEXT:                          "col": 34,
// CHECK-NEXT:                          "tokLen": 1
// CHECK-NEXT:                         },
// CHECK-NEXT:                         "end": {
// CHECK-NEXT:                          "offset": 274,
// CHECK-NEXT:                          "col": 36,
// CHECK-NEXT:                          "tokLen": 1
// CHECK-NEXT:                         }
// CHECK-NEXT:                        },
// CHECK-NEXT:                        "type": {
// CHECK-NEXT:                         "qualType": "const S"
// CHECK-NEXT:                        },
// CHECK-NEXT:                        "valueCategory": "lvalue",
// CHECK-NEXT:                        "extendingDecl": {
// CHECK-NEXT:                         "id": "0x{{.*}}",
// CHECK-NEXT:                         "kind": "VarDecl",
// CHECK-NEXT:                         "name": "__range1",
// CHECK-NEXT:                         "type": {
// CHECK-NEXT:                          "qualType": "S &&"
// CHECK-NEXT:                         }
// CHECK-NEXT:                        },
// CHECK-NEXT:                        "storageDuration": "automatic",
// CHECK-NEXT:                        "boundToLValueRef": true,
// CHECK-NEXT:                        "inner": [
// CHECK-NEXT:                         {
// CHECK-NEXT:                          "id": "0x{{.*}}",
// CHECK-NEXT:                          "kind": "ImplicitCastExpr",
// CHECK-NEXT:                          "range": {
// CHECK-NEXT:                           "begin": {
// CHECK-NEXT:                            "offset": 272,
// CHECK-NEXT:                            "col": 34,
// CHECK-NEXT:                            "tokLen": 1
// CHECK-NEXT:                           },
// CHECK-NEXT:                           "end": {
// CHECK-NEXT:                            "offset": 274,
// CHECK-NEXT:                            "col": 36,
// CHECK-NEXT:                            "tokLen": 1
// CHECK-NEXT:                           }
// CHECK-NEXT:                          },
// CHECK-NEXT:                          "type": {
// CHECK-NEXT:                           "qualType": "const S"
// CHECK-NEXT:                          },
// CHECK-NEXT:                          "valueCategory": "prvalue",
// CHECK-NEXT:                          "castKind": "NoOp",
// CHECK-NEXT:                          "inner": [
// CHECK-NEXT:                           {
// CHECK-NEXT:                            "id": "0x{{.*}}",
// CHECK-NEXT:                            "kind": "CXXBindTemporaryExpr",
// CHECK-NEXT:                            "range": {
// CHECK-NEXT:                             "begin": {
// CHECK-NEXT:                              "offset": 272,
// CHECK-NEXT:                              "col": 34,
// CHECK-NEXT:                              "tokLen": 1
// CHECK-NEXT:                             },
// CHECK-NEXT:                             "end": {
// CHECK-NEXT:                              "offset": 274,
// CHECK-NEXT:                              "col": 36,
// CHECK-NEXT:                              "tokLen": 1
// CHECK-NEXT:                             }
// CHECK-NEXT:                            },
// CHECK-NEXT:                            "type": {
// CHECK-NEXT:                             "qualType": "S"
// CHECK-NEXT:                            },
// CHECK-NEXT:                            "valueCategory": "prvalue",
// CHECK-NEXT:                            "temp": "0x{{.*}}",
// CHECK-NEXT:                            "dtor": {
// CHECK-NEXT:                             "id": "0x{{.*}}",
// CHECK-NEXT:                             "kind": "CXXDestructorDecl",
// CHECK-NEXT:                             "name": "~S",
// CHECK-NEXT:                             "type": {
// CHECK-NEXT:                              "qualType": "void () noexcept"
// CHECK-NEXT:                             }
// CHECK-NEXT:                            },
// CHECK-NEXT:                            "inner": [
// CHECK-NEXT:                             {
// CHECK-NEXT:                              "id": "0x{{.*}}",
// CHECK-NEXT:                              "kind": "CXXTemporaryObjectExpr",
// CHECK-NEXT:                              "range": {
// CHECK-NEXT:                               "begin": {
// CHECK-NEXT:                                "offset": 272,
// CHECK-NEXT:                                "col": 34,
// CHECK-NEXT:                                "tokLen": 1
// CHECK-NEXT:                               },
// CHECK-NEXT:                               "end": {
// CHECK-NEXT:                                "offset": 274,
// CHECK-NEXT:                                "col": 36,
// CHECK-NEXT:                                "tokLen": 1
// CHECK-NEXT:                               }
// CHECK-NEXT:                              },
// CHECK-NEXT:                              "type": {
// CHECK-NEXT:                               "qualType": "S"
// CHECK-NEXT:                              },
// CHECK-NEXT:                              "valueCategory": "prvalue",
// CHECK-NEXT:                              "ctorType": {
// CHECK-NEXT:                               "qualType": "void ()"
// CHECK-NEXT:                              },
// CHECK-NEXT:                              "hadMultipleCandidates": true,
// CHECK-NEXT:                              "constructionKind": "complete"
// CHECK-NEXT:                             }
// CHECK-NEXT:                            ]
// CHECK-NEXT:                           }
// CHECK-NEXT:                          ]
// CHECK-NEXT:                         }
// CHECK-NEXT:                        ]
// CHECK-NEXT:                       }
// CHECK-NEXT:                      ]
// CHECK-NEXT:                     }
// CHECK-NEXT:                    ]
// CHECK-NEXT:                   }
// CHECK-NEXT:                  ]
// CHECK-NEXT:                 }
// CHECK-NEXT:                ]
// CHECK-NEXT:               }
// CHECK-NEXT:              ]
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "DeclStmt",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 307,
// CHECK-NEXT:            "line": 14,
// CHECK-NEXT:            "col": 15,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 307,
// CHECK-NEXT:            "col": 15,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "VarDecl",
// CHECK-NEXT:            "loc": {
// CHECK-NEXT:             "offset": 307,
// CHECK-NEXT:             "col": 15,
// CHECK-NEXT:             "tokLen": 1
// CHECK-NEXT:            },
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "isImplicit": true,
// CHECK-NEXT:            "isUsed": true,
// CHECK-NEXT:            "name": "__begin1",
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "const int *"
// CHECK-NEXT:            },
// CHECK-NEXT:            "init": "c",
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "CXXMemberCallExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "const int *"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "prvalue",
// CHECK-NEXT:              "inner": [
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "MemberExpr",
// CHECK-NEXT:                "range": {
// CHECK-NEXT:                 "begin": {
// CHECK-NEXT:                  "offset": 307,
// CHECK-NEXT:                  "col": 15,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 },
// CHECK-NEXT:                 "end": {
// CHECK-NEXT:                  "offset": 307,
// CHECK-NEXT:                  "col": 15,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 }
// CHECK-NEXT:                },
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "<bound member function type>"
// CHECK-NEXT:                },
// CHECK-NEXT:                "valueCategory": "prvalue",
// CHECK-NEXT:                "name": "begin",
// CHECK-NEXT:                "isArrow": false,
// CHECK-NEXT:                "referencedMemberDecl": "0x{{.*}}",
// CHECK-NEXT:                "inner": [
// CHECK-NEXT:                 {
// CHECK-NEXT:                  "id": "0x{{.*}}",
// CHECK-NEXT:                  "kind": "ImplicitCastExpr",
// CHECK-NEXT:                  "range": {
// CHECK-NEXT:                   "begin": {
// CHECK-NEXT:                    "offset": 307,
// CHECK-NEXT:                    "col": 15,
// CHECK-NEXT:                    "tokLen": 1
// CHECK-NEXT:                   },
// CHECK-NEXT:                   "end": {
// CHECK-NEXT:                    "offset": 307,
// CHECK-NEXT:                    "col": 15,
// CHECK-NEXT:                    "tokLen": 1
// CHECK-NEXT:                   }
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "type": {
// CHECK-NEXT:                   "qualType": "const S"
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "valueCategory": "lvalue",
// CHECK-NEXT:                  "castKind": "NoOp",
// CHECK-NEXT:                  "inner": [
// CHECK-NEXT:                   {
// CHECK-NEXT:                    "id": "0x{{.*}}",
// CHECK-NEXT:                    "kind": "DeclRefExpr",
// CHECK-NEXT:                    "range": {
// CHECK-NEXT:                     "begin": {
// CHECK-NEXT:                      "offset": 307,
// CHECK-NEXT:                      "col": 15,
// CHECK-NEXT:                      "tokLen": 1
// CHECK-NEXT:                     },
// CHECK-NEXT:                     "end": {
// CHECK-NEXT:                      "offset": 307,
// CHECK-NEXT:                      "col": 15,
// CHECK-NEXT:                      "tokLen": 1
// CHECK-NEXT:                     }
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "type": {
// CHECK-NEXT:                     "qualType": "S"
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "valueCategory": "lvalue",
// CHECK-NEXT:                    "referencedDecl": {
// CHECK-NEXT:                     "id": "0x{{.*}}",
// CHECK-NEXT:                     "kind": "VarDecl",
// CHECK-NEXT:                     "name": "__range1",
// CHECK-NEXT:                     "type": {
// CHECK-NEXT:                      "qualType": "S &&"
// CHECK-NEXT:                     }
// CHECK-NEXT:                    }
// CHECK-NEXT:                   }
// CHECK-NEXT:                  ]
// CHECK-NEXT:                 }
// CHECK-NEXT:                ]
// CHECK-NEXT:               }
// CHECK-NEXT:              ]
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "DeclStmt",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 307,
// CHECK-NEXT:            "col": 15,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 307,
// CHECK-NEXT:            "col": 15,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "VarDecl",
// CHECK-NEXT:            "loc": {
// CHECK-NEXT:             "offset": 307,
// CHECK-NEXT:             "col": 15,
// CHECK-NEXT:             "tokLen": 1
// CHECK-NEXT:            },
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "isImplicit": true,
// CHECK-NEXT:            "isUsed": true,
// CHECK-NEXT:            "name": "__end1",
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "const int *"
// CHECK-NEXT:            },
// CHECK-NEXT:            "init": "c",
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "CXXMemberCallExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "const int *"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "prvalue",
// CHECK-NEXT:              "inner": [
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "MemberExpr",
// CHECK-NEXT:                "range": {
// CHECK-NEXT:                 "begin": {
// CHECK-NEXT:                  "offset": 307,
// CHECK-NEXT:                  "col": 15,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 },
// CHECK-NEXT:                 "end": {
// CHECK-NEXT:                  "offset": 307,
// CHECK-NEXT:                  "col": 15,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 }
// CHECK-NEXT:                },
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "<bound member function type>"
// CHECK-NEXT:                },
// CHECK-NEXT:                "valueCategory": "prvalue",
// CHECK-NEXT:                "name": "end",
// CHECK-NEXT:                "isArrow": false,
// CHECK-NEXT:                "referencedMemberDecl": "0x{{.*}}",
// CHECK-NEXT:                "inner": [
// CHECK-NEXT:                 {
// CHECK-NEXT:                  "id": "0x{{.*}}",
// CHECK-NEXT:                  "kind": "ImplicitCastExpr",
// CHECK-NEXT:                  "range": {
// CHECK-NEXT:                   "begin": {
// CHECK-NEXT:                    "offset": 307,
// CHECK-NEXT:                    "col": 15,
// CHECK-NEXT:                    "tokLen": 1
// CHECK-NEXT:                   },
// CHECK-NEXT:                   "end": {
// CHECK-NEXT:                    "offset": 307,
// CHECK-NEXT:                    "col": 15,
// CHECK-NEXT:                    "tokLen": 1
// CHECK-NEXT:                   }
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "type": {
// CHECK-NEXT:                   "qualType": "const S"
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "valueCategory": "lvalue",
// CHECK-NEXT:                  "castKind": "NoOp",
// CHECK-NEXT:                  "inner": [
// CHECK-NEXT:                   {
// CHECK-NEXT:                    "id": "0x{{.*}}",
// CHECK-NEXT:                    "kind": "DeclRefExpr",
// CHECK-NEXT:                    "range": {
// CHECK-NEXT:                     "begin": {
// CHECK-NEXT:                      "offset": 307,
// CHECK-NEXT:                      "col": 15,
// CHECK-NEXT:                      "tokLen": 1
// CHECK-NEXT:                     },
// CHECK-NEXT:                     "end": {
// CHECK-NEXT:                      "offset": 307,
// CHECK-NEXT:                      "col": 15,
// CHECK-NEXT:                      "tokLen": 1
// CHECK-NEXT:                     }
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "type": {
// CHECK-NEXT:                     "qualType": "S"
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "valueCategory": "lvalue",
// CHECK-NEXT:                    "referencedDecl": {
// CHECK-NEXT:                     "id": "0x{{.*}}",
// CHECK-NEXT:                     "kind": "VarDecl",
// CHECK-NEXT:                     "name": "__range1",
// CHECK-NEXT:                     "type": {
// CHECK-NEXT:                      "qualType": "S &&"
// CHECK-NEXT:                     }
// CHECK-NEXT:                    }
// CHECK-NEXT:                   }
// CHECK-NEXT:                  ]
// CHECK-NEXT:                 }
// CHECK-NEXT:                ]
// CHECK-NEXT:               }
// CHECK-NEXT:              ]
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "BinaryOperator",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 307,
// CHECK-NEXT:            "col": 15,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 307,
// CHECK-NEXT:            "col": 15,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "bool"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "prvalue",
// CHECK-NEXT:          "opcode": "!=",
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "ImplicitCastExpr",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "const int *"
// CHECK-NEXT:            },
// CHECK-NEXT:            "valueCategory": "prvalue",
// CHECK-NEXT:            "castKind": "LValueToRValue",
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "DeclRefExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "const int *"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "lvalue",
// CHECK-NEXT:              "referencedDecl": {
// CHECK-NEXT:               "id": "0x{{.*}}",
// CHECK-NEXT:               "kind": "VarDecl",
// CHECK-NEXT:               "name": "__begin1",
// CHECK-NEXT:               "type": {
// CHECK-NEXT:                "qualType": "const int *"
// CHECK-NEXT:               }
// CHECK-NEXT:              }
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           },
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "ImplicitCastExpr",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "const int *"
// CHECK-NEXT:            },
// CHECK-NEXT:            "valueCategory": "prvalue",
// CHECK-NEXT:            "castKind": "LValueToRValue",
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "DeclRefExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "const int *"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "lvalue",
// CHECK-NEXT:              "referencedDecl": {
// CHECK-NEXT:               "id": "0x{{.*}}",
// CHECK-NEXT:               "kind": "VarDecl",
// CHECK-NEXT:               "name": "__end1",
// CHECK-NEXT:               "type": {
// CHECK-NEXT:                "qualType": "const int *"
// CHECK-NEXT:               }
// CHECK-NEXT:              }
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "UnaryOperator",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 307,
// CHECK-NEXT:            "col": 15,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 307,
// CHECK-NEXT:            "col": 15,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "type": {
// CHECK-NEXT:           "qualType": "const int *"
// CHECK-NEXT:          },
// CHECK-NEXT:          "valueCategory": "lvalue",
// CHECK-NEXT:          "isPostfix": false,
// CHECK-NEXT:          "opcode": "++",
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "DeclRefExpr",
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "const int *"
// CHECK-NEXT:            },
// CHECK-NEXT:            "valueCategory": "lvalue",
// CHECK-NEXT:            "referencedDecl": {
// CHECK-NEXT:             "id": "0x{{.*}}",
// CHECK-NEXT:             "kind": "VarDecl",
// CHECK-NEXT:             "name": "__begin1",
// CHECK-NEXT:             "type": {
// CHECK-NEXT:              "qualType": "const int *"
// CHECK-NEXT:             }
// CHECK-NEXT:            }
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "DeclStmt",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 300,
// CHECK-NEXT:            "col": 8,
// CHECK-NEXT:            "tokLen": 4
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 316,
// CHECK-NEXT:            "col": 24,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          },
// CHECK-NEXT:          "inner": [
// CHECK-NEXT:           {
// CHECK-NEXT:            "id": "0x{{.*}}",
// CHECK-NEXT:            "kind": "VarDecl",
// CHECK-NEXT:            "loc": {
// CHECK-NEXT:             "offset": 305,
// CHECK-NEXT:             "col": 13,
// CHECK-NEXT:             "tokLen": 1
// CHECK-NEXT:            },
// CHECK-NEXT:            "range": {
// CHECK-NEXT:             "begin": {
// CHECK-NEXT:              "offset": 300,
// CHECK-NEXT:              "col": 8,
// CHECK-NEXT:              "tokLen": 4
// CHECK-NEXT:             },
// CHECK-NEXT:             "end": {
// CHECK-NEXT:              "offset": 307,
// CHECK-NEXT:              "col": 15,
// CHECK-NEXT:              "tokLen": 1
// CHECK-NEXT:             }
// CHECK-NEXT:            },
// CHECK-NEXT:            "name": "v",
// CHECK-NEXT:            "type": {
// CHECK-NEXT:             "qualType": "int"
// CHECK-NEXT:            },
// CHECK-NEXT:            "init": "c",
// CHECK-NEXT:            "inner": [
// CHECK-NEXT:             {
// CHECK-NEXT:              "id": "0x{{.*}}",
// CHECK-NEXT:              "kind": "ImplicitCastExpr",
// CHECK-NEXT:              "range": {
// CHECK-NEXT:               "begin": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               },
// CHECK-NEXT:               "end": {
// CHECK-NEXT:                "offset": 307,
// CHECK-NEXT:                "col": 15,
// CHECK-NEXT:                "tokLen": 1
// CHECK-NEXT:               }
// CHECK-NEXT:              },
// CHECK-NEXT:              "type": {
// CHECK-NEXT:               "qualType": "int"
// CHECK-NEXT:              },
// CHECK-NEXT:              "valueCategory": "prvalue",
// CHECK-NEXT:              "castKind": "LValueToRValue",
// CHECK-NEXT:              "inner": [
// CHECK-NEXT:               {
// CHECK-NEXT:                "id": "0x{{.*}}",
// CHECK-NEXT:                "kind": "UnaryOperator",
// CHECK-NEXT:                "range": {
// CHECK-NEXT:                 "begin": {
// CHECK-NEXT:                  "offset": 307,
// CHECK-NEXT:                  "col": 15,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 },
// CHECK-NEXT:                 "end": {
// CHECK-NEXT:                  "offset": 307,
// CHECK-NEXT:                  "col": 15,
// CHECK-NEXT:                  "tokLen": 1
// CHECK-NEXT:                 }
// CHECK-NEXT:                },
// CHECK-NEXT:                "type": {
// CHECK-NEXT:                 "qualType": "const int"
// CHECK-NEXT:                },
// CHECK-NEXT:                "valueCategory": "lvalue",
// CHECK-NEXT:                "isPostfix": false,
// CHECK-NEXT:                "opcode": "*",
// CHECK-NEXT:                "canOverflow": false,
// CHECK-NEXT:                "inner": [
// CHECK-NEXT:                 {
// CHECK-NEXT:                  "id": "0x{{.*}}",
// CHECK-NEXT:                  "kind": "ImplicitCastExpr",
// CHECK-NEXT:                  "range": {
// CHECK-NEXT:                   "begin": {
// CHECK-NEXT:                    "offset": 307,
// CHECK-NEXT:                    "col": 15,
// CHECK-NEXT:                    "tokLen": 1
// CHECK-NEXT:                   },
// CHECK-NEXT:                   "end": {
// CHECK-NEXT:                    "offset": 307,
// CHECK-NEXT:                    "col": 15,
// CHECK-NEXT:                    "tokLen": 1
// CHECK-NEXT:                   }
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "type": {
// CHECK-NEXT:                   "qualType": "const int *"
// CHECK-NEXT:                  },
// CHECK-NEXT:                  "valueCategory": "prvalue",
// CHECK-NEXT:                  "castKind": "LValueToRValue",
// CHECK-NEXT:                  "inner": [
// CHECK-NEXT:                   {
// CHECK-NEXT:                    "id": "0x{{.*}}",
// CHECK-NEXT:                    "kind": "DeclRefExpr",
// CHECK-NEXT:                    "range": {
// CHECK-NEXT:                     "begin": {
// CHECK-NEXT:                      "offset": 307,
// CHECK-NEXT:                      "col": 15,
// CHECK-NEXT:                      "tokLen": 1
// CHECK-NEXT:                     },
// CHECK-NEXT:                     "end": {
// CHECK-NEXT:                      "offset": 307,
// CHECK-NEXT:                      "col": 15,
// CHECK-NEXT:                      "tokLen": 1
// CHECK-NEXT:                     }
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "type": {
// CHECK-NEXT:                     "qualType": "const int *"
// CHECK-NEXT:                    },
// CHECK-NEXT:                    "valueCategory": "lvalue",
// CHECK-NEXT:                    "referencedDecl": {
// CHECK-NEXT:                     "id": "0x{{.*}}",
// CHECK-NEXT:                     "kind": "VarDecl",
// CHECK-NEXT:                     "name": "__begin1",
// CHECK-NEXT:                     "type": {
// CHECK-NEXT:                      "qualType": "const int *"
// CHECK-NEXT:                     }
// CHECK-NEXT:                    }
// CHECK-NEXT:                   }
// CHECK-NEXT:                  ]
// CHECK-NEXT:                 }
// CHECK-NEXT:                ]
// CHECK-NEXT:               }
// CHECK-NEXT:              ]
// CHECK-NEXT:             }
// CHECK-NEXT:            ]
// CHECK-NEXT:           }
// CHECK-NEXT:          ]
// CHECK-NEXT:         },
// CHECK-NEXT:         {
// CHECK-NEXT:          "id": "0x{{.*}}",
// CHECK-NEXT:          "kind": "CompoundStmt",
// CHECK-NEXT:          "range": {
// CHECK-NEXT:           "begin": {
// CHECK-NEXT:            "offset": 318,
// CHECK-NEXT:            "col": 26,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           },
// CHECK-NEXT:           "end": {
// CHECK-NEXT:            "offset": 319,
// CHECK-NEXT:            "col": 27,
// CHECK-NEXT:            "tokLen": 1
// CHECK-NEXT:           }
// CHECK-NEXT:          }
// CHECK-NEXT:         }
// CHECK-NEXT:        ]
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }
