# This file is automatically generated by tools/idna-data

import unittest

import idna


class UTS46Tests(unittest.TestCase):

    def test_uts46_106(self):
        self.assertEqual(idna.decode('fass.de', uts46=True, strict=True), 'fass.de')
        self.assertEqual(idna.encode('fass.de', uts46=True, strict=True), b'fass.de')

    def test_uts46_107(self):
        self.assertEqual(idna.decode('faß.de', uts46=True, strict=True), 'faß.de')
        self.assertEqual(idna.encode('faß.de', uts46=True, strict=True), b'xn--fa-hia.de')

    def test_uts46_108(self):
        self.assertEqual(idna.decode('Faß.de', uts46=True, strict=True), 'faß.de')
        self.assertEqual(idna.encode('Faß.de', uts46=True, strict=True), b'xn--fa-hia.de')

    def test_uts46_109(self):
        self.assertEqual(idna.decode('xn--fa-hia.de', uts46=True, strict=True), 'faß.de')
        self.assertEqual(idna.encode('xn--fa-hia.de', uts46=True, strict=True), b'xn--fa-hia.de')

    def test_uts46_113(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'àא', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'àא', strict=True)

    def test_uts46_114(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'àא', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'àא', strict=True)

    def test_uts46_115(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Àא', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Àא', strict=True)

    def test_uts46_116(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Àא', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Àא', strict=True)

    def test_uts46_117(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ca24w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ca24w', strict=True)

    def test_uts46_123(self):
        self.assertEqual(idna.decode('à.א̈', uts46=True, strict=True), 'à.א̈')
        self.assertEqual(idna.encode('à.א̈', uts46=True, strict=True), b'xn--0ca.xn--ssa73l')

    def test_uts46_124(self):
        self.assertEqual(idna.decode('à.א̈', uts46=True, strict=True), 'à.א̈')
        self.assertEqual(idna.encode('à.א̈', uts46=True, strict=True), b'xn--0ca.xn--ssa73l')

    def test_uts46_125(self):
        self.assertEqual(idna.decode('À.א̈', uts46=True, strict=True), 'à.א̈')
        self.assertEqual(idna.encode('À.א̈', uts46=True, strict=True), b'xn--0ca.xn--ssa73l')

    def test_uts46_126(self):
        self.assertEqual(idna.decode('À.א̈', uts46=True, strict=True), 'à.א̈')
        self.assertEqual(idna.encode('À.א̈', uts46=True, strict=True), b'xn--0ca.xn--ssa73l')

    def test_uts46_127(self):
        self.assertEqual(idna.decode('xn--0ca.xn--ssa73l', uts46=True, strict=True), 'à.א̈')
        self.assertEqual(idna.encode('xn--0ca.xn--ssa73l', uts46=True, strict=True), b'xn--0ca.xn--ssa73l')

    def test_uts46_128(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'à.א0٠א', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'à.א0٠א', strict=True)

    def test_uts46_129(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'à.א0٠א', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'à.א0٠א', strict=True)

    def test_uts46_130(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'À.א0٠א', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'À.א0٠א', strict=True)

    def test_uts46_131(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'À.א0٠א', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'À.א0٠א', strict=True)

    def test_uts46_132(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ca.xn--0-zhcb98c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ca.xn--0-zhcb98c', strict=True)

    def test_uts46_133(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̈.א', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̈.א', strict=True)

    def test_uts46_134(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ssa.xn--4db', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ssa.xn--4db', strict=True)

    def test_uts46_135(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'à.א0٠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'à.א0٠', strict=True)

    def test_uts46_136(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'à.א0٠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'à.א0٠', strict=True)

    def test_uts46_137(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'À.א0٠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'À.א0٠', strict=True)

    def test_uts46_138(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'À.א0٠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'À.א0٠', strict=True)

    def test_uts46_139(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ca.xn--0-zhc74b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ca.xn--0-zhc74b', strict=True)

    def test_uts46_145(self):
        self.assertEqual(idna.decode('à̈.א', uts46=True, strict=True), 'à̈.א')
        self.assertEqual(idna.encode('à̈.א', uts46=True, strict=True), b'xn--0ca81i.xn--4db')

    def test_uts46_146(self):
        self.assertEqual(idna.decode('à̈.א', uts46=True, strict=True), 'à̈.א')
        self.assertEqual(idna.encode('à̈.א', uts46=True, strict=True), b'xn--0ca81i.xn--4db')

    def test_uts46_147(self):
        self.assertEqual(idna.decode('À̈.א', uts46=True, strict=True), 'à̈.א')
        self.assertEqual(idna.encode('À̈.א', uts46=True, strict=True), b'xn--0ca81i.xn--4db')

    def test_uts46_148(self):
        self.assertEqual(idna.decode('À̈.א', uts46=True, strict=True), 'à̈.א')
        self.assertEqual(idna.encode('À̈.א', uts46=True, strict=True), b'xn--0ca81i.xn--4db')

    def test_uts46_149(self):
        self.assertEqual(idna.decode('xn--0ca81i.xn--4db', uts46=True, strict=True), 'à̈.א')
        self.assertEqual(idna.encode('xn--0ca81i.xn--4db', uts46=True, strict=True), b'xn--0ca81i.xn--4db')

    def test_uts46_153(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a\u200cb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a\u200cb', strict=True)

    def test_uts46_154(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A\u200cB', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A\u200cB', strict=True)

    def test_uts46_155(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A\u200cb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A\u200cb', strict=True)

    def test_uts46_156(self):
        self.assertEqual(idna.decode('ab', uts46=True, strict=True), 'ab')
        self.assertEqual(idna.encode('ab', uts46=True, strict=True), b'ab')

    def test_uts46_157(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ab-j1t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ab-j1t', strict=True)

    def test_uts46_158(self):
        self.assertEqual(idna.decode('a्\u200cb', uts46=True, strict=True), 'a्\u200cb')
        self.assertEqual(idna.encode('a्\u200cb', uts46=True, strict=True), b'xn--ab-fsf604u')

    def test_uts46_159(self):
        self.assertEqual(idna.decode('A्\u200cB', uts46=True, strict=True), 'a्\u200cb')
        self.assertEqual(idna.encode('A्\u200cB', uts46=True, strict=True), b'xn--ab-fsf604u')

    def test_uts46_160(self):
        self.assertEqual(idna.decode('A्\u200cb', uts46=True, strict=True), 'a्\u200cb')
        self.assertEqual(idna.encode('A्\u200cb', uts46=True, strict=True), b'xn--ab-fsf604u')

    def test_uts46_161(self):
        self.assertEqual(idna.decode('xn--ab-fsf', uts46=True, strict=True), 'a्b')
        self.assertEqual(idna.encode('xn--ab-fsf', uts46=True, strict=True), b'xn--ab-fsf')

    def test_uts46_162(self):
        self.assertEqual(idna.decode('a्b', uts46=True, strict=True), 'a्b')
        self.assertEqual(idna.encode('a्b', uts46=True, strict=True), b'xn--ab-fsf')

    def test_uts46_163(self):
        self.assertEqual(idna.decode('A्B', uts46=True, strict=True), 'a्b')
        self.assertEqual(idna.encode('A्B', uts46=True, strict=True), b'xn--ab-fsf')

    def test_uts46_164(self):
        self.assertEqual(idna.decode('A्b', uts46=True, strict=True), 'a्b')
        self.assertEqual(idna.encode('A्b', uts46=True, strict=True), b'xn--ab-fsf')

    def test_uts46_165(self):
        self.assertEqual(idna.decode('xn--ab-fsf604u', uts46=True, strict=True), 'a्\u200cb')
        self.assertEqual(idna.encode('xn--ab-fsf604u', uts46=True, strict=True), b'xn--ab-fsf604u')

    def test_uts46_166(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̈\u200c̈بb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̈\u200c̈بb', strict=True)

    def test_uts46_167(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̈\u200c̈بB', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̈\u200c̈بB', strict=True)

    def test_uts46_168(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b-bcba413a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b-bcba413a', strict=True)

    def test_uts46_169(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b-bcba413a2w8b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b-bcba413a2w8b', strict=True)

    def test_uts46_170(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'aب̈\u200c̈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'aب̈\u200c̈', strict=True)

    def test_uts46_171(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Aب̈\u200c̈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Aب̈\u200c̈', strict=True)

    def test_uts46_172(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-ccba213a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-ccba213a', strict=True)

    def test_uts46_173(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-ccba213a5w8b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-ccba213a5w8b', strict=True)

    def test_uts46_174(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'aب̈\u200c̈بb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'aب̈\u200c̈بb', strict=True)

    def test_uts46_175(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Aب̈\u200c̈بB', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Aب̈\u200c̈بB', strict=True)

    def test_uts46_176(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Aب̈\u200c̈بb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Aب̈\u200c̈بb', strict=True)

    def test_uts46_177(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ab-uuba211bca', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ab-uuba211bca', strict=True)

    def test_uts46_178(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ab-uuba211bca8057b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ab-uuba211bca8057b', strict=True)

    def test_uts46_179(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a\u200db', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a\u200db', strict=True)

    def test_uts46_180(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A\u200dB', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A\u200dB', strict=True)

    def test_uts46_181(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A\u200db', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A\u200db', strict=True)

    def test_uts46_182(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ab-m1t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ab-m1t', strict=True)

    def test_uts46_183(self):
        self.assertEqual(idna.decode('a्\u200db', uts46=True, strict=True), 'a्\u200db')
        self.assertEqual(idna.encode('a्\u200db', uts46=True, strict=True), b'xn--ab-fsf014u')

    def test_uts46_184(self):
        self.assertEqual(idna.decode('A्\u200dB', uts46=True, strict=True), 'a्\u200db')
        self.assertEqual(idna.encode('A्\u200dB', uts46=True, strict=True), b'xn--ab-fsf014u')

    def test_uts46_185(self):
        self.assertEqual(idna.decode('A्\u200db', uts46=True, strict=True), 'a्\u200db')
        self.assertEqual(idna.encode('A्\u200db', uts46=True, strict=True), b'xn--ab-fsf014u')

    def test_uts46_186(self):
        self.assertEqual(idna.decode('xn--ab-fsf014u', uts46=True, strict=True), 'a्\u200db')
        self.assertEqual(idna.encode('xn--ab-fsf014u', uts46=True, strict=True), b'xn--ab-fsf014u')

    def test_uts46_187(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̈\u200d̈بb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̈\u200d̈بb', strict=True)

    def test_uts46_188(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̈\u200d̈بB', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̈\u200d̈بB', strict=True)

    def test_uts46_189(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b-bcba413a7w8b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b-bcba413a7w8b', strict=True)

    def test_uts46_190(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'aب̈\u200d̈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'aب̈\u200d̈', strict=True)

    def test_uts46_191(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Aب̈\u200d̈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Aب̈\u200d̈', strict=True)

    def test_uts46_192(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-ccba213abx8b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-ccba213abx8b', strict=True)

    def test_uts46_193(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'aب̈\u200d̈بb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'aب̈\u200d̈بb', strict=True)

    def test_uts46_194(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Aب̈\u200d̈بB', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Aب̈\u200d̈بB', strict=True)

    def test_uts46_195(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Aب̈\u200d̈بb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Aب̈\u200d̈بb', strict=True)

    def test_uts46_196(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ab-uuba211bca5157b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ab-uuba211bca5157b', strict=True)

    def test_uts46_200(self):
        self.assertRaises(idna.IDNAError, idna.decode, '¡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '¡', strict=True)

    def test_uts46_201(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7a', strict=True)

    def test_uts46_202(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᧚', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᧚', strict=True)

    def test_uts46_203(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pkf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pkf', strict=True)

    def test_uts46_204(self):
        self.assertRaises(idna.IDNAError, idna.decode, '""', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '""', strict=True)

    def test_uts46_205(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。', strict=True)

    def test_uts46_206(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.', strict=True)

    def test_uts46_207(self):
        self.assertEqual(idna.decode('ꭠ', uts46=True, strict=True), 'ꭠ')
        self.assertEqual(idna.encode('ꭠ', uts46=True, strict=True), b'xn--3y9a')

    def test_uts46_208(self):
        self.assertEqual(idna.decode('xn--3y9a', uts46=True, strict=True), 'ꭠ')
        self.assertEqual(idna.encode('xn--3y9a', uts46=True, strict=True), b'xn--3y9a')

    def test_uts46_209(self):
        self.assertEqual(idna.decode('1234567890ä1234567890123456789012345678901234567890123456', uts46=True, strict=True), '1234567890ä1234567890123456789012345678901234567890123456')
        self.assertRaises(idna.IDNAError, idna.encode, '1234567890ä1234567890123456789012345678901234567890123456', strict=True)

    def test_uts46_210(self):
        self.assertEqual(idna.decode('1234567890ä1234567890123456789012345678901234567890123456', uts46=True, strict=True), '1234567890ä1234567890123456789012345678901234567890123456')
        self.assertRaises(idna.IDNAError, idna.encode, '1234567890ä1234567890123456789012345678901234567890123456', strict=True)

    def test_uts46_211(self):
        self.assertEqual(idna.decode('1234567890Ä1234567890123456789012345678901234567890123456', uts46=True, strict=True), '1234567890ä1234567890123456789012345678901234567890123456')
        self.assertRaises(idna.IDNAError, idna.encode, '1234567890Ä1234567890123456789012345678901234567890123456', strict=True)

    def test_uts46_212(self):
        self.assertEqual(idna.decode('1234567890Ä1234567890123456789012345678901234567890123456', uts46=True, strict=True), '1234567890ä1234567890123456789012345678901234567890123456')
        self.assertRaises(idna.IDNAError, idna.encode, '1234567890Ä1234567890123456789012345678901234567890123456', strict=True)

    def test_uts46_213(self):
        self.assertEqual(idna.decode('xn--12345678901234567890123456789012345678901234567890123456-fxe', uts46=True, strict=True), '1234567890ä1234567890123456789012345678901234567890123456')
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--12345678901234567890123456789012345678901234567890123456-fxe', strict=True)

    def test_uts46_214(self):
        self.assertEqual(idna.decode('www.eXample.cOm', uts46=True, strict=True), 'www.example.com')
        self.assertEqual(idna.encode('www.eXample.cOm', uts46=True, strict=True), b'www.example.com')

    def test_uts46_215(self):
        self.assertEqual(idna.decode('Bücher.de', uts46=True, strict=True), 'bücher.de')
        self.assertEqual(idna.encode('Bücher.de', uts46=True, strict=True), b'xn--bcher-kva.de')

    def test_uts46_216(self):
        self.assertEqual(idna.decode('Bücher.de', uts46=True, strict=True), 'bücher.de')
        self.assertEqual(idna.encode('Bücher.de', uts46=True, strict=True), b'xn--bcher-kva.de')

    def test_uts46_217(self):
        self.assertEqual(idna.decode('bücher.de', uts46=True, strict=True), 'bücher.de')
        self.assertEqual(idna.encode('bücher.de', uts46=True, strict=True), b'xn--bcher-kva.de')

    def test_uts46_218(self):
        self.assertEqual(idna.decode('bücher.de', uts46=True, strict=True), 'bücher.de')
        self.assertEqual(idna.encode('bücher.de', uts46=True, strict=True), b'xn--bcher-kva.de')

    def test_uts46_219(self):
        self.assertEqual(idna.decode('BÜCHER.DE', uts46=True, strict=True), 'bücher.de')
        self.assertEqual(idna.encode('BÜCHER.DE', uts46=True, strict=True), b'xn--bcher-kva.de')

    def test_uts46_220(self):
        self.assertEqual(idna.decode('BÜCHER.DE', uts46=True, strict=True), 'bücher.de')
        self.assertEqual(idna.encode('BÜCHER.DE', uts46=True, strict=True), b'xn--bcher-kva.de')

    def test_uts46_221(self):
        self.assertEqual(idna.decode('xn--bcher-kva.de', uts46=True, strict=True), 'bücher.de')
        self.assertEqual(idna.encode('xn--bcher-kva.de', uts46=True, strict=True), b'xn--bcher-kva.de')

    def test_uts46_222(self):
        self.assertEqual(idna.decode('ÖBB', uts46=True, strict=True), 'öbb')
        self.assertEqual(idna.encode('ÖBB', uts46=True, strict=True), b'xn--bb-eka')

    def test_uts46_223(self):
        self.assertEqual(idna.decode('ÖBB', uts46=True, strict=True), 'öbb')
        self.assertEqual(idna.encode('ÖBB', uts46=True, strict=True), b'xn--bb-eka')

    def test_uts46_224(self):
        self.assertEqual(idna.decode('öbb', uts46=True, strict=True), 'öbb')
        self.assertEqual(idna.encode('öbb', uts46=True, strict=True), b'xn--bb-eka')

    def test_uts46_225(self):
        self.assertEqual(idna.decode('öbb', uts46=True, strict=True), 'öbb')
        self.assertEqual(idna.encode('öbb', uts46=True, strict=True), b'xn--bb-eka')

    def test_uts46_226(self):
        self.assertEqual(idna.decode('Öbb', uts46=True, strict=True), 'öbb')
        self.assertEqual(idna.encode('Öbb', uts46=True, strict=True), b'xn--bb-eka')

    def test_uts46_227(self):
        self.assertEqual(idna.decode('Öbb', uts46=True, strict=True), 'öbb')
        self.assertEqual(idna.encode('Öbb', uts46=True, strict=True), b'xn--bb-eka')

    def test_uts46_228(self):
        self.assertEqual(idna.decode('xn--bb-eka', uts46=True, strict=True), 'öbb')
        self.assertEqual(idna.encode('xn--bb-eka', uts46=True, strict=True), b'xn--bb-eka')

    def test_uts46_229(self):
        self.assertEqual(idna.decode('FAẞ.de', uts46=True, strict=True), 'faß.de')
        self.assertEqual(idna.encode('FAẞ.de', uts46=True, strict=True), b'xn--fa-hia.de')

    def test_uts46_230(self):
        self.assertEqual(idna.decode('FAẞ.DE', uts46=True, strict=True), 'faß.de')
        self.assertEqual(idna.encode('FAẞ.DE', uts46=True, strict=True), b'xn--fa-hia.de')

    def test_uts46_231(self):
        self.assertEqual(idna.decode('βόλος.com', uts46=True, strict=True), 'βόλος.com')
        self.assertEqual(idna.encode('βόλος.com', uts46=True, strict=True), b'xn--nxasmm1c.com')

    def test_uts46_232(self):
        self.assertEqual(idna.decode('βόλος.com', uts46=True, strict=True), 'βόλος.com')
        self.assertEqual(idna.encode('βόλος.com', uts46=True, strict=True), b'xn--nxasmm1c.com')

    def test_uts46_233(self):
        self.assertEqual(idna.decode('ΒΌΛΟΣ.COM', uts46=True, strict=True), 'βόλοσ.com')
        self.assertEqual(idna.encode('ΒΌΛΟΣ.COM', uts46=True, strict=True), b'xn--nxasmq6b.com')

    def test_uts46_234(self):
        self.assertEqual(idna.decode('ΒΌΛΟΣ.COM', uts46=True, strict=True), 'βόλοσ.com')
        self.assertEqual(idna.encode('ΒΌΛΟΣ.COM', uts46=True, strict=True), b'xn--nxasmq6b.com')

    def test_uts46_235(self):
        self.assertEqual(idna.decode('βόλοσ.com', uts46=True, strict=True), 'βόλοσ.com')
        self.assertEqual(idna.encode('βόλοσ.com', uts46=True, strict=True), b'xn--nxasmq6b.com')

    def test_uts46_236(self):
        self.assertEqual(idna.decode('βόλοσ.com', uts46=True, strict=True), 'βόλοσ.com')
        self.assertEqual(idna.encode('βόλοσ.com', uts46=True, strict=True), b'xn--nxasmq6b.com')

    def test_uts46_237(self):
        self.assertEqual(idna.decode('Βόλοσ.com', uts46=True, strict=True), 'βόλοσ.com')
        self.assertEqual(idna.encode('Βόλοσ.com', uts46=True, strict=True), b'xn--nxasmq6b.com')

    def test_uts46_238(self):
        self.assertEqual(idna.decode('Βόλοσ.com', uts46=True, strict=True), 'βόλοσ.com')
        self.assertEqual(idna.encode('Βόλοσ.com', uts46=True, strict=True), b'xn--nxasmq6b.com')

    def test_uts46_239(self):
        self.assertEqual(idna.decode('xn--nxasmq6b.com', uts46=True, strict=True), 'βόλοσ.com')
        self.assertEqual(idna.encode('xn--nxasmq6b.com', uts46=True, strict=True), b'xn--nxasmq6b.com')

    def test_uts46_240(self):
        self.assertEqual(idna.decode('Βόλος.com', uts46=True, strict=True), 'βόλος.com')
        self.assertEqual(idna.encode('Βόλος.com', uts46=True, strict=True), b'xn--nxasmm1c.com')

    def test_uts46_241(self):
        self.assertEqual(idna.decode('Βόλος.com', uts46=True, strict=True), 'βόλος.com')
        self.assertEqual(idna.encode('Βόλος.com', uts46=True, strict=True), b'xn--nxasmm1c.com')

    def test_uts46_242(self):
        self.assertEqual(idna.decode('xn--nxasmm1c.com', uts46=True, strict=True), 'βόλος.com')
        self.assertEqual(idna.encode('xn--nxasmm1c.com', uts46=True, strict=True), b'xn--nxasmm1c.com')

    def test_uts46_243(self):
        self.assertEqual(idna.decode('xn--nxasmm1c', uts46=True, strict=True), 'βόλος')
        self.assertEqual(idna.encode('xn--nxasmm1c', uts46=True, strict=True), b'xn--nxasmm1c')

    def test_uts46_244(self):
        self.assertEqual(idna.decode('βόλος', uts46=True, strict=True), 'βόλος')
        self.assertEqual(idna.encode('βόλος', uts46=True, strict=True), b'xn--nxasmm1c')

    def test_uts46_245(self):
        self.assertEqual(idna.decode('βόλος', uts46=True, strict=True), 'βόλος')
        self.assertEqual(idna.encode('βόλος', uts46=True, strict=True), b'xn--nxasmm1c')

    def test_uts46_246(self):
        self.assertEqual(idna.decode('ΒΌΛΟΣ', uts46=True, strict=True), 'βόλοσ')
        self.assertEqual(idna.encode('ΒΌΛΟΣ', uts46=True, strict=True), b'xn--nxasmq6b')

    def test_uts46_247(self):
        self.assertEqual(idna.decode('ΒΌΛΟΣ', uts46=True, strict=True), 'βόλοσ')
        self.assertEqual(idna.encode('ΒΌΛΟΣ', uts46=True, strict=True), b'xn--nxasmq6b')

    def test_uts46_248(self):
        self.assertEqual(idna.decode('βόλοσ', uts46=True, strict=True), 'βόλοσ')
        self.assertEqual(idna.encode('βόλοσ', uts46=True, strict=True), b'xn--nxasmq6b')

    def test_uts46_249(self):
        self.assertEqual(idna.decode('βόλοσ', uts46=True, strict=True), 'βόλοσ')
        self.assertEqual(idna.encode('βόλοσ', uts46=True, strict=True), b'xn--nxasmq6b')

    def test_uts46_250(self):
        self.assertEqual(idna.decode('Βόλοσ', uts46=True, strict=True), 'βόλοσ')
        self.assertEqual(idna.encode('Βόλοσ', uts46=True, strict=True), b'xn--nxasmq6b')

    def test_uts46_251(self):
        self.assertEqual(idna.decode('Βόλοσ', uts46=True, strict=True), 'βόλοσ')
        self.assertEqual(idna.encode('Βόλοσ', uts46=True, strict=True), b'xn--nxasmq6b')

    def test_uts46_252(self):
        self.assertEqual(idna.decode('xn--nxasmq6b', uts46=True, strict=True), 'βόλοσ')
        self.assertEqual(idna.encode('xn--nxasmq6b', uts46=True, strict=True), b'xn--nxasmq6b')

    def test_uts46_253(self):
        self.assertEqual(idna.decode('Βόλος', uts46=True, strict=True), 'βόλος')
        self.assertEqual(idna.encode('Βόλος', uts46=True, strict=True), b'xn--nxasmm1c')

    def test_uts46_254(self):
        self.assertEqual(idna.decode('Βόλος', uts46=True, strict=True), 'βόλος')
        self.assertEqual(idna.encode('Βόλος', uts46=True, strict=True), b'xn--nxasmm1c')

    def test_uts46_255(self):
        self.assertEqual(idna.decode('www.ශ්\u200dරී.com', uts46=True, strict=True), 'www.ශ්\u200dරී.com')
        self.assertEqual(idna.encode('www.ශ්\u200dරී.com', uts46=True, strict=True), b'www.xn--10cl1a0b660p.com')

    def test_uts46_256(self):
        self.assertEqual(idna.decode('WWW.ශ්\u200dරී.COM', uts46=True, strict=True), 'www.ශ්\u200dරී.com')
        self.assertEqual(idna.encode('WWW.ශ්\u200dරී.COM', uts46=True, strict=True), b'www.xn--10cl1a0b660p.com')

    def test_uts46_257(self):
        self.assertEqual(idna.decode('Www.ශ්\u200dරී.com', uts46=True, strict=True), 'www.ශ්\u200dරී.com')
        self.assertEqual(idna.encode('Www.ශ්\u200dරී.com', uts46=True, strict=True), b'www.xn--10cl1a0b660p.com')

    def test_uts46_258(self):
        self.assertEqual(idna.decode('www.xn--10cl1a0b.com', uts46=True, strict=True), 'www.ශ්රී.com')
        self.assertEqual(idna.encode('www.xn--10cl1a0b.com', uts46=True, strict=True), b'www.xn--10cl1a0b.com')

    def test_uts46_259(self):
        self.assertEqual(idna.decode('www.ශ්රී.com', uts46=True, strict=True), 'www.ශ්රී.com')
        self.assertEqual(idna.encode('www.ශ්රී.com', uts46=True, strict=True), b'www.xn--10cl1a0b.com')

    def test_uts46_260(self):
        self.assertEqual(idna.decode('WWW.ශ්රී.COM', uts46=True, strict=True), 'www.ශ්රී.com')
        self.assertEqual(idna.encode('WWW.ශ්රී.COM', uts46=True, strict=True), b'www.xn--10cl1a0b.com')

    def test_uts46_261(self):
        self.assertEqual(idna.decode('Www.ශ්රී.com', uts46=True, strict=True), 'www.ශ්රී.com')
        self.assertEqual(idna.encode('Www.ශ්රී.com', uts46=True, strict=True), b'www.xn--10cl1a0b.com')

    def test_uts46_262(self):
        self.assertEqual(idna.decode('www.xn--10cl1a0b660p.com', uts46=True, strict=True), 'www.ශ්\u200dරී.com')
        self.assertEqual(idna.encode('www.xn--10cl1a0b660p.com', uts46=True, strict=True), b'www.xn--10cl1a0b660p.com')

    def test_uts46_263(self):
        self.assertEqual(idna.decode('نامه\u200cای', uts46=True, strict=True), 'نامه\u200cای')
        self.assertEqual(idna.encode('نامه\u200cای', uts46=True, strict=True), b'xn--mgba3gch31f060k')

    def test_uts46_264(self):
        self.assertEqual(idna.decode('xn--mgba3gch31f', uts46=True, strict=True), 'نامهای')
        self.assertEqual(idna.encode('xn--mgba3gch31f', uts46=True, strict=True), b'xn--mgba3gch31f')

    def test_uts46_265(self):
        self.assertEqual(idna.decode('نامهای', uts46=True, strict=True), 'نامهای')
        self.assertEqual(idna.encode('نامهای', uts46=True, strict=True), b'xn--mgba3gch31f')

    def test_uts46_266(self):
        self.assertEqual(idna.decode('xn--mgba3gch31f060k', uts46=True, strict=True), 'نامه\u200cای')
        self.assertEqual(idna.encode('xn--mgba3gch31f060k', uts46=True, strict=True), b'xn--mgba3gch31f060k')

    def test_uts46_267(self):
        self.assertEqual(idna.decode('xn--mgba3gch31f060k.com', uts46=True, strict=True), 'نامه\u200cای.com')
        self.assertEqual(idna.encode('xn--mgba3gch31f060k.com', uts46=True, strict=True), b'xn--mgba3gch31f060k.com')

    def test_uts46_268(self):
        self.assertEqual(idna.decode('نامه\u200cای.com', uts46=True, strict=True), 'نامه\u200cای.com')
        self.assertEqual(idna.encode('نامه\u200cای.com', uts46=True, strict=True), b'xn--mgba3gch31f060k.com')

    def test_uts46_269(self):
        self.assertEqual(idna.decode('نامه\u200cای.COM', uts46=True, strict=True), 'نامه\u200cای.com')
        self.assertEqual(idna.encode('نامه\u200cای.COM', uts46=True, strict=True), b'xn--mgba3gch31f060k.com')

    def test_uts46_270(self):
        self.assertEqual(idna.decode('xn--mgba3gch31f.com', uts46=True, strict=True), 'نامهای.com')
        self.assertEqual(idna.encode('xn--mgba3gch31f.com', uts46=True, strict=True), b'xn--mgba3gch31f.com')

    def test_uts46_271(self):
        self.assertEqual(idna.decode('نامهای.com', uts46=True, strict=True), 'نامهای.com')
        self.assertEqual(idna.encode('نامهای.com', uts46=True, strict=True), b'xn--mgba3gch31f.com')

    def test_uts46_272(self):
        self.assertEqual(idna.decode('نامهای.COM', uts46=True, strict=True), 'نامهای.com')
        self.assertEqual(idna.encode('نامهای.COM', uts46=True, strict=True), b'xn--mgba3gch31f.com')

    def test_uts46_273(self):
        self.assertEqual(idna.decode('a.b．c。d｡', uts46=True, strict=True), 'a.b.c.d.')
        self.assertRaises(idna.IDNAError, idna.encode, 'a.b．c。d｡', strict=True)

    def test_uts46_274(self):
        self.assertEqual(idna.decode('a.b.c。d。', uts46=True, strict=True), 'a.b.c.d.')
        self.assertRaises(idna.IDNAError, idna.encode, 'a.b.c。d。', strict=True)

    def test_uts46_275(self):
        self.assertEqual(idna.decode('A.B.C。D。', uts46=True, strict=True), 'a.b.c.d.')
        self.assertRaises(idna.IDNAError, idna.encode, 'A.B.C。D。', strict=True)

    def test_uts46_276(self):
        self.assertEqual(idna.decode('A.b.c。D。', uts46=True, strict=True), 'a.b.c.d.')
        self.assertRaises(idna.IDNAError, idna.encode, 'A.b.c。D。', strict=True)

    def test_uts46_278(self):
        self.assertEqual(idna.decode('A.B．C。D｡', uts46=True, strict=True), 'a.b.c.d.')
        self.assertRaises(idna.IDNAError, idna.encode, 'A.B．C。D｡', strict=True)

    def test_uts46_279(self):
        self.assertEqual(idna.decode('A.b．c。D｡', uts46=True, strict=True), 'a.b.c.d.')
        self.assertRaises(idna.IDNAError, idna.encode, 'A.b．c。D｡', strict=True)

    def test_uts46_280(self):
        self.assertEqual(idna.decode('Ü.xn--tda', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.xn--tda', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_281(self):
        self.assertEqual(idna.decode('Ü.xn--tda', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.xn--tda', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_282(self):
        self.assertEqual(idna.decode('ü.xn--tda', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('ü.xn--tda', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_283(self):
        self.assertEqual(idna.decode('ü.xn--tda', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('ü.xn--tda', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_284(self):
        self.assertEqual(idna.decode('Ü.XN--TDA', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.XN--TDA', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_285(self):
        self.assertEqual(idna.decode('Ü.XN--TDA', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.XN--TDA', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_286(self):
        self.assertEqual(idna.decode('Ü.xn--Tda', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.xn--Tda', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_287(self):
        self.assertEqual(idna.decode('Ü.xn--Tda', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.xn--Tda', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_288(self):
        self.assertEqual(idna.decode('xn--tda.xn--tda', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('xn--tda.xn--tda', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_289(self):
        self.assertEqual(idna.decode('ü.ü', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('ü.ü', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_290(self):
        self.assertEqual(idna.decode('ü.ü', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('ü.ü', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_291(self):
        self.assertEqual(idna.decode('Ü.Ü', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.Ü', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_292(self):
        self.assertEqual(idna.decode('Ü.Ü', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.Ü', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_293(self):
        self.assertEqual(idna.decode('Ü.ü', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.ü', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_294(self):
        self.assertEqual(idna.decode('Ü.ü', uts46=True, strict=True), 'ü.ü')
        self.assertEqual(idna.encode('Ü.ü', uts46=True, strict=True), b'xn--tda.xn--tda')

    def test_uts46_295(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u-ccb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u-ccb', strict=True)

    def test_uts46_296(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a⒈com', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a⒈com', strict=True)

    def test_uts46_297(self):
        self.assertEqual(idna.decode('a1.com', uts46=True, strict=True), 'a1.com')
        self.assertEqual(idna.encode('a1.com', uts46=True, strict=True), b'a1.com')

    def test_uts46_298(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A⒈COM', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A⒈COM', strict=True)

    def test_uts46_299(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A⒈Com', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A⒈Com', strict=True)

    def test_uts46_300(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--acom-0w1b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--acom-0w1b', strict=True)

    def test_uts46_301(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-ecp.ru', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-ecp.ru', strict=True)

    def test_uts46_302(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0.pt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0.pt', strict=True)

    def test_uts46_303(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a.pt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a.pt', strict=True)

    def test_uts46_304(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-Ä.pt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-Ä.pt', strict=True)

    def test_uts46_305(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-Ä.pt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-Ä.pt', strict=True)

    def test_uts46_306(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-ä.pt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-ä.pt', strict=True)

    def test_uts46_307(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-ä.pt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-ä.pt', strict=True)

    def test_uts46_308(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'XN--A-Ä.PT', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'XN--A-Ä.PT', strict=True)

    def test_uts46_309(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'XN--A-Ä.PT', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'XN--A-Ä.PT', strict=True)

    def test_uts46_310(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--A-Ä.pt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--A-Ä.pt', strict=True)

    def test_uts46_311(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--A-Ä.pt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--A-Ä.pt', strict=True)

    def test_uts46_312(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xn--a--gua.pt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xn--a--gua.pt', strict=True)

    def test_uts46_313(self):
        self.assertEqual(idna.decode('日本語。ＪＰ', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('日本語。ＪＰ', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_314(self):
        self.assertEqual(idna.decode('日本語。JP', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('日本語。JP', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_315(self):
        self.assertEqual(idna.decode('日本語。jp', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('日本語。jp', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_316(self):
        self.assertEqual(idna.decode('日本語。Jp', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('日本語。Jp', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_317(self):
        self.assertEqual(idna.decode('xn--wgv71a119e.jp', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('xn--wgv71a119e.jp', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_318(self):
        self.assertEqual(idna.decode('日本語.jp', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('日本語.jp', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_319(self):
        self.assertEqual(idna.decode('日本語.JP', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('日本語.JP', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_320(self):
        self.assertEqual(idna.decode('日本語.Jp', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('日本語.Jp', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_321(self):
        self.assertEqual(idna.decode('日本語。ｊｐ', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('日本語。ｊｐ', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_322(self):
        self.assertEqual(idna.decode('日本語。Ｊｐ', uts46=True, strict=True), '日本語.jp')
        self.assertEqual(idna.encode('日本語。Ｊｐ', uts46=True, strict=True), b'xn--wgv71a119e.jp')

    def test_uts46_323(self):
        self.assertRaises(idna.IDNAError, idna.decode, '☕', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '☕', strict=True)

    def test_uts46_324(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--53h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--53h', strict=True)

    def test_uts46_325(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.aß\u200c\u200db\u200c\u200dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß̂ßz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.aß\u200c\u200db\u200c\u200dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß̂ßz', strict=True)

    def test_uts46_326(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.ASS\u200c\u200dB\u200c\u200dCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.ASS\u200c\u200dB\u200c\u200dCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ', strict=True)

    def test_uts46_327(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.ASS\u200c\u200dB\u200c\u200dCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.ASS\u200c\u200dB\u200c\u200dCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ', strict=True)

    def test_uts46_328(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.ass\u200c\u200db\u200c\u200dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.ass\u200c\u200db\u200c\u200dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)

    def test_uts46_329(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.ass\u200c\u200db\u200c\u200dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.ass\u200c\u200db\u200c\u200dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)

    def test_uts46_330(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.Ass\u200c\u200db\u200c\u200dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.Ass\u200c\u200db\u200c\u200dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)

    def test_uts46_331(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.Ass\u200c\u200db\u200c\u200dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.Ass\u200c\u200db\u200c\u200dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)

    def test_uts46_332(self):
        self.assertEqual(idna.decode('1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa', uts46=True, strict=True), '1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz')
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa', strict=True)

    def test_uts46_333(self):
        self.assertEqual(idna.decode('1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', uts46=True, strict=True), '1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz')
        self.assertRaises(idna.IDNAError, idna.encode, '1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)

    def test_uts46_334(self):
        self.assertEqual(idna.decode('1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', uts46=True, strict=True), '1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz')
        self.assertRaises(idna.IDNAError, idna.encode, '1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)

    def test_uts46_335(self):
        self.assertEqual(idna.decode('1.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ', uts46=True, strict=True), '1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz')
        self.assertRaises(idna.IDNAError, idna.encode, '1.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ', strict=True)

    def test_uts46_336(self):
        self.assertEqual(idna.decode('1.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ', uts46=True, strict=True), '1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz')
        self.assertRaises(idna.IDNAError, idna.encode, '1.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ', strict=True)

    def test_uts46_337(self):
        self.assertEqual(idna.decode('1.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', uts46=True, strict=True), '1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz')
        self.assertRaises(idna.IDNAError, idna.encode, '1.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)

    def test_uts46_338(self):
        self.assertEqual(idna.decode('1.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', uts46=True, strict=True), '1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz')
        self.assertRaises(idna.IDNAError, idna.encode, '1.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz', strict=True)

    def test_uts46_339(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc', strict=True)

    def test_uts46_340(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.Aß\u200c\u200db\u200c\u200dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß̂ßz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.Aß\u200c\u200db\u200c\u200dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß̂ßz', strict=True)

    def test_uts46_341(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--abcdexyz-qyacaaabaaaaaaabaaaaaaaaabaaaaaaaaabaaaaaaaa010ze2isb1140zba8cc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--abcdexyz-qyacaaabaaaaaaabaaaaaaaaabaaaaaaaaabaaaaaaaa010ze2isb1140zba8cc', strict=True)

    def test_uts46_342(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cx\u200dn\u200c-\u200d-bß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cx\u200dn\u200c-\u200d-bß', strict=True)

    def test_uts46_343(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cX\u200dN\u200c-\u200d-BSS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cX\u200dN\u200c-\u200d-BSS', strict=True)

    def test_uts46_344(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cx\u200dn\u200c-\u200d-bss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cx\u200dn\u200c-\u200d-bss', strict=True)

    def test_uts46_345(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cX\u200dn\u200c-\u200d-Bss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cX\u200dn\u200c-\u200d-Bss', strict=True)

    def test_uts46_346(self):
        self.assertEqual(idna.decode('xn--bss', uts46=True, strict=True), '夙')
        self.assertEqual(idna.encode('xn--bss', uts46=True, strict=True), b'xn--bss')

    def test_uts46_347(self):
        self.assertEqual(idna.decode('夙', uts46=True, strict=True), '夙')
        self.assertEqual(idna.encode('夙', uts46=True, strict=True), b'xn--bss')

    def test_uts46_348(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xn--bss-7z6ccid', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xn--bss-7z6ccid', strict=True)

    def test_uts46_349(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cX\u200dn\u200c-\u200d-Bß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cX\u200dn\u200c-\u200d-Bß', strict=True)

    def test_uts46_350(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xn--b-pqa5796ccahd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xn--b-pqa5796ccahd', strict=True)

    def test_uts46_351(self):
        self.assertEqual(idna.decode('ˣ͏ℕ\u200b﹣\xad－᠌ℬ︀ſ\u2064𝔰󠇯ﬄ', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('ˣ͏ℕ\u200b﹣\xad－᠌ℬ︀ſ\u2064𝔰󠇯ﬄ', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_352(self):
        self.assertEqual(idna.decode('x͏N\u200b-\xad-᠌B︀s\u2064s󠇯ffl', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('x͏N\u200b-\xad-᠌B︀s\u2064s󠇯ffl', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_353(self):
        self.assertEqual(idna.decode('x͏n\u200b-\xad-᠌b︀s\u2064s󠇯ffl', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('x͏n\u200b-\xad-᠌b︀s\u2064s󠇯ffl', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_354(self):
        self.assertEqual(idna.decode('X͏N\u200b-\xad-᠌B︀S\u2064S󠇯FFL', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('X͏N\u200b-\xad-᠌B︀S\u2064S󠇯FFL', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_355(self):
        self.assertEqual(idna.decode('X͏n\u200b-\xad-᠌B︀s\u2064s󠇯ffl', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('X͏n\u200b-\xad-᠌B︀s\u2064s󠇯ffl', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_356(self):
        self.assertEqual(idna.decode('xn--bssffl', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('xn--bssffl', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_357(self):
        self.assertEqual(idna.decode('夡夞夜夙', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('夡夞夜夙', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_358(self):
        self.assertEqual(idna.decode('ˣ͏ℕ\u200b﹣\xad－᠌ℬ︀S\u2064𝔰󠇯FFL', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('ˣ͏ℕ\u200b﹣\xad－᠌ℬ︀S\u2064𝔰󠇯FFL', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_359(self):
        self.assertEqual(idna.decode('x͏N\u200b-\xad-᠌B︀S\u2064s󠇯FFL', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('x͏N\u200b-\xad-᠌B︀S\u2064s󠇯FFL', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_360(self):
        self.assertEqual(idna.decode('ˣ͏ℕ\u200b﹣\xad－᠌ℬ︀s\u2064𝔰󠇯ffl', uts46=True, strict=True), '夡夞夜夙')
        self.assertEqual(idna.encode('ˣ͏ℕ\u200b﹣\xad－᠌ℬ︀s\u2064𝔰󠇯ffl', uts46=True, strict=True), b'xn--bssffl')

    def test_uts46_361(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertEqual(idna.encode('123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), b'123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')

    def test_uts46_363(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', strict=True)

    def test_uts46_364(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', strict=True)

    def test_uts46_365(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', strict=True)

    def test_uts46_366(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', strict=True)

    def test_uts46_367(self):
        self.assertEqual(idna.decode('ä1234567890123456789012345678901234567890123456789012345', uts46=True, strict=True), 'ä1234567890123456789012345678901234567890123456789012345')
        self.assertEqual(idna.encode('ä1234567890123456789012345678901234567890123456789012345', uts46=True, strict=True), b'xn--1234567890123456789012345678901234567890123456789012345-9te')

    def test_uts46_368(self):
        self.assertEqual(idna.decode('ä1234567890123456789012345678901234567890123456789012345', uts46=True, strict=True), 'ä1234567890123456789012345678901234567890123456789012345')
        self.assertEqual(idna.encode('ä1234567890123456789012345678901234567890123456789012345', uts46=True, strict=True), b'xn--1234567890123456789012345678901234567890123456789012345-9te')

    def test_uts46_369(self):
        self.assertEqual(idna.decode('Ä1234567890123456789012345678901234567890123456789012345', uts46=True, strict=True), 'ä1234567890123456789012345678901234567890123456789012345')
        self.assertEqual(idna.encode('Ä1234567890123456789012345678901234567890123456789012345', uts46=True, strict=True), b'xn--1234567890123456789012345678901234567890123456789012345-9te')

    def test_uts46_370(self):
        self.assertEqual(idna.decode('Ä1234567890123456789012345678901234567890123456789012345', uts46=True, strict=True), 'ä1234567890123456789012345678901234567890123456789012345')
        self.assertEqual(idna.encode('Ä1234567890123456789012345678901234567890123456789012345', uts46=True, strict=True), b'xn--1234567890123456789012345678901234567890123456789012345-9te')

    def test_uts46_371(self):
        self.assertEqual(idna.decode('xn--1234567890123456789012345678901234567890123456789012345-9te', uts46=True, strict=True), 'ä1234567890123456789012345678901234567890123456789012345')
        self.assertEqual(idna.encode('xn--1234567890123456789012345678901234567890123456789012345-9te', uts46=True, strict=True), b'xn--1234567890123456789012345678901234567890123456789012345-9te')

    def test_uts46_372(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertEqual(idna.encode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), b'123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')

    def test_uts46_373(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertEqual(idna.encode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), b'123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')

    def test_uts46_374(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertEqual(idna.encode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B', uts46=True, strict=True), b'123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')

    def test_uts46_375(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertEqual(idna.encode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B', uts46=True, strict=True), b'123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')

    def test_uts46_376(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertEqual(idna.encode('123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), b'123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')

    def test_uts46_378(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.', strict=True)

    def test_uts46_379(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B.', strict=True)

    def test_uts46_380(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B.', strict=True)

    def test_uts46_382(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', strict=True)

    def test_uts46_383(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', strict=True)

    def test_uts46_384(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901C', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901C', strict=True)

    def test_uts46_385(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901C', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901C', strict=True)

    def test_uts46_386(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', strict=True)

    def test_uts46_387(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', strict=True)

    def test_uts46_388(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', strict=True)

    def test_uts46_389(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789A', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789A', strict=True)

    def test_uts46_390(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789A', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789A', strict=True)

    def test_uts46_391(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', strict=True)

    def test_uts46_392(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', strict=True)

    def test_uts46_393(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', strict=True)

    def test_uts46_394(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789A.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789A.', strict=True)

    def test_uts46_395(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789A.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789A.', strict=True)

    def test_uts46_396(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', strict=True)

    def test_uts46_397(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', strict=True)

    def test_uts46_398(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', strict=True)

    def test_uts46_399(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B', strict=True)

    def test_uts46_400(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890B', strict=True)

    def test_uts46_401(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', strict=True)

    def test_uts46_402(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.b..-q--a-.e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.b..-q--a-.e', strict=True)

    def test_uts46_403(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.b..-q--ä-.e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.b..-q--ä-.e', strict=True)

    def test_uts46_404(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.b..-q--ä-.e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.b..-q--ä-.e', strict=True)

    def test_uts46_405(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A.B..-Q--Ä-.E', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A.B..-Q--Ä-.E', strict=True)

    def test_uts46_406(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A.B..-Q--Ä-.E', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A.B..-Q--Ä-.E', strict=True)

    def test_uts46_407(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A.b..-Q--Ä-.E', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A.b..-Q--Ä-.E', strict=True)

    def test_uts46_408(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A.b..-Q--Ä-.E', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A.b..-Q--Ä-.E', strict=True)

    def test_uts46_409(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.b..xn---q----jra.e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.b..xn---q----jra.e', strict=True)

    def test_uts46_410(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a..c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a..c', strict=True)

    def test_uts46_411(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.-b.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.-b.', strict=True)

    def test_uts46_412(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.b-.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.b-.c', strict=True)

    def test_uts46_413(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.-.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.-.c', strict=True)

    def test_uts46_414(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.bc--de.f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.bc--de.f', strict=True)

    def test_uts46_415(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xn---epa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xn---epa', strict=True)

    def test_uts46_416(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.\xad.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.\xad.c', strict=True)

    def test_uts46_417(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.\xad.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.\xad.c', strict=True)

    def test_uts46_418(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.\xad.C', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.\xad.C', strict=True)

    def test_uts46_419(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.\xad.C', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.\xad.C', strict=True)

    def test_uts46_420(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4ca..c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4ca..c', strict=True)

    def test_uts46_421(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.-b.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.-b.', strict=True)

    def test_uts46_422(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.-b.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.-b.', strict=True)

    def test_uts46_423(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.-B.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.-B.', strict=True)

    def test_uts46_424(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.-B.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.-B.', strict=True)

    def test_uts46_425(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4ca.-b.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4ca.-b.', strict=True)

    def test_uts46_426(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.b-.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.b-.c', strict=True)

    def test_uts46_427(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.b-.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.b-.c', strict=True)

    def test_uts46_428(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.B-.C', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.B-.C', strict=True)

    def test_uts46_429(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.B-.C', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.B-.C', strict=True)

    def test_uts46_430(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.b-.C', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.b-.C', strict=True)

    def test_uts46_431(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.b-.C', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.b-.C', strict=True)

    def test_uts46_432(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4ca.b-.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4ca.b-.c', strict=True)

    def test_uts46_433(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.-.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.-.c', strict=True)

    def test_uts46_434(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.-.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.-.c', strict=True)

    def test_uts46_435(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.-.C', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.-.C', strict=True)

    def test_uts46_436(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.-.C', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.-.C', strict=True)

    def test_uts46_437(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4ca.-.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4ca.-.c', strict=True)

    def test_uts46_438(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.bc--de.f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.bc--de.f', strict=True)

    def test_uts46_439(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ä.bc--de.f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ä.bc--de.f', strict=True)

    def test_uts46_440(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.BC--DE.F', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.BC--DE.F', strict=True)

    def test_uts46_441(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.BC--DE.F', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.BC--DE.F', strict=True)

    def test_uts46_442(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.bc--De.f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.bc--De.f', strict=True)

    def test_uts46_443(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ä.bc--De.f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ä.bc--De.f', strict=True)

    def test_uts46_444(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4ca.bc--de.f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4ca.bc--de.f', strict=True)

    def test_uts46_445(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.b.̈c.d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.b.̈c.d', strict=True)

    def test_uts46_446(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A.B.̈C.D', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A.B.̈C.D', strict=True)

    def test_uts46_447(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A.b.̈c.d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A.b.̈c.d', strict=True)

    def test_uts46_448(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a.b.xn--c-bcb.d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a.b.xn--c-bcb.d', strict=True)

    def test_uts46_449(self):
        self.assertEqual(idna.decode('A0', uts46=True, strict=True), 'a0')
        self.assertEqual(idna.encode('A0', uts46=True, strict=True), b'a0')

    def test_uts46_450(self):
        self.assertEqual(idna.decode('0A', uts46=True, strict=True), '0a')
        self.assertEqual(idna.encode('0A', uts46=True, strict=True), b'0a')

    def test_uts46_455(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'b-.א', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'b-.א', strict=True)

    def test_uts46_456(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'B-.א', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'B-.א', strict=True)

    def test_uts46_457(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'b-.xn--4db', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'b-.xn--4db', strict=True)

    def test_uts46_458(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'd.xn----dha.xn--4db', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'd.xn----dha.xn--4db', strict=True)

    def test_uts46_459(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'aא', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'aא', strict=True)

    def test_uts46_460(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Aא', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Aא', strict=True)

    def test_uts46_461(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-0hc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-0hc', strict=True)

    def test_uts46_462(self):
        self.assertEqual(idna.decode('אׇ', uts46=True, strict=True), 'אׇ')
        self.assertEqual(idna.encode('אׇ', uts46=True, strict=True), b'xn--vdbr')

    def test_uts46_463(self):
        self.assertEqual(idna.decode('xn--vdbr', uts46=True, strict=True), 'אׇ')
        self.assertEqual(idna.encode('xn--vdbr', uts46=True, strict=True), b'xn--vdbr')

    def test_uts46_464(self):
        self.assertEqual(idna.decode('א9ׇ', uts46=True, strict=True), 'א9ׇ')
        self.assertEqual(idna.encode('א9ׇ', uts46=True, strict=True), b'xn--9-ihcz')

    def test_uts46_465(self):
        self.assertEqual(idna.decode('xn--9-ihcz', uts46=True, strict=True), 'א9ׇ')
        self.assertEqual(idna.encode('xn--9-ihcz', uts46=True, strict=True), b'xn--9-ihcz')

    def test_uts46_466(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'אaׇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'אaׇ', strict=True)

    def test_uts46_467(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'אAׇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'אAׇ', strict=True)

    def test_uts46_468(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a-ihcz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a-ihcz', strict=True)

    def test_uts46_469(self):
        self.assertEqual(idna.decode('את', uts46=True, strict=True), 'את')
        self.assertEqual(idna.encode('את', uts46=True, strict=True), b'xn--4db6c')

    def test_uts46_470(self):
        self.assertEqual(idna.decode('xn--4db6c', uts46=True, strict=True), 'את')
        self.assertEqual(idna.encode('xn--4db6c', uts46=True, strict=True), b'xn--4db6c')

    def test_uts46_471(self):
        self.assertEqual(idna.decode('א׳ת', uts46=True, strict=True), 'א׳ת')
        self.assertEqual(idna.encode('א׳ת', uts46=True, strict=True), b'xn--4db6c0a')

    def test_uts46_472(self):
        self.assertEqual(idna.decode('xn--4db6c0a', uts46=True, strict=True), 'א׳ת')
        self.assertEqual(idna.encode('xn--4db6c0a', uts46=True, strict=True), b'xn--4db6c0a')

    def test_uts46_473(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'aאTz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'aאTz', strict=True)

    def test_uts46_474(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'aאtz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'aאtz', strict=True)

    def test_uts46_475(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'AאTZ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'AאTZ', strict=True)

    def test_uts46_476(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Aאtz', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Aאtz', strict=True)

    def test_uts46_477(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--atz-qpe', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--atz-qpe', strict=True)

    def test_uts46_478(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'אTת', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'אTת', strict=True)

    def test_uts46_479(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'אtת', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'אtת', strict=True)

    def test_uts46_480(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--t-zhc3f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--t-zhc3f', strict=True)

    def test_uts46_481(self):
        self.assertEqual(idna.decode('א7ת', uts46=True, strict=True), 'א7ת')
        self.assertEqual(idna.encode('א7ת', uts46=True, strict=True), b'xn--7-zhc3f')

    def test_uts46_482(self):
        self.assertEqual(idna.decode('xn--7-zhc3f', uts46=True, strict=True), 'א7ת')
        self.assertEqual(idna.encode('xn--7-zhc3f', uts46=True, strict=True), b'xn--7-zhc3f')

    def test_uts46_483(self):
        self.assertEqual(idna.decode('א٧ת', uts46=True, strict=True), 'א٧ת')
        self.assertEqual(idna.encode('א٧ת', uts46=True, strict=True), b'xn--4db6c6t')

    def test_uts46_484(self):
        self.assertEqual(idna.decode('xn--4db6c6t', uts46=True, strict=True), 'א٧ת')
        self.assertEqual(idna.encode('xn--4db6c6t', uts46=True, strict=True), b'xn--4db6c6t')

    def test_uts46_485(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a7٧z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a7٧z', strict=True)

    def test_uts46_486(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A7٧Z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A7٧Z', strict=True)

    def test_uts46_487(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A7٧z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A7٧z', strict=True)

    def test_uts46_488(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--a7z-06e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--a7z-06e', strict=True)

    def test_uts46_489(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'א7٧ת', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'א7٧ת', strict=True)

    def test_uts46_490(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7-zhc3fty', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7-zhc3fty', strict=True)

    def test_uts46_491(self):
        self.assertEqual(idna.decode('ஹ்\u200d', uts46=True, strict=True), 'ஹ்\u200d')
        self.assertEqual(idna.encode('ஹ்\u200d', uts46=True, strict=True), b'xn--dmc4b194h')

    def test_uts46_492(self):
        self.assertEqual(idna.decode('xn--dmc4b', uts46=True, strict=True), 'ஹ்')
        self.assertEqual(idna.encode('xn--dmc4b', uts46=True, strict=True), b'xn--dmc4b')

    def test_uts46_493(self):
        self.assertEqual(idna.decode('ஹ்', uts46=True, strict=True), 'ஹ்')
        self.assertEqual(idna.encode('ஹ்', uts46=True, strict=True), b'xn--dmc4b')

    def test_uts46_494(self):
        self.assertEqual(idna.decode('xn--dmc4b194h', uts46=True, strict=True), 'ஹ்\u200d')
        self.assertEqual(idna.encode('xn--dmc4b194h', uts46=True, strict=True), b'xn--dmc4b194h')

    def test_uts46_495(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ஹ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ஹ\u200d', strict=True)

    def test_uts46_496(self):
        self.assertEqual(idna.decode('xn--dmc', uts46=True, strict=True), 'ஹ')
        self.assertEqual(idna.encode('xn--dmc', uts46=True, strict=True), b'xn--dmc')

    def test_uts46_497(self):
        self.assertEqual(idna.decode('ஹ', uts46=True, strict=True), 'ஹ')
        self.assertEqual(idna.encode('ஹ', uts46=True, strict=True), b'xn--dmc')

    def test_uts46_498(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dmc225h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dmc225h', strict=True)

    def test_uts46_499(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d', strict=True)

    def test_uts46_500(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug', strict=True)

    def test_uts46_501(self):
        self.assertEqual(idna.decode('ஹ்\u200c', uts46=True, strict=True), 'ஹ்\u200c')
        self.assertEqual(idna.encode('ஹ்\u200c', uts46=True, strict=True), b'xn--dmc4by94h')

    def test_uts46_502(self):
        self.assertEqual(idna.decode('xn--dmc4by94h', uts46=True, strict=True), 'ஹ்\u200c')
        self.assertEqual(idna.encode('xn--dmc4by94h', uts46=True, strict=True), b'xn--dmc4by94h')

    def test_uts46_503(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ஹ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ஹ\u200c', strict=True)

    def test_uts46_504(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dmc025h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dmc025h', strict=True)

    def test_uts46_505(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c', strict=True)

    def test_uts46_506(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug', strict=True)

    def test_uts46_507(self):
        self.assertEqual(idna.decode('لٰ\u200cۭۯ', uts46=True, strict=True), 'لٰ\u200cۭۯ')
        self.assertEqual(idna.encode('لٰ\u200cۭۯ', uts46=True, strict=True), b'xn--ghb2gxqia7523a')

    def test_uts46_508(self):
        self.assertEqual(idna.decode('xn--ghb2gxqia', uts46=True, strict=True), 'لٰۭۯ')
        self.assertEqual(idna.encode('xn--ghb2gxqia', uts46=True, strict=True), b'xn--ghb2gxqia')

    def test_uts46_509(self):
        self.assertEqual(idna.decode('لٰۭۯ', uts46=True, strict=True), 'لٰۭۯ')
        self.assertEqual(idna.encode('لٰۭۯ', uts46=True, strict=True), b'xn--ghb2gxqia')

    def test_uts46_510(self):
        self.assertEqual(idna.decode('xn--ghb2gxqia7523a', uts46=True, strict=True), 'لٰ\u200cۭۯ')
        self.assertEqual(idna.encode('xn--ghb2gxqia7523a', uts46=True, strict=True), b'xn--ghb2gxqia7523a')

    def test_uts46_511(self):
        self.assertEqual(idna.decode('لٰ\u200cۯ', uts46=True, strict=True), 'لٰ\u200cۯ')
        self.assertEqual(idna.encode('لٰ\u200cۯ', uts46=True, strict=True), b'xn--ghb2g3qq34f')

    def test_uts46_512(self):
        self.assertEqual(idna.decode('xn--ghb2g3q', uts46=True, strict=True), 'لٰۯ')
        self.assertEqual(idna.encode('xn--ghb2g3q', uts46=True, strict=True), b'xn--ghb2g3q')

    def test_uts46_513(self):
        self.assertEqual(idna.decode('لٰۯ', uts46=True, strict=True), 'لٰۯ')
        self.assertEqual(idna.encode('لٰۯ', uts46=True, strict=True), b'xn--ghb2g3q')

    def test_uts46_514(self):
        self.assertEqual(idna.decode('xn--ghb2g3qq34f', uts46=True, strict=True), 'لٰ\u200cۯ')
        self.assertEqual(idna.encode('xn--ghb2g3qq34f', uts46=True, strict=True), b'xn--ghb2g3qq34f')

    def test_uts46_515(self):
        self.assertEqual(idna.decode('ل\u200cۭۯ', uts46=True, strict=True), 'ل\u200cۭۯ')
        self.assertEqual(idna.encode('ل\u200cۭۯ', uts46=True, strict=True), b'xn--ghb25aga828w')

    def test_uts46_516(self):
        self.assertEqual(idna.decode('xn--ghb25aga', uts46=True, strict=True), 'لۭۯ')
        self.assertEqual(idna.encode('xn--ghb25aga', uts46=True, strict=True), b'xn--ghb25aga')

    def test_uts46_517(self):
        self.assertEqual(idna.decode('لۭۯ', uts46=True, strict=True), 'لۭۯ')
        self.assertEqual(idna.encode('لۭۯ', uts46=True, strict=True), b'xn--ghb25aga')

    def test_uts46_518(self):
        self.assertEqual(idna.decode('xn--ghb25aga828w', uts46=True, strict=True), 'ل\u200cۭۯ')
        self.assertEqual(idna.encode('xn--ghb25aga828w', uts46=True, strict=True), b'xn--ghb25aga828w')

    def test_uts46_519(self):
        self.assertEqual(idna.decode('ل\u200cۯ', uts46=True, strict=True), 'ل\u200cۯ')
        self.assertEqual(idna.encode('ل\u200cۯ', uts46=True, strict=True), b'xn--ghb65a953d')

    def test_uts46_520(self):
        self.assertEqual(idna.decode('xn--ghb65a', uts46=True, strict=True), 'لۯ')
        self.assertEqual(idna.encode('xn--ghb65a', uts46=True, strict=True), b'xn--ghb65a')

    def test_uts46_521(self):
        self.assertEqual(idna.decode('لۯ', uts46=True, strict=True), 'لۯ')
        self.assertEqual(idna.encode('لۯ', uts46=True, strict=True), b'xn--ghb65a')

    def test_uts46_522(self):
        self.assertEqual(idna.decode('xn--ghb65a953d', uts46=True, strict=True), 'ل\u200cۯ')
        self.assertEqual(idna.encode('xn--ghb65a953d', uts46=True, strict=True), b'xn--ghb65a953d')

    def test_uts46_523(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لٰ\u200cۭ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لٰ\u200cۭ', strict=True)

    def test_uts46_524(self):
        self.assertEqual(idna.decode('xn--ghb2gxq', uts46=True, strict=True), 'لٰۭ')
        self.assertEqual(idna.encode('xn--ghb2gxq', uts46=True, strict=True), b'xn--ghb2gxq')

    def test_uts46_525(self):
        self.assertEqual(idna.decode('لٰۭ', uts46=True, strict=True), 'لٰۭ')
        self.assertEqual(idna.encode('لٰۭ', uts46=True, strict=True), b'xn--ghb2gxq')

    def test_uts46_526(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ghb2gxqy34f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ghb2gxqy34f', strict=True)

    def test_uts46_527(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۯ\u200cۯ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۯ\u200cۯ', strict=True)

    def test_uts46_528(self):
        self.assertEqual(idna.decode('xn--cmba', uts46=True, strict=True), 'ۯۯ')
        self.assertEqual(idna.encode('xn--cmba', uts46=True, strict=True), b'xn--cmba')

    def test_uts46_529(self):
        self.assertEqual(idna.decode('ۯۯ', uts46=True, strict=True), 'ۯۯ')
        self.assertEqual(idna.encode('ۯۯ', uts46=True, strict=True), b'xn--cmba')

    def test_uts46_530(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cmba004q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cmba004q', strict=True)

    def test_uts46_531(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ل\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ل\u200c', strict=True)

    def test_uts46_532(self):
        self.assertEqual(idna.decode('xn--ghb', uts46=True, strict=True), 'ل')
        self.assertEqual(idna.encode('xn--ghb', uts46=True, strict=True), b'xn--ghb')

    def test_uts46_533(self):
        self.assertEqual(idna.decode('ل', uts46=True, strict=True), 'ل')
        self.assertEqual(idna.encode('ل', uts46=True, strict=True), b'xn--ghb')

    def test_uts46_534(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ghb413k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ghb413k', strict=True)

    def test_uts46_535(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a。。b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a。。b', strict=True)

    def test_uts46_536(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A。。B', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A。。B', strict=True)

    def test_uts46_537(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a..b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a..b', strict=True)

    def test_uts46_538(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。。ڹ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。。ڹ\u200c', strict=True)

    def test_uts46_539(self):
        self.assertRaises(idna.IDNAError, idna.decode, '..xn--skb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '..xn--skb', strict=True)

    def test_uts46_540(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug..xn--skb080k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug..xn--skb080k', strict=True)

    def test_uts46_541(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'א0٠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'א0٠', strict=True)

    def test_uts46_542(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0-zhc74b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0-zhc74b', strict=True)

    def test_uts46_543(self):
        self.assertRaises(idna.IDNAError, idna.decode, '$', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '$', strict=True)

    def test_uts46_544(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⑷.four', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⑷.four', strict=True)

    def test_uts46_545(self):
        self.assertRaises(idna.IDNAError, idna.decode, '(4).four', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '(4).four', strict=True)

    def test_uts46_546(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⑷.FOUR', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⑷.FOUR', strict=True)

    def test_uts46_547(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⑷.Four', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⑷.Four', strict=True)

    def test_uts46_548(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'a\ud900z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'a\ud900z', strict=True)

    def test_uts46_549(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'A\ud900Z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'A\ud900Z', strict=True)

    def test_uts46_550(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--', strict=True)

    def test_uts46_551(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---', strict=True)

    def test_uts46_552(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ASCII-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ASCII-', strict=True)

    def test_uts46_553(self):
        self.assertEqual(idna.decode('ascii', uts46=True, strict=True), 'ascii')
        self.assertEqual(idna.encode('ascii', uts46=True, strict=True), b'ascii')

    def test_uts46_554(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--unicode-.org', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--unicode-.org', strict=True)

    def test_uts46_555(self):
        self.assertEqual(idna.decode('unicode.org', uts46=True, strict=True), 'unicode.org')
        self.assertEqual(idna.encode('unicode.org', uts46=True, strict=True), b'unicode.org')

    def test_uts46_556(self):
        self.assertEqual(idna.decode('陋㛼当𤎫竮䗗', uts46=True, strict=True), '陋㛼当𤎫竮䗗')
        self.assertEqual(idna.encode('陋㛼当𤎫竮䗗', uts46=True, strict=True), b'xn--snl253bgitxhzwu2arn60c')

    def test_uts46_557(self):
        self.assertEqual(idna.decode('陋㛼当𤎫竮䗗', uts46=True, strict=True), '陋㛼当𤎫竮䗗')
        self.assertEqual(idna.encode('陋㛼当𤎫竮䗗', uts46=True, strict=True), b'xn--snl253bgitxhzwu2arn60c')

    def test_uts46_558(self):
        self.assertEqual(idna.decode('xn--snl253bgitxhzwu2arn60c', uts46=True, strict=True), '陋㛼当𤎫竮䗗')
        self.assertEqual(idna.encode('xn--snl253bgitxhzwu2arn60c', uts46=True, strict=True), b'xn--snl253bgitxhzwu2arn60c')

    def test_uts46_559(self):
        self.assertEqual(idna.decode('電𡍪弳䎫窮䵗', uts46=True, strict=True), '電𡍪弳䎫窮䵗')
        self.assertEqual(idna.encode('電𡍪弳䎫窮䵗', uts46=True, strict=True), b'xn--kbo60w31ob3z6t3av9z5b')

    def test_uts46_560(self):
        self.assertEqual(idna.decode('xn--kbo60w31ob3z6t3av9z5b', uts46=True, strict=True), '電𡍪弳䎫窮䵗')
        self.assertEqual(idna.encode('xn--kbo60w31ob3z6t3av9z5b', uts46=True, strict=True), b'xn--kbo60w31ob3z6t3av9z5b')

    def test_uts46_561(self):
        self.assertEqual(idna.decode('xn--A-1ga', uts46=True, strict=True), 'aö')
        self.assertEqual(idna.encode('xn--A-1ga', uts46=True, strict=True), b'xn--a-1ga')

    def test_uts46_562(self):
        self.assertEqual(idna.decode('aö', uts46=True, strict=True), 'aö')
        self.assertEqual(idna.encode('aö', uts46=True, strict=True), b'xn--a-1ga')

    def test_uts46_563(self):
        self.assertEqual(idna.decode('aö', uts46=True, strict=True), 'aö')
        self.assertEqual(idna.encode('aö', uts46=True, strict=True), b'xn--a-1ga')

    def test_uts46_564(self):
        self.assertEqual(idna.decode('AÖ', uts46=True, strict=True), 'aö')
        self.assertEqual(idna.encode('AÖ', uts46=True, strict=True), b'xn--a-1ga')

    def test_uts46_565(self):
        self.assertEqual(idna.decode('AÖ', uts46=True, strict=True), 'aö')
        self.assertEqual(idna.encode('AÖ', uts46=True, strict=True), b'xn--a-1ga')

    def test_uts46_566(self):
        self.assertEqual(idna.decode('Aö', uts46=True, strict=True), 'aö')
        self.assertEqual(idna.encode('Aö', uts46=True, strict=True), b'xn--a-1ga')

    def test_uts46_567(self):
        self.assertEqual(idna.decode('Aö', uts46=True, strict=True), 'aö')
        self.assertEqual(idna.encode('Aö', uts46=True, strict=True), b'xn--a-1ga')

    def test_uts46_568(self):
        self.assertRaises(idna.IDNAError, idna.decode, '＝̸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '＝̸', strict=True)

    def test_uts46_569(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠', strict=True)

    def test_uts46_570(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠', strict=True)

    def test_uts46_571(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch', strict=True)

    def test_uts46_575(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertEqual(idna.encode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), b'123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')

    def test_uts46_576(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertEqual(idna.encode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), b'123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')

    def test_uts46_577(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.', strict=True)

    def test_uts46_578(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b.', strict=True)

    def test_uts46_579(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', strict=True)

    def test_uts46_580(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901c', strict=True)

    def test_uts46_581(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', strict=True)

    def test_uts46_582(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a', strict=True)

    def test_uts46_583(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', strict=True)

    def test_uts46_584(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789a.', strict=True)

    def test_uts46_585(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', strict=True)

    def test_uts46_586(self):
        self.assertEqual(idna.decode('123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', uts46=True, strict=True), '123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b')
        self.assertRaises(idna.IDNAError, idna.encode, '123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890b', strict=True)

    def test_uts46_593(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒕∝ٟ\U00093926．-󠄯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒕∝ٟ\U00093926．-󠄯', strict=True)

    def test_uts46_594(self):
        self.assertRaises(idna.IDNAError, idna.decode, '14.∝ٟ\U00093926.-󠄯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '14.∝ٟ\U00093926.-󠄯', strict=True)

    def test_uts46_595(self):
        self.assertRaises(idna.IDNAError, idna.decode, '14.xn--7hb713l3v90n.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '14.xn--7hb713l3v90n.-', strict=True)

    def test_uts46_596(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7hb713lfwbi1311b.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7hb713lfwbi1311b.-', strict=True)

    def test_uts46_597(self):
        self.assertEqual(idna.decode('ꡣ.ߏ', uts46=True, strict=True), 'ꡣ.ߏ')
        self.assertEqual(idna.encode('ꡣ.ߏ', uts46=True, strict=True), b'xn--8c9a.xn--qsb')

    def test_uts46_598(self):
        self.assertEqual(idna.decode('xn--8c9a.xn--qsb', uts46=True, strict=True), 'ꡣ.ߏ')
        self.assertEqual(idna.encode('xn--8c9a.xn--qsb', uts46=True, strict=True), b'xn--8c9a.xn--qsb')

    def test_uts46_599(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯\u0603｡-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯\u0603｡-', strict=True)

    def test_uts46_600(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯\u0603｡-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯\u0603｡-', strict=True)

    def test_uts46_601(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯\u0603。-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯\u0603。-', strict=True)

    def test_uts46_602(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯\u0603。-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯\u0603。-', strict=True)

    def test_uts46_603(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lfb566l.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lfb566l.-', strict=True)

    def test_uts46_604(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾛𐹧⾕.ᅟ\U000e05f0ςႭ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾛𐹧⾕.ᅟ\U000e05f0ςႭ', strict=True)

    def test_uts46_605(self):
        self.assertRaises(idna.IDNAError, idna.decode, '走𐹧谷.ᅟ\U000e05f0ςႭ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '走𐹧谷.ᅟ\U000e05f0ςႭ', strict=True)

    def test_uts46_606(self):
        self.assertRaises(idna.IDNAError, idna.decode, '走𐹧谷.ᅟ\U000e05f0ςⴍ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '走𐹧谷.ᅟ\U000e05f0ςⴍ', strict=True)

    def test_uts46_607(self):
        self.assertRaises(idna.IDNAError, idna.decode, '走𐹧谷.ᅟ\U000e05f0ΣႭ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '走𐹧谷.ᅟ\U000e05f0ΣႭ', strict=True)

    def test_uts46_608(self):
        self.assertRaises(idna.IDNAError, idna.decode, '走𐹧谷.ᅟ\U000e05f0σⴍ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '走𐹧谷.ᅟ\U000e05f0σⴍ', strict=True)

    def test_uts46_609(self):
        self.assertRaises(idna.IDNAError, idna.decode, '走𐹧谷.ᅟ\U000e05f0Σⴍ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '走𐹧谷.ᅟ\U000e05f0Σⴍ', strict=True)

    def test_uts46_610(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6g3a1x434z.xn--4xa452s5d17u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6g3a1x434z.xn--4xa452s5d17u', strict=True)

    def test_uts46_611(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6g3a1x434z.xn--3xa652s5d17u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6g3a1x434z.xn--3xa652s5d17u', strict=True)

    def test_uts46_612(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾛𐹧⾕.ᅟ\U000e05f0ςⴍ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾛𐹧⾕.ᅟ\U000e05f0ςⴍ', strict=True)

    def test_uts46_613(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾛𐹧⾕.ᅟ\U000e05f0ΣႭ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾛𐹧⾕.ᅟ\U000e05f0ΣႭ', strict=True)

    def test_uts46_614(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾛𐹧⾕.ᅟ\U000e05f0σⴍ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾛𐹧⾕.ᅟ\U000e05f0σⴍ', strict=True)

    def test_uts46_615(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾛𐹧⾕.ᅟ\U000e05f0Σⴍ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾛𐹧⾕.ᅟ\U000e05f0Σⴍ', strict=True)

    def test_uts46_616(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6g3a1x434z.xn--4xa180eotvh7453a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6g3a1x434z.xn--4xa180eotvh7453a', strict=True)

    def test_uts46_617(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6g3a1x434z.xn--4xa627dhpae6345i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6g3a1x434z.xn--4xa627dhpae6345i', strict=True)

    def test_uts46_618(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6g3a1x434z.xn--3xa380eotvh7453a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6g3a1x434z.xn--3xa380eotvh7453a', strict=True)

    def test_uts46_619(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6g3a1x434z.xn--3xa827dhpae6345i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6g3a1x434z.xn--3xa827dhpae6345i', strict=True)

    def test_uts46_620(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d≠ᢙ≯.솣-ᡴႠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d≠ᢙ≯.솣-ᡴႠ', strict=True)

    def test_uts46_621(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d≠ᢙ≯.솣-ᡴႠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d≠ᢙ≯.솣-ᡴႠ', strict=True)

    def test_uts46_622(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d≠ᢙ≯.솣-ᡴⴀ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d≠ᢙ≯.솣-ᡴⴀ', strict=True)

    def test_uts46_623(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d≠ᢙ≯.솣-ᡴⴀ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d≠ᢙ≯.솣-ᡴⴀ', strict=True)

    def test_uts46_624(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jbf911clb.xn----p9j493ivi4l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jbf911clb.xn----p9j493ivi4l', strict=True)

    def test_uts46_625(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ᢙ≯.솣-ᡴⴀ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ᢙ≯.솣-ᡴⴀ', strict=True)

    def test_uts46_626(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ᢙ≯.솣-ᡴⴀ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ᢙ≯.솣-ᡴⴀ', strict=True)

    def test_uts46_627(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ᢙ≯.솣-ᡴႠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ᢙ≯.솣-ᡴႠ', strict=True)

    def test_uts46_628(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ᢙ≯.솣-ᡴႠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ᢙ≯.솣-ᡴႠ', strict=True)

    def test_uts46_629(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jbf929a90b0b.xn----p9j493ivi4l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jbf929a90b0b.xn----p9j493ivi4l', strict=True)

    def test_uts46_630(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jbf911clb.xn----6zg521d196p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jbf911clb.xn----6zg521d196p', strict=True)

    def test_uts46_631(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jbf929a90b0b.xn----6zg521d196p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jbf929a90b0b.xn----6zg521d196p', strict=True)

    def test_uts46_632(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006f79c．𐿇ྡྷݽ\u0600', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006f79c．𐿇ྡྷݽ\u0600', strict=True)

    def test_uts46_633(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006f79c．𐿇ྡྷݽ\u0600', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006f79c．𐿇ྡྷݽ\u0600', strict=True)

    def test_uts46_634(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006f79c.𐿇ྡྷݽ\u0600', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006f79c.𐿇ྡྷݽ\u0600', strict=True)

    def test_uts46_635(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gw68a.xn--ifb57ev2psc6027m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gw68a.xn--ifb57ev2psc6027m', strict=True)

    def test_uts46_636(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𣳔̃.𑓂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𣳔̃.𑓂', strict=True)

    def test_uts46_637(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nsa95820a.xn--wz1d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nsa95820a.xn--wz1d', strict=True)

    def test_uts46_638(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤀𞥅\U00058431。󠄌Ⴣꡥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤀𞥅\U00058431。󠄌Ⴣꡥ', strict=True)

    def test_uts46_639(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤢𞥅\U00058431。󠄌ⴣꡥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤢𞥅\U00058431。󠄌ⴣꡥ', strict=True)

    def test_uts46_640(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9d6hgcy3556a.xn--rlju750b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9d6hgcy3556a.xn--rlju750b', strict=True)

    def test_uts46_641(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9d6hgcy3556a.xn--7nd0578e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9d6hgcy3556a.xn--7nd0578e', strict=True)

    def test_uts46_642(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤀𞥅\U00058431。󠄌ⴣꡥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤀𞥅\U00058431。󠄌ⴣꡥ', strict=True)

    def test_uts46_643(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u08e2𑁿ς𖬱。󠅡렧', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u08e2𑁿ς𖬱。󠅡렧', strict=True)

    def test_uts46_644(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u08e2𑁿ς𖬱。󠅡렧', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u08e2𑁿ς𖬱。󠅡렧', strict=True)

    def test_uts46_645(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u08e2𑁿Σ𖬱。󠅡렧', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u08e2𑁿Σ𖬱。󠅡렧', strict=True)

    def test_uts46_646(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u08e2𑁿Σ𖬱。󠅡렧', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u08e2𑁿Σ𖬱。󠅡렧', strict=True)

    def test_uts46_647(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u08e2𑁿σ𖬱。󠅡렧', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u08e2𑁿σ𖬱。󠅡렧', strict=True)

    def test_uts46_648(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u08e2𑁿σ𖬱。󠅡렧', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u08e2𑁿σ𖬱。󠅡렧', strict=True)

    def test_uts46_649(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa53xp48ys2xc.xn--kn2b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa53xp48ys2xc.xn--kn2b', strict=True)

    def test_uts46_650(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa73xp48ys2xc.xn--kn2b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa73xp48ys2xc.xn--kn2b', strict=True)

    def test_uts46_651(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200d。𞤍\u200c\u200d⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200d。𞤍\u200c\u200d⒈', strict=True)

    def test_uts46_652(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200d。𞤍\u200c\u200d1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200d。𞤍\u200c\u200d1.', strict=True)

    def test_uts46_653(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200d。𞤯\u200c\u200d1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200d。𞤯\u200c\u200d1.', strict=True)

    def test_uts46_654(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--1-0i8r.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--1-0i8r.', strict=True)

    def test_uts46_655(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ugn.xn--1-rgnd61297b.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ugn.xn--1-rgnd61297b.', strict=True)

    def test_uts46_656(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200d。𞤯\u200c\u200d⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200d。𞤯\u200c\u200d⒈', strict=True)

    def test_uts46_657(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--tsh3666n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--tsh3666n', strict=True)

    def test_uts46_658(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ugn.xn--0ugc555aiv51d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ugn.xn--0ugc555aiv51d', strict=True)

    def test_uts46_659(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000853ad.Ⴒ𑇀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000853ad.Ⴒ𑇀', strict=True)

    def test_uts46_660(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000853ad.ⴒ𑇀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000853ad.ⴒ𑇀', strict=True)

    def test_uts46_661(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bn95b.xn--9kj2034e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bn95b.xn--9kj2034e', strict=True)

    def test_uts46_662(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug15083f.xn--9kj2034e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug15083f.xn--9kj2034e', strict=True)

    def test_uts46_663(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bn95b.xn--qnd6272k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bn95b.xn--qnd6272k', strict=True)

    def test_uts46_664(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug15083f.xn--qnd6272k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug15083f.xn--qnd6272k', strict=True)

    def test_uts46_665(self):
        self.assertRaises(idna.IDNAError, idna.decode, '繱𑖿\u200d.８︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '繱𑖿\u200d.８︒', strict=True)

    def test_uts46_666(self):
        self.assertEqual(idna.decode('繱𑖿\u200d.8。', uts46=True, strict=True), '繱𑖿\u200d.8.')
        self.assertRaises(idna.IDNAError, idna.encode, '繱𑖿\u200d.8。', strict=True)

    def test_uts46_673(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gl0as212a.xn--8-o89h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gl0as212a.xn--8-o89h', strict=True)

    def test_uts46_674(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug6928ac48e.xn--8-o89h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug6928ac48e.xn--8-o89h', strict=True)

    def test_uts46_675(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆾．𞀈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆾．𞀈', strict=True)

    def test_uts46_676(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆾.𞀈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆾.𞀈', strict=True)

    def test_uts46_677(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--ph4h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--ph4h', strict=True)

    def test_uts46_678(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß۫。\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß۫。\u200d', strict=True)

    def test_uts46_679(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS۫。\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS۫。\u200d', strict=True)

    def test_uts46_680(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss۫。\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss۫。\u200d', strict=True)

    def test_uts46_681(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss۫。\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss۫。\u200d', strict=True)

    def test_uts46_684(self):
        self.assertEqual(idna.decode('SS۫.', uts46=True, strict=True), 'ss۫.')
        self.assertRaises(idna.IDNAError, idna.encode, 'SS۫.', strict=True)

    def test_uts46_685(self):
        self.assertEqual(idna.decode('Ss۫.', uts46=True, strict=True), 'ss۫.')
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss۫.', strict=True)

    def test_uts46_686(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-59d.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-59d.xn--1ug', strict=True)

    def test_uts46_687(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca012a.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca012a.xn--1ug', strict=True)

    def test_uts46_688(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0435\u200c⒈．\U000e0387', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0435\u200c⒈．\U000e0387', strict=True)

    def test_uts46_689(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0435\u200c1..\U000e0387', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0435\u200c1..\U000e0387', strict=True)

    def test_uts46_690(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-bs31m..xn--tv36e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-bs31m..xn--tv36e', strict=True)

    def test_uts46_691(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-rgn37671n..xn--tv36e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-rgn37671n..xn--tv36e', strict=True)

    def test_uts46_692(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tshz2001k.xn--tv36e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tshz2001k.xn--tv36e', strict=True)

    def test_uts46_693(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug88o47900b.xn--tv36e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug88o47900b.xn--tv36e', strict=True)

    def test_uts46_694(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000df223ٟꪲß。\U000cc4e7', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000df223ٟꪲß。\U000cc4e7', strict=True)

    def test_uts46_695(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000df223ٟꪲSS。\U000cc4e7', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000df223ٟꪲSS。\U000cc4e7', strict=True)

    def test_uts46_696(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000df223ٟꪲss。\U000cc4e7', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000df223ٟꪲss。\U000cc4e7', strict=True)

    def test_uts46_697(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000df223ٟꪲSs。\U000cc4e7', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000df223ٟꪲSs。\U000cc4e7', strict=True)

    def test_uts46_698(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-3xd2839nncy1m.xn--bb79d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-3xd2839nncy1m.xn--bb79d', strict=True)

    def test_uts46_699(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca92z0t7n5w96j.xn--bb79d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca92z0t7n5w96j.xn--bb79d', strict=True)

    def test_uts46_700(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݴ\u200c𞤿。\U0003d610䉜\u200d\U0007f93c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݴ\u200c𞤿。\U0003d610䉜\u200d\U0007f93c', strict=True)

    def test_uts46_701(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݴ\u200c𞤝。\U0003d610䉜\u200d\U0007f93c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݴ\u200c𞤝。\U0003d610䉜\u200d\U0007f93c', strict=True)

    def test_uts46_702(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4pb2977v.xn--z0nt555ukbnv', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4pb2977v.xn--z0nt555ukbnv', strict=True)

    def test_uts46_703(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4pb607jjt73a.xn--1ug236ke314donv1a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4pb607jjt73a.xn--1ug236ke314donv1a', strict=True)

    def test_uts46_704(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cςᡱ⒈.≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cςᡱ⒈.≮𑄳\u200d𐮍', strict=True)

    def test_uts46_705(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cςᡱ⒈.≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cςᡱ⒈.≮𑄳\u200d𐮍', strict=True)

    def test_uts46_706(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cςᡱ1..≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cςᡱ1..≮𑄳\u200d𐮍', strict=True)

    def test_uts46_707(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cςᡱ1..≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cςᡱ1..≮𑄳\u200d𐮍', strict=True)

    def test_uts46_708(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cΣᡱ1..≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cΣᡱ1..≮𑄳\u200d𐮍', strict=True)

    def test_uts46_709(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cΣᡱ1..≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cΣᡱ1..≮𑄳\u200d𐮍', strict=True)

    def test_uts46_710(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cσᡱ1..≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cσᡱ1..≮𑄳\u200d𐮍', strict=True)

    def test_uts46_711(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cσᡱ1..≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cσᡱ1..≮𑄳\u200d𐮍', strict=True)

    def test_uts46_712(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-zmb699meq63t..xn--gdh5392g6sd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-zmb699meq63t..xn--gdh5392g6sd', strict=True)

    def test_uts46_713(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-zmb699meq63t..xn--1ug85gn777ahze', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-zmb699meq63t..xn--1ug85gn777ahze', strict=True)

    def test_uts46_714(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-xmb999meq63t..xn--1ug85gn777ahze', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-xmb999meq63t..xn--1ug85gn777ahze', strict=True)

    def test_uts46_715(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cΣᡱ⒈.≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cΣᡱ⒈.≮𑄳\u200d𐮍', strict=True)

    def test_uts46_716(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cΣᡱ⒈.≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cΣᡱ⒈.≮𑄳\u200d𐮍', strict=True)

    def test_uts46_717(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cσᡱ⒈.≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cσᡱ⒈.≮𑄳\u200d𐮍', strict=True)

    def test_uts46_718(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00094b5cσᡱ⒈.≮𑄳\u200d𐮍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00094b5cσᡱ⒈.≮𑄳\u200d𐮍', strict=True)

    def test_uts46_719(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa207hkzinr77u.xn--gdh5392g6sd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa207hkzinr77u.xn--gdh5392g6sd', strict=True)

    def test_uts46_720(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa207hkzinr77u.xn--1ug85gn777ahze', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa207hkzinr77u.xn--1ug85gn777ahze', strict=True)

    def test_uts46_721(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa407hkzinr77u.xn--1ug85gn777ahze', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa407hkzinr77u.xn--1ug85gn777ahze', strict=True)

    def test_uts46_722(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ㅤ्Ⴀ័.᠋', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ㅤ्Ⴀ័.᠋', strict=True)

    def test_uts46_723(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᅠ्Ⴀ័.᠋', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᅠ्Ⴀ័.᠋', strict=True)

    def test_uts46_724(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᅠ्ⴀ័.᠋', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᅠ्ⴀ័.᠋', strict=True)

    def test_uts46_725(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b445e53p.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b445e53p.', strict=True)

    def test_uts46_726(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ㅤ्ⴀ័.᠋', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ㅤ्ⴀ័.᠋', strict=True)

    def test_uts46_727(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b742bkqf4ty.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b742bkqf4ty.', strict=True)

    def test_uts46_728(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b468aoqa89r.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b468aoqa89r.', strict=True)

    def test_uts46_729(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b445e53po6d.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b445e53po6d.', strict=True)

    def test_uts46_730(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b468azngju2a.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b468azngju2a.', strict=True)

    def test_uts46_731(self):
        self.assertRaises(idna.IDNAError, idna.decode, '❣\u200d．্𑰽ؒꤩ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '❣\u200d．্𑰽ؒꤩ', strict=True)

    def test_uts46_732(self):
        self.assertRaises(idna.IDNAError, idna.decode, '❣\u200d.্𑰽ؒꤩ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '❣\u200d.্𑰽ؒꤩ', strict=True)

    def test_uts46_733(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pei.xn--0fb32q3w7q2g4d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pei.xn--0fb32q3w7q2g4d', strict=True)

    def test_uts46_734(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ugy10a.xn--0fb32q3w7q2g4d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ugy10a.xn--0fb32q3w7q2g4d', strict=True)

    def test_uts46_735(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮𐳺\U00010e44.≯\U0006abb8ꡅ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮𐳺\U00010e44.≯\U0006abb8ꡅ', strict=True)

    def test_uts46_736(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮𐳺\U00010e44.≯\U0006abb8ꡅ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮𐳺\U00010e44.≯\U0006abb8ꡅ', strict=True)

    def test_uts46_737(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh7943gk2a.xn--hdh1383c5e36c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh7943gk2a.xn--hdh1383c5e36c', strict=True)

    def test_uts46_738(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ೌ𐧅𐳏\U000e0cba｡್ᠦ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ೌ𐧅𐳏\U000e0cba｡್ᠦ', strict=True)

    def test_uts46_739(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ೌ𐧅𐳏\U000e0cba。್ᠦ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ೌ𐧅𐳏\U000e0cba。್ᠦ', strict=True)

    def test_uts46_740(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ೌ𐧅𐲏\U000e0cba。್ᠦ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ೌ𐧅𐲏\U000e0cba。್ᠦ', strict=True)

    def test_uts46_741(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7tc6360ky5bn2732c.xn--8tc429c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7tc6360ky5bn2732c.xn--8tc429c', strict=True)

    def test_uts46_742(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ೌ𐧅𐲏\U000e0cba｡್ᠦ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ೌ𐧅𐲏\U000e0cba｡್ᠦ', strict=True)

    def test_uts46_743(self):
        self.assertRaises(idna.IDNAError, idna.decode, '͉。𧡫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '͉。𧡫', strict=True)

    def test_uts46_744(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nua.xn--bc6k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nua.xn--bc6k', strict=True)

    def test_uts46_745(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑰿󠅦．ᅠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑰿󠅦．ᅠ', strict=True)

    def test_uts46_746(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑰿󠅦.ᅠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑰿󠅦.ᅠ', strict=True)

    def test_uts46_747(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ok3d.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ok3d.', strict=True)

    def test_uts46_748(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ok3d.xn--psd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ok3d.xn--psd', strict=True)

    def test_uts46_749(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𞤆\u200d。\U000f8f04\U0001ecd2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𞤆\u200d。\U000f8f04\U0001ecd2', strict=True)

    def test_uts46_750(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𞤨\u200d。\U000f8f04\U0001ecd2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𞤨\u200d。\U000f8f04\U0001ecd2', strict=True)

    def test_uts46_751(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ni8r.xn--846h96596c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ni8r.xn--846h96596c', strict=True)

    def test_uts46_752(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ugnx367r.xn--846h96596c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ugnx367r.xn--846h96596c', strict=True)

    def test_uts46_753(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡏ\U000e01f6≯\U00033fbd。᷽⾇滸𐹰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡏ\U000e01f6≯\U00033fbd。᷽⾇滸𐹰', strict=True)

    def test_uts46_754(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡏ\U000e01f6≯\U00033fbd。᷽⾇滸𐹰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡏ\U000e01f6≯\U00033fbd。᷽⾇滸𐹰', strict=True)

    def test_uts46_755(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡏ\U000e01f6≯\U00033fbd。᷽舛滸𐹰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡏ\U000e01f6≯\U00033fbd。᷽舛滸𐹰', strict=True)

    def test_uts46_756(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡏ\U000e01f6≯\U00033fbd。᷽舛滸𐹰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡏ\U000e01f6≯\U00033fbd。᷽舛滸𐹰', strict=True)

    def test_uts46_757(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh7483cu6twwki8e.xn--yfg0765a58l0n6k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh7483cu6twwki8e.xn--yfg0765a58l0n6k', strict=True)

    def test_uts46_758(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蔏｡𑰺', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蔏｡𑰺', strict=True)

    def test_uts46_759(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蔏。𑰺', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蔏。𑰺', strict=True)

    def test_uts46_760(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--uy1a.xn--jk3d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--uy1a.xn--jk3d', strict=True)

    def test_uts46_761(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟿𐮋。󠄊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟿𐮋。󠄊', strict=True)

    def test_uts46_762(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9𐮋。󠄊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9𐮋。󠄊', strict=True)

    def test_uts46_763(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-rv5i.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-rv5i.', strict=True)

    def test_uts46_764(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000df1c7-䟖F。ߋ⒈٢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000df1c7-䟖F。ߋ⒈٢', strict=True)

    def test_uts46_765(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000df1c7-䟖F。ߋ1.٢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000df1c7-䟖F。ߋ1.٢', strict=True)

    def test_uts46_766(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000df1c7-䟖f。ߋ1.٢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000df1c7-䟖f。ߋ1.٢', strict=True)

    def test_uts46_767(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---f-mz8b08788k.xn--1-ybd.xn--bib', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---f-mz8b08788k.xn--1-ybd.xn--bib', strict=True)

    def test_uts46_768(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000df1c7-䟖f。ߋ⒈٢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000df1c7-䟖f。ߋ⒈٢', strict=True)

    def test_uts46_769(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---f-mz8b08788k.xn--bib53ev44d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---f-mz8b08788k.xn--bib53ev44d', strict=True)

    def test_uts46_770(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c｡𐹺', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c｡𐹺', strict=True)

    def test_uts46_771(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c。𐹺', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c。𐹺', strict=True)

    def test_uts46_772(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--yo0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--yo0d', strict=True)

    def test_uts46_773(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--yo0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--yo0d', strict=True)

    def test_uts46_774(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐡆.≯\u200c-𞥀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐡆.≯\u200c-𞥀', strict=True)

    def test_uts46_775(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐡆.≯\u200c-𞥀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐡆.≯\u200c-𞥀', strict=True)

    def test_uts46_776(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐡆.≯\u200c-𞤞', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐡆.≯\u200c-𞤞', strict=True)

    def test_uts46_777(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐡆.≯\u200c-𞤞', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐡆.≯\u200c-𞤞', strict=True)

    def test_uts46_778(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--le9c.xn----ogo9956r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--le9c.xn----ogo9956r', strict=True)

    def test_uts46_779(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--le9c.xn----rgn40iy359e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--le9c.xn----rgn40iy359e', strict=True)

    def test_uts46_780(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0040-。≠ﳗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0040-。≠ﳗ', strict=True)

    def test_uts46_781(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0040-。≠ﳗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0040-。≠ﳗ', strict=True)

    def test_uts46_782(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0040-。≠هج', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0040-。≠هج', strict=True)

    def test_uts46_783(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0040-。≠هج', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0040-。≠هج', strict=True)

    def test_uts46_784(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----f411m.xn--rgb7c611j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----f411m.xn--rgb7c611j', strict=True)

    def test_uts46_785(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007bb39𑈵。\u200d\U0001ea36', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007bb39𑈵。\u200d\U0001ea36', strict=True)

    def test_uts46_786(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8g1d12120a.xn--5l6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8g1d12120a.xn--5l6h', strict=True)

    def test_uts46_787(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8g1d12120a.xn--1ug6651p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8g1d12120a.xn--1ug6651p', strict=True)

    def test_uts46_788(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑋧꧀2｡㧉\U00092584', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑋧꧀2｡㧉\U00092584', strict=True)

    def test_uts46_789(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑋧꧀2。㧉\U00092584', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑋧꧀2。㧉\U00092584', strict=True)

    def test_uts46_790(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2-5z4eu89y.xn--97l02706d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2-5z4eu89y.xn--97l02706d', strict=True)

    def test_uts46_791(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U0003db04𐹴\U0001ea65。≯6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U0003db04𐹴\U0001ea65。≯6', strict=True)

    def test_uts46_792(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U0003db04𐹴\U0001ea65。≯6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U0003db04𐹴\U0001ea65。≯6', strict=True)

    def test_uts46_793(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--so0du768aim9m.xn--6-ogo', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--so0du768aim9m.xn--6-ogo', strict=True)

    def test_uts46_794(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug7105gf5wfxepq.xn--6-ogo', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug7105gf5wfxepq.xn--6-ogo', strict=True)

    def test_uts46_795(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑁿．𐹦\U0003b7b5-\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑁿．𐹦\U0003b7b5-\u200d', strict=True)

    def test_uts46_796(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑁿.𐹦\U0003b7b5-\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑁿.𐹦\U0003b7b5-\u200d', strict=True)

    def test_uts46_797(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--q30d.xn----i26i1299n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--q30d.xn----i26i1299n', strict=True)

    def test_uts46_798(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--q30d.xn----ugn1088hfsxv', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--q30d.xn----ugn1088hfsxv', strict=True)

    def test_uts46_799(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⤸ς\U0003ac40｡ﾠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⤸ς\U0003ac40｡ﾠ', strict=True)

    def test_uts46_800(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⤸ς\U0003ac40。ᅠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⤸ς\U0003ac40。ᅠ', strict=True)

    def test_uts46_801(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⤸Σ\U0003ac40。ᅠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⤸Σ\U0003ac40。ᅠ', strict=True)

    def test_uts46_802(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⤸σ\U0003ac40。ᅠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⤸σ\U0003ac40。ᅠ', strict=True)

    def test_uts46_803(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa192qmp03d.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa192qmp03d.', strict=True)

    def test_uts46_804(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa392qmp03d.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa392qmp03d.', strict=True)

    def test_uts46_805(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⤸Σ\U0003ac40｡ﾠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⤸Σ\U0003ac40｡ﾠ', strict=True)

    def test_uts46_806(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⤸σ\U0003ac40｡ﾠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⤸σ\U0003ac40｡ﾠ', strict=True)

    def test_uts46_807(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa192qmp03d.xn--psd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa192qmp03d.xn--psd', strict=True)

    def test_uts46_808(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa392qmp03d.xn--psd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa392qmp03d.xn--psd', strict=True)

    def test_uts46_809(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa192qmp03d.xn--cl7c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa192qmp03d.xn--cl7c', strict=True)

    def test_uts46_810(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa392qmp03d.xn--cl7c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa392qmp03d.xn--cl7c', strict=True)

    def test_uts46_811(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݥဵ𐫔ە.𐦬𑋪Ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݥဵ𐫔ە.𐦬𑋪Ⴃ', strict=True)

    def test_uts46_812(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݥဵ𐫔ە.𐦬𑋪ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݥဵ𐫔ە.𐦬𑋪ⴃ', strict=True)

    def test_uts46_813(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--llb10as9tqp5y.xn--ukj7371e21f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--llb10as9tqp5y.xn--ukj7371e21f', strict=True)

    def test_uts46_814(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--llb10as9tqp5y.xn--bnd9168j21f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--llb10as9tqp5y.xn--bnd9168j21f', strict=True)

    def test_uts46_815(self):
        self.assertRaises(idna.IDNAError, idna.decode, '١᭄-킼.᮪ؖ٬≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '١᭄-킼.᮪ؖ٬≯', strict=True)

    def test_uts46_816(self):
        self.assertRaises(idna.IDNAError, idna.decode, '١᭄-킼.᮪ؖ٬≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '١᭄-킼.᮪ؖ٬≯', strict=True)

    def test_uts46_817(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----9pc551nk39n.xn--4fb6o571degg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----9pc551nk39n.xn--4fb6o571degg', strict=True)

    def test_uts46_818(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-。ۂ\u0604\U000855a1𑓂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-。ۂ\u0604\U000855a1𑓂', strict=True)

    def test_uts46_819(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-。ۂ\u0604\U000855a1𑓂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-。ۂ\u0604\U000855a1𑓂', strict=True)

    def test_uts46_820(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--mfb39a7208dzgs3d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--mfb39a7208dzgs3d', strict=True)

    def test_uts46_821(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U000ef456\U000e0050．ֽ\U00019bb0ꡝ𐋡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U000ef456\U000e0050．ֽ\U00019bb0ꡝ𐋡', strict=True)

    def test_uts46_822(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U000ef456\U000e0050.ֽ\U00019bb0ꡝ𐋡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U000ef456\U000e0050.ֽ\U00019bb0ꡝ𐋡', strict=True)

    def test_uts46_823(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b726ey18m.xn--ldb8734fg0qcyzzg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b726ey18m.xn--ldb8734fg0qcyzzg', strict=True)

    def test_uts46_824(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug66101lt8me.xn--ldb8734fg0qcyzzg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug66101lt8me.xn--ldb8734fg0qcyzzg', strict=True)

    def test_uts46_825(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒\U00103235ς\U00040807｡𐮈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒\U00103235ς\U00040807｡𐮈', strict=True)

    def test_uts46_826(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。\U00103235ς\U00040807。𐮈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。\U00103235ς\U00040807。𐮈', strict=True)

    def test_uts46_827(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。\U00103235Σ\U00040807。𐮈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。\U00103235Σ\U00040807。𐮈', strict=True)

    def test_uts46_828(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。\U00103235σ\U00040807。𐮈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。\U00103235σ\U00040807。𐮈', strict=True)

    def test_uts46_829(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--4xa68573c7n64d.xn--f29c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--4xa68573c7n64d.xn--f29c', strict=True)

    def test_uts46_830(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--3xa88573c7n64d.xn--f29c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--3xa88573c7n64d.xn--f29c', strict=True)

    def test_uts46_831(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒\U00103235Σ\U00040807｡𐮈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒\U00103235Σ\U00040807｡𐮈', strict=True)

    def test_uts46_832(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒\U00103235σ\U00040807｡𐮈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒\U00103235σ\U00040807｡𐮈', strict=True)

    def test_uts46_833(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa1729jwz5t7gl5f.xn--f29c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa1729jwz5t7gl5f.xn--f29c', strict=True)

    def test_uts46_834(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa3729jwz5t7gl5f.xn--f29c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa3729jwz5t7gl5f.xn--f29c', strict=True)

    def test_uts46_835(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߙ．ۮ\U000c6f83≯󠅲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߙ．ۮ\U000c6f83≯󠅲', strict=True)

    def test_uts46_836(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߙ．ۮ\U000c6f83≯󠅲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߙ．ۮ\U000c6f83≯󠅲', strict=True)

    def test_uts46_837(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߙ.ۮ\U000c6f83≯󠅲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߙ.ۮ\U000c6f83≯󠅲', strict=True)

    def test_uts46_838(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߙ.ۮ\U000c6f83≯󠅲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߙ.ۮ\U000c6f83≯󠅲', strict=True)

    def test_uts46_839(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0sb.xn--bmb691l0524t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0sb.xn--bmb691l0524t', strict=True)

    def test_uts46_840(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᩳ\U000da678.𐭍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᩳ\U000da678.𐭍', strict=True)

    def test_uts46_841(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2of22352n.xn--q09c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2of22352n.xn--q09c', strict=True)

    def test_uts46_842(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒉\U000e0293≠｡Ⴟ⬣Ⴈ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒉\U000e0293≠｡Ⴟ⬣Ⴈ', strict=True)

    def test_uts46_843(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒉\U000e0293≠｡Ⴟ⬣Ⴈ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒉\U000e0293≠｡Ⴟ⬣Ⴈ', strict=True)

    def test_uts46_844(self):
        self.assertRaises(idna.IDNAError, idna.decode, '2.\U000e0293≠。Ⴟ⬣Ⴈ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '2.\U000e0293≠。Ⴟ⬣Ⴈ', strict=True)

    def test_uts46_845(self):
        self.assertRaises(idna.IDNAError, idna.decode, '2.\U000e0293≠。Ⴟ⬣Ⴈ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '2.\U000e0293≠。Ⴟ⬣Ⴈ', strict=True)

    def test_uts46_846(self):
        self.assertRaises(idna.IDNAError, idna.decode, '2.\U000e0293≠。ⴟ⬣ⴈ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '2.\U000e0293≠。ⴟ⬣ⴈ', strict=True)

    def test_uts46_847(self):
        self.assertRaises(idna.IDNAError, idna.decode, '2.\U000e0293≠。ⴟ⬣ⴈ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '2.\U000e0293≠。ⴟ⬣ⴈ', strict=True)

    def test_uts46_848(self):
        self.assertRaises(idna.IDNAError, idna.decode, '2.xn--1chz4101l.xn--45iz7d6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '2.xn--1chz4101l.xn--45iz7d6b', strict=True)

    def test_uts46_849(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒉\U000e0293≠｡ⴟ⬣ⴈ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒉\U000e0293≠｡ⴟ⬣ⴈ', strict=True)

    def test_uts46_850(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒉\U000e0293≠｡ⴟ⬣ⴈ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒉\U000e0293≠｡ⴟ⬣ⴈ', strict=True)

    def test_uts46_851(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch07f91401d.xn--45iz7d6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch07f91401d.xn--45iz7d6b', strict=True)

    def test_uts46_852(self):
        self.assertRaises(idna.IDNAError, idna.decode, '2.xn--1chz4101l.xn--gnd9b297j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '2.xn--1chz4101l.xn--gnd9b297j', strict=True)

    def test_uts46_853(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch07f91401d.xn--gnd9b297j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch07f91401d.xn--gnd9b297j', strict=True)

    def test_uts46_854(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\U000e0271ྸჅ。-𐹽ݴ𞣑', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\U000e0271ྸჅ。-𐹽ݴ𞣑', strict=True)

    def test_uts46_855(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\U000e0271ྸⴥ。-𐹽ݴ𞣑', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\U000e0271ྸⴥ。-𐹽ݴ𞣑', strict=True)

    def test_uts46_856(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----xmg317tgv352a.xn----05c4213ryr0g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----xmg317tgv352a.xn----05c4213ryr0g', strict=True)

    def test_uts46_857(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----xmg12fm2555h.xn----05c4213ryr0g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----xmg12fm2555h.xn----05c4213ryr0g', strict=True)

    def test_uts46_858(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٙ。𑄴︒اߝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٙ。𑄴︒اߝ', strict=True)

    def test_uts46_859(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٙ。𑄴。اߝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٙ。𑄴。اߝ', strict=True)

    def test_uts46_860(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1hb.xn--w80d.xn--mgb09f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1hb.xn--w80d.xn--mgb09f', strict=True)

    def test_uts46_861(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1hb.xn--mgb09fp820c08pa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1hb.xn--mgb09fp820c08pa', strict=True)

    def test_uts46_862(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴙظ.󠆓\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴙظ.󠆓\u200d', strict=True)

    def test_uts46_863(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴙظ.󠆓\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴙظ.󠆓\u200d', strict=True)

    def test_uts46_864(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3gb910r.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3gb910r.', strict=True)

    def test_uts46_865(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3gb910r.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3gb910r.xn--1ug', strict=True)

    def test_uts46_866(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3gb194c.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3gb194c.', strict=True)

    def test_uts46_867(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3gb194c.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3gb194c.xn--1ug', strict=True)

    def test_uts46_868(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆸｡₆０𐺧ݖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆸｡₆０𐺧ݖ', strict=True)

    def test_uts46_869(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆸。60𐺧ݖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆸。60𐺧ݖ', strict=True)

    def test_uts46_870(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--60-cke9470y', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--60-cke9470y', strict=True)

    def test_uts46_871(self):
        self.assertRaises(idna.IDNAError, idna.decode, '6ࡏ｡-𑈴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '6ࡏ｡-𑈴', strict=True)

    def test_uts46_872(self):
        self.assertRaises(idna.IDNAError, idna.decode, '6ࡏ。-𑈴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '6ࡏ。-𑈴', strict=True)

    def test_uts46_873(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6-jjd.xn----6n8i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6-jjd.xn----6n8i', strict=True)

    def test_uts46_874(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U0004b33f𐹰｡્ς\U0001ec0eࣖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U0004b33f𐹰｡્ς\U0001ec0eࣖ', strict=True)

    def test_uts46_875(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U0004b33f𐹰。્ς\U0001ec0eࣖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U0004b33f𐹰。્ς\U0001ec0eࣖ', strict=True)

    def test_uts46_876(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U0004b33f𐹰。્Σ\U0001ec0eࣖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U0004b33f𐹰。્Σ\U0001ec0eࣖ', strict=True)

    def test_uts46_877(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U0004b33f𐹰。્σ\U0001ec0eࣖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U0004b33f𐹰。્σ\U0001ec0eࣖ', strict=True)

    def test_uts46_878(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--oo0d1330n.xn--4xa21xcwbfz15g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--oo0d1330n.xn--4xa21xcwbfz15g', strict=True)

    def test_uts46_879(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ugx105gq26y.xn--4xa21xcwbfz15g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ugx105gq26y.xn--4xa21xcwbfz15g', strict=True)

    def test_uts46_880(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ugx105gq26y.xn--3xa41xcwbfz15g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ugx105gq26y.xn--3xa41xcwbfz15g', strict=True)

    def test_uts46_881(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U0004b33f𐹰｡્Σ\U0001ec0eࣖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U0004b33f𐹰｡્Σ\U0001ec0eࣖ', strict=True)

    def test_uts46_882(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U0004b33f𐹰｡્σ\U0001ec0eࣖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U0004b33f𐹰｡્σ\U0001ec0eࣖ', strict=True)

    def test_uts46_883(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈\U0005f11cႳ⒪．්\U00098636ࢋ𐹢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈\U0005f11cႳ⒪．්\U00098636ࢋ𐹢', strict=True)

    def test_uts46_884(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.\U0005f11cႳ(o).්\U00098636ࢋ𐹢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.\U0005f11cႳ(o).්\U00098636ࢋ𐹢', strict=True)

    def test_uts46_885(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.\U0005f11cⴓ(o).්\U00098636ࢋ𐹢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.\U0005f11cⴓ(o).්\U00098636ࢋ𐹢', strict=True)

    def test_uts46_886(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.\U0005f11cႳ(O).්\U00098636ࢋ𐹢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.\U0005f11cႳ(O).්\U00098636ࢋ𐹢', strict=True)

    def test_uts46_887(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--(o)-ej1bu5389e.xn--3xb99xpx1yoes3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--(o)-ej1bu5389e.xn--3xb99xpx1yoes3e', strict=True)

    def test_uts46_888(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈\U0005f11cⴓ⒪．්\U00098636ࢋ𐹢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈\U0005f11cⴓ⒪．්\U00098636ࢋ𐹢', strict=True)

    def test_uts46_889(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--(o)-ge4ax01c3t74t.xn--3xb99xpx1yoes3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--(o)-ge4ax01c3t74t.xn--3xb99xpx1yoes3e', strict=True)

    def test_uts46_890(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--(o)-7sn88849j.xn--3xb99xpx1yoes3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--(o)-7sn88849j.xn--3xb99xpx1yoes3e', strict=True)

    def test_uts46_891(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tsh0ds63atl31n.xn--3xb99xpx1yoes3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tsh0ds63atl31n.xn--3xb99xpx1yoes3e', strict=True)

    def test_uts46_892(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rnd762h7cx3027d.xn--3xb99xpx1yoes3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rnd762h7cx3027d.xn--3xb99xpx1yoes3e', strict=True)

    def test_uts46_893(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤷.𐮐𞢁𐹠ؤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤷.𐮐𞢁𐹠ؤ', strict=True)

    def test_uts46_894(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤷.𐮐𞢁𐹠ؤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤷.𐮐𞢁𐹠ؤ', strict=True)

    def test_uts46_895(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤕.𐮐𞢁𐹠ؤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤕.𐮐𞢁𐹠ؤ', strict=True)

    def test_uts46_896(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤕.𐮐𞢁𐹠ؤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤕.𐮐𞢁𐹠ؤ', strict=True)

    def test_uts46_897(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ve6h.xn--jgb1694kz0b2176a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ve6h.xn--jgb1694kz0b2176a', strict=True)

    def test_uts46_898(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐲈-｡𑄳\U0006233b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐲈-｡𑄳\U0006233b', strict=True)

    def test_uts46_899(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐲈-。𑄳\U0006233b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐲈-。𑄳\U0006233b', strict=True)

    def test_uts46_900(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐳈-。𑄳\U0006233b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐳈-。𑄳\U0006233b', strict=True)

    def test_uts46_901(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ue6i.xn--v80d6662t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ue6i.xn--v80d6662t', strict=True)

    def test_uts46_902(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐳈-｡𑄳\U0006233b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐳈-｡𑄳\U0006233b', strict=True)

    def test_uts46_903(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\U000e0256ꡧ．\U000e0282\U00047183🄉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\U000e0256ꡧ．\U000e0282\U00047183🄉', strict=True)

    def test_uts46_904(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\U000e0256ꡧ.\U000e0282\U000471838,', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\U000e0256ꡧ.\U000e0282\U000471838,', strict=True)

    def test_uts46_905(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----hg4ei0361g.xn--8,-k362evu488a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----hg4ei0361g.xn--8,-k362evu488a', strict=True)

    def test_uts46_906(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----hg4ei0361g.xn--207ht163h7m94c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----hg4ei0361g.xn--207ht163h7m94c', strict=True)

    def test_uts46_907(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0f9b\U000e0234臯𧔤.ݨ𝟝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0f9b\U000e0234臯𧔤.ݨ𝟝', strict=True)

    def test_uts46_908(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0f9b\U000e0234臯𧔤.ݨ5', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0f9b\U000e0234臯𧔤.ݨ5', strict=True)

    def test_uts46_909(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zb1at733hm579ddhla.xn--5-b5c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zb1at733hm579ddhla.xn--5-b5c', strict=True)

    def test_uts46_910(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮𐹣．𝨿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮𐹣．𝨿', strict=True)

    def test_uts46_911(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮𐹣．𝨿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮𐹣．𝨿', strict=True)

    def test_uts46_912(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮𐹣.𝨿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮𐹣.𝨿', strict=True)

    def test_uts46_913(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮𐹣.𝨿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮𐹣.𝨿', strict=True)

    def test_uts46_914(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh1504g.xn--e92h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh1504g.xn--e92h', strict=True)

    def test_uts46_915(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹯ᯛ੍｡脥', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹯ᯛ੍｡脥', strict=True)

    def test_uts46_916(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹯ᯛ੍。脥', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹯ᯛ੍。脥', strict=True)

    def test_uts46_917(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ybc101g3m1p.xn--740a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ybc101g3m1p.xn--740a', strict=True)

    def test_uts46_918(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᭄ᅟ\U0001edff\U0008300d.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᭄ᅟ\U0001edff\U0008300d.-', strict=True)

    def test_uts46_919(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1uf9538sxny9a.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1uf9538sxny9a.-', strict=True)

    def test_uts46_920(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--osd971cpx70btgt8b.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--osd971cpx70btgt8b.-', strict=True)

    def test_uts46_921(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c｡͔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c｡͔', strict=True)

    def test_uts46_922(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c。͔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c。͔', strict=True)

    def test_uts46_923(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--yua', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--yua', strict=True)

    def test_uts46_924(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--yua', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--yua', strict=True)

    def test_uts46_925(self):
        self.assertEqual(idna.decode('𞤥󠅮．ᡄႮ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤥󠅮．ᡄႮ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_926(self):
        self.assertEqual(idna.decode('𞤥󠅮.ᡄႮ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤥󠅮.ᡄႮ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_927(self):
        self.assertEqual(idna.decode('𞤥󠅮.ᡄⴎ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤥󠅮.ᡄⴎ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_928(self):
        self.assertEqual(idna.decode('𞤃󠅮.ᡄႮ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤃󠅮.ᡄႮ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_929(self):
        self.assertEqual(idna.decode('𞤃󠅮.ᡄⴎ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤃󠅮.ᡄⴎ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_930(self):
        self.assertEqual(idna.decode('xn--de6h.xn--37e857h', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('xn--de6h.xn--37e857h', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_931(self):
        self.assertEqual(idna.decode('𞤥.ᡄⴎ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤥.ᡄⴎ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_932(self):
        self.assertEqual(idna.decode('𞤃.ᡄႮ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤃.ᡄႮ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_933(self):
        self.assertEqual(idna.decode('𞤃.ᡄⴎ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤃.ᡄⴎ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_934(self):
        self.assertEqual(idna.decode('𞤥󠅮．ᡄⴎ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤥󠅮．ᡄⴎ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_935(self):
        self.assertEqual(idna.decode('𞤃󠅮．ᡄႮ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤃󠅮．ᡄႮ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_936(self):
        self.assertEqual(idna.decode('𞤃󠅮．ᡄⴎ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤃󠅮．ᡄⴎ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_937(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--de6h.xn--mnd799a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--de6h.xn--mnd799a', strict=True)

    def test_uts46_938(self):
        self.assertEqual(idna.decode('𞤥.ᡄႮ', uts46=True, strict=True), '𞤥.ᡄⴎ')
        self.assertEqual(idna.encode('𞤥.ᡄႮ', uts46=True, strict=True), b'xn--de6h.xn--37e857h')

    def test_uts46_939(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤧𝨨Ξ．𪺏㛨❸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤧𝨨Ξ．𪺏㛨❸', strict=True)

    def test_uts46_940(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤧𝨨Ξ.𪺏㛨❸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤧𝨨Ξ.𪺏㛨❸', strict=True)

    def test_uts46_941(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤧𝨨ξ.𪺏㛨❸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤧𝨨ξ.𪺏㛨❸', strict=True)

    def test_uts46_942(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤅𝨨Ξ.𪺏㛨❸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤅𝨨Ξ.𪺏㛨❸', strict=True)

    def test_uts46_943(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤅𝨨ξ.𪺏㛨❸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤅𝨨ξ.𪺏㛨❸', strict=True)

    def test_uts46_944(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zxa5691vboja.xn--bfi293ci119b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zxa5691vboja.xn--bfi293ci119b', strict=True)

    def test_uts46_945(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤧𝨨ξ．𪺏㛨❸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤧𝨨ξ．𪺏㛨❸', strict=True)

    def test_uts46_946(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤅𝨨Ξ．𪺏㛨❸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤅𝨨Ξ．𪺏㛨❸', strict=True)

    def test_uts46_947(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤅𝨨ξ．𪺏㛨❸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤅𝨨ξ．𪺏㛨❸', strict=True)

    def test_uts46_948(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠆몆\u200c-｡Ⴛ𐦅︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠆몆\u200c-｡Ⴛ𐦅︒', strict=True)

    def test_uts46_949(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠆몆\u200c-｡Ⴛ𐦅︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠆몆\u200c-｡Ⴛ𐦅︒', strict=True)

    def test_uts46_950(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠆몆\u200c-。Ⴛ𐦅。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠆몆\u200c-。Ⴛ𐦅。', strict=True)

    def test_uts46_951(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠆몆\u200c-。Ⴛ𐦅。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠆몆\u200c-。Ⴛ𐦅。', strict=True)

    def test_uts46_952(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠆몆\u200c-。ⴛ𐦅。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠆몆\u200c-。ⴛ𐦅。', strict=True)

    def test_uts46_953(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠆몆\u200c-。ⴛ𐦅。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠆몆\u200c-。ⴛ𐦅。', strict=True)

    def test_uts46_954(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----e3j6620g.xn--jlju661e.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----e3j6620g.xn--jlju661e.', strict=True)

    def test_uts46_955(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----e3j425bsk1o.xn--jlju661e.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----e3j425bsk1o.xn--jlju661e.', strict=True)

    def test_uts46_956(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠆몆\u200c-｡ⴛ𐦅︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠆몆\u200c-｡ⴛ𐦅︒', strict=True)

    def test_uts46_957(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠆몆\u200c-｡ⴛ𐦅︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠆몆\u200c-｡ⴛ𐦅︒', strict=True)

    def test_uts46_958(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----e3j6620g.xn--jlj4997dhgh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----e3j6620g.xn--jlj4997dhgh', strict=True)

    def test_uts46_959(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----e3j425bsk1o.xn--jlj4997dhgh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----e3j425bsk1o.xn--jlj4997dhgh', strict=True)

    def test_uts46_960(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----e3j6620g.xn--znd4948j.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----e3j6620g.xn--znd4948j.', strict=True)

    def test_uts46_961(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----e3j425bsk1o.xn--znd4948j.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----e3j425bsk1o.xn--znd4948j.', strict=True)

    def test_uts46_962(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----e3j6620g.xn--znd2362jhgh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----e3j6620g.xn--znd2362jhgh', strict=True)

    def test_uts46_963(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----e3j425bsk1o.xn--znd2362jhgh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----e3j425bsk1o.xn--znd2362jhgh', strict=True)

    def test_uts46_964(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0fb3.︒⥱\u200c𐹬', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0fb3.︒⥱\u200c𐹬', strict=True)

    def test_uts46_965(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0fb3.。⥱\u200c𐹬', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0fb3.。⥱\u200c𐹬', strict=True)

    def test_uts46_966(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--uf66e..xn--qti2829e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--uf66e..xn--qti2829e', strict=True)

    def test_uts46_967(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--uf66e..xn--0ugz28as66q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--uf66e..xn--0ugz28as66q', strict=True)

    def test_uts46_968(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--uf66e.xn--qtiz073e3ik', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--uf66e.xn--qtiz073e3ik', strict=True)

    def test_uts46_969(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--uf66e.xn--0ugz28axl3pqxna', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--uf66e.xn--0ugz28axl3pqxna', strict=True)

    def test_uts46_970(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010bd6.𐹠Ⴑ\U0005a1dc𐫊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010bd6.𐹠Ⴑ\U0005a1dc𐫊', strict=True)

    def test_uts46_971(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010bd6.𐹠ⴑ\U0005a1dc𐫊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010bd6.𐹠ⴑ\U0005a1dc𐫊', strict=True)

    def test_uts46_972(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n49c.xn--8kj8702ewicl862o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n49c.xn--8kj8702ewicl862o', strict=True)

    def test_uts46_973(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n49c.xn--pnd4619jwicl862o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n49c.xn--pnd4619jwicl862o', strict=True)

    def test_uts46_974(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ྤ\U0007192f．𝟭Ⴛ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ྤ\U0007192f．𝟭Ⴛ', strict=True)

    def test_uts46_975(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ྤ\U0007192f.1Ⴛ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ྤ\U0007192f.1Ⴛ', strict=True)

    def test_uts46_976(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ྤ\U0007192f.1ⴛ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ྤ\U0007192f.1ⴛ', strict=True)

    def test_uts46_977(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0fd40533g.xn--1-tws', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0fd40533g.xn--1-tws', strict=True)

    def test_uts46_978(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ྤ\U0007192f．𝟭ⴛ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ྤ\U0007192f．𝟭ⴛ', strict=True)

    def test_uts46_979(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0fd40533g.xn--1-q1g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0fd40533g.xn--1-q1g', strict=True)

    def test_uts46_980(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ࠦ齀。릿\U00010e0b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ࠦ齀。릿\U00010e0b', strict=True)

    def test_uts46_981(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ࠦ齀。릿\U00010e0b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ࠦ齀。릿\U00010e0b', strict=True)

    def test_uts46_982(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----6gd0617i.xn--7y2bm55m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----6gd0617i.xn--7y2bm55m', strict=True)

    def test_uts46_983(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e050aܜ鹝꾗。\U0007ed50\u200d\u200d⏃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e050aܜ鹝꾗。\U0007ed50\u200d\u200d⏃', strict=True)

    def test_uts46_984(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e050aܜ鹝꾗。\U0007ed50\u200d\u200d⏃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e050aܜ鹝꾗。\U0007ed50\u200d\u200d⏃', strict=True)

    def test_uts46_985(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mnb6558e91kyq533a.xn--6mh27269e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mnb6558e91kyq533a.xn--6mh27269e', strict=True)

    def test_uts46_986(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mnb6558e91kyq533a.xn--1uga46zs309y', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mnb6558e91kyq533a.xn--1uga46zs309y', strict=True)

    def test_uts46_987(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮．-܈--', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮．-܈--', strict=True)

    def test_uts46_988(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮．-܈--', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮．-܈--', strict=True)

    def test_uts46_989(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮.-܈--', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮.-܈--', strict=True)

    def test_uts46_990(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮.-܈--', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮.-܈--', strict=True)

    def test_uts46_991(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh.xn------eqf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh.xn------eqf', strict=True)

    def test_uts46_992(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹸\U000e02f3。\u200dς𝟩', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹸\U000e02f3。\u200dς𝟩', strict=True)

    def test_uts46_993(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹸\U000e02f3。\u200dς7', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹸\U000e02f3。\u200dς7', strict=True)

    def test_uts46_994(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹸\U000e02f3。\u200dΣ7', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹸\U000e02f3。\u200dΣ7', strict=True)

    def test_uts46_995(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹸\U000e02f3。\u200dσ7', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹸\U000e02f3。\u200dσ7', strict=True)

    def test_uts46_996(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wo0di5177c.xn--7-zmb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wo0di5177c.xn--7-zmb', strict=True)

    def test_uts46_997(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wo0di5177c.xn--7-zmb938s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wo0di5177c.xn--7-zmb938s', strict=True)

    def test_uts46_998(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wo0di5177c.xn--7-xmb248s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wo0di5177c.xn--7-xmb248s', strict=True)

    def test_uts46_999(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹸\U000e02f3。\u200dΣ𝟩', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹸\U000e02f3。\u200dΣ𝟩', strict=True)

    def test_uts46_1000(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹸\U000e02f3。\u200dσ𝟩', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹸\U000e02f3。\u200dσ𝟩', strict=True)

    def test_uts46_1001(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς\U0008570c８.\U0001eb64', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς\U0008570c８.\U0001eb64', strict=True)

    def test_uts46_1002(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς\U0008570c8.\U0001eb64', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς\U0008570c8.\U0001eb64', strict=True)

    def test_uts46_1003(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ\U0008570c8.\U0001eb64', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ\U0008570c8.\U0001eb64', strict=True)

    def test_uts46_1004(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ\U0008570c8.\U0001eb64', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ\U0008570c8.\U0001eb64', strict=True)

    def test_uts46_1005(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8-zmb14974n.xn--su6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8-zmb14974n.xn--su6h', strict=True)

    def test_uts46_1006(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8-xmb44974n.xn--su6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8-xmb44974n.xn--su6h', strict=True)

    def test_uts46_1007(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ\U0008570c８.\U0001eb64', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ\U0008570c８.\U0001eb64', strict=True)

    def test_uts46_1008(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ\U0008570c８.\U0001eb64', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ\U0008570c８.\U0001eb64', strict=True)

    def test_uts46_1009(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cᡑ🄀ڄ．-𐫄𑲤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cᡑ🄀ڄ．-𐫄𑲤', strict=True)

    def test_uts46_1010(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cᡑ0.ڄ.-𐫄𑲤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cᡑ0.ڄ.-𐫄𑲤', strict=True)

    def test_uts46_1011(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0-o7j.xn--9ib.xn----ek5i065b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0-o7j.xn--9ib.xn----ek5i065b', strict=True)

    def test_uts46_1012(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0-o7j263b.xn--9ib.xn----ek5i065b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0-o7j263b.xn--9ib.xn----ek5i065b', strict=True)

    def test_uts46_1013(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ib722gbw95a.xn----ek5i065b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ib722gbw95a.xn----ek5i065b', strict=True)

    def test_uts46_1014(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ib722gvtfi563c.xn----ek5i065b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ib722gvtfi563c.xn----ek5i065b', strict=True)

    def test_uts46_1015(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𖠍。\U00010abf넯\U0009ed72', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𖠍。\U00010abf넯\U0009ed72', strict=True)

    def test_uts46_1016(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𖠍。\U00010abf넯\U0009ed72', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𖠍。\U00010abf넯\U0009ed72', strict=True)

    def test_uts46_1017(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4e9e.xn--l60bj21opd57g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4e9e.xn--l60bj21opd57g', strict=True)

    def test_uts46_1018(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠇Ⴘ。\u0603Ⴈ𝆊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠇Ⴘ。\u0603Ⴈ𝆊', strict=True)

    def test_uts46_1019(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᠇ⴘ。\u0603ⴈ𝆊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᠇ⴘ。\u0603ⴈ𝆊', strict=True)

    def test_uts46_1020(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--d6e009h.xn--lfb290rfu3z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--d6e009h.xn--lfb290rfu3z', strict=True)

    def test_uts46_1021(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wnd558a.xn--lfb465c1v87a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wnd558a.xn--lfb465c1v87a', strict=True)

    def test_uts46_1022(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒚\U000e02d1𞤰。牣٧Ⴜᣥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒚\U000e02d1𞤰。牣٧Ⴜᣥ', strict=True)

    def test_uts46_1023(self):
        self.assertRaises(idna.IDNAError, idna.decode, '19.\U000e02d1𞤰。牣٧Ⴜᣥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '19.\U000e02d1𞤰。牣٧Ⴜᣥ', strict=True)

    def test_uts46_1024(self):
        self.assertRaises(idna.IDNAError, idna.decode, '19.\U000e02d1𞤰。牣٧ⴜᣥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '19.\U000e02d1𞤰。牣٧ⴜᣥ', strict=True)

    def test_uts46_1025(self):
        self.assertRaises(idna.IDNAError, idna.decode, '19.\U000e02d1𞤎。牣٧Ⴜᣥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '19.\U000e02d1𞤎。牣٧Ⴜᣥ', strict=True)

    def test_uts46_1026(self):
        self.assertRaises(idna.IDNAError, idna.decode, '19.\U000e02d1𞤎。牣٧ⴜᣥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '19.\U000e02d1𞤎。牣٧ⴜᣥ', strict=True)

    def test_uts46_1027(self):
        self.assertRaises(idna.IDNAError, idna.decode, '19.xn--oe6h75760c.xn--gib285gtxo2l9d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '19.xn--oe6h75760c.xn--gib285gtxo2l9d', strict=True)

    def test_uts46_1028(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒚\U000e02d1𞤰。牣٧ⴜᣥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒚\U000e02d1𞤰。牣٧ⴜᣥ', strict=True)

    def test_uts46_1029(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒚\U000e02d1𞤎。牣٧Ⴜᣥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒚\U000e02d1𞤎。牣٧Ⴜᣥ', strict=True)

    def test_uts46_1030(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒚\U000e02d1𞤎。牣٧ⴜᣥ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒚\U000e02d1𞤎。牣٧ⴜᣥ', strict=True)

    def test_uts46_1031(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cthy466n29j3e.xn--gib285gtxo2l9d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cthy466n29j3e.xn--gib285gtxo2l9d', strict=True)

    def test_uts46_1032(self):
        self.assertRaises(idna.IDNAError, idna.decode, '19.xn--oe6h75760c.xn--gib404ccxgh00h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '19.xn--oe6h75760c.xn--gib404ccxgh00h', strict=True)

    def test_uts46_1033(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cthy466n29j3e.xn--gib404ccxgh00h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cthy466n29j3e.xn--gib404ccxgh00h', strict=True)

    def test_uts46_1034(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𐋱𐰽⒈.Ⴓ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𐋱𐰽⒈.Ⴓ', strict=True)

    def test_uts46_1035(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𐋱𐰽1..Ⴓ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𐋱𐰽1..Ⴓ', strict=True)

    def test_uts46_1036(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𐋱𐰽1..ⴓ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𐋱𐰽1..ⴓ', strict=True)

    def test_uts46_1037(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---1-895nq11a..xn--blj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---1-895nq11a..xn--blj', strict=True)

    def test_uts46_1038(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𐋱𐰽⒈.ⴓ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𐋱𐰽⒈.ⴓ', strict=True)

    def test_uts46_1039(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ecp0206g90h.xn--blj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ecp0206g90h.xn--blj', strict=True)

    def test_uts46_1040(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---1-895nq11a..xn--rnd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---1-895nq11a..xn--rnd', strict=True)

    def test_uts46_1041(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ecp0206g90h.xn--rnd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ecp0206g90h.xn--rnd', strict=True)

    def test_uts46_1042(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c긃.榶-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c긃.榶-', strict=True)

    def test_uts46_1043(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c긃.榶-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c긃.榶-', strict=True)

    def test_uts46_1044(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ej0b.xn----d87b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ej0b.xn----d87b', strict=True)

    def test_uts46_1045(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug3307c.xn----d87b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug3307c.xn----d87b', strict=True)

    def test_uts46_1046(self):
        self.assertRaises(idna.IDNAError, idna.decode, '뉓泓\U0001cd7d.্\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '뉓泓\U0001cd7d.্\u200d', strict=True)

    def test_uts46_1047(self):
        self.assertRaises(idna.IDNAError, idna.decode, '뉓泓\U0001cd7d.্\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '뉓泓\U0001cd7d.্\u200d', strict=True)

    def test_uts46_1048(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lwwp69lqs7m.xn--b7b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lwwp69lqs7m.xn--b7b', strict=True)

    def test_uts46_1049(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lwwp69lqs7m.xn--b7b605i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lwwp69lqs7m.xn--b7b605i', strict=True)

    def test_uts46_1050(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹴ß｡ິ\u2b75\U0006a14c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹴ß｡ິ\u2b75\U0006a14c', strict=True)

    def test_uts46_1051(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹴ß。ິ\u2b75\U0006a14c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹴ß。ິ\u2b75\U0006a14c', strict=True)

    def test_uts46_1052(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹴SS。ິ\u2b75\U0006a14c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹴SS。ິ\u2b75\U0006a14c', strict=True)

    def test_uts46_1053(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹴ss。ິ\u2b75\U0006a14c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹴ss。ິ\u2b75\U0006a14c', strict=True)

    def test_uts46_1054(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹴Ss。ິ\u2b75\U0006a14c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹴Ss。ິ\u2b75\U0006a14c', strict=True)

    def test_uts46_1055(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-ti3o.xn--57c638l8774i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-ti3o.xn--57c638l8774i', strict=True)

    def test_uts46_1056(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-l1t5169j.xn--57c638l8774i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-l1t5169j.xn--57c638l8774i', strict=True)

    def test_uts46_1057(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca770nip7n.xn--57c638l8774i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca770nip7n.xn--57c638l8774i', strict=True)

    def test_uts46_1058(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹴SS｡ິ\u2b75\U0006a14c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹴SS｡ິ\u2b75\U0006a14c', strict=True)

    def test_uts46_1059(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹴ss｡ິ\u2b75\U0006a14c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹴ss｡ິ\u2b75\U0006a14c', strict=True)

    def test_uts46_1060(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹴Ss｡ິ\u2b75\U0006a14c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹴Ss｡ິ\u2b75\U0006a14c', strict=True)

    def test_uts46_1061(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᭄．᮪-≮≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᭄．᮪-≮≠', strict=True)

    def test_uts46_1062(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᭄．᮪-≮≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᭄．᮪-≮≠', strict=True)

    def test_uts46_1063(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᭄.᮪-≮≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᭄.᮪-≮≠', strict=True)

    def test_uts46_1064(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᭄.᮪-≮≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᭄.᮪-≮≠', strict=True)

    def test_uts46_1065(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1uf.xn----nmlz65aub', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1uf.xn----nmlz65aub', strict=True)

    def test_uts46_1066(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᯳Ⴑᅟ．𑄴Ⅎ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᯳Ⴑᅟ．𑄴Ⅎ', strict=True)

    def test_uts46_1067(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᯳Ⴑᅟ.𑄴Ⅎ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᯳Ⴑᅟ.𑄴Ⅎ', strict=True)

    def test_uts46_1068(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᯳ⴑᅟ.𑄴ⅎ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᯳ⴑᅟ.𑄴ⅎ', strict=True)

    def test_uts46_1069(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᯳Ⴑᅟ.𑄴ⅎ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᯳Ⴑᅟ.𑄴ⅎ', strict=True)

    def test_uts46_1070(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1zf224e.xn--73g3065g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1zf224e.xn--73g3065g', strict=True)

    def test_uts46_1071(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᯳ⴑᅟ．𑄴ⅎ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᯳ⴑᅟ．𑄴ⅎ', strict=True)

    def test_uts46_1072(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᯳Ⴑᅟ．𑄴ⅎ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᯳Ⴑᅟ．𑄴ⅎ', strict=True)

    def test_uts46_1073(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pnd26a55x.xn--73g3065g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pnd26a55x.xn--73g3065g', strict=True)

    def test_uts46_1074(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--osd925cvyn.xn--73g3065g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--osd925cvyn.xn--73g3065g', strict=True)

    def test_uts46_1075(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pnd26a55x.xn--f3g7465g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pnd26a55x.xn--f3g7465g', strict=True)

    def test_uts46_1076(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001c246。Ⴃ𐴣𐹹똯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001c246。Ⴃ𐴣𐹹똯', strict=True)

    def test_uts46_1077(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001c246。Ⴃ𐴣𐹹똯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001c246。Ⴃ𐴣𐹹똯', strict=True)

    def test_uts46_1078(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001c246。ⴃ𐴣𐹹똯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001c246。ⴃ𐴣𐹹똯', strict=True)

    def test_uts46_1079(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001c246。ⴃ𐴣𐹹똯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001c246。ⴃ𐴣𐹹똯', strict=True)

    def test_uts46_1080(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--187g.xn--ukjy205b8rscdeb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--187g.xn--ukjy205b8rscdeb', strict=True)

    def test_uts46_1081(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--187g.xn--bnd4785f8r8bdeb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--187g.xn--bnd4785f8r8bdeb', strict=True)

    def test_uts46_1082(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫀｡⳻\U000e067e󠄷ㅤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫀｡⳻\U000e067e󠄷ㅤ', strict=True)

    def test_uts46_1083(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫀。⳻\U000e067e󠄷ᅠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫀。⳻\U000e067e󠄷ᅠ', strict=True)

    def test_uts46_1084(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pw9c.xn--mkjw9654i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pw9c.xn--mkjw9654i', strict=True)

    def test_uts46_1085(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pw9c.xn--psd742lxt32w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pw9c.xn--psd742lxt32w', strict=True)

    def test_uts46_1086(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pw9c.xn--mkj83l4v899a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pw9c.xn--mkj83l4v899a', strict=True)

    def test_uts46_1087(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ޚ⾇．ܞ-𐋰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ޚ⾇．ܞ-𐋰', strict=True)

    def test_uts46_1088(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ޚ舛.ܞ-𐋰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ޚ舛.ܞ-𐋰', strict=True)

    def test_uts46_1089(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7qb6383d.xn----20c3154q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7qb6383d.xn----20c3154q', strict=True)

    def test_uts46_1090(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴉ猕\U000f96eb≮．︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴉ猕\U000f96eb≮．︒', strict=True)

    def test_uts46_1091(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴉ猕\U000f96eb≮．︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴉ猕\U000f96eb≮．︒', strict=True)

    def test_uts46_1092(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴉ猕\U000f96eb≮.。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴉ猕\U000f96eb≮.。', strict=True)

    def test_uts46_1093(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴉ猕\U000f96eb≮.。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴉ猕\U000f96eb≮.。', strict=True)

    def test_uts46_1094(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴉ猕\U000f96eb≮.。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴉ猕\U000f96eb≮.。', strict=True)

    def test_uts46_1095(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴉ猕\U000f96eb≮.。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴉ猕\U000f96eb≮.。', strict=True)

    def test_uts46_1096(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh892bbz0d5438s..', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh892bbz0d5438s..', strict=True)

    def test_uts46_1097(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴉ猕\U000f96eb≮．︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴉ猕\U000f96eb≮．︒', strict=True)

    def test_uts46_1098(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴉ猕\U000f96eb≮．︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴉ猕\U000f96eb≮．︒', strict=True)

    def test_uts46_1099(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh892bbz0d5438s.xn--y86c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh892bbz0d5438s.xn--y86c', strict=True)

    def test_uts46_1100(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hnd212gz32d54x5r..', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hnd212gz32d54x5r..', strict=True)

    def test_uts46_1101(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hnd212gz32d54x5r.xn--y86c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hnd212gz32d54x5r.xn--y86c', strict=True)

    def test_uts46_1102(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🏮｡ث鳳ߢ󠅉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🏮｡ث鳳ߢ󠅉', strict=True)

    def test_uts46_1103(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🏮。ث鳳ߢ󠅉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🏮。ث鳳ߢ󠅉', strict=True)

    def test_uts46_1104(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8m8h.xn--qgb29f6z90a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8m8h.xn--qgb29f6z90a', strict=True)

    def test_uts46_1105(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹶。ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹶。ß', strict=True)

    def test_uts46_1106(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹶。SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹶。SS', strict=True)

    def test_uts46_1107(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹶。ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹶。ss', strict=True)

    def test_uts46_1108(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹶。Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹶。Ss', strict=True)

    def test_uts46_1109(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--uo0d.ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--uo0d.ss', strict=True)

    def test_uts46_1110(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug9105g.ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug9105g.ss', strict=True)

    def test_uts46_1111(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug9105g.xn--zca', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug9105g.xn--zca', strict=True)

    def test_uts46_1112(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Å둄-．\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Å둄-．\u200c', strict=True)

    def test_uts46_1113(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Å둄-．\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Å둄-．\u200c', strict=True)

    def test_uts46_1114(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Å둄-.\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Å둄-.\u200c', strict=True)

    def test_uts46_1115(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Å둄-.\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Å둄-.\u200c', strict=True)

    def test_uts46_1116(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'å둄-.\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'å둄-.\u200c', strict=True)

    def test_uts46_1117(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'å둄-.\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'å둄-.\u200c', strict=True)

    def test_uts46_1118(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----1fa1788k.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----1fa1788k.', strict=True)

    def test_uts46_1119(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----1fa1788k.xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----1fa1788k.xn--0ug', strict=True)

    def test_uts46_1120(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'å둄-．\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'å둄-．\u200c', strict=True)

    def test_uts46_1121(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'å둄-．\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'å둄-．\u200c', strict=True)

    def test_uts46_1122(self):
        self.assertRaises(idna.IDNAError, idna.decode, '゙\U000ac391ᷗ𞤀.\U000b1ca2-॓', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '゙\U000ac391ᷗ𞤀.\U000b1ca2-॓', strict=True)

    def test_uts46_1123(self):
        self.assertRaises(idna.IDNAError, idna.decode, '゙\U000ac391ᷗ𞤢.\U000b1ca2-॓', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '゙\U000ac391ᷗ𞤢.\U000b1ca2-॓', strict=True)

    def test_uts46_1124(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--veg121fwg63altj9d.xn----eyd92688s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--veg121fwg63altj9d.xn----eyd92688s', strict=True)

    def test_uts46_1125(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς.ß\U00074c44\u06dd⵿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς.ß\U00074c44\u06dd⵿', strict=True)

    def test_uts46_1126(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ.SS\U00074c44\u06dd⵿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ.SS\U00074c44\u06dd⵿', strict=True)

    def test_uts46_1127(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ.ss\U00074c44\u06dd⵿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ.ss\U00074c44\u06dd⵿', strict=True)

    def test_uts46_1128(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ.ss\U00074c44\u06dd⵿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ.ss\U00074c44\u06dd⵿', strict=True)

    def test_uts46_1129(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa.xn--ss-y8d4760biv60n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa.xn--ss-y8d4760biv60n', strict=True)

    def test_uts46_1130(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ.ß\U00074c44\u06dd⵿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ.ß\U00074c44\u06dd⵿', strict=True)

    def test_uts46_1131(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ.ß\U00074c44\u06dd⵿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ.ß\U00074c44\u06dd⵿', strict=True)

    def test_uts46_1132(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa.xn--zca281az71b8x73m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa.xn--zca281az71b8x73m', strict=True)

    def test_uts46_1133(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa.xn--zca281az71b8x73m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa.xn--zca281az71b8x73m', strict=True)

    def test_uts46_1134(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡀ𞀟｡٫֙', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡀ𞀟｡٫֙', strict=True)

    def test_uts46_1135(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡀ𞀟。٫֙', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡀ𞀟。٫֙', strict=True)

    def test_uts46_1136(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8b9a1720d.xn--kcb33b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8b9a1720d.xn--kcb33b', strict=True)

    def test_uts46_1137(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000886c9\u200cࢩ｡⧅\U00058621-𐭡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000886c9\u200cࢩ｡⧅\U00058621-𐭡', strict=True)

    def test_uts46_1138(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000886c9\u200cࢩ。⧅\U00058621-𐭡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000886c9\u200cࢩ。⧅\U00058621-𐭡', strict=True)

    def test_uts46_1139(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--yyb56242i.xn----zir1232guu71b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--yyb56242i.xn----zir1232guu71b', strict=True)

    def test_uts46_1140(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--yyb780jll63m.xn----zir1232guu71b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--yyb780jll63m.xn----zir1232guu71b', strict=True)

    def test_uts46_1141(self):
        self.assertRaises(idna.IDNAError, idna.decode, '룱\u200d𰍨\u200c。𝨖︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '룱\u200d𰍨\u200c。𝨖︒', strict=True)

    def test_uts46_1142(self):
        self.assertRaises(idna.IDNAError, idna.decode, '룱\u200d𰍨\u200c。𝨖︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '룱\u200d𰍨\u200c。𝨖︒', strict=True)

    def test_uts46_1143(self):
        self.assertRaises(idna.IDNAError, idna.decode, '룱\u200d𰍨\u200c。𝨖。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '룱\u200d𰍨\u200c。𝨖。', strict=True)

    def test_uts46_1144(self):
        self.assertRaises(idna.IDNAError, idna.decode, '룱\u200d𰍨\u200c。𝨖。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '룱\u200d𰍨\u200c。𝨖。', strict=True)

    def test_uts46_1145(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ct2b0738h.xn--772h.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ct2b0738h.xn--772h.', strict=True)

    def test_uts46_1146(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugb3358ili2v.xn--772h.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugb3358ili2v.xn--772h.', strict=True)

    def test_uts46_1147(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ct2b0738h.xn--y86cl899a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ct2b0738h.xn--y86cl899a', strict=True)

    def test_uts46_1148(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugb3358ili2v.xn--y86cl899a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugb3358ili2v.xn--y86cl899a', strict=True)

    def test_uts46_1149(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄄．᳜⒈ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄄．᳜⒈ß', strict=True)

    def test_uts46_1150(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3,.᳜1.ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3,.᳜1.ß', strict=True)

    def test_uts46_1151(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3,.᳜1.SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3,.᳜1.SS', strict=True)

    def test_uts46_1152(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3,.᳜1.ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3,.᳜1.ss', strict=True)

    def test_uts46_1153(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3,.᳜1.Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3,.᳜1.Ss', strict=True)

    def test_uts46_1154(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3,.xn--1-43l.ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3,.xn--1-43l.ss', strict=True)

    def test_uts46_1155(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3,.xn--1-43l.xn--zca', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3,.xn--1-43l.xn--zca', strict=True)

    def test_uts46_1156(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄄．᳜⒈SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄄．᳜⒈SS', strict=True)

    def test_uts46_1157(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄄．᳜⒈ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄄．᳜⒈ss', strict=True)

    def test_uts46_1158(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄄．᳜⒈Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄄．᳜⒈Ss', strict=True)

    def test_uts46_1159(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3,.xn--ss-k1r094b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3,.xn--ss-k1r094b', strict=True)

    def test_uts46_1160(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3,.xn--zca344lmif', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3,.xn--zca344lmif', strict=True)

    def test_uts46_1161(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--x07h.xn--ss-k1r094b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--x07h.xn--ss-k1r094b', strict=True)

    def test_uts46_1162(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--x07h.xn--zca344lmif', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--x07h.xn--zca344lmif', strict=True)

    def test_uts46_1163(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004730d⵿｡\U0001ef13\U000a1128𑐺', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004730d⵿｡\U0001ef13\U000a1128𑐺', strict=True)

    def test_uts46_1164(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004730d⵿。\U0001ef13\U000a1128𑐺', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004730d⵿。\U0001ef13\U000a1128𑐺', strict=True)

    def test_uts46_1165(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--eoj16016a.xn--0v1d3848a3lr0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--eoj16016a.xn--0v1d3848a3lr0d', strict=True)

    def test_uts46_1166(self):
        self.assertRaises(idna.IDNAError, idna.decode, '်्᷽．≠\u200d㇛', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '်्᷽．≠\u200d㇛', strict=True)

    def test_uts46_1167(self):
        self.assertRaises(idna.IDNAError, idna.decode, '်्᷽．≠\u200d㇛', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '်्᷽．≠\u200d㇛', strict=True)

    def test_uts46_1168(self):
        self.assertRaises(idna.IDNAError, idna.decode, '်्᷽．≠\u200d㇛', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '်्᷽．≠\u200d㇛', strict=True)

    def test_uts46_1169(self):
        self.assertRaises(idna.IDNAError, idna.decode, '်्᷽.≠\u200d㇛', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '်्᷽.≠\u200d㇛', strict=True)

    def test_uts46_1170(self):
        self.assertRaises(idna.IDNAError, idna.decode, '်्᷽.≠\u200d㇛', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '်्᷽.≠\u200d㇛', strict=True)

    def test_uts46_1171(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b956a9zm.xn--1ch912d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b956a9zm.xn--1ch912d', strict=True)

    def test_uts46_1172(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b956a9zm.xn--1ug63gz5w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b956a9zm.xn--1ug63gz5w', strict=True)

    def test_uts46_1173(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴁ𐋨娤.\u200d̼٢𑖿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴁ𐋨娤.\u200d̼٢𑖿', strict=True)

    def test_uts46_1174(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴁ𐋨娤.\u200d̼٢𑖿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴁ𐋨娤.\u200d̼٢𑖿', strict=True)

    def test_uts46_1175(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--skjw75lg29h.xn--9ta62nrv36a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--skjw75lg29h.xn--9ta62nrv36a', strict=True)

    def test_uts46_1176(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--skjw75lg29h.xn--9ta62ngt6aou8t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--skjw75lg29h.xn--9ta62ngt6aou8t', strict=True)

    def test_uts46_1177(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8md2578ag21g.xn--9ta62nrv36a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8md2578ag21g.xn--9ta62nrv36a', strict=True)

    def test_uts46_1178(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8md2578ag21g.xn--9ta62ngt6aou8t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8md2578ag21g.xn--9ta62ngt6aou8t', strict=True)

    def test_uts46_1179(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄀Ⴄ٩ࠠ。⒈ྶß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄀Ⴄ٩ࠠ。⒈ྶß', strict=True)

    def test_uts46_1180(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.Ⴄ٩ࠠ。1.ྶß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.Ⴄ٩ࠠ。1.ྶß', strict=True)

    def test_uts46_1181(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.ⴄ٩ࠠ。1.ྶß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.ⴄ٩ࠠ。1.ྶß', strict=True)

    def test_uts46_1182(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.Ⴄ٩ࠠ。1.ྶSS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.Ⴄ٩ࠠ。1.ྶSS', strict=True)

    def test_uts46_1183(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.ⴄ٩ࠠ。1.ྶss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.ⴄ٩ࠠ。1.ྶss', strict=True)

    def test_uts46_1184(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.Ⴄ٩ࠠ。1.ྶSs', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.Ⴄ٩ࠠ。1.ྶSs', strict=True)

    def test_uts46_1185(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.xn--iib29fp25e.1.xn--ss-1sj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.xn--iib29fp25e.1.xn--ss-1sj', strict=True)

    def test_uts46_1186(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.xn--iib29fp25e.1.xn--zca117e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.xn--iib29fp25e.1.xn--zca117e', strict=True)

    def test_uts46_1187(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄀ⴄ٩ࠠ。⒈ྶß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄀ⴄ٩ࠠ。⒈ྶß', strict=True)

    def test_uts46_1188(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄀Ⴄ٩ࠠ。⒈ྶSS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄀Ⴄ٩ࠠ。⒈ྶSS', strict=True)

    def test_uts46_1189(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄀ⴄ٩ࠠ。⒈ྶss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄀ⴄ٩ࠠ。⒈ྶss', strict=True)

    def test_uts46_1190(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄀Ⴄ٩ࠠ。⒈ྶSs', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄀Ⴄ٩ࠠ。⒈ྶSs', strict=True)

    def test_uts46_1191(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--iib29fp25e0219a.xn--ss-1sj588o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--iib29fp25e0219a.xn--ss-1sj588o', strict=True)

    def test_uts46_1192(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--iib29fp25e0219a.xn--zca117e3vp', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--iib29fp25e0219a.xn--zca117e3vp', strict=True)

    def test_uts46_1193(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.xn--iib29f26o.1.xn--ss-1sj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.xn--iib29f26o.1.xn--ss-1sj', strict=True)

    def test_uts46_1194(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.xn--iib29f26o.1.xn--zca117e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.xn--iib29f26o.1.xn--zca117e', strict=True)

    def test_uts46_1195(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--iib29f26o6n43c.xn--ss-1sj588o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--iib29f26o6n43c.xn--ss-1sj588o', strict=True)

    def test_uts46_1196(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--iib29f26o6n43c.xn--zca117e3vp', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--iib29f26o6n43c.xn--zca117e3vp', strict=True)

    def test_uts46_1197(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠.\u200c-٫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠.\u200c-٫', strict=True)

    def test_uts46_1198(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠.\u200c-٫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠.\u200c-٫', strict=True)

    def test_uts46_1199(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch.xn----vqc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch.xn----vqc', strict=True)

    def test_uts46_1200(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch.xn----vqc597q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch.xn----vqc597q', strict=True)

    def test_uts46_1201(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٠۱｡\U000e0cf6𞠁٥', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٠۱｡\U000e0cf6𞠁٥', strict=True)

    def test_uts46_1202(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٠۱。\U000e0cf6𞠁٥', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٠۱。\U000e0cf6𞠁٥', strict=True)

    def test_uts46_1203(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8hb40a.xn--eib7967vner3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8hb40a.xn--eib7967vner3e', strict=True)

    def test_uts46_1204(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c٣⒖。\U000f1149\U0003dddb᯳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c٣⒖。\U000f1149\U0003dddb᯳', strict=True)

    def test_uts46_1205(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c٣15.。\U000f1149\U0003dddb᯳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c٣15.。\U000f1149\U0003dddb᯳', strict=True)

    def test_uts46_1206(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--15-gyd..xn--1zf13512buy41d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--15-gyd..xn--1zf13512buy41d', strict=True)

    def test_uts46_1207(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--15-gyd983x..xn--1zf13512buy41d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--15-gyd983x..xn--1zf13512buy41d', strict=True)

    def test_uts46_1208(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cib675m.xn--1zf13512buy41d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cib675m.xn--1zf13512buy41d', strict=True)

    def test_uts46_1209(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cib152kwgd.xn--1zf13512buy41d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cib152kwgd.xn--1zf13512buy41d', strict=True)

    def test_uts46_1210(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᯳.-逋\U000739ad\U000d966e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᯳.-逋\U000739ad\U000d966e', strict=True)

    def test_uts46_1211(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1zf.xn----483d46987byr50b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1zf.xn----483d46987byr50b', strict=True)

    def test_uts46_1212(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݖ。ㅤ\u200dς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݖ。ㅤ\u200dς', strict=True)

    def test_uts46_1213(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݖ。ᅠ\u200dς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݖ。ᅠ\u200dς', strict=True)

    def test_uts46_1214(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݖ。ᅠ\u200dΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݖ。ᅠ\u200dΣ', strict=True)

    def test_uts46_1215(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݖ。ᅠ\u200dσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݖ。ᅠ\u200dσ', strict=True)

    def test_uts46_1216(self):
        self.assertEqual(idna.decode('xn--9ob.xn--4xa', uts46=True, strict=True), 'ݖ.σ')
        self.assertEqual(idna.encode('xn--9ob.xn--4xa', uts46=True, strict=True), b'xn--9ob.xn--4xa')

    def test_uts46_1217(self):
        self.assertEqual(idna.decode('ݖ.σ', uts46=True, strict=True), 'ݖ.σ')
        self.assertEqual(idna.encode('ݖ.σ', uts46=True, strict=True), b'xn--9ob.xn--4xa')

    def test_uts46_1218(self):
        self.assertEqual(idna.decode('ݖ.Σ', uts46=True, strict=True), 'ݖ.σ')
        self.assertEqual(idna.encode('ݖ.Σ', uts46=True, strict=True), b'xn--9ob.xn--4xa')

    def test_uts46_1219(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ob.xn--4xa795l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ob.xn--4xa795l', strict=True)

    def test_uts46_1220(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ob.xn--3xa995l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ob.xn--3xa995l', strict=True)

    def test_uts46_1221(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݖ。ㅤ\u200dΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݖ。ㅤ\u200dΣ', strict=True)

    def test_uts46_1222(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݖ。ㅤ\u200dσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݖ。ㅤ\u200dσ', strict=True)

    def test_uts46_1223(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ob.xn--4xa380e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ob.xn--4xa380e', strict=True)

    def test_uts46_1224(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ob.xn--4xa380ebol', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ob.xn--4xa380ebol', strict=True)

    def test_uts46_1225(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ob.xn--3xa580ebol', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ob.xn--3xa580ebol', strict=True)

    def test_uts46_1226(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ob.xn--4xa574u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ob.xn--4xa574u', strict=True)

    def test_uts46_1227(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ob.xn--4xa795lq2l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ob.xn--4xa795lq2l', strict=True)

    def test_uts46_1228(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ob.xn--3xa995lq2l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ob.xn--3xa995lq2l', strict=True)

    def test_uts46_1229(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡆႣ｡\U000de8a7̕\u200d\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡆႣ｡\U000de8a7̕\u200d\u200d', strict=True)

    def test_uts46_1230(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡆႣ。\U000de8a7̕\u200d\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡆႣ。\U000de8a7̕\u200d\u200d', strict=True)

    def test_uts46_1231(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡆⴃ。\U000de8a7̕\u200d\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡆⴃ。\U000de8a7̕\u200d\u200d', strict=True)

    def test_uts46_1232(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--57e237h.xn--5sa98523p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--57e237h.xn--5sa98523p', strict=True)

    def test_uts46_1233(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--57e237h.xn--5sa649la993427a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--57e237h.xn--5sa649la993427a', strict=True)

    def test_uts46_1234(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡆⴃ｡\U000de8a7̕\u200d\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡆⴃ｡\U000de8a7̕\u200d\u200d', strict=True)

    def test_uts46_1235(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bnd320b.xn--5sa98523p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bnd320b.xn--5sa98523p', strict=True)

    def test_uts46_1236(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bnd320b.xn--5sa649la993427a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bnd320b.xn--5sa649la993427a', strict=True)

    def test_uts46_1237(self):
        self.assertRaises(idna.IDNAError, idna.decode, '㭄\u200dࡏ𑚵．ς𐮮\u200c\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '㭄\u200dࡏ𑚵．ς𐮮\u200c\u200d', strict=True)

    def test_uts46_1238(self):
        self.assertRaises(idna.IDNAError, idna.decode, '㭄\u200dࡏ𑚵.ς𐮮\u200c\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '㭄\u200dࡏ𑚵.ς𐮮\u200c\u200d', strict=True)

    def test_uts46_1239(self):
        self.assertRaises(idna.IDNAError, idna.decode, '㭄\u200dࡏ𑚵.Σ𐮮\u200c\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '㭄\u200dࡏ𑚵.Σ𐮮\u200c\u200d', strict=True)

    def test_uts46_1240(self):
        self.assertRaises(idna.IDNAError, idna.decode, '㭄\u200dࡏ𑚵.σ𐮮\u200c\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '㭄\u200dࡏ𑚵.σ𐮮\u200c\u200d', strict=True)

    def test_uts46_1241(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ewb302xhu1l.xn--4xa0426k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ewb302xhu1l.xn--4xa0426k', strict=True)

    def test_uts46_1242(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ewb962jfitku4r.xn--4xa695lda6932v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ewb962jfitku4r.xn--4xa695lda6932v', strict=True)

    def test_uts46_1243(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ewb962jfitku4r.xn--3xa895lda6932v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ewb962jfitku4r.xn--3xa895lda6932v', strict=True)

    def test_uts46_1244(self):
        self.assertRaises(idna.IDNAError, idna.decode, '㭄\u200dࡏ𑚵．Σ𐮮\u200c\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '㭄\u200dࡏ𑚵．Σ𐮮\u200c\u200d', strict=True)

    def test_uts46_1245(self):
        self.assertRaises(idna.IDNAError, idna.decode, '㭄\u200dࡏ𑚵．σ𐮮\u200c\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '㭄\u200dࡏ𑚵．σ𐮮\u200c\u200d', strict=True)

    def test_uts46_1246(self):
        self.assertRaises(idna.IDNAError, idna.decode, '឵。\U0001ebf8ꡀ🄋', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '឵。\U0001ebf8ꡀ🄋', strict=True)

    def test_uts46_1247(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--8b9ar252dngd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--8b9ar252dngd', strict=True)

    def test_uts46_1248(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--03e.xn--8b9ar252dngd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--03e.xn--8b9ar252dngd', strict=True)

    def test_uts46_1249(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d0aba暑．⾑٨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d0aba暑．⾑٨', strict=True)

    def test_uts46_1250(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d0aba暑.襾٨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d0aba暑.襾٨', strict=True)

    def test_uts46_1251(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tlvq3513e.xn--hib9228d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tlvq3513e.xn--hib9228d', strict=True)

    def test_uts46_1252(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄚≯ꡢ。\u0891᷿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄚≯ꡢ。\u0891᷿', strict=True)

    def test_uts46_1253(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄚≯ꡢ。\u0891᷿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄚≯ꡢ。\u0891᷿', strict=True)

    def test_uts46_1254(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh7783c.xn--9xb680i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh7783c.xn--9xb680i', strict=True)

    def test_uts46_1255(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ﷃ𮁱୍𐨿.\U000d09e4Ⴗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ﷃ𮁱୍𐨿.\U000d09e4Ⴗ', strict=True)

    def test_uts46_1256(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'كمم𮁱୍𐨿.\U000d09e4Ⴗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'كمم𮁱୍𐨿.\U000d09e4Ⴗ', strict=True)

    def test_uts46_1257(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'كمم𮁱୍𐨿.\U000d09e4ⴗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'كمم𮁱୍𐨿.\U000d09e4ⴗ', strict=True)

    def test_uts46_1258(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fhbea662czx68a2tju.xn--fljz2846h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fhbea662czx68a2tju.xn--fljz2846h', strict=True)

    def test_uts46_1259(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ﷃ𮁱୍𐨿.\U000d09e4ⴗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ﷃ𮁱୍𐨿.\U000d09e4ⴗ', strict=True)

    def test_uts46_1260(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fhbea662czx68a2tju.xn--vnd55511o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fhbea662czx68a2tju.xn--vnd55511o', strict=True)

    def test_uts46_1261(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞀨｡᭄\U000a16e8\U0001e387', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞀨｡᭄\U000a16e8\U0001e387', strict=True)

    def test_uts46_1262(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞀨。᭄\U000a16e8\U0001e387', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞀨。᭄\U000a16e8\U0001e387', strict=True)

    def test_uts46_1263(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mi4h.xn--1uf6843smg20c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mi4h.xn--1uf6843smg20c', strict=True)

    def test_uts46_1264(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e08fc\u200c．𐺰\u200cᡟ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e08fc\u200c．𐺰\u200cᡟ', strict=True)

    def test_uts46_1265(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e08fc\u200c.𐺰\u200cᡟ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e08fc\u200c.𐺰\u200cᡟ', strict=True)

    def test_uts46_1266(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--q046e.xn--v8e7227j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--q046e.xn--v8e7227j', strict=True)

    def test_uts46_1267(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug18531l.xn--v8e340bp21t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug18531l.xn--v8e340bp21t', strict=True)

    def test_uts46_1268(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢛ\U000e815fß.ጧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢛ\U000e815fß.ጧ', strict=True)

    def test_uts46_1269(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢛ\U000e815fSS.ጧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢛ\U000e815fSS.ጧ', strict=True)

    def test_uts46_1270(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢛ\U000e815fss.ጧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢛ\U000e815fss.ጧ', strict=True)

    def test_uts46_1271(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢛ\U000e815fSs.ጧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢛ\U000e815fSs.ጧ', strict=True)

    def test_uts46_1272(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-7dp66033t.xn--p5d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-7dp66033t.xn--p5d', strict=True)

    def test_uts46_1273(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca562jc642x.xn--p5d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca562jc642x.xn--p5d', strict=True)

    def test_uts46_1274(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⮒\u200c.\U00052697\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⮒\u200c.\U00052697\u200c', strict=True)

    def test_uts46_1275(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b9i.xn--5p9y', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b9i.xn--5p9y', strict=True)

    def test_uts46_1276(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugx66b.xn--0ugz2871c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugx66b.xn--0ugz2871c', strict=True)

    def test_uts46_1277(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤂\U00079781𐹯。Ⴜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤂\U00079781𐹯。Ⴜ', strict=True)

    def test_uts46_1278(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤤\U00079781𐹯。ⴜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤤\U00079781𐹯。ⴜ', strict=True)

    def test_uts46_1279(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--no0dr648a51o3b.xn--klj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--no0dr648a51o3b.xn--klj', strict=True)

    def test_uts46_1280(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--no0dr648a51o3b.xn--0nd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--no0dr648a51o3b.xn--0nd', strict=True)

    def test_uts46_1281(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤂\U00079781𐹯。ⴜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤂\U00079781𐹯。ⴜ', strict=True)

    def test_uts46_1282(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹵⮣\u200c𑄰｡\U00077d3fﲷ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹵⮣\u200c𑄰｡\U00077d3fﲷ', strict=True)

    def test_uts46_1283(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹵⮣\u200c𑄰。\U00077d3fضم', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹵⮣\u200c𑄰。\U00077d3fضم', strict=True)

    def test_uts46_1284(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--s9i5458e7yb.xn--1gb4a66004i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--s9i5458e7yb.xn--1gb4a66004i', strict=True)

    def test_uts46_1285(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug586bcj8p7jc.xn--1gb4a66004i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug586bcj8p7jc.xn--1gb4a66004i', strict=True)

    def test_uts46_1286(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴒ。デß𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴒ。デß𞤵్', strict=True)

    def test_uts46_1287(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴒ。デß𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴒ。デß𞤵్', strict=True)

    def test_uts46_1288(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴒ。デß𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴒ。デß𞤵్', strict=True)

    def test_uts46_1289(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴒ。デß𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴒ。デß𞤵్', strict=True)

    def test_uts46_1290(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴒ。デSS𞤓్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴒ。デSS𞤓్', strict=True)

    def test_uts46_1291(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴒ。デSS𞤓్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴒ。デSS𞤓్', strict=True)

    def test_uts46_1292(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴒ。デss𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴒ。デss𞤵్', strict=True)

    def test_uts46_1293(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴒ。デss𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴒ。デss𞤵్', strict=True)

    def test_uts46_1294(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴒ。デSs𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴒ。デSs𞤵్', strict=True)

    def test_uts46_1295(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴒ。デSs𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴒ。デSs𞤵్', strict=True)

    def test_uts46_1296(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9kj.xn--ss-9nh3648ahh20b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9kj.xn--ss-9nh3648ahh20b', strict=True)

    def test_uts46_1297(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9kj.xn--zca669cmr3a0f28a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9kj.xn--zca669cmr3a0f28a', strict=True)

    def test_uts46_1298(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--qnd.xn--ss-9nh3648ahh20b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--qnd.xn--ss-9nh3648ahh20b', strict=True)

    def test_uts46_1299(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--qnd.xn--zca669cmr3a0f28a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--qnd.xn--zca669cmr3a0f28a', strict=True)

    def test_uts46_1300(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴒ。デSS𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴒ。デSS𞤵్', strict=True)

    def test_uts46_1301(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴒ。デSS𞤵్', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴒ。デSS𞤵్', strict=True)

    def test_uts46_1302(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑁿്．７-ߒ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑁿്．７-ߒ', strict=True)

    def test_uts46_1303(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑁿്.7-ߒ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑁿്.7-ߒ', strict=True)

    def test_uts46_1304(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wxc1283k.xn--7--yue', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wxc1283k.xn--7--yue', strict=True)

    def test_uts46_1305(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𑜫\U000e0b47.᜴\U000527a4𑍬ᢧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𑜫\U000e0b47.᜴\U000527a4𑍬ᢧ', strict=True)

    def test_uts46_1306(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𑜫\U000e0b47.᜴\U000527a4𑍬ᢧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𑜫\U000e0b47.᜴\U000527a4𑍬ᢧ', strict=True)

    def test_uts46_1307(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdhx157g68o0g.xn--c0e65eu616c34o7a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdhx157g68o0g.xn--c0e65eu616c34o7a', strict=True)

    def test_uts46_1308(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᷛ\U0008e419Ⴗ쏔。ށ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᷛ\U0008e419Ⴗ쏔。ށ', strict=True)

    def test_uts46_1309(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᷛ\U0008e419Ⴗ쏔。ށ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᷛ\U0008e419Ⴗ쏔。ށ', strict=True)

    def test_uts46_1310(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᷛ\U0008e419ⴗ쏔。ށ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᷛ\U0008e419ⴗ쏔。ށ', strict=True)

    def test_uts46_1311(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᷛ\U0008e419ⴗ쏔。ށ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᷛ\U0008e419ⴗ쏔。ށ', strict=True)

    def test_uts46_1312(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zegy26dw47iy6w2f.xn--iqb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zegy26dw47iy6w2f.xn--iqb', strict=True)

    def test_uts46_1313(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vnd148d733ky6n9e.xn--iqb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vnd148d733ky6n9e.xn--iqb', strict=True)

    def test_uts46_1314(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß｡𐋳Ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß｡𐋳Ⴌྸ', strict=True)

    def test_uts46_1315(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß。𐋳Ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß。𐋳Ⴌྸ', strict=True)

    def test_uts46_1316(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß。𐋳ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß。𐋳ⴌྸ', strict=True)

    def test_uts46_1317(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS。𐋳Ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS。𐋳Ⴌྸ', strict=True)

    def test_uts46_1318(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss。𐋳ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss。𐋳ⴌྸ', strict=True)

    def test_uts46_1319(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss。𐋳Ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss。𐋳Ⴌྸ', strict=True)

    def test_uts46_1320(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss.xn--lgd921mvv0m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss.xn--lgd921mvv0m', strict=True)

    def test_uts46_1321(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss.𐋳ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss.𐋳ⴌྸ', strict=True)

    def test_uts46_1322(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS.𐋳Ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS.𐋳Ⴌྸ', strict=True)

    def test_uts46_1323(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss.𐋳Ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss.𐋳Ⴌྸ', strict=True)

    def test_uts46_1324(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca.xn--lgd921mvv0m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca.xn--lgd921mvv0m', strict=True)

    def test_uts46_1325(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß.𐋳ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß.𐋳ⴌྸ', strict=True)

    def test_uts46_1326(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß｡𐋳ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß｡𐋳ⴌྸ', strict=True)

    def test_uts46_1327(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS｡𐋳Ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS｡𐋳Ⴌྸ', strict=True)

    def test_uts46_1328(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss｡𐋳ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss｡𐋳ⴌྸ', strict=True)

    def test_uts46_1329(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss｡𐋳Ⴌྸ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss｡𐋳Ⴌྸ', strict=True)

    def test_uts46_1330(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss.xn--lgd10cu829c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss.xn--lgd10cu829c', strict=True)

    def test_uts46_1331(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca.xn--lgd10cu829c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca.xn--lgd10cu829c', strict=True)

    def test_uts46_1332(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ڞ\U00010da1.\u200c⾝্', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ڞ\U00010da1.\u200c⾝্', strict=True)

    def test_uts46_1333(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ڞ\U00010da1.\u200c身্', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ڞ\U00010da1.\u200c身্', strict=True)

    def test_uts46_1334(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----stc7013r.xn--b7b1419d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----stc7013r.xn--b7b1419d', strict=True)

    def test_uts46_1335(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----stc7013r.xn--b7b305imj2f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----stc7013r.xn--b7b305imj2f', strict=True)

    def test_uts46_1336(self):
        self.assertRaises(idna.IDNAError, idna.decode, '😮ݤ𑈵𞀖.💅\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '😮ݤ𑈵𞀖.💅\u200d', strict=True)

    def test_uts46_1337(self):
        self.assertRaises(idna.IDNAError, idna.decode, '😮ݤ𑈵𞀖.💅\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '😮ݤ𑈵𞀖.💅\u200d', strict=True)

    def test_uts46_1338(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--opb4277kuc7elqsa.xn--kr8h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--opb4277kuc7elqsa.xn--kr8h', strict=True)

    def test_uts46_1339(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--opb4277kuc7elqsa.xn--1ug5265p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--opb4277kuc7elqsa.xn--1ug5265p', strict=True)

    def test_uts46_1340(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣲ\u200d꙳ܒ.ᢏ\u200c\U000e0344', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣲ\u200d꙳ܒ.ᢏ\u200c\U000e0344', strict=True)

    def test_uts46_1341(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cnb37gdy00a.xn--89e02253p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cnb37gdy00a.xn--89e02253p', strict=True)

    def test_uts46_1342(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cnb37g904be26j.xn--89e849ax9363a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cnb37g904be26j.xn--89e849ax9363a', strict=True)

    def test_uts46_1343(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴑ．ڿ\U0001ebd3ᠲ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴑ．ڿ\U0001ebd3ᠲ', strict=True)

    def test_uts46_1344(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴑ.ڿ\U0001ebd3ᠲ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴑ.ڿ\U0001ebd3ᠲ', strict=True)

    def test_uts46_1345(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴑ.ڿ\U0001ebd3ᠲ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴑ.ڿ\U0001ebd3ᠲ', strict=True)

    def test_uts46_1346(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8kj.xn--ykb840gd555a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8kj.xn--ykb840gd555a', strict=True)

    def test_uts46_1347(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴑ．ڿ\U0001ebd3ᠲ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴑ．ڿ\U0001ebd3ᠲ', strict=True)

    def test_uts46_1348(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pnd.xn--ykb840gd555a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pnd.xn--ykb840gd555a', strict=True)

    def test_uts46_1349(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᩚ\U0001b99d్。\U0001a76c𝟵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᩚ\U0001b99d్。\U0001a76c𝟵', strict=True)

    def test_uts46_1350(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᩚ\U0001b99d్。\U0001a76c9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᩚ\U0001b99d్。\U0001a76c9', strict=True)

    def test_uts46_1351(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lqc703ebm93a.xn--9-000p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lqc703ebm93a.xn--9-000p', strict=True)

    def test_uts46_1352(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cڠ\U0003fe86𝟗｡Ⴣ꒘ﳐ\U00050616', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cڠ\U0003fe86𝟗｡Ⴣ꒘ﳐ\U00050616', strict=True)

    def test_uts46_1353(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cڠ\U0003fe869。Ⴣ꒘مخ\U00050616', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cڠ\U0003fe869。Ⴣ꒘مخ\U00050616', strict=True)

    def test_uts46_1354(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cڠ\U0003fe869。ⴣ꒘مخ\U00050616', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cڠ\U0003fe869。ⴣ꒘مخ\U00050616', strict=True)

    def test_uts46_1355(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-vtc42319e.xn--tgb9bz87p833hw316c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-vtc42319e.xn--tgb9bz87p833hw316c', strict=True)

    def test_uts46_1356(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-vtc736qts91g.xn--tgb9bz87p833hw316c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-vtc736qts91g.xn--tgb9bz87p833hw316c', strict=True)

    def test_uts46_1357(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cڠ\U0003fe86𝟗｡ⴣ꒘ﳐ\U00050616', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cڠ\U0003fe86𝟗｡ⴣ꒘ﳐ\U00050616', strict=True)

    def test_uts46_1358(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-vtc42319e.xn--tgb9bz61cfn8mw3t2c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-vtc42319e.xn--tgb9bz61cfn8mw3t2c', strict=True)

    def test_uts46_1359(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-vtc736qts91g.xn--tgb9bz61cfn8mw3t2c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-vtc736qts91g.xn--tgb9bz61cfn8mw3t2c', strict=True)

    def test_uts46_1360(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡖ｡̟\U000576e8ஂ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡖ｡̟\U000576e8ஂ-', strict=True)

    def test_uts46_1361(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡖ。̟\U000576e8ஂ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡖ。̟\U000576e8ஂ-', strict=True)

    def test_uts46_1362(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--m8e.xn----mdb555dkk71m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--m8e.xn----mdb555dkk71m', strict=True)

    def test_uts46_1363(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞠠浘。絧𞀀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞠠浘。絧𞀀', strict=True)

    def test_uts46_1364(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--e0wp491f.xn--ud0a3573e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--e0wp491f.xn--ud0a3573e', strict=True)

    def test_uts46_1365(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֖Ⴋ．𝟳≯︒︊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֖Ⴋ．𝟳≯︒︊', strict=True)

    def test_uts46_1366(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֖Ⴋ．𝟳≯︒︊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֖Ⴋ．𝟳≯︒︊', strict=True)

    def test_uts46_1367(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֖Ⴋ.7≯。︊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֖Ⴋ.7≯。︊', strict=True)

    def test_uts46_1368(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֖Ⴋ.7≯。︊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֖Ⴋ.7≯。︊', strict=True)

    def test_uts46_1369(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֖ⴋ.7≯。︊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֖ⴋ.7≯。︊', strict=True)

    def test_uts46_1370(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֖ⴋ.7≯。︊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֖ⴋ.7≯。︊', strict=True)

    def test_uts46_1371(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hcb613r.xn--7-pgo.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hcb613r.xn--7-pgo.', strict=True)

    def test_uts46_1372(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֖ⴋ．𝟳≯︒︊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֖ⴋ．𝟳≯︒︊', strict=True)

    def test_uts46_1373(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֖ⴋ．𝟳≯︒︊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֖ⴋ．𝟳≯︒︊', strict=True)

    def test_uts46_1374(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hcb613r.xn--7-pgoy530h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hcb613r.xn--7-pgoy530h', strict=True)

    def test_uts46_1375(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hcb887c.xn--7-pgo.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hcb887c.xn--7-pgo.', strict=True)

    def test_uts46_1376(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hcb887c.xn--7-pgoy530h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hcb887c.xn--7-pgoy530h', strict=True)

    def test_uts46_1377(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200dF𑓂。\U000e0ea8︒ݾ𐹢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200dF𑓂。\U000e0ea8︒ݾ𐹢', strict=True)

    def test_uts46_1378(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200dF𑓂。\U000e0ea8。ݾ𐹢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200dF𑓂。\U000e0ea8。ݾ𐹢', strict=True)

    def test_uts46_1379(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200df𑓂。\U000e0ea8。ݾ𐹢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200df𑓂。\U000e0ea8。ݾ𐹢', strict=True)

    def test_uts46_1380(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--f-kq9i.xn--7656e.xn--fqb4175k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--f-kq9i.xn--7656e.xn--fqb4175k', strict=True)

    def test_uts46_1381(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--f-tgn9761i.xn--7656e.xn--fqb4175k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--f-tgn9761i.xn--7656e.xn--fqb4175k', strict=True)

    def test_uts46_1382(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200df𑓂。\U000e0ea8︒ݾ𐹢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200df𑓂。\U000e0ea8︒ݾ𐹢', strict=True)

    def test_uts46_1383(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--f-kq9i.xn--fqb1637j8hky9452a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--f-kq9i.xn--fqb1637j8hky9452a', strict=True)

    def test_uts46_1384(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--f-tgn9761i.xn--fqb1637j8hky9452a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--f-tgn9761i.xn--fqb1637j8hky9452a', strict=True)

    def test_uts46_1385(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࡅ🄇𐼗︒｡𐹻𑜫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࡅ🄇𐼗︒｡𐹻𑜫', strict=True)

    def test_uts46_1386(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࡅ6,𐼗。。𐹻𑜫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࡅ6,𐼗。。𐹻𑜫', strict=True)

    def test_uts46_1387(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6,-r4e4420y..xn--zo0di2m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6,-r4e4420y..xn--zo0di2m', strict=True)

    def test_uts46_1388(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6,-r4e6182wo1ra.xn--zo0di2m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6,-r4e6182wo1ra.xn--zo0di2m', strict=True)

    def test_uts46_1389(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3vb4696jpxkjh7s.xn--zo0di2m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3vb4696jpxkjh7s.xn--zo0di2m', strict=True)

    def test_uts46_1390(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010e48.᷀𑈱𐦭', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010e48.᷀𑈱𐦭', strict=True)

    def test_uts46_1391(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jn0d.xn--7dg0871h3lf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jn0d.xn--7dg0871h3lf', strict=True)

    def test_uts46_1392(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴂ䠺。𞤃\U000453ce\U000d9ba6ړ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴂ䠺。𞤃\U000453ce\U000d9ba6ړ', strict=True)

    def test_uts46_1393(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴂ䠺。𞤥\U000453ce\U000d9ba6ړ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴂ䠺。𞤥\U000453ce\U000d9ba6ړ', strict=True)

    def test_uts46_1394(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tkj638f.xn--pjb9818vg4xno967d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tkj638f.xn--pjb9818vg4xno967d', strict=True)

    def test_uts46_1395(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9md875z.xn--pjb9818vg4xno967d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9md875z.xn--pjb9818vg4xno967d', strict=True)

    def test_uts46_1396(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴂ䠺。𞤃\U000453ce\U000d9ba6ړ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴂ䠺。𞤃\U000453ce\U000d9ba6ړ', strict=True)

    def test_uts46_1397(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🄇伐︒.\U0001c65a꣄', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🄇伐︒.\U0001c65a꣄', strict=True)

    def test_uts46_1398(self):
        self.assertRaises(idna.IDNAError, idna.decode, '6,伐。.\U0001c65a꣄', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '6,伐。.\U0001c65a꣄', strict=True)

    def test_uts46_1399(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6,-7i3c..xn--0f9ao925c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6,-7i3c..xn--0f9ao925c', strict=True)

    def test_uts46_1400(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6,-7i3cj157d.xn--0f9ao925c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6,-7i3cj157d.xn--0f9ao925c', strict=True)

    def test_uts46_1401(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--woqs083bel0g.xn--0f9ao925c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--woqs083bel0g.xn--0f9ao925c', strict=True)

    def test_uts46_1402(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹠꯭\ufffb。\u200d𐫓Ⴚ𑂹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹠꯭\ufffb。\u200d𐫓Ⴚ𑂹', strict=True)

    def test_uts46_1403(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐹠꯭\ufffb。\u200d𐫓ⴚ𑂹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐹠꯭\ufffb。\u200d𐫓ⴚ𑂹', strict=True)

    def test_uts46_1404(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--429az70n29i.xn--ilj7702eqyd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--429az70n29i.xn--ilj7702eqyd', strict=True)

    def test_uts46_1405(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ugz126coy7bdbm.xn--1ug062chv7ov6e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ugz126coy7bdbm.xn--1ug062chv7ov6e', strict=True)

    def test_uts46_1406(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--429az70n29i.xn--ynd3619jqyd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--429az70n29i.xn--ynd3619jqyd', strict=True)

    def test_uts46_1407(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ugz126coy7bdbm.xn--ynd959evs1pv6e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ugz126coy7bdbm.xn--ynd959evs1pv6e', strict=True)

    def test_uts46_1408(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆠．\U00077434\U000cc7c8', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆠．\U00077434\U000cc7c8', strict=True)

    def test_uts46_1409(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆠.\U00077434\U000cc7c8', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆠.\U00077434\U000cc7c8', strict=True)

    def test_uts46_1410(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--rx21bhv12i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--rx21bhv12i', strict=True)

    def test_uts46_1411(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫃\u200cႦ.≠\U0001edd9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫃\u200cႦ.≠\U0001edd9', strict=True)

    def test_uts46_1412(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫃\u200cႦ.≠\U0001edd9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫃\u200cႦ.≠\U0001edd9', strict=True)

    def test_uts46_1413(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫃\u200cⴆ.≠\U0001edd9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫃\u200cⴆ.≠\U0001edd9', strict=True)

    def test_uts46_1414(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫃\u200cⴆ.≠\U0001edd9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫃\u200cⴆ.≠\U0001edd9', strict=True)

    def test_uts46_1415(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xkjz802e.xn--1ch2802p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xkjz802e.xn--1ch2802p', strict=True)

    def test_uts46_1416(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug132csv7o.xn--1ch2802p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug132csv7o.xn--1ch2802p', strict=True)

    def test_uts46_1417(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--end1719j.xn--1ch2802p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--end1719j.xn--1ch2802p', strict=True)

    def test_uts46_1418(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--end799ekr1p.xn--1ch2802p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--end799ekr1p.xn--1ch2802p', strict=True)

    def test_uts46_1419(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0072\U00019a62𝟥ꘌ．ࡁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0072\U00019a62𝟥ꘌ．ࡁ', strict=True)

    def test_uts46_1420(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0072\U00019a623ꘌ.ࡁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0072\U00019a623ꘌ.ࡁ', strict=True)

    def test_uts46_1421(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-0g3es485d8i15h.xn--zvb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-0g3es485d8i15h.xn--zvb', strict=True)

    def test_uts46_1422(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.ᢆ\U000e1ca3-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.ᢆ\U000e1ca3-', strict=True)

    def test_uts46_1423(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn----pbkx6497q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn----pbkx6497q', strict=True)

    def test_uts46_1424(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000f2697\u200c｡\u200c\U0001ec06ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000f2697\u200c｡\u200c\U0001ec06ς', strict=True)

    def test_uts46_1425(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000f2697\u200c。\u200c\U0001ec06ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000f2697\u200c。\u200c\U0001ec06ς', strict=True)

    def test_uts46_1426(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000f2697\u200c。\u200c\U0001ec06Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000f2697\u200c。\u200c\U0001ec06Σ', strict=True)

    def test_uts46_1427(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000f2697\u200c。\u200c\U0001ec06σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000f2697\u200c。\u200c\U0001ec06σ', strict=True)

    def test_uts46_1428(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--qp42f.xn--4xa3011w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--qp42f.xn--4xa3011w', strict=True)

    def test_uts46_1429(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug76062m.xn--4xa595lhn92a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug76062m.xn--4xa595lhn92a', strict=True)

    def test_uts46_1430(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug76062m.xn--3xa795lhn92a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug76062m.xn--3xa795lhn92a', strict=True)

    def test_uts46_1431(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000f2697\u200c｡\u200c\U0001ec06Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000f2697\u200c｡\u200c\U0001ec06Σ', strict=True)

    def test_uts46_1432(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000f2697\u200c｡\u200c\U0001ec06σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000f2697\u200c｡\u200c\U0001ec06σ', strict=True)

    def test_uts46_1433(self):
        self.assertRaises(idna.IDNAError, idna.decode, '堕𑓂ᬂ。𐮇𞤽\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '堕𑓂ᬂ。𐮇𞤽\u200c-', strict=True)

    def test_uts46_1434(self):
        self.assertRaises(idna.IDNAError, idna.decode, '堕𑓂ᬂ。𐮇𞤛\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '堕𑓂ᬂ。𐮇𞤛\u200c-', strict=True)

    def test_uts46_1435(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5sf345zdk8h.xn----iv5iw606c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5sf345zdk8h.xn----iv5iw606c', strict=True)

    def test_uts46_1436(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5sf345zdk8h.xn----rgnt157hwl9g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5sf345zdk8h.xn----rgnt157hwl9g', strict=True)

    def test_uts46_1437(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢｡ᡥςتς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢｡ᡥςتς', strict=True)

    def test_uts46_1438(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢。ᡥςتς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢。ᡥςتς', strict=True)

    def test_uts46_1439(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤀。ᡥΣتΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤀。ᡥΣتΣ', strict=True)

    def test_uts46_1440(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢。ᡥσتσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢。ᡥσتσ', strict=True)

    def test_uts46_1441(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--l8e1317j1ebz456b.xn--4xaa85plx4a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--l8e1317j1ebz456b.xn--4xaa85plx4a', strict=True)

    def test_uts46_1442(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--l8e1317j1ebz456b.xn--3xaa16plx4a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--l8e1317j1ebz456b.xn--3xaa16plx4a', strict=True)

    def test_uts46_1443(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤀｡ᡥΣتΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤀｡ᡥΣتΣ', strict=True)

    def test_uts46_1444(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢｡ᡥσتσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢｡ᡥσتσ', strict=True)

    def test_uts46_1445(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢。ᡥΣتΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢。ᡥΣتΣ', strict=True)

    def test_uts46_1446(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢。ᡥΣتσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢。ᡥΣتσ', strict=True)

    def test_uts46_1447(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢。ᡥΣتς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢。ᡥΣتς', strict=True)

    def test_uts46_1448(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢。ᡥσتς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢。ᡥσتς', strict=True)

    def test_uts46_1449(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--l8e1317j1ebz456b.xn--3xab95plx4a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--l8e1317j1ebz456b.xn--3xab95plx4a', strict=True)

    def test_uts46_1450(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢｡ᡥΣتΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢｡ᡥΣتΣ', strict=True)

    def test_uts46_1451(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢｡ᡥΣتσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢｡ᡥΣتσ', strict=True)

    def test_uts46_1452(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢｡ᡥΣتς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢｡ᡥΣتς', strict=True)

    def test_uts46_1453(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹶𑁆ᡕ𞤢｡ᡥσتς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹶𑁆ᡕ𞤢｡ᡥσتς', strict=True)

    def test_uts46_1454(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cf4b0．-𝟻ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cf4b0．-𝟻ß', strict=True)

    def test_uts46_1455(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cf4b0.-5ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cf4b0.-5ß', strict=True)

    def test_uts46_1456(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cf4b0.-5SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cf4b0.-5SS', strict=True)

    def test_uts46_1457(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cf4b0.-5ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cf4b0.-5ss', strict=True)

    def test_uts46_1458(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--t960e.-5ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--t960e.-5ss', strict=True)

    def test_uts46_1459(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--t960e.xn---5-hia', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--t960e.xn---5-hia', strict=True)

    def test_uts46_1460(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cf4b0．-𝟻SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cf4b0．-𝟻SS', strict=True)

    def test_uts46_1461(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cf4b0．-𝟻ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cf4b0．-𝟻ss', strict=True)

    def test_uts46_1462(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cf4b0．-𝟻Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cf4b0．-𝟻Ss', strict=True)

    def test_uts46_1463(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cf4b0.-5Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cf4b0.-5Ss', strict=True)

    def test_uts46_1464(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐨿.🤒Ⴥ\U00091bb6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐨿.🤒Ⴥ\U00091bb6', strict=True)

    def test_uts46_1465(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𐨿.🤒ⴥ\U00091bb6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𐨿.🤒ⴥ\U00091bb6', strict=True)

    def test_uts46_1466(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0s9c.xn--tljz038l0gz4b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0s9c.xn--tljz038l0gz4b', strict=True)

    def test_uts46_1467(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug9533g.xn--tljz038l0gz4b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug9533g.xn--tljz038l0gz4b', strict=True)

    def test_uts46_1468(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0s9c.xn--9nd3211w0gz4b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0s9c.xn--9nd3211w0gz4b', strict=True)

    def test_uts46_1469(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug9533g.xn--9nd3211w0gz4b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug9533g.xn--9nd3211w0gz4b', strict=True)

    def test_uts46_1470(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000352c5。ß𬵩\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000352c5。ß𬵩\u200d', strict=True)

    def test_uts46_1471(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000352c5。SS𬵩\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000352c5。SS𬵩\u200d', strict=True)

    def test_uts46_1472(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000352c5。ss𬵩\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000352c5。ss𬵩\u200d', strict=True)

    def test_uts46_1473(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000352c5。Ss𬵩\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000352c5。Ss𬵩\u200d', strict=True)

    def test_uts46_1474(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ey1p.xn--ss-eq36b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ey1p.xn--ss-eq36b', strict=True)

    def test_uts46_1475(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ey1p.xn--ss-n1tx0508a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ey1p.xn--ss-n1tx0508a', strict=True)

    def test_uts46_1476(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ey1p.xn--zca870nz438b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ey1p.xn--zca870nz438b', strict=True)

    def test_uts46_1477(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𭉝。߱́𞹻', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𭉝。߱́𞹻', strict=True)

    def test_uts46_1478(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𭉝。߱́غ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𭉝。߱́غ', strict=True)

    def test_uts46_1479(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--634m.xn--lsa46nuub', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--634m.xn--lsa46nuub', strict=True)

    def test_uts46_1480(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugy003y.xn--lsa46nuub', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugy003y.xn--lsa46nuub', strict=True)

    def test_uts46_1481(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ef0c\u200c𑈶。𐹡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ef0c\u200c𑈶。𐹡', strict=True)

    def test_uts46_1482(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9g1d1288a.xn--8n0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9g1d1288a.xn--8n0d', strict=True)

    def test_uts46_1483(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug7946gzpxf.xn--8n0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug7946gzpxf.xn--8n0d', strict=True)

    def test_uts46_1484(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻ς≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻ς≠', strict=True)

    def test_uts46_1485(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻ς≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻ς≠', strict=True)

    def test_uts46_1486(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭。𑖿᪻ς≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭。𑖿᪻ς≠', strict=True)

    def test_uts46_1487(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭。𑖿᪻ς≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭。𑖿᪻ς≠', strict=True)

    def test_uts46_1488(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭。𑖿᪻Σ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭。𑖿᪻Σ≠', strict=True)

    def test_uts46_1489(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭。𑖿᪻Σ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭。𑖿᪻Σ≠', strict=True)

    def test_uts46_1490(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭。𑖿᪻σ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭。𑖿᪻σ≠', strict=True)

    def test_uts46_1491(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭。𑖿᪻σ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭。𑖿᪻σ≠', strict=True)

    def test_uts46_1492(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zb9h5968x.xn--4xa378i1mfjw7y', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zb9h5968x.xn--4xa378i1mfjw7y', strict=True)

    def test_uts46_1493(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y', strict=True)

    def test_uts46_1494(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug3766p5nm1b.xn--3xa578i1mfjw7y', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug3766p5nm1b.xn--3xa578i1mfjw7y', strict=True)

    def test_uts46_1495(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻Σ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻Σ≠', strict=True)

    def test_uts46_1496(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻Σ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻Σ≠', strict=True)

    def test_uts46_1497(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻σ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻σ≠', strict=True)

    def test_uts46_1498(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻σ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅯\U00087f6d\u200c🜭｡𑖿᪻σ≠', strict=True)

    def test_uts46_1499(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒋｡⒈\u200d\U000b3d22', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒋｡⒈\u200d\U000b3d22', strict=True)

    def test_uts46_1500(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4.。1.\u200d\U000b3d22', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4.。1.\u200d\U000b3d22', strict=True)

    def test_uts46_1501(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4..1.xn--sf51d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4..1.xn--sf51d', strict=True)

    def test_uts46_1502(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4..1.xn--1ug64613i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4..1.xn--1ug64613i', strict=True)

    def test_uts46_1503(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wsh.xn--tsh07994h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wsh.xn--tsh07994h', strict=True)

    def test_uts46_1504(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wsh.xn--1ug58o74922a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wsh.xn--1ug58o74922a', strict=True)

    def test_uts46_1505(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لß｡᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لß｡᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1506(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لß｡᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لß｡᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1507(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لß。᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لß。᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1508(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لSS。᩠𐇽\U000be162𞤜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لSS。᩠𐇽\U000be162𞤜', strict=True)

    def test_uts46_1509(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لss。᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لss。᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1510(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لss。᩠𐇽\U000be162𞤜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لss。᩠𐇽\U000be162𞤜', strict=True)

    def test_uts46_1511(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-svd.xn--jof2298hn83fln78f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-svd.xn--jof2298hn83fln78f', strict=True)

    def test_uts46_1512(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لß。᩠𐇽\U000be162𞤜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لß。᩠𐇽\U000be162𞤜', strict=True)

    def test_uts46_1513(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca57y.xn--jof2298hn83fln78f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca57y.xn--jof2298hn83fln78f', strict=True)

    def test_uts46_1514(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لSS｡᩠𐇽\U000be162𞤜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لSS｡᩠𐇽\U000be162𞤜', strict=True)

    def test_uts46_1515(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لss｡᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لss｡᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1516(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لss｡᩠𐇽\U000be162𞤜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لss｡᩠𐇽\U000be162𞤜', strict=True)

    def test_uts46_1517(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لß｡᩠𐇽\U000be162𞤜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لß｡᩠𐇽\U000be162𞤜', strict=True)

    def test_uts46_1518(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لSS｡᩠𐇽\U000be162𞤜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لSS｡᩠𐇽\U000be162𞤜', strict=True)

    def test_uts46_1519(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لss｡᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لss｡᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1520(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لss｡᩠𐇽\U000be162𞤜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لss｡᩠𐇽\U000be162𞤜', strict=True)

    def test_uts46_1521(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لß｡᩠𐇽\U000be162𞤜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لß｡᩠𐇽\U000be162𞤜', strict=True)

    def test_uts46_1522(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لSS。᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لSS。᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1523(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لSs。᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لSs。᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1524(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لSS｡᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لSS｡᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1525(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لSs｡᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لSs｡᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1526(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لSS｡᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لSS｡᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1527(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لSs｡᩠𐇽\U000be162𞤾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لSs｡᩠𐇽\U000be162𞤾', strict=True)

    def test_uts46_1528(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹽𑄳\U0007c732.ᷟី꠆𑜫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹽𑄳\U0007c732.ᷟី꠆𑜫', strict=True)

    def test_uts46_1529(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1o0di0c0652w.xn--33e362arr1l153d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1o0di0c0652w.xn--33e362arr1l153d', strict=True)

    def test_uts46_1530(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴓ𑜫\u200d\U00097b53．ڧ𑰶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴓ𑜫\u200d\U00097b53．ڧ𑰶', strict=True)

    def test_uts46_1531(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴓ𑜫\u200d\U00097b53.ڧ𑰶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴓ𑜫\u200d\U00097b53.ڧ𑰶', strict=True)

    def test_uts46_1532(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴓ𑜫\u200d\U00097b53.ڧ𑰶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴓ𑜫\u200d\U00097b53.ڧ𑰶', strict=True)

    def test_uts46_1533(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--blj6306ey091d.xn--9jb4223l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--blj6306ey091d.xn--9jb4223l', strict=True)

    def test_uts46_1534(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ugy52cym7p7xu5e.xn--9jb4223l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ugy52cym7p7xu5e.xn--9jb4223l', strict=True)

    def test_uts46_1535(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴓ𑜫\u200d\U00097b53．ڧ𑰶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴓ𑜫\u200d\U00097b53．ڧ𑰶', strict=True)

    def test_uts46_1536(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rnd8945ky009c.xn--9jb4223l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rnd8945ky009c.xn--9jb4223l', strict=True)

    def test_uts46_1537(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rnd479ep20q7x12e.xn--9jb4223l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rnd479ep20q7x12e.xn--9jb4223l', strict=True)

    def test_uts46_1538(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨿.🄆—', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨿.🄆—', strict=True)

    def test_uts46_1539(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨿.5,—', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨿.5,—', strict=True)

    def test_uts46_1540(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0s9c.xn--5,-81t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0s9c.xn--5,-81t', strict=True)

    def test_uts46_1541(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0s9c.xn--8ug8324p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0s9c.xn--8ug8324p', strict=True)

    def test_uts46_1542(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000942b1\U000419ae۸。\U000e0fad-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000942b1\U000419ae۸。\U000e0fad-', strict=True)

    def test_uts46_1543(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lmb18944c0g2z.xn----2k81m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lmb18944c0g2z.xn----2k81m', strict=True)

    def test_uts46_1544(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c5f8ߍ𐹮。\u06ddᡎᠴ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c5f8ߍ𐹮。\u06ddᡎᠴ', strict=True)

    def test_uts46_1545(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--osb0855kcc2r.xn--tlb299fhc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--osb0855kcc2r.xn--tlb299fhc', strict=True)

    def test_uts46_1546(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200dᠮႾ🄂.🚗ࡁ𮹌\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200dᠮႾ🄂.🚗ࡁ𮹌\u200c', strict=True)

    def test_uts46_1547(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200dᠮႾ1,.🚗ࡁ𮹌\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200dᠮႾ1,.🚗ࡁ𮹌\u200c', strict=True)

    def test_uts46_1548(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200dᠮⴞ1,.🚗ࡁ𮹌\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200dᠮⴞ1,.🚗ࡁ𮹌\u200c', strict=True)

    def test_uts46_1549(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1,-v3o625k.xn--zvb3124wpkpf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1,-v3o625k.xn--zvb3124wpkpf', strict=True)

    def test_uts46_1550(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1,-v3o161c53q.xn--zvb692j9664aic1g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1,-v3o161c53q.xn--zvb692j9664aic1g', strict=True)

    def test_uts46_1551(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200dᠮⴞ🄂.🚗ࡁ𮹌\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200dᠮⴞ🄂.🚗ࡁ𮹌\u200c', strict=True)

    def test_uts46_1552(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1,-ogkx89c.xn--zvb3124wpkpf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1,-ogkx89c.xn--zvb3124wpkpf', strict=True)

    def test_uts46_1553(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1,-ogkx89c39j.xn--zvb692j9664aic1g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1,-ogkx89c39j.xn--zvb692j9664aic1g', strict=True)

    def test_uts46_1554(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--h7e438h1p44a.xn--zvb3124wpkpf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--h7e438h1p44a.xn--zvb3124wpkpf', strict=True)

    def test_uts46_1555(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--h7e341b0wlbv45b.xn--zvb692j9664aic1g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--h7e341b0wlbv45b.xn--zvb692j9664aic1g', strict=True)

    def test_uts46_1556(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd129ai554b.xn--zvb3124wpkpf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd129ai554b.xn--zvb3124wpkpf', strict=True)

    def test_uts46_1557(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd129ay2gnw71c.xn--zvb692j9664aic1g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd129ay2gnw71c.xn--zvb692j9664aic1g', strict=True)

    def test_uts46_1558(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0601ڗ．𑚶\U0007c877⾆', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0601ڗ．𑚶\U0007c877⾆', strict=True)

    def test_uts46_1559(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0601ڗ.𑚶\U0007c877舌', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0601ڗ.𑚶\U0007c877舌', strict=True)

    def test_uts46_1560(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jfb41a.xn--tc1ap851axo39c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jfb41a.xn--tc1ap851axo39c', strict=True)

    def test_uts46_1561(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🞅\U000e0ce1\U000dc359.\U000725b7', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🞅\U000e0ce1\U000dc359.\U000725b7', strict=True)

    def test_uts46_1562(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ie9hi1349bqdlb.xn--oj69a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ie9hi1349bqdlb.xn--oj69a', strict=True)

    def test_uts46_1563(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⃧\U0006f84e-\U000ab8dd.4Ⴄ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⃧\U0006f84e-\U000ab8dd.4Ⴄ\u200c', strict=True)

    def test_uts46_1564(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⃧\U0006f84e-\U000ab8dd.4ⴄ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⃧\U0006f84e-\U000ab8dd.4ⴄ\u200c', strict=True)

    def test_uts46_1565(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----9snu5320fi76w.xn--4-ivs', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----9snu5320fi76w.xn--4-ivs', strict=True)

    def test_uts46_1566(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----9snu5320fi76w.xn--4-sgn589c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----9snu5320fi76w.xn--4-sgn589c', strict=True)

    def test_uts46_1567(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----9snu5320fi76w.xn--4-f0g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----9snu5320fi76w.xn--4-f0g', strict=True)

    def test_uts46_1568(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----9snu5320fi76w.xn--4-f0g649i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----9snu5320fi76w.xn--4-f0g649i', strict=True)

    def test_uts46_1569(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ｡𝌠ß𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ｡𝌠ß𖫱', strict=True)

    def test_uts46_1570(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ。𝌠ß𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ。𝌠ß𖫱', strict=True)

    def test_uts46_1571(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ。𝌠SS𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ。𝌠SS𖫱', strict=True)

    def test_uts46_1572(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ。𝌠ss𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ。𝌠ss𖫱', strict=True)

    def test_uts46_1573(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ。𝌠Ss𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ。𝌠Ss𖫱', strict=True)

    def test_uts46_1574(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hwe.xn--ss-ci1ub261a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hwe.xn--ss-ci1ub261a', strict=True)

    def test_uts46_1575(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ.𝌠ss𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ.𝌠ss𖫱', strict=True)

    def test_uts46_1576(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ.𝌠SS𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ.𝌠SS𖫱', strict=True)

    def test_uts46_1577(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ.𝌠Ss𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ.𝌠Ss𖫱', strict=True)

    def test_uts46_1578(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hwe.xn--zca4946pblnc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hwe.xn--zca4946pblnc', strict=True)

    def test_uts46_1579(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ.𝌠ß𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ.𝌠ß𖫱', strict=True)

    def test_uts46_1580(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ｡𝌠SS𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ｡𝌠SS𖫱', strict=True)

    def test_uts46_1581(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ｡𝌠ss𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ｡𝌠ss𖫱', strict=True)

    def test_uts46_1582(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᚭ｡𝌠Ss𖫱', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᚭ｡𝌠Ss𖫱', strict=True)

    def test_uts46_1583(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₁｡𞤫ꡪ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₁｡𞤫ꡪ', strict=True)

    def test_uts46_1584(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1。𞤫ꡪ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1。𞤫ꡪ', strict=True)

    def test_uts46_1585(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1。𞤉ꡪ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1。𞤉ꡪ', strict=True)

    def test_uts46_1586(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--gd9al691d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--gd9al691d', strict=True)

    def test_uts46_1587(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₁｡𞤉ꡪ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₁｡𞤉ꡪ', strict=True)

    def test_uts46_1588(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0002fefc\u200c.\U0001ed9e\U000bb664\U00065607', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0002fefc\u200c.\U0001ed9e\U000bb664\U00065607', strict=True)

    def test_uts46_1589(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--kg4n.xn--2b7hs861pl540a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--kg4n.xn--2b7hs861pl540a', strict=True)

    def test_uts46_1590(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug27500a.xn--2b7hs861pl540a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug27500a.xn--2b7hs861pl540a', strict=True)

    def test_uts46_1591(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑑄≯｡𑜤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑑄≯｡𑜤', strict=True)

    def test_uts46_1592(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑑄≯｡𑜤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑑄≯｡𑜤', strict=True)

    def test_uts46_1593(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑑄≯。𑜤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑑄≯。𑜤', strict=True)

    def test_uts46_1594(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑑄≯。𑜤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑑄≯。𑜤', strict=True)

    def test_uts46_1595(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh5636g.xn--ci2d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh5636g.xn--ci2d', strict=True)

    def test_uts46_1596(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴋ≮𱲆。\u200dާ𐋣', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴋ≮𱲆。\u200dާ𐋣', strict=True)

    def test_uts46_1597(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴋ≮𱲆。\u200dާ𐋣', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴋ≮𱲆。\u200dާ𐋣', strict=True)

    def test_uts46_1598(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴋ≮𱲆。\u200dާ𐋣', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴋ≮𱲆。\u200dާ𐋣', strict=True)

    def test_uts46_1599(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴋ≮𱲆。\u200dާ𐋣', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴋ≮𱲆。\u200dާ𐋣', strict=True)

    def test_uts46_1600(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdhz03bxt42d.xn--lrb6479j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdhz03bxt42d.xn--lrb6479j', strict=True)

    def test_uts46_1601(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdhz03bxt42d.xn--lrb506jqr4n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdhz03bxt42d.xn--lrb506jqr4n', strict=True)

    def test_uts46_1602(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jnd802gsm17c.xn--lrb6479j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jnd802gsm17c.xn--lrb6479j', strict=True)

    def test_uts46_1603(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jnd802gsm17c.xn--lrb506jqr4n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jnd802gsm17c.xn--lrb506jqr4n', strict=True)

    def test_uts46_1604(self):
        self.assertRaises(idna.IDNAError, idna.decode, '្.\U00086f52≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '្.\U00086f52≯', strict=True)

    def test_uts46_1605(self):
        self.assertRaises(idna.IDNAError, idna.decode, '្.\U00086f52≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '្.\U00086f52≯', strict=True)

    def test_uts46_1606(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u4e.xn--hdhx0084f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u4e.xn--hdhx0084f', strict=True)

    def test_uts46_1607(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004f047᜴．𐨺É⬓𑄴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004f047᜴．𐨺É⬓𑄴', strict=True)

    def test_uts46_1608(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004f047᜴．𐨺É⬓𑄴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004f047᜴．𐨺É⬓𑄴', strict=True)

    def test_uts46_1609(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004f047᜴.𐨺É⬓𑄴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004f047᜴.𐨺É⬓𑄴', strict=True)

    def test_uts46_1610(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004f047᜴.𐨺É⬓𑄴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004f047᜴.𐨺É⬓𑄴', strict=True)

    def test_uts46_1611(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004f047᜴.𐨺é⬓𑄴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004f047᜴.𐨺é⬓𑄴', strict=True)

    def test_uts46_1612(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004f047᜴.𐨺é⬓𑄴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004f047᜴.𐨺é⬓𑄴', strict=True)

    def test_uts46_1613(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--c0e34564d.xn--9ca207st53lg3f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--c0e34564d.xn--9ca207st53lg3f', strict=True)

    def test_uts46_1614(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004f047᜴．𐨺é⬓𑄴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004f047᜴．𐨺é⬓𑄴', strict=True)

    def test_uts46_1615(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004f047᜴．𐨺é⬓𑄴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004f047᜴．𐨺é⬓𑄴', strict=True)

    def test_uts46_1616(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢇ\u200d꣄｡︒𞤺', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢇ\u200d꣄｡︒𞤺', strict=True)

    def test_uts46_1617(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢇ\u200d꣄。。𞤺', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢇ\u200d꣄。。𞤺', strict=True)

    def test_uts46_1618(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢇ\u200d꣄。。𞤘', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢇ\u200d꣄。。𞤘', strict=True)

    def test_uts46_1619(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--09e4694e..xn--ye6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--09e4694e..xn--ye6h', strict=True)

    def test_uts46_1620(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--09e669a6x8j..xn--ye6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--09e669a6x8j..xn--ye6h', strict=True)

    def test_uts46_1621(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢇ\u200d꣄｡︒𞤘', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢇ\u200d꣄｡︒𞤘', strict=True)

    def test_uts46_1622(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--09e4694e.xn--y86cv562b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--09e4694e.xn--y86cv562b', strict=True)

    def test_uts46_1623(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--09e669a6x8j.xn--y86cv562b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--09e669a6x8j.xn--y86cv562b', strict=True)

    def test_uts46_1624(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ea6c\U00096671᜔\u200c｡رު≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ea6c\U00096671᜔\u200c｡رު≮', strict=True)

    def test_uts46_1625(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ea6c\U00096671᜔\u200c｡رު≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ea6c\U00096671᜔\u200c｡رު≮', strict=True)

    def test_uts46_1626(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ea6c\U00096671᜔\u200c。رު≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ea6c\U00096671᜔\u200c。رު≮', strict=True)

    def test_uts46_1627(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ea6c\U00096671᜔\u200c。رު≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ea6c\U00096671᜔\u200c。رު≮', strict=True)

    def test_uts46_1628(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fze3930v7hz6b.xn--wgb86el10d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fze3930v7hz6b.xn--wgb86el10d', strict=True)

    def test_uts46_1629(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fze607b9651bjwl7c.xn--wgb86el10d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fze607b9651bjwl7c.xn--wgb86el10d', strict=True)

    def test_uts46_1630(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴣ．ٓᢤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴣ．ٓᢤ', strict=True)

    def test_uts46_1631(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴣ.ٓᢤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴣ.ٓᢤ', strict=True)

    def test_uts46_1632(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴣ.ٓᢤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴣ.ٓᢤ', strict=True)

    def test_uts46_1633(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rlj.xn--vhb294g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rlj.xn--vhb294g', strict=True)

    def test_uts46_1634(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴣ．ٓᢤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴣ．ٓᢤ', strict=True)

    def test_uts46_1635(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7nd.xn--vhb294g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7nd.xn--vhb294g', strict=True)

    def test_uts46_1636(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄈ࠓ．싉\U000841bbჄ\U00082850', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄈ࠓ．싉\U000841bbჄ\U00082850', strict=True)

    def test_uts46_1637(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄈ࠓ．싉\U000841bbჄ\U00082850', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄈ࠓ．싉\U000841bbჄ\U00082850', strict=True)

    def test_uts46_1638(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄈ࠓ.싉\U000841bbჄ\U00082850', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄈ࠓ.싉\U000841bbჄ\U00082850', strict=True)

    def test_uts46_1639(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄈ࠓ.싉\U000841bbჄ\U00082850', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄈ࠓ.싉\U000841bbჄ\U00082850', strict=True)

    def test_uts46_1640(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄈ࠓ.싉\U000841bbⴤ\U00082850', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄈ࠓ.싉\U000841bbⴤ\U00082850', strict=True)

    def test_uts46_1641(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄈ࠓ.싉\U000841bbⴤ\U00082850', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄈ࠓ.싉\U000841bbⴤ\U00082850', strict=True)

    def test_uts46_1642(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--oub.xn--sljz109bpe25dviva', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--oub.xn--sljz109bpe25dviva', strict=True)

    def test_uts46_1643(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄈ࠓ．싉\U000841bbⴤ\U00082850', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄈ࠓ．싉\U000841bbⴤ\U00082850', strict=True)

    def test_uts46_1644(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄈ࠓ．싉\U000841bbⴤ\U00082850', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄈ࠓ．싉\U000841bbⴤ\U00082850', strict=True)

    def test_uts46_1645(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--oub.xn--8nd9522gpe69cviva', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--oub.xn--8nd9522gpe69cviva', strict=True)

    def test_uts46_1646(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꨬ𑲫≮．⤂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꨬ𑲫≮．⤂', strict=True)

    def test_uts46_1647(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꨬ𑲫≮．⤂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꨬ𑲫≮．⤂', strict=True)

    def test_uts46_1648(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꨬ𑲫≮.⤂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꨬ𑲫≮.⤂', strict=True)

    def test_uts46_1649(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꨬ𑲫≮.⤂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꨬ𑲫≮.⤂', strict=True)

    def test_uts46_1650(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh1854cn19c.xn--kqi', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh1854cn19c.xn--kqi', strict=True)

    def test_uts46_1651(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮Ⴢ．Ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮Ⴢ．Ⴃ', strict=True)

    def test_uts46_1652(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮Ⴢ．Ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮Ⴢ．Ⴃ', strict=True)

    def test_uts46_1653(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮Ⴢ.Ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮Ⴢ.Ⴃ', strict=True)

    def test_uts46_1654(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮Ⴢ.Ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮Ⴢ.Ⴃ', strict=True)

    def test_uts46_1655(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮ⴢ.ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮ⴢ.ⴃ', strict=True)

    def test_uts46_1656(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮ⴢ.ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮ⴢ.ⴃ', strict=True)

    def test_uts46_1657(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮Ⴢ.ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮Ⴢ.ⴃ', strict=True)

    def test_uts46_1658(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮Ⴢ.ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮Ⴢ.ⴃ', strict=True)

    def test_uts46_1659(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mfb266l4khr54u.xn--ukj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mfb266l4khr54u.xn--ukj', strict=True)

    def test_uts46_1660(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮ⴢ．ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮ⴢ．ⴃ', strict=True)

    def test_uts46_1661(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮ⴢ．ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮ⴢ．ⴃ', strict=True)

    def test_uts46_1662(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮Ⴢ．ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮Ⴢ．ⴃ', strict=True)

    def test_uts46_1663(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0604𐩔≮Ⴢ．ⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0604𐩔≮Ⴢ．ⴃ', strict=True)

    def test_uts46_1664(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mfb416c0jox02t.xn--ukj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mfb416c0jox02t.xn--ukj', strict=True)

    def test_uts46_1665(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mfb416c0jox02t.xn--bnd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mfb416c0jox02t.xn--bnd', strict=True)

    def test_uts46_1666(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑁅。-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑁅。-', strict=True)

    def test_uts46_1667(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--210d.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--210d.-', strict=True)

    def test_uts46_1668(self):
        self.assertRaises(idna.IDNAError, idna.decode, '්\U00095e3d\U000e09f1｡饈≠٤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '්\U00095e3d\U000e09f1｡饈≠٤', strict=True)

    def test_uts46_1669(self):
        self.assertRaises(idna.IDNAError, idna.decode, '්\U00095e3d\U000e09f1｡饈≠٤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '්\U00095e3d\U000e09f1｡饈≠٤', strict=True)

    def test_uts46_1670(self):
        self.assertRaises(idna.IDNAError, idna.decode, '්\U00095e3d\U000e09f1。饈≠٤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '්\U00095e3d\U000e09f1。饈≠٤', strict=True)

    def test_uts46_1671(self):
        self.assertRaises(idna.IDNAError, idna.decode, '්\U00095e3d\U000e09f1。饈≠٤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '්\U00095e3d\U000e09f1。饈≠٤', strict=True)

    def test_uts46_1672(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--h1c25913jfwov.xn--dib144ler5f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--h1c25913jfwov.xn--dib144ler5f', strict=True)

    def test_uts46_1673(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞥃ᠠ⁷｡≯邅⬻4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞥃ᠠ⁷｡≯邅⬻4', strict=True)

    def test_uts46_1674(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞥃ᠠ⁷｡≯邅⬻4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞥃ᠠ⁷｡≯邅⬻4', strict=True)

    def test_uts46_1675(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞥃ᠠ7。≯邅⬻4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞥃ᠠ7。≯邅⬻4', strict=True)

    def test_uts46_1676(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞥃ᠠ7。≯邅⬻4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞥃ᠠ7。≯邅⬻4', strict=True)

    def test_uts46_1677(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤡ᠠ7。≯邅⬻4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤡ᠠ7。≯邅⬻4', strict=True)

    def test_uts46_1678(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤡ᠠ7。≯邅⬻4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤡ᠠ7。≯邅⬻4', strict=True)

    def test_uts46_1679(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7-v4j2826w.xn--4-ogoy01bou3i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7-v4j2826w.xn--4-ogoy01bou3i', strict=True)

    def test_uts46_1680(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤡ᠠ⁷｡≯邅⬻4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤡ᠠ⁷｡≯邅⬻4', strict=True)

    def test_uts46_1681(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤡ᠠ⁷｡≯邅⬻4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤡ᠠ⁷｡≯邅⬻4', strict=True)

    def test_uts46_1682(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a0fefᡳ-𑐻.𐹴𐋫\u0605\U000d13b3', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a0fefᡳ-𑐻.𐹴𐋫\u0605\U000d13b3', strict=True)

    def test_uts46_1683(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----m9j3429kxmy7e.xn--nfb7950kdihrp812a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----m9j3429kxmy7e.xn--nfb7950kdihrp812a', strict=True)

    def test_uts46_1684(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a0d86ࡅੑ.넨-\U000f69c8', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a0d86ࡅੑ.넨-\U000f69c8', strict=True)

    def test_uts46_1685(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a0d86ࡅੑ.넨-\U000f69c8', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a0d86ࡅੑ.넨-\U000f69c8', strict=True)

    def test_uts46_1686(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3vb26hb6834b.xn----i37ez0957g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3vb26hb6834b.xn----i37ez0957g', strict=True)

    def test_uts46_1687(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡦᡑ\u200d⒈。𐋣-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡦᡑ\u200d⒈。𐋣-', strict=True)

    def test_uts46_1688(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡦᡑ\u200d1.。𐋣-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡦᡑ\u200d1.。𐋣-', strict=True)

    def test_uts46_1689(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-o7j0610f..xn----381i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-o7j0610f..xn----381i', strict=True)

    def test_uts46_1690(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-o7j663bdl7m..xn----381i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-o7j663bdl7m..xn----381i', strict=True)

    def test_uts46_1691(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--h8e863drj7h.xn----381i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--h8e863drj7h.xn----381i', strict=True)

    def test_uts46_1692(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--h8e470bl0d838o.xn----381i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--h8e470bl0d838o.xn----381i', strict=True)

    def test_uts46_1693(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴌ。\U0010df20ﭩ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴌ。\U0010df20ﭩ', strict=True)

    def test_uts46_1694(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴌ。\U0010df20ٹ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴌ。\U0010df20ٹ', strict=True)

    def test_uts46_1695(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴌ。\U0010df20ٹ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴌ。\U0010df20ٹ', strict=True)

    def test_uts46_1696(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3kj.xn--yib19191t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3kj.xn--yib19191t', strict=True)

    def test_uts46_1697(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴌ。\U0010df20ﭩ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴌ。\U0010df20ﭩ', strict=True)

    def test_uts46_1698(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--knd.xn--yib19191t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--knd.xn--yib19191t', strict=True)

    def test_uts46_1699(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐮁𐭱.྄፞-ᳺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐮁𐭱.྄፞-ᳺ', strict=True)

    def test_uts46_1700(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--r19c5a.xn----xjg270ag3m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--r19c5a.xn----xjg270ag3m', strict=True)

    def test_uts46_1701(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈䰹\u200d-。웈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈䰹\u200d-。웈', strict=True)

    def test_uts46_1702(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈䰹\u200d-。웈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈䰹\u200d-。웈', strict=True)

    def test_uts46_1703(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.䰹\u200d-。웈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.䰹\u200d-。웈', strict=True)

    def test_uts46_1704(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.䰹\u200d-。웈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.䰹\u200d-。웈', strict=True)

    def test_uts46_1705(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn----zw5a.xn--kp5b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn----zw5a.xn--kp5b', strict=True)

    def test_uts46_1706(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn----tgnz80r.xn--kp5b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn----tgnz80r.xn--kp5b', strict=True)

    def test_uts46_1707(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----dcp160o.xn--kp5b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----dcp160o.xn--kp5b', strict=True)

    def test_uts46_1708(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----tgnx5rjr6c.xn--kp5b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----tgnx5rjr6c.xn--kp5b', strict=True)

    def test_uts46_1709(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'て。\u200c\U000e0cfd߳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'て。\u200c\U000e0cfd߳', strict=True)

    def test_uts46_1710(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--m9j.xn--rtb10784p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--m9j.xn--rtb10784p', strict=True)

    def test_uts46_1711(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--m9j.xn--rtb154j9l73w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--m9j.xn--rtb154j9l73w', strict=True)

    def test_uts46_1712(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς｡꧀ۧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς｡꧀ۧ', strict=True)

    def test_uts46_1713(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς。꧀ۧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς。꧀ۧ', strict=True)

    def test_uts46_1714(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ。꧀ۧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ。꧀ۧ', strict=True)

    def test_uts46_1715(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ。꧀ۧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ。꧀ۧ', strict=True)

    def test_uts46_1716(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa.xn--3lb1944f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa.xn--3lb1944f', strict=True)

    def test_uts46_1717(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa.xn--3lb1944f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa.xn--3lb1944f', strict=True)

    def test_uts46_1718(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ｡꧀ۧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ｡꧀ۧ', strict=True)

    def test_uts46_1719(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ｡꧀ۧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ｡꧀ۧ', strict=True)

    def test_uts46_1720(self):
        self.assertRaises(idna.IDNAError, idna.decode, '்\U000e5ac5\U0008c251.ႢႵ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '்\U000e5ac5\U0008c251.ႢႵ', strict=True)

    def test_uts46_1721(self):
        self.assertRaises(idna.IDNAError, idna.decode, '்\U000e5ac5\U0008c251.ⴂⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '்\U000e5ac5\U0008c251.ⴂⴕ', strict=True)

    def test_uts46_1722(self):
        self.assertRaises(idna.IDNAError, idna.decode, '்\U000e5ac5\U0008c251.Ⴂⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '்\U000e5ac5\U0008c251.Ⴂⴕ', strict=True)

    def test_uts46_1723(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xmc83135idcxza.xn--tkjwb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xmc83135idcxza.xn--tkjwb', strict=True)

    def test_uts46_1724(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xmc83135idcxza.xn--9md086l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xmc83135idcxza.xn--9md086l', strict=True)

    def test_uts46_1725(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xmc83135idcxza.xn--9md2b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xmc83135idcxza.xn--9md2b', strict=True)

    def test_uts46_1726(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᰲ🄈⾛֦．\u200d\U000af964߽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᰲ🄈⾛֦．\u200d\U000af964߽', strict=True)

    def test_uts46_1727(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᰲ7,走֦.\u200d\U000af964߽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᰲ7,走֦.\u200d\U000af964߽', strict=True)

    def test_uts46_1728(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7,-bid991urn3k.xn--1tb13454l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7,-bid991urn3k.xn--1tb13454l', strict=True)

    def test_uts46_1729(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7,-bid991urn3k.xn--1tb334j1197q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7,-bid991urn3k.xn--1tb334j1197q', strict=True)

    def test_uts46_1730(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xcb756i493fwi5o.xn--1tb13454l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xcb756i493fwi5o.xn--1tb13454l', strict=True)

    def test_uts46_1731(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xcb756i493fwi5o.xn--1tb334j1197q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xcb756i493fwi5o.xn--1tb334j1197q', strict=True)

    def test_uts46_1732(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢗ｡Ӏ\U0005d13b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢗ｡Ӏ\U0005d13b', strict=True)

    def test_uts46_1733(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢗ。Ӏ\U0005d13b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢗ。Ӏ\U0005d13b', strict=True)

    def test_uts46_1734(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢗ。ӏ\U0005d13b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢗ。ӏ\U0005d13b', strict=True)

    def test_uts46_1735(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hbf.xn--s5a83117e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hbf.xn--s5a83117e', strict=True)

    def test_uts46_1736(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢗ｡ӏ\U0005d13b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢗ｡ӏ\U0005d13b', strict=True)

    def test_uts46_1737(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hbf.xn--d5a86117e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hbf.xn--d5a86117e', strict=True)

    def test_uts46_1738(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٨-。\U000603c7🝆ᄾ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٨-。\U000603c7🝆ᄾ', strict=True)

    def test_uts46_1739(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----oqc.xn--qrd1699v327w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----oqc.xn--qrd1699v327w', strict=True)

    def test_uts46_1740(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𐋷𖾑。󠆬', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𐋷𖾑。󠆬', strict=True)

    def test_uts46_1741(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----991iq40y.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----991iq40y.', strict=True)

    def test_uts46_1742(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹳🐴멈.꯭\U0005087c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹳🐴멈.꯭\U0005087c', strict=True)

    def test_uts46_1743(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹳🐴멈.꯭\U0005087c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹳🐴멈.꯭\U0005087c', strict=True)

    def test_uts46_1744(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--422b325mqb6i.xn--429a8682s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--422b325mqb6i.xn--429a8682s', strict=True)

    def test_uts46_1745(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug6681d406b7bwk.xn--429a8682s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug6681d406b7bwk.xn--429a8682s', strict=True)

    def test_uts46_1746(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮.ݩ\u0603', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮.ݩ\u0603', strict=True)

    def test_uts46_1747(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮.ݩ\u0603', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮.ݩ\u0603', strict=True)

    def test_uts46_1748(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh.xn--lfb92e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh.xn--lfb92e', strict=True)

    def test_uts46_1749(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010dad⾆｡\u200c𑚶\U0009fc43\U0001ec18', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010dad⾆｡\u200c𑚶\U0009fc43\U0001ec18', strict=True)

    def test_uts46_1750(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010dad舌。\u200c𑚶\U0009fc43\U0001ec18', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010dad舌。\u200c𑚶\U0009fc43\U0001ec18', strict=True)

    def test_uts46_1751(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tc1ao37z.xn--6e2dw557azds2d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tc1ao37z.xn--6e2dw557azds2d', strict=True)

    def test_uts46_1752(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tc1ao37z.xn--0ugx728gi1nfwqz2e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tc1ao37z.xn--0ugx728gi1nfwqz2e', strict=True)

    def test_uts46_1753(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cჀ-.𝟷ς𞴺ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cჀ-.𝟷ς𞴺ς', strict=True)

    def test_uts46_1754(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cჀ-.1ς𞴺ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cჀ-.1ς𞴺ς', strict=True)

    def test_uts46_1755(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴠ-.1ς𞴺ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴠ-.1ς𞴺ς', strict=True)

    def test_uts46_1756(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cჀ-.1Σ𞴺Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cჀ-.1Σ𞴺Σ', strict=True)

    def test_uts46_1757(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴠ-.1σ𞴺σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴠ-.1σ𞴺σ', strict=True)

    def test_uts46_1758(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cჀ-.1σ𞴺Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cჀ-.1σ𞴺Σ', strict=True)

    def test_uts46_1759(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----2ws.xn--1-0mba52321c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----2ws.xn--1-0mba52321c', strict=True)

    def test_uts46_1760(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----rgn530d.xn--1-0mba52321c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----rgn530d.xn--1-0mba52321c', strict=True)

    def test_uts46_1761(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cჀ-.1ς𞴺Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cჀ-.1ς𞴺Σ', strict=True)

    def test_uts46_1762(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴠ-.1ς𞴺σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴠ-.1ς𞴺σ', strict=True)

    def test_uts46_1763(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----rgn530d.xn--1-ymbd52321c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----rgn530d.xn--1-ymbd52321c', strict=True)

    def test_uts46_1764(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----rgn530d.xn--1-ymba92321c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----rgn530d.xn--1-ymba92321c', strict=True)

    def test_uts46_1765(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴠ-.𝟷ς𞴺ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴠ-.𝟷ς𞴺ς', strict=True)

    def test_uts46_1766(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cჀ-.𝟷Σ𞴺Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cჀ-.𝟷Σ𞴺Σ', strict=True)

    def test_uts46_1767(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴠ-.𝟷σ𞴺σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴠ-.𝟷σ𞴺σ', strict=True)

    def test_uts46_1768(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cჀ-.𝟷σ𞴺Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cჀ-.𝟷σ𞴺Σ', strict=True)

    def test_uts46_1769(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cჀ-.𝟷ς𞴺Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cჀ-.𝟷ς𞴺Σ', strict=True)

    def test_uts46_1770(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴠ-.𝟷ς𞴺σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴠ-.𝟷ς𞴺σ', strict=True)

    def test_uts46_1771(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----z1g.xn--1-0mba52321c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----z1g.xn--1-0mba52321c', strict=True)

    def test_uts46_1772(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----z1g168i.xn--1-0mba52321c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----z1g168i.xn--1-0mba52321c', strict=True)

    def test_uts46_1773(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----z1g168i.xn--1-ymbd52321c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----z1g168i.xn--1-ymbd52321c', strict=True)

    def test_uts46_1774(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----z1g168i.xn--1-ymba92321c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----z1g168i.xn--1-ymba92321c', strict=True)

    def test_uts46_1775(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑲘󠄒\U00013461｡𝟪Ⴜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑲘󠄒\U00013461｡𝟪Ⴜ', strict=True)

    def test_uts46_1776(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑲘󠄒\U00013461。8Ⴜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑲘󠄒\U00013461。8Ⴜ', strict=True)

    def test_uts46_1777(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑲘󠄒\U00013461。8ⴜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑲘󠄒\U00013461。8ⴜ', strict=True)

    def test_uts46_1778(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7m3d291b.xn--8-vws', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7m3d291b.xn--8-vws', strict=True)

    def test_uts46_1779(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑲘󠄒\U00013461｡𝟪ⴜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑲘󠄒\U00013461｡𝟪ⴜ', strict=True)

    def test_uts46_1780(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7m3d291b.xn--8-s1g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7m3d291b.xn--8-s1g', strict=True)

    def test_uts46_1781(self):
        self.assertRaises(idna.IDNAError, idna.decode, '䪏ګߠु｡뭕ᢝឹ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '䪏ګߠु｡뭕ᢝឹ', strict=True)

    def test_uts46_1782(self):
        self.assertRaises(idna.IDNAError, idna.decode, '䪏ګߠु｡뭕ᢝឹ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '䪏ګߠु｡뭕ᢝឹ', strict=True)

    def test_uts46_1783(self):
        self.assertRaises(idna.IDNAError, idna.decode, '䪏ګߠु。뭕ᢝឹ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '䪏ګߠु。뭕ᢝឹ', strict=True)

    def test_uts46_1784(self):
        self.assertRaises(idna.IDNAError, idna.decode, '䪏ګߠु。뭕ᢝឹ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '䪏ګߠु。뭕ᢝឹ', strict=True)

    def test_uts46_1785(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ekb23dj4at01n.xn--43e96bh910b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ekb23dj4at01n.xn--43e96bh910b', strict=True)

    def test_uts46_1786(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮫｡🂉\U000e0070', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮫｡🂉\U000e0070', strict=True)

    def test_uts46_1787(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮫。🂉\U000e0070', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮫。🂉\U000e0070', strict=True)

    def test_uts46_1788(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zxf.xn--fx7ho0250c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zxf.xn--fx7ho0250c', strict=True)

    def test_uts46_1789(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e9383ૄ。ς\u200d𐹮𑈵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e9383ૄ。ς\u200d𐹮𑈵', strict=True)

    def test_uts46_1790(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e9383ૄ。Σ\u200d𐹮𑈵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e9383ૄ。Σ\u200d𐹮𑈵', strict=True)

    def test_uts46_1791(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e9383ૄ。σ\u200d𐹮𑈵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e9383ૄ。σ\u200d𐹮𑈵', strict=True)

    def test_uts46_1792(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dfc53161q.xn--4xa8467k5mc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dfc53161q.xn--4xa8467k5mc', strict=True)

    def test_uts46_1793(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dfc53161q.xn--4xa895lzo7nsfd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dfc53161q.xn--4xa895lzo7nsfd', strict=True)

    def test_uts46_1794(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dfc53161q.xn--3xa006lzo7nsfd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dfc53161q.xn--3xa006lzo7nsfd', strict=True)

    def test_uts46_1795(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫀ᡂ𑜫．𑘿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫀ᡂ𑜫．𑘿', strict=True)

    def test_uts46_1796(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫀ᡂ𑜫.𑘿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫀ᡂ𑜫.𑘿', strict=True)

    def test_uts46_1797(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--17e9625js1h.xn--sb2d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--17e9625js1h.xn--sb2d', strict=True)

    def test_uts46_1798(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000ec6b6\U000f82d6\U00096a70-。\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000ec6b6\U000f82d6\U00096a70-。\u200c', strict=True)

    def test_uts46_1799(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----7i12hu122k9ire.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----7i12hu122k9ire.', strict=True)

    def test_uts46_1800(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----7i12hu122k9ire.xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----7i12hu122k9ire.xn--0ug', strict=True)

    def test_uts46_1801(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣．߂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣．߂', strict=True)

    def test_uts46_1802(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣.߂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣.߂', strict=True)

    def test_uts46_1803(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bo0d.xn--dsb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bo0d.xn--dsb', strict=True)

    def test_uts46_1804(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ߡ｡Ↄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ߡ｡Ↄ', strict=True)

    def test_uts46_1805(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ߡ。Ↄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ߡ。Ↄ', strict=True)

    def test_uts46_1806(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ߡ。ↄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ߡ。ↄ', strict=True)

    def test_uts46_1807(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----8cd.xn--r5g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----8cd.xn--r5g', strict=True)

    def test_uts46_1808(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ߡ｡ↄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ߡ｡ↄ', strict=True)

    def test_uts46_1809(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----8cd.xn--q5g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----8cd.xn--q5g', strict=True)

    def test_uts46_1810(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-︒󠄄。ß哑\u200c\U00010d7f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-︒󠄄。ß哑\u200c\U00010d7f', strict=True)

    def test_uts46_1811(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-。󠄄。ß哑\u200c\U00010d7f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-。󠄄。ß哑\u200c\U00010d7f', strict=True)

    def test_uts46_1812(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-。󠄄。SS哑\u200c\U00010d5f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-。󠄄。SS哑\u200c\U00010d5f', strict=True)

    def test_uts46_1813(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-。󠄄。ss哑\u200c\U00010d7f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-。󠄄。ss哑\u200c\U00010d7f', strict=True)

    def test_uts46_1814(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-。󠄄。Ss哑\u200c\U00010d5f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-。󠄄。Ss哑\u200c\U00010d5f', strict=True)

    def test_uts46_1815(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-..xn--ss-h46c5711e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-..xn--ss-h46c5711e', strict=True)

    def test_uts46_1816(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----tgn..xn--ss-k1ts75zb8ym', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----tgn..xn--ss-k1ts75zb8ym', strict=True)

    def test_uts46_1817(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----tgn..xn--zca670n5f0binyk', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----tgn..xn--zca670n5f0binyk', strict=True)

    def test_uts46_1818(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-︒󠄄。SS哑\u200c\U00010d5f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-︒󠄄。SS哑\u200c\U00010d5f', strict=True)

    def test_uts46_1819(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-︒󠄄。ss哑\u200c\U00010d7f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-︒󠄄。ss哑\u200c\U00010d7f', strict=True)

    def test_uts46_1820(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-︒󠄄。Ss哑\u200c\U00010d5f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-︒󠄄。Ss哑\u200c\U00010d5f', strict=True)

    def test_uts46_1821(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----o89h.xn--ss-h46c5711e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----o89h.xn--ss-h46c5711e', strict=True)

    def test_uts46_1822(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----tgnt341h.xn--ss-k1ts75zb8ym', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----tgnt341h.xn--ss-k1ts75zb8ym', strict=True)

    def test_uts46_1823(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----tgnt341h.xn--zca670n5f0binyk', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----tgnt341h.xn--zca670n5f0binyk', strict=True)

    def test_uts46_1824(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-。󠄄。SS哑\u200c\U00010d7f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-。󠄄。SS哑\u200c\U00010d7f', strict=True)

    def test_uts46_1825(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-。󠄄。Ss哑\u200c\U00010d7f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-。󠄄。Ss哑\u200c\U00010d7f', strict=True)

    def test_uts46_1826(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-︒󠄄。SS哑\u200c\U00010d7f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-︒󠄄。SS哑\u200c\U00010d7f', strict=True)

    def test_uts46_1827(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-︒󠄄。Ss哑\u200c\U00010d7f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-︒󠄄。Ss哑\u200c\U00010d7f', strict=True)

    def test_uts46_1828(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒．𑑂︯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒．𑑂︯', strict=True)

    def test_uts46_1829(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒．𑑂︯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒．𑑂︯', strict=True)

    def test_uts46_1830(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。.𑑂︯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。.𑑂︯', strict=True)

    def test_uts46_1831(self):
        self.assertRaises(idna.IDNAError, idna.decode, '..xn--s96cu30b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '..xn--s96cu30b', strict=True)

    def test_uts46_1832(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y86c.xn--s96cu30b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y86c.xn--s96cu30b', strict=True)

    def test_uts46_1833(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꤬。\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꤬。\u200d', strict=True)

    def test_uts46_1834(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zi9a.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zi9a.', strict=True)

    def test_uts46_1835(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zi9a.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zi9a.xn--1ug', strict=True)

    def test_uts46_1836(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U000e0e21｡ﳗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U000e0e21｡ﳗ', strict=True)

    def test_uts46_1837(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U000e0e21。هج', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U000e0e21。هج', strict=True)

    def test_uts46_1838(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--d356e.xn--rgb7c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--d356e.xn--rgb7c', strict=True)

    def test_uts46_1839(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug80651l.xn--rgb7c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug80651l.xn--rgb7c', strict=True)

    def test_uts46_1840(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-Ⴄ𝟢٣．𑍴ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-Ⴄ𝟢٣．𑍴ς', strict=True)

    def test_uts46_1841(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-Ⴄ0٣.𑍴ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-Ⴄ0٣.𑍴ς', strict=True)

    def test_uts46_1842(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ⴄ0٣.𑍴ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ⴄ0٣.𑍴ς', strict=True)

    def test_uts46_1843(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-Ⴄ0٣.𑍴Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-Ⴄ0٣.𑍴Σ', strict=True)

    def test_uts46_1844(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ⴄ0٣.𑍴σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ⴄ0٣.𑍴σ', strict=True)

    def test_uts46_1845(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---0-iyd8660b.xn--4xa9120l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---0-iyd8660b.xn--4xa9120l', strict=True)

    def test_uts46_1846(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---0-iyd8660b.xn--3xa1220l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---0-iyd8660b.xn--3xa1220l', strict=True)

    def test_uts46_1847(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ⴄ𝟢٣．𑍴ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ⴄ𝟢٣．𑍴ς', strict=True)

    def test_uts46_1848(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-Ⴄ𝟢٣．𑍴Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-Ⴄ𝟢٣．𑍴Σ', strict=True)

    def test_uts46_1849(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ⴄ𝟢٣．𑍴σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ⴄ𝟢٣．𑍴σ', strict=True)

    def test_uts46_1850(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---0-iyd216h.xn--4xa9120l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---0-iyd216h.xn--4xa9120l', strict=True)

    def test_uts46_1851(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---0-iyd216h.xn--3xa1220l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---0-iyd216h.xn--3xa1220l', strict=True)

    def test_uts46_1852(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e6204。-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e6204。-', strict=True)

    def test_uts46_1853(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xm38e.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xm38e.-', strict=True)

    def test_uts46_1854(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮．\U000b622e༘ß≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮．\U000b622e༘ß≯', strict=True)

    def test_uts46_1855(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮．\U000b622e༘ß≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮．\U000b622e༘ß≯', strict=True)

    def test_uts46_1856(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮.\U000b622e༘ß≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮.\U000b622e༘ß≯', strict=True)

    def test_uts46_1857(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮.\U000b622e༘ß≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮.\U000b622e༘ß≯', strict=True)

    def test_uts46_1858(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮.\U000b622e༘SS≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮.\U000b622e༘SS≯', strict=True)

    def test_uts46_1859(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮.\U000b622e༘SS≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮.\U000b622e༘SS≯', strict=True)

    def test_uts46_1860(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮.\U000b622e༘ss≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮.\U000b622e༘ss≯', strict=True)

    def test_uts46_1861(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮.\U000b622e༘ss≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮.\U000b622e༘ss≯', strict=True)

    def test_uts46_1862(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮.\U000b622e༘Ss≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮.\U000b622e༘Ss≯', strict=True)

    def test_uts46_1863(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮.\U000b622e༘Ss≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮.\U000b622e༘Ss≯', strict=True)

    def test_uts46_1864(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pgh4639f.xn--ss-ifj426nle504a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pgh4639f.xn--ss-ifj426nle504a', strict=True)

    def test_uts46_1865(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pgh4639f.xn--zca593eo6oc013y', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pgh4639f.xn--zca593eo6oc013y', strict=True)

    def test_uts46_1866(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮．\U000b622e༘SS≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮．\U000b622e༘SS≯', strict=True)

    def test_uts46_1867(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮．\U000b622e༘SS≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮．\U000b622e༘SS≯', strict=True)

    def test_uts46_1868(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮．\U000b622e༘ss≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮．\U000b622e༘ss≯', strict=True)

    def test_uts46_1869(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮．\U000b622e༘ss≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮．\U000b622e༘ss≯', strict=True)

    def test_uts46_1870(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮．\U000b622e༘Ss≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮．\U000b622e༘Ss≯', strict=True)

    def test_uts46_1871(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⋠𐋮．\U000b622e༘Ss≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⋠𐋮．\U000b622e༘Ss≯', strict=True)

    def test_uts46_1872(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1𐋸٤｡\U000e08aeﮤ\U0007774a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1𐋸٤｡\U000e08aeﮤ\U0007774a', strict=True)

    def test_uts46_1873(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1𐋸٤。\U000e08aeۀ\U0007774a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1𐋸٤。\U000e08aeۀ\U0007774a', strict=True)

    def test_uts46_1874(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1𐋸٤。\U000e08aeۀ\U0007774a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1𐋸٤。\U000e08aeۀ\U0007774a', strict=True)

    def test_uts46_1875(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-hqc3905q.xn--zkb83268gqee4a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-hqc3905q.xn--zkb83268gqee4a', strict=True)

    def test_uts46_1876(self):
        self.assertRaises(idna.IDNAError, idna.decode, '儭-｡𐹴Ⴢ\U00065ce0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '儭-｡𐹴Ⴢ\U00065ce0\u200c', strict=True)

    def test_uts46_1877(self):
        self.assertRaises(idna.IDNAError, idna.decode, '儭-。𐹴Ⴢ\U00065ce0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '儭-。𐹴Ⴢ\U00065ce0\u200c', strict=True)

    def test_uts46_1878(self):
        self.assertRaises(idna.IDNAError, idna.decode, '儭-。𐹴ⴢ\U00065ce0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '儭-。𐹴ⴢ\U00065ce0\u200c', strict=True)

    def test_uts46_1879(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----gz7a.xn--qlj9223eywx0b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----gz7a.xn--qlj9223eywx0b', strict=True)

    def test_uts46_1880(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----gz7a.xn--0ug472cfq0pus98b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----gz7a.xn--0ug472cfq0pus98b', strict=True)

    def test_uts46_1881(self):
        self.assertRaises(idna.IDNAError, idna.decode, '儭-｡𐹴ⴢ\U00065ce0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '儭-｡𐹴ⴢ\U00065ce0\u200c', strict=True)

    def test_uts46_1882(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----gz7a.xn--6nd5001kyw98a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----gz7a.xn--6nd5001kyw98a', strict=True)

    def test_uts46_1883(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----gz7a.xn--6nd249ejl4pusr7b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----gz7a.xn--6nd249ejl4pusr7b', strict=True)

    def test_uts46_1884(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟺𐋷ڹ．𞤭\U000bf361', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟺𐋷ڹ．𞤭\U000bf361', strict=True)

    def test_uts46_1885(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4𐋷ڹ.𞤭\U000bf361', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4𐋷ڹ.𞤭\U000bf361', strict=True)

    def test_uts46_1886(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4𐋷ڹ.𞤋\U000bf361', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4𐋷ڹ.𞤋\U000bf361', strict=True)

    def test_uts46_1887(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4-cvc5384q.xn--le6hi7322b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4-cvc5384q.xn--le6hi7322b', strict=True)

    def test_uts46_1888(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟺𐋷ڹ．𞤋\U000bf361', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟺𐋷ڹ．𞤋\U000bf361', strict=True)

    def test_uts46_1889(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯-ꡋ𑲣.⒈𐹭', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯-ꡋ𑲣.⒈𐹭', strict=True)

    def test_uts46_1890(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯-ꡋ𑲣.⒈𐹭', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯-ꡋ𑲣.⒈𐹭', strict=True)

    def test_uts46_1891(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯-ꡋ𑲣.1.𐹭', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯-ꡋ𑲣.1.𐹭', strict=True)

    def test_uts46_1892(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯-ꡋ𑲣.1.𐹭', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯-ꡋ𑲣.1.𐹭', strict=True)

    def test_uts46_1893(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ogox061d5i8d.1.xn--lo0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ogox061d5i8d.1.xn--lo0d', strict=True)

    def test_uts46_1894(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ogox061d5i8d.xn--tsh0666f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ogox061d5i8d.xn--tsh0666f', strict=True)

    def test_uts46_1895(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̰．\U000f0731蚀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̰．\U000f0731蚀', strict=True)

    def test_uts46_1896(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̰.\U000f0731蚀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̰.\U000f0731蚀', strict=True)

    def test_uts46_1897(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xta.xn--e91aw9417e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xta.xn--e91aw9417e', strict=True)

    def test_uts46_1898(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּႸ.𞡼𑇀ß⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּႸ.𞡼𑇀ß⃗', strict=True)

    def test_uts46_1899(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּႸ.𞡼𑇀ß⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּႸ.𞡼𑇀ß⃗', strict=True)

    def test_uts46_1900(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּⴘ.𞡼𑇀ß⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּⴘ.𞡼𑇀ß⃗', strict=True)

    def test_uts46_1901(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּႸ.𞡼𑇀SS⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּႸ.𞡼𑇀SS⃗', strict=True)

    def test_uts46_1902(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּⴘ.𞡼𑇀ss⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּⴘ.𞡼𑇀ss⃗', strict=True)

    def test_uts46_1903(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--kdb1d278n.xn--ss-yju5690ken9h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--kdb1d278n.xn--ss-yju5690ken9h', strict=True)

    def test_uts46_1904(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--kdb1d278n.xn--zca284nhg9nrrxg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--kdb1d278n.xn--zca284nhg9nrrxg', strict=True)

    def test_uts46_1905(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּⴘ.𞡼𑇀ß⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּⴘ.𞡼𑇀ß⃗', strict=True)

    def test_uts46_1906(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּႸ.𞡼𑇀SS⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּႸ.𞡼𑇀SS⃗', strict=True)

    def test_uts46_1907(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּⴘ.𞡼𑇀ss⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּⴘ.𞡼𑇀ss⃗', strict=True)

    def test_uts46_1908(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--kdb1d867b.xn--ss-yju5690ken9h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--kdb1d867b.xn--ss-yju5690ken9h', strict=True)

    def test_uts46_1909(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--kdb1d867b.xn--zca284nhg9nrrxg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--kdb1d867b.xn--zca284nhg9nrrxg', strict=True)

    def test_uts46_1910(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּႸ.𞡼𑇀ss⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּႸ.𞡼𑇀ss⃗', strict=True)

    def test_uts46_1911(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'יּႸ.𞡼𑇀ss⃗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'יּႸ.𞡼𑇀ss⃗', strict=True)

    def test_uts46_1912(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᮣ𐹰\U00081c53｡凬', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᮣ𐹰\U00081c53｡凬', strict=True)

    def test_uts46_1913(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᮣ𐹰\U00081c53。凬', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᮣ𐹰\U00081c53。凬', strict=True)

    def test_uts46_1914(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rxfz314ilg20c.xn--t9q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rxfz314ilg20c.xn--t9q', strict=True)

    def test_uts46_1915(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🢟🄈\u200dꡎ｡྄', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🢟🄈\u200dꡎ｡྄', strict=True)

    def test_uts46_1916(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🢟7,\u200dꡎ。྄', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🢟7,\u200dꡎ。྄', strict=True)

    def test_uts46_1917(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7,-gh9hg322i.xn--3ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7,-gh9hg322i.xn--3ed', strict=True)

    def test_uts46_1918(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7,-n1t0654eqo3o.xn--3ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7,-n1t0654eqo3o.xn--3ed', strict=True)

    def test_uts46_1919(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nc9aq743ds0e.xn--3ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nc9aq743ds0e.xn--3ed', strict=True)

    def test_uts46_1920(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug4874cfd0kbmg.xn--3ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug4874cfd0kbmg.xn--3ed', strict=True)

    def test_uts46_1921(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡔ。္ᢇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡔ。္ᢇ', strict=True)

    def test_uts46_1922(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tc9a.xn--9jd663b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tc9a.xn--9jd663b', strict=True)

    def test_uts46_1923(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⃫≮.𝨖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⃫≮.𝨖', strict=True)

    def test_uts46_1924(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⃫≮.𝨖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⃫≮.𝨖', strict=True)

    def test_uts46_1925(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--e1g71d.xn--772h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--e1g71d.xn--772h', strict=True)

    def test_uts46_1926(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴢ≯褦．ᠪߪႾݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴢ≯褦．ᠪߪႾݧ', strict=True)

    def test_uts46_1927(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴢ≯褦．ᠪߪႾݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴢ≯褦．ᠪߪႾݧ', strict=True)

    def test_uts46_1928(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴢ≯褦.ᠪߪႾݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴢ≯褦.ᠪߪႾݧ', strict=True)

    def test_uts46_1929(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴢ≯褦.ᠪߪႾݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴢ≯褦.ᠪߪႾݧ', strict=True)

    def test_uts46_1930(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴢ≯褦.ᠪߪⴞݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴢ≯褦.ᠪߪⴞݧ', strict=True)

    def test_uts46_1931(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴢ≯褦.ᠪߪⴞݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴢ≯褦.ᠪߪⴞݧ', strict=True)

    def test_uts46_1932(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴢ≯褦.ᠪߪⴞݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴢ≯褦.ᠪߪⴞݧ', strict=True)

    def test_uts46_1933(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴢ≯褦.ᠪߪⴞݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴢ≯褦.ᠪߪⴞݧ', strict=True)

    def test_uts46_1934(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh433bev8e.xn--rpb5x392bcyt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh433bev8e.xn--rpb5x392bcyt', strict=True)

    def test_uts46_1935(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴢ≯褦．ᠪߪⴞݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴢ≯褦．ᠪߪⴞݧ', strict=True)

    def test_uts46_1936(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴢ≯褦．ᠪߪⴞݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴢ≯褦．ᠪߪⴞݧ', strict=True)

    def test_uts46_1937(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴢ≯褦．ᠪߪⴞݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴢ≯褦．ᠪߪⴞݧ', strict=True)

    def test_uts46_1938(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴢ≯褦．ᠪߪⴞݧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴢ≯褦．ᠪߪⴞݧ', strict=True)

    def test_uts46_1939(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6nd461g478e.xn--rpb5x392bcyt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6nd461g478e.xn--rpb5x392bcyt', strict=True)

    def test_uts46_1940(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6nd461g478e.xn--rpb5x49td2h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6nd461g478e.xn--rpb5x49td2h', strict=True)

    def test_uts46_1941(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0008a246󠆒\u200c꥓。𞤙ٻꡘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0008a246󠆒\u200c꥓。𞤙ٻꡘ', strict=True)

    def test_uts46_1942(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0008a246󠆒\u200c꥓。𞤻ٻꡘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0008a246󠆒\u200c꥓。𞤻ٻꡘ', strict=True)

    def test_uts46_1943(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3j9al6189a.xn--0ib8893fegvj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3j9al6189a.xn--0ib8893fegvj', strict=True)

    def test_uts46_1944(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug8815chtz0e.xn--0ib8893fegvj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug8815chtz0e.xn--0ib8893fegvj', strict=True)

    def test_uts46_1945(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c.≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c.≯', strict=True)

    def test_uts46_1946(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c.≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c.≯', strict=True)

    def test_uts46_1947(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--hdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--hdh', strict=True)

    def test_uts46_1948(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--hdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--hdh', strict=True)

    def test_uts46_1949(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𰅧\U00063a60-．꯭-悜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𰅧\U00063a60-．꯭-悜', strict=True)

    def test_uts46_1950(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𰅧\U00063a60-.꯭-悜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𰅧\U00063a60-.꯭-悜', strict=True)

    def test_uts46_1951(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----7m53aj640l.xn----8f4br83t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----7m53aj640l.xn----8f4br83t', strict=True)

    def test_uts46_1952(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡉ\U000364e7⬞ᢜ.-\u200d𞣑\u202e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡉ\U000364e7⬞ᢜ.-\u200d𞣑\u202e', strict=True)

    def test_uts46_1953(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--87e0ol04cdl39e.xn----qinu247r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--87e0ol04cdl39e.xn----qinu247r', strict=True)

    def test_uts46_1954(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--87e0ol04cdl39e.xn----ugn5e3763s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--87e0ol04cdl39e.xn----ugn5e3763s', strict=True)

    def test_uts46_1955(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒐\u200c衃Ⴝ.ڂႴ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒐\u200c衃Ⴝ.ڂႴ', strict=True)

    def test_uts46_1956(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.\u200c衃Ⴝ.ڂႴ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.\u200c衃Ⴝ.ڂႴ', strict=True)

    def test_uts46_1957(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.\u200c衃ⴝ.ڂⴔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.\u200c衃ⴝ.ڂⴔ', strict=True)

    def test_uts46_1958(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.\u200c衃Ⴝ.ڂⴔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.\u200c衃Ⴝ.ڂⴔ', strict=True)

    def test_uts46_1959(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.xn--llj1920a.xn--7ib268q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.xn--llj1920a.xn--7ib268q', strict=True)

    def test_uts46_1960(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.xn--0ug862cbm5e.xn--7ib268q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.xn--0ug862cbm5e.xn--7ib268q', strict=True)

    def test_uts46_1961(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒐\u200c衃ⴝ.ڂⴔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒐\u200c衃ⴝ.ڂⴔ', strict=True)

    def test_uts46_1962(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒐\u200c衃Ⴝ.ڂⴔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒐\u200c衃Ⴝ.ڂⴔ', strict=True)

    def test_uts46_1963(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1shy52abz3f.xn--7ib268q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1shy52abz3f.xn--7ib268q', strict=True)

    def test_uts46_1964(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugx0px1izu2h.xn--7ib268q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugx0px1izu2h.xn--7ib268q', strict=True)

    def test_uts46_1965(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.xn--1nd9032d.xn--7ib268q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.xn--1nd9032d.xn--7ib268q', strict=True)

    def test_uts46_1966(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.xn--1nd159e1y2f.xn--7ib268q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.xn--1nd159e1y2f.xn--7ib268q', strict=True)

    def test_uts46_1967(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.xn--1nd9032d.xn--7ib433c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.xn--1nd9032d.xn--7ib433c', strict=True)

    def test_uts46_1968(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.xn--1nd159e1y2f.xn--7ib433c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.xn--1nd159e1y2f.xn--7ib433c', strict=True)

    def test_uts46_1969(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1nd362hy16e.xn--7ib268q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1nd362hy16e.xn--7ib268q', strict=True)

    def test_uts46_1970(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1nd159ecmd785k.xn--7ib268q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1nd159ecmd785k.xn--7ib268q', strict=True)

    def test_uts46_1971(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1nd362hy16e.xn--7ib433c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1nd362hy16e.xn--7ib433c', strict=True)

    def test_uts46_1972(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1nd159ecmd785k.xn--7ib433c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1nd159ecmd785k.xn--7ib433c', strict=True)

    def test_uts46_1973(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߡ\u200c。--⸬', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߡ\u200c。--⸬', strict=True)

    def test_uts46_1974(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8sb.xn-----iw2a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8sb.xn-----iw2a', strict=True)

    def test_uts46_1975(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8sb884j.xn-----iw2a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8sb884j.xn-----iw2a', strict=True)

    def test_uts46_1976(self):
        self.assertEqual(idna.decode('𞥓．ܘ', uts46=True, strict=True), '𞥓.ܘ')
        self.assertEqual(idna.encode('𞥓．ܘ', uts46=True, strict=True), b'xn--of6h.xn--inb')

    def test_uts46_1977(self):
        self.assertEqual(idna.decode('𞥓.ܘ', uts46=True, strict=True), '𞥓.ܘ')
        self.assertEqual(idna.encode('𞥓.ܘ', uts46=True, strict=True), b'xn--of6h.xn--inb')

    def test_uts46_1978(self):
        self.assertEqual(idna.decode('xn--of6h.xn--inb', uts46=True, strict=True), '𞥓.ܘ')
        self.assertEqual(idna.encode('xn--of6h.xn--inb', uts46=True, strict=True), b'xn--of6h.xn--inb')

    def test_uts46_1979(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄽-．-්', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄽-．-්', strict=True)

    def test_uts46_1980(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄽-.-්', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄽-.-්', strict=True)

    def test_uts46_1981(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn----ptf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn----ptf', strict=True)

    def test_uts46_1982(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠇝ݛ-.ᤧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠇝ݛ-.ᤧ', strict=True)

    def test_uts46_1983(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----k4c.xn--lff', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----k4c.xn--lff', strict=True)

    def test_uts46_1984(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤴󠆹⦉𐹺.꠆⒌\U000d8938', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤴󠆹⦉𐹺.꠆⒌\U000d8938', strict=True)

    def test_uts46_1985(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤴󠆹⦉𐹺.꠆5.\U000d8938', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤴󠆹⦉𐹺.꠆5.\U000d8938', strict=True)

    def test_uts46_1986(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤒󠆹⦉𐹺.꠆5.\U000d8938', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤒󠆹⦉𐹺.꠆5.\U000d8938', strict=True)

    def test_uts46_1987(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fuix729epewf.xn--5-w93e.xn--7b83e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fuix729epewf.xn--5-w93e.xn--7b83e', strict=True)

    def test_uts46_1988(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤒󠆹⦉𐹺.꠆⒌\U000d8938', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤒󠆹⦉𐹺.꠆⒌\U000d8938', strict=True)

    def test_uts46_1989(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fuix729epewf.xn--xsh5029b6e77i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fuix729epewf.xn--xsh5029b6e77i', strict=True)

    def test_uts46_1990(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄸₀。𑖿\u200c𐦂\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄸₀。𑖿\u200c𐦂\u200d', strict=True)

    def test_uts46_1991(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄸0。𑖿\u200c𐦂\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄸0。𑖿\u200c𐦂\u200d', strict=True)

    def test_uts46_1992(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.xn--mn9cz2s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.xn--mn9cz2s', strict=True)

    def test_uts46_1993(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.xn--0ugc8040p9hk', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.xn--0ugc8040p9hk', strict=True)

    def test_uts46_1994(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴚ𐋸󠄄。𝟝ퟶ်', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴚ𐋸󠄄。𝟝ퟶ်', strict=True)

    def test_uts46_1995(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴚ𐋸󠄄。5ퟶ်', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴚ𐋸󠄄。5ퟶ်', strict=True)

    def test_uts46_1996(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴚ𐋸󠄄。5ퟶ်', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴚ𐋸󠄄。5ퟶ်', strict=True)

    def test_uts46_1997(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ilj2659d.xn--5-dug9054m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ilj2659d.xn--5-dug9054m', strict=True)

    def test_uts46_1998(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴚ𐋸.5ퟶ်', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴚ𐋸.5ퟶ်', strict=True)

    def test_uts46_1999(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴚ𐋸.5ퟶ်', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴚ𐋸.5ퟶ်', strict=True)

    def test_uts46_2000(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴚ𐋸󠄄。𝟝ퟶ်', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴚ𐋸󠄄。𝟝ퟶ်', strict=True)

    def test_uts46_2001(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ynd2415j.xn--5-dug9054m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ynd2415j.xn--5-dug9054m', strict=True)

    def test_uts46_2002(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-ᠹ﹪.ᷡᤢ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-ᠹ﹪.ᷡᤢ', strict=True)

    def test_uts46_2003(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-ᠹ%.ᷡᤢ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-ᠹ%.ᷡᤢ', strict=True)

    def test_uts46_2004(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---%-u4o.xn--gff52t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---%-u4o.xn--gff52t', strict=True)

    def test_uts46_2005(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---%-u4oy48b.xn--gff52t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---%-u4oy48b.xn--gff52t', strict=True)

    def test_uts46_2006(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----c6jx047j.xn--gff52t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----c6jx047j.xn--gff52t', strict=True)

    def test_uts46_2007(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----c6j614b1z4v.xn--gff52t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----c6j614b1z4v.xn--gff52t', strict=True)

    def test_uts46_2008(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠.ᠿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠.ᠿ', strict=True)

    def test_uts46_2009(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠.ᠿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠.ᠿ', strict=True)

    def test_uts46_2010(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch.xn--y7e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch.xn--y7e', strict=True)

    def test_uts46_2011(self):
        self.assertEqual(idna.decode('ܣ֣｡㌪', uts46=True, strict=True), 'ܣ֣.ハイツ')
        self.assertEqual(idna.encode('ܣ֣｡㌪', uts46=True, strict=True), b'xn--ucb18e.xn--eck4c5a')

    def test_uts46_2012(self):
        self.assertEqual(idna.decode('ܣ֣。ハイツ', uts46=True, strict=True), 'ܣ֣.ハイツ')
        self.assertEqual(idna.encode('ܣ֣。ハイツ', uts46=True, strict=True), b'xn--ucb18e.xn--eck4c5a')

    def test_uts46_2013(self):
        self.assertEqual(idna.decode('xn--ucb18e.xn--eck4c5a', uts46=True, strict=True), 'ܣ֣.ハイツ')
        self.assertEqual(idna.encode('xn--ucb18e.xn--eck4c5a', uts46=True, strict=True), b'xn--ucb18e.xn--eck4c5a')

    def test_uts46_2014(self):
        self.assertEqual(idna.decode('ܣ֣.ハイツ', uts46=True, strict=True), 'ܣ֣.ハイツ')
        self.assertEqual(idna.encode('ܣ֣.ハイツ', uts46=True, strict=True), b'xn--ucb18e.xn--eck4c5a')

    def test_uts46_2015(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ede5󠆀≮.⵿-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ede5󠆀≮.⵿-', strict=True)

    def test_uts46_2016(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ede5󠆀≮.⵿-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ede5󠆀≮.⵿-', strict=True)

    def test_uts46_2017(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdhx802p.xn----i2s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdhx802p.xn----i2s', strict=True)

    def test_uts46_2018(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₆榎\U000a658e്｡𞤅ۭﱚ\U000e0ba8', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₆榎\U000a658e്｡𞤅ۭﱚ\U000e0ba8', strict=True)

    def test_uts46_2019(self):
        self.assertRaises(idna.IDNAError, idna.decode, '6榎\U000a658e്。𞤅ۭيي\U000e0ba8', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '6榎\U000a658e്。𞤅ۭيي\U000e0ba8', strict=True)

    def test_uts46_2020(self):
        self.assertRaises(idna.IDNAError, idna.decode, '6榎\U000a658e്。𞤧ۭيي\U000e0ba8', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '6榎\U000a658e്。𞤧ۭيي\U000e0ba8', strict=True)

    def test_uts46_2021(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6-kmf4691ejv41j.xn--mhba10ch545mn8v8h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6-kmf4691ejv41j.xn--mhba10ch545mn8v8h', strict=True)

    def test_uts46_2022(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₆榎\U000a658e്｡𞤧ۭﱚ\U000e0ba8', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₆榎\U000a658e്｡𞤧ۭﱚ\U000e0ba8', strict=True)

    def test_uts46_2023(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𣩫．\U0008c472', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𣩫．\U0008c472', strict=True)

    def test_uts46_2024(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𣩫.\U0008c472', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𣩫.\U0008c472', strict=True)

    def test_uts46_2025(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--td3j.xn--4628b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--td3j.xn--4628b', strict=True)

    def test_uts46_2026(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d︒｡ڹ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d︒｡ڹ\u200c', strict=True)

    def test_uts46_2027(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y86c.xn--skb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y86c.xn--skb', strict=True)

    def test_uts46_2028(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug2658f.xn--skb080k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug2658f.xn--skb080k', strict=True)

    def test_uts46_2029(self):
        self.assertEqual(idna.decode('xn--skb', uts46=True, strict=True), 'ڹ')
        self.assertEqual(idna.encode('xn--skb', uts46=True, strict=True), b'xn--skb')

    def test_uts46_2030(self):
        self.assertEqual(idna.decode('ڹ', uts46=True, strict=True), 'ڹ')
        self.assertEqual(idna.encode('ڹ', uts46=True, strict=True), b'xn--skb')

    def test_uts46_2031(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹦\u200c𐹶。\u206d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹦\u200c𐹶。\u206d', strict=True)

    def test_uts46_2032(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--eo0d6a.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--eo0d6a.', strict=True)

    def test_uts46_2033(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug4994goba.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug4994goba.', strict=True)

    def test_uts46_2034(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--eo0d6a.xn--sxg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--eo0d6a.xn--sxg', strict=True)

    def test_uts46_2035(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug4994goba.xn--sxg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug4994goba.xn--sxg', strict=True)

    def test_uts46_2036(self):
        self.assertRaises(idna.IDNAError, idna.decode, '్𝨾֩𝟭。-𑜨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '్𝨾֩𝟭。-𑜨', strict=True)

    def test_uts46_2037(self):
        self.assertRaises(idna.IDNAError, idna.decode, '్𝨾֩1。-𑜨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '్𝨾֩1。-𑜨', strict=True)

    def test_uts46_2038(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-rfc312cdp45c.xn----nq0j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-rfc312cdp45c.xn----nq0j', strict=True)

    def test_uts46_2039(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a3fc8。뙏', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a3fc8。뙏', strict=True)

    def test_uts46_2040(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a3fc8。뙏', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a3fc8。뙏', strict=True)

    def test_uts46_2041(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ph26c.xn--281b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ph26c.xn--281b', strict=True)

    def test_uts46_2042(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00055a1a󠄌\U000d1f40ᡀ.ࢶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00055a1a󠄌\U000d1f40ᡀ.ࢶ', strict=True)

    def test_uts46_2043(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--z7e98100evc01b.xn--czb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--z7e98100evc01b.xn--czb', strict=True)

    def test_uts46_2044(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d｡\U0004505b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d｡\U0004505b', strict=True)

    def test_uts46_2045(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。\U0004505b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。\U0004505b', strict=True)

    def test_uts46_2046(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--6x4u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--6x4u', strict=True)

    def test_uts46_2047(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.xn--6x4u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.xn--6x4u', strict=True)

    def test_uts46_2048(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࡋ皥．-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࡋ皥．-', strict=True)

    def test_uts46_2049(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࡋ皥.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࡋ皥.-', strict=True)

    def test_uts46_2050(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9vb4167c.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9vb4167c.-', strict=True)

    def test_uts46_2051(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000108f8̕𐮇．⒈ꡦ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000108f8̕𐮇．⒈ꡦ', strict=True)

    def test_uts46_2052(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000108f8̕𐮇.1.ꡦ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000108f8̕𐮇.1.ꡦ', strict=True)

    def test_uts46_2053(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5sa9915kgvb.1.xn--cd9a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5sa9915kgvb.1.xn--cd9a', strict=True)

    def test_uts46_2054(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5sa9915kgvb.xn--tshw539b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5sa9915kgvb.xn--tshw539b', strict=True)

    def test_uts46_2055(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴛ\u200c֢\u200d。ﾠā𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴛ\u200c֢\u200d。ﾠā𐹦', strict=True)

    def test_uts46_2056(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴛ\u200c֢\u200d。ﾠā𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴛ\u200c֢\u200d。ﾠā𐹦', strict=True)

    def test_uts46_2057(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴛ\u200c֢\u200d。ᅠā𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴛ\u200c֢\u200d。ᅠā𐹦', strict=True)

    def test_uts46_2058(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴛ\u200c֢\u200d。ᅠā𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴛ\u200c֢\u200d。ᅠā𐹦', strict=True)

    def test_uts46_2059(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴛ\u200c֢\u200d。ᅠā𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴛ\u200c֢\u200d。ᅠā𐹦', strict=True)

    def test_uts46_2060(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴛ\u200c֢\u200d。ᅠā𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴛ\u200c֢\u200d。ᅠā𐹦', strict=True)

    def test_uts46_2061(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴛ\u200c֢\u200d。ᅠĀ𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴛ\u200c֢\u200d。ᅠĀ𐹦', strict=True)

    def test_uts46_2062(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴛ\u200c֢\u200d。ᅠĀ𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴛ\u200c֢\u200d。ᅠĀ𐹦', strict=True)

    def test_uts46_2063(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb323r.xn--yda4409k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb323r.xn--yda4409k', strict=True)

    def test_uts46_2064(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb736kea974k.xn--yda4409k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb736kea974k.xn--yda4409k', strict=True)

    def test_uts46_2065(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴛ\u200c֢\u200d。ﾠā𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴛ\u200c֢\u200d。ﾠā𐹦', strict=True)

    def test_uts46_2066(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴛ\u200c֢\u200d。ﾠā𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴛ\u200c֢\u200d。ﾠā𐹦', strict=True)

    def test_uts46_2067(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴛ\u200c֢\u200d。ﾠĀ𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴛ\u200c֢\u200d。ﾠĀ𐹦', strict=True)

    def test_uts46_2068(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴛ\u200c֢\u200d。ﾠĀ𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴛ\u200c֢\u200d。ﾠĀ𐹦', strict=True)

    def test_uts46_2069(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb597c.xn--yda594fdn5q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb597c.xn--yda594fdn5q', strict=True)

    def test_uts46_2070(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb597cdmmfa.xn--yda594fdn5q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb597cdmmfa.xn--yda594fdn5q', strict=True)

    def test_uts46_2071(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb323r.xn--yda594fdn5q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb323r.xn--yda594fdn5q', strict=True)

    def test_uts46_2072(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb736kea974k.xn--yda594fdn5q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb736kea974k.xn--yda594fdn5q', strict=True)

    def test_uts46_2073(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb597c.xn--yda9741khjj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb597c.xn--yda9741khjj', strict=True)

    def test_uts46_2074(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb597cdmmfa.xn--yda9741khjj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb597cdmmfa.xn--yda9741khjj', strict=True)

    def test_uts46_2075(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb323r.xn--yda9741khjj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb323r.xn--yda9741khjj', strict=True)

    def test_uts46_2076(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tcb736kea974k.xn--yda9741khjj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tcb736kea974k.xn--yda9741khjj', strict=True)

    def test_uts46_2077(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\ufff9\u200c｡曳⾑𐋰≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\ufff9\u200c｡曳⾑𐋰≯', strict=True)

    def test_uts46_2078(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\ufff9\u200c｡曳⾑𐋰≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\ufff9\u200c｡曳⾑𐋰≯', strict=True)

    def test_uts46_2079(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\ufff9\u200c。曳襾𐋰≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\ufff9\u200c。曳襾𐋰≯', strict=True)

    def test_uts46_2080(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\ufff9\u200c。曳襾𐋰≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\ufff9\u200c。曳襾𐋰≯', strict=True)

    def test_uts46_2081(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vn7c.xn--hdh501y8wvfs5h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vn7c.xn--hdh501y8wvfs5h', strict=True)

    def test_uts46_2082(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug2139f.xn--hdh501y8wvfs5h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug2139f.xn--hdh501y8wvfs5h', strict=True)

    def test_uts46_2083(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯⒈。ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯⒈。ß', strict=True)

    def test_uts46_2084(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯⒈。ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯⒈。ß', strict=True)

    def test_uts46_2085(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯1.。ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯1.。ß', strict=True)

    def test_uts46_2086(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯1.。ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯1.。ß', strict=True)

    def test_uts46_2087(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯1.。SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯1.。SS', strict=True)

    def test_uts46_2088(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯1.。SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯1.。SS', strict=True)

    def test_uts46_2089(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯1.。ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯1.。ss', strict=True)

    def test_uts46_2090(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯1.。ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯1.。ss', strict=True)

    def test_uts46_2091(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯1.。Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯1.。Ss', strict=True)

    def test_uts46_2092(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯1.。Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯1.。Ss', strict=True)

    def test_uts46_2093(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-ogo..ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-ogo..ss', strict=True)

    def test_uts46_2094(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-ogo..xn--zca', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-ogo..xn--zca', strict=True)

    def test_uts46_2095(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯⒈。SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯⒈。SS', strict=True)

    def test_uts46_2096(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯⒈。SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯⒈。SS', strict=True)

    def test_uts46_2097(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯⒈。ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯⒈。ss', strict=True)

    def test_uts46_2098(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯⒈。ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯⒈。ss', strict=True)

    def test_uts46_2099(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯⒈。Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯⒈。Ss', strict=True)

    def test_uts46_2100(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯⒈。Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯⒈。Ss', strict=True)

    def test_uts46_2101(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh84f.ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh84f.ss', strict=True)

    def test_uts46_2102(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh84f.xn--zca', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh84f.xn--zca', strict=True)

    def test_uts46_2103(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٧\u200dﮖ｡ߚ-₆Ⴙ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٧\u200dﮖ｡ߚ-₆Ⴙ', strict=True)

    def test_uts46_2104(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٧\u200dڳ。ߚ-6Ⴙ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٧\u200dڳ。ߚ-6Ⴙ', strict=True)

    def test_uts46_2105(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٧\u200dڳ。ߚ-6ⴙ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٧\u200dڳ。ߚ-6ⴙ', strict=True)

    def test_uts46_2106(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gib6m.xn---6-lve6529a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gib6m.xn---6-lve6529a', strict=True)

    def test_uts46_2107(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gib6m343e.xn---6-lve6529a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gib6m343e.xn---6-lve6529a', strict=True)

    def test_uts46_2108(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٧\u200dﮖ｡ߚ-₆ⴙ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٧\u200dﮖ｡ߚ-₆ⴙ', strict=True)

    def test_uts46_2109(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gib6m.xn---6-lve002g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gib6m.xn---6-lve002g', strict=True)

    def test_uts46_2110(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gib6m343e.xn---6-lve002g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gib6m343e.xn---6-lve002g', strict=True)

    def test_uts46_2111(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c｡≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c｡≠', strict=True)

    def test_uts46_2112(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c｡≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c｡≠', strict=True)

    def test_uts46_2113(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c。≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c。≠', strict=True)

    def test_uts46_2114(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c。≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c。≠', strict=True)

    def test_uts46_2115(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--1ch', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--1ch', strict=True)

    def test_uts46_2116(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--1ch', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--1ch', strict=True)

    def test_uts46_2117(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑖿𝨔.ᡟ𑖿ᭂ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑖿𝨔.ᡟ𑖿ᭂ\u200c', strict=True)

    def test_uts46_2118(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--461dw464a.xn--v8e29loy65a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--461dw464a.xn--v8e29loy65a', strict=True)

    def test_uts46_2119(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--461dw464a.xn--v8e29ldzfo952a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--461dw464a.xn--v8e29ldzfo952a', strict=True)

    def test_uts46_2120(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000948f3\u200d\U00091771.𖬴Ↄ≠-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000948f3\u200d\U00091771.𖬴Ↄ≠-', strict=True)

    def test_uts46_2121(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000948f3\u200d\U00091771.𖬴Ↄ≠-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000948f3\u200d\U00091771.𖬴Ↄ≠-', strict=True)

    def test_uts46_2122(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000948f3\u200d\U00091771.𖬴ↄ≠-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000948f3\u200d\U00091771.𖬴ↄ≠-', strict=True)

    def test_uts46_2123(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000948f3\u200d\U00091771.𖬴ↄ≠-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000948f3\u200d\U00091771.𖬴ↄ≠-', strict=True)

    def test_uts46_2124(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6j00chy9a.xn----81n51bt713h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6j00chy9a.xn----81n51bt713h', strict=True)

    def test_uts46_2125(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug15151gkb5a.xn----81n51bt713h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug15151gkb5a.xn----81n51bt713h', strict=True)

    def test_uts46_2126(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6j00chy9a.xn----61n81bt713h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6j00chy9a.xn----61n81bt713h', strict=True)

    def test_uts46_2127(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug15151gkb5a.xn----61n81bt713h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug15151gkb5a.xn----61n81bt713h', strict=True)

    def test_uts46_2128(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߢς\u200d𝟳。蔑\U0009b5a2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߢς\u200d𝟳。蔑\U0009b5a2', strict=True)

    def test_uts46_2129(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߢς\u200d7。蔑\U0009b5a2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߢς\u200d7。蔑\U0009b5a2', strict=True)

    def test_uts46_2130(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߢΣ\u200d7。蔑\U0009b5a2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߢΣ\u200d7。蔑\U0009b5a2', strict=True)

    def test_uts46_2131(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߢσ\u200d7。蔑\U0009b5a2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߢσ\u200d7。蔑\U0009b5a2', strict=True)

    def test_uts46_2132(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7-zmb872a.xn--wy1ao4929b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7-zmb872a.xn--wy1ao4929b', strict=True)

    def test_uts46_2133(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7-zmb872aez5a.xn--wy1ao4929b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7-zmb872aez5a.xn--wy1ao4929b', strict=True)

    def test_uts46_2134(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7-xmb182aez5a.xn--wy1ao4929b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7-xmb182aez5a.xn--wy1ao4929b', strict=True)

    def test_uts46_2135(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߢΣ\u200d𝟳。蔑\U0009b5a2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߢΣ\u200d𝟳。蔑\U0009b5a2', strict=True)

    def test_uts46_2136(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߢσ\u200d𝟳。蔑\U0009b5a2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߢσ\u200d𝟳。蔑\U0009b5a2', strict=True)

    def test_uts46_2137(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹰.\u0600', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹰.\u0600', strict=True)

    def test_uts46_2138(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--oo0d.xn--ifb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--oo0d.xn--ifb', strict=True)

    def test_uts46_2139(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ࢨ.𱠖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ࢨ.𱠖', strict=True)

    def test_uts46_2140(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----mod.xn--5o9n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----mod.xn--5o9n', strict=True)

    def test_uts46_2141(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𞱸󠇀。誆⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𞱸󠇀。誆⒈', strict=True)

    def test_uts46_2142(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𞱸󠇀。誆⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𞱸󠇀。誆⒈', strict=True)

    def test_uts46_2143(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𞱸󠇀。誆1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𞱸󠇀。誆1.', strict=True)

    def test_uts46_2144(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𞱸󠇀。誆1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𞱸󠇀。誆1.', strict=True)

    def test_uts46_2145(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh7151p.xn--1-dy1d.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh7151p.xn--1-dy1d.', strict=True)

    def test_uts46_2146(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh7151p.xn--tsh1248a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh7151p.xn--tsh1248a', strict=True)

    def test_uts46_2147(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ؖ𞥙䐊ِ．︒م↺ڜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ؖ𞥙䐊ِ．︒م↺ڜ', strict=True)

    def test_uts46_2148(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ؖ𞥙䐊ِ.。م↺ڜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ؖ𞥙䐊ِ.。م↺ڜ', strict=True)

    def test_uts46_2149(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4fb0j490qjg4x..xn--hhb8o948e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4fb0j490qjg4x..xn--hhb8o948e', strict=True)

    def test_uts46_2150(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4fb0j490qjg4x.xn--hhb8o948euo5r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4fb0j490qjg4x.xn--hhb8o948euo5r', strict=True)

    def test_uts46_2151(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.\u200cૅ\U000e9e24۴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.\u200cૅ\U000e9e24۴', strict=True)

    def test_uts46_2152(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.\u200cૅ\U000e9e24۴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.\u200cૅ\U000e9e24۴', strict=True)

    def test_uts46_2153(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---?-6g4k75207c.xn--hmb76q74166b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---?-6g4k75207c.xn--hmb76q74166b', strict=True)

    def test_uts46_2154(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---?-6g4k75207c.xn--hmb76q48y18505a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---?-6g4k75207c.xn--hmb76q48y18505a', strict=True)

    def test_uts46_2155(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.xn--hmb76q74166b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.xn--hmb76q74166b', strict=True)

    def test_uts46_2156(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.xn--hmb76q74166b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.xn--hmb76q74166b', strict=True)

    def test_uts46_2157(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.XN--HMB76Q74166B', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.XN--HMB76Q74166B', strict=True)

    def test_uts46_2158(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.XN--HMB76Q74166B', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.XN--HMB76Q74166B', strict=True)

    def test_uts46_2159(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.Xn--Hmb76q74166b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.Xn--Hmb76q74166b', strict=True)

    def test_uts46_2160(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.Xn--Hmb76q74166b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.Xn--Hmb76q74166b', strict=True)

    def test_uts46_2161(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.xn--hmb76q48y18505a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.xn--hmb76q48y18505a', strict=True)

    def test_uts46_2162(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.xn--hmb76q48y18505a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.xn--hmb76q48y18505a', strict=True)

    def test_uts46_2163(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.XN--HMB76Q48Y18505A', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.XN--HMB76Q48Y18505A', strict=True)

    def test_uts46_2164(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.XN--HMB76Q48Y18505A', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.XN--HMB76Q48Y18505A', strict=True)

    def test_uts46_2165(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.Xn--Hmb76q48y18505a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.Xn--Hmb76q48y18505a', strict=True)

    def test_uts46_2166(self):
        self.assertRaises(idna.IDNAError, idna.decode, '퀬-?\U00076cd2.Xn--Hmb76q48y18505a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '퀬-?\U00076cd2.Xn--Hmb76q48y18505a', strict=True)

    def test_uts46_2167(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴌ.𐹾︒𑁿\U0001ef84', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴌ.𐹾︒𑁿\U0001ef84', strict=True)

    def test_uts46_2168(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴌ.𐹾。𑁿\U0001ef84', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴌ.𐹾。𑁿\U0001ef84', strict=True)

    def test_uts46_2169(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴌ.𐹾。𑁿\U0001ef84', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴌ.𐹾。𑁿\U0001ef84', strict=True)

    def test_uts46_2170(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3kj.xn--2o0d.xn--q30dg029a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3kj.xn--2o0d.xn--q30dg029a', strict=True)

    def test_uts46_2171(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴌ.𐹾︒𑁿\U0001ef84', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴌ.𐹾︒𑁿\U0001ef84', strict=True)

    def test_uts46_2172(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3kj.xn--y86c030a9ob6374b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3kj.xn--y86c030a9ob6374b', strict=True)

    def test_uts46_2173(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--knd.xn--2o0d.xn--q30dg029a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--knd.xn--2o0d.xn--q30dg029a', strict=True)

    def test_uts46_2174(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--knd.xn--y86c030a9ob6374b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--knd.xn--y86c030a9ob6374b', strict=True)

    def test_uts46_2175(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000677bf╏。\U0001ea55\U000e007e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000677bf╏。\U0001ea55\U000e007e', strict=True)

    def test_uts46_2176(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--iyh90030d.xn--1m6hs0260c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--iyh90030d.xn--1m6hs0260c', strict=True)

    def test_uts46_2177(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d┮󠇐．ఀ్᜴\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d┮󠇐．ఀ్᜴\u200d', strict=True)

    def test_uts46_2178(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d┮󠇐.ఀ్᜴\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d┮󠇐.ఀ్᜴\u200d', strict=True)

    def test_uts46_2179(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--kxh.xn--eoc8m432a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--kxh.xn--eoc8m432a', strict=True)

    def test_uts46_2180(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug04r.xn--eoc8m432a40i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug04r.xn--eoc8m432a40i', strict=True)

    def test_uts46_2181(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000b96aa｡🄂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000b96aa｡🄂', strict=True)

    def test_uts46_2182(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000b96aa。1,', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000b96aa。1,', strict=True)

    def test_uts46_2183(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n433d.1,', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n433d.1,', strict=True)

    def test_uts46_2184(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n433d.xn--v07h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n433d.xn--v07h', strict=True)

    def test_uts46_2185(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑍨刍.🛦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑍨刍.🛦', strict=True)

    def test_uts46_2186(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rbry728b.xn--y88h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rbry728b.xn--y88h', strict=True)

    def test_uts46_2187(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e030f3｡ᯱ𝟒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e030f3｡ᯱ𝟒', strict=True)

    def test_uts46_2188(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e030f3。ᯱ4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e030f3。ᯱ4', strict=True)

    def test_uts46_2189(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-ib31m.xn--4-pql', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-ib31m.xn--4-pql', strict=True)

    def test_uts46_2190(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڇ６Ⴔ辘.ﴢڇ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڇ６Ⴔ辘.ﴢڇ\u200c', strict=True)

    def test_uts46_2191(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڇ6Ⴔ辘.صيڇ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڇ6Ⴔ辘.صيڇ\u200c', strict=True)

    def test_uts46_2192(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڇ6ⴔ辘.صيڇ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڇ6ⴔ辘.صيڇ\u200c', strict=True)

    def test_uts46_2193(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6-gsc2270akm6f.xn--0gb6bxk', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6-gsc2270akm6f.xn--0gb6bxk', strict=True)

    def test_uts46_2194(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6-gsc2270akm6f.xn--0gb6bxkx18g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6-gsc2270akm6f.xn--0gb6bxkx18g', strict=True)

    def test_uts46_2195(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڇ６ⴔ辘.ﴢڇ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڇ６ⴔ辘.ﴢڇ\u200c', strict=True)

    def test_uts46_2196(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6-gsc039eqq6k.xn--0gb6bxk', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6-gsc039eqq6k.xn--0gb6bxk', strict=True)

    def test_uts46_2197(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6-gsc039eqq6k.xn--0gb6bxkx18g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6-gsc039eqq6k.xn--0gb6bxkx18g', strict=True)

    def test_uts46_2198(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄍.𐮭\U0001ec2c\U000bbade۹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄍.𐮭\U0001ec2c\U000bbade۹', strict=True)

    def test_uts46_2199(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--mmb3954kd0uf1zx7f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--mmb3954kd0uf1zx7f', strict=True)

    def test_uts46_2200(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\ua87d≯．\U000bbc80\U00092cc4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\ua87d≯．\U000bbc80\U00092cc4', strict=True)

    def test_uts46_2201(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\ua87d≯．\U000bbc80\U00092cc4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\ua87d≯．\U000bbc80\U00092cc4', strict=True)

    def test_uts46_2202(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\ua87d≯.\U000bbc80\U00092cc4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\ua87d≯.\U000bbc80\U00092cc4', strict=True)

    def test_uts46_2203(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\ua87d≯.\U000bbc80\U00092cc4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\ua87d≯.\U000bbc80\U00092cc4', strict=True)

    def test_uts46_2204(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh8193c.xn--5z40cp629b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh8193c.xn--5z40cp629b', strict=True)

    def test_uts46_2205(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ςოٻ.ςܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ςოٻ.ςܔ', strict=True)

    def test_uts46_2206(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ΣᲝٻ.Σܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ΣᲝٻ.Σܔ', strict=True)

    def test_uts46_2207(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σოٻ.σܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σოٻ.σܔ', strict=True)

    def test_uts46_2208(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σოٻ.σܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σოٻ.σܔ', strict=True)

    def test_uts46_2209(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa60l26n.xn--4xa21o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa60l26n.xn--4xa21o', strict=True)

    def test_uts46_2210(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σოٻ.ςܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σოٻ.ςܔ', strict=True)

    def test_uts46_2211(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σოٻ.ςܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σოٻ.ςܔ', strict=True)

    def test_uts46_2212(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa60l26n.xn--3xa41o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa60l26n.xn--3xa41o', strict=True)

    def test_uts46_2213(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa80l26n.xn--3xa41o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa80l26n.xn--3xa41o', strict=True)

    def test_uts46_2214(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σოٻ.Σܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σოٻ.Σܔ', strict=True)

    def test_uts46_2215(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0008459a݈𠄯ݟ｡\U000e06e9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0008459a݈𠄯ݟ｡\U000e06e9', strict=True)

    def test_uts46_2216(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0008459a݈𠄯ݟ。\U000e06e9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0008459a݈𠄯ݟ。\U000e06e9', strict=True)

    def test_uts46_2217(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vob0c4369twfv8b.xn--kl46e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vob0c4369twfv8b.xn--kl46e', strict=True)

    def test_uts46_2218(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0cdb．\u200d䤫≠Ⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0cdb．\u200d䤫≠Ⴞ', strict=True)

    def test_uts46_2219(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0cdb．\u200d䤫≠Ⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0cdb．\u200d䤫≠Ⴞ', strict=True)

    def test_uts46_2220(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0cdb.\u200d䤫≠Ⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0cdb.\u200d䤫≠Ⴞ', strict=True)

    def test_uts46_2221(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0cdb.\u200d䤫≠Ⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0cdb.\u200d䤫≠Ⴞ', strict=True)

    def test_uts46_2222(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0cdb.\u200d䤫≠ⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0cdb.\u200d䤫≠ⴞ', strict=True)

    def test_uts46_2223(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0cdb.\u200d䤫≠ⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0cdb.\u200d䤫≠ⴞ', strict=True)

    def test_uts46_2224(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1t56e.xn--1ch153bqvw', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1t56e.xn--1ch153bqvw', strict=True)

    def test_uts46_2225(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1t56e.xn--1ug73gzzpwi3a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1t56e.xn--1ug73gzzpwi3a', strict=True)

    def test_uts46_2226(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0cdb．\u200d䤫≠ⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0cdb．\u200d䤫≠ⴞ', strict=True)

    def test_uts46_2227(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0cdb．\u200d䤫≠ⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0cdb．\u200d䤫≠ⴞ', strict=True)

    def test_uts46_2228(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1t56e.xn--2nd141ghl2a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1t56e.xn--2nd141ghl2a', strict=True)

    def test_uts46_2229(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1t56e.xn--2nd159e9vb743e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1t56e.xn--2nd159e9vb743e', strict=True)

    def test_uts46_2230(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐽘𑈵．𐹣🕥', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐽘𑈵．𐹣🕥', strict=True)

    def test_uts46_2231(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐽘𑈵.𐹣🕥', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐽘𑈵.𐹣🕥', strict=True)

    def test_uts46_2232(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bv0d02c.xn--bo0dq650b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bv0d02c.xn--bo0dq650b', strict=True)

    def test_uts46_2233(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒊⒈𑁄。9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒊⒈𑁄。9', strict=True)

    def test_uts46_2234(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3.1.𑁄。9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3.1.𑁄。9', strict=True)

    def test_uts46_2235(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3.1.xn--110d.j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3.1.xn--110d.j', strict=True)

    def test_uts46_2236(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tshd3512p.j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tshd3512p.j', strict=True)

    def test_uts46_2237(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200cⷱ≮．𐹱\U000ad3f44₉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200cⷱ≮．𐹱\U000ad3f44₉', strict=True)

    def test_uts46_2238(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200cⷱ≮．𐹱\U000ad3f44₉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200cⷱ≮．𐹱\U000ad3f44₉', strict=True)

    def test_uts46_2239(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200cⷱ≮.𐹱\U000ad3f449', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200cⷱ≮.𐹱\U000ad3f449', strict=True)

    def test_uts46_2240(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200cⷱ≮.𐹱\U000ad3f449', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200cⷱ≮.𐹱\U000ad3f449', strict=True)

    def test_uts46_2241(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ngo823c.xn--49-ki3om2611f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ngo823c.xn--49-ki3om2611f', strict=True)

    def test_uts46_2242(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----sgn20i14s.xn--49-ki3om2611f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----sgn20i14s.xn--49-ki3om2611f', strict=True)

    def test_uts46_2243(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≯딾｡ࡇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≯딾｡ࡇ', strict=True)

    def test_uts46_2244(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≯딾｡ࡇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≯딾｡ࡇ', strict=True)

    def test_uts46_2245(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≯딾。ࡇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≯딾。ࡇ', strict=True)

    def test_uts46_2246(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≯딾。ࡇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≯딾。ࡇ', strict=True)

    def test_uts46_2247(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----pgow547d.xn--5vb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----pgow547d.xn--5vb', strict=True)

    def test_uts46_2248(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑙢⒈𐹠-｡\U000e05d0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑙢⒈𐹠-｡\U000e05d0\u200c', strict=True)

    def test_uts46_2249(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑙢1.𐹠-。\U000e05d0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑙢1.𐹠-。\U000e05d0\u200c', strict=True)

    def test_uts46_2250(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-bf0j.xn----516i.xn--jd46e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-bf0j.xn----516i.xn--jd46e', strict=True)

    def test_uts46_2251(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-bf0j.xn----516i.xn--0ug23321l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-bf0j.xn----516i.xn--0ug23321l', strict=True)

    def test_uts46_2252(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----dcpy090hiyg.xn--jd46e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----dcpy090hiyg.xn--jd46e', strict=True)

    def test_uts46_2253(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----dcpy090hiyg.xn--0ug23321l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----dcpy090hiyg.xn--0ug23321l', strict=True)

    def test_uts46_2254(self):
        self.assertRaises(idna.IDNAError, idna.decode, '͊．𐨎', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '͊．𐨎', strict=True)

    def test_uts46_2255(self):
        self.assertRaises(idna.IDNAError, idna.decode, '͊.𐨎', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '͊.𐨎', strict=True)

    def test_uts46_2256(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--oua.xn--mr9c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--oua.xn--mr9c', strict=True)

    def test_uts46_2257(self):
        self.assertRaises(idna.IDNAError, idna.decode, '훉≮｡ิ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '훉≮｡ิ', strict=True)

    def test_uts46_2258(self):
        self.assertRaises(idna.IDNAError, idna.decode, '훉≮｡ิ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '훉≮｡ิ', strict=True)

    def test_uts46_2259(self):
        self.assertRaises(idna.IDNAError, idna.decode, '훉≮。ิ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '훉≮。ิ', strict=True)

    def test_uts46_2260(self):
        self.assertRaises(idna.IDNAError, idna.decode, '훉≮。ิ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '훉≮。ิ', strict=True)

    def test_uts46_2261(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh2512e.xn--i4c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh2512e.xn--i4c', strict=True)

    def test_uts46_2262(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⷷ\U0009e8c9🃘．\U00034207𝟸ٙ𞤯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⷷ\U0009e8c9🃘．\U00034207𝟸ٙ𞤯', strict=True)

    def test_uts46_2263(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⷷ\U0009e8c9🃘.\U000342072ٙ𞤯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⷷ\U0009e8c9🃘.\U000342072ٙ𞤯', strict=True)

    def test_uts46_2264(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⷷ\U0009e8c9🃘.\U000342072ٙ𞤍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⷷ\U0009e8c9🃘.\U000342072ٙ𞤍', strict=True)

    def test_uts46_2265(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--trj8045le6s9b.xn--2-upc23918acjsj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--trj8045le6s9b.xn--2-upc23918acjsj', strict=True)

    def test_uts46_2266(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⷷ\U0009e8c9🃘．\U00034207𝟸ٙ𞤍', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⷷ\U0009e8c9🃘．\U00034207𝟸ٙ𞤍', strict=True)

    def test_uts46_2267(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d71e9ßᢞ\u200c。٠\U0001edfbﳔ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d71e9ßᢞ\u200c。٠\U0001edfbﳔ-', strict=True)

    def test_uts46_2268(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d71e9ßᢞ\u200c。٠\U0001edfbنخ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d71e9ßᢞ\u200c。٠\U0001edfbنخ-', strict=True)

    def test_uts46_2269(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d71e9SSᢞ\u200c。٠\U0001edfbنخ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d71e9SSᢞ\u200c。٠\U0001edfbنخ-', strict=True)

    def test_uts46_2270(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d71e9ssᢞ\u200c。٠\U0001edfbنخ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d71e9ssᢞ\u200c。٠\U0001edfbنخ-', strict=True)

    def test_uts46_2271(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d71e9Ssᢞ\u200c。٠\U0001edfbنخ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d71e9Ssᢞ\u200c。٠\U0001edfbنخ-', strict=True)

    def test_uts46_2272(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-jepz4596r.xn----dnc5e1er384z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-jepz4596r.xn----dnc5e1er384z', strict=True)

    def test_uts46_2273(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-jep006bqt765b.xn----dnc5e1er384z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-jep006bqt765b.xn----dnc5e1er384z', strict=True)

    def test_uts46_2274(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca272jbif10059a.xn----dnc5e1er384z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca272jbif10059a.xn----dnc5e1er384z', strict=True)

    def test_uts46_2275(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d71e9SSᢞ\u200c。٠\U0001edfbﳔ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d71e9SSᢞ\u200c。٠\U0001edfbﳔ-', strict=True)

    def test_uts46_2276(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d71e9ssᢞ\u200c。٠\U0001edfbﳔ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d71e9ssᢞ\u200c。٠\U0001edfbﳔ-', strict=True)

    def test_uts46_2277(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d71e9Ssᢞ\u200c。٠\U0001edfbﳔ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d71e9Ssᢞ\u200c。٠\U0001edfbﳔ-', strict=True)

    def test_uts46_2278(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡆ。Ↄྵ놮-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡆ。Ↄྵ놮-', strict=True)

    def test_uts46_2279(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡆ。Ↄྵ놮-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡆ。Ↄྵ놮-', strict=True)

    def test_uts46_2280(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡆ。ↄྵ놮-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡆ。ↄྵ놮-', strict=True)

    def test_uts46_2281(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡆ。ↄྵ놮-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡆ。ↄྵ놮-', strict=True)

    def test_uts46_2282(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fc9a.xn----qmg097k469k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fc9a.xn----qmg097k469k', strict=True)

    def test_uts46_2283(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fc9a.xn----qmg787k869k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fc9a.xn----qmg787k869k', strict=True)

    def test_uts46_2284(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ﶭ\u200d.\U00065c0cک', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ﶭ\u200d.\U00065c0cک', strict=True)

    def test_uts46_2285(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'لمي\u200d.\U00065c0cک', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'لمي\u200d.\U00065c0cک', strict=True)

    def test_uts46_2286(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ghbcp.xn--ckb36214f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ghbcp.xn--ckb36214f', strict=True)

    def test_uts46_2287(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ghbcp494x.xn--ckb36214f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ghbcp494x.xn--ckb36214f', strict=True)

    def test_uts46_2288(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴜᰯ𐳒≯。۠ᜲྺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴜᰯ𐳒≯。۠ᜲྺ', strict=True)

    def test_uts46_2289(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴜᰯ𐳒≯。۠ᜲྺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴜᰯ𐳒≯。۠ᜲྺ', strict=True)

    def test_uts46_2290(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴜᰯ𐳒≯。۠ᜲྺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴜᰯ𐳒≯。۠ᜲྺ', strict=True)

    def test_uts46_2291(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴜᰯ𐳒≯。۠ᜲྺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴜᰯ𐳒≯。۠ᜲྺ', strict=True)

    def test_uts46_2292(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴜᰯ𐲒≯。۠ᜲྺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴜᰯ𐲒≯。۠ᜲྺ', strict=True)

    def test_uts46_2293(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴜᰯ𐲒≯。۠ᜲྺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴜᰯ𐲒≯。۠ᜲྺ', strict=True)

    def test_uts46_2294(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--r1f68xh1jgv7u.xn--wlb646b4ng', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--r1f68xh1jgv7u.xn--wlb646b4ng', strict=True)

    def test_uts46_2295(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0nd679cf3eq67y.xn--wlb646b4ng', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0nd679cf3eq67y.xn--wlb646b4ng', strict=True)

    def test_uts46_2296(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋵。ﳬ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋵。ﳬ', strict=True)

    def test_uts46_2297(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋵。كم', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋵。كم', strict=True)

    def test_uts46_2298(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--p97c.xn--fhbe', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--p97c.xn--fhbe', strict=True)

    def test_uts46_2299(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋵.كم', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋵.كم', strict=True)

    def test_uts46_2300(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮\U0001d176．\U00071c81ꫬ⹈\U000f096d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮\U0001d176．\U00071c81ꫬ⹈\U000f096d', strict=True)

    def test_uts46_2301(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮\U0001d176．\U00071c81ꫬ⹈\U000f096d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮\U0001d176．\U00071c81ꫬ⹈\U000f096d', strict=True)

    def test_uts46_2302(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮\U0001d176.\U00071c81ꫬ⹈\U000f096d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮\U0001d176.\U00071c81ꫬ⹈\U000f096d', strict=True)

    def test_uts46_2303(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮\U0001d176.\U00071c81ꫬ⹈\U000f096d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮\U0001d176.\U00071c81ꫬ⹈\U000f096d', strict=True)

    def test_uts46_2304(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh.xn--4tjx101bsg00ds9pyc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh.xn--4tjx101bsg00ds9pyc', strict=True)

    def test_uts46_2305(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh0880o.xn--4tjx101bsg00ds9pyc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh0880o.xn--4tjx101bsg00ds9pyc', strict=True)

    def test_uts46_2306(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⷰ͘ᢕ．͡𐹷\U000e0d0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⷰ͘ᢕ．͡𐹷\U000e0d0d', strict=True)

    def test_uts46_2307(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⷰ͘ᢕ.͡𐹷\U000e0d0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⷰ͘ᢕ.͡𐹷\U000e0d0d', strict=True)

    def test_uts46_2308(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2ua889htsp.xn--cva2687k2tv0g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2ua889htsp.xn--cva2687k2tv0g', strict=True)

    def test_uts46_2309(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ﵹᡐ\u200cڭ．𑋪ׇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ﵹᡐ\u200cڭ．𑋪ׇ', strict=True)

    def test_uts46_2310(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'غممᡐ\u200cڭ.𑋪ׇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'غممᡐ\u200cڭ.𑋪ׇ', strict=True)

    def test_uts46_2311(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5gbwa03bg24e.xn--vdb1198k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5gbwa03bg24e.xn--vdb1198k', strict=True)

    def test_uts46_2312(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5gbwa03bg24eptk.xn--vdb1198k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5gbwa03bg24eptk.xn--vdb1198k', strict=True)

    def test_uts46_2313(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑑂｡\u200d\U000e5780🞕\U000a5054', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑑂｡\u200d\U000e5780🞕\U000a5054', strict=True)

    def test_uts46_2314(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑑂。\u200d\U000e5780🞕\U000a5054', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑑂。\u200d\U000e5780🞕\U000a5054', strict=True)

    def test_uts46_2315(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8v1d.xn--ye9h41035a2qqs', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8v1d.xn--ye9h41035a2qqs', strict=True)

    def test_uts46_2316(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8v1d.xn--1ug1386plvx1cd8vya', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8v1d.xn--1ug1386plvx1cd8vya', strict=True)

    def test_uts46_2317(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ש。⒚', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ש。⒚', strict=True)

    def test_uts46_2318(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ש。19.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ש。19.', strict=True)

    def test_uts46_2319(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----gjc.1j.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----gjc.1j.', strict=True)

    def test_uts46_2320(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----gjc.xn--cth', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----gjc.xn--cth', strict=True)

    def test_uts46_2321(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0010afbbࡅ\u200c｡ᢎ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0010afbbࡅ\u200c｡ᢎ\u200d', strict=True)

    def test_uts46_2322(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0010afbbࡅ\u200c。ᢎ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0010afbbࡅ\u200c。ᢎ\u200d', strict=True)

    def test_uts46_2323(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3vb50049s.xn--79e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3vb50049s.xn--79e', strict=True)

    def test_uts46_2324(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3vb882jz4411a.xn--79e259a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3vb882jz4411a.xn--79e259a', strict=True)

    def test_uts46_2325(self):
        self.assertEqual(idna.decode('ßুᷭ。ؠ8₅', uts46=True, strict=True), 'ßুᷭ.ؠ85')
        self.assertEqual(idna.encode('ßুᷭ。ؠ8₅', uts46=True, strict=True), b'xn--zca266bwrr.xn--85-psd')

    def test_uts46_2326(self):
        self.assertEqual(idna.decode('ßুᷭ。ؠ85', uts46=True, strict=True), 'ßুᷭ.ؠ85')
        self.assertEqual(idna.encode('ßুᷭ。ؠ85', uts46=True, strict=True), b'xn--zca266bwrr.xn--85-psd')

    def test_uts46_2327(self):
        self.assertEqual(idna.decode('SSুᷭ。ؠ85', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('SSুᷭ。ؠ85', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2328(self):
        self.assertEqual(idna.decode('ssুᷭ。ؠ85', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('ssুᷭ。ؠ85', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2329(self):
        self.assertEqual(idna.decode('Ssুᷭ。ؠ85', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('Ssুᷭ。ؠ85', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2330(self):
        self.assertEqual(idna.decode('xn--ss-e2f077r.xn--85-psd', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('xn--ss-e2f077r.xn--85-psd', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2331(self):
        self.assertEqual(idna.decode('ssুᷭ.ؠ85', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('ssুᷭ.ؠ85', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2332(self):
        self.assertEqual(idna.decode('SSুᷭ.ؠ85', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('SSুᷭ.ؠ85', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2333(self):
        self.assertEqual(idna.decode('Ssুᷭ.ؠ85', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('Ssুᷭ.ؠ85', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2334(self):
        self.assertEqual(idna.decode('xn--zca266bwrr.xn--85-psd', uts46=True, strict=True), 'ßুᷭ.ؠ85')
        self.assertEqual(idna.encode('xn--zca266bwrr.xn--85-psd', uts46=True, strict=True), b'xn--zca266bwrr.xn--85-psd')

    def test_uts46_2335(self):
        self.assertEqual(idna.decode('ßুᷭ.ؠ85', uts46=True, strict=True), 'ßুᷭ.ؠ85')
        self.assertEqual(idna.encode('ßুᷭ.ؠ85', uts46=True, strict=True), b'xn--zca266bwrr.xn--85-psd')

    def test_uts46_2336(self):
        self.assertEqual(idna.decode('SSুᷭ。ؠ8₅', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('SSুᷭ。ؠ8₅', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2337(self):
        self.assertEqual(idna.decode('ssুᷭ。ؠ8₅', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('ssুᷭ。ؠ8₅', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2338(self):
        self.assertEqual(idna.decode('Ssুᷭ。ؠ8₅', uts46=True, strict=True), 'ssুᷭ.ؠ85')
        self.assertEqual(idna.encode('Ssুᷭ。ؠ8₅', uts46=True, strict=True), b'xn--ss-e2f077r.xn--85-psd')

    def test_uts46_2339(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્҄魅𝟣．₃𐹥ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્҄魅𝟣．₃𐹥ß', strict=True)

    def test_uts46_2340(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્҄魅1.3𐹥ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્҄魅1.3𐹥ß', strict=True)

    def test_uts46_2341(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્҄魅1.3𐹥SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્҄魅1.3𐹥SS', strict=True)

    def test_uts46_2342(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્҄魅1.3𐹥ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્҄魅1.3𐹥ss', strict=True)

    def test_uts46_2343(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્҄魅1.3𐹥Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્҄魅1.3𐹥Ss', strict=True)

    def test_uts46_2344(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-0xb049b102o.xn--3ss-nv9t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-0xb049b102o.xn--3ss-nv9t', strict=True)

    def test_uts46_2345(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-0xb049b102o.xn--3-qfa7018r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-0xb049b102o.xn--3-qfa7018r', strict=True)

    def test_uts46_2346(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્҄魅𝟣．₃𐹥SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્҄魅𝟣．₃𐹥SS', strict=True)

    def test_uts46_2347(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્҄魅𝟣．₃𐹥ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્҄魅𝟣．₃𐹥ss', strict=True)

    def test_uts46_2348(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્҄魅𝟣．₃𐹥Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્҄魅𝟣．₃𐹥Ss', strict=True)

    def test_uts46_2349(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ܫ｡𑓂⒈𑜫\U000e0ffb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ܫ｡𑓂⒈𑜫\U000e0ffb', strict=True)

    def test_uts46_2350(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ܫ。𑓂1.𑜫\U000e0ffb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ܫ。𑓂1.𑜫\U000e0ffb', strict=True)

    def test_uts46_2351(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1nb.xn--1-jq9i.xn--ji2dg9877c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1nb.xn--1-jq9i.xn--ji2dg9877c', strict=True)

    def test_uts46_2352(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1nb.xn--tsh7798f6rbrt828c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1nb.xn--tsh7798f6rbrt828c', strict=True)

    def test_uts46_2353(self):
        self.assertEqual(idna.decode('︍છ。嵨', uts46=True, strict=True), 'છ.嵨')
        self.assertEqual(idna.encode('︍છ。嵨', uts46=True, strict=True), b'xn--6dc.xn--tot')

    def test_uts46_2354(self):
        self.assertEqual(idna.decode('xn--6dc.xn--tot', uts46=True, strict=True), 'છ.嵨')
        self.assertEqual(idna.encode('xn--6dc.xn--tot', uts46=True, strict=True), b'xn--6dc.xn--tot')

    def test_uts46_2355(self):
        self.assertEqual(idna.decode('છ.嵨', uts46=True, strict=True), 'છ.嵨')
        self.assertEqual(idna.encode('છ.嵨', uts46=True, strict=True), b'xn--6dc.xn--tot')

    def test_uts46_2356(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴔ≠Ⴀ.𐹥𐹰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴔ≠Ⴀ.𐹥𐹰', strict=True)

    def test_uts46_2357(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴔ≠Ⴀ.𐹥𐹰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴔ≠Ⴀ.𐹥𐹰', strict=True)

    def test_uts46_2358(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴔ≠ⴀ.𐹥𐹰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴔ≠ⴀ.𐹥𐹰', strict=True)

    def test_uts46_2359(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴔ≠ⴀ.𐹥𐹰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴔ≠ⴀ.𐹥𐹰', strict=True)

    def test_uts46_2360(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch603bxb.xn--do0dwa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch603bxb.xn--do0dwa', strict=True)

    def test_uts46_2361(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7md3b171g.xn--do0dwa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7md3b171g.xn--do0dwa', strict=True)

    def test_uts46_2362(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200c⒙𐫥｡𝨵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200c⒙𐫥｡𝨵', strict=True)

    def test_uts46_2363(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-\u200c18.𐫥。𝨵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-\u200c18.𐫥。𝨵', strict=True)

    def test_uts46_2364(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-18.xn--rx9c.xn--382h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-18.xn--rx9c.xn--382h', strict=True)

    def test_uts46_2365(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---18-9m0a.xn--rx9c.xn--382h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---18-9m0a.xn--rx9c.xn--382h', strict=True)

    def test_uts46_2366(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ddps939g.xn--382h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ddps939g.xn--382h', strict=True)

    def test_uts46_2367(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----sgn18r3191a.xn--382h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----sgn18r3191a.xn--382h', strict=True)

    def test_uts46_2368(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒.ʌᠣ-𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒.ʌᠣ-𐹽', strict=True)

    def test_uts46_2369(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。.ʌᠣ-𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。.ʌᠣ-𐹽', strict=True)

    def test_uts46_2370(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。.Ʌᠣ-𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。.Ʌᠣ-𐹽', strict=True)

    def test_uts46_2371(self):
        self.assertRaises(idna.IDNAError, idna.decode, '..xn----73a596nuh9t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '..xn----73a596nuh9t', strict=True)

    def test_uts46_2372(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒.Ʌᠣ-𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒.Ʌᠣ-𐹽', strict=True)

    def test_uts46_2373(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y86c.xn----73a596nuh9t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y86c.xn----73a596nuh9t', strict=True)

    def test_uts46_2374(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︅︒。𦀾᳠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︅︒。𦀾᳠', strict=True)

    def test_uts46_2375(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︅。。𦀾᳠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︅。。𦀾᳠', strict=True)

    def test_uts46_2376(self):
        self.assertRaises(idna.IDNAError, idna.decode, '..xn--t6f5138v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '..xn--t6f5138v', strict=True)

    def test_uts46_2377(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y86c.xn--t6f5138v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y86c.xn--t6f5138v', strict=True)

    def test_uts46_2378(self):
        self.assertEqual(idna.decode('xn--t6f5138v', uts46=True, strict=True), '𦀾᳠')
        self.assertEqual(idna.encode('xn--t6f5138v', uts46=True, strict=True), b'xn--t6f5138v')

    def test_uts46_2379(self):
        self.assertEqual(idna.decode('𦀾᳠', uts46=True, strict=True), '𦀾᳠')
        self.assertEqual(idna.encode('𦀾᳠', uts46=True, strict=True), b'xn--t6f5138v')

    def test_uts46_2380(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001eb91ß\U0010f79e。ᡁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001eb91ß\U0010f79e。ᡁ', strict=True)

    def test_uts46_2381(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001eb91SS\U0010f79e。ᡁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001eb91SS\U0010f79e。ᡁ', strict=True)

    def test_uts46_2382(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001eb91ss\U0010f79e。ᡁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001eb91ss\U0010f79e。ᡁ', strict=True)

    def test_uts46_2383(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001eb91Ss\U0010f79e。ᡁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001eb91Ss\U0010f79e。ᡁ', strict=True)

    def test_uts46_2384(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-o412ac6305g.xn--07e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-o412ac6305g.xn--07e', strict=True)

    def test_uts46_2385(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca9432wb989f.xn--07e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca9432wb989f.xn--07e', strict=True)

    def test_uts46_2386(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꥓\u200dج٬。𱆎\U000fb85f\u200c󠅆', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꥓\u200dج٬。𱆎\U000fb85f\u200c󠅆', strict=True)

    def test_uts46_2387(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rgb2k6711c.xn--ec8nj3948b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rgb2k6711c.xn--ec8nj3948b', strict=True)

    def test_uts46_2388(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rgb2k500fhq9j.xn--0ug78870a5sp9d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rgb2k500fhq9j.xn--0ug78870a5sp9d', strict=True)

    def test_uts46_2389(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f．-ß\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f．-ß\u200c≠', strict=True)

    def test_uts46_2390(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f．-ß\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f．-ß\u200c≠', strict=True)

    def test_uts46_2391(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f.-ß\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f.-ß\u200c≠', strict=True)

    def test_uts46_2392(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f.-ß\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f.-ß\u200c≠', strict=True)

    def test_uts46_2393(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f.-SS\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f.-SS\u200c≠', strict=True)

    def test_uts46_2394(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f.-SS\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f.-SS\u200c≠', strict=True)

    def test_uts46_2395(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f.-ss\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f.-ss\u200c≠', strict=True)

    def test_uts46_2396(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f.-ss\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f.-ss\u200c≠', strict=True)

    def test_uts46_2397(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f.-Ss\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f.-Ss\u200c≠', strict=True)

    def test_uts46_2398(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f.-Ss\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f.-Ss\u200c≠', strict=True)

    def test_uts46_2399(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u836e.xn---ss-gl2a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u836e.xn---ss-gl2a', strict=True)

    def test_uts46_2400(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u836e.xn---ss-cn0at5l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u836e.xn---ss-cn0at5l', strict=True)

    def test_uts46_2401(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u836e.xn----qfa750ve7b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u836e.xn----qfa750ve7b', strict=True)

    def test_uts46_2402(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f．-SS\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f．-SS\u200c≠', strict=True)

    def test_uts46_2403(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f．-SS\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f．-SS\u200c≠', strict=True)

    def test_uts46_2404(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f．-ss\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f．-ss\u200c≠', strict=True)

    def test_uts46_2405(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f．-ss\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f．-ss\u200c≠', strict=True)

    def test_uts46_2406(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f．-Ss\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f．-Ss\u200c≠', strict=True)

    def test_uts46_2407(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e054f．-Ss\u200c≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e054f．-Ss\u200c≠', strict=True)

    def test_uts46_2408(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡙ\u200c｡≯𐋲≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡙ\u200c｡≯𐋲≠', strict=True)

    def test_uts46_2409(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡙ\u200c｡≯𐋲≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡙ\u200c｡≯𐋲≠', strict=True)

    def test_uts46_2410(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡙ\u200c。≯𐋲≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡙ\u200c。≯𐋲≠', strict=True)

    def test_uts46_2411(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡙ\u200c。≯𐋲≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡙ\u200c。≯𐋲≠', strict=True)

    def test_uts46_2412(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--p8e.xn--1ch3a7084l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--p8e.xn--1ch3a7084l', strict=True)

    def test_uts46_2413(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡙ.≯𐋲≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡙ.≯𐋲≠', strict=True)

    def test_uts46_2414(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡙ.≯𐋲≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡙ.≯𐋲≠', strict=True)

    def test_uts46_2415(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--p8e650b.xn--1ch3a7084l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--p8e650b.xn--1ch3a7084l', strict=True)

    def test_uts46_2416(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹧𞲄\U000e006d\U00046f29。͎🄀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹧𞲄\U000e006d\U00046f29。͎🄀', strict=True)

    def test_uts46_2417(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹧𞲄\U000e006d\U00046f29。͎0.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹧𞲄\U000e006d\U00046f29。͎0.', strict=True)

    def test_uts46_2418(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fo0dw409aq58qrn69d.xn--0-bgb.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fo0dw409aq58qrn69d.xn--0-bgb.', strict=True)

    def test_uts46_2419(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fo0dw409aq58qrn69d.xn--sua6883w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fo0dw409aq58qrn69d.xn--sua6883w', strict=True)

    def test_uts46_2420(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴄ．\u200dܡ\U000fb8cbς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴄ．\u200dܡ\U000fb8cbς', strict=True)

    def test_uts46_2421(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴄ.\u200dܡ\U000fb8cbς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴄ.\u200dܡ\U000fb8cbς', strict=True)

    def test_uts46_2422(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴄ.\u200dܡ\U000fb8cbς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴄ.\u200dܡ\U000fb8cbς', strict=True)

    def test_uts46_2423(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴄ.\u200dܡ\U000fb8cbΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴄ.\u200dܡ\U000fb8cbΣ', strict=True)

    def test_uts46_2424(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴄ.\u200dܡ\U000fb8cbσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴄ.\u200dܡ\U000fb8cbσ', strict=True)

    def test_uts46_2425(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vkj.xn--4xa73ob5892c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vkj.xn--4xa73ob5892c', strict=True)

    def test_uts46_2426(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vkj.xn--4xa73o3t5ajq467a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vkj.xn--4xa73o3t5ajq467a', strict=True)

    def test_uts46_2427(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vkj.xn--3xa93o3t5ajq467a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vkj.xn--3xa93o3t5ajq467a', strict=True)

    def test_uts46_2428(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴄ．\u200dܡ\U000fb8cbς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴄ．\u200dܡ\U000fb8cbς', strict=True)

    def test_uts46_2429(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴄ．\u200dܡ\U000fb8cbΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴄ．\u200dܡ\U000fb8cbΣ', strict=True)

    def test_uts46_2430(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴄ．\u200dܡ\U000fb8cbσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴄ．\u200dܡ\U000fb8cbσ', strict=True)

    def test_uts46_2431(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cnd.xn--4xa73ob5892c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cnd.xn--4xa73ob5892c', strict=True)

    def test_uts46_2432(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cnd.xn--4xa73o3t5ajq467a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cnd.xn--4xa73o3t5ajq467a', strict=True)

    def test_uts46_2433(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cnd.xn--3xa93o3t5ajq467a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cnd.xn--3xa93o3t5ajq467a', strict=True)

    def test_uts46_2434(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000aed5bؓ.Ⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000aed5bؓ.Ⴕ', strict=True)

    def test_uts46_2435(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000aed5bؓ.ⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000aed5bؓ.ⴕ', strict=True)

    def test_uts46_2436(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1fb94204l.xn--dlj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1fb94204l.xn--dlj', strict=True)

    def test_uts46_2437(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1fb94204l.xn--tnd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1fb94204l.xn--tnd', strict=True)

    def test_uts46_2438(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ᷳ𞤥。\u200c꣄\U000e0a89\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ᷳ𞤥。\u200c꣄\U000e0a89\u200d', strict=True)

    def test_uts46_2439(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ᷳ𞤥。\u200c꣄\U000e0a89\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ᷳ𞤥。\u200c꣄\U000e0a89\u200d', strict=True)

    def test_uts46_2440(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ᷳ𞤃。\u200c꣄\U000e0a89\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ᷳ𞤃。\u200c꣄\U000e0a89\u200d', strict=True)

    def test_uts46_2441(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ᷳ𞤃。\u200c꣄\U000e0a89\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ᷳ𞤃。\u200c꣄\U000e0a89\u200d', strict=True)

    def test_uts46_2442(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ofg13qyr21c.xn--0f9au6706d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ofg13qyr21c.xn--0f9au6706d', strict=True)

    def test_uts46_2443(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ofg13qyr21c.xn--0ugc0116hix29k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ofg13qyr21c.xn--0ugc0116hix29k', strict=True)

    def test_uts46_2444(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c󠄷｡\U00092441', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c󠄷｡\U00092441', strict=True)

    def test_uts46_2445(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c󠄷。\U00092441', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c󠄷。\U00092441', strict=True)

    def test_uts46_2446(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--w720c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--w720c', strict=True)

    def test_uts46_2447(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--w720c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--w720c', strict=True)

    def test_uts46_2448(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈ූ焅.\U000d7859\u200dꡟ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈ූ焅.\U000d7859\u200dꡟ', strict=True)

    def test_uts46_2449(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.ූ焅.\U000d7859\u200dꡟ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.ූ焅.\U000d7859\u200dꡟ', strict=True)

    def test_uts46_2450(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--t1c6981c.xn--4c9a21133d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--t1c6981c.xn--4c9a21133d', strict=True)

    def test_uts46_2451(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--t1c6981c.xn--1ugz184c9lw7i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--t1c6981c.xn--1ugz184c9lw7i', strict=True)

    def test_uts46_2452(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--t1c337io97c.xn--4c9a21133d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--t1c337io97c.xn--4c9a21133d', strict=True)

    def test_uts46_2453(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--t1c337io97c.xn--1ugz184c9lw7i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--t1c337io97c.xn--1ugz184c9lw7i', strict=True)

    def test_uts46_2454(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍ς≮.ς𝪦𞤕0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍ς≮.ς𝪦𞤕0', strict=True)

    def test_uts46_2455(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍ς≮.ς𝪦𞤕0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍ς≮.ς𝪦𞤕0', strict=True)

    def test_uts46_2456(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍ς≮.ς𝪦𞤷0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍ς≮.ς𝪦𞤷0', strict=True)

    def test_uts46_2457(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍ς≮.ς𝪦𞤷0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍ς≮.ς𝪦𞤷0', strict=True)

    def test_uts46_2458(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍Σ≮.Σ𝪦𞤕0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍Σ≮.Σ𝪦𞤕0', strict=True)

    def test_uts46_2459(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍Σ≮.Σ𝪦𞤕0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍Σ≮.Σ𝪦𞤕0', strict=True)

    def test_uts46_2460(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍σ≮.σ𝪦𞤷0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍σ≮.σ𝪦𞤷0', strict=True)

    def test_uts46_2461(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍σ≮.σ𝪦𞤷0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍σ≮.σ𝪦𞤷0', strict=True)

    def test_uts46_2462(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍Σ≮.Σ𝪦𞤷0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍Σ≮.Σ𝪦𞤷0', strict=True)

    def test_uts46_2463(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍Σ≮.Σ𝪦𞤷0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍Σ≮.Σ𝪦𞤷0', strict=True)

    def test_uts46_2464(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa544kvid.xn--0-zmb55727aggma', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa544kvid.xn--0-zmb55727aggma', strict=True)

    def test_uts46_2465(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa744kvid.xn--0-xmb85727aggma', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa744kvid.xn--0-xmb85727aggma', strict=True)

    def test_uts46_2466(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍σ≮.σ𝪦𞤕0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍σ≮.σ𝪦𞤕0', strict=True)

    def test_uts46_2467(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᷍σ≮.σ𝪦𞤕0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᷍σ≮.σ𝪦𞤕0', strict=True)

    def test_uts46_2468(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a29beßֹ𐫙.֭ࢡ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a29beßֹ𐫙.֭ࢡ', strict=True)

    def test_uts46_2469(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a29beSSֹ𐫙.֭ࢡ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a29beSSֹ𐫙.֭ࢡ', strict=True)

    def test_uts46_2470(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a29bessֹ𐫙.֭ࢡ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a29bessֹ𐫙.֭ࢡ', strict=True)

    def test_uts46_2471(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a29beSsֹ𐫙.֭ࢡ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a29beSsֹ𐫙.֭ࢡ', strict=True)

    def test_uts46_2472(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-xjd6058xlz50g.xn--4cb62m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-xjd6058xlz50g.xn--4cb62m', strict=True)

    def test_uts46_2473(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca89v339zj118e.xn--4cb62m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca89v339zj118e.xn--4cb62m', strict=True)

    def test_uts46_2474(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𞣄｡⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𞣄｡⒈', strict=True)

    def test_uts46_2475(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𞣄。1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𞣄。1.', strict=True)

    def test_uts46_2476(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----xc8r.b.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----xc8r.b.', strict=True)

    def test_uts46_2477(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----xc8r.xn--tsh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----xc8r.xn--tsh', strict=True)

    def test_uts46_2478(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00048822𐫖𝟡。ؾ𑘿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00048822𐫖𝟡。ؾ𑘿', strict=True)

    def test_uts46_2479(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00048822𐫖9。ؾ𑘿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00048822𐫖9。ؾ𑘿', strict=True)

    def test_uts46_2480(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-el5iv442t.xn--9gb0830l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-el5iv442t.xn--9gb0830l', strict=True)

    def test_uts46_2481(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٨ﲌ٨ᩝ.\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٨ﲌ٨ᩝ.\u200d', strict=True)

    def test_uts46_2482(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٨نم٨ᩝ.\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٨نم٨ᩝ.\u200d', strict=True)

    def test_uts46_2483(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hhbb5hc956w.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hhbb5hc956w.', strict=True)

    def test_uts46_2484(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hhbb5hc956w.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hhbb5hc956w.xn--1ug', strict=True)

    def test_uts46_2485(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟘．Ⴇ\U000c0cd1ﵐ\U0006b0f1', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟘．Ⴇ\U000c0cd1ﵐ\U0006b0f1', strict=True)

    def test_uts46_2486(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.Ⴇ\U000c0cd1تجم\U0006b0f1', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.Ⴇ\U000c0cd1تجم\U0006b0f1', strict=True)

    def test_uts46_2487(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.ⴇ\U000c0cd1تجم\U0006b0f1', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.ⴇ\U000c0cd1تجم\U0006b0f1', strict=True)

    def test_uts46_2488(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.xn--pgbe9ez79qd207lvff8b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.xn--pgbe9ez79qd207lvff8b', strict=True)

    def test_uts46_2489(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟘．ⴇ\U000c0cd1ﵐ\U0006b0f1', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟘．ⴇ\U000c0cd1ﵐ\U0006b0f1', strict=True)

    def test_uts46_2490(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0.xn--pgbe9e344c2725svff8b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0.xn--pgbe9e344c2725svff8b', strict=True)

    def test_uts46_2491(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑇀▍.⁞ᠰ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑇀▍.⁞ᠰ', strict=True)

    def test_uts46_2492(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9zh3057f.xn--j7e103b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9zh3057f.xn--j7e103b', strict=True)

    def test_uts46_2493(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d-ٺ.\U0008fbe9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d-ٺ.\U0008fbe9', strict=True)

    def test_uts46_2494(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----qrc.xn--ts49b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----qrc.xn--ts49b', strict=True)

    def test_uts46_2495(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----qrc357q.xn--ts49b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----qrc357q.xn--ts49b', strict=True)

    def test_uts46_2496(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᠢ𐮂𐫘寐｡\u200c≯✳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᠢ𐮂𐫘寐｡\u200c≯✳', strict=True)

    def test_uts46_2497(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᠢ𐮂𐫘寐｡\u200c≯✳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᠢ𐮂𐫘寐｡\u200c≯✳', strict=True)

    def test_uts46_2498(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᠢ𐮂𐫘寐。\u200c≯✳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᠢ𐮂𐫘寐。\u200c≯✳', strict=True)

    def test_uts46_2499(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᠢ𐮂𐫘寐。\u200c≯✳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᠢ𐮂𐫘寐。\u200c≯✳', strict=True)

    def test_uts46_2500(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--46e6675axzzhota.xn--hdh99p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--46e6675axzzhota.xn--hdh99p', strict=True)

    def test_uts46_2501(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--46e6675axzzhota.xn--0ug06gu8f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--46e6675axzzhota.xn--0ug06gu8f', strict=True)

    def test_uts46_2502(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d｡\U000f8c9cႺႴ\U0001ea07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d｡\U000f8c9cႺႴ\U0001ea07', strict=True)

    def test_uts46_2503(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。\U000f8c9cႺႴ\U0001ea07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。\U000f8c9cႺႴ\U0001ea07', strict=True)

    def test_uts46_2504(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。\U000f8c9cⴚⴔ\U0001ea07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。\U000f8c9cⴚⴔ\U0001ea07', strict=True)

    def test_uts46_2505(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。\U000f8c9cႺⴔ\U0001ea07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。\U000f8c9cႺⴔ\U0001ea07', strict=True)

    def test_uts46_2506(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--cljl81825an3r4h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--cljl81825an3r4h', strict=True)

    def test_uts46_2507(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.xn--cljl81825an3r4h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.xn--cljl81825an3r4h', strict=True)

    def test_uts46_2508(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d｡\U000f8c9cⴚⴔ\U0001ea07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d｡\U000f8c9cⴚⴔ\U0001ea07', strict=True)

    def test_uts46_2509(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d｡\U000f8c9cႺⴔ\U0001ea07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d｡\U000f8c9cႺⴔ\U0001ea07', strict=True)

    def test_uts46_2510(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--ynd036lq981an3r4h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--ynd036lq981an3r4h', strict=True)

    def test_uts46_2511(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.xn--ynd036lq981an3r4h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.xn--ynd036lq981an3r4h', strict=True)

    def test_uts46_2512(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--sndl01647an3h1h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--sndl01647an3h1h', strict=True)

    def test_uts46_2513(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.xn--sndl01647an3h1h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.xn--sndl01647an3h1h', strict=True)

    def test_uts46_2514(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-3.\u200dヌᢕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-3.\u200dヌᢕ', strict=True)

    def test_uts46_2515(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-3.xn--fbf115j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-3.xn--fbf115j', strict=True)

    def test_uts46_2516(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-3.xn--fbf739aq5o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-3.xn--fbf739aq5o', strict=True)

    def test_uts46_2517(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🂃٦ß\u200d。\U000e0802\U000adc0d\U0001ea52-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🂃٦ß\u200d。\U000e0802\U000adc0d\U0001ea52-', strict=True)

    def test_uts46_2518(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🂃٦SS\u200d。\U000e0802\U000adc0d\U0001ea52-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🂃٦SS\u200d。\U000e0802\U000adc0d\U0001ea52-', strict=True)

    def test_uts46_2519(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🂃٦ss\u200d。\U000e0802\U000adc0d\U0001ea52-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🂃٦ss\u200d。\U000e0802\U000adc0d\U0001ea52-', strict=True)

    def test_uts46_2520(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-pyd98921c.xn----nz8rh7531csznt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-pyd98921c.xn----nz8rh7531csznt', strict=True)

    def test_uts46_2521(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-pyd483x5k99b.xn----nz8rh7531csznt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-pyd483x5k99b.xn----nz8rh7531csznt', strict=True)

    def test_uts46_2522(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca34z68yzu83b.xn----nz8rh7531csznt', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca34z68yzu83b.xn----nz8rh7531csznt', strict=True)

    def test_uts46_2523(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🂃٦Ss\u200d。\U000e0802\U000adc0d\U0001ea52-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🂃٦Ss\u200d。\U000e0802\U000adc0d\U0001ea52-', strict=True)

    def test_uts46_2524(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꇟ-𐾺ڟ。\U000b003a\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꇟ-𐾺ڟ。\U000b003a\u200c', strict=True)

    def test_uts46_2525(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----utc4430jd3zd.xn--bp20d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----utc4430jd3zd.xn--bp20d', strict=True)

    def test_uts46_2526(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----utc4430jd3zd.xn--0ugx6670i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----utc4430jd3zd.xn--0ugx6670i', strict=True)

    def test_uts46_2527(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٥.҄𐨗𝩋\U00034903', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٥.҄𐨗𝩋\U00034903', strict=True)

    def test_uts46_2528(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--eib.xn--n3a0405kus8eft5l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--eib.xn--n3a0405kus8eft5l', strict=True)

    def test_uts46_2529(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.\U00071f13ى𐨿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.\U00071f13ى𐨿', strict=True)

    def test_uts46_2530(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--lhb4124khbq4b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--lhb4124khbq4b', strict=True)

    def test_uts46_2531(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28ς.\U0001ed99녫ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28ς.\U0001ed99녫ß', strict=True)

    def test_uts46_2532(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28ς.\U0001ed99녫ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28ς.\U0001ed99녫ß', strict=True)

    def test_uts46_2533(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28Σ.\U0001ed99녫SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28Σ.\U0001ed99녫SS', strict=True)

    def test_uts46_2534(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28Σ.\U0001ed99녫SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28Σ.\U0001ed99녫SS', strict=True)

    def test_uts46_2535(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28σ.\U0001ed99녫ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28σ.\U0001ed99녫ss', strict=True)

    def test_uts46_2536(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28σ.\U0001ed99녫ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28σ.\U0001ed99녫ss', strict=True)

    def test_uts46_2537(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28Σ.\U0001ed99녫ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28Σ.\U0001ed99녫ss', strict=True)

    def test_uts46_2538(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28Σ.\U0001ed99녫ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28Σ.\U0001ed99녫ss', strict=True)

    def test_uts46_2539(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28Σ.\U0001ed99녫Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28Σ.\U0001ed99녫Ss', strict=True)

    def test_uts46_2540(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28Σ.\U0001ed99녫Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28Σ.\U0001ed99녫Ss', strict=True)

    def test_uts46_2541(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa76659r.xn--ss-d64i8755h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa76659r.xn--ss-d64i8755h', strict=True)

    def test_uts46_2542(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28Σ.\U0001ed99녫ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28Σ.\U0001ed99녫ß', strict=True)

    def test_uts46_2543(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28Σ.\U0001ed99녫ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28Σ.\U0001ed99녫ß', strict=True)

    def test_uts46_2544(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28σ.\U0001ed99녫ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28σ.\U0001ed99녫ß', strict=True)

    def test_uts46_2545(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000feb28σ.\U0001ed99녫ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000feb28σ.\U0001ed99녫ß', strict=True)

    def test_uts46_2546(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa76659r.xn--zca5051g4h4i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa76659r.xn--zca5051g4h4i', strict=True)

    def test_uts46_2547(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa96659r.xn--zca5051g4h4i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa96659r.xn--zca5051g4h4i', strict=True)

    def test_uts46_2548(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ្\u200d｡≠\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ្\u200d｡≠\u200d\u200c', strict=True)

    def test_uts46_2549(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ្\u200d｡≠\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ្\u200d｡≠\u200d\u200c', strict=True)

    def test_uts46_2550(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ្\u200d。≠\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ្\u200d。≠\u200d\u200c', strict=True)

    def test_uts46_2551(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ្\u200d。≠\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ្\u200d。≠\u200d\u200c', strict=True)

    def test_uts46_2552(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ្\u200d。≠\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ្\u200d。≠\u200d\u200c', strict=True)

    def test_uts46_2553(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ្\u200d。≠\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ្\u200d。≠\u200d\u200c', strict=True)

    def test_uts46_2554(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u4e969b.xn--1ch', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u4e969b.xn--1ch', strict=True)

    def test_uts46_2555(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ្.≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ្.≠', strict=True)

    def test_uts46_2556(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ្.≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ្.≠', strict=True)

    def test_uts46_2557(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ្.≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ្.≠', strict=True)

    def test_uts46_2558(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ្.≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ្.≠', strict=True)

    def test_uts46_2559(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u4e823bq1a.xn--0ugb89o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u4e823bq1a.xn--0ugb89o', strict=True)

    def test_uts46_2560(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ្\u200d｡≠\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ្\u200d｡≠\u200d\u200c', strict=True)

    def test_uts46_2561(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ្\u200d｡≠\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ្\u200d｡≠\u200d\u200c', strict=True)

    def test_uts46_2562(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u4e319b.xn--1ch', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u4e319b.xn--1ch', strict=True)

    def test_uts46_2563(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u4e823bcza.xn--0ugb89o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u4e823bcza.xn--0ugb89o', strict=True)

    def test_uts46_2564(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋺꫶꥓\U000e7989．\u200c᜔ڏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋺꫶꥓\U000e7989．\u200c᜔ڏ', strict=True)

    def test_uts46_2565(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋺꫶꥓\U000e7989.\u200c᜔ڏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋺꫶꥓\U000e7989.\u200c᜔ڏ', strict=True)

    def test_uts46_2566(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3j9a14ak27osbz2o.xn--ljb175f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3j9a14ak27osbz2o.xn--ljb175f', strict=True)

    def test_uts46_2567(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3j9a14ak27osbz2o.xn--ljb175f1wg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3j9a14ak27osbz2o.xn--ljb175f1wg', strict=True)

    def test_uts46_2568(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007a52fྨ．≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007a52fྨ．≯', strict=True)

    def test_uts46_2569(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007a52fྨ．≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007a52fྨ．≯', strict=True)

    def test_uts46_2570(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007a52fྨ.≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007a52fྨ.≯', strict=True)

    def test_uts46_2571(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007a52fྨ.≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007a52fྨ.≯', strict=True)

    def test_uts46_2572(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4fd57150h.xn--hdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4fd57150h.xn--hdh', strict=True)

    def test_uts46_2573(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𞡄Ⴓ．𐇽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𞡄Ⴓ．𐇽', strict=True)

    def test_uts46_2574(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𞡄Ⴓ.𐇽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𞡄Ⴓ.𐇽', strict=True)

    def test_uts46_2575(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𞡄ⴓ.𐇽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𞡄ⴓ.𐇽', strict=True)

    def test_uts46_2576(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--blj7492l.xn--m27c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--blj7492l.xn--m27c', strict=True)

    def test_uts46_2577(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ugz52c4i16a.xn--m27c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ugz52c4i16a.xn--m27c', strict=True)

    def test_uts46_2578(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d𞡄ⴓ．𐇽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d𞡄ⴓ．𐇽', strict=True)

    def test_uts46_2579(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rnd5552v.xn--m27c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rnd5552v.xn--m27c', strict=True)

    def test_uts46_2580(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rnd379ex885a.xn--m27c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rnd379ex885a.xn--m27c', strict=True)

    def test_uts46_2581(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐪒ß꣪．ᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐪒ß꣪．ᡤ', strict=True)

    def test_uts46_2582(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐪒ß꣪.ᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐪒ß꣪.ᡤ', strict=True)

    def test_uts46_2583(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐪒SS꣪.ᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐪒SS꣪.ᡤ', strict=True)

    def test_uts46_2584(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐪒ss꣪.ᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐪒ss꣪.ᡤ', strict=True)

    def test_uts46_2585(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-tu9hw933a.xn--08e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-tu9hw933a.xn--08e', strict=True)

    def test_uts46_2586(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca2517f2hvc.xn--08e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca2517f2hvc.xn--08e', strict=True)

    def test_uts46_2587(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐪒SS꣪．ᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐪒SS꣪．ᡤ', strict=True)

    def test_uts46_2588(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐪒ss꣪．ᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐪒ss꣪．ᡤ', strict=True)

    def test_uts46_2589(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐪒Ss꣪.ᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐪒Ss꣪.ᡤ', strict=True)

    def test_uts46_2590(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐪒Ss꣪．ᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐪒Ss꣪．ᡤ', strict=True)

    def test_uts46_2591(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨿󠆌鸮𑚶.ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨿󠆌鸮𑚶.ς', strict=True)

    def test_uts46_2592(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨿󠆌鸮𑚶.Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨿󠆌鸮𑚶.Σ', strict=True)

    def test_uts46_2593(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨿󠆌鸮𑚶.σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨿󠆌鸮𑚶.σ', strict=True)

    def test_uts46_2594(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--l76a726rt2h.xn--4xa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--l76a726rt2h.xn--4xa', strict=True)

    def test_uts46_2595(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--l76a726rt2h.xn--3xa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--l76a726rt2h.xn--3xa', strict=True)

    def test_uts46_2596(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒗𞤬。-𑚶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒗𞤬。-𑚶', strict=True)

    def test_uts46_2597(self):
        self.assertRaises(idna.IDNAError, idna.decode, '16.𞤬。-𑚶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '16.𞤬。-𑚶', strict=True)

    def test_uts46_2598(self):
        self.assertRaises(idna.IDNAError, idna.decode, '16.𞤊。-𑚶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '16.𞤊。-𑚶', strict=True)

    def test_uts46_2599(self):
        self.assertRaises(idna.IDNAError, idna.decode, '16.xn--ke6h.xn----4j0j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '16.xn--ke6h.xn----4j0j', strict=True)

    def test_uts46_2600(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒗𞤊。-𑚶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒗𞤊。-𑚶', strict=True)

    def test_uts46_2601(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8shw466n.xn----4j0j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8shw466n.xn----4j0j', strict=True)

    def test_uts46_2602(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࢳ𞤿⾫｡𐹣ڏ⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࢳ𞤿⾫｡𐹣ڏ⒈', strict=True)

    def test_uts46_2603(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࢳ𞤿隹。𐹣ڏ1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࢳ𞤿隹。𐹣ڏ1.', strict=True)

    def test_uts46_2604(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࢳ𞤝隹。𐹣ڏ1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࢳ𞤝隹。𐹣ڏ1.', strict=True)

    def test_uts46_2605(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8yb0383efiwk.xn--1-wsc3373r.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8yb0383efiwk.xn--1-wsc3373r.', strict=True)

    def test_uts46_2606(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࢳ𞤝⾫｡𐹣ڏ⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࢳ𞤝⾫｡𐹣ڏ⒈', strict=True)

    def test_uts46_2607(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8yb0383efiwk.xn--ljb064mol4n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8yb0383efiwk.xn--ljb064mol4n', strict=True)

    def test_uts46_2608(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u2433\U0001a39b𝟧١.ᡢ8ི\u0600', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u2433\U0001a39b𝟧١.ᡢ8ི\u0600', strict=True)

    def test_uts46_2609(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u2433\U0001a39b5١.ᡢ8ི\u0600', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u2433\U0001a39b5١.ᡢ8ི\u0600', strict=True)

    def test_uts46_2610(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5-bqc410un435a.xn--8-rkc763epjj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5-bqc410un435a.xn--8-rkc763epjj', strict=True)

    def test_uts46_2611(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹠.🄀⒒-\U000e8c08', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹠.🄀⒒-\U000e8c08', strict=True)

    def test_uts46_2612(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹠.0.11.-\U000e8c08', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹠.0.11.-\U000e8c08', strict=True)

    def test_uts46_2613(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7n0d.0.11.xn----8j07m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7n0d.0.11.xn----8j07m', strict=True)

    def test_uts46_2614(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7n0d.xn----xcp9757q1s13g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7n0d.xn----xcp9757q1s13g', strict=True)

    def test_uts46_2615(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς-。\u200c𝟭-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς-。\u200c𝟭-', strict=True)

    def test_uts46_2616(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς-。\u200c1-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς-。\u200c1-', strict=True)

    def test_uts46_2617(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ-。\u200c1-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ-。\u200c1-', strict=True)

    def test_uts46_2618(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ-。\u200c1-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ-。\u200c1-', strict=True)

    def test_uts46_2619(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----zmb.1-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----zmb.1-', strict=True)

    def test_uts46_2620(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----zmb.xn--1--i1t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----zmb.xn--1--i1t', strict=True)

    def test_uts46_2621(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----xmb.xn--1--i1t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----xmb.xn--1--i1t', strict=True)

    def test_uts46_2622(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ-。\u200c𝟭-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ-。\u200c𝟭-', strict=True)

    def test_uts46_2623(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ-。\u200c𝟭-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ-。\u200c𝟭-', strict=True)

    def test_uts46_2624(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᜴-ೢ．󠄩Ⴄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᜴-ೢ．󠄩Ⴄ', strict=True)

    def test_uts46_2625(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᜴-ೢ.󠄩Ⴄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᜴-ೢ.󠄩Ⴄ', strict=True)

    def test_uts46_2626(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᜴-ೢ.󠄩ⴄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᜴-ೢ.󠄩ⴄ', strict=True)

    def test_uts46_2627(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ggf830f.xn--vkj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ggf830f.xn--vkj', strict=True)

    def test_uts46_2628(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᜴-ೢ．󠄩ⴄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᜴-ೢ．󠄩ⴄ', strict=True)

    def test_uts46_2629(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ggf830f.xn--cnd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ggf830f.xn--cnd', strict=True)

    def test_uts46_2630(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000ad217♋ڻ𐦥｡॔⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000ad217♋ڻ𐦥｡॔⒈', strict=True)

    def test_uts46_2631(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000ad217♋ڻ𐦥。॔1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000ad217♋ڻ𐦥。॔1.', strict=True)

    def test_uts46_2632(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ukb372n129m3rs7f.xn--1-fyd.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ukb372n129m3rs7f.xn--1-fyd.', strict=True)

    def test_uts46_2633(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ukb372n129m3rs7f.xn--u3b240l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ukb372n129m3rs7f.xn--u3b240l', strict=True)

    def test_uts46_2634(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֤．ہ᪳\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֤．ہ᪳\u200c', strict=True)

    def test_uts46_2635(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֤.ہ᪳\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֤.ہ᪳\u200c', strict=True)

    def test_uts46_2636(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vcb.xn--0kb623h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vcb.xn--0kb623h', strict=True)

    def test_uts46_2637(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vcb.xn--0kb623hm1d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vcb.xn--0kb623hm1d', strict=True)

    def test_uts46_2638(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00062b4fࡆ≮્．\U0001e98a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00062b4fࡆ≮્．\U0001e98a', strict=True)

    def test_uts46_2639(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00062b4fࡆ≮્．\U0001e98a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00062b4fࡆ≮્．\U0001e98a', strict=True)

    def test_uts46_2640(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00062b4fࡆ≮્.\U0001e98a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00062b4fࡆ≮્.\U0001e98a', strict=True)

    def test_uts46_2641(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00062b4fࡆ≮્.\U0001e98a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00062b4fࡆ≮્.\U0001e98a', strict=True)

    def test_uts46_2642(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4vb80kq29ayo62l.xn--8g6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4vb80kq29ayo62l.xn--8g6h', strict=True)

    def test_uts46_2643(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。𞀘⒈ꡍ擉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。𞀘⒈ꡍ擉', strict=True)

    def test_uts46_2644(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。𞀘1.ꡍ擉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。𞀘1.ꡍ擉', strict=True)

    def test_uts46_2645(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--1-1p4r.xn--s7uv61m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--1-1p4r.xn--s7uv61m', strict=True)

    def test_uts46_2646(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.xn--1-1p4r.xn--s7uv61m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.xn--1-1p4r.xn--s7uv61m', strict=True)

    def test_uts46_2647(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--tsh026uql4bew9p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--tsh026uql4bew9p', strict=True)

    def test_uts46_2648(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.xn--tsh026uql4bew9p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.xn--tsh026uql4bew9p', strict=True)

    def test_uts46_2649(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₈ߋ．ﭤ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₈ߋ．ﭤ≠', strict=True)

    def test_uts46_2650(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₈ߋ．ﭤ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₈ߋ．ﭤ≠', strict=True)

    def test_uts46_2651(self):
        self.assertRaises(idna.IDNAError, idna.decode, '8ߋ.ٿ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '8ߋ.ٿ≠', strict=True)

    def test_uts46_2652(self):
        self.assertRaises(idna.IDNAError, idna.decode, '8ߋ.ٿ≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '8ߋ.ٿ≠', strict=True)

    def test_uts46_2653(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8-zbd.xn--4ib883l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8-zbd.xn--4ib883l', strict=True)

    def test_uts46_2654(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢡߞ\U000b9423.⒒ق𑍦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢡߞ\U000b9423.⒒ق𑍦', strict=True)

    def test_uts46_2655(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢡߞ\U000b9423.11.ق𑍦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢡߞ\U000b9423.11.ق𑍦', strict=True)

    def test_uts46_2656(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5sb596fi873t.11.xn--ehb4198k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5sb596fi873t.11.xn--ehb4198k', strict=True)

    def test_uts46_2657(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5sb596fi873t.xn--ehb336mvy7n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5sb596fi873t.xn--ehb336mvy7n', strict=True)

    def test_uts46_2658(self):
        self.assertRaises(idna.IDNAError, idna.decode, '่-𐹺𝟜.ͣۡ⒏', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '่-𐹺𝟜.ͣۡ⒏', strict=True)

    def test_uts46_2659(self):
        self.assertRaises(idna.IDNAError, idna.decode, '่-𐹺4.ͣۡ8.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '่-𐹺4.ͣۡ8.', strict=True)

    def test_uts46_2660(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---4-owiz479s.xn--8-ihb69x.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---4-owiz479s.xn--8-ihb69x.', strict=True)

    def test_uts46_2661(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---4-owiz479s.xn--eva20pjv9a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---4-owiz479s.xn--eva20pjv9a', strict=True)

    def test_uts46_2662(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⫐｡Ⴠ-\U000c3422', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⫐｡Ⴠ-\U000c3422', strict=True)

    def test_uts46_2663(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⫐。Ⴠ-\U000c3422', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⫐。Ⴠ-\U000c3422', strict=True)

    def test_uts46_2664(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⫐。ⴠ-\U000c3422', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⫐。ⴠ-\U000c3422', strict=True)

    def test_uts46_2665(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--r3i.xn----2wst7439i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--r3i.xn----2wst7439i', strict=True)

    def test_uts46_2666(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⫐｡ⴠ-\U000c3422', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⫐｡ⴠ-\U000c3422', strict=True)

    def test_uts46_2667(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--r3i.xn----z1g58579u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--r3i.xn----z1g58579u', strict=True)

    def test_uts46_2668(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑑂◊．⦟∠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑑂◊．⦟∠', strict=True)

    def test_uts46_2669(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑑂◊.⦟∠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑑂◊.⦟∠', strict=True)

    def test_uts46_2670(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--01h3338f.xn--79g270a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--01h3338f.xn--79g270a', strict=True)

    def test_uts46_2671(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f330-٢。\U000cbe1bꡂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f330-٢。\U000cbe1bꡂ', strict=True)

    def test_uts46_2672(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----dqc20828e.xn--bc9an2879c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----dqc20828e.xn--bc9an2879c', strict=True)

    def test_uts46_2673(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٸ。\U000e03ec݁\U0001eaad𐹪', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٸ。\U000e03ec݁\U0001eaad𐹪', strict=True)

    def test_uts46_2674(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'يٴ。\U000e03ec݁\U0001eaad𐹪', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'يٴ。\U000e03ec݁\U0001eaad𐹪', strict=True)

    def test_uts46_2675(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mhb8f.xn--oob2585kfdsfsbo7h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mhb8f.xn--oob2585kfdsfsbo7h', strict=True)

    def test_uts46_2676(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫆ꌄ｡\u200dᣬ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫆ꌄ｡\u200dᣬ', strict=True)

    def test_uts46_2677(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫆ꌄ。\u200dᣬ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫆ꌄ。\u200dᣬ', strict=True)

    def test_uts46_2678(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y77ao18q.xn--wdf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y77ao18q.xn--wdf', strict=True)

    def test_uts46_2679(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y77ao18q.xn--wdf367a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y77ao18q.xn--wdf367a', strict=True)

    def test_uts46_2680(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₀٢。\U000c5a9e≯-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₀٢。\U000c5a9e≯-', strict=True)

    def test_uts46_2681(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₀٢。\U000c5a9e≯-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₀٢。\U000c5a9e≯-', strict=True)

    def test_uts46_2682(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0٢。\U000c5a9e≯-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0٢。\U000c5a9e≯-', strict=True)

    def test_uts46_2683(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0٢。\U000c5a9e≯-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0٢。\U000c5a9e≯-', strict=True)

    def test_uts46_2684(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0-dqc.xn----ogov3342l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0-dqc.xn----ogov3342l', strict=True)

    def test_uts46_2685(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̜𐹫-\U0001ebc3.𐋤ࡅ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̜𐹫-\U0001ebc3.𐋤ࡅ', strict=True)

    def test_uts46_2686(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----gdb7046r692g.xn--3vb1349j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----gdb7046r692g.xn--3vb1349j', strict=True)

    def test_uts46_2687(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠｡𝩑𐹩Ⴡ֔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠｡𝩑𐹩Ⴡ֔', strict=True)

    def test_uts46_2688(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠｡𝩑𐹩Ⴡ֔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠｡𝩑𐹩Ⴡ֔', strict=True)

    def test_uts46_2689(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠。𝩑𐹩Ⴡ֔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠。𝩑𐹩Ⴡ֔', strict=True)

    def test_uts46_2690(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠。𝩑𐹩Ⴡ֔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠。𝩑𐹩Ⴡ֔', strict=True)

    def test_uts46_2691(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠。𝩑𐹩ⴡ֔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠。𝩑𐹩ⴡ֔', strict=True)

    def test_uts46_2692(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠。𝩑𐹩ⴡ֔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠。𝩑𐹩ⴡ֔', strict=True)

    def test_uts46_2693(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch.xn--fcb363rk03mypug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch.xn--fcb363rk03mypug', strict=True)

    def test_uts46_2694(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠｡𝩑𐹩ⴡ֔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠｡𝩑𐹩ⴡ֔', strict=True)

    def test_uts46_2695(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠｡𝩑𐹩ⴡ֔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠｡𝩑𐹩ⴡ֔', strict=True)

    def test_uts46_2696(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch.xn--fcb538c649rypog', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch.xn--fcb538c649rypog', strict=True)

    def test_uts46_2697(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𖫳≠.Ⴀ𐮀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𖫳≠.Ⴀ𐮀', strict=True)

    def test_uts46_2698(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𖫳≠.Ⴀ𐮀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𖫳≠.Ⴀ𐮀', strict=True)

    def test_uts46_2699(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𖫳≠.ⴀ𐮀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𖫳≠.ⴀ𐮀', strict=True)

    def test_uts46_2700(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𖫳≠.ⴀ𐮀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𖫳≠.ⴀ𐮀', strict=True)

    def test_uts46_2701(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch9250k.xn--rkj6232e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch9250k.xn--rkj6232e', strict=True)

    def test_uts46_2702(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch9250k.xn--7md2659j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch9250k.xn--7md2659j', strict=True)

    def test_uts46_2703(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅾ܶܦ．ᢚ閪\u08e2𝩟', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅾ܶܦ．ᢚ閪\u08e2𝩟', strict=True)

    def test_uts46_2704(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅾ܶܦ.ᢚ閪\u08e2𝩟', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅾ܶܦ.ᢚ閪\u08e2𝩟', strict=True)

    def test_uts46_2705(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wnb5a.xn--l0b161fis8gbp5m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wnb5a.xn--l0b161fis8gbp5m', strict=True)

    def test_uts46_2706(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d󠇜ۋ꣩｡⃝ྰ-ᛟ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d󠇜ۋ꣩｡⃝ྰ-ᛟ', strict=True)

    def test_uts46_2707(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d󠇜ۋ꣩。⃝ྰ-ᛟ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d󠇜ۋ꣩。⃝ྰ-ᛟ', strict=True)

    def test_uts46_2708(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--blb8114f.xn----gmg236cj6k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--blb8114f.xn----gmg236cj6k', strict=True)

    def test_uts46_2709(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--blb540ke10h.xn----gmg236cj6k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--blb540ke10h.xn----gmg236cj6k', strict=True)

    def test_uts46_2710(self):
        self.assertRaises(idna.IDNAError, idna.decode, '헁\U000d8599ฺ\U000da35a。ں𝟜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '헁\U000d8599ฺ\U000da35a。ں𝟜', strict=True)

    def test_uts46_2711(self):
        self.assertRaises(idna.IDNAError, idna.decode, '헁\U000d8599ฺ\U000da35a。ں𝟜', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '헁\U000d8599ฺ\U000da35a。ں𝟜', strict=True)

    def test_uts46_2712(self):
        self.assertRaises(idna.IDNAError, idna.decode, '헁\U000d8599ฺ\U000da35a。ں4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '헁\U000d8599ฺ\U000da35a。ں4', strict=True)

    def test_uts46_2713(self):
        self.assertRaises(idna.IDNAError, idna.decode, '헁\U000d8599ฺ\U000da35a。ں4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '헁\U000d8599ฺ\U000da35a。ں4', strict=True)

    def test_uts46_2714(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--o4c1723h8g85gt4ya.xn--4-dvc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--o4c1723h8g85gt4ya.xn--4-dvc', strict=True)

    def test_uts46_2715(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹭｡\U000c3c42\u200cႾ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹭｡\U000c3c42\u200cႾ', strict=True)

    def test_uts46_2716(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹭。\U000c3c42\u200cႾ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹭。\U000c3c42\u200cႾ', strict=True)

    def test_uts46_2717(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹭。\U000c3c42\u200cⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹭。\U000c3c42\u200cⴞ', strict=True)

    def test_uts46_2718(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lo0d.xn--mljx1099g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lo0d.xn--mljx1099g', strict=True)

    def test_uts46_2719(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lo0d.xn--0ugx72cwi33v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lo0d.xn--0ugx72cwi33v', strict=True)

    def test_uts46_2720(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹭｡\U000c3c42\u200cⴞ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹭｡\U000c3c42\u200cⴞ', strict=True)

    def test_uts46_2721(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lo0d.xn--2nd75260n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lo0d.xn--2nd75260n', strict=True)

    def test_uts46_2722(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lo0d.xn--2nd949eqw95u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lo0d.xn--2nd949eqw95u', strict=True)

    def test_uts46_2723(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꥓.̽\U000110bd馋', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꥓.̽\U000110bd馋', strict=True)

    def test_uts46_2724(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3j9a.xn--bua0708eqzrd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3j9a.xn--bua0708eqzrd', strict=True)

    def test_uts46_2725(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000c8add\U000aa6f8\u200d｡䜖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000c8add\U000aa6f8\u200d｡䜖', strict=True)

    def test_uts46_2726(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000c8add\U000aa6f8\u200d。䜖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000c8add\U000aa6f8\u200d。䜖', strict=True)

    def test_uts46_2727(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--g138cxw05a.xn--k0o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--g138cxw05a.xn--k0o', strict=True)

    def test_uts46_2728(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug30527h9mxi.xn--k0o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug30527h9mxi.xn--k0o', strict=True)

    def test_uts46_2729(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡯ⚉姶🄉．۷\u200d🎪\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡯ⚉姶🄉．۷\u200d🎪\u200d', strict=True)

    def test_uts46_2730(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡯ⚉姶8,.۷\u200d🎪\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡯ⚉姶8,.۷\u200d🎪\u200d', strict=True)

    def test_uts46_2731(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8,-g9oy26fzu4d.xn--kmb6733w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8,-g9oy26fzu4d.xn--kmb6733w', strict=True)

    def test_uts46_2732(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8,-g9oy26fzu4d.xn--kmb859ja94998b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8,-g9oy26fzu4d.xn--kmb859ja94998b', strict=True)

    def test_uts46_2733(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--c9e433epi4b3j20a.xn--kmb6733w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--c9e433epi4b3j20a.xn--kmb6733w', strict=True)

    def test_uts46_2734(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--c9e433epi4b3j20a.xn--kmb859ja94998b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--c9e433epi4b3j20a.xn--kmb859ja94998b', strict=True)

    def test_uts46_2735(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ef40.𐹸🚖ฺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ef40.𐹸🚖ฺ', strict=True)

    def test_uts46_2736(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0n7h.xn--o4c9032klszf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0n7h.xn--o4c9032klszf', strict=True)

    def test_uts46_2737(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴔᠵ｡𐹧݇۹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴔᠵ｡𐹧݇۹', strict=True)

    def test_uts46_2738(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴔᠵ。𐹧݇۹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴔᠵ。𐹧݇۹', strict=True)

    def test_uts46_2739(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴔᠵ。𐹧݇۹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴔᠵ。𐹧݇۹', strict=True)

    def test_uts46_2740(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--o7e997h.xn--mmb9ml895e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--o7e997h.xn--mmb9ml895e', strict=True)

    def test_uts46_2741(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴔᠵ｡𐹧݇۹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴔᠵ｡𐹧݇۹', strict=True)

    def test_uts46_2742(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--snd659a.xn--mmb9ml895e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--snd659a.xn--mmb9ml895e', strict=True)

    def test_uts46_2743(self):
        self.assertRaises(idna.IDNAError, idna.decode, '፟ᡈ\u200c．︒-𖾐-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '፟ᡈ\u200c．︒-𖾐-', strict=True)

    def test_uts46_2744(self):
        self.assertRaises(idna.IDNAError, idna.decode, '፟ᡈ\u200c.。-𖾐-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '፟ᡈ\u200c.。-𖾐-', strict=True)

    def test_uts46_2745(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b7d82w..xn-----pe4u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b7d82w..xn-----pe4u', strict=True)

    def test_uts46_2746(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b7d82wo4h..xn-----pe4u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b7d82wo4h..xn-----pe4u', strict=True)

    def test_uts46_2747(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b7d82w.xn-----c82nz547a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b7d82w.xn-----c82nz547a', strict=True)

    def test_uts46_2748(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b7d82wo4h.xn-----c82nz547a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b7d82wo4h.xn-----c82nz547a', strict=True)

    def test_uts46_2749(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈\u0601⒖\u200c.ᷰߛ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈\u0601⒖\u200c.ᷰߛ', strict=True)

    def test_uts46_2750(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.\u060115.\u200c.ᷰߛ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.\u060115.\u200c.ᷰߛ', strict=True)

    def test_uts46_2751(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--15-1pd..xn--2sb914i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--15-1pd..xn--2sb914i', strict=True)

    def test_uts46_2752(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--15-1pd.xn--0ug.xn--2sb914i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--15-1pd.xn--0ug.xn--2sb914i', strict=True)

    def test_uts46_2753(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jfb347mib.xn--2sb914i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jfb347mib.xn--2sb914i', strict=True)

    def test_uts46_2754(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jfb844kmfdwb.xn--2sb914i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jfb844kmfdwb.xn--2sb914i', strict=True)

    def test_uts46_2755(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝩜。-୍Ⴋ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝩜。-୍Ⴋ', strict=True)

    def test_uts46_2756(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝩜。-୍ⴋ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝩜。-୍ⴋ', strict=True)

    def test_uts46_2757(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--792h.xn----bse820x', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--792h.xn----bse820x', strict=True)

    def test_uts46_2758(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--792h.xn----bse632b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--792h.xn----bse632b', strict=True)

    def test_uts46_2759(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ßჀ.ؠ刯Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ßჀ.ؠ刯Ⴝ', strict=True)

    def test_uts46_2760(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ßⴠ.ؠ刯ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ßⴠ.ؠ刯ⴝ', strict=True)

    def test_uts46_2761(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SSჀ.ؠ刯Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SSჀ.ؠ刯Ⴝ', strict=True)

    def test_uts46_2762(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ssⴠ.ؠ刯ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ssⴠ.ؠ刯ⴝ', strict=True)

    def test_uts46_2763(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ssⴠ.ؠ刯Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ssⴠ.ؠ刯Ⴝ', strict=True)

    def test_uts46_2764(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-j81a.xn--fgb670rovy', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-j81a.xn--fgb670rovy', strict=True)

    def test_uts46_2765(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca277t.xn--fgb670rovy', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca277t.xn--fgb670rovy', strict=True)

    def test_uts46_2766(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-j81a.xn--fgb845cb66c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-j81a.xn--fgb845cb66c', strict=True)

    def test_uts46_2767(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-wgk.xn--fgb845cb66c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-wgk.xn--fgb845cb66c', strict=True)

    def test_uts46_2768(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca442f.xn--fgb845cb66c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca442f.xn--fgb845cb66c', strict=True)

    def test_uts46_2769(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪ႣℲ｡ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪ႣℲ｡ᠳ툻ٳ', strict=True)

    def test_uts46_2770(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪ႣℲ｡ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪ႣℲ｡ᠳ툻ٳ', strict=True)

    def test_uts46_2771(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪ႣℲ。ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪ႣℲ。ᠳ툻ٳ', strict=True)

    def test_uts46_2772(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪ႣℲ。ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪ႣℲ。ᠳ툻ٳ', strict=True)

    def test_uts46_2773(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪ⴃⅎ。ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪ⴃⅎ。ᠳ툻ٳ', strict=True)

    def test_uts46_2774(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪ⴃⅎ。ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪ⴃⅎ。ᠳ툻ٳ', strict=True)

    def test_uts46_2775(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪Ⴃⅎ。ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪Ⴃⅎ。ᠳ툻ٳ', strict=True)

    def test_uts46_2776(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪Ⴃⅎ。ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪Ⴃⅎ。ᠳ툻ٳ', strict=True)

    def test_uts46_2777(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--yxf24x4ol.xn--sib102gc69k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--yxf24x4ol.xn--sib102gc69k', strict=True)

    def test_uts46_2778(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪ⴃⅎ｡ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪ⴃⅎ｡ᠳ툻ٳ', strict=True)

    def test_uts46_2779(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪ⴃⅎ｡ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪ⴃⅎ｡ᠳ툻ٳ', strict=True)

    def test_uts46_2780(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪Ⴃⅎ｡ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪Ⴃⅎ｡ᠳ툻ٳ', strict=True)

    def test_uts46_2781(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᮪Ⴃⅎ｡ᠳ툻ٳ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᮪Ⴃⅎ｡ᠳ툻ٳ', strict=True)

    def test_uts46_2782(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bnd957c2pe.xn--sib102gc69k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bnd957c2pe.xn--sib102gc69k', strict=True)

    def test_uts46_2783(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bnd957cone.xn--sib102gc69k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bnd957cone.xn--sib102gc69k', strict=True)

    def test_uts46_2784(self):
        self.assertRaises(idna.IDNAError, idna.decode, '۬.ࢢ𐹫ټ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '۬.ࢢ𐹫ټ', strict=True)

    def test_uts46_2785(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8lb.xn--1ib31ily45b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8lb.xn--1ib31ily45b', strict=True)

    def test_uts46_2790(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴣ𐹻.\u200c𝪣≮\U000e0a49', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴣ𐹻.\u200c𝪣≮\U000e0a49', strict=True)

    def test_uts46_2791(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴣ𐹻.\u200c𝪣≮\U000e0a49', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴣ𐹻.\u200c𝪣≮\U000e0a49', strict=True)

    def test_uts46_2792(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴣ𐹻.\u200c𝪣≮\U000e0a49', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴣ𐹻.\u200c𝪣≮\U000e0a49', strict=True)

    def test_uts46_2793(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴣ𐹻.\u200c𝪣≮\U000e0a49', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴣ𐹻.\u200c𝪣≮\U000e0a49', strict=True)

    def test_uts46_2794(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rlj6323e.xn--gdh4944ob3x3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rlj6323e.xn--gdh4944ob3x3e', strict=True)

    def test_uts46_2795(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rlj6323e.xn--0ugy6gn120eb103g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rlj6323e.xn--0ugy6gn120eb103g', strict=True)

    def test_uts46_2796(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7nd8101k.xn--gdh4944ob3x3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7nd8101k.xn--gdh4944ob3x3e', strict=True)

    def test_uts46_2797(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7nd8101k.xn--0ugy6gn120eb103g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7nd8101k.xn--0ugy6gn120eb103g', strict=True)

    def test_uts46_2798(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟵隁⯮．᠍\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟵隁⯮．᠍\u200c', strict=True)

    def test_uts46_2799(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9隁⯮.᠍\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9隁⯮.᠍\u200c', strict=True)

    def test_uts46_2800(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-mfs8024b.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-mfs8024b.', strict=True)

    def test_uts46_2801(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9隁⯮.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9隁⯮.', strict=True)

    def test_uts46_2802(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-mfs8024b.xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-mfs8024b.xn--0ug', strict=True)

    def test_uts46_2803(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒏𐹧｡Ⴣ྄彦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒏𐹧｡Ⴣ྄彦', strict=True)

    def test_uts46_2804(self):
        self.assertRaises(idna.IDNAError, idna.decode, '8.𐹧。Ⴣ྄彦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '8.𐹧。Ⴣ྄彦', strict=True)

    def test_uts46_2805(self):
        self.assertRaises(idna.IDNAError, idna.decode, '8.𐹧。ⴣ྄彦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '8.𐹧。ⴣ྄彦', strict=True)

    def test_uts46_2806(self):
        self.assertRaises(idna.IDNAError, idna.decode, '8.xn--fo0d.xn--3ed972m6o8a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '8.xn--fo0d.xn--3ed972m6o8a', strict=True)

    def test_uts46_2807(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒏𐹧｡ⴣ྄彦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒏𐹧｡ⴣ྄彦', strict=True)

    def test_uts46_2808(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0sh2466f.xn--3ed972m6o8a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0sh2466f.xn--3ed972m6o8a', strict=True)

    def test_uts46_2809(self):
        self.assertRaises(idna.IDNAError, idna.decode, '8.xn--fo0d.xn--3ed15dt93o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '8.xn--fo0d.xn--3ed15dt93o', strict=True)

    def test_uts46_2810(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0sh2466f.xn--3ed15dt93o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0sh2466f.xn--3ed15dt93o', strict=True)

    def test_uts46_2811(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-问\U0006cc14⒛。\u0604-\U0005c5c9橬', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-问\U0006cc14⒛。\u0604-\U0005c5c9橬', strict=True)

    def test_uts46_2812(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-问\U0006cc1420.。\u0604-\U0005c5c9橬', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-问\U0006cc1420.。\u0604-\U0005c5c9橬', strict=True)

    def test_uts46_2813(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---20-658jx1776d..xn----ykc7228efm46d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---20-658jx1776d..xn----ykc7228efm46d', strict=True)

    def test_uts46_2814(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----hdpu849bhis3e.xn----ykc7228efm46d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----hdpu849bhis3e.xn----ykc7228efm46d', strict=True)

    def test_uts46_2815(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᮬႬ\u200c̥。𝟸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᮬႬ\u200c̥。𝟸', strict=True)

    def test_uts46_2816(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᮬႬ\u200c̥。2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᮬႬ\u200c̥。2', strict=True)

    def test_uts46_2817(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᮬⴌ\u200c̥。2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᮬⴌ\u200c̥。2', strict=True)

    def test_uts46_2818(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mta176jjjm.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mta176jjjm.c', strict=True)

    def test_uts46_2819(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mta176j97cl2q.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mta176j97cl2q.c', strict=True)

    def test_uts46_2820(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᮬⴌ\u200c̥。𝟸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᮬⴌ\u200c̥。𝟸', strict=True)

    def test_uts46_2821(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mta930emri.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mta930emri.c', strict=True)

    def test_uts46_2822(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mta930emribme.c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mta930emribme.c', strict=True)

    def test_uts46_2823(self):
        self.assertRaises(idna.IDNAError, idna.decode, '?。꠆٩\U000e04a9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '?。꠆٩\U000e04a9', strict=True)

    def test_uts46_2824(self):
        self.assertRaises(idna.IDNAError, idna.decode, '?.xn--iib9583fusy0i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '?.xn--iib9583fusy0i', strict=True)

    def test_uts46_2825(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄁͟⾶｡₇︒눇≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄁͟⾶｡₇︒눇≮', strict=True)

    def test_uts46_2826(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄁͟⾶｡₇︒눇≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄁͟⾶｡₇︒눇≮', strict=True)

    def test_uts46_2827(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄁͟飛。7。눇≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄁͟飛。7。눇≮', strict=True)

    def test_uts46_2828(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠄁͟飛。7。눇≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠄁͟飛。7。눇≮', strict=True)

    def test_uts46_2829(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ua0567e.7.xn--gdh6767c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ua0567e.7.xn--gdh6767c', strict=True)

    def test_uts46_2830(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ua0567e.xn--7-ngou006d1ttc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ua0567e.xn--7-ngou006d1ttc', strict=True)

    def test_uts46_2831(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c︉𐹴\u200d．\u200c⿃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c︉𐹴\u200d．\u200c⿃', strict=True)

    def test_uts46_2832(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c︉𐹴\u200d.\u200c鳥', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c︉𐹴\u200d.\u200c鳥', strict=True)

    def test_uts46_2833(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--so0d.xn--6x6a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--so0d.xn--6x6a', strict=True)

    def test_uts46_2834(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugc6024p.xn--0ug1920c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugc6024p.xn--0ug1920c', strict=True)

    def test_uts46_2835(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🍮．\u200d\U000e05d2𐦁𝨝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🍮．\u200d\U000e05d2𐦁𝨝', strict=True)

    def test_uts46_2836(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🍮.\u200d\U000e05d2𐦁𝨝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🍮.\u200d\U000e05d2𐦁𝨝', strict=True)

    def test_uts46_2837(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lj8h.xn--ln9ci476aqmr2g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lj8h.xn--ln9ci476aqmr2g', strict=True)

    def test_uts46_2838(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lj8h.xn--1ug6603gr1pfwq37h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lj8h.xn--1ug6603gr1pfwq37h', strict=True)

    def test_uts46_2839(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽृ.𞤓\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽृ.𞤓\u200d', strict=True)

    def test_uts46_2840(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽृ.𞤵\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽृ.𞤵\u200d', strict=True)

    def test_uts46_2841(self):
        self.assertEqual(idna.decode('xn--2ib43l.xn--te6h', uts46=True, strict=True), 'ٽृ.𞤵')
        self.assertEqual(idna.encode('xn--2ib43l.xn--te6h', uts46=True, strict=True), b'xn--2ib43l.xn--te6h')

    def test_uts46_2842(self):
        self.assertEqual(idna.decode('ٽृ.𞤵', uts46=True, strict=True), 'ٽृ.𞤵')
        self.assertEqual(idna.encode('ٽृ.𞤵', uts46=True, strict=True), b'xn--2ib43l.xn--te6h')

    def test_uts46_2843(self):
        self.assertEqual(idna.decode('ٽृ.𞤓', uts46=True, strict=True), 'ٽृ.𞤵')
        self.assertEqual(idna.encode('ٽृ.𞤓', uts46=True, strict=True), b'xn--2ib43l.xn--te6h')

    def test_uts46_2844(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2ib43l.xn--1ugy711p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2ib43l.xn--1ugy711p', strict=True)

    def test_uts46_2845(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٤੍-．\U000e573d္\U00066990', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٤੍-．\U000e573d္\U00066990', strict=True)

    def test_uts46_2846(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٤੍-.\U000e573d္\U00066990', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٤੍-.\U000e573d္\U00066990', strict=True)

    def test_uts46_2847(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----gqc711a.xn--9jd88234f3qm0b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----gqc711a.xn--9jd88234f3qm0b', strict=True)

    def test_uts46_2848(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4်-𐹸｡ꨩ\u200c𐹴≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4်-𐹸｡ꨩ\u200c𐹴≮', strict=True)

    def test_uts46_2849(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4်-𐹸｡ꨩ\u200c𐹴≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4်-𐹸｡ꨩ\u200c𐹴≮', strict=True)

    def test_uts46_2850(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4်-𐹸。ꨩ\u200c𐹴≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4်-𐹸。ꨩ\u200c𐹴≮', strict=True)

    def test_uts46_2851(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4်-𐹸。ꨩ\u200c𐹴≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4်-𐹸。ꨩ\u200c𐹴≮', strict=True)

    def test_uts46_2852(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4--e4j7831r.xn--gdh8754cz40c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4--e4j7831r.xn--gdh8754cz40c', strict=True)

    def test_uts46_2853(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4--e4j7831r.xn--0ugy6gjy5sl3ud', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4--e4j7831r.xn--0ugy6gjy5sl3ud', strict=True)

    def test_uts46_2854(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c。ﾠ྄ྖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c。ﾠ྄ྖ', strict=True)

    def test_uts46_2855(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c。ᅠ྄ྖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c。ᅠ྄ྖ', strict=True)

    def test_uts46_2856(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--3ed0b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--3ed0b', strict=True)

    def test_uts46_2857(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--3ed0b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--3ed0b', strict=True)

    def test_uts46_2858(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--3ed0b20h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--3ed0b20h', strict=True)

    def test_uts46_2859(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--3ed0b20h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--3ed0b20h', strict=True)

    def test_uts46_2860(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--3ed0by082k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--3ed0by082k', strict=True)

    def test_uts46_2861(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--3ed0by082k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--3ed0by082k', strict=True)

    def test_uts46_2862(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯\U0008d605．\u200d𐅼\U000b21db', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯\U0008d605．\u200d𐅼\U000b21db', strict=True)

    def test_uts46_2863(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯\U0008d605．\u200d𐅼\U000b21db', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯\U0008d605．\u200d𐅼\U000b21db', strict=True)

    def test_uts46_2864(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯\U0008d605.\u200d𐅼\U000b21db', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯\U0008d605.\u200d𐅼\U000b21db', strict=True)

    def test_uts46_2865(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯\U0008d605.\u200d𐅼\U000b21db', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯\U0008d605.\u200d𐅼\U000b21db', strict=True)

    def test_uts46_2866(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh84488f.xn--xy7cw2886b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh84488f.xn--xy7cw2886b', strict=True)

    def test_uts46_2867(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdh84488f.xn--1ug8099fbjp4e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdh84488f.xn--1ug8099fbjp4e', strict=True)

    def test_uts46_2868(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'فß𐰯｡𝟕𐫫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'فß𐰯｡𝟕𐫫', strict=True)

    def test_uts46_2869(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'فß𐰯。7𐫫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'فß𐰯。7𐫫', strict=True)

    def test_uts46_2870(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'فSS𐰯。7𐫫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'فSS𐰯。7𐫫', strict=True)

    def test_uts46_2871(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'فss𐰯。7𐫫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'فss𐰯。7𐫫', strict=True)

    def test_uts46_2872(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-jvd2339x.xn--7-mm5i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-jvd2339x.xn--7-mm5i', strict=True)

    def test_uts46_2873(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca96ys96y.xn--7-mm5i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca96ys96y.xn--7-mm5i', strict=True)

    def test_uts46_2874(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'فSS𐰯｡𝟕𐫫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'فSS𐰯｡𝟕𐫫', strict=True)

    def test_uts46_2875(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'فss𐰯｡𝟕𐫫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'فss𐰯｡𝟕𐫫', strict=True)

    def test_uts46_2876(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'فSs𐰯。7𐫫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'فSs𐰯。7𐫫', strict=True)

    def test_uts46_2877(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'فSs𐰯｡𝟕𐫫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'فSs𐰯｡𝟕𐫫', strict=True)

    def test_uts46_2878(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ßެާࢱ。𐭁\U00105b99𐹲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ßެާࢱ。𐭁\U00105b99𐹲', strict=True)

    def test_uts46_2879(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SSެާࢱ。𐭁\U00105b99𐹲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SSެާࢱ。𐭁\U00105b99𐹲', strict=True)

    def test_uts46_2880(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ssެާࢱ。𐭁\U00105b99𐹲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ssެާࢱ。𐭁\U00105b99𐹲', strict=True)

    def test_uts46_2881(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ssެާࢱ。𐭁\U00105b99𐹲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ssެާࢱ。𐭁\U00105b99𐹲', strict=True)

    def test_uts46_2882(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-9qet02k.xn--e09co8cr9861c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-9qet02k.xn--e09co8cr9861c', strict=True)

    def test_uts46_2883(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca685aoa95h.xn--e09co8cr9861c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca685aoa95h.xn--e09co8cr9861c', strict=True)

    def test_uts46_2884(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-｡\U000e0257⒌\U0001ebdb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-｡\U000e0257⒌\U0001ebdb', strict=True)

    def test_uts46_2885(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-。\U000e02575.\U0001ebdb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-。\U000e02575.\U0001ebdb', strict=True)

    def test_uts46_2886(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--5-zz21m.xn--6x6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--5-zz21m.xn--6x6h', strict=True)

    def test_uts46_2887(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--xsh6367n1bi3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--xsh6367n1bi3e', strict=True)

    def test_uts46_2888(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fς．-≮ﲫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fς．-≮ﲫ', strict=True)

    def test_uts46_2889(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fς．-≮ﲫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fς．-≮ﲫ', strict=True)

    def test_uts46_2890(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fς.-≮خج', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fς.-≮خج', strict=True)

    def test_uts46_2891(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fς.-≮خج', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fς.-≮خج', strict=True)

    def test_uts46_2892(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fΣ.-≮خج', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fΣ.-≮خج', strict=True)

    def test_uts46_2893(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fΣ.-≮خج', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fΣ.-≮خج', strict=True)

    def test_uts46_2894(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fσ.-≮خج', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fσ.-≮خج', strict=True)

    def test_uts46_2895(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fσ.-≮خج', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fσ.-≮خج', strict=True)

    def test_uts46_2896(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa92520c.xn----9mcf1400a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa92520c.xn----9mcf1400a', strict=True)

    def test_uts46_2897(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa13520c.xn----9mcf1400a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa13520c.xn----9mcf1400a', strict=True)

    def test_uts46_2898(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fΣ．-≮ﲫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fΣ．-≮ﲫ', strict=True)

    def test_uts46_2899(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fΣ．-≮ﲫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fΣ．-≮ﲫ', strict=True)

    def test_uts46_2900(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fσ．-≮ﲫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fσ．-≮ﲫ', strict=True)

    def test_uts46_2901(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003c38fσ．-≮ﲫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003c38fσ．-≮ﲫ', strict=True)

    def test_uts46_2902(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡗࢸܙ．\U00054914\U000e06d9్ﰾ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡗࢸܙ．\U00054914\U000e06d9్ﰾ', strict=True)

    def test_uts46_2903(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡗࢸܙ.\U00054914\U000e06d9్كي', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡗࢸܙ.\U00054914\U000e06d9్كي', strict=True)

    def test_uts46_2904(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jnb34fs003a.xn--fhbo927bk128mpi24d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jnb34fs003a.xn--fhbo927bk128mpi24d', strict=True)

    def test_uts46_2905(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐠰ࢷ𞤌𐫭。𐋦៍𝩃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐠰ࢷ𞤌𐫭。𐋦៍𝩃', strict=True)

    def test_uts46_2906(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐠰ࢷ𞤮𐫭。𐋦៍𝩃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐠰ࢷ𞤮𐫭。𐋦៍𝩃', strict=True)

    def test_uts46_2907(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dzb5191kezbrw47a.xn--p4e3841jz9tf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dzb5191kezbrw47a.xn--p4e3841jz9tf', strict=True)

    def test_uts46_2908(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐠰ࢷ𞤮𐫭.𐋦៍𝩃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐠰ࢷ𞤮𐫭.𐋦៍𝩃', strict=True)

    def test_uts46_2909(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐠰ࢷ𞤌𐫭.𐋦៍𝩃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐠰ࢷ𞤌𐫭.𐋦៍𝩃', strict=True)

    def test_uts46_2910(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₂㘷--。ۓ\u200c𐫆𑖿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₂㘷--。ۓ\u200c𐫆𑖿', strict=True)

    def test_uts46_2911(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₂㘷--。ۓ\u200c𐫆𑖿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₂㘷--。ۓ\u200c𐫆𑖿', strict=True)

    def test_uts46_2912(self):
        self.assertRaises(idna.IDNAError, idna.decode, '2㘷--。ۓ\u200c𐫆𑖿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '2㘷--。ۓ\u200c𐫆𑖿', strict=True)

    def test_uts46_2913(self):
        self.assertRaises(idna.IDNAError, idna.decode, '2㘷--。ۓ\u200c𐫆𑖿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '2㘷--。ۓ\u200c𐫆𑖿', strict=True)

    def test_uts46_2914(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2---u58b.xn--jlb8024k14g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2---u58b.xn--jlb8024k14g', strict=True)

    def test_uts46_2915(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2---u58b.xn--jlb820ku99nbgj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2---u58b.xn--jlb820ku99nbgj', strict=True)

    def test_uts46_2916(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𘊻．ᡮح-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𘊻．ᡮح-', strict=True)

    def test_uts46_2917(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𘊻.ᡮح-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𘊻.ᡮح-', strict=True)

    def test_uts46_2918(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----bp5n.xn----bnc231l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----bp5n.xn----bnc231l', strict=True)

    def test_uts46_2919(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c-ß｡ᢣ𐹭ؿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c-ß｡ᢣ𐹭ؿ', strict=True)

    def test_uts46_2920(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c-ß。ᢣ𐹭ؿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c-ß。ᢣ𐹭ؿ', strict=True)

    def test_uts46_2921(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c-SS。ᢣ𐹭ؿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c-SS。ᢣ𐹭ؿ', strict=True)

    def test_uts46_2922(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c-ss。ᢣ𐹭ؿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c-ss。ᢣ𐹭ؿ', strict=True)

    def test_uts46_2923(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c-Ss。ᢣ𐹭ؿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c-Ss。ᢣ𐹭ؿ', strict=True)

    def test_uts46_2924(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ss.xn--bhb925glx3p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ss.xn--bhb925glx3p', strict=True)

    def test_uts46_2925(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---ss-8m0a.xn--bhb925glx3p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---ss-8m0a.xn--bhb925glx3p', strict=True)

    def test_uts46_2926(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----qfa550v.xn--bhb925glx3p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----qfa550v.xn--bhb925glx3p', strict=True)

    def test_uts46_2927(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c-SS｡ᢣ𐹭ؿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c-SS｡ᢣ𐹭ؿ', strict=True)

    def test_uts46_2928(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c-ss｡ᢣ𐹭ؿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c-ss｡ᢣ𐹭ؿ', strict=True)

    def test_uts46_2929(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c-Ss｡ᢣ𐹭ؿ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c-Ss｡ᢣ𐹭ؿ', strict=True)

    def test_uts46_2930(self):
        self.assertEqual(idna.decode('꧐Ӏ᮪ࣶ．눵', uts46=True, strict=True), '꧐ӏ᮪ࣶ.눵')
        self.assertEqual(idna.encode('꧐Ӏ᮪ࣶ．눵', uts46=True, strict=True), b'xn--s5a04sn4u297k.xn--2e1b')

    def test_uts46_2931(self):
        self.assertEqual(idna.decode('꧐Ӏ᮪ࣶ．눵', uts46=True, strict=True), '꧐ӏ᮪ࣶ.눵')
        self.assertEqual(idna.encode('꧐Ӏ᮪ࣶ．눵', uts46=True, strict=True), b'xn--s5a04sn4u297k.xn--2e1b')

    def test_uts46_2932(self):
        self.assertEqual(idna.decode('꧐Ӏ᮪ࣶ.눵', uts46=True, strict=True), '꧐ӏ᮪ࣶ.눵')
        self.assertEqual(idna.encode('꧐Ӏ᮪ࣶ.눵', uts46=True, strict=True), b'xn--s5a04sn4u297k.xn--2e1b')

    def test_uts46_2933(self):
        self.assertEqual(idna.decode('꧐Ӏ᮪ࣶ.눵', uts46=True, strict=True), '꧐ӏ᮪ࣶ.눵')
        self.assertEqual(idna.encode('꧐Ӏ᮪ࣶ.눵', uts46=True, strict=True), b'xn--s5a04sn4u297k.xn--2e1b')

    def test_uts46_2934(self):
        self.assertEqual(idna.decode('꧐ӏ᮪ࣶ.눵', uts46=True, strict=True), '꧐ӏ᮪ࣶ.눵')
        self.assertEqual(idna.encode('꧐ӏ᮪ࣶ.눵', uts46=True, strict=True), b'xn--s5a04sn4u297k.xn--2e1b')

    def test_uts46_2935(self):
        self.assertEqual(idna.decode('꧐ӏ᮪ࣶ.눵', uts46=True, strict=True), '꧐ӏ᮪ࣶ.눵')
        self.assertEqual(idna.encode('꧐ӏ᮪ࣶ.눵', uts46=True, strict=True), b'xn--s5a04sn4u297k.xn--2e1b')

    def test_uts46_2936(self):
        self.assertEqual(idna.decode('xn--s5a04sn4u297k.xn--2e1b', uts46=True, strict=True), '꧐ӏ᮪ࣶ.눵')
        self.assertEqual(idna.encode('xn--s5a04sn4u297k.xn--2e1b', uts46=True, strict=True), b'xn--s5a04sn4u297k.xn--2e1b')

    def test_uts46_2937(self):
        self.assertEqual(idna.decode('꧐ӏ᮪ࣶ．눵', uts46=True, strict=True), '꧐ӏ᮪ࣶ.눵')
        self.assertEqual(idna.encode('꧐ӏ᮪ࣶ．눵', uts46=True, strict=True), b'xn--s5a04sn4u297k.xn--2e1b')

    def test_uts46_2938(self):
        self.assertEqual(idna.decode('꧐ӏ᮪ࣶ．눵', uts46=True, strict=True), '꧐ӏ᮪ࣶ.눵')
        self.assertEqual(idna.encode('꧐ӏ᮪ࣶ．눵', uts46=True, strict=True), b'xn--s5a04sn4u297k.xn--2e1b')

    def test_uts46_2939(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--d5a07sn4u297k.xn--2e1b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--d5a07sn4u297k.xn--2e1b', strict=True)

    def test_uts46_2940(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꣪｡\U0001613f𑆾󠇗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꣪｡\U0001613f𑆾󠇗', strict=True)

    def test_uts46_2941(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꣪。\U0001613f𑆾󠇗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꣪。\U0001613f𑆾󠇗', strict=True)

    def test_uts46_2942(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3g9a.xn--ud1dz07k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3g9a.xn--ud1dz07k', strict=True)

    def test_uts46_2943(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000c74d3𑚳。\U00050dff≯⾇', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000c74d3𑚳。\U00050dff≯⾇', strict=True)

    def test_uts46_2944(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000c74d3𑚳。\U00050dff≯⾇', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000c74d3𑚳。\U00050dff≯⾇', strict=True)

    def test_uts46_2945(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000c74d3𑚳。\U00050dff≯舛', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000c74d3𑚳。\U00050dff≯舛', strict=True)

    def test_uts46_2946(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000c74d3𑚳。\U00050dff≯舛', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000c74d3𑚳。\U00050dff≯舛', strict=True)

    def test_uts46_2947(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3e2d79770c.xn--hdh0088abyy1c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3e2d79770c.xn--hdh0088abyy1c', strict=True)

    def test_uts46_2948(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫇١\u200c．\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫇١\u200c．\u200d\u200c', strict=True)

    def test_uts46_2949(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫇١\u200c.\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫇١\u200c.\u200d\u200c', strict=True)

    def test_uts46_2952(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9hb652kv99n.xn--0ugb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9hb652kv99n.xn--0ugb', strict=True)

    def test_uts46_2953(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00061148砪≯ᢑ｡≯𝩚\U00093d14\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00061148砪≯ᢑ｡≯𝩚\U00093d14\u200c', strict=True)

    def test_uts46_2954(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00061148砪≯ᢑ｡≯𝩚\U00093d14\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00061148砪≯ᢑ｡≯𝩚\U00093d14\u200c', strict=True)

    def test_uts46_2955(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00061148砪≯ᢑ。≯𝩚\U00093d14\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00061148砪≯ᢑ。≯𝩚\U00093d14\u200c', strict=True)

    def test_uts46_2956(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00061148砪≯ᢑ。≯𝩚\U00093d14\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00061148砪≯ᢑ。≯𝩚\U00093d14\u200c', strict=True)

    def test_uts46_2957(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bbf561cf95e57y3e.xn--hdh0834o7mj6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bbf561cf95e57y3e.xn--hdh0834o7mj6b', strict=True)

    def test_uts46_2958(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bbf561cf95e57y3e.xn--0ugz6gc910ejro8c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bbf561cf95e57y3e.xn--0ugz6gc910ejro8c', strict=True)

    def test_uts46_2959(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴥ.𑄳㊸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴥ.𑄳㊸', strict=True)

    def test_uts46_2960(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴥ.𑄳43', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴥ.𑄳43', strict=True)

    def test_uts46_2961(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴥ.𑄳43', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴥ.𑄳43', strict=True)

    def test_uts46_2962(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tlj.xn--43-274o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tlj.xn--43-274o', strict=True)

    def test_uts46_2963(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴥ.𑄳㊸', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴥ.𑄳㊸', strict=True)

    def test_uts46_2964(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9nd.xn--43-274o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9nd.xn--43-274o', strict=True)

    def test_uts46_2965(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟎٣。Ⴒᡇࣲ𐹠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟎٣。Ⴒᡇࣲ𐹠', strict=True)

    def test_uts46_2966(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0٣。Ⴒᡇࣲ𐹠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0٣。Ⴒᡇࣲ𐹠', strict=True)

    def test_uts46_2967(self):
        self.assertRaises(idna.IDNAError, idna.decode, '0٣。ⴒᡇࣲ𐹠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '0٣。ⴒᡇࣲ𐹠', strict=True)

    def test_uts46_2968(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0-fqc.xn--10b369eivp359r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0-fqc.xn--10b369eivp359r', strict=True)

    def test_uts46_2969(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟎٣。ⴒᡇࣲ𐹠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟎٣。ⴒᡇࣲ𐹠', strict=True)

    def test_uts46_2970(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0-fqc.xn--10b180bnwgfy0z', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0-fqc.xn--10b180bnwgfy0z', strict=True)

    def test_uts46_2971(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00057aa8󠄉ﾠྷ.\U000787b0꥓', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00057aa8󠄉ﾠྷ.\U000787b0꥓', strict=True)

    def test_uts46_2972(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00057aa8󠄉ᅠྷ.\U000787b0꥓', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00057aa8󠄉ᅠྷ.\U000787b0꥓', strict=True)

    def test_uts46_2973(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--kgd72212e.xn--3j9au7544a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--kgd72212e.xn--3j9au7544a', strict=True)

    def test_uts46_2974(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--kgd36f9z57y.xn--3j9au7544a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--kgd36f9z57y.xn--3j9au7544a', strict=True)

    def test_uts46_2975(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--kgd7493jee34a.xn--3j9au7544a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--kgd7493jee34a.xn--3j9au7544a', strict=True)

    def test_uts46_2976(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ؘ.۳\u200c꥓', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ؘ.۳\u200c꥓', strict=True)

    def test_uts46_2977(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6fb.xn--gmb0524f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6fb.xn--gmb0524f', strict=True)

    def test_uts46_2978(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6fb.xn--gmb469jjf1h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6fb.xn--gmb469jjf1h', strict=True)

    def test_uts46_2979(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡌ．︒ᢑ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡌ．︒ᢑ', strict=True)

    def test_uts46_2980(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡌ.。ᢑ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡌ.。ᢑ', strict=True)

    def test_uts46_2981(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--c8e..xn--bbf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--c8e..xn--bbf', strict=True)

    def test_uts46_2982(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--c8e.xn--bbf9168i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--c8e.xn--bbf9168i', strict=True)

    def test_uts46_2983(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑋪ၳ｡\U0001ef67', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑋪ၳ｡\U0001ef67', strict=True)

    def test_uts46_2984(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑋪ၳ。\U0001ef67', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑋪ၳ。\U0001ef67', strict=True)

    def test_uts46_2985(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xld7443k.xn--4o7h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xld7443k.xn--4o7h', strict=True)

    def test_uts46_2986(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001edcf。ᠢ\U00093606', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001edcf。ᠢ\U00093606', strict=True)

    def test_uts46_2987(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hd7h.xn--46e66060j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hd7h.xn--46e66060j', strict=True)

    def test_uts46_2988(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑄳㴼．\u200c𐹡⃫\U0006bea6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑄳㴼．\u200c𐹡⃫\U0006bea6', strict=True)

    def test_uts46_2989(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑄳㴼.\u200c𐹡⃫\U0006bea6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑄳㴼.\u200c𐹡⃫\U0006bea6', strict=True)

    def test_uts46_2990(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--iym9428c.xn--e1g3464g08p3b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--iym9428c.xn--e1g3464g08p3b', strict=True)

    def test_uts46_2991(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--iym9428c.xn--0ug46a7218cllv0c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--iym9428c.xn--0ug46a7218cllv0c', strict=True)

    def test_uts46_2992(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00060edf𐹳𑈯｡̝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00060edf𐹳𑈯｡̝', strict=True)

    def test_uts46_2993(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00060edf𐹳𑈯。̝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00060edf𐹳𑈯。̝', strict=True)

    def test_uts46_2994(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ro0dw7dey96m.xn--eta', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ro0dw7dey96m.xn--eta', strict=True)

    def test_uts46_2995(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢊ뾜\U000e0c74𑚶。࢝𐹥', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢊ뾜\U000e0c74𑚶。࢝𐹥', strict=True)

    def test_uts46_2996(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᢊ뾜\U000e0c74𑚶。࢝𐹥', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᢊ뾜\U000e0c74𑚶。࢝𐹥', strict=True)

    def test_uts46_2997(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--39e4566fjv8bwmt6n.xn--myb6415k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--39e4566fjv8bwmt6n.xn--myb6415k', strict=True)

    def test_uts46_2998(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹥≠｡𐋲\U000e09e0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹥≠｡𐋲\U000e09e0\u200c', strict=True)

    def test_uts46_2999(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹥≠｡𐋲\U000e09e0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹥≠｡𐋲\U000e09e0\u200c', strict=True)

    def test_uts46_3000(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹥≠。𐋲\U000e09e0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹥≠。𐋲\U000e09e0\u200c', strict=True)

    def test_uts46_3001(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹥≠。𐋲\U000e09e0\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹥≠。𐋲\U000e09e0\u200c', strict=True)

    def test_uts46_3002(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch6704g.xn--m97cw2999c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch6704g.xn--m97cw2999c', strict=True)

    def test_uts46_3003(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch6704g.xn--0ug3840g51u4g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch6704g.xn--0ug3840g51u4g', strict=True)

    def test_uts46_3004(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᅟ\U00059be0्．\u200d꥓\U00010aa4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᅟ\U00059be0्．\u200d꥓\U00010aa4', strict=True)

    def test_uts46_3005(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᅟ\U00059be0्.\u200d꥓\U00010aa4', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᅟ\U00059be0्.\u200d꥓\U00010aa4', strict=True)

    def test_uts46_3006(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b91514e.xn--3j9al95p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b91514e.xn--3j9al95p', strict=True)

    def test_uts46_3007(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b91514e.xn--1ug6815co9wc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b91514e.xn--1ug6815co9wc', strict=True)

    def test_uts46_3008(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b542bb085j.xn--3j9al95p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b542bb085j.xn--3j9al95p', strict=True)

    def test_uts46_3009(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--n3b542bb085j.xn--1ug6815co9wc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--n3b542bb085j.xn--1ug6815co9wc', strict=True)

    def test_uts46_3010(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0008c2d4󠆎󠆗𑲕。≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0008c2d4󠆎󠆗𑲕。≮', strict=True)

    def test_uts46_3011(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0008c2d4󠆎󠆗𑲕。≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0008c2d4󠆎󠆗𑲕。≮', strict=True)

    def test_uts46_3012(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4m3dv4354a.xn--gdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4m3dv4354a.xn--gdh', strict=True)

    def test_uts46_3013(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆦.ࣣ暀≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆦.ࣣ暀≠', strict=True)

    def test_uts46_3014(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆦.ࣣ暀≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆦.ࣣ暀≠', strict=True)

    def test_uts46_3015(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--m0b461k3g2c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--m0b461k3g2c', strict=True)

    def test_uts46_3016(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐡤꯭｡ﴰ\U0009c585ᷰ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐡤꯭｡ﴰ\U0009c585ᷰ', strict=True)

    def test_uts46_3017(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐡤꯭。شم\U0009c585ᷰ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐡤꯭。شم\U0009c585ᷰ', strict=True)

    def test_uts46_3018(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--429ak76o.xn--zgb8a701kox37t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--429ak76o.xn--zgb8a701kox37t', strict=True)

    def test_uts46_3019(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝉃\u200d⒈｡Ⴌ\U0001ec53', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝉃\u200d⒈｡Ⴌ\U0001ec53', strict=True)

    def test_uts46_3020(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝉃\u200d1.。Ⴌ\U0001ec53', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝉃\u200d1.。Ⴌ\U0001ec53', strict=True)

    def test_uts46_3021(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝉃\u200d1.。ⴌ\U0001ec53', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝉃\u200d1.。ⴌ\U0001ec53', strict=True)

    def test_uts46_3022(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-px8q..xn--3kj4524l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-px8q..xn--3kj4524l', strict=True)

    def test_uts46_3023(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-tgn9827q..xn--3kj4524l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-tgn9827q..xn--3kj4524l', strict=True)

    def test_uts46_3024(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝉃\u200d⒈｡ⴌ\U0001ec53', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝉃\u200d⒈｡ⴌ\U0001ec53', strict=True)

    def test_uts46_3025(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tshz828m.xn--3kj4524l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tshz828m.xn--3kj4524l', strict=True)

    def test_uts46_3026(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug68oq348b.xn--3kj4524l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug68oq348b.xn--3kj4524l', strict=True)

    def test_uts46_3027(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-px8q..xn--knd8464v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-px8q..xn--knd8464v', strict=True)

    def test_uts46_3028(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-tgn9827q..xn--knd8464v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-tgn9827q..xn--knd8464v', strict=True)

    def test_uts46_3029(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tshz828m.xn--knd8464v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tshz828m.xn--knd8464v', strict=True)

    def test_uts46_3030(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug68oq348b.xn--knd8464v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug68oq348b.xn--knd8464v', strict=True)

    def test_uts46_3031(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e08d9੍𱫘𞤸.ς\U00075bde\U00108c14', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e08d9੍𱫘𞤸.ς\U00075bde\U00108c14', strict=True)

    def test_uts46_3032(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e08d9੍𱫘𞤖.Σ\U00075bde\U00108c14', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e08d9੍𱫘𞤖.Σ\U00075bde\U00108c14', strict=True)

    def test_uts46_3033(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e08d9੍𱫘𞤸.σ\U00075bde\U00108c14', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e08d9੍𱫘𞤸.σ\U00075bde\U00108c14', strict=True)

    def test_uts46_3034(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e08d9੍𱫘𞤖.σ\U00075bde\U00108c14', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e08d9੍𱫘𞤖.σ\U00075bde\U00108c14', strict=True)

    def test_uts46_3035(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ybc0236vjvxgt5q0g.xn--4xa82737giye6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ybc0236vjvxgt5q0g.xn--4xa82737giye6b', strict=True)

    def test_uts46_3036(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e08d9੍𱫘𞤖.ς\U00075bde\U00108c14', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e08d9੍𱫘𞤖.ς\U00075bde\U00108c14', strict=True)

    def test_uts46_3037(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ybc0236vjvxgt5q0g.xn--3xa03737giye6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ybc0236vjvxgt5q0g.xn--3xa03737giye6b', strict=True)

    def test_uts46_3038(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e08d9੍𱫘𞤸.Σ\U00075bde\U00108c14', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e08d9੍𱫘𞤸.Σ\U00075bde\U00108c14', strict=True)

    def test_uts46_3039(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߓ。\u200c𐫀\U0009eb71', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߓ。\u200c𐫀\U0009eb71', strict=True)

    def test_uts46_3040(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--usb.xn--pw9ci1099a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--usb.xn--pw9ci1099a', strict=True)

    def test_uts46_3041(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--usb.xn--0ug9553gm3v5d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--usb.xn--0ug9553gm3v5d', strict=True)

    def test_uts46_3042(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᰮ𞀝.֦ꡟ𞤕󠆖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᰮ𞀝.֦ꡟ𞤕󠆖', strict=True)

    def test_uts46_3043(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᰮ𞀝.֦ꡟ𞤷󠆖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᰮ𞀝.֦ꡟ𞤷󠆖', strict=True)

    def test_uts46_3044(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--q1f4493q.xn--xcb8244fifvj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--q1f4493q.xn--xcb8244fifvj', strict=True)

    def test_uts46_3045(self):
        self.assertRaises(idna.IDNAError, idna.decode, '䂹\U000fe585𐋦．\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '䂹\U000fe585𐋦．\u200d', strict=True)

    def test_uts46_3046(self):
        self.assertRaises(idna.IDNAError, idna.decode, '䂹\U000fe585𐋦.\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '䂹\U000fe585𐋦.\u200d', strict=True)

    def test_uts46_3047(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0on3543c5981i.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0on3543c5981i.', strict=True)

    def test_uts46_3048(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0on3543c5981i.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0on3543c5981i.xn--1ug', strict=True)

    def test_uts46_3049(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꧀\u200c𐹲\u200c｡ݧ🄉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꧀\u200c𐹲\u200c｡ݧ🄉', strict=True)

    def test_uts46_3050(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꧀\u200c𐹲\u200c。ݧ8,', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꧀\u200c𐹲\u200c。ݧ8,', strict=True)

    def test_uts46_3051(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7m9an32q.xn--8,-qle', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7m9an32q.xn--8,-qle', strict=True)

    def test_uts46_3052(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0uga8686hdgvd.xn--8,-qle', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0uga8686hdgvd.xn--8,-qle', strict=True)

    def test_uts46_3053(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7m9an32q.xn--rpb6081w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7m9an32q.xn--rpb6081w', strict=True)

    def test_uts46_3054(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0uga8686hdgvd.xn--rpb6081w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0uga8686hdgvd.xn--rpb6081w', strict=True)

    def test_uts46_3055(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒｡Ⴃ≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒｡Ⴃ≯', strict=True)

    def test_uts46_3056(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒｡Ⴃ≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒｡Ⴃ≯', strict=True)

    def test_uts46_3057(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。。Ⴃ≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。。Ⴃ≯', strict=True)

    def test_uts46_3058(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。。Ⴃ≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。。Ⴃ≯', strict=True)

    def test_uts46_3059(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。。ⴃ≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。。ⴃ≯', strict=True)

    def test_uts46_3060(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。。ⴃ≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。。ⴃ≯', strict=True)

    def test_uts46_3061(self):
        self.assertRaises(idna.IDNAError, idna.decode, '..xn--hdh782b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '..xn--hdh782b', strict=True)

    def test_uts46_3062(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒｡ⴃ≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒｡ⴃ≯', strict=True)

    def test_uts46_3063(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒｡ⴃ≯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒｡ⴃ≯', strict=True)

    def test_uts46_3064(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y86c.xn--hdh782b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y86c.xn--hdh782b', strict=True)

    def test_uts46_3065(self):
        self.assertRaises(idna.IDNAError, idna.decode, '..xn--bnd622g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '..xn--bnd622g', strict=True)

    def test_uts46_3066(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y86c.xn--bnd622g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y86c.xn--bnd622g', strict=True)

    def test_uts46_3067(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹮｡\U000e08bc\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹮｡\U000e08bc\u200d', strict=True)

    def test_uts46_3068(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹮。\U000e08bc\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹮。\U000e08bc\u200d', strict=True)

    def test_uts46_3069(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mo0d.xn--wy46e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mo0d.xn--wy46e', strict=True)

    def test_uts46_3070(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mo0d.xn--1ug18431l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mo0d.xn--1ug18431l', strict=True)

    def test_uts46_3071(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴞ𐹨｡︒ݽ\u200dႯ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴞ𐹨｡︒ݽ\u200dႯ', strict=True)

    def test_uts46_3072(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴞ𐹨。。ݽ\u200dႯ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴞ𐹨。。ݽ\u200dႯ', strict=True)

    def test_uts46_3073(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴞ𐹨。。ݽ\u200dⴏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴞ𐹨。。ݽ\u200dⴏ', strict=True)

    def test_uts46_3074(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴞ𐹨。。ݽ\u200dⴏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴞ𐹨。。ݽ\u200dⴏ', strict=True)

    def test_uts46_3075(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mlju223e..xn--eqb053q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mlju223e..xn--eqb053q', strict=True)

    def test_uts46_3076(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mlju223e..xn--eqb096jpgj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mlju223e..xn--eqb096jpgj', strict=True)

    def test_uts46_3077(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴞ𐹨｡︒ݽ\u200dⴏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴞ𐹨｡︒ݽ\u200dⴏ', strict=True)

    def test_uts46_3078(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴞ𐹨｡︒ݽ\u200dⴏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴞ𐹨｡︒ݽ\u200dⴏ', strict=True)

    def test_uts46_3079(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mlju223e.xn--eqb053qjk7l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mlju223e.xn--eqb053qjk7l', strict=True)

    def test_uts46_3080(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mlju223e.xn--eqb096jpgj9y7r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mlju223e.xn--eqb096jpgj9y7r', strict=True)

    def test_uts46_3081(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd0990k..xn--eqb053q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd0990k..xn--eqb053q', strict=True)

    def test_uts46_3082(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd0990k..xn--eqb096jpgj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd0990k..xn--eqb096jpgj', strict=True)

    def test_uts46_3083(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd0990k..xn--eqb228b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd0990k..xn--eqb228b', strict=True)

    def test_uts46_3084(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd0990k..xn--eqb228bgzm', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd0990k..xn--eqb228bgzm', strict=True)

    def test_uts46_3085(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd0990k.xn--eqb053qjk7l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd0990k.xn--eqb053qjk7l', strict=True)

    def test_uts46_3086(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd0990k.xn--eqb096jpgj9y7r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd0990k.xn--eqb096jpgj9y7r', strict=True)

    def test_uts46_3087(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd0990k.xn--eqb228b583r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd0990k.xn--eqb228b583r', strict=True)

    def test_uts46_3088(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd0990k.xn--eqb228bgzmvp0t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd0990k.xn--eqb228bgzmvp0t', strict=True)

    def test_uts46_3089(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႦ𝟹。-⃒-ߑ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႦ𝟹。-⃒-ߑ', strict=True)

    def test_uts46_3090(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႦ3。-⃒-ߑ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႦ3。-⃒-ߑ', strict=True)

    def test_uts46_3091(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴆ3。-⃒-ߑ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴆ3。-⃒-ߑ', strict=True)

    def test_uts46_3092(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-lvs.xn-----vue617w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-lvs.xn-----vue617w', strict=True)

    def test_uts46_3093(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-rgnv99c.xn-----vue617w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-rgnv99c.xn-----vue617w', strict=True)

    def test_uts46_3094(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴆ𝟹。-⃒-ߑ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴆ𝟹。-⃒-ߑ', strict=True)

    def test_uts46_3095(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-i0g.xn-----vue617w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-i0g.xn-----vue617w', strict=True)

    def test_uts46_3096(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-i0g939i.xn-----vue617w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-i0g939i.xn-----vue617w', strict=True)

    def test_uts46_3097(self):
        self.assertRaises(idna.IDNAError, idna.decode, '箃Ⴡ-\U000e005d｡≠-🤖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '箃Ⴡ-\U000e005d｡≠-🤖', strict=True)

    def test_uts46_3098(self):
        self.assertRaises(idna.IDNAError, idna.decode, '箃Ⴡ-\U000e005d｡≠-🤖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '箃Ⴡ-\U000e005d｡≠-🤖', strict=True)

    def test_uts46_3099(self):
        self.assertRaises(idna.IDNAError, idna.decode, '箃Ⴡ-\U000e005d。≠-🤖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '箃Ⴡ-\U000e005d。≠-🤖', strict=True)

    def test_uts46_3100(self):
        self.assertRaises(idna.IDNAError, idna.decode, '箃Ⴡ-\U000e005d。≠-🤖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '箃Ⴡ-\U000e005d。≠-🤖', strict=True)

    def test_uts46_3101(self):
        self.assertRaises(idna.IDNAError, idna.decode, '箃ⴡ-\U000e005d。≠-🤖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '箃ⴡ-\U000e005d。≠-🤖', strict=True)

    def test_uts46_3102(self):
        self.assertRaises(idna.IDNAError, idna.decode, '箃ⴡ-\U000e005d。≠-🤖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '箃ⴡ-\U000e005d。≠-🤖', strict=True)

    def test_uts46_3103(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----4wsr321ay823p.xn----tfot873s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----4wsr321ay823p.xn----tfot873s', strict=True)

    def test_uts46_3104(self):
        self.assertRaises(idna.IDNAError, idna.decode, '箃ⴡ-\U000e005d｡≠-🤖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '箃ⴡ-\U000e005d｡≠-🤖', strict=True)

    def test_uts46_3105(self):
        self.assertRaises(idna.IDNAError, idna.decode, '箃ⴡ-\U000e005d｡≠-🤖', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '箃ⴡ-\U000e005d｡≠-🤖', strict=True)

    def test_uts46_3106(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----11g3013fy8x5m.xn----tfot873s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----11g3013fy8x5m.xn----tfot873s', strict=True)

    def test_uts46_3107(self):
        self.assertEqual(idna.decode('ߥ.ڵ', uts46=True, strict=True), 'ߥ.ڵ')
        self.assertEqual(idna.encode('ߥ.ڵ', uts46=True, strict=True), b'xn--dtb.xn--okb')

    def test_uts46_3108(self):
        self.assertEqual(idna.decode('xn--dtb.xn--okb', uts46=True, strict=True), 'ߥ.ڵ')
        self.assertEqual(idna.encode('xn--dtb.xn--okb', uts46=True, strict=True), b'xn--dtb.xn--okb')

    def test_uts46_3109(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\u200d.𞤿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\u200d.𞤿', strict=True)

    def test_uts46_3110(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\u200d.𞤝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\u200d.𞤝', strict=True)

    def test_uts46_3111(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--3e6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--3e6h', strict=True)

    def test_uts46_3112(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugc.xn--3e6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugc.xn--3e6h', strict=True)

    def test_uts46_3113(self):
        self.assertEqual(idna.decode('xn--3e6h', uts46=True, strict=True), '𞤿')
        self.assertEqual(idna.encode('xn--3e6h', uts46=True, strict=True), b'xn--3e6h')

    def test_uts46_3114(self):
        self.assertEqual(idna.decode('𞤿', uts46=True, strict=True), '𞤿')
        self.assertEqual(idna.encode('𞤿', uts46=True, strict=True), b'xn--3e6h')

    def test_uts46_3115(self):
        self.assertEqual(idna.decode('𞤝', uts46=True, strict=True), '𞤿')
        self.assertEqual(idna.encode('𞤝', uts46=True, strict=True), b'xn--3e6h')

    def test_uts46_3116(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🜑𐹧ع.ς𑍍蜹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🜑𐹧ع.ς𑍍蜹', strict=True)

    def test_uts46_3117(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🜑𐹧ع.Σ𑍍蜹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🜑𐹧ع.Σ𑍍蜹', strict=True)

    def test_uts46_3118(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🜑𐹧ع.σ𑍍蜹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🜑𐹧ع.σ𑍍蜹', strict=True)

    def test_uts46_3119(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4gb3736kk4zf.xn--4xa2248dy27d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4gb3736kk4zf.xn--4xa2248dy27d', strict=True)

    def test_uts46_3120(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4gb3736kk4zf.xn--3xa4248dy27d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4gb3736kk4zf.xn--3xa4248dy27d', strict=True)

    def test_uts46_3121(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000ab810ス\U001067e4٩．\U000da0df', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000ab810ス\U001067e4٩．\U000da0df', strict=True)

    def test_uts46_3122(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000ab810ス\U001067e4٩.\U000da0df', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000ab810ス\U001067e4٩.\U000da0df', strict=True)

    def test_uts46_3123(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--iib777sp230oo708a.xn--7824e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--iib777sp230oo708a.xn--7824e', strict=True)

    def test_uts46_3124(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪣\U0009585d．֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪣\U0009585d．֚?ۂ', strict=True)

    def test_uts46_3125(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪣\U0009585d．֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪣\U0009585d．֚?ۂ', strict=True)

    def test_uts46_3126(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪣\U0009585d.֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪣\U0009585d.֚?ۂ', strict=True)

    def test_uts46_3127(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪣\U0009585d.֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪣\U0009585d.֚?ۂ', strict=True)

    def test_uts46_3128(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8c3hu7971a.xn--?-wec30g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8c3hu7971a.xn--?-wec30g', strict=True)

    def test_uts46_3129(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8c3hu7971a.֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8c3hu7971a.֚?ۂ', strict=True)

    def test_uts46_3130(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8c3hu7971a.֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8c3hu7971a.֚?ۂ', strict=True)

    def test_uts46_3131(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'XN--8C3HU7971A.֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'XN--8C3HU7971A.֚?ۂ', strict=True)

    def test_uts46_3132(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'XN--8C3HU7971A.֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'XN--8C3HU7971A.֚?ۂ', strict=True)

    def test_uts46_3133(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--8c3hu7971a.֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--8c3hu7971a.֚?ۂ', strict=True)

    def test_uts46_3134(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--8c3hu7971a.֚?ۂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--8c3hu7971a.֚?ۂ', strict=True)

    def test_uts46_3135(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٠\U000aa4f5\u200c。ݗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٠\U000aa4f5\u200c。ݗ', strict=True)

    def test_uts46_3136(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8hb82030l.xn--bpb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8hb82030l.xn--bpb', strict=True)

    def test_uts46_3137(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8hb852ke991q.xn--bpb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8hb852ke991q.xn--bpb', strict=True)

    def test_uts46_3138(self):
        self.assertRaises(idna.IDNAError, idna.decode, '်\u200d\u200c。-\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '်\u200d\u200c。-\u200c', strict=True)

    def test_uts46_3139(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bkd.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bkd.-', strict=True)

    def test_uts46_3140(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bkd412fca.xn----sgn', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bkd412fca.xn----sgn', strict=True)

    def test_uts46_3141(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒｡᭄ᡉ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒｡᭄ᡉ', strict=True)

    def test_uts46_3142(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。。᭄ᡉ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。。᭄ᡉ', strict=True)

    def test_uts46_3143(self):
        self.assertRaises(idna.IDNAError, idna.decode, '..xn--87e93m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '..xn--87e93m', strict=True)

    def test_uts46_3144(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y86c.xn--87e93m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y86c.xn--87e93m', strict=True)

    def test_uts46_3145(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݘß。ጫᢊݨ𝟐', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݘß。ጫᢊݨ𝟐', strict=True)

    def test_uts46_3146(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݘß。ጫᢊݨ2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݘß。ጫᢊݨ2', strict=True)

    def test_uts46_3147(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݘSS。ጫᢊݨ2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݘSS。ጫᢊݨ2', strict=True)

    def test_uts46_3148(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݘss。ጫᢊݨ2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݘss。ጫᢊݨ2', strict=True)

    def test_uts46_3149(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-gke.xn--2-b5c641gfmf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-gke.xn--2-b5c641gfmf', strict=True)

    def test_uts46_3150(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca724a.xn--2-b5c641gfmf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca724a.xn--2-b5c641gfmf', strict=True)

    def test_uts46_3151(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݘSS。ጫᢊݨ𝟐', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݘSS。ጫᢊݨ𝟐', strict=True)

    def test_uts46_3152(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݘss。ጫᢊݨ𝟐', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݘss。ጫᢊݨ𝟐', strict=True)

    def test_uts46_3153(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݘSs。ጫᢊݨ2', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݘSs。ጫᢊݨ2', strict=True)

    def test_uts46_3154(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݘSs。ጫᢊݨ𝟐', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݘSs。ጫᢊݨ𝟐', strict=True)

    def test_uts46_3155(self):
        self.assertRaises(idna.IDNAError, idna.decode, '߃\U0001ed87ᚲ.ं͓𝟚্', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '߃\U0001ed87ᚲ.ं͓𝟚্', strict=True)

    def test_uts46_3156(self):
        self.assertRaises(idna.IDNAError, idna.decode, '߃\U0001ed87ᚲ.ं͓2্', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '߃\U0001ed87ᚲ.ं͓2্', strict=True)

    def test_uts46_3157(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--esb067enh07a.xn--2-lgb874bjxa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--esb067enh07a.xn--2-lgb874bjxa', strict=True)

    def test_uts46_3158(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-᮫︒\u200d.\U00052d88\U00065e53', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-᮫︒\u200d.\U00052d88\U00065e53', strict=True)

    def test_uts46_3159(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-᮫。\u200d.\U00052d88\U00065e53', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-᮫。\u200d.\U00052d88\U00065e53', strict=True)

    def test_uts46_3160(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----qml..xn--x50zy803a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----qml..xn--x50zy803a', strict=True)

    def test_uts46_3161(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----qml.xn--1ug.xn--x50zy803a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----qml.xn--1ug.xn--x50zy803a', strict=True)

    def test_uts46_3162(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----qml1407i.xn--x50zy803a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----qml1407i.xn--x50zy803a', strict=True)

    def test_uts46_3163(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----qmlv7tw180a.xn--x50zy803a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----qmlv7tw180a.xn--x50zy803a', strict=True)

    def test_uts46_3164(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e09ae.≯𞀆', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e09ae.≯𞀆', strict=True)

    def test_uts46_3165(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e09ae.≯𞀆', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e09ae.≯𞀆', strict=True)

    def test_uts46_3166(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--t546e.xn--hdh5166o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--t546e.xn--hdh5166o', strict=True)

    def test_uts46_3167(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𑄳\U000e0297𐹩。\U0001ebb1', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𑄳\U000e0297𐹩。\U0001ebb1', strict=True)

    def test_uts46_3168(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----p26i72em2894c.xn--zw6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----p26i72em2894c.xn--zw6h', strict=True)

    def test_uts46_3169(self):
        self.assertEqual(idna.decode('ڹ．ᡳᅟ', uts46=True, strict=True), 'ڹ.ᡳ')
        self.assertEqual(idna.encode('ڹ．ᡳᅟ', uts46=True, strict=True), b'xn--skb.xn--g9e')

    def test_uts46_3170(self):
        self.assertEqual(idna.decode('ڹ.ᡳᅟ', uts46=True, strict=True), 'ڹ.ᡳ')
        self.assertEqual(idna.encode('ڹ.ᡳᅟ', uts46=True, strict=True), b'xn--skb.xn--g9e')

    def test_uts46_3171(self):
        self.assertEqual(idna.decode('xn--skb.xn--g9e', uts46=True, strict=True), 'ڹ.ᡳ')
        self.assertEqual(idna.encode('xn--skb.xn--g9e', uts46=True, strict=True), b'xn--skb.xn--g9e')

    def test_uts46_3172(self):
        self.assertEqual(idna.decode('ڹ.ᡳ', uts46=True, strict=True), 'ڹ.ᡳ')
        self.assertEqual(idna.encode('ڹ.ᡳ', uts46=True, strict=True), b'xn--skb.xn--g9e')

    def test_uts46_3173(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--skb.xn--osd737a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--skb.xn--osd737a', strict=True)

    def test_uts46_3174(self):
        self.assertRaises(idna.IDNAError, idna.decode, '㨛𘱎.︒𝟕ഁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '㨛𘱎.︒𝟕ഁ', strict=True)

    def test_uts46_3175(self):
        self.assertRaises(idna.IDNAError, idna.decode, '㨛𘱎.。7ഁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '㨛𘱎.。7ഁ', strict=True)

    def test_uts46_3176(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mbm8237g..xn--7-7hf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mbm8237g..xn--7-7hf', strict=True)

    def test_uts46_3177(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mbm8237g.xn--7-7hf1526p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mbm8237g.xn--7-7hf1526p', strict=True)

    def test_uts46_3178(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u06dd\U0003bc67-｡\U0001edc1\u2064𞤣≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u06dd\U0003bc67-｡\U0001edc1\u2064𞤣≮', strict=True)

    def test_uts46_3179(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u06dd\U0003bc67-｡\U0001edc1\u2064𞤣≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u06dd\U0003bc67-｡\U0001edc1\u2064𞤣≮', strict=True)

    def test_uts46_3180(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u06dd\U0003bc67-。\U0001edc1\u2064𞤣≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u06dd\U0003bc67-。\U0001edc1\u2064𞤣≮', strict=True)

    def test_uts46_3181(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u06dd\U0003bc67-。\U0001edc1\u2064𞤣≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u06dd\U0003bc67-。\U0001edc1\u2064𞤣≮', strict=True)

    def test_uts46_3182(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u06dd\U0003bc67-。\U0001edc1\u2064𞤁≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u06dd\U0003bc67-。\U0001edc1\u2064𞤁≮', strict=True)

    def test_uts46_3183(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u06dd\U0003bc67-。\U0001edc1\u2064𞤁≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u06dd\U0003bc67-。\U0001edc1\u2064𞤁≮', strict=True)

    def test_uts46_3184(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----dxc06304e.xn--gdh5020pk5c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----dxc06304e.xn--gdh5020pk5c', strict=True)

    def test_uts46_3185(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u06dd\U0003bc67-｡\U0001edc1\u2064𞤁≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u06dd\U0003bc67-｡\U0001edc1\u2064𞤁≮', strict=True)

    def test_uts46_3186(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u06dd\U0003bc67-｡\U0001edc1\u2064𞤁≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u06dd\U0003bc67-｡\U0001edc1\u2064𞤁≮', strict=True)

    def test_uts46_3187(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß\u200c꫶ᢥ．⊶ჁႶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß\u200c꫶ᢥ．⊶ჁႶ', strict=True)

    def test_uts46_3188(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß\u200c꫶ᢥ.⊶ჁႶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß\u200c꫶ᢥ.⊶ჁႶ', strict=True)

    def test_uts46_3189(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß\u200c꫶ᢥ.⊶ⴡⴖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß\u200c꫶ᢥ.⊶ⴡⴖ', strict=True)

    def test_uts46_3190(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS\u200c꫶ᢥ.⊶ჁႶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS\u200c꫶ᢥ.⊶ჁႶ', strict=True)

    def test_uts46_3191(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss\u200c꫶ᢥ.⊶ⴡⴖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss\u200c꫶ᢥ.⊶ⴡⴖ', strict=True)

    def test_uts46_3192(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss\u200c꫶ᢥ.⊶Ⴡⴖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss\u200c꫶ᢥ.⊶Ⴡⴖ', strict=True)

    def test_uts46_3193(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-4epx629f.xn--ifh802b6a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-4epx629f.xn--ifh802b6a', strict=True)

    def test_uts46_3194(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss꫶ᢥ.⊶ⴡⴖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss꫶ᢥ.⊶ⴡⴖ', strict=True)

    def test_uts46_3195(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS꫶ᢥ.⊶ჁႶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS꫶ᢥ.⊶ჁႶ', strict=True)

    def test_uts46_3196(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss꫶ᢥ.⊶Ⴡⴖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss꫶ᢥ.⊶Ⴡⴖ', strict=True)

    def test_uts46_3197(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-4ep585bkm5p.xn--ifh802b6a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-4ep585bkm5p.xn--ifh802b6a', strict=True)

    def test_uts46_3198(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca682johfi89m.xn--ifh802b6a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca682johfi89m.xn--ifh802b6a', strict=True)

    def test_uts46_3199(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß\u200c꫶ᢥ．⊶ⴡⴖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß\u200c꫶ᢥ．⊶ⴡⴖ', strict=True)

    def test_uts46_3200(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS\u200c꫶ᢥ．⊶ჁႶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS\u200c꫶ᢥ．⊶ჁႶ', strict=True)

    def test_uts46_3201(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss\u200c꫶ᢥ．⊶ⴡⴖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss\u200c꫶ᢥ．⊶ⴡⴖ', strict=True)

    def test_uts46_3202(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss\u200c꫶ᢥ．⊶Ⴡⴖ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss\u200c꫶ᢥ．⊶Ⴡⴖ', strict=True)

    def test_uts46_3203(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-4epx629f.xn--5nd703gyrh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-4epx629f.xn--5nd703gyrh', strict=True)

    def test_uts46_3204(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-4ep585bkm5p.xn--5nd703gyrh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-4ep585bkm5p.xn--5nd703gyrh', strict=True)

    def test_uts46_3205(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-4epx629f.xn--undv409k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-4epx629f.xn--undv409k', strict=True)

    def test_uts46_3206(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-4ep585bkm5p.xn--undv409k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-4ep585bkm5p.xn--undv409k', strict=True)

    def test_uts46_3207(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca682johfi89m.xn--undv409k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca682johfi89m.xn--undv409k', strict=True)

    def test_uts46_3208(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。ς\U000e0049', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。ς\U000e0049', strict=True)

    def test_uts46_3209(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。Σ\U000e0049', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。Σ\U000e0049', strict=True)

    def test_uts46_3210(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。σ\U000e0049', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。σ\U000e0049', strict=True)

    def test_uts46_3211(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--4xa24344p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--4xa24344p', strict=True)

    def test_uts46_3212(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.xn--4xa24344p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.xn--4xa24344p', strict=True)

    def test_uts46_3213(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.xn--3xa44344p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.xn--3xa44344p', strict=True)

    def test_uts46_3214(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ed51ß.ݑ\u200d𞤛-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ed51ß.ݑ\u200d𞤛-', strict=True)

    def test_uts46_3215(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ed51ß.ݑ\u200d𞤽-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ed51ß.ݑ\u200d𞤽-', strict=True)

    def test_uts46_3216(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ed51SS.ݑ\u200d𞤛-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ed51SS.ݑ\u200d𞤛-', strict=True)

    def test_uts46_3217(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ed51ss.ݑ\u200d𞤽-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ed51ss.ݑ\u200d𞤽-', strict=True)

    def test_uts46_3218(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ed51Ss.ݑ\u200d𞤽-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ed51Ss.ݑ\u200d𞤽-', strict=True)

    def test_uts46_3219(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-2722a.xn----z3c03218a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-2722a.xn----z3c03218a', strict=True)

    def test_uts46_3220(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-2722a.xn----z3c011q9513b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-2722a.xn----z3c011q9513b', strict=True)

    def test_uts46_3221(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca5423w.xn----z3c011q9513b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca5423w.xn----z3c011q9513b', strict=True)

    def test_uts46_3222(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ed51ss.ݑ\u200d𞤛-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ed51ss.ݑ\u200d𞤛-', strict=True)

    def test_uts46_3223(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ed51Ss.ݑ\u200d𞤛-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ed51Ss.ݑ\u200d𞤛-', strict=True)

    def test_uts46_3224(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑘽\u200d𞤧．𐹧\U000e19aa-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑘽\u200d𞤧．𐹧\U000e19aa-', strict=True)

    def test_uts46_3225(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑘽\u200d𞤧.𐹧\U000e19aa-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑘽\u200d𞤧.𐹧\U000e19aa-', strict=True)

    def test_uts46_3226(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑘽\u200d𞤅.𐹧\U000e19aa-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑘽\u200d𞤅.𐹧\U000e19aa-', strict=True)

    def test_uts46_3227(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--qb2ds317a.xn----k26iq1483f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--qb2ds317a.xn----k26iq1483f', strict=True)

    def test_uts46_3228(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ugz808gdimf.xn----k26iq1483f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ugz808gdimf.xn----k26iq1483f', strict=True)

    def test_uts46_3229(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑘽\u200d𞤅．𐹧\U000e19aa-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑘽\u200d𞤅．𐹧\U000e19aa-', strict=True)

    def test_uts46_3230(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒒\U000a8619\U000b3ce0𑓀.-\U000de84a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒒\U000a8619\U000b3ce0𑓀.-\U000de84a', strict=True)

    def test_uts46_3231(self):
        self.assertRaises(idna.IDNAError, idna.decode, '11.\U000a8619\U000b3ce0𑓀.-\U000de84a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '11.\U000a8619\U000b3ce0𑓀.-\U000de84a', strict=True)

    def test_uts46_3232(self):
        self.assertRaises(idna.IDNAError, idna.decode, '11.xn--uz1d59632bxujd.xn----x310m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '11.xn--uz1d59632bxujd.xn----x310m', strict=True)

    def test_uts46_3233(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3shy698frsu9dt1me.xn----x310m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3shy698frsu9dt1me.xn----x310m', strict=True)

    def test_uts46_3234(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-｡\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-｡\u200d', strict=True)

    def test_uts46_3235(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-。\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-。\u200d', strict=True)

    def test_uts46_3236(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.', strict=True)

    def test_uts46_3237(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--1ug', strict=True)

    def test_uts46_3238(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ．ς¹-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ．ς¹-?', strict=True)

    def test_uts46_3239(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ．ς¹-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ．ς¹-?', strict=True)

    def test_uts46_3240(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ.ς1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ.ς1-?', strict=True)

    def test_uts46_3241(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ.ς1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ.ς1-?', strict=True)

    def test_uts46_3242(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ.Σ1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ.Σ1-?', strict=True)

    def test_uts46_3243(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ.Σ1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ.Σ1-?', strict=True)

    def test_uts46_3244(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ.σ1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ.σ1-?', strict=True)

    def test_uts46_3245(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ.σ1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ.σ1-?', strict=True)

    def test_uts46_3246(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--88e732c.xn--1-?-pzc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--88e732c.xn--1-?-pzc', strict=True)

    def test_uts46_3247(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--88e732c.xn--1-?-lzc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--88e732c.xn--1-?-lzc', strict=True)

    def test_uts46_3248(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ．Σ¹-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ．Σ¹-?', strict=True)

    def test_uts46_3249(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ．Σ¹-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ．Σ¹-?', strict=True)

    def test_uts46_3250(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ．σ¹-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ．σ¹-?', strict=True)

    def test_uts46_3251(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮ᡬ．σ¹-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮ᡬ．σ¹-?', strict=True)

    def test_uts46_3252(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--88e732c.σ1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--88e732c.σ1-?', strict=True)

    def test_uts46_3253(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'XN--88E732C.Σ1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'XN--88E732C.Σ1-?', strict=True)

    def test_uts46_3254(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--88e732c.ς1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--88e732c.ς1-?', strict=True)

    def test_uts46_3255(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--88e732c.ς1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--88e732c.ς1-?', strict=True)

    def test_uts46_3256(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--88e732c.σ1-?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--88e732c.σ1-?', strict=True)

    def test_uts46_3257(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ቬ\U0009483c\U000415f6｡𐨬𝟠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ቬ\U0009483c\U000415f6｡𐨬𝟠', strict=True)

    def test_uts46_3258(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ቬ\U0009483c\U000415f6。𐨬8', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ቬ\U0009483c\U000415f6。𐨬8', strict=True)

    def test_uts46_3259(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--d0d41273c887z.xn--8-ob5i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--d0d41273c887z.xn--8-ob5i', strict=True)

    def test_uts46_3260(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010c72。蔫ݦ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010c72。蔫ݦ', strict=True)

    def test_uts46_3261(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--389c.xn--qpb7055d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--389c.xn--qpb7055d', strict=True)

    def test_uts46_3262(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00092ca7₃｡ꡚ𛇑󠄳ه', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00092ca7₃｡ꡚ𛇑󠄳ه', strict=True)

    def test_uts46_3263(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00092ca73。ꡚ𛇑󠄳ه', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00092ca73。ꡚ𛇑󠄳ه', strict=True)

    def test_uts46_3264(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-ep59g.xn--jhb5904fcp0h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-ep59g.xn--jhb5904fcp0h', strict=True)

    def test_uts46_3265(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蓸ق≠.ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蓸ق≠.ß', strict=True)

    def test_uts46_3266(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蓸ق≠.ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蓸ق≠.ß', strict=True)

    def test_uts46_3267(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蓸ق≠.SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蓸ق≠.SS', strict=True)

    def test_uts46_3268(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蓸ق≠.SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蓸ق≠.SS', strict=True)

    def test_uts46_3269(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蓸ق≠.ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蓸ق≠.ss', strict=True)

    def test_uts46_3270(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蓸ق≠.ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蓸ق≠.ss', strict=True)

    def test_uts46_3271(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蓸ق≠.Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蓸ق≠.Ss', strict=True)

    def test_uts46_3272(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蓸ق≠.Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蓸ق≠.Ss', strict=True)

    def test_uts46_3273(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ehb015lnt1e.ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ehb015lnt1e.ss', strict=True)

    def test_uts46_3274(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ehb015lnt1e.xn--zca', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ehb015lnt1e.xn--zca', strict=True)

    def test_uts46_3275(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࡎٺී⒊.𐹹\U0001ec69\U000e00ea\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࡎٺී⒊.𐹹\U0001ec69\U000e00ea\u200c', strict=True)

    def test_uts46_3276(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࡎٺී3..𐹹\U0001ec69\U000e00ea\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࡎٺී3..𐹹\U0001ec69\U000e00ea\u200c', strict=True)

    def test_uts46_3277(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-prc71ls9j..xn--xo0dw109an237f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-prc71ls9j..xn--xo0dw109an237f', strict=True)

    def test_uts46_3278(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-prc71ls9j..xn--0ug3205g7eyf3c96h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-prc71ls9j..xn--0ug3205g7eyf3c96h', strict=True)

    def test_uts46_3279(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zib94gfziuq1a.xn--xo0dw109an237f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zib94gfziuq1a.xn--xo0dw109an237f', strict=True)

    def test_uts46_3280(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zib94gfziuq1a.xn--0ug3205g7eyf3c96h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zib94gfziuq1a.xn--0ug3205g7eyf3c96h', strict=True)

    def test_uts46_3281(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς\u200d-.Ⴣ𦟙', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς\u200d-.Ⴣ𦟙', strict=True)

    def test_uts46_3282(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς\u200d-.ⴣ𦟙', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς\u200d-.ⴣ𦟙', strict=True)

    def test_uts46_3283(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ\u200d-.Ⴣ𦟙', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ\u200d-.Ⴣ𦟙', strict=True)

    def test_uts46_3284(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ\u200d-.ⴣ𦟙', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ\u200d-.ⴣ𦟙', strict=True)

    def test_uts46_3285(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----zmb.xn--rlj2573p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----zmb.xn--rlj2573p', strict=True)

    def test_uts46_3286(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----zmb048s.xn--rlj2573p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----zmb048s.xn--rlj2573p', strict=True)

    def test_uts46_3287(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----xmb348s.xn--rlj2573p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----xmb348s.xn--rlj2573p', strict=True)

    def test_uts46_3288(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----zmb.xn--7nd64871a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----zmb.xn--7nd64871a', strict=True)

    def test_uts46_3289(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----zmb048s.xn--7nd64871a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----zmb048s.xn--7nd64871a', strict=True)

    def test_uts46_3290(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----xmb348s.xn--7nd64871a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----xmb348s.xn--7nd64871a', strict=True)

    def test_uts46_3291(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠。🞳𝟲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠。🞳𝟲', strict=True)

    def test_uts46_3292(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠。🞳𝟲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠。🞳𝟲', strict=True)

    def test_uts46_3293(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠。🞳6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠。🞳6', strict=True)

    def test_uts46_3294(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠。🞳6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠。🞳6', strict=True)

    def test_uts46_3295(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch.xn--6-dl4s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch.xn--6-dl4s', strict=True)

    def test_uts46_3296(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠.🞳6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠.🞳6', strict=True)

    def test_uts46_3297(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠.🞳6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠.🞳6', strict=True)

    def test_uts46_3298(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000c5b3d.蠔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000c5b3d.蠔', strict=True)

    def test_uts46_3299(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--g747d.xn--xl2a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--g747d.xn--xl2a', strict=True)

    def test_uts46_3300(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣦ\u200d．뼽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣦ\u200d．뼽', strict=True)

    def test_uts46_3301(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣦ\u200d．뼽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣦ\u200d．뼽', strict=True)

    def test_uts46_3302(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣦ\u200d.뼽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣦ\u200d.뼽', strict=True)

    def test_uts46_3303(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣦ\u200d.뼽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣦ\u200d.뼽', strict=True)

    def test_uts46_3304(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--p0b.xn--e43b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--p0b.xn--e43b', strict=True)

    def test_uts46_3305(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--p0b869i.xn--e43b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--p0b869i.xn--e43b', strict=True)

    def test_uts46_3306(self):
        self.assertRaises(idna.IDNAError, idna.decode, '₇்\U001030b7ے。👖ٵ-\U0001ea91', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '₇்\U001030b7ے。👖ٵ-\U0001ea91', strict=True)

    def test_uts46_3307(self):
        self.assertRaises(idna.IDNAError, idna.decode, '7்\U001030b7ے。👖اٴ-\U0001ea91', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '7்\U001030b7ے。👖اٴ-\U0001ea91', strict=True)

    def test_uts46_3308(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7-rwc839aj3073c.xn----ymc5uv818oghka', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7-rwc839aj3073c.xn----ymc5uv818oghka', strict=True)

    def test_uts46_3309(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-｡ݻ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-｡ݻ', strict=True)

    def test_uts46_3310(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-。ݻ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-。ݻ', strict=True)

    def test_uts46_3311(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--cqb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--cqb', strict=True)

    def test_uts46_3312(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑇌\U000356d3｡-⒈ꡏܫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑇌\U000356d3｡-⒈ꡏܫ', strict=True)

    def test_uts46_3313(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑇌\U000356d3。-1.ꡏܫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑇌\U000356d3。-1.ꡏܫ', strict=True)

    def test_uts46_3314(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8d1dg030h.-1.xn--1nb7163f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8d1dg030h.-1.xn--1nb7163f', strict=True)

    def test_uts46_3315(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8d1dg030h.xn----u1c466tp10j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8d1dg030h.xn----u1c466tp10j', strict=True)

    def test_uts46_3316(self):
        self.assertRaises(idna.IDNAError, idna.decode, '璛᜴گ.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '璛᜴گ.-', strict=True)

    def test_uts46_3317(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ikb175frt4e.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ikb175frt4e.-', strict=True)

    def test_uts46_3318(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆰ࢡ੍샕．𐹲휁', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆰ࢡ੍샕．𐹲휁', strict=True)

    def test_uts46_3319(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆰ࢡ੍샕．𐹲휁', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆰ࢡ੍샕．𐹲휁', strict=True)

    def test_uts46_3320(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆰ࢡ੍샕.𐹲휁', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆰ࢡ੍샕.𐹲휁', strict=True)

    def test_uts46_3321(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠆰ࢡ੍샕.𐹲휁', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠆰ࢡ੍샕.𐹲휁', strict=True)

    def test_uts46_3322(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--qyb07fj857a.xn--728bv72h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--qyb07fj857a.xn--728bv72h', strict=True)

    def test_uts46_3323(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004da3d．\U0004be15', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004da3d．\U0004be15', strict=True)

    def test_uts46_3324(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0004da3d.\U0004be15', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0004da3d.\U0004be15', strict=True)

    def test_uts46_3325(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pr3x.xn--rv7w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pr3x.xn--rv7w', strict=True)

    def test_uts46_3326(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽ𞥕｡𑑂𞤶Ⴍ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽ𞥕｡𑑂𞤶Ⴍ-', strict=True)

    def test_uts46_3327(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽ𞥕。𑑂𞤶Ⴍ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽ𞥕。𑑂𞤶Ⴍ-', strict=True)

    def test_uts46_3328(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽ𞥕。𑑂𞤶ⴍ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽ𞥕。𑑂𞤶ⴍ-', strict=True)

    def test_uts46_3329(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽ𞥕。𑑂𞤔Ⴍ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽ𞥕。𑑂𞤔Ⴍ-', strict=True)

    def test_uts46_3330(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽ𞥕。𑑂𞤔ⴍ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽ𞥕。𑑂𞤔ⴍ-', strict=True)

    def test_uts46_3331(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2ib0338v.xn----zvs0199fo91g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2ib0338v.xn----zvs0199fo91g', strict=True)

    def test_uts46_3332(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽ𞥕｡𑑂𞤶ⴍ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽ𞥕｡𑑂𞤶ⴍ-', strict=True)

    def test_uts46_3333(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽ𞥕｡𑑂𞤔Ⴍ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽ𞥕｡𑑂𞤔Ⴍ-', strict=True)

    def test_uts46_3334(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٽ𞥕｡𑑂𞤔ⴍ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٽ𞥕｡𑑂𞤔ⴍ-', strict=True)

    def test_uts46_3335(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2ib0338v.xn----w0g2740ro9vg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2ib0338v.xn----w0g2740ro9vg', strict=True)

    def test_uts46_3336(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010bc0\U00010e09\U0001e9cf。\U000626a7₄Ⴋ\U00042e6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010bc0\U00010e09\U0001e9cf。\U000626a7₄Ⴋ\U00042e6b', strict=True)

    def test_uts46_3337(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010bc0\U00010e09\U0001e9cf。\U000626a74Ⴋ\U00042e6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010bc0\U00010e09\U0001e9cf。\U000626a74Ⴋ\U00042e6b', strict=True)

    def test_uts46_3338(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010bc0\U00010e09\U0001e9cf。\U000626a74ⴋ\U00042e6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010bc0\U00010e09\U0001e9cf。\U000626a74ⴋ\U00042e6b', strict=True)

    def test_uts46_3339(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--039c42bq865a.xn--4-wvs27840bnrzm', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--039c42bq865a.xn--4-wvs27840bnrzm', strict=True)

    def test_uts46_3340(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00010bc0\U00010e09\U0001e9cf。\U000626a7₄ⴋ\U00042e6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00010bc0\U00010e09\U0001e9cf。\U000626a7₄ⴋ\U00042e6b', strict=True)

    def test_uts46_3341(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--039c42bq865a.xn--4-t0g49302fnrzm', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--039c42bq865a.xn--4-t0g49302fnrzm', strict=True)

    def test_uts46_3342(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4ڽ︒\U000e0465.≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4ڽ︒\U000e0465.≠', strict=True)

    def test_uts46_3343(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4ڽ︒\U000e0465.≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4ڽ︒\U000e0465.≠', strict=True)

    def test_uts46_3344(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4ڽ。\U000e0465.≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4ڽ。\U000e0465.≠', strict=True)

    def test_uts46_3345(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4ڽ。\U000e0465.≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4ڽ。\U000e0465.≠', strict=True)

    def test_uts46_3346(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4-kvc.xn--5136e.xn--1ch', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4-kvc.xn--5136e.xn--1ch', strict=True)

    def test_uts46_3347(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4-kvc5601q2h50i.xn--1ch', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4-kvc5601q2h50i.xn--1ch', strict=True)

    def test_uts46_3348(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟓。ۗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟓。ۗ', strict=True)

    def test_uts46_3349(self):
        self.assertRaises(idna.IDNAError, idna.decode, '5。ۗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '5。ۗ', strict=True)

    def test_uts46_3350(self):
        self.assertRaises(idna.IDNAError, idna.decode, '5.xn--nlb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '5.xn--nlb', strict=True)

    def test_uts46_3351(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000bae29.⾕', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000bae29.⾕', strict=True)

    def test_uts46_3352(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000bae29.谷', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000bae29.谷', strict=True)

    def test_uts46_3353(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--i183d.xn--6g3a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--i183d.xn--6g3a', strict=True)

    def test_uts46_3354(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug26167i.xn--6g3a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug26167i.xn--6g3a', strict=True)

    def test_uts46_3355(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒\U000cec07\u200d.-ܼ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒\U000cec07\u200d.-ܼ\u200c', strict=True)

    def test_uts46_3356(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。\U000cec07\u200d.-ܼ\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。\U000cec07\u200d.-ܼ\u200c', strict=True)

    def test_uts46_3357(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--hh50e.xn----t2c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--hh50e.xn----t2c', strict=True)

    def test_uts46_3358(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--1ug05310k.xn----t2c071q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--1ug05310k.xn----t2c071q', strict=True)

    def test_uts46_3359(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--y86c71305c.xn----t2c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--y86c71305c.xn----t2c', strict=True)

    def test_uts46_3360(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug1658ftw26f.xn----t2c071q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug1658ftw26f.xn----t2c071q', strict=True)

    def test_uts46_3361(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𞤟。ᡨ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𞤟。ᡨ', strict=True)

    def test_uts46_3362(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𞤟。ᡨ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𞤟。ᡨ', strict=True)

    def test_uts46_3363(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𞥁。ᡨ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𞥁。ᡨ', strict=True)

    def test_uts46_3364(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯𞥁。ᡨ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯𞥁。ᡨ', strict=True)

    def test_uts46_3365(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hdhz520p.xn--48e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hdhz520p.xn--48e', strict=True)

    def test_uts46_3366(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ུ𫫰𝨄。ܓ𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ུ𫫰𝨄。ܓ𐹦', strict=True)

    def test_uts46_3367(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ned8985uo92e.xn--dnb6395k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ned8985uo92e.xn--dnb6395k', strict=True)

    def test_uts46_3368(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̼ߛ⁷𝟹｡𝟬', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̼ߛ⁷𝟹｡𝟬', strict=True)

    def test_uts46_3369(self):
        self.assertRaises(idna.IDNAError, idna.decode, '̼ߛ73。0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '̼ߛ73。0', strict=True)

    def test_uts46_3370(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--73-9yb648b.a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--73-9yb648b.a', strict=True)

    def test_uts46_3371(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d．𝟗', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d．𝟗', strict=True)

    def test_uts46_3372(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d.j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d.j', strict=True)

    def test_uts46_3373(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d.J', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d.J', strict=True)

    def test_uts46_3374(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.j', strict=True)

    def test_uts46_3375(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.j', strict=True)

    def test_uts46_3376(self):
        self.assertEqual(idna.decode('j', uts46=True, strict=True), 'j')
        self.assertEqual(idna.encode('j', uts46=True, strict=True), b'j')

    def test_uts46_3377(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݹᡭ𪕈。ڶࣙ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݹᡭ𪕈。ڶࣙ', strict=True)

    def test_uts46_3378(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9pb497fs270c.xn--pkb80i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9pb497fs270c.xn--pkb80i', strict=True)

    def test_uts46_3379(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ܦ５ߢ겙。᳴\U00010dda', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ܦ５ߢ겙。᳴\U00010dda', strict=True)

    def test_uts46_3380(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ܦ５ߢ겙。᳴\U00010dda', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ܦ５ߢ겙。᳴\U00010dda', strict=True)

    def test_uts46_3381(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ܦ5ߢ겙。᳴\U00010dda', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ܦ5ߢ겙。᳴\U00010dda', strict=True)

    def test_uts46_3382(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ܦ5ߢ겙。᳴\U00010dda', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ܦ5ߢ겙。᳴\U00010dda', strict=True)

    def test_uts46_3383(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5-j1c97c2483c.xn--e7f2093h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5-j1c97c2483c.xn--e7f2093h', strict=True)

    def test_uts46_3384(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴍ\U0003f8cdꡨ֮。Ⴞ\u200c\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴍ\U0003f8cdꡨ֮。Ⴞ\u200c\u200c', strict=True)

    def test_uts46_3385(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴍ\U0003f8cdꡨ֮。ⴞ\u200c\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴍ\U0003f8cdꡨ֮。ⴞ\u200c\u200c', strict=True)

    def test_uts46_3386(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5cb172r175fug38a.xn--mlj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5cb172r175fug38a.xn--mlj', strict=True)

    def test_uts46_3387(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5cb172r175fug38a.xn--0uga051h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5cb172r175fug38a.xn--0uga051h', strict=True)

    def test_uts46_3388(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5cb347co96jug15a.xn--2nd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5cb347co96jug15a.xn--2nd', strict=True)

    def test_uts46_3389(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5cb347co96jug15a.xn--2nd059ea', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5cb347co96jug15a.xn--2nd059ea', strict=True)

    def test_uts46_3390(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋰。\U000d14f1', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋰。\U000d14f1', strict=True)

    def test_uts46_3391(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--k97c.xn--q031e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--k97c.xn--q031e', strict=True)

    def test_uts46_3392(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e13a6឴୍.𐹾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e13a6឴୍.𐹾', strict=True)

    def test_uts46_3393(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ic59305p.xn--2o0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ic59305p.xn--2o0d', strict=True)

    def test_uts46_3394(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9ic364dho91z.xn--2o0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9ic364dho91z.xn--2o0d', strict=True)

    def test_uts46_3395(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣟႫ\U00036ff8귤．\U000a017c𝟢휪ૣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣟႫ\U00036ff8귤．\U000a017c𝟢휪ૣ', strict=True)

    def test_uts46_3396(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣟႫ\U00036ff8귤．\U000a017c𝟢휪ૣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣟႫ\U00036ff8귤．\U000a017c𝟢휪ૣ', strict=True)

    def test_uts46_3397(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣟႫ\U00036ff8귤.\U000a017c0휪ૣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣟႫ\U00036ff8귤.\U000a017c0휪ૣ', strict=True)

    def test_uts46_3398(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣟႫ\U00036ff8귤.\U000a017c0휪ૣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣟႫ\U00036ff8귤.\U000a017c0휪ૣ', strict=True)

    def test_uts46_3399(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣟⴋ\U00036ff8귤.\U000a017c0휪ૣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣟⴋ\U00036ff8귤.\U000a017c0휪ૣ', strict=True)

    def test_uts46_3400(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣟⴋ\U00036ff8귤.\U000a017c0휪ૣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣟⴋ\U00036ff8귤.\U000a017c0휪ૣ', strict=True)

    def test_uts46_3401(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--i0b436pkl2g2h42a.xn--0-8le8997mulr5f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--i0b436pkl2g2h42a.xn--0-8le8997mulr5f', strict=True)

    def test_uts46_3402(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣟⴋ\U00036ff8귤．\U000a017c𝟢휪ૣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣟⴋ\U00036ff8귤．\U000a017c𝟢휪ૣ', strict=True)

    def test_uts46_3403(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣟⴋ\U00036ff8귤．\U000a017c𝟢휪ૣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣟⴋ\U00036ff8귤．\U000a017c𝟢휪ૣ', strict=True)

    def test_uts46_3404(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--i0b601b6r7l2hs0a.xn--0-8le8997mulr5f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--i0b601b6r7l2hs0a.xn--0-8le8997mulr5f', strict=True)

    def test_uts46_3405(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ބ．𞡝\u0601', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ބ．𞡝\u0601', strict=True)

    def test_uts46_3406(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ބ.𞡝\u0601', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ބ.𞡝\u0601', strict=True)

    def test_uts46_3407(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lqb.xn--jfb1808v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lqb.xn--jfb1808v', strict=True)

    def test_uts46_3408(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્₃.8꣄\u200d🃤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્₃.8꣄\u200d🃤', strict=True)

    def test_uts46_3409(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્3.8꣄\u200d🃤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્3.8꣄\u200d🃤', strict=True)

    def test_uts46_3410(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-yke.xn--8-sl4et308f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-yke.xn--8-sl4et308f', strict=True)

    def test_uts46_3411(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-yke.xn--8-ugnv982dbkwm', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-yke.xn--8-ugnv982dbkwm', strict=True)

    def test_uts46_3412(self):
        self.assertRaises(idna.IDNAError, idna.decode, '℻⩷𝆆。𞤠󠆁᠌', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '℻⩷𝆆。𞤠󠆁᠌', strict=True)

    def test_uts46_3413(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'FAX⩷𝆆。𞤠󠆁᠌', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'FAX⩷𝆆。𞤠󠆁᠌', strict=True)

    def test_uts46_3414(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'fax⩷𝆆。𞥂󠆁᠌', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'fax⩷𝆆。𞥂󠆁᠌', strict=True)

    def test_uts46_3415(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Fax⩷𝆆。𞤠󠆁᠌', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Fax⩷𝆆。𞤠󠆁᠌', strict=True)

    def test_uts46_3416(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fax-4c9a1676t.xn--6e6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fax-4c9a1676t.xn--6e6h', strict=True)

    def test_uts46_3417(self):
        self.assertRaises(idna.IDNAError, idna.decode, '℻⩷𝆆。𞥂󠆁᠌', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '℻⩷𝆆。𞥂󠆁᠌', strict=True)

    def test_uts46_3418(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'FAX⩷𝆆。𞥂󠆁᠌', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'FAX⩷𝆆。𞥂󠆁᠌', strict=True)

    def test_uts46_3419(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'fax⩷𝆆。𞤠󠆁᠌', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'fax⩷𝆆。𞤠󠆁᠌', strict=True)

    def test_uts46_3420(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'fax⩷𝆆.𞥂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'fax⩷𝆆.𞥂', strict=True)

    def test_uts46_3421(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'FAX⩷𝆆.𞤠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'FAX⩷𝆆.𞤠', strict=True)

    def test_uts46_3422(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Fax⩷𝆆.𞤠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Fax⩷𝆆.𞤠', strict=True)

    def test_uts46_3423(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'FAX⩷𝆆.𞥂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'FAX⩷𝆆.𞥂', strict=True)

    def test_uts46_3424(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Fax⩷𝆆.𞥂', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Fax⩷𝆆.𞥂', strict=True)

    def test_uts46_3425(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡕ≠ၞ\U000eeff1｡\U00010d67󠄫ﾠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡕ≠ၞ\U000eeff1｡\U00010d67󠄫ﾠ', strict=True)

    def test_uts46_3426(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡕ≠ၞ\U000eeff1｡\U00010d67󠄫ﾠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡕ≠ၞ\U000eeff1｡\U00010d67󠄫ﾠ', strict=True)

    def test_uts46_3427(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡕ≠ၞ\U000eeff1。\U00010d67󠄫ᅠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡕ≠ၞ\U000eeff1。\U00010d67󠄫ᅠ', strict=True)

    def test_uts46_3428(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡕ≠ၞ\U000eeff1。\U00010d67󠄫ᅠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡕ≠ၞ\U000eeff1。\U00010d67󠄫ᅠ', strict=True)

    def test_uts46_3429(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cld333gn31h0158l.xn--3g0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cld333gn31h0158l.xn--3g0d', strict=True)

    def test_uts46_3430(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cld333gn31h0158l.xn--psd1510k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cld333gn31h0158l.xn--psd1510k', strict=True)

    def test_uts46_3431(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cld333gn31h0158l.xn--cl7c96v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cld333gn31h0158l.xn--cl7c96v', strict=True)

    def test_uts46_3432(self):
        self.assertRaises(idna.IDNAError, idna.decode, '鱊。\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '鱊。\u200c', strict=True)

    def test_uts46_3435(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rt6a.xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rt6a.xn--0ug', strict=True)

    def test_uts46_3436(self):
        self.assertRaises(idna.IDNAError, idna.decode, '8𐹣．𑍨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '8𐹣．𑍨', strict=True)

    def test_uts46_3437(self):
        self.assertRaises(idna.IDNAError, idna.decode, '8𐹣.𑍨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '8𐹣.𑍨', strict=True)

    def test_uts46_3438(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8-d26i.xn--0p1d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8-d26i.xn--0p1d', strict=True)

    def test_uts46_3439(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⏹𐧀．𐫯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⏹𐧀．𐫯', strict=True)

    def test_uts46_3440(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⏹𐧀.𐫯', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⏹𐧀.𐫯', strict=True)

    def test_uts46_3441(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--qoh9161g.xn--1x9c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--qoh9161g.xn--1x9c', strict=True)

    def test_uts46_3442(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤺ߌ4．\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤺ߌ4．\u200d', strict=True)

    def test_uts46_3443(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤺ߌ4.\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤺ߌ4.\u200d', strict=True)

    def test_uts46_3444(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤘ߌ4.\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤘ߌ4.\u200d', strict=True)

    def test_uts46_3447(self):
        self.assertEqual(idna.decode('𞤘ߌ4.', uts46=True, strict=True), '𞤺ߌ4.')
        self.assertRaises(idna.IDNAError, idna.encode, '𞤘ߌ4.', strict=True)

    def test_uts46_3448(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4-0bd15808a.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4-0bd15808a.xn--1ug', strict=True)

    def test_uts46_3449(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤘ߌ4．\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤘ߌ4．\u200d', strict=True)

    def test_uts46_3450(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒗ঁ⃯-.\u08e2•', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒗ঁ⃯-.\u08e2•', strict=True)

    def test_uts46_3451(self):
        self.assertRaises(idna.IDNAError, idna.decode, '16.ঁ⃯-.\u08e2•', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '16.ঁ⃯-.\u08e2•', strict=True)

    def test_uts46_3452(self):
        self.assertRaises(idna.IDNAError, idna.decode, '16.xn----z0d801p.xn--l0b810j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '16.xn----z0d801p.xn--l0b810j', strict=True)

    def test_uts46_3453(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----z0d801p6kd.xn--l0b810j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----z0d801p6kd.xn--l0b810j', strict=True)

    def test_uts46_3454(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-｡䏛', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-｡䏛', strict=True)

    def test_uts46_3455(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-。䏛', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-。䏛', strict=True)

    def test_uts46_3456(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--xco', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--xco', strict=True)

    def test_uts46_3457(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000520e0．\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000520e0．\u200d', strict=True)

    def test_uts46_3458(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000520e0.\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000520e0.\u200d', strict=True)

    def test_uts46_3459(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dj8y.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dj8y.', strict=True)

    def test_uts46_3460(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugz7551c.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugz7551c.xn--1ug', strict=True)

    def test_uts46_3461(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈⓰\U000e58c7｡𐹠\u200d\U00097de6Ⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈⓰\U000e58c7｡𐹠\u200d\U00097de6Ⴕ', strict=True)

    def test_uts46_3462(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.⓰\U000e58c7。𐹠\u200d\U00097de6Ⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.⓰\U000e58c7。𐹠\u200d\U00097de6Ⴕ', strict=True)

    def test_uts46_3463(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.⓰\U000e58c7。𐹠\u200d\U00097de6ⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.⓰\U000e58c7。𐹠\u200d\U00097de6ⴕ', strict=True)

    def test_uts46_3464(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--svh00804k.xn--dljv223ee5t2d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--svh00804k.xn--dljv223ee5t2d', strict=True)

    def test_uts46_3465(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--svh00804k.xn--1ug352csp0psg45e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--svh00804k.xn--1ug352csp0psg45e', strict=True)

    def test_uts46_3466(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈⓰\U000e58c7｡𐹠\u200d\U00097de6ⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈⓰\U000e58c7｡𐹠\u200d\U00097de6ⴕ', strict=True)

    def test_uts46_3467(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tsh0nz9380h.xn--dljv223ee5t2d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tsh0nz9380h.xn--dljv223ee5t2d', strict=True)

    def test_uts46_3468(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tsh0nz9380h.xn--1ug352csp0psg45e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tsh0nz9380h.xn--1ug352csp0psg45e', strict=True)

    def test_uts46_3469(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--svh00804k.xn--tnd1990ke579c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--svh00804k.xn--tnd1990ke579c', strict=True)

    def test_uts46_3470(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--svh00804k.xn--tnd969erj4psgl3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--svh00804k.xn--tnd969erj4psgl3e', strict=True)

    def test_uts46_3471(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tsh0nz9380h.xn--tnd1990ke579c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tsh0nz9380h.xn--tnd1990ke579c', strict=True)

    def test_uts46_3472(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tsh0nz9380h.xn--tnd969erj4psgl3e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tsh0nz9380h.xn--tnd969erj4psgl3e', strict=True)

    def test_uts46_3473(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞠊ᠮ-ß｡᳐効\u0601\U000378ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞠊ᠮ-ß｡᳐効\u0601\U000378ed', strict=True)

    def test_uts46_3474(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞠊ᠮ-ß。᳐効\u0601\U000378ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞠊ᠮ-ß。᳐効\u0601\U000378ed', strict=True)

    def test_uts46_3475(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞠊ᠮ-SS。᳐効\u0601\U000378ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞠊ᠮ-SS。᳐効\u0601\U000378ed', strict=True)

    def test_uts46_3476(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞠊ᠮ-ss。᳐効\u0601\U000378ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞠊ᠮ-ss。᳐効\u0601\U000378ed', strict=True)

    def test_uts46_3477(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞠊ᠮ-Ss。᳐効\u0601\U000378ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞠊ᠮ-Ss。᳐効\u0601\U000378ed', strict=True)

    def test_uts46_3478(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---ss-21t18904a.xn--jfb197i791bi6x4c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---ss-21t18904a.xn--jfb197i791bi6x4c', strict=True)

    def test_uts46_3479(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----qfa310pg973b.xn--jfb197i791bi6x4c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----qfa310pg973b.xn--jfb197i791bi6x4c', strict=True)

    def test_uts46_3480(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞠊ᠮ-SS｡᳐効\u0601\U000378ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞠊ᠮ-SS｡᳐効\u0601\U000378ed', strict=True)

    def test_uts46_3481(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞠊ᠮ-ss｡᳐効\u0601\U000378ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞠊ᠮ-ss｡᳐効\u0601\U000378ed', strict=True)

    def test_uts46_3482(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞠊ᠮ-Ss｡᳐効\u0601\U000378ed', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞠊ᠮ-Ss｡᳐効\u0601\U000378ed', strict=True)

    def test_uts46_3483(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑇀.\U000e0a31', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑇀.\U000e0a31', strict=True)

    def test_uts46_3484(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wd1d.xn--k946e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wd1d.xn--k946e', strict=True)

    def test_uts46_3485(self):
        self.assertRaises(idna.IDNAError, idna.decode, '␒3ﮈ｡𝟘𐨿\U00010e46', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '␒3ﮈ｡𝟘𐨿\U00010e46', strict=True)

    def test_uts46_3486(self):
        self.assertRaises(idna.IDNAError, idna.decode, '␒3ڈ。0𐨿\U00010e46', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '␒3ڈ。0𐨿\U00010e46', strict=True)

    def test_uts46_3487(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-jsc897t.xn--0-sc5iy3h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-jsc897t.xn--0-sc5iy3h', strict=True)

    def test_uts46_3488(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݫ６ઁࢦ。ᷣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݫ６ઁࢦ。ᷣ', strict=True)

    def test_uts46_3489(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ݫ6ઁࢦ。ᷣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ݫ6ઁࢦ。ᷣ', strict=True)

    def test_uts46_3490(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6-h5c06gj6c.xn--7eg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6-h5c06gj6c.xn--7eg', strict=True)

    def test_uts46_3491(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0605-\U0003d91eႢ。\U00085936\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0605-\U0003d91eႢ。\U00085936\u200d', strict=True)

    def test_uts46_3492(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0605-\U0003d91eⴂ。\U00085936\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0605-\U0003d91eⴂ。\U00085936\u200d', strict=True)

    def test_uts46_3493(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----0kc8501a5399e.xn--ss06b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----0kc8501a5399e.xn--ss06b', strict=True)

    def test_uts46_3494(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----0kc8501a5399e.xn--1ugy3204f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----0kc8501a5399e.xn--1ugy3204f', strict=True)

    def test_uts46_3495(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----0kc662fc152h.xn--ss06b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----0kc662fc152h.xn--ss06b', strict=True)

    def test_uts46_3496(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----0kc662fc152h.xn--1ugy3204f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----0kc662fc152h.xn--1ugy3204f', strict=True)

    def test_uts46_3497(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾆．ꡈ５≯ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾆．ꡈ５≯ß', strict=True)

    def test_uts46_3498(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾆．ꡈ５≯ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾆．ꡈ５≯ß', strict=True)

    def test_uts46_3499(self):
        self.assertRaises(idna.IDNAError, idna.decode, '舌.ꡈ5≯ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '舌.ꡈ5≯ß', strict=True)

    def test_uts46_3500(self):
        self.assertRaises(idna.IDNAError, idna.decode, '舌.ꡈ5≯ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '舌.ꡈ5≯ß', strict=True)

    def test_uts46_3501(self):
        self.assertRaises(idna.IDNAError, idna.decode, '舌.ꡈ5≯SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '舌.ꡈ5≯SS', strict=True)

    def test_uts46_3502(self):
        self.assertRaises(idna.IDNAError, idna.decode, '舌.ꡈ5≯SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '舌.ꡈ5≯SS', strict=True)

    def test_uts46_3503(self):
        self.assertRaises(idna.IDNAError, idna.decode, '舌.ꡈ5≯ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '舌.ꡈ5≯ss', strict=True)

    def test_uts46_3504(self):
        self.assertRaises(idna.IDNAError, idna.decode, '舌.ꡈ5≯ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '舌.ꡈ5≯ss', strict=True)

    def test_uts46_3505(self):
        self.assertRaises(idna.IDNAError, idna.decode, '舌.ꡈ5≯Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '舌.ꡈ5≯Ss', strict=True)

    def test_uts46_3506(self):
        self.assertRaises(idna.IDNAError, idna.decode, '舌.ꡈ5≯Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '舌.ꡈ5≯Ss', strict=True)

    def test_uts46_3507(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tc1a.xn--5ss-3m2a5009e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tc1a.xn--5ss-3m2a5009e', strict=True)

    def test_uts46_3508(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tc1a.xn--5-qfa988w745i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tc1a.xn--5-qfa988w745i', strict=True)

    def test_uts46_3509(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾆．ꡈ５≯SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾆．ꡈ５≯SS', strict=True)

    def test_uts46_3510(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾆．ꡈ５≯SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾆．ꡈ５≯SS', strict=True)

    def test_uts46_3511(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾆．ꡈ５≯ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾆．ꡈ５≯ss', strict=True)

    def test_uts46_3512(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾆．ꡈ５≯ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾆．ꡈ５≯ss', strict=True)

    def test_uts46_3513(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾆．ꡈ５≯Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾆．ꡈ５≯Ss', strict=True)

    def test_uts46_3514(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾆．ꡈ５≯Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾆．ꡈ５≯Ss', strict=True)

    def test_uts46_3515(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્8\u200d．\U000be088ݜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્8\u200d．\U000be088ݜ', strict=True)

    def test_uts46_3516(self):
        self.assertRaises(idna.IDNAError, idna.decode, '્8\u200d.\U000be088ݜ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '્8\u200d.\U000be088ݜ', strict=True)

    def test_uts46_3517(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8-yke.xn--gpb79046m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8-yke.xn--gpb79046m', strict=True)

    def test_uts46_3518(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8-yke534n.xn--gpb79046m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8-yke534n.xn--gpb79046m', strict=True)

    def test_uts46_3519(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000b8dc6ੰ≮\U000b94d9．\U0005e3a7⁷\U000e0bd9ڶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000b8dc6ੰ≮\U000b94d9．\U0005e3a7⁷\U000e0bd9ڶ', strict=True)

    def test_uts46_3520(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000b8dc6ੰ≮\U000b94d9．\U0005e3a7⁷\U000e0bd9ڶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000b8dc6ੰ≮\U000b94d9．\U0005e3a7⁷\U000e0bd9ڶ', strict=True)

    def test_uts46_3521(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000b8dc6ੰ≮\U000b94d9.\U0005e3a77\U000e0bd9ڶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000b8dc6ੰ≮\U000b94d9.\U0005e3a77\U000e0bd9ڶ', strict=True)

    def test_uts46_3522(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000b8dc6ੰ≮\U000b94d9.\U0005e3a77\U000e0bd9ڶ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000b8dc6ੰ≮\U000b94d9.\U0005e3a77\U000e0bd9ڶ', strict=True)

    def test_uts46_3523(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ycc893jqh38rb6fa.xn--7-5uc53836ixt41c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ycc893jqh38rb6fa.xn--7-5uc53836ixt41c', strict=True)

    def test_uts46_3524(self):
        self.assertEqual(idna.decode('𞤪.ς', uts46=True, strict=True), '𞤪.ς')
        self.assertEqual(idna.encode('𞤪.ς', uts46=True, strict=True), b'xn--ie6h.xn--3xa')

    def test_uts46_3525(self):
        self.assertEqual(idna.decode('𞤈.Σ', uts46=True, strict=True), '𞤪.σ')
        self.assertEqual(idna.encode('𞤈.Σ', uts46=True, strict=True), b'xn--ie6h.xn--4xa')

    def test_uts46_3526(self):
        self.assertEqual(idna.decode('𞤪.σ', uts46=True, strict=True), '𞤪.σ')
        self.assertEqual(idna.encode('𞤪.σ', uts46=True, strict=True), b'xn--ie6h.xn--4xa')

    def test_uts46_3527(self):
        self.assertEqual(idna.decode('𞤈.σ', uts46=True, strict=True), '𞤪.σ')
        self.assertEqual(idna.encode('𞤈.σ', uts46=True, strict=True), b'xn--ie6h.xn--4xa')

    def test_uts46_3528(self):
        self.assertEqual(idna.decode('xn--ie6h.xn--4xa', uts46=True, strict=True), '𞤪.σ')
        self.assertEqual(idna.encode('xn--ie6h.xn--4xa', uts46=True, strict=True), b'xn--ie6h.xn--4xa')

    def test_uts46_3529(self):
        self.assertEqual(idna.decode('𞤈.ς', uts46=True, strict=True), '𞤪.ς')
        self.assertEqual(idna.encode('𞤈.ς', uts46=True, strict=True), b'xn--ie6h.xn--3xa')

    def test_uts46_3530(self):
        self.assertEqual(idna.decode('xn--ie6h.xn--3xa', uts46=True, strict=True), '𞤪.ς')
        self.assertEqual(idna.encode('xn--ie6h.xn--3xa', uts46=True, strict=True), b'xn--ie6h.xn--3xa')

    def test_uts46_3531(self):
        self.assertEqual(idna.decode('𞤪.Σ', uts46=True, strict=True), '𞤪.σ')
        self.assertEqual(idna.encode('𞤪.Σ', uts46=True, strict=True), b'xn--ie6h.xn--4xa')

    def test_uts46_3532(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႺ｡ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႺ｡ς', strict=True)

    def test_uts46_3533(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႺ。ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႺ。ς', strict=True)

    def test_uts46_3534(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴚ。ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴚ。ς', strict=True)

    def test_uts46_3535(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႺ。Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႺ。Σ', strict=True)

    def test_uts46_3536(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴚ。σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴚ。σ', strict=True)

    def test_uts46_3537(self):
        self.assertEqual(idna.decode('xn--ilj.xn--4xa', uts46=True, strict=True), 'ⴚ.σ')
        self.assertEqual(idna.encode('xn--ilj.xn--4xa', uts46=True, strict=True), b'xn--ilj.xn--4xa')

    def test_uts46_3538(self):
        self.assertEqual(idna.decode('ⴚ.σ', uts46=True, strict=True), 'ⴚ.σ')
        self.assertEqual(idna.encode('ⴚ.σ', uts46=True, strict=True), b'xn--ilj.xn--4xa')

    def test_uts46_3539(self):
        self.assertEqual(idna.decode('Ⴚ.Σ', uts46=True, strict=True), 'ⴚ.σ')
        self.assertEqual(idna.encode('Ⴚ.Σ', uts46=True, strict=True), b'xn--ilj.xn--4xa')

    def test_uts46_3540(self):
        self.assertEqual(idna.decode('ⴚ.ς', uts46=True, strict=True), 'ⴚ.ς')
        self.assertEqual(idna.encode('ⴚ.ς', uts46=True, strict=True), b'xn--ilj.xn--3xa')

    def test_uts46_3541(self):
        self.assertEqual(idna.decode('Ⴚ.ς', uts46=True, strict=True), 'ⴚ.ς')
        self.assertEqual(idna.encode('Ⴚ.ς', uts46=True, strict=True), b'xn--ilj.xn--3xa')

    def test_uts46_3542(self):
        self.assertEqual(idna.decode('xn--ilj.xn--3xa', uts46=True, strict=True), 'ⴚ.ς')
        self.assertEqual(idna.encode('xn--ilj.xn--3xa', uts46=True, strict=True), b'xn--ilj.xn--3xa')

    def test_uts46_3543(self):
        self.assertEqual(idna.decode('Ⴚ.σ', uts46=True, strict=True), 'ⴚ.σ')
        self.assertEqual(idna.encode('Ⴚ.σ', uts46=True, strict=True), b'xn--ilj.xn--4xa')

    def test_uts46_3544(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug262c.xn--4xa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug262c.xn--4xa', strict=True)

    def test_uts46_3545(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug262c.xn--3xa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug262c.xn--3xa', strict=True)

    def test_uts46_3546(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴚ｡ς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴚ｡ς', strict=True)

    def test_uts46_3547(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႺ｡Σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႺ｡Σ', strict=True)

    def test_uts46_3548(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴚ｡σ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴚ｡σ', strict=True)

    def test_uts46_3549(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ynd.xn--4xa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ynd.xn--4xa', strict=True)

    def test_uts46_3550(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ynd.xn--3xa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ynd.xn--3xa', strict=True)

    def test_uts46_3551(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ynd759e.xn--4xa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ynd759e.xn--4xa', strict=True)

    def test_uts46_3552(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ynd759e.xn--3xa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ynd759e.xn--3xa', strict=True)

    def test_uts46_3553(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤃．𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤃．𐹦', strict=True)

    def test_uts46_3554(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤃.𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤃.𐹦', strict=True)

    def test_uts46_3555(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤥.𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤥.𐹦', strict=True)

    def test_uts46_3556(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--de6h.xn--eo0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--de6h.xn--eo0d', strict=True)

    def test_uts46_3557(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤥．𐹦', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤥．𐹦', strict=True)

    def test_uts46_3558(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d⾕。\u200c꥓̐ꡎ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d⾕。\u200c꥓̐ꡎ', strict=True)

    def test_uts46_3559(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d⾕。\u200c꥓̐ꡎ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d⾕。\u200c꥓̐ꡎ', strict=True)

    def test_uts46_3560(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d谷。\u200c꥓̐ꡎ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d谷。\u200c꥓̐ꡎ', strict=True)

    def test_uts46_3561(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6g3a.xn--0sa8175flwa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6g3a.xn--0sa8175flwa', strict=True)

    def test_uts46_3562(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug0273b.xn--0sa359l6n7g13a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug0273b.xn--0sa359l6n7g13a', strict=True)

    def test_uts46_3563(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڪ-뉔．𞤐\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڪ-뉔．𞤐\u200c', strict=True)

    def test_uts46_3564(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڪ-뉔．𞤐\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڪ-뉔．𞤐\u200c', strict=True)

    def test_uts46_3565(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڪ-뉔.𞤐\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڪ-뉔.𞤐\u200c', strict=True)

    def test_uts46_3566(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڪ-뉔.𞤐\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڪ-뉔.𞤐\u200c', strict=True)

    def test_uts46_3567(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڪ-뉔.𞤲\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڪ-뉔.𞤲\u200c', strict=True)

    def test_uts46_3568(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڪ-뉔.𞤲\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڪ-뉔.𞤲\u200c', strict=True)

    def test_uts46_3569(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----guc3592k.xn--qe6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----guc3592k.xn--qe6h', strict=True)

    def test_uts46_3570(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----guc3592k.xn--0ug7611p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----guc3592k.xn--0ug7611p', strict=True)

    def test_uts46_3571(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڪ-뉔．𞤲\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڪ-뉔．𞤲\u200c', strict=True)

    def test_uts46_3572(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڪ-뉔．𞤲\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڪ-뉔．𞤲\u200c', strict=True)

    def test_uts46_3573(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00054cb5５ᦛς.꣄ݻܸ᳒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00054cb5５ᦛς.꣄ݻܸ᳒', strict=True)

    def test_uts46_3574(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00054cb5５ᦛς.꣄ݻܸ᳒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00054cb5５ᦛς.꣄ݻܸ᳒', strict=True)

    def test_uts46_3575(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00054cb55ᦛς.꣄ݻܸ᳒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00054cb55ᦛς.꣄ݻܸ᳒', strict=True)

    def test_uts46_3576(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00054cb55ᦛΣ.꣄ݻܸ᳒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00054cb55ᦛΣ.꣄ݻܸ᳒', strict=True)

    def test_uts46_3577(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00054cb55ᦛσ.꣄ݻܸ᳒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00054cb55ᦛσ.꣄ݻܸ᳒', strict=True)

    def test_uts46_3578(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5-0mb988ng603j.xn--fob7kk44dl41k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5-0mb988ng603j.xn--fob7kk44dl41k', strict=True)

    def test_uts46_3579(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5-ymb298ng603j.xn--fob7kk44dl41k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5-ymb298ng603j.xn--fob7kk44dl41k', strict=True)

    def test_uts46_3580(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00054cb5５ᦛΣ.꣄ݻܸ᳒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00054cb5５ᦛΣ.꣄ݻܸ᳒', strict=True)

    def test_uts46_3581(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00054cb5５ᦛσ.꣄ݻܸ᳒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00054cb5５ᦛσ.꣄ݻܸ᳒', strict=True)

    def test_uts46_3582(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00054cb5５ᦛΣ.꣄ݻܸ᳒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00054cb5５ᦛΣ.꣄ݻܸ᳒', strict=True)

    def test_uts46_3583(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00054cb5５ᦛσ.꣄ݻܸ᳒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00054cb5５ᦛσ.꣄ݻܸ᳒', strict=True)

    def test_uts46_3584(self):
        self.assertEqual(idna.decode('淽。ᠾ', uts46=True, strict=True), '淽.ᠾ')
        self.assertEqual(idna.encode('淽。ᠾ', uts46=True, strict=True), b'xn--34w.xn--x7e')

    def test_uts46_3585(self):
        self.assertEqual(idna.decode('xn--34w.xn--x7e', uts46=True, strict=True), '淽.ᠾ')
        self.assertEqual(idna.encode('xn--34w.xn--x7e', uts46=True, strict=True), b'xn--34w.xn--x7e')

    def test_uts46_3586(self):
        self.assertEqual(idna.decode('淽.ᠾ', uts46=True, strict=True), '淽.ᠾ')
        self.assertEqual(idna.encode('淽.ᠾ', uts46=True, strict=True), b'xn--34w.xn--x7e')

    def test_uts46_3587(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹴𑘷。-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹴𑘷。-', strict=True)

    def test_uts46_3588(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--so0do6k.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--so0do6k.-', strict=True)

    def test_uts46_3589(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000aca29Ⴓ❓｡𑄨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000aca29Ⴓ❓｡𑄨', strict=True)

    def test_uts46_3590(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000aca29Ⴓ❓。𑄨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000aca29Ⴓ❓。𑄨', strict=True)

    def test_uts46_3591(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000aca29ⴓ❓。𑄨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000aca29ⴓ❓。𑄨', strict=True)

    def test_uts46_3592(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8di78qvw32y.xn--k80d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8di78qvw32y.xn--k80d', strict=True)

    def test_uts46_3593(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000aca29ⴓ❓｡𑄨', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000aca29ⴓ❓｡𑄨', strict=True)

    def test_uts46_3594(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--rnd896i0j14q.xn--k80d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--rnd896i0j14q.xn--k80d', strict=True)

    def test_uts46_3595(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌Ⴇ｡ßႣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌Ⴇ｡ßႣ', strict=True)

    def test_uts46_3596(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌Ⴇ。ßႣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌Ⴇ。ßႣ', strict=True)

    def test_uts46_3597(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤮ⴇ。ßⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤮ⴇ。ßⴃ', strict=True)

    def test_uts46_3598(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌Ⴇ。SSႣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌Ⴇ。SSႣ', strict=True)

    def test_uts46_3599(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤮ⴇ。ssⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤮ⴇ。ssⴃ', strict=True)

    def test_uts46_3600(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌ⴇ。Ssⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌ⴇ。Ssⴃ', strict=True)

    def test_uts46_3601(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ykj9323eegwf.xn--ss-151a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ykj9323eegwf.xn--ss-151a', strict=True)

    def test_uts46_3602(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug332c3q0pr56g.xn--ss-151a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug332c3q0pr56g.xn--ss-151a', strict=True)

    def test_uts46_3603(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug332c3q0pr56g.xn--zca417t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug332c3q0pr56g.xn--zca417t', strict=True)

    def test_uts46_3604(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤮ⴇ｡ßⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤮ⴇ｡ßⴃ', strict=True)

    def test_uts46_3605(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌Ⴇ｡SSႣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌Ⴇ｡SSႣ', strict=True)

    def test_uts46_3606(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤮ⴇ｡ssⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤮ⴇ｡ssⴃ', strict=True)

    def test_uts46_3607(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌ⴇ｡Ssⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌ⴇ｡Ssⴃ', strict=True)

    def test_uts46_3608(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fnd1201kegrf.xn--ss-fek', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fnd1201kegrf.xn--ss-fek', strict=True)

    def test_uts46_3609(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fnd599eyj4pr50g.xn--ss-fek', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fnd599eyj4pr50g.xn--ss-fek', strict=True)

    def test_uts46_3610(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fnd599eyj4pr50g.xn--zca681f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fnd599eyj4pr50g.xn--zca681f', strict=True)

    def test_uts46_3611(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌ⴇ。ßⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌ⴇ。ßⴃ', strict=True)

    def test_uts46_3612(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌ⴇ。ssⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌ⴇ。ssⴃ', strict=True)

    def test_uts46_3613(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌Ⴇ。Ssⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌Ⴇ。Ssⴃ', strict=True)

    def test_uts46_3614(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fnd1201kegrf.xn--ss-151a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fnd1201kegrf.xn--ss-151a', strict=True)

    def test_uts46_3615(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fnd599eyj4pr50g.xn--ss-151a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fnd599eyj4pr50g.xn--ss-151a', strict=True)

    def test_uts46_3616(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌ⴇ｡ßⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌ⴇ｡ßⴃ', strict=True)

    def test_uts46_3617(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌ⴇ｡ssⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌ⴇ｡ssⴃ', strict=True)

    def test_uts46_3618(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐹡𞤌Ⴇ｡Ssⴃ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐹡𞤌Ⴇ｡Ssⴃ', strict=True)

    def test_uts46_3619(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u17ff｡\U0001eb33', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u17ff｡\U0001eb33', strict=True)

    def test_uts46_3620(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u17ff。\U0001eb33', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u17ff。\U0001eb33', strict=True)

    def test_uts46_3621(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--45e.xn--et6h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--45e.xn--et6h', strict=True)

    def test_uts46_3622(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ْ\u200d｡್𑚳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ْ\u200d｡್𑚳', strict=True)

    def test_uts46_3623(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ْ\u200d。್𑚳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ْ\u200d。್𑚳', strict=True)

    def test_uts46_3624(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--uhb.xn--8tc4527k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--uhb.xn--8tc4527k', strict=True)

    def test_uts46_3625(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--uhb882k.xn--8tc4527k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--uhb882k.xn--8tc4527k', strict=True)

    def test_uts46_3626(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠ᠻ．ݭ𞥃≮\U000dfdfa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠ᠻ．ݭ𞥃≮\U000dfdfa', strict=True)

    def test_uts46_3627(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠ᠻ．ݭ𞥃≮\U000dfdfa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠ᠻ．ݭ𞥃≮\U000dfdfa', strict=True)

    def test_uts46_3628(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠ᠻ.ݭ𞥃≮\U000dfdfa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠ᠻ.ݭ𞥃≮\U000dfdfa', strict=True)

    def test_uts46_3629(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠ᠻ.ݭ𞥃≮\U000dfdfa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠ᠻ.ݭ𞥃≮\U000dfdfa', strict=True)

    def test_uts46_3630(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠ᠻ.ݭ𞤡≮\U000dfdfa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠ᠻ.ݭ𞤡≮\U000dfdfa', strict=True)

    def test_uts46_3631(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠ᠻ.ݭ𞤡≮\U000dfdfa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠ᠻ.ݭ𞤡≮\U000dfdfa', strict=True)

    def test_uts46_3632(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----g6j886c.xn--xpb049kk353abj99f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----g6j886c.xn--xpb049kk353abj99f', strict=True)

    def test_uts46_3633(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠ᠻ．ݭ𞤡≮\U000dfdfa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠ᠻ．ݭ𞤡≮\U000dfdfa', strict=True)

    def test_uts46_3634(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠ᠻ．ݭ𞤡≮\U000dfdfa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠ᠻ．ݭ𞤡≮\U000dfdfa', strict=True)

    def test_uts46_3635(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0c06≯\u07b5\U00010eea．\U0008a955≮𑁆ࡌ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0c06≯\u07b5\U00010eea．\U0008a955≮𑁆ࡌ', strict=True)

    def test_uts46_3636(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0c06≯\u07b5\U00010eea．\U0008a955≮𑁆ࡌ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0c06≯\u07b5\U00010eea．\U0008a955≮𑁆ࡌ', strict=True)

    def test_uts46_3637(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0c06≯\u07b5\U00010eea.\U0008a955≮𑁆ࡌ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0c06≯\u07b5\U00010eea.\U0008a955≮𑁆ࡌ', strict=True)

    def test_uts46_3638(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0c06≯\u07b5\U00010eea.\U0008a955≮𑁆ࡌ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0c06≯\u07b5\U00010eea.\U0008a955≮𑁆ࡌ', strict=True)

    def test_uts46_3639(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zrb797kdm1oes34i.xn--bwb394k8k2o25n6d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zrb797kdm1oes34i.xn--bwb394k8k2o25n6d', strict=True)

    def test_uts46_3640(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠\U000e62c2.\u0600்-ڹ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠\U000e62c2.\u0600்-ڹ', strict=True)

    def test_uts46_3641(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠\U000e62c2.\u0600்-ڹ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠\U000e62c2.\u0600்-ڹ', strict=True)

    def test_uts46_3642(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ch22084l.xn----qkc07co6n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ch22084l.xn----qkc07co6n', strict=True)

    def test_uts46_3643(self):
        self.assertRaises(idna.IDNAError, idna.decode, '៝\U000e0063≠｡𐹼𐋤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '៝\U000e0063≠｡𐹼𐋤', strict=True)

    def test_uts46_3644(self):
        self.assertRaises(idna.IDNAError, idna.decode, '៝\U000e0063≠｡𐹼𐋤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '៝\U000e0063≠｡𐹼𐋤', strict=True)

    def test_uts46_3645(self):
        self.assertRaises(idna.IDNAError, idna.decode, '៝\U000e0063≠。𐹼𐋤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '៝\U000e0063≠。𐹼𐋤', strict=True)

    def test_uts46_3646(self):
        self.assertRaises(idna.IDNAError, idna.decode, '៝\U000e0063≠。𐹼𐋤', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '៝\U000e0063≠。𐹼𐋤', strict=True)

    def test_uts46_3647(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--54e694cn389z.xn--787ct8r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--54e694cn389z.xn--787ct8r', strict=True)

    def test_uts46_3648(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß𰀻\U00046b17｡𝩨🕮ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß𰀻\U00046b17｡𝩨🕮ß', strict=True)

    def test_uts46_3649(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß𰀻\U00046b17。𝩨🕮ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß𰀻\U00046b17。𝩨🕮ß', strict=True)

    def test_uts46_3650(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS𰀻\U00046b17。𝩨🕮SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS𰀻\U00046b17。𝩨🕮SS', strict=True)

    def test_uts46_3651(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss𰀻\U00046b17。𝩨🕮ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss𰀻\U00046b17。𝩨🕮ss', strict=True)

    def test_uts46_3652(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss𰀻\U00046b17。𝩨🕮Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss𰀻\U00046b17。𝩨🕮Ss', strict=True)

    def test_uts46_3653(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-jl59biy67d.xn--ss-4d11aw87d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-jl59biy67d.xn--ss-4d11aw87d', strict=True)

    def test_uts46_3654(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca20040bgrkh.xn--zca3653v86qa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca20040bgrkh.xn--zca3653v86qa', strict=True)

    def test_uts46_3655(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS𰀻\U00046b17｡𝩨🕮SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS𰀻\U00046b17｡𝩨🕮SS', strict=True)

    def test_uts46_3656(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss𰀻\U00046b17｡𝩨🕮ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss𰀻\U00046b17｡𝩨🕮ss', strict=True)

    def test_uts46_3657(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss𰀻\U00046b17｡𝩨🕮Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss𰀻\U00046b17｡𝩨🕮Ss', strict=True)

    def test_uts46_3658(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d。\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d。\u200c', strict=True)

    def test_uts46_3659(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug.xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug.xn--0ug', strict=True)

    def test_uts46_3660(self):
        self.assertRaises(idna.IDNAError, idna.decode, '҃𐭞\u200d.ឹ\U0001ebcc\U0009fa5a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '҃𐭞\u200d.ឹ\U0001ebcc\U0009fa5a', strict=True)

    def test_uts46_3661(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--m3a6965k.xn--43e8670vmd79b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--m3a6965k.xn--43e8670vmd79b', strict=True)

    def test_uts46_3662(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--m3a412lrr0o.xn--43e8670vmd79b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--m3a412lrr0o.xn--43e8670vmd79b', strict=True)

    def test_uts46_3663(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c𐠨\u200c临。ꡢ\U00084ddeⶏ𐹣', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c𐠨\u200c临。ꡢ\U00084ddeⶏ𐹣', strict=True)

    def test_uts46_3664(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--miq9646b.xn--uojv340bk71c99u9f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--miq9646b.xn--uojv340bk71c99u9f', strict=True)

    def test_uts46_3665(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0uga2656aop9k.xn--uojv340bk71c99u9f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0uga2656aop9k.xn--uojv340bk71c99u9f', strict=True)

    def test_uts46_3666(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0458．󠄮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0458．󠄮', strict=True)

    def test_uts46_3667(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0458.󠄮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0458.󠄮', strict=True)

    def test_uts46_3668(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--s136e.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--s136e.', strict=True)

    def test_uts46_3669(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫄്．꫶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫄്．꫶', strict=True)

    def test_uts46_3670(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐫄്.꫶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐫄്.꫶', strict=True)

    def test_uts46_3671(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wxc7880k.xn--2v9a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wxc7880k.xn--2v9a', strict=True)

    def test_uts46_3672(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꦷ\U000ddd59멹。⒛\U000e0a07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꦷ\U000ddd59멹。⒛\U000e0a07', strict=True)

    def test_uts46_3673(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꦷ\U000ddd59멹。⒛\U000e0a07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꦷ\U000ddd59멹。⒛\U000e0a07', strict=True)

    def test_uts46_3674(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꦷ\U000ddd59멹。20.\U000e0a07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꦷ\U000ddd59멹。20.\U000e0a07', strict=True)

    def test_uts46_3675(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꦷ\U000ddd59멹。20.\U000e0a07', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꦷ\U000ddd59멹。20.\U000e0a07', strict=True)

    def test_uts46_3676(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ym9av13acp85w.20.xn--d846e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ym9av13acp85w.20.xn--d846e', strict=True)

    def test_uts46_3677(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ym9av13acp85w.xn--dth22121k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ym9av13acp85w.xn--dth22121k', strict=True)

    def test_uts46_3678(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳⒊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳⒊', strict=True)

    def test_uts46_3679(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳⒊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳⒊', strict=True)

    def test_uts46_3680(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳3.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳3.', strict=True)

    def test_uts46_3681(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳3.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳3.', strict=True)

    def test_uts46_3682(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳3.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳3.', strict=True)

    def test_uts46_3683(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳3.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳3.', strict=True)

    def test_uts46_3684(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wkj8016bne45io02g.xn--3-55c6803r.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wkj8016bne45io02g.xn--3-55c6803r.', strict=True)

    def test_uts46_3685(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳⒊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳⒊', strict=True)

    def test_uts46_3686(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳⒊', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴅ\U000f2b39릖\U000e0d9a.ݷ𐹳⒊', strict=True)

    def test_uts46_3687(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wkj8016bne45io02g.xn--7pb000mwm4n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wkj8016bne45io02g.xn--7pb000mwm4n', strict=True)

    def test_uts46_3688(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dnd2167fnet0io02g.xn--3-55c6803r.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dnd2167fnet0io02g.xn--3-55c6803r.', strict=True)

    def test_uts46_3689(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dnd2167fnet0io02g.xn--7pb000mwm4n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dnd2167fnet0io02g.xn--7pb000mwm4n', strict=True)

    def test_uts46_3690(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c｡︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c｡︒', strict=True)

    def test_uts46_3691(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c。。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c。。', strict=True)

    def test_uts46_3692(self):
        self.assertRaises(idna.IDNAError, idna.decode, '..', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '..', strict=True)

    def test_uts46_3693(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug..', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug..', strict=True)

    def test_uts46_3694(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--y86c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--y86c', strict=True)

    def test_uts46_3695(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--y86c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--y86c', strict=True)

    def test_uts46_3696(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ݭ．₄', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ݭ．₄', strict=True)

    def test_uts46_3697(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ݭ．₄', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ݭ．₄', strict=True)

    def test_uts46_3698(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ݭ.e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ݭ.e', strict=True)

    def test_uts46_3699(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ݭ.e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ݭ.e', strict=True)

    def test_uts46_3700(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ݭ.E', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ݭ.E', strict=True)

    def test_uts46_3701(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≯ݭ.E', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≯ݭ.E', strict=True)

    def test_uts46_3702(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xpb149k.e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xpb149k.e', strict=True)

    def test_uts46_3703(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡲ-𝟹.ß-\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡲ-𝟹.ß-\u200c-', strict=True)

    def test_uts46_3704(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡲ-3.ß-\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡲ-3.ß-\u200c-', strict=True)

    def test_uts46_3705(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡲ-3.SS-\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡲ-3.SS-\u200c-', strict=True)

    def test_uts46_3706(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡲ-3.ss-\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡲ-3.ss-\u200c-', strict=True)

    def test_uts46_3707(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡲ-3.Ss-\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡲ-3.Ss-\u200c-', strict=True)

    def test_uts46_3708(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---3-p9o.ss--', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---3-p9o.ss--', strict=True)

    def test_uts46_3709(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---3-p9o.xn--ss---276a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---3-p9o.xn--ss---276a', strict=True)

    def test_uts46_3710(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---3-p9o.xn-----fia9303a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---3-p9o.xn-----fia9303a', strict=True)

    def test_uts46_3711(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡲ-𝟹.SS-\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡲ-𝟹.SS-\u200c-', strict=True)

    def test_uts46_3712(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡲ-𝟹.ss-\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡲ-𝟹.ss-\u200c-', strict=True)

    def test_uts46_3713(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡲ-𝟹.Ss-\u200c-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡲ-𝟹.Ss-\u200c-', strict=True)

    def test_uts46_3714(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ﴈ𝟦ه\U000ce2af｡Ӏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ﴈ𝟦ه\U000ce2af｡Ӏ', strict=True)

    def test_uts46_3715(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ضي4ه\U000ce2af。Ӏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ضي4ه\U000ce2af。Ӏ', strict=True)

    def test_uts46_3716(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ضي4ه\U000ce2af。ӏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ضي4ه\U000ce2af。ӏ', strict=True)

    def test_uts46_3717(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4-tnc6ck183523b.xn--s5a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4-tnc6ck183523b.xn--s5a', strict=True)

    def test_uts46_3718(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ﴈ𝟦ه\U000ce2af｡ӏ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ﴈ𝟦ه\U000ce2af｡ӏ', strict=True)

    def test_uts46_3719(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4-tnc6ck183523b.xn--d5a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4-tnc6ck183523b.xn--d5a', strict=True)

    def test_uts46_3720(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.\u0602آ𑆾🐹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.\u0602آ𑆾🐹', strict=True)

    def test_uts46_3721(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.\u0602آ𑆾🐹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.\u0602آ𑆾🐹', strict=True)

    def test_uts46_3722(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--kfb8dy983hgl7g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--kfb8dy983hgl7g', strict=True)

    def test_uts46_3723(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000d9d9cᢘ。᩿⺢', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000d9d9cᢘ。᩿⺢', strict=True)

    def test_uts46_3724(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ibf35138o.xn--fpfz94g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ibf35138o.xn--fpfz94g', strict=True)

    def test_uts46_3725(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ႷᠤႫ｡?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ႷᠤႫ｡?͌س觴', strict=True)

    def test_uts46_3726(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ႷᠤႫ｡?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ႷᠤႫ｡?͌س觴', strict=True)

    def test_uts46_3727(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ႷᠤႫ。?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ႷᠤႫ。?͌س觴', strict=True)

    def test_uts46_3728(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ႷᠤႫ。?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ႷᠤႫ。?͌س觴', strict=True)

    def test_uts46_3729(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ⴗᠤⴋ。?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ⴗᠤⴋ。?͌س觴', strict=True)

    def test_uts46_3730(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ⴗᠤⴋ。?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ⴗᠤⴋ。?͌س觴', strict=True)

    def test_uts46_3731(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠Ⴗᠤⴋ。?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠Ⴗᠤⴋ。?͌س觴', strict=True)

    def test_uts46_3732(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠Ⴗᠤⴋ。?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠Ⴗᠤⴋ。?͌س觴', strict=True)

    def test_uts46_3733(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--66e353ce0ilb.xn--?-7fb34t0u7s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--66e353ce0ilb.xn--?-7fb34t0u7s', strict=True)

    def test_uts46_3734(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ⴗᠤⴋ｡?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ⴗᠤⴋ｡?͌س觴', strict=True)

    def test_uts46_3735(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠ⴗᠤⴋ｡?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠ⴗᠤⴋ｡?͌س觴', strict=True)

    def test_uts46_3736(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠Ⴗᠤⴋ｡?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠Ⴗᠤⴋ｡?͌س觴', strict=True)

    def test_uts46_3737(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠Ⴗᠤⴋ｡?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠Ⴗᠤⴋ｡?͌س觴', strict=True)

    def test_uts46_3738(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vnd619as6ig6k.xn--?-7fb34t0u7s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vnd619as6ig6k.xn--?-7fb34t0u7s', strict=True)

    def test_uts46_3739(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jndx718cnnl.xn--?-7fb34t0u7s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jndx718cnnl.xn--?-7fb34t0u7s', strict=True)

    def test_uts46_3740(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vnd619as6ig6k.?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vnd619as6ig6k.?͌س觴', strict=True)

    def test_uts46_3741(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'XN--VND619AS6IG6K.?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'XN--VND619AS6IG6K.?͌س觴', strict=True)

    def test_uts46_3742(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--Vnd619as6ig6k.?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--Vnd619as6ig6k.?͌س觴', strict=True)

    def test_uts46_3743(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--66e353ce0ilb.?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--66e353ce0ilb.?͌س觴', strict=True)

    def test_uts46_3744(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'XN--66E353CE0ILB.?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'XN--66E353CE0ILB.?͌س觴', strict=True)

    def test_uts46_3745(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--66e353ce0ilb.?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--66e353ce0ilb.?͌س觴', strict=True)

    def test_uts46_3746(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jndx718cnnl.?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jndx718cnnl.?͌س觴', strict=True)

    def test_uts46_3747(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'XN--JNDX718CNNL.?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'XN--JNDX718CNNL.?͌س觴', strict=True)

    def test_uts46_3748(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--Jndx718cnnl.?͌س觴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--Jndx718cnnl.?͌س觴', strict=True)

    def test_uts46_3749(self):
        self.assertRaises(idna.IDNAError, idna.decode, '٧.\U00010968', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '٧.\U00010968', strict=True)

    def test_uts46_3750(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gib.xn--vm9c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gib.xn--vm9c', strict=True)

    def test_uts46_3751(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꧀𝟯｡\u200d\U0007c465𐹪᯳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꧀𝟯｡\u200d\U0007c465𐹪᯳', strict=True)

    def test_uts46_3752(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꧀3。\u200d\U0007c465𐹪᯳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꧀3。\u200d\U0007c465𐹪᯳', strict=True)

    def test_uts46_3753(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-5z4e.xn--1zfz754hncv8b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-5z4e.xn--1zfz754hncv8b', strict=True)

    def test_uts46_3754(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-5z4e.xn--1zf96ony8ygd68c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-5z4e.xn--1zf96ony8ygd68c', strict=True)

    def test_uts46_3755(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a35444\U000605bd.≯٤𑀾\U000e0e0c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a35444\U000605bd.≯٤𑀾\U000e0e0c', strict=True)

    def test_uts46_3756(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a35444\U000605bd.≯٤𑀾\U000e0e0c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a35444\U000605bd.≯٤𑀾\U000e0e0c', strict=True)

    def test_uts46_3757(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4-fg85dl688i.xn--dib174li86ntdy0i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4-fg85dl688i.xn--dib174li86ntdy0i', strict=True)

    def test_uts46_3758(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000971a7𝟯。⒈᩶𝟚\U000a060c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000971a7𝟯。⒈᩶𝟚\U000a060c', strict=True)

    def test_uts46_3759(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000971a73。1.᩶2\U000a060c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000971a73。1.᩶2\U000a060c', strict=True)

    def test_uts46_3760(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-rj42h.1.xn--2-13k96240l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-rj42h.1.xn--2-13k96240l', strict=True)

    def test_uts46_3761(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-rj42h.xn--2-13k746cq465x', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-rj42h.xn--2-13k746cq465x', strict=True)

    def test_uts46_3762(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d₅⒈。≯𝟴\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d₅⒈。≯𝟴\u200d', strict=True)

    def test_uts46_3763(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d₅⒈。≯𝟴\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d₅⒈。≯𝟴\u200d', strict=True)

    def test_uts46_3764(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d51.。≯8\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d51.。≯8\u200d', strict=True)

    def test_uts46_3765(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d51.。≯8\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d51.。≯8\u200d', strict=True)

    def test_uts46_3766(self):
        self.assertRaises(idna.IDNAError, idna.decode, '51..xn--8-ogo', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '51..xn--8-ogo', strict=True)

    def test_uts46_3767(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--51-l1t..xn--8-ugn00i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--51-l1t..xn--8-ugn00i', strict=True)

    def test_uts46_3768(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5-ecp.xn--8-ogo', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5-ecp.xn--8-ogo', strict=True)

    def test_uts46_3769(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5-tgnz5r.xn--8-ugn00i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5-tgnz5r.xn--8-ugn00i', strict=True)

    def test_uts46_3770(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡰڗႆ．\U000aa619ܯ≠\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡰڗႆ．\U000aa619ܯ≠\u200c', strict=True)

    def test_uts46_3771(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡰڗႆ．\U000aa619ܯ≠\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡰڗႆ．\U000aa619ܯ≠\u200c', strict=True)

    def test_uts46_3772(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡰڗႆ.\U000aa619ܯ≠\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡰڗႆ.\U000aa619ܯ≠\u200c', strict=True)

    def test_uts46_3773(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꡰڗႆ.\U000aa619ܯ≠\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꡰڗႆ.\U000aa619ܯ≠\u200c', strict=True)

    def test_uts46_3774(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tjb002cn51k.xn--5nb630lbj91q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tjb002cn51k.xn--5nb630lbj91q', strict=True)

    def test_uts46_3775(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tjb002cn51k.xn--5nb448jcubcz547b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tjb002cn51k.xn--5nb448jcubcz547b', strict=True)

    def test_uts46_3776(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑄱｡\U000aa33f𐹵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑄱｡\U000aa33f𐹵', strict=True)

    def test_uts46_3777(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑄱。\U000aa33f𐹵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑄱。\U000aa33f𐹵', strict=True)

    def test_uts46_3778(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--t80d.xn--to0d14792b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--t80d.xn--to0d14792b', strict=True)

    def test_uts46_3779(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟥\u0600。ܽ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟥\u0600。ܽ', strict=True)

    def test_uts46_3780(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3\u0600。ܽ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3\u0600。ܽ', strict=True)

    def test_uts46_3781(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-rkc.xn--kob', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-rkc.xn--kob', strict=True)

    def test_uts46_3782(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ط𐹣٦.ݭ긷', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ط𐹣٦.ݭ긷', strict=True)

    def test_uts46_3783(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ط𐹣٦.ݭ긷', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ط𐹣٦.ݭ긷', strict=True)

    def test_uts46_3784(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2gb8gu829f.xn--xpb0156f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2gb8gu829f.xn--xpb0156f', strict=True)

    def test_uts46_3785(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒Ↄⷧ\U000be003．Ⴗ\U000108de', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒Ↄⷧ\U000be003．Ⴗ\U000108de', strict=True)

    def test_uts46_3786(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。Ↄⷧ\U000be003.Ⴗ\U000108de', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。Ↄⷧ\U000be003.Ⴗ\U000108de', strict=True)

    def test_uts46_3787(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。ↄⷧ\U000be003.ⴗ\U000108de', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。ↄⷧ\U000be003.ⴗ\U000108de', strict=True)

    def test_uts46_3788(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--r5gy00cll06u.xn--flj4541e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--r5gy00cll06u.xn--flj4541e', strict=True)

    def test_uts46_3789(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒ↄⷧ\U000be003．ⴗ\U000108de', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒ↄⷧ\U000be003．ⴗ\U000108de', strict=True)

    def test_uts46_3790(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--r5gy00c056n0226g.xn--flj4541e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--r5gy00c056n0226g.xn--flj4541e', strict=True)

    def test_uts46_3791(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--q5g000cll06u.xn--vnd8618j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--q5g000cll06u.xn--vnd8618j', strict=True)

    def test_uts46_3792(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--q5g000c056n0226g.xn--vnd8618j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--q5g000c056n0226g.xn--vnd8618j', strict=True)

    def test_uts46_3793(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u0600.ֱ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u0600.ֱ', strict=True)

    def test_uts46_3794(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ifb.xn--8cb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ifb.xn--8cb', strict=True)

    def test_uts46_3795(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς≯｡𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς≯｡𐹽', strict=True)

    def test_uts46_3796(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς≯｡𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς≯｡𐹽', strict=True)

    def test_uts46_3797(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς≯。𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς≯。𐹽', strict=True)

    def test_uts46_3798(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς≯。𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς≯。𐹽', strict=True)

    def test_uts46_3799(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ≯。𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ≯。𐹽', strict=True)

    def test_uts46_3800(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ≯。𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ≯。𐹽', strict=True)

    def test_uts46_3801(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ≯。𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ≯。𐹽', strict=True)

    def test_uts46_3802(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ≯。𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ≯。𐹽', strict=True)

    def test_uts46_3803(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa818m.xn--1o0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa818m.xn--1o0d', strict=True)

    def test_uts46_3804(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa028m.xn--1o0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa028m.xn--1o0d', strict=True)

    def test_uts46_3805(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ≯｡𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ≯｡𐹽', strict=True)

    def test_uts46_3806(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ≯｡𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ≯｡𐹽', strict=True)

    def test_uts46_3807(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ≯｡𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ≯｡𐹽', strict=True)

    def test_uts46_3808(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ≯｡𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ≯｡𐹽', strict=True)

    def test_uts46_3809(self):
        self.assertRaises(idna.IDNAError, idna.decode, '្\u200dݟ。𐹶', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '្\u200dݟ。𐹶', strict=True)

    def test_uts46_3810(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jpb535f.xn--uo0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jpb535f.xn--uo0d', strict=True)

    def test_uts46_3811(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jpb535fv9f.xn--uo0d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jpb535fv9f.xn--uo0d', strict=True)

    def test_uts46_3812(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003edc2ੂႪ\U0004209f.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003edc2ੂႪ\U0004209f.≮', strict=True)

    def test_uts46_3813(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003edc2ੂႪ\U0004209f.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003edc2ੂႪ\U0004209f.≮', strict=True)

    def test_uts46_3814(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003edc2ੂⴊ\U0004209f.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003edc2ੂⴊ\U0004209f.≮', strict=True)

    def test_uts46_3815(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003edc2ੂⴊ\U0004209f.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003edc2ੂⴊ\U0004209f.≮', strict=True)

    def test_uts46_3816(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nbc229o4y27dgskb.xn--gdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nbc229o4y27dgskb.xn--gdh', strict=True)

    def test_uts46_3817(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nbc493aro75ggskb.xn--gdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nbc493aro75ggskb.xn--gdh', strict=True)

    def test_uts46_3818(self):
        self.assertEqual(idna.decode('ꡠ．۲', uts46=True, strict=True), 'ꡠ.۲')
        self.assertEqual(idna.encode('ꡠ．۲', uts46=True, strict=True), b'xn--5c9a.xn--fmb')

    def test_uts46_3819(self):
        self.assertEqual(idna.decode('ꡠ.۲', uts46=True, strict=True), 'ꡠ.۲')
        self.assertEqual(idna.encode('ꡠ.۲', uts46=True, strict=True), b'xn--5c9a.xn--fmb')

    def test_uts46_3820(self):
        self.assertEqual(idna.decode('xn--5c9a.xn--fmb', uts46=True, strict=True), 'ꡠ.۲')
        self.assertEqual(idna.encode('xn--5c9a.xn--fmb', uts46=True, strict=True), b'xn--5c9a.xn--fmb')

    def test_uts46_3821(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣\U00044dc4｡ꡬ🄄', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣\U00044dc4｡ꡬ🄄', strict=True)

    def test_uts46_3822(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣\U00044dc4。ꡬ3,', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣\U00044dc4。ꡬ3,', strict=True)

    def test_uts46_3823(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bo0d0203l.xn--3,-yj9h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bo0d0203l.xn--3,-yj9h', strict=True)

    def test_uts46_3824(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bo0d0203l.xn--id9a4443d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bo0d0203l.xn--id9a4443d', strict=True)

    def test_uts46_3825(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-్\U0001ef80𑲓｡\u200d്', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-్\U0001ef80𑲓｡\u200d്', strict=True)

    def test_uts46_3826(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-్\U0001ef80𑲓。\u200d്', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-్\U0001ef80𑲓。\u200d്', strict=True)

    def test_uts46_3827(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----x6e0220sclug.xn--wxc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----x6e0220sclug.xn--wxc', strict=True)

    def test_uts46_3828(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----x6e0220sclug.xn--wxc317g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----x6e0220sclug.xn--wxc317g', strict=True)

    def test_uts46_3829(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꙽\u200c霣🄆｡\u200c𑁂ᬁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꙽\u200c霣🄆｡\u200c𑁂ᬁ', strict=True)

    def test_uts46_3830(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꙽\u200c霣🄆｡\u200c𑁂ᬁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꙽\u200c霣🄆｡\u200c𑁂ᬁ', strict=True)

    def test_uts46_3831(self):
        self.assertRaises(idna.IDNAError, idna.decode, '꙽\u200c霣5,。\u200c𑁂ᬁ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '꙽\u200c霣5,。\u200c𑁂ᬁ', strict=True)

    def test_uts46_3832(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5,-op8g373c.xn--4sf0725i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5,-op8g373c.xn--4sf0725i', strict=True)

    def test_uts46_3833(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5,-i1tz135dnbqa.xn--4sf36u6u4w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5,-i1tz135dnbqa.xn--4sf36u6u4w', strict=True)

    def test_uts46_3834(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2q5a751a653w.xn--4sf0725i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2q5a751a653w.xn--4sf0725i', strict=True)

    def test_uts46_3835(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug4208b2vjuk63a.xn--4sf36u6u4w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug4208b2vjuk63a.xn--4sf36u6u4w', strict=True)

    def test_uts46_3836(self):
        self.assertRaises(idna.IDNAError, idna.decode, '兎｡ᠼ\U000e0d1c𑚶𑰿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '兎｡ᠼ\U000e0d1c𑚶𑰿', strict=True)

    def test_uts46_3837(self):
        self.assertRaises(idna.IDNAError, idna.decode, '兎。ᠼ\U000e0d1c𑚶𑰿', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '兎。ᠼ\U000e0d1c𑚶𑰿', strict=True)

    def test_uts46_3838(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b5q.xn--v7e6041kqqd4m251b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b5q.xn--v7e6041kqqd4m251b', strict=True)

    def test_uts46_3839(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟙｡\u200d𝟸\u200d⁷', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟙｡\u200d𝟸\u200d⁷', strict=True)

    def test_uts46_3840(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1。\u200d2\u200d7', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1。\u200d2\u200d7', strict=True)

    def test_uts46_3841(self):
        self.assertEqual(idna.decode('1.2h', uts46=True, strict=True), '1.2h')
        self.assertEqual(idna.encode('1.2h', uts46=True, strict=True), b'1.2h')

    def test_uts46_3842(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--27-l1tb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--27-l1tb', strict=True)

    def test_uts46_3843(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡨ-｡\U000e0ecb𝟷', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡨ-｡\U000e0ecb𝟷', strict=True)

    def test_uts46_3844(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡨ-。\U000e0ecb1', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡨ-。\U000e0ecb1', strict=True)

    def test_uts46_3845(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----z8j.xn--1-5671m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----z8j.xn--1-5671m', strict=True)

    def test_uts46_3846(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑰻\U00075010𐫚．٨⁹', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑰻\U00075010𐫚．٨⁹', strict=True)

    def test_uts46_3847(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑰻\U00075010𐫚.٨9', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑰻\U00075010𐫚.٨9', strict=True)

    def test_uts46_3848(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gx9cr01aul57i.xn--9-oqc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gx9cr01aul57i.xn--9-oqc', strict=True)

    def test_uts46_3849(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴜ\U00088dedྀ⾇。Ⴏ♀\u200c\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴜ\U00088dedྀ⾇。Ⴏ♀\u200c\u200c', strict=True)

    def test_uts46_3850(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴜ\U00088dedྀ舛。Ⴏ♀\u200c\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴜ\U00088dedྀ舛。Ⴏ♀\u200c\u200c', strict=True)

    def test_uts46_3851(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴜ\U00088dedྀ舛。ⴏ♀\u200c\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴜ\U00088dedྀ舛。ⴏ♀\u200c\u200c', strict=True)

    def test_uts46_3852(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zed372mdj2do3v4h.xn--e5h11w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zed372mdj2do3v4h.xn--e5h11w', strict=True)

    def test_uts46_3853(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zed372mdj2do3v4h.xn--0uga678bgyh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zed372mdj2do3v4h.xn--0uga678bgyh', strict=True)

    def test_uts46_3854(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴜ\U00088dedྀ⾇。ⴏ♀\u200c\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴜ\U00088dedྀ⾇。ⴏ♀\u200c\u200c', strict=True)

    def test_uts46_3855(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zed54dz10wo343g.xn--nnd651i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zed54dz10wo343g.xn--nnd651i', strict=True)

    def test_uts46_3856(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zed54dz10wo343g.xn--nnd089ea464d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zed54dz10wo343g.xn--nnd089ea464d', strict=True)

    def test_uts46_3857(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑁆𝟰.\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑁆𝟰.\u200d', strict=True)

    def test_uts46_3858(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑁆4.\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑁆4.\u200d', strict=True)

    def test_uts46_3859(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4-xu7i.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4-xu7i.', strict=True)

    def test_uts46_3860(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4-xu7i.xn--1ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4-xu7i.xn--1ug', strict=True)

    def test_uts46_3861(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006ed18Ⴞ癀｡𑘿\u200d\u200c붼', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006ed18Ⴞ癀｡𑘿\u200d\u200c붼', strict=True)

    def test_uts46_3862(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006ed18Ⴞ癀｡𑘿\u200d\u200c붼', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006ed18Ⴞ癀｡𑘿\u200d\u200c붼', strict=True)

    def test_uts46_3863(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006ed18Ⴞ癀。𑘿\u200d\u200c붼', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006ed18Ⴞ癀。𑘿\u200d\u200c붼', strict=True)

    def test_uts46_3864(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006ed18Ⴞ癀。𑘿\u200d\u200c붼', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006ed18Ⴞ癀。𑘿\u200d\u200c붼', strict=True)

    def test_uts46_3865(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006ed18ⴞ癀。𑘿\u200d\u200c붼', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006ed18ⴞ癀。𑘿\u200d\u200c붼', strict=True)

    def test_uts46_3866(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006ed18ⴞ癀。𑘿\u200d\u200c붼', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006ed18ⴞ癀。𑘿\u200d\u200c붼', strict=True)

    def test_uts46_3867(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mlju35u7qx2f.xn--et3bn23n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mlju35u7qx2f.xn--et3bn23n', strict=True)

    def test_uts46_3868(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mlju35u7qx2f.xn--0ugb6122js83c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mlju35u7qx2f.xn--0ugb6122js83c', strict=True)

    def test_uts46_3869(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006ed18ⴞ癀｡𑘿\u200d\u200c붼', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006ed18ⴞ癀｡𑘿\u200d\u200c붼', strict=True)

    def test_uts46_3870(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0006ed18ⴞ癀｡𑘿\u200d\u200c붼', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0006ed18ⴞ癀｡𑘿\u200d\u200c붼', strict=True)

    def test_uts46_3871(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd6803c7q37d.xn--et3bn23n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd6803c7q37d.xn--et3bn23n', strict=True)

    def test_uts46_3872(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2nd6803c7q37d.xn--0ugb6122js83c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2nd6803c7q37d.xn--0ugb6122js83c', strict=True)

    def test_uts46_3873(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000da005-்。ڹ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000da005-்。ڹ', strict=True)

    def test_uts46_3874(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----mze84808x.xn--skb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----mze84808x.xn--skb', strict=True)

    def test_uts46_3875(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡃ𝟧≯ᠣ．氁\U000683f1ꁫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡃ𝟧≯ᠣ．氁\U000683f1ꁫ', strict=True)

    def test_uts46_3876(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡃ𝟧≯ᠣ．氁\U000683f1ꁫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡃ𝟧≯ᠣ．氁\U000683f1ꁫ', strict=True)

    def test_uts46_3877(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡃ5≯ᠣ.氁\U000683f1ꁫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡃ5≯ᠣ.氁\U000683f1ꁫ', strict=True)

    def test_uts46_3878(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡃ5≯ᠣ.氁\U000683f1ꁫ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡃ5≯ᠣ.氁\U000683f1ꁫ', strict=True)

    def test_uts46_3879(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5-24jyf768b.xn--lqw213ime95g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5-24jyf768b.xn--lqw213ime95g', strict=True)

    def test_uts46_3880(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹬𝩇．ྲྀ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹬𝩇．ྲྀ', strict=True)

    def test_uts46_3881(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹬𝩇．ྲྀ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹬𝩇．ྲྀ', strict=True)

    def test_uts46_3882(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹬𝩇.ྲྀ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹬𝩇.ྲྀ', strict=True)

    def test_uts46_3883(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ko0d8295a.xn--zed3h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ko0d8295a.xn--zed3h', strict=True)

    def test_uts46_3884(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𑈶⒏．⒎𰛢\U000e03ad', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𑈶⒏．⒎𰛢\U000e03ad', strict=True)

    def test_uts46_3885(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-𑈶8..7.𰛢\U000e03ad', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-𑈶8..7.𰛢\U000e03ad', strict=True)

    def test_uts46_3886(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn---8-bv5o..7.xn--c35nf1622b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn---8-bv5o..7.xn--c35nf1622b', strict=True)

    def test_uts46_3887(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----scp6252h.xn--zshy411yzpx2d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----scp6252h.xn--zshy411yzpx2d', strict=True)

    def test_uts46_3888(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႡ畝\u200d．≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႡ畝\u200d．≮', strict=True)

    def test_uts46_3889(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႡ畝\u200d．≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႡ畝\u200d．≮', strict=True)

    def test_uts46_3890(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႡ畝\u200d.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႡ畝\u200d.≮', strict=True)

    def test_uts46_3891(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cႡ畝\u200d.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cႡ畝\u200d.≮', strict=True)

    def test_uts46_3892(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴁ畝\u200d.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴁ畝\u200d.≮', strict=True)

    def test_uts46_3893(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴁ畝\u200d.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴁ畝\u200d.≮', strict=True)

    def test_uts46_3894(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--skjy82u.xn--gdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--skjy82u.xn--gdh', strict=True)

    def test_uts46_3895(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴁ畝.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴁ畝.≮', strict=True)

    def test_uts46_3896(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴁ畝.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴁ畝.≮', strict=True)

    def test_uts46_3897(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴁ畝.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴁ畝.≮', strict=True)

    def test_uts46_3898(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴁ畝.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴁ畝.≮', strict=True)

    def test_uts46_3899(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugc160hb36e.xn--gdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugc160hb36e.xn--gdh', strict=True)

    def test_uts46_3900(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴁ畝\u200d．≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴁ畝\u200d．≮', strict=True)

    def test_uts46_3901(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cⴁ畝\u200d．≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cⴁ畝\u200d．≮', strict=True)

    def test_uts46_3902(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8md0962c.xn--gdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8md0962c.xn--gdh', strict=True)

    def test_uts46_3903(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8md700fea3748f.xn--gdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8md700fea3748f.xn--gdh', strict=True)

    def test_uts46_3904(self):
        self.assertRaises(idna.IDNAError, idna.decode, '歷｡𐹻≯\U000f36fd\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '歷｡𐹻≯\U000f36fd\u200d', strict=True)

    def test_uts46_3905(self):
        self.assertRaises(idna.IDNAError, idna.decode, '歷｡𐹻≯\U000f36fd\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '歷｡𐹻≯\U000f36fd\u200d', strict=True)

    def test_uts46_3906(self):
        self.assertRaises(idna.IDNAError, idna.decode, '歷。𐹻≯\U000f36fd\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '歷。𐹻≯\U000f36fd\u200d', strict=True)

    def test_uts46_3907(self):
        self.assertRaises(idna.IDNAError, idna.decode, '歷。𐹻≯\U000f36fd\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '歷。𐹻≯\U000f36fd\u200d', strict=True)

    def test_uts46_3908(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nmw.xn--hdh7804gdms2h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nmw.xn--hdh7804gdms2h', strict=True)

    def test_uts46_3909(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nmw.xn--1ugx6gs128a1134j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nmw.xn--1ugx6gs128a1134j', strict=True)

    def test_uts46_3910(self):
        self.assertRaises(idna.IDNAError, idna.decode, '໋\u200d．鎁\U000e0c11', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '໋\u200d．鎁\U000e0c11', strict=True)

    def test_uts46_3911(self):
        self.assertRaises(idna.IDNAError, idna.decode, '໋\u200d.鎁\U000e0c11', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '໋\u200d.鎁\U000e0c11', strict=True)

    def test_uts46_3912(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--t8c.xn--iz4a43209d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--t8c.xn--iz4a43209d', strict=True)

    def test_uts46_3913(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--t8c059f.xn--iz4a43209d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--t8c059f.xn--iz4a43209d', strict=True)

    def test_uts46_3914(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\u200c𞤀｡𱘅\U00010d83', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\u200c𞤀｡𱘅\U00010d83', strict=True)

    def test_uts46_3915(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\u200c𞤀。𱘅\U00010d83', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\u200c𞤀。𱘅\U00010d83', strict=True)

    def test_uts46_3916(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\u200c𞤢。𱘅\U00010d83', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\u200c𞤢。𱘅\U00010d83', strict=True)

    def test_uts46_3917(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\u200c𞤀。𱘅\U00010d63', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\u200c𞤀。𱘅\U00010d63', strict=True)

    def test_uts46_3918(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9d6h.xn--wh0dj799f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9d6h.xn--wh0dj799f', strict=True)

    def test_uts46_3919(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugb45126a.xn--wh0dj799f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugb45126a.xn--wh0dj799f', strict=True)

    def test_uts46_3920(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\u200c𞤢｡𱘅\U00010d83', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\u200c𞤢｡𱘅\U00010d83', strict=True)

    def test_uts46_3921(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\u200c𞤀｡𱘅\U00010d63', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\u200c𞤀｡𱘅\U00010d63', strict=True)

    def test_uts46_3922(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠𝟫-.ς⒍𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠𝟫-.ς⒍𐹦≠', strict=True)

    def test_uts46_3923(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠𝟫-.ς⒍𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠𝟫-.ς⒍𐹦≠', strict=True)

    def test_uts46_3924(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠9-.ς6.𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠9-.ς6.𐹦≠', strict=True)

    def test_uts46_3925(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠9-.ς6.𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠9-.ς6.𐹦≠', strict=True)

    def test_uts46_3926(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠9-.Σ6.𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠9-.Σ6.𐹦≠', strict=True)

    def test_uts46_3927(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠9-.Σ6.𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠9-.Σ6.𐹦≠', strict=True)

    def test_uts46_3928(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠9-.σ6.𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠9-.σ6.𐹦≠', strict=True)

    def test_uts46_3929(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠9-.σ6.𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠9-.σ6.𐹦≠', strict=True)

    def test_uts46_3930(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9--etd0100a.xn--6-zmb.xn--1ch8704g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9--etd0100a.xn--6-zmb.xn--1ch8704g', strict=True)

    def test_uts46_3931(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9--etd0100a.xn--6-xmb.xn--1ch8704g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9--etd0100a.xn--6-xmb.xn--1ch8704g', strict=True)

    def test_uts46_3932(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠𝟫-.Σ⒍𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠𝟫-.Σ⒍𐹦≠', strict=True)

    def test_uts46_3933(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠𝟫-.Σ⒍𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠𝟫-.Σ⒍𐹦≠', strict=True)

    def test_uts46_3934(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠𝟫-.σ⒍𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠𝟫-.σ⒍𐹦≠', strict=True)

    def test_uts46_3935(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ب≠𝟫-.σ⒍𐹦≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ب≠𝟫-.σ⒍𐹦≠', strict=True)

    def test_uts46_3936(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9--etd0100a.xn--4xa887mzpbzz04b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9--etd0100a.xn--4xa887mzpbzz04b', strict=True)

    def test_uts46_3937(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9--etd0100a.xn--3xa097mzpbzz04b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9--etd0100a.xn--3xa097mzpbzz04b', strict=True)

    def test_uts46_3938(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000896f4.-ᡢ֒𝨠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000896f4.-ᡢ֒𝨠', strict=True)

    def test_uts46_3939(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ep37b.xn----hec165lho83b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ep37b.xn----hec165lho83b', strict=True)

    def test_uts46_3940(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۋ⒈ß󠄽。\U000772cd-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۋ⒈ß󠄽。\U000772cd-', strict=True)

    def test_uts46_3941(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۋ1.ß󠄽。\U000772cd-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۋ1.ß󠄽。\U000772cd-', strict=True)

    def test_uts46_3942(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۋ1.SS󠄽。\U000772cd-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۋ1.SS󠄽。\U000772cd-', strict=True)

    def test_uts46_3943(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۋ1.ss󠄽。\U000772cd-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۋ1.ss󠄽。\U000772cd-', strict=True)

    def test_uts46_3944(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۋ1.Ss󠄽。\U000772cd-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۋ1.Ss󠄽。\U000772cd-', strict=True)

    def test_uts46_3945(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-cwc.ss.xn----q001f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-cwc.ss.xn----q001f', strict=True)

    def test_uts46_3946(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-cwc.xn--zca.xn----q001f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-cwc.xn--zca.xn----q001f', strict=True)

    def test_uts46_3947(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۋ⒈SS󠄽。\U000772cd-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۋ⒈SS󠄽。\U000772cd-', strict=True)

    def test_uts46_3948(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۋ⒈ss󠄽。\U000772cd-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۋ⒈ss󠄽。\U000772cd-', strict=True)

    def test_uts46_3949(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۋ⒈Ss󠄽。\U000772cd-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۋ⒈Ss󠄽。\U000772cd-', strict=True)

    def test_uts46_3950(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-d7d6651a.xn----q001f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-d7d6651a.xn----q001f', strict=True)

    def test_uts46_3951(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca541ato3a.xn----q001f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca541ato3a.xn----q001f', strict=True)

    def test_uts46_3952(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b．᮪ςႦ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b．᮪ςႦ\u200d', strict=True)

    def test_uts46_3953(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b.᮪ςႦ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b.᮪ςႦ\u200d', strict=True)

    def test_uts46_3954(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b.᮪ςⴆ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b.᮪ςⴆ\u200d', strict=True)

    def test_uts46_3955(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b.᮪ΣႦ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b.᮪ΣႦ\u200d', strict=True)

    def test_uts46_3956(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b.᮪σⴆ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b.᮪σⴆ\u200d', strict=True)

    def test_uts46_3957(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b.᮪Σⴆ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b.᮪Σⴆ\u200d', strict=True)

    def test_uts46_3958(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nu4s.xn--4xa153j7im', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nu4s.xn--4xa153j7im', strict=True)

    def test_uts46_3959(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nu4s.xn--4xa153jk8cs1q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nu4s.xn--4xa153jk8cs1q', strict=True)

    def test_uts46_3960(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nu4s.xn--3xa353jk8cs1q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nu4s.xn--3xa353jk8cs1q', strict=True)

    def test_uts46_3961(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b．᮪ςⴆ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b．᮪ςⴆ\u200d', strict=True)

    def test_uts46_3962(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b．᮪ΣႦ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b．᮪ΣႦ\u200d', strict=True)

    def test_uts46_3963(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b．᮪σⴆ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b．᮪σⴆ\u200d', strict=True)

    def test_uts46_3964(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003f02b．᮪Σⴆ\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003f02b．᮪Σⴆ\u200d', strict=True)

    def test_uts46_3965(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nu4s.xn--4xa217dxri', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nu4s.xn--4xa217dxri', strict=True)

    def test_uts46_3966(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nu4s.xn--4xa217dxriome', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nu4s.xn--4xa217dxriome', strict=True)

    def test_uts46_3967(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--nu4s.xn--3xa417dxriome', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--nu4s.xn--3xa417dxriome', strict=True)

    def test_uts46_3968(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⾆\u08e2.𝈴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⾆\u08e2.𝈴', strict=True)

    def test_uts46_3969(self):
        self.assertRaises(idna.IDNAError, idna.decode, '舌\u08e2.𝈴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '舌\u08e2.𝈴', strict=True)

    def test_uts46_3970(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--l0b9413d.xn--kl1h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--l0b9413d.xn--kl1h', strict=True)

    def test_uts46_3971(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⫞𐹶𖫴。⭠⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⫞𐹶𖫴。⭠⒈', strict=True)

    def test_uts46_3972(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⫞𐹶𖫴。⭠1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⫞𐹶𖫴。⭠1.', strict=True)

    def test_uts46_3973(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--53ix188et88b.xn--1-h6r.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--53ix188et88b.xn--1-h6r.', strict=True)

    def test_uts46_3974(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--53ix188et88b.xn--tsh52w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--53ix188et88b.xn--tsh52w', strict=True)

    def test_uts46_3975(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈\u200cꫬ︒．્', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈\u200cꫬ︒．્', strict=True)

    def test_uts46_3976(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.\u200cꫬ。.્', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.\u200cꫬ。.્', strict=True)

    def test_uts46_3977(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--sv9a..xn--mfc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--sv9a..xn--mfc', strict=True)

    def test_uts46_3978(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--0ug7185c..xn--mfc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--0ug7185c..xn--mfc', strict=True)

    def test_uts46_3979(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tsh0720cse8b.xn--mfc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tsh0720cse8b.xn--mfc', strict=True)

    def test_uts46_3980(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug78o720myr1c.xn--mfc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug78o720myr1c.xn--mfc', strict=True)

    def test_uts46_3981(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ె。䰀٨\U0001eb45󠅼', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ె。䰀٨\U0001eb45󠅼', strict=True)

    def test_uts46_3982(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--eqc.xn--hib5476aim6t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--eqc.xn--hib5476aim6t', strict=True)

    def test_uts46_3983(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß\u200d.᯲\U00044fbc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß\u200d.᯲\U00044fbc', strict=True)

    def test_uts46_3984(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS\u200d.᯲\U00044fbc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS\u200d.᯲\U00044fbc', strict=True)

    def test_uts46_3985(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss\u200d.᯲\U00044fbc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss\u200d.᯲\U00044fbc', strict=True)

    def test_uts46_3986(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss\u200d.᯲\U00044fbc', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss\u200d.᯲\U00044fbc', strict=True)

    def test_uts46_3987(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss.xn--0zf22107b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss.xn--0zf22107b', strict=True)

    def test_uts46_3988(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-n1t.xn--0zf22107b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-n1t.xn--0zf22107b', strict=True)

    def test_uts46_3989(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca870n.xn--0zf22107b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca870n.xn--0zf22107b', strict=True)

    def test_uts46_3990(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑓂\u200c≮.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑓂\u200c≮.≮', strict=True)

    def test_uts46_3991(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𑓂\u200c≮.≮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𑓂\u200c≮.≮', strict=True)

    def test_uts46_3992(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdhz656g.xn--gdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdhz656g.xn--gdh', strict=True)

    def test_uts46_3993(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugy6glz29a.xn--gdh', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugy6glz29a.xn--gdh', strict=True)

    def test_uts46_3994(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🕼．ﾠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🕼．ﾠ', strict=True)

    def test_uts46_3995(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🕼.ᅠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🕼.ᅠ', strict=True)

    def test_uts46_3996(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--my8h.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--my8h.', strict=True)

    def test_uts46_3997(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🕼.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🕼.', strict=True)

    def test_uts46_3998(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--my8h.xn--psd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--my8h.xn--psd', strict=True)

    def test_uts46_3999(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--my8h.xn--cl7c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--my8h.xn--cl7c', strict=True)

    def test_uts46_4000(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡔﶂ。\U0007760e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡔﶂ。\U0007760e', strict=True)

    def test_uts46_4001(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡔلحى。\U0007760e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡔلحى。\U0007760e', strict=True)

    def test_uts46_4002(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--sgb9bq785p.xn--bc31b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--sgb9bq785p.xn--bc31b', strict=True)

    def test_uts46_4003(self):
        self.assertRaises(idna.IDNAError, idna.decode, '爕\U000b3651．𝟰気', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '爕\U000b3651．𝟰気', strict=True)

    def test_uts46_4004(self):
        self.assertRaises(idna.IDNAError, idna.decode, '爕\U000b3651.4気', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '爕\U000b3651.4気', strict=True)

    def test_uts46_4005(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1zxq3199c.xn--4-678b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1zxq3199c.xn--4-678b', strict=True)

    def test_uts46_4006(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒋𑍍Ⴝ-．\U0001eb2a්ֵ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒋𑍍Ⴝ-．\U0001eb2a්ֵ', strict=True)

    def test_uts46_4007(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4.𑍍Ⴝ-.\U0001eb2a්ֵ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4.𑍍Ⴝ-.\U0001eb2a්ֵ', strict=True)

    def test_uts46_4008(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4.𑍍ⴝ-.\U0001eb2a්ֵ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4.𑍍ⴝ-.\U0001eb2a්ֵ', strict=True)

    def test_uts46_4009(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4.xn----wwsx259f.xn--ddb152b7y23b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4.xn----wwsx259f.xn--ddb152b7y23b', strict=True)

    def test_uts46_4010(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒋𑍍ⴝ-．\U0001eb2a්ֵ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒋𑍍ⴝ-．\U0001eb2a්ֵ', strict=True)

    def test_uts46_4011(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----jcp487avl3w.xn--ddb152b7y23b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----jcp487avl3w.xn--ddb152b7y23b', strict=True)

    def test_uts46_4012(self):
        self.assertRaises(idna.IDNAError, idna.decode, '4.xn----t1g9869q.xn--ddb152b7y23b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '4.xn----t1g9869q.xn--ddb152b7y23b', strict=True)

    def test_uts46_4013(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----t1g323mnk9t.xn--ddb152b7y23b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----t1g323mnk9t.xn--ddb152b7y23b', strict=True)

    def test_uts46_4014(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000de743。\U00091183\U00049897--', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000de743。\U00091183\U00049897--', strict=True)

    def test_uts46_4015(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2y75e.xn-----1l15eer88n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2y75e.xn-----1l15eer88n', strict=True)

    def test_uts46_4016(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200dߟ｡\u200c꯭', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200dߟ｡\u200c꯭', strict=True)

    def test_uts46_4017(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200dߟ。\u200c꯭', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200dߟ。\u200c꯭', strict=True)

    def test_uts46_4018(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6sb.xn--429a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6sb.xn--429a', strict=True)

    def test_uts46_4019(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--6sb394j.xn--0ug1126c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--6sb394j.xn--0ug1126c', strict=True)

    def test_uts46_4020(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ebbd߿ࡎ｡ᢍ\U0009de41𐫘', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ebbd߿ࡎ｡ᢍ\U0009de41𐫘', strict=True)

    def test_uts46_4021(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ebbd߿ࡎ。ᢍ\U0009de41𐫘', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ebbd߿ࡎ。ᢍ\U0009de41𐫘', strict=True)

    def test_uts46_4022(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3tb2nz468k.xn--69e8615j5rn5d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3tb2nz468k.xn--69e8615j5rn5d', strict=True)

    def test_uts46_4023(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۭ𞺌𑄚᜔.ꡞࢷ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۭ𞺌𑄚᜔.ꡞࢷ', strict=True)

    def test_uts46_4024(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ۭم𑄚᜔.ꡞࢷ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ۭم𑄚᜔.ꡞࢷ', strict=True)

    def test_uts46_4025(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hhb94ag41b739u.xn--dzb5582f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hhb94ag41b739u.xn--dzb5582f', strict=True)

    def test_uts46_4026(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡ςؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡ςؼς', strict=True)

    def test_uts46_4027(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡ςؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡ςؼς', strict=True)

    def test_uts46_4028(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。ςؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。ςؼς', strict=True)

    def test_uts46_4029(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。ςؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。ςؼς', strict=True)

    def test_uts46_4030(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。ΣؼΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。ΣؼΣ', strict=True)

    def test_uts46_4031(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。ΣؼΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。ΣؼΣ', strict=True)

    def test_uts46_4032(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。σؼσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。σؼσ', strict=True)

    def test_uts46_4033(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。σؼσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。σؼσ', strict=True)

    def test_uts46_4034(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。Σؼσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。Σؼσ', strict=True)

    def test_uts46_4035(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。Σؼσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。Σؼσ', strict=True)

    def test_uts46_4036(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3sb7483hoyvbbe76g.xn--4xaa21q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3sb7483hoyvbbe76g.xn--4xaa21q', strict=True)

    def test_uts46_4037(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。Σؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。Σؼς', strict=True)

    def test_uts46_4038(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。Σؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。Σؼς', strict=True)

    def test_uts46_4039(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。σؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。σؼς', strict=True)

    def test_uts46_4040(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ。σؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ。σؼς', strict=True)

    def test_uts46_4041(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3sb7483hoyvbbe76g.xn--3xab31q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3sb7483hoyvbbe76g.xn--3xab31q', strict=True)

    def test_uts46_4042(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3sb7483hoyvbbe76g.xn--3xaa51q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3sb7483hoyvbbe76g.xn--3xaa51q', strict=True)

    def test_uts46_4043(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡ΣؼΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡ΣؼΣ', strict=True)

    def test_uts46_4044(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡ΣؼΣ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡ΣؼΣ', strict=True)

    def test_uts46_4045(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡σؼσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡σؼσ', strict=True)

    def test_uts46_4046(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡σؼσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡σؼσ', strict=True)

    def test_uts46_4047(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡Σؼσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡Σؼσ', strict=True)

    def test_uts46_4048(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡Σؼσ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡Σؼσ', strict=True)

    def test_uts46_4049(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡Σؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡Σؼς', strict=True)

    def test_uts46_4050(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡Σؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡Σؼς', strict=True)

    def test_uts46_4051(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡σؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡σؼς', strict=True)

    def test_uts46_4052(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0007b0b5킃𑘶ߜ｡σؼς', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0007b0b5킃𑘶ߜ｡σؼς', strict=True)

    def test_uts46_4053(self):
        self.assertRaises(idna.IDNAError, idna.decode, '蔰。\U000e0079ࣝ-𑈵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '蔰。\U000e0079ࣝ-𑈵', strict=True)

    def test_uts46_4054(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--sz1a.xn----mrd9984r3dl0i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--sz1a.xn----mrd9984r3dl0i', strict=True)

    def test_uts46_4055(self):
        self.assertEqual(idna.decode('ςჅ。ݚ', uts46=True, strict=True), 'ςⴥ.ݚ')
        self.assertEqual(idna.encode('ςჅ。ݚ', uts46=True, strict=True), b'xn--3xa403s.xn--epb')

    def test_uts46_4056(self):
        self.assertEqual(idna.decode('ςⴥ。ݚ', uts46=True, strict=True), 'ςⴥ.ݚ')
        self.assertEqual(idna.encode('ςⴥ。ݚ', uts46=True, strict=True), b'xn--3xa403s.xn--epb')

    def test_uts46_4057(self):
        self.assertEqual(idna.decode('ΣჅ。ݚ', uts46=True, strict=True), 'σⴥ.ݚ')
        self.assertEqual(idna.encode('ΣჅ。ݚ', uts46=True, strict=True), b'xn--4xa203s.xn--epb')

    def test_uts46_4058(self):
        self.assertEqual(idna.decode('σⴥ。ݚ', uts46=True, strict=True), 'σⴥ.ݚ')
        self.assertEqual(idna.encode('σⴥ。ݚ', uts46=True, strict=True), b'xn--4xa203s.xn--epb')

    def test_uts46_4059(self):
        self.assertEqual(idna.decode('Σⴥ。ݚ', uts46=True, strict=True), 'σⴥ.ݚ')
        self.assertEqual(idna.encode('Σⴥ。ݚ', uts46=True, strict=True), b'xn--4xa203s.xn--epb')

    def test_uts46_4060(self):
        self.assertEqual(idna.decode('xn--4xa203s.xn--epb', uts46=True, strict=True), 'σⴥ.ݚ')
        self.assertEqual(idna.encode('xn--4xa203s.xn--epb', uts46=True, strict=True), b'xn--4xa203s.xn--epb')

    def test_uts46_4061(self):
        self.assertEqual(idna.decode('σⴥ.ݚ', uts46=True, strict=True), 'σⴥ.ݚ')
        self.assertEqual(idna.encode('σⴥ.ݚ', uts46=True, strict=True), b'xn--4xa203s.xn--epb')

    def test_uts46_4062(self):
        self.assertEqual(idna.decode('ΣჅ.ݚ', uts46=True, strict=True), 'σⴥ.ݚ')
        self.assertEqual(idna.encode('ΣჅ.ݚ', uts46=True, strict=True), b'xn--4xa203s.xn--epb')

    def test_uts46_4063(self):
        self.assertEqual(idna.decode('Σⴥ.ݚ', uts46=True, strict=True), 'σⴥ.ݚ')
        self.assertEqual(idna.encode('Σⴥ.ݚ', uts46=True, strict=True), b'xn--4xa203s.xn--epb')

    def test_uts46_4064(self):
        self.assertEqual(idna.decode('xn--3xa403s.xn--epb', uts46=True, strict=True), 'ςⴥ.ݚ')
        self.assertEqual(idna.encode('xn--3xa403s.xn--epb', uts46=True, strict=True), b'xn--3xa403s.xn--epb')

    def test_uts46_4065(self):
        self.assertEqual(idna.decode('ςⴥ.ݚ', uts46=True, strict=True), 'ςⴥ.ݚ')
        self.assertEqual(idna.encode('ςⴥ.ݚ', uts46=True, strict=True), b'xn--3xa403s.xn--epb')

    def test_uts46_4066(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa477d.xn--epb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa477d.xn--epb', strict=True)

    def test_uts46_4067(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa677d.xn--epb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa677d.xn--epb', strict=True)

    def test_uts46_4068(self):
        self.assertRaises(idna.IDNAError, idna.decode, '్Ⴉ\U0001ec13．᭲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '్Ⴉ\U0001ec13．᭲', strict=True)

    def test_uts46_4069(self):
        self.assertRaises(idna.IDNAError, idna.decode, '్Ⴉ\U0001ec13.᭲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '్Ⴉ\U0001ec13.᭲', strict=True)

    def test_uts46_4070(self):
        self.assertRaises(idna.IDNAError, idna.decode, '్ⴉ\U0001ec13.᭲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '్ⴉ\U0001ec13.᭲', strict=True)

    def test_uts46_4071(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lqc478nlr02a.xn--dwf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lqc478nlr02a.xn--dwf', strict=True)

    def test_uts46_4072(self):
        self.assertRaises(idna.IDNAError, idna.decode, '్ⴉ\U0001ec13．᭲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '్ⴉ\U0001ec13．᭲', strict=True)

    def test_uts46_4073(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--lqc64t7t26c.xn--dwf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--lqc64t7t26c.xn--dwf', strict=True)

    def test_uts46_4074(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⮷≮\U0004e234󠄟。𐠄', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⮷≮\U0004e234󠄟。𐠄', strict=True)

    def test_uts46_4075(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⮷≮\U0004e234󠄟。𐠄', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⮷≮\U0004e234󠄟。𐠄', strict=True)

    def test_uts46_4076(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh877a3513h.xn--pc9c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh877a3513h.xn--pc9c', strict=True)

    def test_uts46_4077(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڼ｡\u200dẏ\u200cᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڼ｡\u200dẏ\u200cᡤ', strict=True)

    def test_uts46_4078(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڼ｡\u200dẏ\u200cᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڼ｡\u200dẏ\u200cᡤ', strict=True)

    def test_uts46_4079(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڼ。\u200dẏ\u200cᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڼ。\u200dẏ\u200cᡤ', strict=True)

    def test_uts46_4080(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڼ。\u200dẏ\u200cᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڼ。\u200dẏ\u200cᡤ', strict=True)

    def test_uts46_4081(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڼ。\u200dẎ\u200cᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڼ。\u200dẎ\u200cᡤ', strict=True)

    def test_uts46_4082(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڼ。\u200dẎ\u200cᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڼ。\u200dẎ\u200cᡤ', strict=True)

    def test_uts46_4083(self):
        self.assertEqual(idna.decode('xn--vkb.xn--08e172a', uts46=True, strict=True), 'ڼ.ẏᡤ')
        self.assertEqual(idna.encode('xn--vkb.xn--08e172a', uts46=True, strict=True), b'xn--vkb.xn--08e172a')

    def test_uts46_4084(self):
        self.assertEqual(idna.decode('ڼ.ẏᡤ', uts46=True, strict=True), 'ڼ.ẏᡤ')
        self.assertEqual(idna.encode('ڼ.ẏᡤ', uts46=True, strict=True), b'xn--vkb.xn--08e172a')

    def test_uts46_4085(self):
        self.assertEqual(idna.decode('ڼ.ẏᡤ', uts46=True, strict=True), 'ڼ.ẏᡤ')
        self.assertEqual(idna.encode('ڼ.ẏᡤ', uts46=True, strict=True), b'xn--vkb.xn--08e172a')

    def test_uts46_4086(self):
        self.assertEqual(idna.decode('ڼ.Ẏᡤ', uts46=True, strict=True), 'ڼ.ẏᡤ')
        self.assertEqual(idna.encode('ڼ.Ẏᡤ', uts46=True, strict=True), b'xn--vkb.xn--08e172a')

    def test_uts46_4087(self):
        self.assertEqual(idna.decode('ڼ.Ẏᡤ', uts46=True, strict=True), 'ڼ.ẏᡤ')
        self.assertEqual(idna.encode('ڼ.Ẏᡤ', uts46=True, strict=True), b'xn--vkb.xn--08e172a')

    def test_uts46_4088(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vkb.xn--08e172ax6aca', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vkb.xn--08e172ax6aca', strict=True)

    def test_uts46_4089(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڼ｡\u200dẎ\u200cᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڼ｡\u200dẎ\u200cᡤ', strict=True)

    def test_uts46_4090(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڼ｡\u200dẎ\u200cᡤ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڼ｡\u200dẎ\u200cᡤ', strict=True)

    def test_uts46_4091(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹹𑲛。\U00051090්', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹹𑲛。\U00051090්', strict=True)

    def test_uts46_4092(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xo0dg5v.xn--h1c39876d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xo0dg5v.xn--h1c39876d', strict=True)

    def test_uts46_4093(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠𑈵｡嵕ﻱ۴꥓', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠𑈵｡嵕ﻱ۴꥓', strict=True)

    def test_uts46_4094(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠𑈵｡嵕ﻱ۴꥓', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠𑈵｡嵕ﻱ۴꥓', strict=True)

    def test_uts46_4095(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠𑈵。嵕ي۴꥓', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠𑈵。嵕ي۴꥓', strict=True)

    def test_uts46_4096(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≠𑈵。嵕ي۴꥓', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≠𑈵。嵕ي۴꥓', strict=True)

    def test_uts46_4097(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ufo4749h.xn--mhb45a235sns3c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ufo4749h.xn--mhb45a235sns3c', strict=True)

    def test_uts46_4098(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U0004de30𐹶ݮ．ہ\u200d≯\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U0004de30𐹶ݮ．ہ\u200d≯\u200d', strict=True)

    def test_uts46_4099(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U0004de30𐹶ݮ．ہ\u200d≯\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U0004de30𐹶ݮ．ہ\u200d≯\u200d', strict=True)

    def test_uts46_4100(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U0004de30𐹶ݮ.ہ\u200d≯\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U0004de30𐹶ݮ.ہ\u200d≯\u200d', strict=True)

    def test_uts46_4101(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U0004de30𐹶ݮ.ہ\u200d≯\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U0004de30𐹶ݮ.ہ\u200d≯\u200d', strict=True)

    def test_uts46_4102(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ypb5875khz9y.xn--0kb682l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ypb5875khz9y.xn--0kb682l', strict=True)

    def test_uts46_4103(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ypb717jrx2o7v94a.xn--0kb660ka35v', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ypb717jrx2o7v94a.xn--0kb660ka35v', strict=True)

    def test_uts46_4104(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮．឵ࡕ𐫔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮．឵ࡕ𐫔', strict=True)

    def test_uts46_4105(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮．឵ࡕ𐫔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮．឵ࡕ𐫔', strict=True)

    def test_uts46_4106(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮.឵ࡕ𐫔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮.឵ࡕ𐫔', strict=True)

    def test_uts46_4107(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≮.឵ࡕ𐫔', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≮.឵ࡕ𐫔', strict=True)

    def test_uts46_4108(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh.xn--kwb4643k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh.xn--kwb4643k', strict=True)

    def test_uts46_4109(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gdh.xn--kwb589e217p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gdh.xn--kwb589e217p', strict=True)

    def test_uts46_4110(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐩗\u200d｡ႩႵ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐩗\u200d｡ႩႵ', strict=True)

    def test_uts46_4111(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐩗\u200d。ႩႵ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐩗\u200d。ႩႵ', strict=True)

    def test_uts46_4112(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐩗\u200d。ⴉⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐩗\u200d。ⴉⴕ', strict=True)

    def test_uts46_4113(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐩗\u200d。Ⴉⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐩗\u200d。Ⴉⴕ', strict=True)

    def test_uts46_4114(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pt9c.xn--0kjya', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pt9c.xn--0kjya', strict=True)

    def test_uts46_4115(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐩗.ⴉⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐩗.ⴉⴕ', strict=True)

    def test_uts46_4116(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐩗.ႩႵ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐩗.ႩႵ', strict=True)

    def test_uts46_4117(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐩗.Ⴉⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐩗.Ⴉⴕ', strict=True)

    def test_uts46_4118(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug4933g.xn--0kjya', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug4933g.xn--0kjya', strict=True)

    def test_uts46_4119(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐩗\u200d｡ⴉⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐩗\u200d｡ⴉⴕ', strict=True)

    def test_uts46_4120(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐩗\u200d｡Ⴉⴕ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐩗\u200d｡Ⴉⴕ', strict=True)

    def test_uts46_4121(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pt9c.xn--hnd666l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pt9c.xn--hnd666l', strict=True)

    def test_uts46_4122(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug4933g.xn--hnd666l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug4933g.xn--hnd666l', strict=True)

    def test_uts46_4123(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--pt9c.xn--hndy', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--pt9c.xn--hndy', strict=True)

    def test_uts46_4124(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug4933g.xn--hndy', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug4933g.xn--hndy', strict=True)

    def test_uts46_4125(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\u200cㄤ．̮\U000d5a11ূ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\u200cㄤ．̮\U000d5a11ূ', strict=True)

    def test_uts46_4126(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\u200cㄤ.̮\U000d5a11ূ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\u200cㄤ.̮\U000d5a11ূ', strict=True)

    def test_uts46_4127(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1fk.xn--vta284a9o563a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1fk.xn--vta284a9o563a', strict=True)

    def test_uts46_4128(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0uga242k.xn--vta284a9o563a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0uga242k.xn--vta284a9o563a', strict=True)

    def test_uts46_4129(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋻｡-\u200c𐫄Ⴗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋻｡-\u200c𐫄Ⴗ', strict=True)

    def test_uts46_4130(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋻。-\u200c𐫄Ⴗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋻。-\u200c𐫄Ⴗ', strict=True)

    def test_uts46_4131(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋻。-\u200c𐫄ⴗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋻。-\u200c𐫄ⴗ', strict=True)

    def test_uts46_4132(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--v97c.xn----lws0526f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--v97c.xn----lws0526f', strict=True)

    def test_uts46_4133(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--v97c.xn----sgnv20du99s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--v97c.xn----sgnv20du99s', strict=True)

    def test_uts46_4134(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐋻｡-\u200c𐫄ⴗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐋻｡-\u200c𐫄ⴗ', strict=True)

    def test_uts46_4135(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--v97c.xn----i1g2513q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--v97c.xn----i1g2513q', strict=True)

    def test_uts46_4136(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--v97c.xn----i1g888ih12u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--v97c.xn----i1g888ih12u', strict=True)

    def test_uts46_4137(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🙑\U00010dfa．≠\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🙑\U00010dfa．≠\u200c', strict=True)

    def test_uts46_4138(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🙑\U00010dfa．≠\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🙑\U00010dfa．≠\u200c', strict=True)

    def test_uts46_4139(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🙑\U00010dfa.≠\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🙑\U00010dfa.≠\u200c', strict=True)

    def test_uts46_4140(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🙑\U00010dfa.≠\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🙑\U00010dfa.≠\u200c', strict=True)

    def test_uts46_4141(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bl0dh970b.xn--1ch', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bl0dh970b.xn--1ch', strict=True)

    def test_uts46_4142(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--bl0dh970b.xn--0ug83g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--bl0dh970b.xn--0ug83g', strict=True)

    def test_uts46_4143(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٌ᳒｡\U0001eb9e⵿⧎', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٌ᳒｡\U0001eb9e⵿⧎', strict=True)

    def test_uts46_4144(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ٌ᳒。\U0001eb9e⵿⧎', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ٌ᳒。\U0001eb9e⵿⧎', strict=True)

    def test_uts46_4145(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ohb646i.xn--ewi38jf765c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ohb646i.xn--ewi38jf765c', strict=True)

    def test_uts46_4146(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴔ𝨨₃\U000e0066．𝟳𑂹ஂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴔ𝨨₃\U000e0066．𝟳𑂹ஂ', strict=True)

    def test_uts46_4147(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴔ𝨨3\U000e0066.7𑂹ஂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴔ𝨨3\U000e0066.7𑂹ஂ', strict=True)

    def test_uts46_4148(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴔ𝨨3\U000e0066.7𑂹ஂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴔ𝨨3\U000e0066.7𑂹ஂ', strict=True)

    def test_uts46_4149(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-ews6985n35s3g.xn--7-cve6271r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-ews6985n35s3g.xn--7-cve6271r', strict=True)

    def test_uts46_4150(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴔ𝨨₃\U000e0066．𝟳𑂹ஂ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴔ𝨨₃\U000e0066．𝟳𑂹ஂ', strict=True)

    def test_uts46_4151(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-b1g83426a35t0g.xn--7-cve6271r', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-b1g83426a35t0g.xn--7-cve6271r', strict=True)

    def test_uts46_4152(self):
        self.assertRaises(idna.IDNAError, idna.decode, '䏈\u200c。\u200c⒈\U00071895', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '䏈\u200c。\u200c⒈\U00071895', strict=True)

    def test_uts46_4153(self):
        self.assertRaises(idna.IDNAError, idna.decode, '䏈\u200c。\u200c1.\U00071895', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '䏈\u200c。\u200c1.\U00071895', strict=True)

    def test_uts46_4154(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--eco.1.xn--ms39a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--eco.1.xn--ms39a', strict=True)

    def test_uts46_4155(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug491l.xn--1-rgn.xn--ms39a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug491l.xn--1-rgn.xn--ms39a', strict=True)

    def test_uts46_4156(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--eco.xn--tsh21126d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--eco.xn--tsh21126d', strict=True)

    def test_uts46_4157(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug491l.xn--0ug88oot66q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug491l.xn--0ug88oot66q', strict=True)

    def test_uts46_4158(self):
        self.assertRaises(idna.IDNAError, idna.decode, '１꫶ß𑲥｡ᷘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '１꫶ß𑲥｡ᷘ', strict=True)

    def test_uts46_4159(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1꫶ß𑲥。ᷘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1꫶ß𑲥。ᷘ', strict=True)

    def test_uts46_4160(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1꫶SS𑲥。ᷘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1꫶SS𑲥。ᷘ', strict=True)

    def test_uts46_4161(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1꫶ss𑲥。ᷘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1꫶ss𑲥。ᷘ', strict=True)

    def test_uts46_4162(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ss-ir6ln166b.xn--weg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ss-ir6ln166b.xn--weg', strict=True)

    def test_uts46_4163(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-qfa2471kdb0d.xn--weg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-qfa2471kdb0d.xn--weg', strict=True)

    def test_uts46_4164(self):
        self.assertRaises(idna.IDNAError, idna.decode, '１꫶SS𑲥｡ᷘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '１꫶SS𑲥｡ᷘ', strict=True)

    def test_uts46_4165(self):
        self.assertRaises(idna.IDNAError, idna.decode, '１꫶ss𑲥｡ᷘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '１꫶ss𑲥｡ᷘ', strict=True)

    def test_uts46_4166(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1꫶Ss𑲥。ᷘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1꫶Ss𑲥。ᷘ', strict=True)

    def test_uts46_4167(self):
        self.assertRaises(idna.IDNAError, idna.decode, '１꫶Ss𑲥｡ᷘ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '１꫶Ss𑲥｡ᷘ', strict=True)

    def test_uts46_4168(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U0006bda9\U0001eaaf್｡ݼ⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U0006bda9\U0001eaaf್｡ݼ⒈', strict=True)

    def test_uts46_4169(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U0006bda9\U0001eaaf್。ݼ1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U0006bda9\U0001eaaf್。ݼ1.', strict=True)

    def test_uts46_4170(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8tc9875v5is1a.xn--1-g6c.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8tc9875v5is1a.xn--1-g6c.', strict=True)

    def test_uts46_4171(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8tc969gzn94a4lm8a.xn--1-g6c.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8tc969gzn94a4lm8a.xn--1-g6c.', strict=True)

    def test_uts46_4172(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8tc9875v5is1a.xn--dqb689l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8tc9875v5is1a.xn--dqb689l', strict=True)

    def test_uts46_4173(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8tc969gzn94a4lm8a.xn--dqb689l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8tc969gzn94a4lm8a.xn--dqb689l', strict=True)

    def test_uts46_4174(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᪶．𞤳\U00093896\U000bb252ߗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᪶．𞤳\U00093896\U000bb252ߗ', strict=True)

    def test_uts46_4175(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᪶.𞤳\U00093896\U000bb252ߗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᪶.𞤳\U00093896\U000bb252ߗ', strict=True)

    def test_uts46_4176(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᪶.𞤑\U00093896\U000bb252ߗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᪶.𞤑\U00093896\U000bb252ߗ', strict=True)

    def test_uts46_4177(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zqf.xn--ysb9657vuiz5bj0ep', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zqf.xn--ysb9657vuiz5bj0ep', strict=True)

    def test_uts46_4178(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᪶．𞤑\U00093896\U000bb252ߗ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᪶．𞤑\U00093896\U000bb252ߗ', strict=True)

    def test_uts46_4179(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࡂ\U0001ea5a⒈．\U000e0b0c８\U0008fccfݰ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࡂ\U0001ea5a⒈．\U000e0b0c８\U0008fccfݰ', strict=True)

    def test_uts46_4180(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࡂ\U0001ea5a1..\U000e0b0c8\U0008fccfݰ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࡂ\U0001ea5a1..\U000e0b0c8\U0008fccfݰ', strict=True)

    def test_uts46_4181(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-rid26318a..xn--8-s5c22427ox454a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-rid26318a..xn--8-s5c22427ox454a', strict=True)

    def test_uts46_4182(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0vb095ldg52a.xn--8-s5c22427ox454a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0vb095ldg52a.xn--8-s5c22427ox454a', strict=True)

    def test_uts46_4183(self):
        self.assertRaises(idna.IDNAError, idna.decode, '͡𐫫ͩᡷ。-\U000e0c1b鞰', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '͡𐫫ͩᡷ。-\U000e0c1b鞰', strict=True)

    def test_uts46_4184(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cvaq482npv5t.xn----yg7dt1332g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cvaq482npv5t.xn----yg7dt1332g', strict=True)

    def test_uts46_4185(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.્剘ß𐫃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.્剘ß𐫃', strict=True)

    def test_uts46_4186(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.્剘SS𐫃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.્剘SS𐫃', strict=True)

    def test_uts46_4187(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.્剘ss𐫃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.્剘ss𐫃', strict=True)

    def test_uts46_4188(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.્剘Ss𐫃', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.્剘Ss𐫃', strict=True)

    def test_uts46_4189(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--ss-bqg4734erywk', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--ss-bqg4734erywk', strict=True)

    def test_uts46_4190(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--zca791c493duf8i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--zca791c493duf8i', strict=True)

    def test_uts46_4191(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣻ\U0001ed78｡-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣻ\U0001ed78｡-', strict=True)

    def test_uts46_4192(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࣻ\U0001ed78。-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࣻ\U0001ed78。-', strict=True)

    def test_uts46_4193(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b1b2719v.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b1b2719v.-', strict=True)

    def test_uts46_4194(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈\U000e023b𐹲｡≠\u0603𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈\U000e023b𐹲｡≠\u0603𐹽', strict=True)

    def test_uts46_4195(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒈\U000e023b𐹲｡≠\u0603𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒈\U000e023b𐹲｡≠\u0603𐹽', strict=True)

    def test_uts46_4196(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.\U000e023b𐹲。≠\u0603𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.\U000e023b𐹲。≠\u0603𐹽', strict=True)

    def test_uts46_4197(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.\U000e023b𐹲。≠\u0603𐹽', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.\U000e023b𐹲。≠\u0603𐹽', strict=True)

    def test_uts46_4198(self):
        self.assertRaises(idna.IDNAError, idna.decode, '1.xn--qo0dl3077c.xn--lfb536lb35n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '1.xn--qo0dl3077c.xn--lfb536lb35n', strict=True)

    def test_uts46_4199(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tshw766f1153g.xn--lfb536lb35n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tshw766f1153g.xn--lfb536lb35n', strict=True)

    def test_uts46_4200(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹢\U000e021aႮ\u200c.㖾𐹡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹢\U000e021aႮ\u200c.㖾𐹡', strict=True)

    def test_uts46_4201(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹢\U000e021aⴎ\u200c.㖾𐹡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹢\U000e021aⴎ\u200c.㖾𐹡', strict=True)

    def test_uts46_4202(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5kjx323em053g.xn--pelu572d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5kjx323em053g.xn--pelu572d', strict=True)

    def test_uts46_4203(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug342clq0pqxv4i.xn--pelu572d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug342clq0pqxv4i.xn--pelu572d', strict=True)

    def test_uts46_4204(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mnd9001km0o0g.xn--pelu572d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mnd9001km0o0g.xn--pelu572d', strict=True)

    def test_uts46_4205(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mnd289ezj4pqxp0i.xn--pelu572d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mnd289ezj4pqxp0i.xn--pelu572d', strict=True)

    def test_uts46_4206(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a9f17．߇ᡖႳႧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a9f17．߇ᡖႳႧ', strict=True)

    def test_uts46_4207(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a9f17.߇ᡖႳႧ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a9f17.߇ᡖႳႧ', strict=True)

    def test_uts46_4208(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a9f17.߇ᡖⴓⴇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a9f17.߇ᡖⴓⴇ', strict=True)

    def test_uts46_4209(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--te28c.xn--isb295fbtpmb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--te28c.xn--isb295fbtpmb', strict=True)

    def test_uts46_4210(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a9f17．߇ᡖⴓⴇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a9f17．߇ᡖⴓⴇ', strict=True)

    def test_uts46_4211(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--te28c.xn--isb856b9a631d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--te28c.xn--isb856b9a631d', strict=True)

    def test_uts46_4212(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a9f17.߇ᡖႳⴇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a9f17.߇ᡖႳⴇ', strict=True)

    def test_uts46_4213(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--te28c.xn--isb286btrgo7w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--te28c.xn--isb286btrgo7w', strict=True)

    def test_uts46_4214(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a9f17．߇ᡖႳⴇ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a9f17．߇ᡖႳⴇ', strict=True)

    def test_uts46_4215(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200d\U00105349.ڳݵ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200d\U00105349.ڳݵ', strict=True)

    def test_uts46_4216(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3j78f.xn--mkb20b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3j78f.xn--mkb20b', strict=True)

    def test_uts46_4217(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1ug39444n.xn--mkb20b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1ug39444n.xn--mkb20b', strict=True)

    def test_uts46_4218(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00032931⒛⾳．ꡦ⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00032931⒛⾳．ꡦ⒈', strict=True)

    def test_uts46_4219(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0003293120.音.ꡦ1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0003293120.音.ꡦ1.', strict=True)

    def test_uts46_4220(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--20-9802c.xn--0w5a.xn--1-eg4e.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--20-9802c.xn--0w5a.xn--1-eg4e.', strict=True)

    def test_uts46_4221(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dth6033bzbvx.xn--tsh9439b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dth6033bzbvx.xn--tsh9439b', strict=True)

    def test_uts46_4222(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߜ８\U00073993-｡\U0009ec99𑁿𐩥্', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߜ８\U00073993-｡\U0009ec99𑁿𐩥্', strict=True)

    def test_uts46_4223(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߜ8\U00073993-。\U0009ec99𑁿𐩥্', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߜ8\U00073993-。\U0009ec99𑁿𐩥্', strict=True)

    def test_uts46_4224(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--8--rve13079p.xn--b7b9842k42df776x', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--8--rve13079p.xn--b7b9842k42df776x', strict=True)

    def test_uts46_4225(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ。۰≮ß݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ。۰≮ß݅', strict=True)

    def test_uts46_4226(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ。۰≮ß݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ。۰≮ß݅', strict=True)

    def test_uts46_4227(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴕ。۰≮ß݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴕ。۰≮ß݅', strict=True)

    def test_uts46_4228(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴕ。۰≮ß݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴕ。۰≮ß݅', strict=True)

    def test_uts46_4229(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ。۰≮SS݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ。۰≮SS݅', strict=True)

    def test_uts46_4230(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ。۰≮SS݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ。۰≮SS݅', strict=True)

    def test_uts46_4231(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴕ。۰≮ss݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴕ。۰≮ss݅', strict=True)

    def test_uts46_4232(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴕ。۰≮ss݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴕ。۰≮ss݅', strict=True)

    def test_uts46_4233(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ。۰≮Ss݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ。۰≮Ss݅', strict=True)

    def test_uts46_4234(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ。۰≮Ss݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ。۰≮Ss݅', strict=True)

    def test_uts46_4235(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dlj.xn--ss-jbe65aw27i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dlj.xn--ss-jbe65aw27i', strict=True)

    def test_uts46_4236(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴕ.۰≮ss݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴕ.۰≮ss݅', strict=True)

    def test_uts46_4237(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴕ.۰≮ss݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴕ.۰≮ss݅', strict=True)

    def test_uts46_4238(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ.۰≮SS݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ.۰≮SS݅', strict=True)

    def test_uts46_4239(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ.۰≮SS݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ.۰≮SS݅', strict=True)

    def test_uts46_4240(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ.۰≮Ss݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ.۰≮Ss݅', strict=True)

    def test_uts46_4241(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴕ.۰≮Ss݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴕ.۰≮Ss݅', strict=True)

    def test_uts46_4242(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dlj.xn--zca912alh227g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dlj.xn--zca912alh227g', strict=True)

    def test_uts46_4243(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴕ.۰≮ß݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴕ.۰≮ß݅', strict=True)

    def test_uts46_4244(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴕ.۰≮ß݅', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴕ.۰≮ß݅', strict=True)

    def test_uts46_4245(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tnd.xn--ss-jbe65aw27i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tnd.xn--ss-jbe65aw27i', strict=True)

    def test_uts46_4246(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tnd.xn--zca912alh227g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tnd.xn--zca912alh227g', strict=True)

    def test_uts46_4247(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ߩ-.𝨗꒱᭲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ߩ-.𝨗꒱᭲', strict=True)

    def test_uts46_4248(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----odd.xn--dwf8994dc8wj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----odd.xn--dwf8994dc8wj', strict=True)

    def test_uts46_4249(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ef38\u200c.≯䕵⫧', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ef38\u200c.≯䕵⫧', strict=True)

    def test_uts46_4250(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001ef38\u200c.≯䕵⫧', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001ef38\u200c.≯䕵⫧', strict=True)

    def test_uts46_4251(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--sn7h.xn--hdh754ax6w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--sn7h.xn--hdh754ax6w', strict=True)

    def test_uts46_4252(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugx453p.xn--hdh754ax6w', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugx453p.xn--hdh754ax6w', strict=True)

    def test_uts46_4253(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨅ßﱗ.ڬ۳︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨅ßﱗ.ڬ۳︒', strict=True)

    def test_uts46_4254(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨅ßيخ.ڬ۳。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨅ßيخ.ڬ۳。', strict=True)

    def test_uts46_4255(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨅SSيخ.ڬ۳。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨅SSيخ.ڬ۳。', strict=True)

    def test_uts46_4256(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨅ssيخ.ڬ۳。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨅ssيخ.ڬ۳。', strict=True)

    def test_uts46_4257(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨅Ssيخ.ڬ۳。', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨅Ssيخ.ڬ۳。', strict=True)

    def test_uts46_4258(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-ytd5i7765l.xn--fkb6l.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-ytd5i7765l.xn--fkb6l.', strict=True)

    def test_uts46_4259(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca23yncs877j.xn--fkb6l.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca23yncs877j.xn--fkb6l.', strict=True)

    def test_uts46_4260(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨅SSﱗ.ڬ۳︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨅SSﱗ.ڬ۳︒', strict=True)

    def test_uts46_4261(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨅ssﱗ.ڬ۳︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨅ssﱗ.ڬ۳︒', strict=True)

    def test_uts46_4262(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐨅Ssﱗ.ڬ۳︒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐨅Ssﱗ.ڬ۳︒', strict=True)

    def test_uts46_4263(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-ytd5i7765l.xn--fkb6lp314e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-ytd5i7765l.xn--fkb6lp314e', strict=True)

    def test_uts46_4264(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca23yncs877j.xn--fkb6lp314e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca23yncs877j.xn--fkb6lp314e', strict=True)

    def test_uts46_4265(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≮🡒᳭.\U0004fffeႡܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≮🡒᳭.\U0004fffeႡܔ', strict=True)

    def test_uts46_4266(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≮🡒᳭.\U0004fffeႡܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≮🡒᳭.\U0004fffeႡܔ', strict=True)

    def test_uts46_4267(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≮🡒᳭.\U0004fffeⴁܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≮🡒᳭.\U0004fffeⴁܔ', strict=True)

    def test_uts46_4268(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-≮🡒᳭.\U0004fffeⴁܔ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-≮🡒᳭.\U0004fffeⴁܔ', strict=True)

    def test_uts46_4269(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----44l04zxt68c.xn--enb135qf106f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----44l04zxt68c.xn--enb135qf106f', strict=True)

    def test_uts46_4270(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----44l04zxt68c.xn--enb300c1597h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----44l04zxt68c.xn--enb300c1597h', strict=True)

    def test_uts46_4271(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤨｡ꡏ\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤨｡ꡏ\u200d\u200c', strict=True)

    def test_uts46_4272(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤨。ꡏ\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤨。ꡏ\u200d\u200c', strict=True)

    def test_uts46_4273(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤆。ꡏ\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤆。ꡏ\u200d\u200c', strict=True)

    def test_uts46_4274(self):
        self.assertEqual(idna.decode('xn--ge6h.xn--oc9a', uts46=True, strict=True), '𞤨.ꡏ')
        self.assertEqual(idna.encode('xn--ge6h.xn--oc9a', uts46=True, strict=True), b'xn--ge6h.xn--oc9a')

    def test_uts46_4275(self):
        self.assertEqual(idna.decode('𞤨.ꡏ', uts46=True, strict=True), '𞤨.ꡏ')
        self.assertEqual(idna.encode('𞤨.ꡏ', uts46=True, strict=True), b'xn--ge6h.xn--oc9a')

    def test_uts46_4276(self):
        self.assertEqual(idna.decode('𞤆.ꡏ', uts46=True, strict=True), '𞤨.ꡏ')
        self.assertEqual(idna.encode('𞤆.ꡏ', uts46=True, strict=True), b'xn--ge6h.xn--oc9a')

    def test_uts46_4277(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ge6h.xn--0ugb9575h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ge6h.xn--0ugb9575h', strict=True)

    def test_uts46_4278(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𞤆｡ꡏ\u200d\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𞤆｡ꡏ\u200d\u200c', strict=True)

    def test_uts46_4279(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅹𑂶．ᢌ𑂹٩', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅹𑂶．ᢌ𑂹٩', strict=True)

    def test_uts46_4280(self):
        self.assertRaises(idna.IDNAError, idna.decode, '󠅹𑂶.ᢌ𑂹٩', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '󠅹𑂶.ᢌ𑂹٩', strict=True)

    def test_uts46_4281(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--b50d.xn--iib993gyp5p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--b50d.xn--iib993gyp5p', strict=True)

    def test_uts46_4282(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ󠅺\U0005dd52。≯⾑', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ󠅺\U0005dd52。≯⾑', strict=True)

    def test_uts46_4283(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ󠅺\U0005dd52。≯⾑', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ󠅺\U0005dd52。≯⾑', strict=True)

    def test_uts46_4284(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ󠅺\U0005dd52。≯襾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ󠅺\U0005dd52。≯襾', strict=True)

    def test_uts46_4285(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⅎ󠅺\U0005dd52。≯襾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⅎ󠅺\U0005dd52。≯襾', strict=True)

    def test_uts46_4286(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ󠅺\U0005dd52。≯襾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ󠅺\U0005dd52。≯襾', strict=True)

    def test_uts46_4287(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ󠅺\U0005dd52。≯襾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ󠅺\U0005dd52。≯襾', strict=True)

    def test_uts46_4288(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--73g39298c.xn--hdhz171b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--73g39298c.xn--hdhz171b', strict=True)

    def test_uts46_4289(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ󠅺\U0005dd52。≯⾑', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ󠅺\U0005dd52。≯⾑', strict=True)

    def test_uts46_4290(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⅎ󠅺\U0005dd52。≯⾑', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⅎ󠅺\U0005dd52。≯⾑', strict=True)

    def test_uts46_4291(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--f3g73398c.xn--hdhz171b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--f3g73398c.xn--hdhz171b', strict=True)

    def test_uts46_4292(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς\u200dු٠｡-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς\u200dු٠｡-', strict=True)

    def test_uts46_4293(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς\u200dු٠。-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς\u200dු٠。-', strict=True)

    def test_uts46_4294(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ\u200dු٠。-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ\u200dු٠。-', strict=True)

    def test_uts46_4295(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ\u200dු٠。-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ\u200dු٠。-', strict=True)

    def test_uts46_4296(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa25ks2j.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa25ks2j.-', strict=True)

    def test_uts46_4297(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa25ks2jenu.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa25ks2jenu.-', strict=True)

    def test_uts46_4298(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa45ks2jenu.-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa45ks2jenu.-', strict=True)

    def test_uts46_4299(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ\u200dු٠｡-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ\u200dු٠｡-', strict=True)

    def test_uts46_4300(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ\u200dු٠｡-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ\u200dු٠｡-', strict=True)

    def test_uts46_4301(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c.ßႩ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c.ßႩ-', strict=True)

    def test_uts46_4302(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c.ßⴉ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c.ßⴉ-', strict=True)

    def test_uts46_4303(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c.SSႩ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c.SSႩ-', strict=True)

    def test_uts46_4304(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c.ssⴉ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c.ssⴉ-', strict=True)

    def test_uts46_4305(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c.Ssⴉ-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c.Ssⴉ-', strict=True)

    def test_uts46_4306(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--ss--bi1b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--ss--bi1b', strict=True)

    def test_uts46_4307(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--ss--bi1b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--ss--bi1b', strict=True)

    def test_uts46_4308(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn----pfa2305a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn----pfa2305a', strict=True)

    def test_uts46_4309(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--ss--4rn', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--ss--4rn', strict=True)

    def test_uts46_4310(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--ss--4rn', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--ss--4rn', strict=True)

    def test_uts46_4311(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn----pfa042j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn----pfa042j', strict=True)

    def test_uts46_4312(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cdb72𐫍㓱。⾑', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cdb72𐫍㓱。⾑', strict=True)

    def test_uts46_4313(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000cdb72𐫍㓱。襾', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000cdb72𐫍㓱。襾', strict=True)

    def test_uts46_4314(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--u7kt691dlj09f.xn--9v2a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--u7kt691dlj09f.xn--9v2a', strict=True)

    def test_uts46_4315(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڠ𐮋𐹰≮。≯\U000e0997\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڠ𐮋𐹰≮。≯\U000e0997\u200d', strict=True)

    def test_uts46_4316(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ڠ𐮋𐹰≮。≯\U000e0997\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ڠ𐮋𐹰≮。≯\U000e0997\u200d', strict=True)

    def test_uts46_4317(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2jb053lf13nyoc.xn--hdh08821l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2jb053lf13nyoc.xn--hdh08821l', strict=True)

    def test_uts46_4318(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2jb053lf13nyoc.xn--1ugx6gc8096c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2jb053lf13nyoc.xn--1ugx6gc8096c', strict=True)

    def test_uts46_4319(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟞｡\U00043c36ݷࢰ⩋', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟞｡\U00043c36ݷࢰ⩋', strict=True)

    def test_uts46_4320(self):
        self.assertRaises(idna.IDNAError, idna.decode, '6。\U00043c36ݷࢰ⩋', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '6。\U00043c36ݷࢰ⩋', strict=True)

    def test_uts46_4321(self):
        self.assertRaises(idna.IDNAError, idna.decode, '6.xn--7pb04do15eq748f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '6.xn--7pb04do15eq748f', strict=True)

    def test_uts46_4322(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ﳽ。𑇀𑍴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ﳽ。𑇀𑍴', strict=True)

    def test_uts46_4323(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-ﳽ。𑇀𑍴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-ﳽ。𑇀𑍴', strict=True)

    def test_uts46_4324(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-شى。𑇀𑍴', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-شى。𑇀𑍴', strict=True)

    def test_uts46_4325(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----qnc7d.xn--wd1d62a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----qnc7d.xn--wd1d62a', strict=True)

    def test_uts46_4326(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000e02b6𝟏.ൃ\U000aa950𐹬\U000ca4f6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000e02b6𝟏.ൃ\U000aa950𐹬\U000ca4f6', strict=True)

    def test_uts46_4327(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000e02b61.ൃ\U000aa950𐹬\U000ca4f6', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000e02b61.ൃ\U000aa950𐹬\U000ca4f6', strict=True)

    def test_uts46_4328(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-f521m.xn--mxc0872kcu37dnmem', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-f521m.xn--mxc0872kcu37dnmem', strict=True)

    def test_uts46_4329(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1-rgnu0071n.xn--mxc0872kcu37dnmem', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1-rgnu0071n.xn--mxc0872kcu37dnmem', strict=True)

    def test_uts46_4330(self):
        self.assertEqual(idna.decode('齙--𝟰.ß', uts46=True, strict=True), '齙--4.ß')
        self.assertEqual(idna.encode('齙--𝟰.ß', uts46=True, strict=True), b'xn----4-p16k.xn--zca')

    def test_uts46_4331(self):
        self.assertEqual(idna.decode('齙--4.ß', uts46=True, strict=True), '齙--4.ß')
        self.assertEqual(idna.encode('齙--4.ß', uts46=True, strict=True), b'xn----4-p16k.xn--zca')

    def test_uts46_4332(self):
        self.assertEqual(idna.decode('齙--4.SS', uts46=True, strict=True), '齙--4.ss')
        self.assertEqual(idna.encode('齙--4.SS', uts46=True, strict=True), b'xn----4-p16k.ss')

    def test_uts46_4333(self):
        self.assertEqual(idna.decode('齙--4.ss', uts46=True, strict=True), '齙--4.ss')
        self.assertEqual(idna.encode('齙--4.ss', uts46=True, strict=True), b'xn----4-p16k.ss')

    def test_uts46_4334(self):
        self.assertEqual(idna.decode('齙--4.Ss', uts46=True, strict=True), '齙--4.ss')
        self.assertEqual(idna.encode('齙--4.Ss', uts46=True, strict=True), b'xn----4-p16k.ss')

    def test_uts46_4335(self):
        self.assertEqual(idna.decode('xn----4-p16k.ss', uts46=True, strict=True), '齙--4.ss')
        self.assertEqual(idna.encode('xn----4-p16k.ss', uts46=True, strict=True), b'xn----4-p16k.ss')

    def test_uts46_4336(self):
        self.assertEqual(idna.decode('xn----4-p16k.xn--zca', uts46=True, strict=True), '齙--4.ß')
        self.assertEqual(idna.encode('xn----4-p16k.xn--zca', uts46=True, strict=True), b'xn----4-p16k.xn--zca')

    def test_uts46_4337(self):
        self.assertEqual(idna.decode('齙--𝟰.SS', uts46=True, strict=True), '齙--4.ss')
        self.assertEqual(idna.encode('齙--𝟰.SS', uts46=True, strict=True), b'xn----4-p16k.ss')

    def test_uts46_4338(self):
        self.assertEqual(idna.decode('齙--𝟰.ss', uts46=True, strict=True), '齙--4.ss')
        self.assertEqual(idna.encode('齙--𝟰.ss', uts46=True, strict=True), b'xn----4-p16k.ss')

    def test_uts46_4339(self):
        self.assertEqual(idna.decode('齙--𝟰.Ss', uts46=True, strict=True), '齙--4.ss')
        self.assertEqual(idna.encode('齙--𝟰.Ss', uts46=True, strict=True), b'xn----4-p16k.ss')

    def test_uts46_4340(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᯲.𐹢𞀖\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᯲.𐹢𞀖\u200c', strict=True)

    def test_uts46_4341(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0zf.xn--9n0d2296a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0zf.xn--9n0d2296a', strict=True)

    def test_uts46_4342(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0zf.xn--0ug9894grqqf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0zf.xn--0ug9894grqqf', strict=True)

    def test_uts46_4343(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000c3c99\U000e02d8｡?-\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000c3c99\U000e02d8｡?-\u200d', strict=True)

    def test_uts46_4344(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000c3c99\U000e02d8。?-\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000c3c99\U000e02d8。?-\u200d', strict=True)

    def test_uts46_4345(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ct86d8w51a.?-', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ct86d8w51a.?-', strict=True)

    def test_uts46_4346(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ct86d8w51a.xn--?--n1t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ct86d8w51a.xn--?--n1t', strict=True)

    def test_uts46_4347(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ct86d8w51a.?-\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ct86d8w51a.?-\u200d', strict=True)

    def test_uts46_4348(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'XN--CT86D8W51A.?-\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'XN--CT86D8W51A.?-\u200d', strict=True)

    def test_uts46_4349(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Xn--Ct86d8w51a.?-\u200d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Xn--Ct86d8w51a.?-\u200d', strict=True)

    def test_uts46_4350(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᩠．\U0001ed77-𝪩悎', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᩠．\U0001ed77-𝪩悎', strict=True)

    def test_uts46_4351(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᩠.\U0001ed77-𝪩悎', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᩠.\U0001ed77-𝪩悎', strict=True)

    def test_uts46_4352(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--jof.xn----gf4bq282iezpa', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--jof.xn----gf4bq282iezpa', strict=True)

    def test_uts46_4353(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001b72f\U000e029b．𞤳\U0004f97e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001b72f\U000e029b．𞤳\U0004f97e', strict=True)

    def test_uts46_4354(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001b72f\U000e029b.𞤳\U0004f97e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001b72f\U000e029b.𞤳\U0004f97e', strict=True)

    def test_uts46_4355(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001b72f\U000e029b.𞤑\U0004f97e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001b72f\U000e029b.𞤑\U0004f97e', strict=True)

    def test_uts46_4356(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--xx5gy2741c.xn--re6hw266j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--xx5gy2741c.xn--re6hw266j', strict=True)

    def test_uts46_4357(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U0001b72f\U000e029b．𞤑\U0004f97e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U0001b72f\U000e029b．𞤑\U0004f97e', strict=True)

    def test_uts46_4358(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ܜ𐫒خ.𐋲', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ܜ𐫒خ.𐋲', strict=True)

    def test_uts46_4359(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--tgb98b8643d.xn--m97c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--tgb98b8643d.xn--m97c', strict=True)

    def test_uts46_4360(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐼑𞤓ط\u08e2.?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐼑𞤓ط\u08e2.?', strict=True)

    def test_uts46_4361(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐼑𞤵ط\u08e2.?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐼑𞤵ط\u08e2.?', strict=True)

    def test_uts46_4362(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--2gb08k9w69agm0g.?', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--2gb08k9w69agm0g.?', strict=True)

    def test_uts46_4363(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ↄ。᳔੍\U0001ede3', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ↄ。᳔੍\U0001ede3', strict=True)

    def test_uts46_4364(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ↄ。᳔੍\U0001ede3', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ↄ。᳔੍\U0001ede3', strict=True)

    def test_uts46_4365(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ↄ。᳔੍\U0001ede3', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ↄ。᳔੍\U0001ede3', strict=True)

    def test_uts46_4366(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--r5g.xn--ybc995g0835a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--r5g.xn--ybc995g0835a', strict=True)

    def test_uts46_4367(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ↄ。᳔੍\U0001ede3', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ↄ。᳔੍\U0001ede3', strict=True)

    def test_uts46_4368(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--q5g.xn--ybc995g0835a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--q5g.xn--ybc995g0835a', strict=True)

    def test_uts46_4369(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0aa2-。\U0009b08f≮𑜫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0aa2-。\U0009b08f≮𑜫', strict=True)

    def test_uts46_4370(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000e0aa2-。\U0009b08f≮𑜫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000e0aa2-。\U0009b08f≮𑜫', strict=True)

    def test_uts46_4371(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----bh61m.xn--gdhz157g0em1d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----bh61m.xn--gdhz157g0em1d', strict=True)

    def test_uts46_4372(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000e0279\u200d。\U0008cfe7≮Ⴉ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000e0279\u200d。\U0008cfe7≮Ⴉ', strict=True)

    def test_uts46_4373(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000e0279\u200d。\U0008cfe7≮Ⴉ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000e0279\u200d。\U0008cfe7≮Ⴉ', strict=True)

    def test_uts46_4374(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000e0279\u200d。\U0008cfe7≮ⴉ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000e0279\u200d。\U0008cfe7≮ⴉ', strict=True)

    def test_uts46_4375(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\U000e0279\u200d。\U0008cfe7≮ⴉ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\U000e0279\u200d。\U0008cfe7≮ⴉ', strict=True)

    def test_uts46_4376(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3n36e.xn--gdh992byu01p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3n36e.xn--gdh992byu01p', strict=True)

    def test_uts46_4377(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugc90904y.xn--gdh992byu01p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugc90904y.xn--gdh992byu01p', strict=True)

    def test_uts46_4378(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3n36e.xn--hnd112gpz83n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3n36e.xn--hnd112gpz83n', strict=True)

    def test_uts46_4379(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ugc90904y.xn--hnd112gpz83n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ugc90904y.xn--hnd112gpz83n', strict=True)

    def test_uts46_4380(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹯-𑄴ࢼ。︒䖐⾆', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹯-𑄴ࢼ。︒䖐⾆', strict=True)

    def test_uts46_4381(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹯-𑄴ࢼ。。䖐舌', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹯-𑄴ࢼ。。䖐舌', strict=True)

    def test_uts46_4382(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----rpd7902rclc..xn--fpo216m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----rpd7902rclc..xn--fpo216m', strict=True)

    def test_uts46_4383(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----rpd7902rclc.xn--fpo216mn07e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----rpd7902rclc.xn--fpo216mn07e', strict=True)

    def test_uts46_4384(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪞Ⴐ｡쪡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪞Ⴐ｡쪡', strict=True)

    def test_uts46_4385(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪞Ⴐ｡쪡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪞Ⴐ｡쪡', strict=True)

    def test_uts46_4386(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪞Ⴐ。쪡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪞Ⴐ。쪡', strict=True)

    def test_uts46_4387(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪞Ⴐ。쪡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪞Ⴐ。쪡', strict=True)

    def test_uts46_4388(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪞ⴐ。쪡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪞ⴐ。쪡', strict=True)

    def test_uts46_4389(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪞ⴐ。쪡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪞ⴐ。쪡', strict=True)

    def test_uts46_4390(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--7kj1858k.xn--pi6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--7kj1858k.xn--pi6b', strict=True)

    def test_uts46_4391(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪞ⴐ｡쪡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪞ⴐ｡쪡', strict=True)

    def test_uts46_4392(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝪞ⴐ｡쪡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝪞ⴐ｡쪡', strict=True)

    def test_uts46_4393(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ond3755u.xn--pi6b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ond3755u.xn--pi6b', strict=True)

    def test_uts46_4394(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ฺ쩁𐹬.\U0010b273', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ฺ쩁𐹬.\U0010b273', strict=True)

    def test_uts46_4395(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ฺ쩁𐹬.\U0010b273', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ฺ쩁𐹬.\U0010b273', strict=True)

    def test_uts46_4396(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--o4c4837g2zvb.xn--5f70g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--o4c4837g2zvb.xn--5f70g', strict=True)

    def test_uts46_4397(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡅ０\u200c｡⎢\U000e4a04', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡅ０\u200c｡⎢\U000e4a04', strict=True)

    def test_uts46_4398(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡅ0\u200c。⎢\U000e4a04', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡅ0\u200c。⎢\U000e4a04', strict=True)

    def test_uts46_4399(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0-z6j.xn--8lh28773l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0-z6j.xn--8lh28773l', strict=True)

    def test_uts46_4400(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0-z6jy93b.xn--8lh28773l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0-z6jy93b.xn--8lh28773l', strict=True)

    def test_uts46_4401(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00032b9a９ꍩ៓．\u200dß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00032b9a９ꍩ៓．\u200dß', strict=True)

    def test_uts46_4402(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00032b9a9ꍩ៓.\u200dß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00032b9a9ꍩ៓.\u200dß', strict=True)

    def test_uts46_4403(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00032b9a9ꍩ៓.\u200dSS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00032b9a9ꍩ៓.\u200dSS', strict=True)

    def test_uts46_4404(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00032b9a9ꍩ៓.\u200dss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00032b9a9ꍩ៓.\u200dss', strict=True)

    def test_uts46_4405(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-i0j5967eg3qz.ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-i0j5967eg3qz.ss', strict=True)

    def test_uts46_4406(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-i0j5967eg3qz.xn--ss-l1t', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-i0j5967eg3qz.xn--ss-l1t', strict=True)

    def test_uts46_4407(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9-i0j5967eg3qz.xn--zca770n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9-i0j5967eg3qz.xn--zca770n', strict=True)

    def test_uts46_4408(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00032b9a９ꍩ៓．\u200dSS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00032b9a９ꍩ៓．\u200dSS', strict=True)

    def test_uts46_4409(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00032b9a９ꍩ៓．\u200dss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00032b9a９ꍩ៓．\u200dss', strict=True)

    def test_uts46_4410(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00032b9a9ꍩ៓.\u200dSs', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00032b9a9ꍩ៓.\u200dSs', strict=True)

    def test_uts46_4411(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00032b9a９ꍩ៓．\u200dSs', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00032b9a９ꍩ៓．\u200dSs', strict=True)

    def test_uts46_4412(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꗷ𑆀.ݝ𐩒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꗷ𑆀.ݝ𐩒', strict=True)

    def test_uts46_4413(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ju8a625r.xn--hpb0073k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ju8a625r.xn--hpb0073k', strict=True)

    def test_uts46_4414(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒐≯-。︒\U000a9463-\U0005e6e0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒐≯-。︒\U000a9463-\U0005e6e0', strict=True)

    def test_uts46_4415(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⒐≯-。︒\U000a9463-\U0005e6e0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⒐≯-。︒\U000a9463-\U0005e6e0', strict=True)

    def test_uts46_4416(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.≯-。。\U000a9463-\U0005e6e0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.≯-。。\U000a9463-\U0005e6e0', strict=True)

    def test_uts46_4417(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.≯-。。\U000a9463-\U0005e6e0', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.≯-。。\U000a9463-\U0005e6e0', strict=True)

    def test_uts46_4418(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.xn----ogo..xn----xj54d1s69k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.xn----ogo..xn----xj54d1s69k', strict=True)

    def test_uts46_4419(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----ogot9g.xn----n89hl0522az9u2a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----ogot9g.xn----n89hl0522az9u2a', strict=True)

    def test_uts46_4420(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00088a9aೣჁ\U000e088f．؝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00088a9aೣჁ\U000e088f．؝', strict=True)

    def test_uts46_4421(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00088a9aೣჁ\U000e088f.؝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00088a9aೣჁ\U000e088f.؝', strict=True)

    def test_uts46_4422(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00088a9aೣⴡ\U000e088f.؝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00088a9aೣⴡ\U000e088f.؝', strict=True)

    def test_uts46_4423(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vuc226n8n28lmju7a.xn--cgb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vuc226n8n28lmju7a.xn--cgb', strict=True)

    def test_uts46_4424(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00088a9aೣⴡ\U000e088f．؝', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00088a9aೣⴡ\U000e088f．؝', strict=True)

    def test_uts46_4425(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--vuc49qvu85xmju7a.xn--cgb', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--vuc49qvu85xmju7a.xn--cgb', strict=True)

    def test_uts46_4426(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᷫ。𐋩ظ-𐫮', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᷫ。𐋩ظ-𐫮', strict=True)

    def test_uts46_4427(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--gfg.xn----xnc0815qyyg', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--gfg.xn----xnc0815qyyg', strict=True)

    def test_uts46_4428(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。⾇𐳋Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。⾇𐳋Ⴝ', strict=True)

    def test_uts46_4429(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。⾇𐳋Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。⾇𐳋Ⴝ', strict=True)

    def test_uts46_4430(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。舛𐳋Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。舛𐳋Ⴝ', strict=True)

    def test_uts46_4431(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。舛𐳋Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。舛𐳋Ⴝ', strict=True)

    def test_uts46_4432(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。舛𐳋ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。舛𐳋ⴝ', strict=True)

    def test_uts46_4433(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。舛𐳋ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。舛𐳋ⴝ', strict=True)

    def test_uts46_4434(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。舛𐲋Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。舛𐲋Ⴝ', strict=True)

    def test_uts46_4435(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。舛𐲋Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。舛𐲋Ⴝ', strict=True)

    def test_uts46_4436(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。舛𐲋ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。舛𐲋ⴝ', strict=True)

    def test_uts46_4437(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。舛𐲋ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。舛𐲋ⴝ', strict=True)

    def test_uts46_4438(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9u4b.xn--llj123yh74e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9u4b.xn--llj123yh74e', strict=True)

    def test_uts46_4439(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。⾇𐳋ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。⾇𐳋ⴝ', strict=True)

    def test_uts46_4440(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。⾇𐳋ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。⾇𐳋ⴝ', strict=True)

    def test_uts46_4441(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。⾇𐲋Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。⾇𐲋Ⴝ', strict=True)

    def test_uts46_4442(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。⾇𐲋Ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。⾇𐲋Ⴝ', strict=True)

    def test_uts46_4443(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。⾇𐲋ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。⾇𐲋ⴝ', strict=True)

    def test_uts46_4444(self):
        self.assertRaises(idna.IDNAError, idna.decode, '싇。⾇𐲋ⴝ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '싇。⾇𐲋ⴝ', strict=True)

    def test_uts46_4445(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--9u4b.xn--1nd7519ch79d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--9u4b.xn--1nd7519ch79d', strict=True)

    def test_uts46_4446(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹠ς。\u200cڿჀ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹠ς。\u200cڿჀ', strict=True)

    def test_uts46_4447(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹠ς。\u200cڿⴠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹠ς。\u200cڿⴠ', strict=True)

    def test_uts46_4448(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹠Σ。\u200cڿჀ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹠Σ。\u200cڿჀ', strict=True)

    def test_uts46_4449(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹠σ。\u200cڿⴠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹠σ。\u200cڿⴠ', strict=True)

    def test_uts46_4450(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹠Σ。\u200cڿⴠ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹠Σ。\u200cڿⴠ', strict=True)

    def test_uts46_4451(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa9167k.xn--ykb467q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa9167k.xn--ykb467q', strict=True)

    def test_uts46_4452(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa9167k.xn--ykb760k9hj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa9167k.xn--ykb760k9hj', strict=True)

    def test_uts46_4453(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa1267k.xn--ykb760k9hj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa1267k.xn--ykb760k9hj', strict=True)

    def test_uts46_4454(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa9167k.xn--ykb632c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa9167k.xn--ykb632c', strict=True)

    def test_uts46_4455(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa9167k.xn--ykb632cvxm', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa9167k.xn--ykb632cvxm', strict=True)

    def test_uts46_4456(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa1267k.xn--ykb632cvxm', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa1267k.xn--ykb632cvxm', strict=True)

    def test_uts46_4457(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00087490\u200c\u0604.ښ-ß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00087490\u200c\u0604.ښ-ß', strict=True)

    def test_uts46_4458(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00087490\u200c\u0604.ښ-SS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00087490\u200c\u0604.ښ-SS', strict=True)

    def test_uts46_4459(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00087490\u200c\u0604.ښ-ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00087490\u200c\u0604.ښ-ss', strict=True)

    def test_uts46_4460(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U00087490\u200c\u0604.ښ-Ss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U00087490\u200c\u0604.ښ-Ss', strict=True)

    def test_uts46_4461(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mfb98261i.xn---ss-sdf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mfb98261i.xn---ss-sdf', strict=True)

    def test_uts46_4462(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mfb144kqo32m.xn---ss-sdf', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mfb144kqo32m.xn---ss-sdf', strict=True)

    def test_uts46_4463(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mfb144kqo32m.xn----qfa315b', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mfb144kqo32m.xn----qfa315b', strict=True)

    def test_uts46_4464(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\u200d឵ٺ.-ﮰ\U000c511e\U00010e1a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\u200d឵ٺ.-ﮰ\U000c511e\U00010e1a', strict=True)

    def test_uts46_4465(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\u200d឵ٺ.-ۓ\U000c511e\U00010e1a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\u200d឵ٺ.-ۓ\U000c511e\U00010e1a', strict=True)

    def test_uts46_4466(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200c\u200d឵ٺ.-ۓ\U000c511e\U00010e1a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200c\u200d឵ٺ.-ۓ\U000c511e\U00010e1a', strict=True)

    def test_uts46_4467(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zib.xn----twc1133r17r6g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zib.xn----twc1133r17r6g', strict=True)

    def test_uts46_4468(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zib502kda.xn----twc1133r17r6g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zib502kda.xn----twc1133r17r6g', strict=True)

    def test_uts46_4469(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zib539f.xn----twc1133r17r6g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zib539f.xn----twc1133r17r6g', strict=True)

    def test_uts46_4470(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zib539f8igea.xn----twc1133r17r6g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zib539f8igea.xn----twc1133r17r6g', strict=True)

    def test_uts46_4471(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a1db1｡𐮬≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a1db1｡𐮬≠', strict=True)

    def test_uts46_4472(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a1db1｡𐮬≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a1db1｡𐮬≠', strict=True)

    def test_uts46_4473(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a1db1。𐮬≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a1db1。𐮬≠', strict=True)

    def test_uts46_4474(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\U000a1db1。𐮬≠', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\U000a1db1。𐮬≠', strict=True)

    def test_uts46_4475(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--dd55c.xn--1ch3003g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--dd55c.xn--1ch3003g', strict=True)

    def test_uts46_4476(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ྲ\U0001ed85｡𐹮𐹷덝۵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ྲ\U0001ed85｡𐹮𐹷덝۵', strict=True)

    def test_uts46_4477(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ྲ\U0001ed85｡𐹮𐹷덝۵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ྲ\U0001ed85｡𐹮𐹷덝۵', strict=True)

    def test_uts46_4478(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ྲ\U0001ed85。𐹮𐹷덝۵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ྲ\U0001ed85。𐹮𐹷덝۵', strict=True)

    def test_uts46_4479(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ྲ\U0001ed85。𐹮𐹷덝۵', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ྲ\U0001ed85。𐹮𐹷덝۵', strict=True)

    def test_uts46_4480(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fgd0675v.xn--imb5839fidpcbba', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fgd0675v.xn--imb5839fidpcbba', strict=True)

    def test_uts46_4481(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴏ󠅋-．\u200dႩ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴏ󠅋-．\u200dႩ', strict=True)

    def test_uts46_4482(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ⴏ󠅋-.\u200dႩ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴏ󠅋-.\u200dႩ', strict=True)

    def test_uts46_4483(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴏ󠅋-.\u200dⴉ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴏ󠅋-.\u200dⴉ', strict=True)

    def test_uts46_4484(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----3vs.xn--0kj', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----3vs.xn--0kj', strict=True)

    def test_uts46_4485(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----3vs.xn--1ug532c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----3vs.xn--1ug532c', strict=True)

    def test_uts46_4486(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ⴏ󠅋-．\u200dⴉ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ⴏ󠅋-．\u200dⴉ', strict=True)

    def test_uts46_4487(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----00g.xn--hnd', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----00g.xn--hnd', strict=True)

    def test_uts46_4488(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----00g.xn--hnd399e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----00g.xn--hnd399e', strict=True)

    def test_uts46_4489(self):
        self.assertRaises(idna.IDNAError, idna.decode, '⇧𐨏\U000e0f88\U000efd85。\u0600\U000e0235󠆉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '⇧𐨏\U000e0f88\U000efd85。\u0600\U000e0235󠆉', strict=True)

    def test_uts46_4490(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--l8g5552g64t4g46xf.xn--ifb08144p', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--l8g5552g64t4g46xf.xn--ifb08144p', strict=True)

    def test_uts46_4491(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠𐮂.↑🄇⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠𐮂.↑🄇⒈', strict=True)

    def test_uts46_4492(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠𐮂.↑🄇⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠𐮂.↑🄇⒈', strict=True)

    def test_uts46_4493(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠𐮂.↑6,1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠𐮂.↑6,1.', strict=True)

    def test_uts46_4494(self):
        self.assertRaises(idna.IDNAError, idna.decode, '≠𐮂.↑6,1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '≠𐮂.↑6,1.', strict=True)

    def test_uts46_4495(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1chy492g.xn--6,1-pw1a.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1chy492g.xn--6,1-pw1a.', strict=True)

    def test_uts46_4496(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1chy492g.xn--6,-uzus5m', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1chy492g.xn--6,-uzus5m', strict=True)

    def test_uts46_4497(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--1chy492g.xn--45gx9iuy44d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--1chy492g.xn--45gx9iuy44d', strict=True)

    def test_uts46_4498(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝩏\U000e0c89ß.ᢤ\U0008498c\u200c𐹫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝩏\U000e0c89ß.ᢤ\U0008498c\u200c𐹫', strict=True)

    def test_uts46_4499(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝩏\U000e0c89SS.ᢤ\U0008498c\u200c𐹫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝩏\U000e0c89SS.ᢤ\U0008498c\u200c𐹫', strict=True)

    def test_uts46_4500(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝩏\U000e0c89ss.ᢤ\U0008498c\u200c𐹫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝩏\U000e0c89ss.ᢤ\U0008498c\u200c𐹫', strict=True)

    def test_uts46_4501(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝩏\U000e0c89Ss.ᢤ\U0008498c\u200c𐹫', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝩏\U000e0c89Ss.ᢤ\U0008498c\u200c𐹫', strict=True)

    def test_uts46_4502(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-zb11ap1427e.xn--ubf2596jbt61c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-zb11ap1427e.xn--ubf2596jbt61c', strict=True)

    def test_uts46_4503(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-zb11ap1427e.xn--ubf609atw1tynn3d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-zb11ap1427e.xn--ubf609atw1tynn3d', strict=True)

    def test_uts46_4504(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca3153vupz3e.xn--ubf609atw1tynn3d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca3153vupz3e.xn--ubf609atw1tynn3d', strict=True)

    def test_uts46_4505(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß\U00010d73\U00057601Ⴇ｡ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß\U00010d73\U00057601Ⴇ｡ꙺ', strict=True)

    def test_uts46_4506(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß\U00010d73\U00057601Ⴇ。ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß\U00010d73\U00057601Ⴇ。ꙺ', strict=True)

    def test_uts46_4507(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß\U00010d73\U00057601ⴇ。ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß\U00010d73\U00057601ⴇ。ꙺ', strict=True)

    def test_uts46_4508(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS\U00010d53\U00057601Ⴇ。ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS\U00010d53\U00057601Ⴇ。ꙺ', strict=True)

    def test_uts46_4509(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss\U00010d73\U00057601ⴇ。ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss\U00010d73\U00057601ⴇ。ꙺ', strict=True)

    def test_uts46_4510(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss\U00010d73\U00057601Ⴇ。ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss\U00010d73\U00057601Ⴇ。ꙺ', strict=True)

    def test_uts46_4511(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-e61ar955h4hs7b.xn--9x8a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-e61ar955h4hs7b.xn--9x8a', strict=True)

    def test_uts46_4512(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca227tpy4lkns1b.xn--9x8a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca227tpy4lkns1b.xn--9x8a', strict=True)

    def test_uts46_4513(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ß\U00010d73\U00057601ⴇ｡ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ß\U00010d73\U00057601ⴇ｡ꙺ', strict=True)

    def test_uts46_4514(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS\U00010d53\U00057601Ⴇ｡ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS\U00010d53\U00057601Ⴇ｡ꙺ', strict=True)

    def test_uts46_4515(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ss\U00010d73\U00057601ⴇ｡ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ss\U00010d73\U00057601ⴇ｡ꙺ', strict=True)

    def test_uts46_4516(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Ss\U00010d73\U00057601Ⴇ｡ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Ss\U00010d73\U00057601Ⴇ｡ꙺ', strict=True)

    def test_uts46_4517(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS\U00010d73\U00057601Ⴇ。ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS\U00010d73\U00057601Ⴇ。ꙺ', strict=True)

    def test_uts46_4518(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-rek7420r4hs7b.xn--9x8a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-rek7420r4hs7b.xn--9x8a', strict=True)

    def test_uts46_4519(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca491fci5qkn79a.xn--9x8a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca491fci5qkn79a.xn--9x8a', strict=True)

    def test_uts46_4520(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'SS\U00010d73\U00057601Ⴇ｡ꙺ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'SS\U00010d73\U00057601Ⴇ｡ꙺ', strict=True)

    def test_uts46_4521(self):
        self.assertRaises(idna.IDNAError, idna.decode, '᜔。󠆣-𑋪', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '᜔。󠆣-𑋪', strict=True)

    def test_uts46_4522(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--fze.xn----ly8i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--fze.xn----ly8i', strict=True)

    def test_uts46_4523(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꯨ-．\U000a83dcֽß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꯨ-．\U000a83dcֽß', strict=True)

    def test_uts46_4524(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꯨ-.\U000a83dcֽß', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꯨ-.\U000a83dcֽß', strict=True)

    def test_uts46_4525(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꯨ-.\U000a83dcֽSS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꯨ-.\U000a83dcֽSS', strict=True)

    def test_uts46_4526(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꯨ-.\U000a83dcֽss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꯨ-.\U000a83dcֽss', strict=True)

    def test_uts46_4527(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꯨ-.\U000a83dcֽSs', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꯨ-.\U000a83dcֽSs', strict=True)

    def test_uts46_4528(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----pw5e.xn--ss-7jd10716y', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----pw5e.xn--ss-7jd10716y', strict=True)

    def test_uts46_4529(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----pw5e.xn--zca50wfv060a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----pw5e.xn--zca50wfv060a', strict=True)

    def test_uts46_4530(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꯨ-．\U000a83dcֽSS', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꯨ-．\U000a83dcֽSS', strict=True)

    def test_uts46_4531(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꯨ-．\U000a83dcֽss', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꯨ-．\U000a83dcֽss', strict=True)

    def test_uts46_4532(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ꯨ-．\U000a83dcֽSs', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ꯨ-．\U000a83dcֽSs', strict=True)

    def test_uts46_4533(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡓ-≮。٫󠅱ᡄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡓ-≮。٫󠅱ᡄ', strict=True)

    def test_uts46_4534(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ᡓ-≮。٫󠅱ᡄ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ᡓ-≮。٫󠅱ᡄ', strict=True)

    def test_uts46_4535(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----s7j866c.xn--kib252g', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----s7j866c.xn--kib252g', strict=True)

    def test_uts46_4536(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟥♮𑜫࣭．្𑜫8󠆏', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟥♮𑜫࣭．្𑜫8󠆏', strict=True)

    def test_uts46_4537(self):
        self.assertRaises(idna.IDNAError, idna.decode, '3♮𑜫࣭.្𑜫8󠆏', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '3♮𑜫࣭.្𑜫8󠆏', strict=True)

    def test_uts46_4538(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3-ksd277tlo7s.xn--8-f0jx021l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3-ksd277tlo7s.xn--8-f0jx021l', strict=True)

    def test_uts46_4539(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-｡\U00095300\u200d❡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-｡\U00095300\u200d❡', strict=True)

    def test_uts46_4540(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-。\U00095300\u200d❡', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-。\U00095300\u200d❡', strict=True)

    def test_uts46_4541(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--nei54421f', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--nei54421f', strict=True)

    def test_uts46_4542(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn--1ug800aq795s', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn--1ug800aq795s', strict=True)

    def test_uts46_4543(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𝟓☱𝟐\U000a5c35｡𝪮\U00050873', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𝟓☱𝟐\U000a5c35｡𝪮\U00050873', strict=True)

    def test_uts46_4544(self):
        self.assertRaises(idna.IDNAError, idna.decode, '5☱2\U000a5c35。𝪮\U00050873', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '5☱2\U000a5c35。𝪮\U00050873', strict=True)

    def test_uts46_4545(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--52-dwx47758j.xn--kd3hk431k', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--52-dwx47758j.xn--kd3hk431k', strict=True)

    def test_uts46_4546(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.-├\U000969a3', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.-├\U000969a3', strict=True)

    def test_uts46_4547(self):
        self.assertRaises(idna.IDNAError, idna.decode, '-.xn----ukp70432h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '-.xn----ukp70432h', strict=True)

    def test_uts46_4548(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֥ݭ｡\u200d\U000e0018', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֥ݭ｡\u200d\U000e0018', strict=True)

    def test_uts46_4549(self):
        self.assertRaises(idna.IDNAError, idna.decode, '֥ݭ。\u200d\U000e0018', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '֥ݭ。\u200d\U000e0018', strict=True)

    def test_uts46_4550(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wcb62g.xn--p526e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wcb62g.xn--p526e', strict=True)

    def test_uts46_4551(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--wcb62g.xn--1ugy8001l', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--wcb62g.xn--1ugy8001l', strict=True)

    def test_uts46_4552(self):
        self.assertRaises(idna.IDNAError, idna.decode, '쥥\U000d43c9Ⴎ．\u200c⒈⒈𐫒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '쥥\U000d43c9Ⴎ．\u200c⒈⒈𐫒', strict=True)

    def test_uts46_4553(self):
        self.assertRaises(idna.IDNAError, idna.decode, '쥥\U000d43c9Ⴎ．\u200c⒈⒈𐫒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '쥥\U000d43c9Ⴎ．\u200c⒈⒈𐫒', strict=True)

    def test_uts46_4554(self):
        self.assertRaises(idna.IDNAError, idna.decode, '쥥\U000d43c9Ⴎ.\u200c1.1.𐫒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '쥥\U000d43c9Ⴎ.\u200c1.1.𐫒', strict=True)

    def test_uts46_4555(self):
        self.assertRaises(idna.IDNAError, idna.decode, '쥥\U000d43c9Ⴎ.\u200c1.1.𐫒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '쥥\U000d43c9Ⴎ.\u200c1.1.𐫒', strict=True)

    def test_uts46_4556(self):
        self.assertRaises(idna.IDNAError, idna.decode, '쥥\U000d43c9ⴎ.\u200c1.1.𐫒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '쥥\U000d43c9ⴎ.\u200c1.1.𐫒', strict=True)

    def test_uts46_4557(self):
        self.assertRaises(idna.IDNAError, idna.decode, '쥥\U000d43c9ⴎ.\u200c1.1.𐫒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '쥥\U000d43c9ⴎ.\u200c1.1.𐫒', strict=True)

    def test_uts46_4558(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5kj3511ccyw3h.1.1.xn--7w9c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5kj3511ccyw3h.1.1.xn--7w9c', strict=True)

    def test_uts46_4559(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5kj3511ccyw3h.xn--1-rgn.1.xn--7w9c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5kj3511ccyw3h.xn--1-rgn.1.xn--7w9c', strict=True)

    def test_uts46_4560(self):
        self.assertRaises(idna.IDNAError, idna.decode, '쥥\U000d43c9ⴎ．\u200c⒈⒈𐫒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '쥥\U000d43c9ⴎ．\u200c⒈⒈𐫒', strict=True)

    def test_uts46_4561(self):
        self.assertRaises(idna.IDNAError, idna.decode, '쥥\U000d43c9ⴎ．\u200c⒈⒈𐫒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '쥥\U000d43c9ⴎ．\u200c⒈⒈𐫒', strict=True)

    def test_uts46_4562(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5kj3511ccyw3h.xn--tsha6797o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5kj3511ccyw3h.xn--tsha6797o', strict=True)

    def test_uts46_4563(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--5kj3511ccyw3h.xn--0ug88oa0396u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--5kj3511ccyw3h.xn--0ug88oa0396u', strict=True)

    def test_uts46_4564(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mnd7865gcy28g.1.1.xn--7w9c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mnd7865gcy28g.1.1.xn--7w9c', strict=True)

    def test_uts46_4565(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mnd7865gcy28g.xn--1-rgn.1.xn--7w9c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mnd7865gcy28g.xn--1-rgn.1.xn--7w9c', strict=True)

    def test_uts46_4566(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mnd7865gcy28g.xn--tsha6797o', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mnd7865gcy28g.xn--tsha6797o', strict=True)

    def test_uts46_4567(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--mnd7865gcy28g.xn--0ug88oa0396u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--mnd7865gcy28g.xn--0ug88oa0396u', strict=True)

    def test_uts46_4568(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࠧ𝟶ڠ-。𑄳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࠧ𝟶ڠ-。𑄳', strict=True)

    def test_uts46_4569(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࠧ0ڠ-。𑄳', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࠧ0ڠ-。𑄳', strict=True)

    def test_uts46_4570(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0--p3d67m.xn--v80d', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0--p3d67m.xn--v80d', strict=True)

    def test_uts46_4571(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς．ﷁ🞛⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς．ﷁ🞛⒈', strict=True)

    def test_uts46_4572(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ς.فمي🞛1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ς.فمي🞛1.', strict=True)

    def test_uts46_4573(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ.فمي🞛1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ.فمي🞛1.', strict=True)

    def test_uts46_4574(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ.فمي🞛1.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ.فمي🞛1.', strict=True)

    def test_uts46_4575(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa.xn--1-gocmu97674d.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa.xn--1-gocmu97674d.', strict=True)

    def test_uts46_4576(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa.xn--1-gocmu97674d.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa.xn--1-gocmu97674d.', strict=True)

    def test_uts46_4577(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'Σ．ﷁ🞛⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'Σ．ﷁ🞛⒈', strict=True)

    def test_uts46_4578(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'σ．ﷁ🞛⒈', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'σ．ﷁ🞛⒈', strict=True)

    def test_uts46_4579(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--4xa.xn--dhbip2802atb20c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--4xa.xn--dhbip2802atb20c', strict=True)

    def test_uts46_4580(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--3xa.xn--dhbip2802atb20c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--3xa.xn--dhbip2802atb20c', strict=True)

    def test_uts46_4581(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🗩-｡𐹻\U000d0786\U0006526e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🗩-｡𐹻\U000d0786\U0006526e', strict=True)

    def test_uts46_4582(self):
        self.assertRaises(idna.IDNAError, idna.decode, '🗩-。𐹻\U000d0786\U0006526e', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '🗩-。𐹻\U000d0786\U0006526e', strict=True)

    def test_uts46_4583(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----6t3s.xn--zo0d4811u6ru6a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----6t3s.xn--zo0d4811u6ru6a', strict=True)

    def test_uts46_4584(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐡜-🔪｡𝟻\u200c𐿀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐡜-🔪｡𝟻\u200c𐿀', strict=True)

    def test_uts46_4585(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐡜-🔪。5\u200c𐿀', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐡜-🔪。5\u200c𐿀', strict=True)

    def test_uts46_4586(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----5j4iv089c.xn--5-bn7i', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----5j4iv089c.xn--5-bn7i', strict=True)

    def test_uts46_4587(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn----5j4iv089c.xn--5-sgn7149h', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn----5j4iv089c.xn--5-sgn7149h', strict=True)

    def test_uts46_4588(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dß．ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dß．ߏ0ּ', strict=True)

    def test_uts46_4589(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dß．ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dß．ߏ0ּ', strict=True)

    def test_uts46_4590(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dß.ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dß.ߏ0ּ', strict=True)

    def test_uts46_4591(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dß.ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dß.ߏ0ּ', strict=True)

    def test_uts46_4592(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dSS.ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dSS.ߏ0ּ', strict=True)

    def test_uts46_4593(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dSS.ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dSS.ߏ0ּ', strict=True)

    def test_uts46_4594(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dss.ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dss.ߏ0ּ', strict=True)

    def test_uts46_4595(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dss.ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dss.ߏ0ּ', strict=True)

    def test_uts46_4596(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-i05i7041a.xn--0-vgc50n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-i05i7041a.xn--0-vgc50n', strict=True)

    def test_uts46_4597(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--ss-l1tu910fo0xd.xn--0-vgc50n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--ss-l1tu910fo0xd.xn--0-vgc50n', strict=True)

    def test_uts46_4598(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dSs.ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dSs.ߏ0ּ', strict=True)

    def test_uts46_4599(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dSs.ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dSs.ߏ0ּ', strict=True)

    def test_uts46_4600(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--zca770n5s4hev6c.xn--0-vgc50n', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--zca770n5s4hev6c.xn--0-vgc50n', strict=True)

    def test_uts46_4601(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dSS．ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dSS．ߏ0ּ', strict=True)

    def test_uts46_4602(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dSS．ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dSS．ߏ0ּ', strict=True)

    def test_uts46_4603(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dss．ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dss．ߏ0ּ', strict=True)

    def test_uts46_4604(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dss．ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dss．ߏ0ּ', strict=True)

    def test_uts46_4605(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dSs．ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dSs．ߏ0ּ', strict=True)

    def test_uts46_4606(self):
        self.assertRaises(idna.IDNAError, idna.decode, '𐹣늿\u200dSs．ߏ0ּ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '𐹣늿\u200dSs．ߏ0ּ', strict=True)

    def test_uts46_4607(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9󠇥．\U000ead34ᢓ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9󠇥．\U000ead34ᢓ', strict=True)

    def test_uts46_4608(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9󠇥.\U000ead34ᢓ', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9󠇥.\U000ead34ᢓ', strict=True)

    def test_uts46_4609(self):
        self.assertRaises(idna.IDNAError, idna.decode, '9.xn--dbf91222q', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '9.xn--dbf91222q', strict=True)

    def test_uts46_4610(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cﾠ.𐫭🠗ß⽟', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cﾠ.𐫭🠗ß⽟', strict=True)

    def test_uts46_4611(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cᅠ.𐫭🠗ß玉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cᅠ.𐫭🠗ß玉', strict=True)

    def test_uts46_4612(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cᅠ.𐫭🠗SS玉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cᅠ.𐫭🠗SS玉', strict=True)

    def test_uts46_4613(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cᅠ.𐫭🠗ss玉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cᅠ.𐫭🠗ss玉', strict=True)

    def test_uts46_4614(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cᅠ.𐫭🠗Ss玉', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cᅠ.𐫭🠗Ss玉', strict=True)

    def test_uts46_4615(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--ss-je6eq954cp25j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--ss-je6eq954cp25j', strict=True)

    def test_uts46_4616(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--ss-je6eq954cp25j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--ss-je6eq954cp25j', strict=True)

    def test_uts46_4617(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug.xn--zca2289c550e0iwi', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug.xn--zca2289c550e0iwi', strict=True)

    def test_uts46_4618(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cﾠ.𐫭🠗SS⽟', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cﾠ.𐫭🠗SS⽟', strict=True)

    def test_uts46_4619(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cﾠ.𐫭🠗ss⽟', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cﾠ.𐫭🠗ss⽟', strict=True)

    def test_uts46_4620(self):
        self.assertRaises(idna.IDNAError, idna.decode, '\u200cﾠ.𐫭🠗Ss⽟', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '\u200cﾠ.𐫭🠗Ss⽟', strict=True)

    def test_uts46_4621(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--psd.xn--ss-je6eq954cp25j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--psd.xn--ss-je6eq954cp25j', strict=True)

    def test_uts46_4622(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--psd526e.xn--ss-je6eq954cp25j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--psd526e.xn--ss-je6eq954cp25j', strict=True)

    def test_uts46_4623(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--psd526e.xn--zca2289c550e0iwi', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--psd526e.xn--zca2289c550e0iwi', strict=True)

    def test_uts46_4624(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--cl7c.xn--ss-je6eq954cp25j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--cl7c.xn--ss-je6eq954cp25j', strict=True)

    def test_uts46_4625(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug7719f.xn--ss-je6eq954cp25j', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug7719f.xn--ss-je6eq954cp25j', strict=True)

    def test_uts46_4626(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--0ug7719f.xn--zca2289c550e0iwi', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--0ug7719f.xn--zca2289c550e0iwi', strict=True)

    def test_uts46_4627(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒Ⴖͦ．\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒Ⴖͦ．\u200c', strict=True)

    def test_uts46_4628(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。Ⴖͦ.\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。Ⴖͦ.\u200c', strict=True)

    def test_uts46_4629(self):
        self.assertRaises(idna.IDNAError, idna.decode, '。ⴖͦ.\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '。ⴖͦ.\u200c', strict=True)

    def test_uts46_4630(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--hva754s.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--hva754s.', strict=True)

    def test_uts46_4631(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--hva754s.xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--hva754s.xn--0ug', strict=True)

    def test_uts46_4632(self):
        self.assertRaises(idna.IDNAError, idna.decode, '︒ⴖͦ．\u200c', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '︒ⴖͦ．\u200c', strict=True)

    def test_uts46_4633(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hva754sy94k.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hva754sy94k.', strict=True)

    def test_uts46_4634(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hva754sy94k.xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hva754sy94k.xn--0ug', strict=True)

    def test_uts46_4635(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--hva929d.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--hva929d.', strict=True)

    def test_uts46_4636(self):
        self.assertRaises(idna.IDNAError, idna.decode, '.xn--hva929d.xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, '.xn--hva929d.xn--0ug', strict=True)

    def test_uts46_4637(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hva929dl29p.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hva929dl29p.', strict=True)

    def test_uts46_4638(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hva929dl29p.xn--0ug', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hva929dl29p.xn--0ug', strict=True)

    def test_uts46_4641(self):
        self.assertEqual(idna.decode('Ⴖͦ.', uts46=True, strict=True), 'ⴖͦ.')
        self.assertRaises(idna.IDNAError, idna.encode, 'Ⴖͦ.', strict=True)

    def test_uts46_4642(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hva929d.', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hva929d.', strict=True)

    def test_uts46_4643(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࢻ．\u200cႣ𞀒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࢻ．\u200cႣ𞀒', strict=True)

    def test_uts46_4644(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࢻ.\u200cႣ𞀒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࢻ.\u200cႣ𞀒', strict=True)

    def test_uts46_4645(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࢻ.\u200cⴃ𞀒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࢻ.\u200cⴃ𞀒', strict=True)

    def test_uts46_4646(self):
        self.assertEqual(idna.decode('xn--hzb.xn--ukj4430l', uts46=True, strict=True), 'ࢻ.ⴃ𞀒')
        self.assertEqual(idna.encode('xn--hzb.xn--ukj4430l', uts46=True, strict=True), b'xn--hzb.xn--ukj4430l')

    def test_uts46_4647(self):
        self.assertEqual(idna.decode('ࢻ.ⴃ𞀒', uts46=True, strict=True), 'ࢻ.ⴃ𞀒')
        self.assertEqual(idna.encode('ࢻ.ⴃ𞀒', uts46=True, strict=True), b'xn--hzb.xn--ukj4430l')

    def test_uts46_4648(self):
        self.assertEqual(idna.decode('ࢻ.Ⴃ𞀒', uts46=True, strict=True), 'ࢻ.ⴃ𞀒')
        self.assertEqual(idna.encode('ࢻ.Ⴃ𞀒', uts46=True, strict=True), b'xn--hzb.xn--ukj4430l')

    def test_uts46_4649(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hzb.xn--0ug822cp045a', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hzb.xn--0ug822cp045a', strict=True)

    def test_uts46_4650(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'ࢻ．\u200cⴃ𞀒', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'ࢻ．\u200cⴃ𞀒', strict=True)

    def test_uts46_4651(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hzb.xn--bnd2938u', strict=True)
        self.assertRaises(idna.IDNAError, idna.encode, 'xn--hzb.xn--bnd2938u', strict=True)

    def test_uts46_4652(self):
        self.assertRaises(idna.IDNAError, idna.decode, 'xn--hzb.xn--bnd300f7225a', strict=True