#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Vampire: The Masquerade - Redemption
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250806.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='vampire-the-masquerade-redemption'
GAME_NAME='Vampire: The Masquerade - Redemption'

ARCHIVE_BASE_0_NAME='setup_vampire_the_masquerade_redemption_2.0.0.3.exe'
ARCHIVE_BASE_0_MD5='96c19b0ce487e53dd8fe24ef963d31fc'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1300000'
ARCHIVE_BASE_0_VERSION='1.1-gog2.0.0.3'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/vampire_the_masquerade_redemption'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
*.dll
*.exe
*.inf
*.isu
extras/cs
miles'
CONTENT_GAME_DATA_FILES='
*.dat
*.nob
*.pub
*.zip
vampireankh.ico
chronicles
extras
sounds
video'
CONTENT_DOC_DATA_FILES='
*.pdf
*.rtf'

USER_PERSISTENT_DIRECTORIES='
savegames'
USER_PERSISTENT_FILES='
*.ini'

## Set required registry keys.
## TODO: The CD key should be extracted from a file provided with the game installer,
##       instead of hardcoded in this script.
# shellcheck disable=SC1003
WINE_REGISTRY_INIT='
[HKEY_LOCAL_MACHINE\Software\Activision\Vampire: The Masquerade - Redemption\v1.0]
"CDDRIVE"="c:"
"INSTALLDIR"="C:\\'"${GAME_ID}"'"
"INSTALLDIREXE"="C:\\'"${GAME_ID}"'\\vampire.exe"
"INSTALLTYPE"=dword:00000002
"Version"="0.1"

[HKEY_LOCAL_MACHINE\Software\WON\CDKeys]
"Vampire"=hex:4e,07,4a,bf,8e,4d,c1,71,9c,de,2b,b9,91,2e,a3,e9'

## TODO: The game can mess up with the display gamma setting, we should restore the previous value after exiting it.

APP_MAIN_EXE='vampire.exe'
APP_MAIN_ICON='vampireankh.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
