---
id: Switch
section: components
cssPrefix: pf-v6-c-switch
propComponents: ['Switch']
ouia: true
---

import { Fragment, useState } from 'react';

## Examples

To keep inline with accessibility guidelines, the label for a switch must never dynamically change. A dynamically changing label (such as one label for an "on" state and another label for an "off" state) can be confusing as the contexts for each label changes as the switch state does. This applies to both visible text labels as well as labels provided via `aria-label`.

### Basic

```ts file="./SwitchBasic.tsx"

```

### Reversed Layout

```ts file="./SwitchReversed.tsx"

```

### Without label

```ts file="./SwitchWithoutLabel.tsx"

```

### Checked with label

```ts file="./SwitchCheckedWithLabel.tsx"

```

### Disabled

```ts file="./SwitchDisabled.tsx"

```

### Uncontrolled

```ts file="./SwitchUncontrolled.tsx"

```
