; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- -mattr=+sse2 -enable-unsafe-fp-math | FileCheck %s

; Don't fold the incoming stack arguments into the xorps instructions used
; to do floating-point negations, because the arguments aren't vectors
; and aren't vector-aligned.

define void @foo(ptr %p, ptr %q, float %s, float %y) nounwind {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushl %esi
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movl $-2147483648, %edx # imm = 0x80000000
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-NEXT:    xorl %edx, %esi
; CHECK-NEXT:    movl %esi, (%ecx)
; CHECK-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; CHECK-NEXT:    movl %edx, (%eax)
; CHECK-NEXT:    popl %esi
; CHECK-NEXT:    retl
  %ss = fsub float -0.0, %s
  %yy = fsub float -0.0, %y
  store float %ss, ptr %p
  store float %yy, ptr %q
  ret void
}
