doc ///
    Key
        boxProduct
        (symbol **,CpMackeyFunctor,CpMackeyFunctor)
        (boxProduct,CpMackeyFunctor,CpMackeyFunctor)
        (symbol ⊠, CpMackeyFunctor,CpMackeyFunctor)
    Headline
        box product of Cp-Mackey functors
    Usage
        M ⊠ N
        boxProduct(M,N)
        M ** N
    Inputs
        M : CpMackeyFunctor
        N : CpMackeyFunctor
    Outputs
        : CpMackeyFunctor
            the box product of $M$ and $N$
    Description
        Text
            Given two @TO2((CpMackeyFunctor),"Cp-Mackey functors")@ $M$ and $N$, we can form their {\em box product}, which creates another Mackey functor. This new Mackey functor is defined by the following data:

            @UL{
                (BOLD "underlying module:", " defined as ", TEX"$M(C_p/e) \\otimes N(C_p/e)$"),
                (BOLD "fixed module:", " defined as ", TEX "$(M(C_p/C_p)\\otimes N(C_p/C_p)) \\oplus (M(C_p/e) \\otimes N(C_p/e))/ \\sim$", " where the equivalence relation is generated by ", TEX"$$( \\text{tr}(x)\\otimes b,0 ) \\sim ( 0, x\\otimes\\text{res}(b))$$", TEX"$$(a\\otimes\\text{tr}(y),0)\\sim(0,\\text{res}(a)\\otimes y)$$", " and ", TEX"$$(0, x\\otimes y)\\sim(0, c(x)\\otimes c(y))$$"),
                (BOLD "restriction:", " defined by the formula ", TEX"$$[a\\otimes b, x\\otimes y] \\mapsto \\text{res}(a) \\otimes \\text{res}(b) + \\sum_{i=0}^{p-1} c^i(x) \\otimes c^i(y).$$"),
                (BOLD "transfer:", " defined by the formula", TEX"$$x\\otimes y \\mapsto [0,x \\otimes y]$$"),
                (BOLD "conjugation:"," defined by ", TEX"$c\\otimes c$", ".")
            }@

            The box product makes $\text{Mack}_{C_p}$ into a symmetric monoidal category, which is {\em closed symmetric monoidal} due to the @TO2((internalHom, CpMackeyFunctor, CpMackeyFunctor),"internal hom")@.

        Example
            M= makeUnderlyingFreeMackeyFunctor(2);
            M**M
    SeeAlso
        "the abelian category of Mackey functors"
        (internalHom, CpMackeyFunctor, CpMackeyFunctor)
///

doc ///
    Key
        (boxProduct, MackeyFunctorHomomorphism,CpMackeyFunctor)
        (symbol ⊠, MackeyFunctorHomomorphism,CpMackeyFunctor)
        (symbol **, MackeyFunctorHomomorphism,CpMackeyFunctor)
        (boxProduct, CpMackeyFunctor,MackeyFunctorHomomorphism)
        (symbol ⊠, CpMackeyFunctor,MackeyFunctorHomomorphism)
        (symbol **, CpMackeyFunctor,MackeyFunctorHomomorphism)
    Headline
        induced maps on box products
    Usage
        F ⊠ M
        boxProduct(F,M)
        F ** M
        M ⊠ F
        boxProduct(M,F)
        M ** F
    Inputs
        F : MackeyFunctorHomomorphism
        M : CpMackeyFunctor
    Outputs
        : MackeyFunctorHomomorphism
            the map induced by taking the box product of M with a morphism F.
    Description
        Text
            A map $F\colon P\to Q$ of Mackey functors can be tesnored with a Mackey functor $M$ to form a map $M ⊠ F\colon M ⊠ P\to M ⊠ Q$.
        Example
            boxProduct(makeUnderlyingFreeMackeyFunctor(3),complexLinearizationMap(3))
    SeeAlso
        "the abelian category of Mackey functors"
        boxProduct
///
