/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.statemanager.StateManagerService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Event;
import org.chefproject.core.UsageSession;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericPresenceService;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;

public abstract class BasePresenceService
extends TurbineBaseService
implements GenericPresenceService,
CacheRefresher {
    protected Storage m_storage = null;
    protected Maintenance m_maintenance = null;
    protected long m_timeoutSeconds = 0L;
    protected long m_checkSeconds = 0L;
    protected StateManagerService m_stateManager = null;
    protected Cache m_cache = null;

    protected abstract Storage newStorage();

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        this.m_timeoutSeconds = Long.parseLong(this.getProperties().getProperty("timeout", "1800"));
        this.m_checkSeconds = Long.parseLong(this.getProperties().getProperty("check", "60"));
        Log.debug("chef", this + ".init(ServletConfig): timeout: " + this.m_timeoutSeconds + "  check: " + this.m_checkSeconds);
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.debug("chef", this + ".init(RunData)");
    }

    public void init() throws InitializationException {
        super.init();
        Log.debug("chef", this + ".init()");
        this.m_stateManager = (StateManagerService)TurbineServices.getInstance().getService("StateManagerService");
        this.m_storage = this.newStorage();
        this.m_maintenance = new Maintenance();
        this.m_maintenance.start();
        this.m_cache = new Cache((CacheRefresher)this, this.presenceReference(""));
        this.getLocations();
    }

    public void shutdown() {
        this.m_maintenance.stop();
        this.m_maintenance = null;
        this.m_storage = null;
        this.m_stateManager = null;
        this.m_cache.clear();
        this.m_cache = null;
        Log.debug("chef", this + ".shutdown()");
        super.shutdown();
    }

    public String presenceReference(String id) {
        return "/presence/" + id;
    }

    protected String presenceId(String ref) {
        String start = this.presenceReference("");
        int i = ref.indexOf(start);
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + start.length());
        return id;
    }

    public void setPresence(UsageSession session, String locationId) {
        this.setPresence(session, locationId, null);
    }

    public void setPresence(UsageSession session, String locationId, String stateKey) {
        boolean added;
        if (this.m_maintenance == null) {
            Log.warn("chef", this + ".setPresence() : called with null m_maintenance!");
            return;
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".setPresence(" + session.getId() + ", " + locationId + ", " + stateKey + ")");
        }
        if (added = this.m_maintenance.setPresence(session.getId(), locationId, stateKey)) {
            this.m_storage.setPresence(session.getId(), locationId);
            Event event = EventTrackingService.newEvent("pres.begin", this.presenceReference(locationId), true);
            EventTrackingService.post(event, session);
        }
    }

    public void removePresence(UsageSession session) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".removePresence(" + session.getId() + ")");
        }
        List locations = this.m_maintenance.getLocations(session.getId());
        int i = 0;
        while (i < locations.size()) {
            this.removePresence(session, (String)locations.get(i));
            ++i;
        }
        this.m_maintenance.removeSession(session.getId());
    }

    public void removePresence(UsageSession session, String locationId) {
        boolean removed;
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".removePresence(" + session.getId() + ", " + locationId + ")");
        }
        if (removed = this.m_maintenance.removePresence(session.getId(), locationId)) {
            this.m_storage.removePresence(session.getId(), locationId);
            Event event = EventTrackingService.newEvent("pres.end", this.presenceReference(locationId), true);
            EventTrackingService.post(event, session);
        }
    }

    public List getPresence(String locationId) {
        if (this.m_cache == null) {
            Log.warn("chef", this + ".getPresence() : called with null m_cache!");
            return new Vector();
        }
        String key = this.presenceReference(locationId);
        List ids = (List)this.m_cache.get(key);
        if (ids == null) {
            ids = this.m_storage.getSessions(locationId);
            this.m_cache.put(key, ids);
        }
        Vector<UsageSession> sessions = new Vector<UsageSession>();
        int i = 0;
        while (i < ids.size()) {
            UsageSession session = UsageSessionService.getSession((String)ids.get(i));
            if (session != null) {
                sessions.add(session);
            }
            ++i;
        }
        Collections.sort(sessions);
        return sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLocations() {
        List locations = new Vector();
        if (this.m_cache.disabled()) {
            locations = this.m_storage.getLocations();
        } else if (this.m_cache.isComplete()) {
            locations = this.m_cache.getIds();
        } else {
            Cache cache = this.m_cache;
            synchronized (cache) {
                if (this.m_cache.isComplete()) {
                    locations = this.m_cache.getIds();
                } else {
                    this.m_cache.holdEvents();
                    locations = this.m_storage.getLocations();
                    Iterator it = locations.iterator();
                    while (it.hasNext()) {
                        String locationId = (String)it.next();
                        List ids = this.m_storage.getSessions(locationId);
                        this.m_cache.put(this.presenceReference(locationId), ids);
                    }
                    this.m_cache.setComplete();
                    this.m_cache.processEvents();
                }
            }
        }
        Collections.sort(locations);
        return locations;
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".refresh(): " + key + " event: " + event);
        }
        if (event == null) {
            return oldValue;
        }
        String sessionId = event.getSessionId();
        if (sessionId == null) {
            return oldValue;
        }
        if (oldValue == null) {
            String locationId = this.presenceId(event.getResource());
            List rv = this.m_storage.getSessions(locationId);
            if (rv.isEmpty()) {
                rv = null;
            }
            return rv;
        }
        List ids = (List)oldValue;
        if (event.getEvent().equals("pres.begin")) {
            if (!ids.contains(sessionId)) {
                ids.add(sessionId);
            }
        } else if (event.getEvent().equals("pres.end") && ids.contains(sessionId)) {
            ids.remove(sessionId);
        }
        if (ids.isEmpty()) {
            oldValue = null;
        }
        return oldValue;
    }

    protected class VarInt {
        protected int m_value = 0;

        protected VarInt() {
        }

        public int getValue() {
            return this.m_value;
        }

        public synchronized void incValue() {
            ++this.m_value;
        }

        public synchronized void decValue() {
            --this.m_value;
        }
    }

    protected class Presence {
        protected long m_timestamp = 0L;
        protected Set m_keys = new HashSet();

        public Presence() {
            this.m_timestamp = System.currentTimeMillis();
        }

        public void addKey(String key) {
            if (key != null) {
                this.m_keys.add(key);
            }
        }

        public Set getKeys() {
            return this.m_keys;
        }

        public void refresh() {
            this.m_timestamp = System.currentTimeMillis();
        }

        public boolean isExpired(long now) {
            return this.m_timestamp + BasePresenceService.this.m_timeoutSeconds * 1000L < now;
        }
    }

    protected class Maintenance
    implements Runnable {
        protected Thread m_timeoutChecker = null;
        protected boolean m_timeoutCheckerStop = false;
        protected Map m_sessions = new HashMap();
        protected Map m_stateKeys = new HashMap();

        public void start() {
            if (this.m_timeoutChecker != null) {
                return;
            }
            this.m_timeoutChecker = new Thread((Runnable)this, "BasePresenceService.TimeoutChecker");
            this.m_timeoutCheckerStop = false;
            this.m_timeoutChecker.start();
        }

        public void stop() {
            if (this.m_timeoutChecker != null) {
                this.m_timeoutCheckerStop = true;
                this.m_timeoutChecker.interrupt();
                try {
                    this.m_timeoutChecker.join();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                this.m_timeoutChecker = null;
            }
            Iterator i = this.m_sessions.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry locEntry = i.next();
                String sessionId = (String)locEntry.getKey();
                Map locations = (Map)locEntry.getValue();
                if (locations == null || locations.isEmpty()) continue;
                Iterator p = locations.entrySet().iterator();
                while (p.hasNext()) {
                    Map.Entry presEntry = p.next();
                    Presence presence = (Presence)presEntry.getValue();
                    String locationId = (String)presEntry.getKey();
                    this.processRemoval(sessionId, locationId, presence);
                    BasePresenceService.this.m_storage.removePresence(sessionId, locationId);
                    Event event = EventTrackingService.newEvent("pres.end", BasePresenceService.this.presenceReference(locationId), true);
                    EventTrackingService.post(event, UsageSessionService.getSession(sessionId));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", this + ".run()");
                }
                while (!this.m_timeoutCheckerStop) {
                    if (Log.getLogger("chef").isDebugEnabled()) {
                        Log.debug("chef", this + ".checking...");
                    }
                    long now = System.currentTimeMillis();
                    Vector sessionIds = new Vector();
                    sessionIds.addAll(this.m_sessions.keySet());
                    int i = 0;
                    while (i < sessionIds.size()) {
                        String sessionId = (String)sessionIds.get(i);
                        Map locations = (Map)this.m_sessions.get(sessionId);
                        if (locations != null && !locations.isEmpty()) {
                            Map map = locations;
                            synchronized (map) {
                                Vector presences = new Vector();
                                presences.addAll(locations.entrySet());
                                int p = 0;
                                while (p < presences.size()) {
                                    Map.Entry entry = (Map.Entry)presences.get(p);
                                    Presence presence = (Presence)entry.getValue();
                                    String locationId = (String)entry.getKey();
                                    if (presence.isExpired(now)) {
                                        locations.remove(locationId);
                                        this.processRemoval(sessionId, locationId, presence);
                                        BasePresenceService.this.m_storage.removePresence(sessionId, locationId);
                                        Event event = EventTrackingService.newEvent("pres.end", BasePresenceService.this.presenceReference(locationId), true);
                                        EventTrackingService.post(event, UsageSessionService.getSession(sessionId));
                                    }
                                    ++p;
                                }
                            }
                        }
                        ++i;
                    }
                    try {
                        Thread.sleep(BasePresenceService.this.m_checkSeconds * 1000L);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", this + ": done");
                }
            }
            catch (Throwable e) {
                Log.warn("chef", this + ": exception: ", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setPresence(String sessionId, String locationId, String stateKey) {
            HashMap<String, Presence> hashMap;
            boolean newlyAdded = false;
            HashMap<String, Presence> locations = (HashMap<String, Presence>)this.m_sessions.get(sessionId);
            if (locations == null) {
                hashMap = this.m_sessions;
                synchronized (hashMap) {
                    locations = (Map)this.m_sessions.get(sessionId);
                    if (locations == null) {
                        locations = new HashMap<String, Presence>();
                        this.m_sessions.put(sessionId, locations);
                    }
                }
            }
            hashMap = locations;
            synchronized (hashMap) {
                Presence presence = (Presence)locations.get(locationId);
                if (presence == null) {
                    presence = new Presence();
                    locations.put(locationId, presence);
                    newlyAdded = true;
                }
                presence.addKey(stateKey);
                presence.refresh();
            }
            if (stateKey != null && newlyAdded) {
                Map map = this.m_stateKeys;
                synchronized (map) {
                    VarInt count = (VarInt)this.m_stateKeys.get(stateKey);
                    if (count == null) {
                        count = new VarInt();
                        this.m_stateKeys.put(stateKey, count);
                    }
                    count.incValue();
                }
            }
            return newlyAdded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removePresence(String sessionId, String locationId) {
            Map locations = (Map)this.m_sessions.get(sessionId);
            if (locations == null) {
                return false;
            }
            Presence presence = null;
            Map map = locations;
            synchronized (map) {
                block5: {
                    presence = (Presence)locations.get(locationId);
                    if (presence != null) break block5;
                    boolean bl = false;
                    return bl;
                }
                locations.remove(locationId);
            }
            this.processRemoval(sessionId, locationId, presence);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSession(String sessionId) {
            Map locations = null;
            Map map = this.m_sessions;
            synchronized (map) {
                locations = (Map)this.m_sessions.get(sessionId);
                if (locations == null) {
                    return;
                }
                this.m_sessions.remove(sessionId);
            }
            if (!locations.isEmpty()) {
                Log.warn("chef", this + ".removeSession(): locations not empty: session: " + sessionId);
            }
        }

        public List getLocations(String sessionId) {
            Vector rv = new Vector();
            Map locations = (Map)this.m_sessions.get(sessionId);
            if (locations == null || locations.isEmpty()) {
                return rv;
            }
            rv.addAll(locations.keySet());
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processRemoval(String sessionId, String locationId, Presence presence) {
            Set keys = presence.getKeys();
            if (keys.isEmpty()) {
                return;
            }
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                boolean retire = false;
                Map map = this.m_stateKeys;
                synchronized (map) {
                    VarInt count = (VarInt)this.m_stateKeys.get(key);
                    if (count != null) {
                        count.decValue();
                        if (count.getValue() <= 0) {
                            retire = true;
                            this.m_stateKeys.remove(key);
                        }
                    } else {
                        retire = true;
                        Log.warn("chef", this + ".processRemoval: key not in map: " + key);
                    }
                }
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", this + ".processRemoval: session: " + sessionId + " location: " + locationId + " key: " + key + " retire: " + retire);
                }
                if (!retire) continue;
                BasePresenceService.this.m_stateManager.retireState(key);
            }
        }
    }

    protected static interface Storage {
        public void setPresence(String var1, String var2);

        public void removePresence(String var1, String var2);

        public List getSessions(String var1);

        public List getLocations();
    }
}

