# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storage.aio import StorageManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageManagementManagementPoliciesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_management_policies_get(self, resource_group):
        response = await self.client.management_policies.get(
            resource_group_name=resource_group.name,
            account_name="str",
            management_policy_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_management_policies_create_or_update(self, resource_group):
        response = await self.client.management_policies.create_or_update(
            resource_group_name=resource_group.name,
            account_name="str",
            management_policy_name="str",
            properties={
                "id": "str",
                "lastModifiedTime": "2020-02-20 00:00:00",
                "name": "str",
                "policy": {
                    "rules": [
                        {
                            "definition": {
                                "actions": {
                                    "baseBlob": {
                                        "delete": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastAccessTimeGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                            "daysAfterModificationGreaterThan": 0.0,
                                        },
                                        "enableAutoTierToHotFromCool": bool,
                                        "tierToArchive": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastAccessTimeGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                            "daysAfterModificationGreaterThan": 0.0,
                                        },
                                        "tierToCold": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastAccessTimeGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                            "daysAfterModificationGreaterThan": 0.0,
                                        },
                                        "tierToCool": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastAccessTimeGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                            "daysAfterModificationGreaterThan": 0.0,
                                        },
                                        "tierToHot": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastAccessTimeGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                            "daysAfterModificationGreaterThan": 0.0,
                                        },
                                    },
                                    "snapshot": {
                                        "delete": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                        "tierToArchive": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                        "tierToCold": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                        "tierToCool": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                        "tierToHot": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                    },
                                    "version": {
                                        "delete": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                        "tierToArchive": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                        "tierToCold": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                        "tierToCool": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                        "tierToHot": {
                                            "daysAfterCreationGreaterThan": 0.0,
                                            "daysAfterLastTierChangeGreaterThan": 0.0,
                                        },
                                    },
                                },
                                "filters": {
                                    "blobTypes": ["str"],
                                    "blobIndexMatch": [{"name": "str", "op": "str", "value": "str"}],
                                    "prefixMatch": ["str"],
                                },
                            },
                            "name": "str",
                            "type": "str",
                            "enabled": bool,
                        }
                    ]
                },
                "type": "str",
            },
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_management_policies_delete(self, resource_group):
        response = await self.client.management_policies.delete(
            resource_group_name=resource_group.name,
            account_name="str",
            management_policy_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...
