# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.keyvault import KeyVaultManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKeyVaultManagementSecretsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KeyVaultManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_secrets_get(self, resource_group):
        response = self.client.secrets.get(
            resource_group_name=resource_group.name,
            vault_name="str",
            secret_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_secrets_create_or_update(self, resource_group):
        response = self.client.secrets.create_or_update(
            resource_group_name=resource_group.name,
            vault_name="str",
            secret_name="str",
            parameters={
                "properties": {
                    "attributes": {
                        "created": "2020-02-20 00:00:00",
                        "enabled": bool,
                        "exp": "2020-02-20 00:00:00",
                        "nbf": "2020-02-20 00:00:00",
                        "updated": "2020-02-20 00:00:00",
                    },
                    "contentType": "str",
                    "secretUri": "str",
                    "secretUriWithVersion": "str",
                    "value": "str",
                },
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_secrets_update(self, resource_group):
        response = self.client.secrets.update(
            resource_group_name=resource_group.name,
            vault_name="str",
            secret_name="str",
            parameters={
                "properties": {
                    "attributes": {
                        "created": "2020-02-20 00:00:00",
                        "enabled": bool,
                        "exp": "2020-02-20 00:00:00",
                        "nbf": "2020-02-20 00:00:00",
                        "updated": "2020-02-20 00:00:00",
                    },
                    "contentType": "str",
                    "value": "str",
                },
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_secrets_list(self, resource_group):
        response = self.client.secrets.list(
            resource_group_name=resource_group.name,
            vault_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
