# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.authorization import AuthorizationManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-authorization
# USAGE
    python patch_role_management_policy.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AuthorizationManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.role_management_policies.update(
        scope="providers/Microsoft.Subscription/subscriptions/129ff972-28f8-46b8-a726-e497be039368",
        role_management_policy_name="570c3619-7688-4b34-b290-2b8bb3ccab2a",
        parameters={
            "properties": {
                "rules": [
                    {
                        "exceptionMembers": None,
                        "id": "Expiration_Admin_Eligibility",
                        "isExpirationRequired": False,
                        "maximumDuration": "P180D",
                        "ruleType": "RoleManagementPolicyExpirationRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Eligibility",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Notification_Admin_Admin_Eligibility",
                        "isDefaultRecipientsEnabled": False,
                        "notificationLevel": "Critical",
                        "notificationRecipients": ["admin_admin_eligible@test.com"],
                        "notificationType": "Email",
                        "recipientType": "Admin",
                        "ruleType": "RoleManagementPolicyNotificationRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Eligibility",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Notification_Requestor_Admin_Eligibility",
                        "isDefaultRecipientsEnabled": False,
                        "notificationLevel": "Critical",
                        "notificationRecipients": ["requestor_admin_eligible@test.com"],
                        "notificationType": "Email",
                        "recipientType": "Requestor",
                        "ruleType": "RoleManagementPolicyNotificationRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Eligibility",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Notification_Approver_Admin_Eligibility",
                        "isDefaultRecipientsEnabled": False,
                        "notificationLevel": "Critical",
                        "notificationRecipients": ["approver_admin_eligible@test.com"],
                        "notificationType": "Email",
                        "recipientType": "Approver",
                        "ruleType": "RoleManagementPolicyNotificationRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Eligibility",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "enabledRules": [],
                        "id": "Enablement_Admin_Eligibility",
                        "ruleType": "RoleManagementPolicyEnablementRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Eligibility",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "exceptionMembers": None,
                        "id": "Expiration_Admin_Assignment",
                        "isExpirationRequired": False,
                        "maximumDuration": "P90D",
                        "ruleType": "RoleManagementPolicyExpirationRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "enabledRules": ["Justification", "MultiFactorAuthentication"],
                        "id": "Enablement_Admin_Assignment",
                        "ruleType": "RoleManagementPolicyEnablementRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Notification_Admin_Admin_Assignment",
                        "isDefaultRecipientsEnabled": False,
                        "notificationLevel": "Critical",
                        "notificationRecipients": ["admin_admin_member@test.com"],
                        "notificationType": "Email",
                        "recipientType": "Admin",
                        "ruleType": "RoleManagementPolicyNotificationRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Notification_Requestor_Admin_Assignment",
                        "isDefaultRecipientsEnabled": False,
                        "notificationLevel": "Critical",
                        "notificationRecipients": ["requestor_admin_member@test.com"],
                        "notificationType": "Email",
                        "recipientType": "Requestor",
                        "ruleType": "RoleManagementPolicyNotificationRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Notification_Approver_Admin_Assignment",
                        "isDefaultRecipientsEnabled": False,
                        "notificationLevel": "Critical",
                        "notificationRecipients": ["approver_admin_member@test.com"],
                        "notificationType": "Email",
                        "recipientType": "Approver",
                        "ruleType": "RoleManagementPolicyNotificationRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "exceptionMembers": None,
                        "id": "Expiration_EndUser_Assignment",
                        "isExpirationRequired": True,
                        "maximumDuration": "PT7H",
                        "ruleType": "RoleManagementPolicyExpirationRule",
                        "target": {
                            "caller": "EndUser",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "enabledRules": ["Justification", "MultiFactorAuthentication", "Ticketing"],
                        "id": "Enablement_EndUser_Assignment",
                        "ruleType": "RoleManagementPolicyEnablementRule",
                        "target": {
                            "caller": "EndUser",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Approval_EndUser_Assignment",
                        "ruleType": "RoleManagementPolicyApprovalRule",
                        "setting": {
                            "approvalMode": "SingleStage",
                            "approvalStages": [
                                {
                                    "approvalStageTimeOutInDays": 1,
                                    "escalationApprovers": None,
                                    "escalationTimeInMinutes": 0,
                                    "isApproverJustificationRequired": True,
                                    "isEscalationEnabled": False,
                                    "primaryApprovers": [
                                        {
                                            "description": "amansw_new_group",
                                            "id": "2385b0f3-5fa9-43cf-8ca4-b01dc97298cd",
                                            "isBackup": False,
                                            "userType": "Group",
                                        },
                                        {
                                            "description": "amansw_group",
                                            "id": "2f4913c9-d15b-406a-9946-1d66a28f2690",
                                            "isBackup": False,
                                            "userType": "Group",
                                        },
                                    ],
                                }
                            ],
                            "isApprovalRequired": True,
                            "isApprovalRequiredForExtension": False,
                            "isRequestorJustificationRequired": True,
                        },
                        "target": {
                            "caller": "EndUser",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "claimValue": "",
                        "id": "AuthenticationContext_EndUser_Assignment",
                        "isEnabled": False,
                        "ruleType": "RoleManagementPolicyAuthenticationContextRule",
                        "target": {
                            "caller": "EndUser",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Notification_Admin_EndUser_Assignment",
                        "isDefaultRecipientsEnabled": False,
                        "notificationLevel": "Critical",
                        "notificationRecipients": ["admin_enduser_member@test.com"],
                        "notificationType": "Email",
                        "recipientType": "Admin",
                        "ruleType": "RoleManagementPolicyNotificationRule",
                        "target": {
                            "caller": "EndUser",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Notification_Requestor_EndUser_Assignment",
                        "isDefaultRecipientsEnabled": False,
                        "notificationLevel": "Critical",
                        "notificationRecipients": ["requestor_enduser_member@test.com"],
                        "notificationType": "Email",
                        "recipientType": "Requestor",
                        "ruleType": "RoleManagementPolicyNotificationRule",
                        "target": {
                            "caller": "EndUser",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "Notification_Approver_EndUser_Assignment",
                        "isDefaultRecipientsEnabled": True,
                        "notificationLevel": "Critical",
                        "notificationRecipients": None,
                        "notificationType": "Email",
                        "recipientType": "Approver",
                        "ruleType": "RoleManagementPolicyNotificationRule",
                        "target": {
                            "caller": "EndUser",
                            "enforcedSettings": None,
                            "inheritableSettings": None,
                            "level": "Assignment",
                            "operations": ["All"],
                            "targetObjects": None,
                        },
                    },
                    {
                        "id": "PIMOnlyMode_Admin_Assignment",
                        "pimOnlyModeSettings": {
                            "excludedAssignmentTypes": ["ServicePrincipalsAsTarget"],
                            "excludes": [
                                {"id": "ec42a424-a0c0-4418-8788-d19bdeb03704", "type": "User"},
                                {"id": "00029dfb-0218-4e7a-9a85-c15dc0c880bc", "type": "Group"},
                                {"id": "0000103d-1fc2-4ac8-81de-71517765655c", "type": "ServicePrincipal"},
                            ],
                            "mode": "Enabled",
                        },
                        "ruleType": "RoleManagementPolicyPimOnlyModeRule",
                        "target": {
                            "caller": "Admin",
                            "enforcedSettings": ["all"],
                            "inheritableSettings": ["all"],
                            "level": "Assignment",
                            "operations": ["all"],
                            "targetObjects": [],
                        },
                    },
                ]
            }
        },
    )
    print(response)


# x-ms-original-file: specification/authorization/resource-manager/Microsoft.Authorization/preview/2024-09-01-preview/examples/PatchRoleManagementPolicy.json
if __name__ == "__main__":
    main()
