# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.servicefabricmanagedclusters import ServiceFabricManagedClustersManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-servicefabricmanagedclusters
# USAGE
    python application_action_restart_deployed_code_package_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ServiceFabricManagedClustersManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    client.applications.begin_restart_deployed_code_package(
        resource_group_name="resRg",
        cluster_name="myCluster",
        application_name="myApp",
        parameters={
            "codePackageInstanceId": "133991326715515522",
            "codePackageName": "Code",
            "nodeName": "nt1_0",
            "serviceManifestName": "TestPkg",
            "servicePackageActivationId": "sharedProcess",
        },
    ).result()


# x-ms-original-file: 2025-10-01-preview/ApplicationActionRestartDeployedCodePackage_example.json
if __name__ == "__main__":
    main()
