% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_set.R
\name{font_set_auto}
\alias{font_set_auto}
\title{Automatic font set}
\usage{
font_set_auto()
}
\value{
An object of class \code{font_set}.
}
\description{
Build a \code{\link[=font_set]{font_set()}} by detecting the best available
system fonts for each role (sans, serif, mono, symbol).

For each role a list of well-known fonts is tried in order.
When none is found on the system, the corresponding Liberation
font is used as a guaranteed offline fallback.\tabular{lll}{
   Role \tab Candidates (in order) \tab Fallback \cr
   sans \tab Arial, Helvetica, DejaVu Sans \tab Liberation Sans \cr
   serif \tab Times New Roman, Times, DejaVu Serif \tab Liberation Serif \cr
   mono \tab Courier New, Courier, DejaVu Sans Mono \tab Liberation Mono \cr
   symbol \tab Symbol, Apple Symbols \tab Liberation Sans \cr
}
}
\examples{
fonts <- font_set_auto()
fonts
}
\seealso{
\code{\link[=font_set]{font_set()}}, \code{\link[=font_set_liberation]{font_set_liberation()}}

Other font set functions: 
\code{\link{font_google}()},
\code{\link{font_liberation}()},
\code{\link{font_set}()},
\code{\link{font_set_liberation}()}
}
\concept{font set functions}
