% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretePlot.R
\name{discretePlot}
\alias{discretePlot}
\title{Plot Distribution of Discrete Numeric Variable}
\usage{
discretePlot(
  x,
  by,
  scale = c("frequency", "percent"),
  xlab = deparse(substitute(x)),
  ylab = scale,
  main = "",
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{a numeric variable.}

\item{by}{optionally a factor (or character or logical variable) by which to classify \code{x}.}

\item{scale}{either \code{"frequency"} (the default) or \code{"percent"}.}

\item{xlab}{optional character string to label the horizontal axis.}

\item{ylab}{optional character string to label the vertical axis.}

\item{main}{optional main label for the plot (ignored if the \code{by} argument is specified).}

\item{xlim}{two-element numeric vectors specifying the range of the x axes; if not specified, will be determined from the data.}

\item{ylim}{two-element numeric vectors specifying the range of the y axes; if not specified, will be determined from the data; the lower limit of the y-axis should normally be 0 and a warning will be printed if it isn't.}

\item{...}{other arguments to be passed to \code{\link[graphics:plot.default]{plot}}.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
Plot Distribution of Discrete Numeric Variable
}
\details{
Plot the distribution of a discrete numeric variable, optionally classified by a factor.

If the \code{by} argument is specified, then one plot is produced for each level of \code{by}; these are arranged vertically and all use the same scale for the horizontal and vertical axes.
}
\examples{
data(mtcars)
mtcars$cyl <- factor(mtcars$cyl)
with(mtcars, discretePlot(carb))
with(mtcars, discretePlot(carb, scale="percent"))
with(mtcars, discretePlot(carb, by=cyl))

}
\seealso{
\code{\link{Hist}}, \code{\link{Dotplot}}.
}
\author{
John Fox
}
\keyword{hplot}
